<?php

/*
* @category    Controlador 2022
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/
ini_set('memory_limit', '-1'); 
header("Content-Type: text/plain; charset=UTF-8");
require("../../../core/php/_database.php");
require("../../../core/php/php_functions.php");
session_start();

$task = isset($_REQUEST['task'])?$_REQUEST['task']:null;

switch($task){
    case "VerificarDatosBasicosLoad":
        loadVerificarDatosBasicos();
        break;
    case "VerificarDatosBasicosSave":
        saveVerificarDatosBasicos();
        break;
    case "VerificarEspecialidadProfesional":
        verificarEspecialidadProfesional();
        break;
    case "ValidaAtencionRuta":
        validaAtencionRuta();
        break;
    
    
    
    case "UltimaAtencionAgudezaVisual":
        ultimaAtencion("res202_agudezavisual_load");
        break;
    case "UltimaAtencionRecienNacido":
        ultimaAtencion("res202_reciennacido_load");
        break;
    default: 
        break;
}

function validaAtencionRuta(){
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $pRuta = isset($_REQUEST['pRuta'])?$_REQUEST['pRuta']:null;
    $pTipoAtencion = isset($_REQUEST['pTipoAtencion'])?$_REQUEST['pTipoAtencion']:null;
    $pRango = isset($_REQUEST['pRango'])?$_REQUEST['pRango']:null;
        
    $qry = 'CALL sp_rias_get_atencion(\'' . $pPaciente . '\',"' . $pRuta . '","' . $pTipoAtencion . '","' . $pRango . '")';
    //echo $qry;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    while ($row[] = @mysqli_fetch_assoc($gBaseDatos->QryID));
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $pRegistros = count($row);
    $res = '[';
    $data = '';
    for($i=0;$i<$pRegistros;$i++){
        $Paciente = $row[$i]["Paciente"];
        if($Paciente <> "" || $Paciente <> null){
            $data .= '{"Paciente": "' . $Paciente . '", "Ruta": "' . $row[$i]["Ruta"] . '", "TipoAtencion": "' . $row[$i]["TipoAtencion"] . '", "Fecha": "' . $row[$i]["Fecha"] . '", "RangoEdad": "' . $row[$i]["RangoEdad"] . '"}, ';
        }
    }
    $res .= rtrim($data,", ");
    $res .= ']';
    echo $res;
}

function loadVerificarDatosBasicos(){
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $qry = "CALL sp_2022_load_datosbasicos('" . $pPaciente . "')";
    //echo $qry;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $resY = str_replace("<BR \/><br \/>","",PonerAcentosHTML($gBaseDatos->jsonSP($qry,"D")));
    $res = str_replace("<br \/>","",$resY);
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $res1 = str_replace("[", "", $res);
    $res = str_replace("]", "", $res1);
    echo $res;
}

function verificarEspecialidadProfesional(){
    $pProfesional = isset($_REQUEST['pProfesional'])?$_REQUEST['pProfesional']:0;
    $qry = "CALL sp_2022_load_especialidadxprofe('" . $pProfesional . "')";
    //echo $qry;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $resY = str_replace("<BR \/><br \/>","",PonerAcentosHTML($gBaseDatos->jsonSP($qry,"D")));
    $res = str_replace("<br \/>","",$resY);
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $res1 = str_replace("[", "", $res);
    $res = str_replace("]", "", $res1);
    echo $res;
}

function saveVerificarDatosBasicos(){
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:null;
    $pGenero = isset($_REQUEST['pGenero'])?$_REQUEST['pGenero']:null;
    $pFecNac = isset($_REQUEST['pFecNac'])?$_REQUEST['pFecNac']:null;
    $pEdad = isset($_REQUEST['pEdad'])?$_REQUEST['pEdad']:null;
    $pPais = isset($_REQUEST['pPais'])?$_REQUEST['pPais']:null;
    $pEtnia = isset($_REQUEST['pEtnia'])?$_REQUEST['pEtnia']:null;
    $pEscolaridad = isset($_REQUEST['pEscolaridad'])?$_REQUEST['pEscolaridad']:null;
    $pOcupacion = isset($_REQUEST['pOcupacion'])?$_REQUEST['pOcupacion']:null;
    $pDireccion = isset($_REQUEST['pDireccion'])?$_REQUEST['pDireccion']:null;
    $pTelefono = isset($_REQUEST['pTelefono'])?$_REQUEST['pTelefono']:null;
    $pEmail = isset($_REQUEST['pEmail'])?$_REQUEST['pEmail']:null;
    $pUsuario = $_SESSION['ID_USUARIO'];

    $qry = 'CALL sp_2022_save_datosbasicos(\'' . $pPaciente . '\',"' . $pGenero . '","' . $pFecNac . '","' . $pEdad . '","' . $pPais . '","' . $pEtnia . '","' . $pEscolaridad . '","' . $pOcupacion . '","' . $pDireccion . '","' . $pTelefono . '","' . $pEmail . '",\'' . $pUsuario . '\')';
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry)){
       echo "{success: true, requestedId:'1'}";
    }else{
       echo "{success: true, requestedId:'0'}";
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
}

function ultimaAtencion($sp){
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $qry = "CALL sp_" . $sp . "('" . $pPaciente . "')";
    //echo $qry;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    while ($row[] = @mysqli_fetch_assoc($gBaseDatos->QryID));
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $pRegistros = count($row);
    $res = '[';
    $data = '';
    for($i=0;$i<$pRegistros;$i++){
        $variable = $row[$i]["Variable"];
        if($variable <> "" || $variable <> null){
            $data .= '{"Variable": "' . $variable . '", "Valor": "' . $row[$i]["Valor"] . '", "Fecha": "' . $row[$i]["Fecha"] . '", "Dias": "' . $row[$i]["DiasUltimaAtencion"] . '", "Fecha1": "' . $row[$i]["Fecha1"] . '", "Dias1": "' . $row[$i]["DiasUltimaAtencion1"] . '"}, ';
        }
    }
    $res .= rtrim($data,", ");
    $res .= ']';
    echo $res;
}