<?php

/*
* @category    Controlador Asignacion de Citas
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/
//set_time_limit(500);
require("../../../core/php/_database.php");
require("../../../core/php/php_functions.php");
session_start();
$task = '';
if ( isset($_POST['task'])){
  $task = $_POST['task'];
}
switch($task){
    case "LISTAR_PROFESIONALES_AGENDA":
        Listar_ProfesionalesAgenda();
        break;
    case "LISTAR_CONSULTORIOSxPROFE_AGENDA":
        Listar_ConsultoriosxProfe();
        break;
    case "LISTAR_AGENDAS_DISPONIBLES":
        Listar_AgendasDispxProfexConsultorio();
        break;
    case "LISTAR_AGENDAS_BLOQUEADAS":
        Listar_AgendasBloqueadasxProfexConsultorio();
        break;
    case "LISTAR_HORARIOS_AGENDAS_DISPONIBLES":
        Listar_HorariosDispxAgendas();
        break;
    case "LISTAR_HORARIOS_AGENDAS_DISPONIBLES_CRI":
        Listar_HorariosDispxAgendasCRI();
        break;
    case "LISTAR_HORARIOS_AGENDAS_DISPONIBLES_SESIONES":
        Listar_HorariosDispxAgendasSesiones();
        break;
    case "LISTAR_HORARIOS_AGENDAS_DISPONIBLES_SESIONES_CRI":
        Listar_HorariosDispxAgendasSesionesCRI();
        break;
    case "AGENDAS_DESBLOQUEAR":
        DesbloquearAgendas();
        break;
    //case "ASIGNAR_CITAS_SESIONES":
    case "ASIGNAR_CITAS_SESIONESzx":
        AsignarCitasSesiones();
        break;
    case "LISTAR_CITASxLEGALIZAR":
        Listar_CitasxLegalizar();
        break;
    case "LISTAR_CITASxLEGALIZARMANUAL":
        Listar_CitasManualxLegalizar();
        break;
    case "LISTAR_CITASxEVOLUCIONAR":
        Listar_CitasxEvolucionar();
        break;
    case "LISTAR_CITASxEVOLUCIONARODO":
        Listar_CitasxEvolucionarOdo();
        break;
    case "LISTAR_CITASxEVOLUCIONAR001":
        Listar_CitasxEvolucionar001();
        break;
    case "LISTAR_CITASxEVOLUCIONAR002":
        Listar_CitasxEvolucionar002();
        break;
    case "LISTAR_CITASxEVOLUCIONAR004":
        Listar_CitasxEvolucionar004();
        break;
    case "LISTAR_CITASxEVOLUCIONAR_URG":
        Listar_CitasxEvolucionarUrgencias();
        break;
    case "LISTAR_CITASxEVOLUCIONARxPACIENTE":
        Listar_CitasxEvolucionarxPaciente();
        break;
    case "LISTAR_CITASxEVOLUCIONAR_UAM":
        Listar_CitasxEvolucionarUAM();
        break;
    case "LISTAR_CITASxEVOLUCIONAR_UAM001":
        Listar_CitasxEvolucionarUAMEST();
        break;
    case "LISTAR_CITASxEVOLUCIONAR_UAM000":
        Listar_CitasxEvolucionarUAM00();
        break;
    case "HISTORIAL_CITAS_ASIGNADAS":
        Historial_CitasAsignadas();
        break;
    case "HISTORIAL_CITAS_ASIGNADAS_MANUAL":
        Historial_CitasAsignadasManual();
        break;
    case "HISTORIAL_CITAS_CANCELADAS":
        Historial_CitasX("c");
        break;
    case "HISTORIAL_CITAS_CANCELADAS_MANUAL":
        Historial_CitasManualX("C");
        break;
    case "HISTORIAL_CITAS_INASISTENCIA":
        Historial_CitasX("i");
        break;
    case "HISTORIAL_CITAS_INASISTENCIA_MANUAL":
        Historial_CitasManualX("I");
        break;
    case "HISTORIAL_CITAS_LEGALIZADAS":
        Historial_Legalizaciones();
        break;
    case "HISTORIAL_CITAS_LEGALIZADAS_MANUAL":
        Historial_LegalizacionesManual();
        break;
    case "CANECELAR_CITAS":
        Cancelar_Citas();
        break;
    case "INASISTENCIA_CITAS":
        Inasistencia_Citas();
        break;
    case "DESBLOQUEAR_CITAS":
        DesbloquearAgendas();
        break;
    case "BLOQUEAR_CITAS":
        BloquearAgendas();
        break;
    case "ASIGNAR_CITAS":
        AsignarCitas();
        break;
    case "NO_ASIGNAR_CITAS":
        NoAsignarCitas();
        break;
    case "VER_HORARIOSDISP_ALUMA":
        verHorariosDispxAgendasAluma();
        break;
    case "VER_HORARIOSDISP_MANUAL2015":
        verHorariosDispxAgendasManual2015();
        break;
    default:
        echo "{failure:true}";
        break;
}

function Listar_CitasxEvolucionar004(){
    $pAgenda = isset($_REQUEST['pAgenda'])?$_REQUEST['pAgenda']:0;
    $pNomBaseDatos = isset($_REQUEST['pNomBaseDatos'])?$_REQUEST['pNomBaseDatos']:"NA";
    if($pNomBaseDatos == "NA"){
        $gBaseDatos = new ofiMySQLi();
    }else{
        $gBaseDatos = new ofiMySQLi($pNomBaseDatos);
    }
    $gBaseDatos->conectar();
    $qry = "CALL sp_grid_agendas_citasxevolucionar004('" . $pAgenda . "')";
    //echo $qry;
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
    {
        $nRow = $row;
        foreach($row as $key => $val)
        {
            $nRow[$key] = PonerAcentosHTML($val);
        }
        $arr[] = $nRow;
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $jsonresult = JEncode($arr);
    if (!is_null($jsonresult))
        echo '({"total":"0","results":'. $jsonresult .'})';    
}

function verHorariosDispxAgendasManual2015(){
    $pProfesional = isset($_REQUEST['pProfesional'])?$_REQUEST['pProfesional']:0;
    $pFecha = isset($_REQUEST['pFecha'])?$_REQUEST['pFecha']:null;
    $pCodBloqueo = isset($_REQUEST['pCodBloqueo'])?$_REQUEST['pCodBloqueo']:"-1";
    $pUsuario = isset($_REQUEST['pUsuario'])?$_REQUEST['pUsuario']:0;
    $pNroHoras = isset($_REQUEST['pNroHoras'])?$_REQUEST['pNroHoras']:1;
    $pNomBaseDatos = isset($_REQUEST['pNomBaseDatos'])?$_REQUEST['pNomBaseDatos']:"NA";
    if($pNomBaseDatos == "NA"){
        $gBaseDatos = new ofiMySQLi();
    }else{
        $gBaseDatos = new ofiMySQLi($pNomBaseDatos);
    }
    $gBaseDatos->conectar();
    $qry = "CALL sp_asignarcitasmanual2015_horariosdisp_grid('" . $pProfesional . "',\"" . $pFecha . "\")";
    //echo $qry;
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
    {
        $nRow = $row;
        foreach($row as $key => $val)
        {
            $nRow[$key] = PonerAcentosHTML($val);
        }
        $arr[] = $nRow;
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $pRegistros = count($arr);
    $Grupo = 0;
    $descHoraFin = "";
    for($i=0;$i<$pRegistros;$i++){
        $Grupo ++;
        $descHoraFin = "";
        $inthoraAct = 0;
        $inthoraSig = 0;
        if(($i+($pNroHoras-1))<$pRegistros){
            if($arr[$i]["GrupoCita"]==0){
                if($pNroHoras == 1){
                    if($arr[($i+1)]["citaDescripcion"] !== "" && $arr[($i+1)]["citaDescripcion"] !== null){
                        $arr[$i]["GrupoCita"] = $Grupo;
                        $arr[$i]["MostrarGrupoCita"] = 1;
                        $arr[$i]["citaDescripcion"] = $arr[$i]["citaDescripcion"];// . " - " . $arr[($i+1)]["citaDescripcion"];
                    }
                }else{
                    for($j=1;$j<=$pNroHoras;$j++){
                        if($j==1){
                            $horaAct = $arr[$i]["HoraFinal"];
                            $horaSig = $arr[$i]["HoraCitaInicio"];
                            $inthoraAct = $arr[$i]["intHoraCitaInicio"];
                        }else{
                            $horaAct = $horaSig;
                            $inthoraAct = $arr[$i]["intHoraCitaInicio"];
                            $horaSig = $arr[$i]["HoraCitaInicio"];
                        }
                        if($horaAct == $horaSig){
                            $arr[$i]["GrupoCita"] = $Grupo;
                            $arr[$i]["MostrarGrupoCita"] = 1;
                            for($k=1;$k<$pNroHoras;$k++){
                                $arr[$i+$k]["GrupoCita"] = $Grupo;
                                $descHoraFin = $arr[($i+1)+$k]["citaDescripcion"];
                                $inthoraSig = $arr[$i+$k]["intHoraCitaInicio"];
                                $horaSig = $arr[$i+$k]["HoraCitaFin"];
                            }
                            $arr[$i]["citaDescripcion"] = $arr[$i]["citaDescripcion"];// . " - " . $descHoraFin;
                            $arr[$i]["HoraCitaInicio"] = $horaAct;
                            $arr[$i]["HoraCitaFin"] = $horaSig;
                            $arr[$i]["intHoraCitaInicio"] = $inthoraAct;
                            $arr[$i]["intHoraCitaFin"] = $inthoraSig;
                        }
                    }
                }
            }
        }
    }
    $jsonresult = JEncode($arr);
    if (!is_null($jsonresult))
        echo '({"total":"0","results":'. $jsonresult .'})';
}
               

function verHorariosDispxAgendasAluma(){
    $pProfesional = isset($_REQUEST['pProfesional'])?$_REQUEST['pProfesional']:0;
    $pFecha = isset($_REQUEST['pFecha'])?$_REQUEST['pFecha']:null;
    $pCodBloqueo = isset($_REQUEST['pCodBloqueo'])?$_REQUEST['pCodBloqueo']:"-1";
    $pUsuario = isset($_REQUEST['pUsuario'])?$_REQUEST['pUsuario']:0;
    $pNroHoras = isset($_REQUEST['pNroHoras'])?$_REQUEST['pNroHoras']:1;
    $pNomBaseDatos = isset($_REQUEST['pNomBaseDatos'])?$_REQUEST['pNomBaseDatos']:"NA";
    if($pNomBaseDatos == "NA"){
        $gBaseDatos = new ofiMySQLi();
    }else{
        $gBaseDatos = new ofiMySQLi($pNomBaseDatos);
    }
    $gBaseDatos->conectar();
    $qry = "CALL sp_asignarcitasaluma_horariosdisp_grid('" . $pProfesional . "',\"" . $pFecha . "\")";
    //echo $qry;
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
    {
        $nRow = $row;
        foreach($row as $key => $val)
        {
            $nRow[$key] = PonerAcentosHTML($val);
        }
        $arr[] = $nRow;
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $pRegistros = count($arr);
    $Grupo = 0;
    $descHoraFin = "";
    for($i=0;$i<$pRegistros;$i++){
        $Grupo ++;
        $descHoraFin = "";
        $inthoraAct = 0;
        $inthoraSig = 0;
        if(($i+($pNroHoras-1))<$pRegistros){
            if($arr[$i]["GrupoCita"]==0){
                if($pNroHoras == 1){
                    if($arr[($i+1)]["citaDescripcion"] !== "" && $arr[($i+1)]["citaDescripcion"] !== null){
                        $arr[$i]["GrupoCita"] = $Grupo;
                        $arr[$i]["MostrarGrupoCita"] = 1;
                        $arr[$i]["citaDescripcion"] = $arr[$i]["citaDescripcion"];// . " - " . $arr[($i+1)]["citaDescripcion"];
                    }
                }else{
                    for($j=1;$j<=$pNroHoras;$j++){
                        if($j==1){
                            $horaAct = $arr[$i]["HoraFinal"];
                            $horaSig = $arr[$i]["HoraCitaInicio"];
                            $inthoraAct = $arr[$i]["intHoraCitaInicio"];
                        }else{
                            $horaAct = $horaSig;
                            $inthoraAct = $arr[$i]["intHoraCitaInicio"];
                            $horaSig = $arr[$i]["HoraCitaInicio"];
                        }
                        if($horaAct == $horaSig){
                            $arr[$i]["GrupoCita"] = $Grupo;
                            $arr[$i]["MostrarGrupoCita"] = 1;
                            for($k=1;$k<$pNroHoras;$k++){
                                $arr[$i+$k]["GrupoCita"] = $Grupo;
                                $descHoraFin = $arr[($i+1)+$k]["citaDescripcion"];
                                $inthoraSig = $arr[$i+$k]["intHoraCitaInicio"];
                                $horaSig = $arr[$i+$k]["HoraCitaFin"];
                            }
                            $arr[$i]["citaDescripcion"] = $arr[$i]["citaDescripcion"];// . " - " . $descHoraFin;
                            $arr[$i]["HoraCitaInicio"] = $horaAct;
                            $arr[$i]["HoraCitaFin"] = $horaSig;
                            $arr[$i]["intHoraCitaInicio"] = $inthoraAct;
                            $arr[$i]["intHoraCitaFin"] = $inthoraSig;
                        }
                    }
                }
            }
        }
    }
    $jsonresult = JEncode($arr);
    if (!is_null($jsonresult))
        echo '({"total":"0","results":'. $jsonresult .'})';
}
               
function NoAsignarCitas(){
    $pConsecutivoDetalle = isset($_REQUEST['pConsecutivoDetalle'])?$_REQUEST['pConsecutivoDetalle']:0;
    $pMotivoNoCita = isset($_REQUEST['pMotivoNoCita'])?$_REQUEST['pMotivoNoCita']:null;
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_asignarcitas_noproxima('" . $pConsecutivoDetalle . "',\"" . $pMotivoNoCita . "\")";
    //echo $qry;
    $CampoLlave = explode("^",$gBaseDatos->jasonSP_arreglo2011($qry));
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    if($CampoLlave[0] > 0){
        echo "1";
    }else{
        echo "0";
    }
}

function Listar_HorariosDispxAgendasSesionesCRI(){
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pProfesional = isset($_REQUEST['pProfesional'])?$_REQUEST['pProfesional']:0;
    $pCodBloqueo = isset($_REQUEST['pCodBloqueo'])?$_REQUEST['pCodBloqueo']:"-1";
    $pNomBaseDatos = isset($_REQUEST['pNomBaseDatos'])?$_REQUEST['pNomBaseDatos']:"NA";
    if($pNomBaseDatos == "NA"){
        $gBaseDatos = new ofiMySQLi();
    }else{
        $gBaseDatos = new ofiMySQLi($pNomBaseDatos);
    }
    $gBaseDatos->conectar();
    $qry = "CALL sp_asignarcitas_horariosdisp_sesiones_cri_grid('" . $pIPS . "','" . $pProfesional . "',\"" . $pCodBloqueo . "\")";
    //echo $qry;
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
    {
        $nRow = $row;
        foreach($row as $key => $val)
        {
            $nRow[$key] = PonerAcentosHTML($val);
        }
        $arr[] = $nRow;
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $jsonresult = JEncode($arr);
    if (!is_null($jsonresult))
        echo '({"total":"0","results":'. $jsonresult .'})';
}

function Listar_HorariosDispxAgendasCRI(){
    $pAgenda = isset($_REQUEST['pAgenda'])?$_REQUEST['pAgenda']:0;
    $pCodBloqueo = isset($_REQUEST['pCodBloqueo'])?$_REQUEST['pCodBloqueo']:"-1";
    $pUsuario = isset($_REQUEST['pUsuario'])?$_REQUEST['pUsuario']:0;
    $pNroHoras = isset($_REQUEST['pNroHoras'])?$_REQUEST['pNroHoras']:1;
    $pNomBaseDatos = isset($_REQUEST['pNomBaseDatos'])?$_REQUEST['pNomBaseDatos']:"NA";
    if($pNomBaseDatos == "NA"){
        $gBaseDatos = new ofiMySQLi();
    }else{
        $gBaseDatos = new ofiMySQLi($pNomBaseDatos);
    }
    $gBaseDatos->conectar();
    $qry = "CALL sp_asignarcitas_horariosdisp_cri_grid('" . $pAgenda . "',\"" . $pCodBloqueo . "\",'" . $pUsuario . "')";
    //echo $qry;
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
    {
        $nRow = $row;
        foreach($row as $key => $val)
        {
            $nRow[$key] = PonerAcentosHTML($val);
        }
        $arr[] = $nRow;
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $pRegistros = count($arr);
    $Grupo = 0;
    $descHoraFin = "";
    for($i=0;$i<$pRegistros;$i++)
    {
        $Grupo ++;
        $descHoraFin = "";
        if(($i+($pNroHoras-1))<$pRegistros){
            if($arr[$i]["GrupoCita"]==0){
                if($pNroHoras == 1){
                    $arr[$i]["GrupoCita"] = $Grupo;
                    $arr[$i]["MostrarGrupoCita"] = 1;
                }else{
                    for($j=1;$j<=$pNroHoras;$j++){
                        if($j==1){
                            $horaAct = substr($arr[$i]["IdCita"],-5);
                            $horaSig = substr($arr[$i+$j]["IdCita"],0,5);
                        }else{
                            $horaAct = $horaSig;
                            $horaSig = substr($arr[$i+$j]["IdCita"],0,5);
                        }
                        if($horaAct == $horaSig){
                            $arr[$i]["GrupoCita"] = $Grupo;
                            $arr[$i]["MostrarGrupoCita"] = 1;
                            for($k=1;$k<$pNroHoras;$k++){
                                $arr[$i+$k]["GrupoCita"] = $Grupo;
                                $descHoraFin = substr($arr[$i+$k]["citaDescripcion"],-8);
                            }
                            $arr[$i]["citaDescripcion"] = substr($arr[$i]["citaDescripcion"],0,8) . $descHoraFin;
                        }
                    }
                }
            }
        }
    }
    $jsonresult = JEncode($arr);
    if (!is_null($jsonresult))
        echo '({"total":"0","results":'. $jsonresult .'})';
}
function AsignarCitasSesiones(){
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pSede = isset($_REQUEST['pSede'])?$_REQUEST['pSede']:0;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pConsultorio = isset($_REQUEST['pConsultorio'])?$_REQUEST['pConsultorio']:0;
    $pUsuario = isset($_REQUEST['pUsuario'])?$_REQUEST['pUsuario']:0;
    $pFechaCita = isset($_REQUEST['pFechaCita'])?$_REQUEST['pFechaCita']:"1980-01-01";
    $pTipoAfiliacion = isset($_REQUEST['pTipoAfiliacion'])?$_REQUEST['pTipoAfiliacion']:null;
    $pTipoAfiliado  = isset($_REQUEST['pTipoAfiliado'])?$_REQUEST['pTipoAfiliado']:null;
    if ($pTipoAfiliado == "")
        $pTipoAfiliado = null;
    $pParentesco = isset($_REQUEST['pParentesco'])?$_REQUEST['pParentesco']:null;
    if ($pParentesco == "")
        $pParentesco = null;
    $pRangoSalarial = isset($_REQUEST['pRangoSalarial'])?$_REQUEST['pRangoSalarial']:null;
    $pEstadoListado = isset($_REQUEST['pEstadoListado'])?$_REQUEST['pEstadoListado']:null;
    $pEdadPaciente = isset($_REQUEST['pEdadPaciente'])?$_REQUEST['pEdadPaciente']:null;
    if ($pEdadPaciente == "")
        $pEdadPaciente = null;
    $pDeptoMuniciPaciente = isset($_REQUEST['pDeptoMuniciPaciente'])?$_REQUEST['pDeptoMuniciPaciente']:null;
    if ($pDeptoMuniciPaciente == "")
        $pDeptoMuniciPaciente = null;
    $pPrograma = isset($_REQUEST['pPrograma'])?$_REQUEST['pPrograma']:null;
    $pFinalidad = isset($_REQUEST['pFinalidad'])?$_REQUEST['pFinalidad']:null;
    if ($pFinalidad == "")
        $pFinalidad = null;
    $pFacturarParticular = isset($_REQUEST['pFacturarParticular'])?$_REQUEST['pFacturarParticular']:0;
    $pFacturarCopagos = isset($_REQUEST['pFacturarCopagos'])?$_REQUEST['pFacturarCopagos']:0;
    $pCopagoDigitado = isset($_REQUEST['pCopagoDigitado'])?$_REQUEST['pCopagoDigitado']:0;
    $pPorCopagos = isset($_REQUEST['pPorCopagos'])?$_REQUEST['pPorCopagos']:0;
    $pMaxCopago = isset($_REQUEST['pMaxCopago'])?$_REQUEST['pMaxCopago']:0;
    $pvlrCuotaModeradoraIndicada = isset($_REQUEST['pvlrCuotaModeradoraIndicada'])?$_REQUEST['pvlrCuotaModeradoraIndicada']:0;
    $pExento = isset($_REQUEST['pExento'])?$_REQUEST['pExento']:null;
    $pTutela = isset($_REQUEST['pTutela'])?$_REQUEST['pTutela']:null;
    $pCodCliente = isset($_REQUEST['pCodCliente'])?$_REQUEST['pCodCliente']:0;
    $pDesCliente = isset($_REQUEST['pDesCliente'])?$_REQUEST['pDesCliente']:null;
    if ($pDesCliente == "")
        $pDesCliente = null;
    $pCodPlan = isset($_REQUEST['pCodPlan'])?$_REQUEST['pCodPlan']:0;
    $pDesPlan = isset($_REQUEST['pDesPlan'])?$_REQUEST['pDesPlan']:null;
    if ($pDesPlan == "")
        $pDesPlan = null;
    $pCodSubPlan = isset($_REQUEST['pCodSubPlan'])?$_REQUEST['pCodSubPlan']:0;
    $pDesSubPlan = isset($_REQUEST['pDesSubPlan'])?$_REQUEST['pDesSubPlan']:null;
    if ($pDesSubPlan == "")
        $pDesSubPlan = null;
    $pContrato = isset($_REQUEST['pContrato'])?$_REQUEST['pContrato']:0;
    $pIdProced = isset($_REQUEST['pIdProced'])?$_REQUEST['pIdProced']:0;
    $pCodProced = isset($_REQUEST['pCodProced'])?$_REQUEST['pCodProced']:null;
    if ($pCodProced == "")
        $pCodProced = null;
    $pDesProced = isset($_REQUEST['pDesProced'])?$_REQUEST['pDesProced']:null;
    if ($pDesProced == "")
        $pDesProced = null;
    $pTarifaProced = isset($_REQUEST['pTarifaProced'])?$_REQUEST['pTarifaProced']:0;
    $pObservaciones = isset($_REQUEST['pObservaciones'])?$_REQUEST['pObservaciones']:null;
    if ($pObservaciones == "")
        $pObservaciones = null;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $pUsuarioAsigna = isset($_REQUEST['pUsuarioAsigna'])?$_REQUEST['pUsuarioAsigna']:0;
    $pSolicitudUsuario = isset($_REQUEST['pSolicitudUsuario'])?$_REQUEST['pSolicitudUsuario']:"0";
    $pProfeSol = isset($_REQUEST['pProfeSol'])?$_REQUEST['pProfeSol']:0;
    $pProfesionalCita = isset($_REQUEST['pProfesionalCita'])?$_REQUEST['pProfesionalCita']:0;
    $pMarcaExento = isset($_REQUEST['pMarcaExento'])?$_REQUEST['pMarcaExento']:"0";
    //if ($pMarcaExento == "t")
    //    $pMarcaExento = "1";
    //else
    //    $pMarcaExento = "0";
    $pAutorizacion = isset($_REQUEST['pAutorizacion'])?$_REQUEST['pAutorizacion']:null;
    if ($pAutorizacion == "")
        $pAutorizacion = null;
    $pFechaSol = isset($_REQUEST['pFechaSol'])?$_REQUEST['pFechaSol']:null;
    $pCitas = explode("¬", isset($_REQUEST['pInfoCita'])?$_REQUEST['pInfoCita']:"");
    $pItems = count($pCitas)-1;
    $pNomBaseDatos = isset($_REQUEST['pNomBaseDatos'])?$_REQUEST['pNomBaseDatos']:"NA";
    if($pItems > 0){
        for ($i=0; $i<$pItems; $i++){
            //558^1^2011-08-01^12257^obs 1^984
            //echo $pCitas[$i];
            $pIdCita = explode("^", $pCitas[$i]);
            $anio = substr($pIdCita[2], 0, 4);
            $mes = substr($pIdCita[2], 5, 2);
            $dia = substr($pIdCita[2], 8, 2);
            $fecCita = mktime(0,0,0,$mes,$dia,$anio);
            $diaSemanaCita = date("D",$pIdCita[2]);
            $horaCita = date("H",$pIdCita[2]);
            $OportunidadCita = OportunidadAsignacionCitas($pIdCita[2]);
            if ($OportunidadCita < 0)
                $OportunidadCita = 0;
            if($pNomBaseDatos == "NA"){
                $gBaseDatos = new ofiMySQLi();
            }else{
                $gBaseDatos = new ofiMySQLi($pNomBaseDatos);
            }
            $gBaseDatos->conectar();
            $CodInsercion = "PRS-" .  $_SESSION['ID_EMPRESA'] . "-SED-" . $_SESSION['ID_SEDE'] .  "-IPS-" . $_SESSION['ID_IPS'] . "-USR-" . $_SESSION['ID_USUARIO'] . "-CONS-" . mt_rand(0,100000) . "-" . date("His");
            $qry = "CALL sp_asignarcitas_crear_cas(\"" . $CodInsercion . "\",'" . $pEmpresa . "','" . $pSede . "','" .$pIPS . "','" . $pIdCita[1] . "','" . $pCodCliente . "','" . $pCodPlan . "','" . $pCodSubPlan . "','" . $pContrato . "',\"" . $pIdCita[2] . "\",\"" . $pFechaSol . "\",'" . $pPaciente . "','" . $pTipoAfiliacion . "',\"" . $pTipoAfiliado . "\",\"". $pParentesco . "\",'" . $pRangoSalarial . "','" . $pEstadoListado . "',\"" . $pEdadPaciente . "\",\"" .  $pDeptoMuniciPaciente . "\",'" . $pPrograma . "',\"" . $pFinalidad . "\",'" . $pFacturarParticular . "','" . $pExento . "','" . $pTutela . "','" . $pUsuario . "','" . $pProfeSol . "',\"" . $pAutorizacion . "\",'" . $pProfesionalCita . "','" . $pUsuarioAsigna . "',\"" . $pSolicitudUsuario . "\",'" . $OportunidadCita . "','" . $pIdCita[5] . "','" . $pFacturarCopagos . "','" . $pCopagoDigitado . "','" . $pPorCopagos . "','" . $pvlrCuotaModeradoraIndicada . "','" . $pMaxCopago . "',\"" . $pMarcaExento . "\")";
            //echo $qry;
            $CampoLlave = explode("^",$gBaseDatos->jasonSP_arreglo2011($qry));
            $gBaseDatos->liberar();
            $gBaseDatos->cerrar();
            if($CampoLlave[0] > 0){
                $qry = "CALL sp_asignarcitas_crear_cas_detalle('" . $CampoLlave[0] . "','" . $pIdProced . "',\"" . $pCodProced . "\",\"" . $pDesProced . "\",'" . $pTarifaProced . "','" . $pUsuario . "')";
                $gBaseDatos->conectar();
                @mysqli_query($gBaseDatos->ConexionID, $qry);
                $gBaseDatos->cerrar();
                $pOportunidad = $OportunidadCita;
                $qry = "CALL sp_asignarcitas_actualizar_detalleagendas('" . $pIdCita[3] . "','" . $CampoLlave[0] . "',\"" . $pIdCita[4] . "\",'" . $pIdProced . "',\"" . $pCodProced . "\",\"" . $pDesProced . "\",'" . $pPaciente . "','" . $pCodCliente . "',\"" . $pDesCliente . "\",'" . $pCodPlan . "',\"" . $pDesPlan . "\",'" . $pCodSubPlan . "',\"" . $pDesSubPlan . "\",'" . $pContrato . "','" . $pUsuario . "','" . $pOportunidad . "',\"" . $pObservaciones . "\",\"" . $pSolicitudUsuario . "\")";
                echo $qry;
                $gBaseDatos->conectar();
                @mysqli_query($gBaseDatos->ConexionID, $qry);
                $gBaseDatos->cerrar();
                echo "1";
            }else{
                echo "0";
            }
        }
    }else{
        echo "0";
    }
}
function BloquearAgendas(){
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pProfesional = isset($_REQUEST['pProfesional'])?$_REQUEST['pProfesional']:0;
    $pCodBloqueo = isset($_REQUEST['pCodBloqueo'])?$_REQUEST['pCodBloqueo']:"-1";
    $pUsuario = isset($_REQUEST['pUsuario'])?$_REQUEST['pUsuario']:0;
    $pNomBaseDatos = isset($_REQUEST['pNomBaseDatos'])?$_REQUEST['pNomBaseDatos']:"NA";
    if($pNomBaseDatos == "NA"){
        $gBaseDatos = new ofiMySQLi();
    }else{
        $gBaseDatos = new ofiMySQLi($pNomBaseDatos);
    }
    $gBaseDatos->conectar();
    $qry = "CALL sp_util_bloquearagendas_codigo('" . $pIPS  . "','" . $pProfesional . "',\"" . $pCodBloqueo . "\",'" . $pUsuario . "')";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
       echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
}
function DesbloquearAgendas(){
    $pNomBaseDatos = isset($_REQUEST['pNomBaseDatos'])?$_REQUEST['pNomBaseDatos']:"NA";
    if($pNomBaseDatos == "NA"){
        $gBaseDatos = new ofiMySQLi();
    }else{
        $gBaseDatos = new ofiMySQLi($pNomBaseDatos);
    }
    $gBaseDatos->conectar();
    $pUsuario = isset($_REQUEST['pUsuario'])?$_REQUEST['pUsuario']:0;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $qry = "CALL sp_util_desbloquearagendas_codigo('" . $pUsuario  . "','" . $pIPS . "')";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
       echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
}
function Inasistencia_Citas(){
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pIPS = isset($_REQUEST['pIPS']) ? $_REQUEST['pIPS']:0;
    $pCAS = isset($_REQUEST['pCAS']) ? $_REQUEST['pCAS']:0;
    $pMotivo = isset($_REQUEST['pMotivo']) ? utf8_encode(str_replace('"', '""',$_REQUEST['pMotivo'])):null;
    $pUsuario = isset($_REQUEST['pUsuario']) ? $_REQUEST['pUsuario']:0;
    $pNomBaseDatos = isset($_REQUEST['pNomBaseDatos'])?$_REQUEST['pNomBaseDatos']:"NA";
    if($pNomBaseDatos == "NA"){
        $gBaseDatos = new ofiMySQLi();
    }else{
        $gBaseDatos = new ofiMySQLi($pNomBaseDatos);
    }
    $gBaseDatos->conectar();
    $qry = "CALL sp_asignarcitas_inasistencia('" . $pIPS . "','" . $pCAS . "',\"" . $pMotivo . "\",'" . $pUsuario . "')";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry))
        echo "{success: true, requestedId:'1'}";
    else
       echo "{success: true, requestedId:'0'}";
    $gBaseDatos->cerrar();
}
function Cancelar_Citas(){
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pIPS = isset($_REQUEST['pIPS']) ? $_REQUEST['pIPS']:0;
    $pCAS = isset($_REQUEST['pCAS']) ? $_REQUEST['pCAS']:0;
    $pMotivo = isset($_REQUEST['pMotivo']) ? utf8_encode(str_replace('"', '""',$_REQUEST['pMotivo'])):null;
    $pUsuario = isset($_REQUEST['pUsuario']) ? $_REQUEST['pUsuario']:0;
    $pNomBaseDatos = isset($_REQUEST['pNomBaseDatos'])?$_REQUEST['pNomBaseDatos']:"NA";
    if($pNomBaseDatos == "NA"){
        $gBaseDatos = new ofiMySQLi();
    }else{
        $gBaseDatos = new ofiMySQLi($pNomBaseDatos);
    }
    $gBaseDatos->conectar();
    $qry = "CALL sp_asignarcitas_cancelar('" . $pIPS . "','" . $pCAS . "',\"" . $pMotivo . "\",'" . $pUsuario . "')";
    //echo $qry;
    if(@mysqli_query($gBaseDatos->ConexionID, $qry)){
        $gBaseDatos->cerrar();
        if($pNomBaseDatos == "NA"){
            $gBaseDatos = new ofiMySQLi();
        }else{
            $gBaseDatos = new ofiMySQLi($pNomBaseDatos);
        }
        $gBaseDatos->conectar();
        $qry = "CALL sp_estudios_borrar_cas('" . $pEmpresa . "','" . $pIPS . "','" . $pCAS . "','" . $pUsuario . "',\"" . "Cita Cancelada: " . $pMotivo . "\")";
        @mysqli_query($gBaseDatos->ConexionID, $qry);
        echo "{success: true, requestedId:'1'}";
        $gBaseDatos->cerrar();
    }else{
       echo "{success: true, requestedId:'0'}";
        $gBaseDatos->cerrar();
    }
}
function Historial_Legalizaciones(){
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pIPS = isset($_REQUEST['pIPS']) ? $_REQUEST['pIPS']:0;
    $pSede = isset($_REQUEST['pSede']) ? $_REQUEST['pSede']:0;
    $pPaciente = isset($_REQUEST['pPaciente']) ? $_REQUEST['pPaciente']:0;
    $pNomBaseDatos = isset($_REQUEST['pNomBaseDatos'])?$_REQUEST['pNomBaseDatos']:"NA";
    if($pNomBaseDatos == "NA"){
        $gBaseDatos = new ofiMySQLi();
    }else{
        $gBaseDatos = new ofiMySQLi($pNomBaseDatos);
    }
    $gBaseDatos->conectar();
    $qry = "CALL sp_legalizacion_grid_citaslegalizadas('". $pEmpresa . "','" . $pSede . "','" . $pIPS . "','" . $pPaciente . "')";
    //echo $qry;
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
    {
        $nRow = $row;
        foreach($row as $key => $val)
        {
            $nRow[$key] = PonerAcentosHTML($val);
        }
        $arr[] = $nRow;
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $jsonresult = JEncode($arr);
    if (!is_null($jsonresult))
        echo '({"total":"0","results":'. $jsonresult .'})';
}
function Historial_LegalizacionesManual(){
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pIPS = isset($_REQUEST['pIPS']) ? $_REQUEST['pIPS']:0;
    $pSede = isset($_REQUEST['pSede']) ? $_REQUEST['pSede']:0;
    $pPaciente = isset($_REQUEST['pPaciente']) ? $_REQUEST['pPaciente']:0;
    $pNomBaseDatos = isset($_REQUEST['pNomBaseDatos'])?$_REQUEST['pNomBaseDatos']:"NA";
    if($pNomBaseDatos == "NA"){
        $gBaseDatos = new ofiMySQLi();
    }else{
        $gBaseDatos = new ofiMySQLi($pNomBaseDatos);
    }
    $gBaseDatos->conectar();
    $qry = "CALL sp_legalizacion_grid_citaslegalizadas_manual('". $pEmpresa . "','" . $pSede . "','" . $pIPS . "','" . $pPaciente . "')";
    //echo $qry;
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
    {
        $nRow = $row;
        foreach($row as $key => $val)
        {
            $nRow[$key] = PonerAcentosHTML($val);
        }
        $arr[] = $nRow;
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $jsonresult = JEncode($arr);
    if (!is_null($jsonresult))
        echo '({"total":"0","results":'. $jsonresult .'})';
}
function Historial_CitasX($Estado){
    // OR = ||
    
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pIPS = isset($_REQUEST['pIPS']) ? $_REQUEST['pIPS']:0;
    $pPaciente = isset($_REQUEST['pPaciente']) ? $_REQUEST['pPaciente']:0;
    $pNomBaseDatos = isset($_REQUEST['pNomBaseDatos'])?$_REQUEST['pNomBaseDatos']:"NA";
    if($pNomBaseDatos == "NA"){
        $gBaseDatos = new ofiMySQLi();
    }else{
        $gBaseDatos = new ofiMySQLi($pNomBaseDatos);
    }
    $gBaseDatos->conectar();
    $qry = "CALL sp_historial_citas_x('" . $pPaciente . "','". $pEmpresa . "','" . $pIPS . "',\"" . $Estado . "\")";
    $CampoLlave = explode("^",$gBaseDatos->jasonSP_arreglo2011($qry));
    $nbrows = $CampoLlave[0];
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    if($nbrows>0){
        $gBaseDatos->conectar();
        $start = (integer) (isset($_POST['start']) ? $_POST['start'] : $_GET['start']);
        $end = (integer) (isset($_POST['limit']) ? $_POST['limit'] : $_GET['limit']);
        $qry = "CALL sp_historial_citas_x_limit('" . $pPaciente . "','". $pEmpresa . "','" . $pIPS . "',\"" . $Estado . "\",'" . $start . "','" . $end . "')";
        //echo $qry;
        $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
        while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
        {
            $nRow = $row;
            foreach($row as $key => $val)
            {
                $nRow[$key] = PonerAcentosHTML($val);
            }
            $arr[] = $nRow;
        }
        $jsonresult = JEncode($arr);
        $gBaseDatos->liberar();
        $gBaseDatos->cerrar();
        echo '({success: true, requestedId:"1", "total":"'.$nbrows.'","results":'.$jsonresult.'})';
    } else {
        echo '({success: true, requestedId:"1", "total":"0", "results":""})';
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
}
function Historial_CitasManualX($Estado){
    // OR = ||
    
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pIPS = isset($_REQUEST['pIPS']) ? $_REQUEST['pIPS']:0;
    $pPaciente = isset($_REQUEST['pPaciente']) ? $_REQUEST['pPaciente']:0;
    $pNomBaseDatos = isset($_REQUEST['pNomBaseDatos'])?$_REQUEST['pNomBaseDatos']:"NA";
    if($pNomBaseDatos == "NA"){
        $gBaseDatos = new ofiMySQLi();
    }else{
        $gBaseDatos = new ofiMySQLi($pNomBaseDatos);
    }
    $gBaseDatos->conectar();
    $qry = "CALL sp_historial_citas_manual_x('" . $pPaciente . "','". $pEmpresa . "','" . $pIPS . "',\"" . $Estado . "\")";
    $CampoLlave = explode("^",$gBaseDatos->jasonSP_arreglo2011($qry));
    $nbrows = $CampoLlave[0];
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    if($nbrows>0){
        $gBaseDatos->conectar();
        $start = (integer) (isset($_POST['start']) ? $_POST['start'] : $_GET['start']);
        $end = (integer) (isset($_POST['limit']) ? $_POST['limit'] : $_GET['limit']);
        $qry = "CALL sp_historial_citas_manual_x_limit('" . $pPaciente . "','". $pEmpresa . "','" . $pIPS . "',\"" . $Estado . "\",'" . $start . "','" . $end . "')";
        //echo $qry;
        $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
        while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
        {
            $nRow = $row;
            foreach($row as $key => $val)
            {
                $nRow[$key] = PonerAcentosHTML($val);
            }
            $arr[] = $nRow;
        }
        $jsonresult = JEncode($arr);
        $gBaseDatos->liberar();
        $gBaseDatos->cerrar();
        echo '({success: true, requestedId:"1", "total":"'.$nbrows.'","results":'.$jsonresult.'})';
    } else {
        echo '({success: true, requestedId:"1", "total":"0", "results":""})';
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
}
function Historial_CitasAsignadasManual(){
    // OR = ||
    
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pIPS = isset($_REQUEST['pIPS']) ? $_REQUEST['pIPS']:0;
    $pPaciente = isset($_REQUEST['pPaciente']) ? $_REQUEST['pPaciente']:0;
    $pNomBaseDatos = isset($_REQUEST['pNomBaseDatos'])?$_REQUEST['pNomBaseDatos']:"NA";
    if($pNomBaseDatos == "NA"){
        $gBaseDatos = new ofiMySQLi();
    }else{
        $gBaseDatos = new ofiMySQLi($pNomBaseDatos);
    }
    $gBaseDatos->conectar();
    $qry = "CALL sp_historial_citas_asignadas_manual('" . $pPaciente . "','". $pEmpresa . "','" . $pIPS . "')";
    $CampoLlave = explode("^",$gBaseDatos->jasonSP_arreglo2011($qry));
    $nbrows = $CampoLlave[0];
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    if($nbrows>0){
        $gBaseDatos->conectar();
        $start = (integer) (isset($_POST['start']) ? $_POST['start'] : $_GET['start']);
        $end = (integer) (isset($_POST['limit']) ? $_POST['limit'] : $_GET['limit']);
        $qry = "CALL sp_historial_citas_asignadas_manual_limit('" . $pPaciente . "','". $pEmpresa . "','" . $pIPS . "','" . $start . "','" . $end . "')";
        //echo $qry;
        $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
        while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
        {
            $nRow = $row;
            foreach($row as $key => $val)
            {
                $nRow[$key] = PonerAcentosHTML($val);
            }
            $arr[] = $nRow;
        }
        $jsonresult = JEncode($arr);
        $gBaseDatos->liberar();
        $gBaseDatos->cerrar();
        echo '({success: true, requestedId:"1", "total":"'.$nbrows.'","results":'.$jsonresult.'})';
    } else {
        echo '({success: true, requestedId:"1", "total":"0", "results":""})';
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
}
function Historial_CitasAsignadas(){
    // OR = ||
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pIPS = isset($_REQUEST['pIPS']) ? $_REQUEST['pIPS']:0;
    $pPaciente = isset($_REQUEST['pPaciente']) ? $_REQUEST['pPaciente']:0;
    $pDesde = isset($_REQUEST['pDesde']) ? $_REQUEST['pDesde']:null;
    $pHasta = isset($_REQUEST['pHasta']) ? $_REQUEST['pHasta']:null;
    $pNomBaseDatos = isset($_REQUEST['pNomBaseDatos'])?$_REQUEST['pNomBaseDatos']:"NA";
    if($pNomBaseDatos == "NA"){
        $gBaseDatos = new ofiMySQLi();
    }else{
        $gBaseDatos = new ofiMySQLi($pNomBaseDatos);
    }
    $gBaseDatos->conectar();
    $qry = "CALL sp_historial_citas_asignadas('" . $pPaciente . "','". $pEmpresa . "','" . $pIPS . "',\"" . $pDesde . "\",\"" . $pHasta . "\")";
    //$qry = "CALL sp_historial_citas_asignadas('" . $pPaciente . "','". $pEmpresa . "','" . $pIPS . "')";
    //echo $qry;
    $CampoLlave = explode("^",$gBaseDatos->jasonSP_arreglo2011($qry));
    $nbrows = $CampoLlave[0];
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    if($nbrows>0){
        $gBaseDatos->conectar();
        $start = (integer) (isset($_POST['start']) ? $_POST['start'] : $_GET['start']);
        $end = (integer) (isset($_POST['limit']) ? $_POST['limit'] : $_GET['limit']);
        if($end == null || $end == 0){
            $end = 15;
        }
        $qry = "CALL sp_historial_citas_asignadas_limit('" . $pPaciente . "','". $pEmpresa . "','" . $pIPS . "',\"" . $pDesde . "\",\"" . $pHasta . "\",'" . $start . "','" . $end . "')";
        //$qry = "CALL sp_historial_citas_asignadas_limit('" . $pPaciente . "','". $pEmpresa . "','" . $pIPS . "','" . $start . "','" . $end . "')";
        //echo $qry;
        $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
        while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
        {
            $nRow = $row;
            foreach($row as $key => $val)
            {
                $nRow[$key] = PonerAcentosHTML($val);
            }
            $arr[] = $nRow;
        }
        $jsonresult = JEncode($arr);
        $gBaseDatos->liberar();
        $gBaseDatos->cerrar();
        echo '({success: true, requestedId:"1", "total":"'.$nbrows.'","results":'.$jsonresult.'})';
    } else {
        echo '({success: true, requestedId:"1", "total":"0", "results":""})';
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
}
function Listar_CitasxEvolucionarxPaciente(){
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $pProfesional = isset($_REQUEST['pProfesional'])?$_REQUEST['pProfesional']:0;
    $pNomBaseDatos = isset($_REQUEST['pNomBaseDatos'])?$_REQUEST['pNomBaseDatos']:"NA";
    if($pNomBaseDatos == "NA"){
        $gBaseDatos = new ofiMySQLi();
    }else{
        $gBaseDatos = new ofiMySQLi($pNomBaseDatos);
    }
    $gBaseDatos->conectar();
    $qry = "CALL sp_pacientes_hc_sinevolucionar('" . $pEmpresa . "','" . $pIPS . "','" . $pPaciente . "','" . $pProfesional . "')";
    //echo $qry;
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
    {
        $nRow = $row;
        foreach($row as $key => $val)
        {
            $nRow[$key] = PonerAcentosHTML($val);
        }
        $arr[] = $nRow;
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $jsonresult = JEncode($arr);
    if (!is_null($jsonresult))
        echo '({"total":"0","results":'. $jsonresult .'})';
}
function Listar_CitasxEvolucionarUrgencias(){
    $pAgenda = isset($_REQUEST['pAgenda'])?$_REQUEST['pAgenda']:0;
    $pNomBaseDatos = isset($_REQUEST['pNomBaseDatos'])?$_REQUEST['pNomBaseDatos']:"NA";
    if($pNomBaseDatos == "NA"){
        $gBaseDatos = new ofiMySQLi();
    }else{
        $gBaseDatos = new ofiMySQLi($pNomBaseDatos);
    }
    $gBaseDatos->conectar();
    $qry = "CALL sp_grid_agendas_citasxevolucionar_urgencias('" . $pAgenda . "')";
    //echo $qry;
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
    {
        $nRow = $row;
        foreach($row as $key => $val)
        {
            $nRow[$key] = PonerAcentosHTML($val);
        }
        $arr[] = $nRow;
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $jsonresult = JEncode($arr);
    if (!is_null($jsonresult))
        echo '({"total":"0","results":'. $jsonresult .'})';    
}
function Listar_CitasxEvolucionar(){
    $pAgenda = isset($_REQUEST['pAgenda'])?$_REQUEST['pAgenda']:0;
    $pNomBaseDatos = isset($_REQUEST['pNomBaseDatos'])?$_REQUEST['pNomBaseDatos']:"NA";
    if($pNomBaseDatos == "NA"){
        $gBaseDatos = new ofiMySQLi();
    }else{
        $gBaseDatos = new ofiMySQLi($pNomBaseDatos);
    }
    $gBaseDatos->conectar();
    $qry = "CALL sp_grid_agendas_citasxevolucionar('" . $pAgenda . "')";
    //echo $qry;
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
    {
        $nRow = $row;
        foreach($row as $key => $val)
        {
            $nRow[$key] = PonerAcentosHTML($val);
        }
        $arr[] = $nRow;
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $jsonresult = JEncode($arr);
    if (!is_null($jsonresult))
        echo '({"total":"0","results":'. $jsonresult .'})';    
}
function Listar_CitasxEvolucionarOdo(){
    $pAgenda = isset($_REQUEST['pAgenda'])?$_REQUEST['pAgenda']:0;
    $pNomBaseDatos = isset($_REQUEST['pNomBaseDatos'])?$_REQUEST['pNomBaseDatos']:"NA";
    if($pNomBaseDatos == "NA"){
        $gBaseDatos = new ofiMySQLi();
    }else{
        $gBaseDatos = new ofiMySQLi($pNomBaseDatos);
    }
    $gBaseDatos->conectar();
    $qry = "CALL sp_grid_agendas_citasxevolucionarodo('" . $pAgenda . "')";
    //echo $qry;
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
    {
        $nRow = $row;
        foreach($row as $key => $val)
        {
            $nRow[$key] = PonerAcentosHTML($val);
        }
        $arr[] = $nRow;
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $jsonresult = JEncode($arr);
    if (!is_null($jsonresult))
        echo '({"total":"0","results":'. $jsonresult .'})';    
}

function Listar_CitasxEvolucionarUAMEST(){
    $pAgenda = isset($_REQUEST['pAgenda'])?$_REQUEST['pAgenda']:0;
    $pNomBaseDatos = isset($_REQUEST['pNomBaseDatos'])?$_REQUEST['pNomBaseDatos']:"NA";
    if($pNomBaseDatos == "NA"){
        $gBaseDatos = new ofiMySQLi();
    }else{
        $gBaseDatos = new ofiMySQLi($pNomBaseDatos);
    }
    $gBaseDatos->conectar();
    $qry = "CALL sp_grid_agendas_citasxevolucionar_uamest('" . $pAgenda . "')";
    //echo $qry;
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
    {
        $nRow = $row;
        foreach($row as $key => $val)
        {
            $nRow[$key] = PonerAcentosHTML($val);
        }
        $arr[] = $nRow;
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $jsonresult = JEncode($arr);
    if (!is_null($jsonresult))
        echo '({"total":"0","results":'. $jsonresult .'})';    
}
function Listar_CitasxEvolucionarUAM(){
    $pProfesional = isset($_REQUEST['pProfesional'])?$_REQUEST['pProfesional']:0;
    $pNomBaseDatos = isset($_REQUEST['pNomBaseDatos'])?$_REQUEST['pNomBaseDatos']:"NA";
    if($pNomBaseDatos == "NA"){
        $gBaseDatos = new ofiMySQLi();
    }else{
        $gBaseDatos = new ofiMySQLi($pNomBaseDatos);
    }
    $gBaseDatos->conectar();
    $qry = "CALL sp_grid_agendas_citasxevolucionar_uam001('" . $pProfesional . "')";
    //echo $qry;
    unset($arr);
    if($pProfesional != 0){
        $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
        $arr = array();
        while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
        {
            $nRow = $row;
            foreach($row as $key => $val)
            {
                $nRow[$key] = PonerAcentosHTML($val);
            }
            $arr[] = $nRow;
        }
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $jsonresult = JEncode($arr);
    if (!is_null($jsonresult))
        echo '({"total":"0","results":'. $jsonresult .'})';    
}
function Listar_CitasxEvolucionarUAM00(){
    $pAgenda = isset($_REQUEST['pAgenda'])?$_REQUEST['pAgenda']:0;
    $pNomBaseDatos = isset($_REQUEST['pNomBaseDatos'])?$_REQUEST['pNomBaseDatos']:"NA";
    if($pNomBaseDatos == "NA"){
        $gBaseDatos = new ofiMySQLi();
    }else{
        $gBaseDatos = new ofiMySQLi($pNomBaseDatos);
    }
    $gBaseDatos->conectar();
    $qry = "CALL sp_grid_agendas_citasxevolucionar_uam000('" . $pAgenda . "')";
    //echo $qry;
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
    {
        $nRow = $row;
        foreach($row as $key => $val)
        {
            $nRow[$key] = PonerAcentosHTML($val);
        }
        $arr[] = $nRow;
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $jsonresult = JEncode($arr);
    if (!is_null($jsonresult))
        echo '({"total":"0","results":'. $jsonresult .'})';
}

function Listar_CitasxEvolucionar001(){
    $pAgenda = isset($_REQUEST['pAgenda'])?$_REQUEST['pAgenda']:0;
    $pNomBaseDatos = isset($_REQUEST['pNomBaseDatos'])?$_REQUEST['pNomBaseDatos']:"NA";
    if($pNomBaseDatos == "NA"){
        $gBaseDatos = new ofiMySQLi();
    }else{
        $gBaseDatos = new ofiMySQLi($pNomBaseDatos);
    }
    $gBaseDatos->conectar();
    $qry = "CALL sp_grid_agendas_citasxevolucionar001('" . $pAgenda . "')";
    //echo $qry;
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
    {
        $nRow = $row;
        foreach($row as $key => $val)
        {
            $nRow[$key] = PonerAcentosHTML($val);
        }
        $arr[] = $nRow;
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $jsonresult = JEncode($arr);
    if (!is_null($jsonresult))
        echo '({"total":"0","results":'. $jsonresult .'})';    
}
function Listar_CitasxEvolucionar002(){
    $pAgenda = isset($_REQUEST['pAgenda'])?$_REQUEST['pAgenda']:0;
    $pNomBaseDatos = isset($_REQUEST['pNomBaseDatos'])?$_REQUEST['pNomBaseDatos']:"NA";
    if($pNomBaseDatos == "NA"){
        $gBaseDatos = new ofiMySQLi();
    }else{
        $gBaseDatos = new ofiMySQLi($pNomBaseDatos);
    }
    $gBaseDatos->conectar();
    $qry = "CALL sp_grid_agendas_citasxevolucionar002('" . $pAgenda . "')";
    //echo $qry;
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
    {
        $nRow = $row;
        foreach($row as $key => $val)
        {
            $nRow[$key] = PonerAcentosHTML($val);
        }
        $arr[] = $nRow;
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $jsonresult = JEncode($arr);
    if (!is_null($jsonresult))
        echo '({"total":"0","results":'. $jsonresult .'})';    
}
function Listar_CitasManualxLegalizar(){
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pSede = isset($_REQUEST['pSede'])?$_REQUEST['pSede']:0;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $pNomBaseDatos = isset($_REQUEST['pNomBaseDatos'])?$_REQUEST['pNomBaseDatos']:"NA";
    if($pNomBaseDatos == "NA"){
        $gBaseDatos = new ofiMySQLi();
    }else{
        $gBaseDatos = new ofiMySQLi($pNomBaseDatos);
    }
    $gBaseDatos->conectar();
    $qry = "CALL sp_legalizacion_grid_citasmanualxlegalizar('" . $pEmpresa . "','" . $pSede . "','" . $pIPS . "','" . $pPaciente . "')";
    //echo $qry;
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
    {
        $nRow = $row;
        foreach($row as $key => $val)
        {
            $nRow[$key] = PonerAcentosHTML($val);
        }
        $arr[] = $nRow;
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $jsonresult = JEncode($arr);
    if (!is_null($jsonresult))
        echo '({"total":"0","results":'. $jsonresult .'})';    
}
function Listar_CitasxLegalizar(){
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pSede = isset($_REQUEST['pSede'])?$_REQUEST['pSede']:0;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $pNomBaseDatos = isset($_REQUEST['pNomBaseDatos'])?$_REQUEST['pNomBaseDatos']:"NA";
    if($pNomBaseDatos == "NA"){
        $gBaseDatos = new ofiMySQLi();
    }else{
        $gBaseDatos = new ofiMySQLi($pNomBaseDatos);
    }
    $gBaseDatos->conectar();
    $qry = "CALL sp_legalizacion_grid_citasxlegalizar('" . $pEmpresa . "','" . $pSede . "','" . $pIPS . "','" . $pPaciente . "')";
    //echo $qry;
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
    {
        $nRow = $row;
        foreach($row as $key => $val)
        {
            $nRow[$key] = PonerAcentosHTML($val);
        }
        $arr[] = $nRow;
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $jsonresult = JEncode($arr);
    if (!is_null($jsonresult))
        echo '({"total":"0","results":'. $jsonresult .'})';    
}
function AsignarCitas(){
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pSede = isset($_REQUEST['pSede'])?$_REQUEST['pSede']:0;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pConsultorio = isset($_REQUEST['pConsultorio'])?$_REQUEST['pConsultorio']:0;
    $pUsuario = isset($_REQUEST['pUsuario'])?$_REQUEST['pUsuario']:0;
    $pFechaCita = isset($_REQUEST['pFechaCita'])?$_REQUEST['pFechaCita']:"1980-01-01";
    $pTipoAfiliacion = isset($_REQUEST['pTipoAfiliacion'])?$_REQUEST['pTipoAfiliacion']:null;
    $pTipoAfiliado  = isset($_REQUEST['pTipoAfiliado'])?$_REQUEST['pTipoAfiliado']:null;
    if ($pTipoAfiliado == "")
        $pTipoAfiliado = null;
    $pParentesco = isset($_REQUEST['pParentesco'])?$_REQUEST['pParentesco']:null;
    if ($pParentesco == "")
        $pParentesco = null;
    $pRangoSalarial = isset($_REQUEST['pRangoSalarial'])?$_REQUEST['pRangoSalarial']:null;
    $pEstadoListado = isset($_REQUEST['pEstadoListado'])?$_REQUEST['pEstadoListado']:null;
    $pEdadPaciente = isset($_REQUEST['pEdadPaciente'])?$_REQUEST['pEdadPaciente']:null;
    if ($pEdadPaciente == "")
        $pEdadPaciente = null;
    $pDeptoMuniciPaciente = isset($_REQUEST['pDeptoMuniciPaciente'])?$_REQUEST['pDeptoMuniciPaciente']:null;
    if ($pDeptoMuniciPaciente == "")
        $pDeptoMuniciPaciente = null;
    $pPrograma = isset($_REQUEST['pPrograma'])?$_REQUEST['pPrograma']:null;
    $pFinalidad = isset($_REQUEST['pFinalidad'])?$_REQUEST['pFinalidad']:null;
    if ($pFinalidad == "")
        $pFinalidad = null;
    $pFacturarParticular = isset($_REQUEST['pFacturarParticular'])?$_REQUEST['pFacturarParticular']:0;
    $pFacturarCopagos = isset($_REQUEST['pFacturarCopagos'])?$_REQUEST['pFacturarCopagos']:0;
    $pCopagoDigitado = isset($_REQUEST['pCopagoDigitado'])?$_REQUEST['pCopagoDigitado']:0;
    $pPorCopagos = isset($_REQUEST['pPorCopagos'])?$_REQUEST['pPorCopagos']:0;
    $pMaxCopago = isset($_REQUEST['pMaxCopago'])?$_REQUEST['pMaxCopago']:0;
    $pvlrCuotaModeradoraIndicada = isset($_REQUEST['pvlrCuotaModeradoraIndicada'])?$_REQUEST['pvlrCuotaModeradoraIndicada']:0;
    $pExento = isset($_REQUEST['pExento'])?$_REQUEST['pExento']:null;
    $pTutela = isset($_REQUEST['pTutela'])?$_REQUEST['pTutela']:null;
    $pCodCliente = isset($_REQUEST['pCodCliente'])?$_REQUEST['pCodCliente']:0;
    $pDesCliente = isset($_REQUEST['pDesCliente'])?$_REQUEST['pDesCliente']:null;
    if ($pDesCliente == "")
        $pDesCliente = null;
    $pCodPlan = isset($_REQUEST['pCodPlan'])?$_REQUEST['pCodPlan']:0;
    $pDesPlan = isset($_REQUEST['pDesPlan'])?$_REQUEST['pDesPlan']:null;
    if ($pDesPlan == "")
        $pDesPlan = null;
    $pCodSubPlan = isset($_REQUEST['pCodSubPlan'])?$_REQUEST['pCodSubPlan']:0;
    $pDesSubPlan = isset($_REQUEST['pDesSubPlan'])?$_REQUEST['pDesSubPlan']:null;
    if ($pDesSubPlan == "")
        $pDesSubPlan = null;
    $pContrato = isset($_REQUEST['pContrato'])?$_REQUEST['pContrato']:0;
    $pIdProced = isset($_REQUEST['pIdProced'])?$_REQUEST['pIdProced']:0;
    $pCodProced = isset($_REQUEST['pCodProced'])?$_REQUEST['pCodProced']:null;
    if ($pCodProced == "")
        $pCodProced = null;
    $pDesProced = isset($_REQUEST['pDesProced'])?$_REQUEST['pDesProced']:null;
    if ($pDesProced == "")
        $pDesProced = null;
    $pTarifaProced = isset($_REQUEST['pTarifaProced'])?$_REQUEST['pTarifaProced']:0;
    $pObservaciones = isset($_REQUEST['pObservaciones'])?$_REQUEST['pObservaciones']:null;
    if ($pObservaciones == "")
        $pObservaciones = null;
    $pPaciente = isset($_REQUEST['pPaciente'])?$_REQUEST['pPaciente']:0;
    $pUsuarioAsigna = isset($_REQUEST['pUsuarioAsigna'])?$_REQUEST['pUsuarioAsigna']:0;
    $pSolicitudUsuario = isset($_REQUEST['pSolicitudUsuario'])?$_REQUEST['pSolicitudUsuario']:"0";
    $pProfeSol = isset($_REQUEST['pProfeSol'])?$_REQUEST['pProfeSol']:0;
    $pProfesionalCita = isset($_REQUEST['pProfesionalCita'])?$_REQUEST['pProfesionalCita']:0;
    $pMarcaExento = isset($_REQUEST['pMarcaExento'])?$_REQUEST['pMarcaExento']:"0";
    //if ($pMarcaExento == "t")
    //    $pMarcaExento = "1";
    //else
    //    $pMarcaExento = "0";
    $pAutorizacion = isset($_REQUEST['pAutorizacion'])?$_REQUEST['pAutorizacion']:null;
    if ($pAutorizacion == "")
        $pAutorizacion = null;
    $pFechaSol = isset($_REQUEST['pFechaSol'])?$_REQUEST['pFechaSol']:null;
    $pOrigenReg = isset($_REQUEST['pOrigenReg'])?$_REQUEST['pOrigenReg']:null;
    $pCitas = explode("¬", isset($_REQUEST['pInfoCita'])?$_REQUEST['pInfoCita']:"");
    //echo var_dump($pCitas);
    $pItems = count($pCitas)-1;
    //$pitems = 0;
    
    $anio = substr($pFechaCita, 0, 4);
    $mes = substr($pFechaCita, 5, 2);
    $dia = substr($pFechaCita, 8, 2);
    $fecCita = mktime(0,0,0,$mes,$dia,$anio);
    $diaSemanaCita = date("D",$fecCita);
    $horaCita = date("H",$fecCita);
    $OportunidadCita = OportunidadAsignacionCitas($fecCita);
    $pNomBaseDatos = isset($_REQUEST['pNomBaseDatos'])?$_REQUEST['pNomBaseDatos']:"NA";
    if($pItems > 0){
        if($pNomBaseDatos == "NA"){
            $gBaseDatos = new ofiMySQLi();
        }else{
            $gBaseDatos = new ofiMySQLi($pNomBaseDatos);
        }
        $gBaseDatos->conectar();
        $pIdCita = explode("^", $pCitas[0]);
        $CodInsercion = "PRS-" .  $_SESSION['ID_EMPRESA'] . "-SED-" . $_SESSION['ID_SEDE'] .  "-IPS-" . $_SESSION['ID_IPS'] . "-USR-" . $_SESSION['ID_USUARIO'] . "-CONS-" . mt_rand(0,100000) . "-" . date("His");
        $qry = "CALL sp_asignarcitas_crear_cas(\"" . $CodInsercion . "\",'" . $pEmpresa . "','" . $pSede . "','" .$pIPS . "','" .$pConsultorio . "','" . $pCodCliente . "','" . $pCodPlan . "','" . $pCodSubPlan . "','" . $pContrato . "',\"" . $pFechaCita . "\",\"" . $pFechaSol . "\",'" . $pPaciente . "','" . $pTipoAfiliacion . "',\"" . $pTipoAfiliado . "\",\"". $pParentesco . "\",'" . $pRangoSalarial . "','" . $pEstadoListado . "',\"" . $pEdadPaciente . "\",\"" .  $pDeptoMuniciPaciente . "\",'" . $pPrograma . "',\"" . $pFinalidad . "\",'" . $pFacturarParticular . "','" . $pExento . "','" . $pTutela . "','" . $pUsuario . "','" . $pProfeSol . "',\"" . $pAutorizacion . "\",'" . $pProfesionalCita . "','" . $pUsuarioAsigna . "',\"" . $pSolicitudUsuario . "\",'" . $OportunidadCita . "','" . $pIdCita[2] . "','" . $pFacturarCopagos . "','" . $pCopagoDigitado . "','" . $pPorCopagos . "','" . $pvlrCuotaModeradoraIndicada . "','" . $pMaxCopago . "',\"" . $pMarcaExento . "\")";
        //echo $qry;
        $CampoLlave = explode("^",$gBaseDatos->jasonSP_arreglo2011($qry));
        $gBaseDatos->liberar();
        $gBaseDatos->cerrar();
        if($CampoLlave[0] > 0){
            $qry = "CALL sp_asignarcitas_crear_cas_detalle('" . $CampoLlave[0] . "','" . $pIdProced . "',\"" . $pCodProced . "\",\"" . $pDesProced . "\",'" . $pTarifaProced . "','" . $pUsuario . "')";
            $gBaseDatos->conectar();
            @mysqli_query($gBaseDatos->ConexionID, $qry);
            $gBaseDatos->cerrar();
            for($i=0; $i<$pItems; $i++)
            {
                //echo $pCitas[$i];
                $pDetCita = explode("^", $pCitas[$i]);
                $pOportunidad = $OportunidadCita;
                $qry = "CALL sp_asignarcitas_actualizar_detalleagendas('" . $pDetCita[0] . "','" . $CampoLlave[0] . "',\"" . $pDetCita[1] . "\",'" . $pIdProced . "',\"" . $pCodProced . "\",\"" . $pDesProced . "\",'" . $pPaciente . "','" . $pCodCliente . "',\"" . $pDesCliente . "\",'" . $pCodPlan . "',\"" . $pDesPlan . "\",'" . $pCodSubPlan . "',\"" . $pDesSubPlan . "\",'" . $pContrato . "','" . $pUsuario . "','" . $pOportunidad . "',\"" . $pObservaciones . "\",\"" . $pSolicitudUsuario . "\")";
                //echo $qry;
                $gBaseDatos->conectar();
                @mysqli_query($gBaseDatos->ConexionID, $qry);
                $gBaseDatos->cerrar();
            }
            if($pOrigenReg == "CX"){
                //Asignar Automaticamente la Cita Pendiente en Radicar Citas Cx
                $qry = "CALL sp_asignarcitas_update_citasprogramacioncx('" . $CampoLlave[0] . "')";
            }else{
                //Asignar Automaticamente la Cita Pendiente en Radicar Citas Cx
                $qry = "CALL sp_asignarcitas_update_radicarcitascx('" . $CampoLlave[0] . "')";
            }
            $gBaseDatos->conectar();
            @mysqli_query($gBaseDatos->ConexionID, $qry);
            $gBaseDatos->cerrar();
            echo $CampoLlave[0];
        }else{
            echo "0";
        }
    }else{
        echo "0";
    }
}
function Listar_ProfesionalesAgenda(){
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pProced = isset($_REQUEST['pProced'])?$_REQUEST['pProced']:0;
    $pNomBaseDatos = isset($_REQUEST['pNomBaseDatos'])?$_REQUEST['pNomBaseDatos']:"NA";
    if($pNomBaseDatos == "NA"){
        $gBaseDatos = new ofiMySQLi();
    }else{
        $gBaseDatos = new ofiMySQLi($pNomBaseDatos);
    }
    $gBaseDatos->conectar();
    $pCodBloqueo = isset($_REQUEST['pCodBloqueo'])?$_REQUEST['pCodBloqueo']:"-1";
    $qry = "CALL sp_asignarcitas_profesionales_grid('" . $pEmpresa . "','" . $pIPS . "','" . $pProced . "',\"" . $pCodBloqueo . "\")";
    //echo $qry;
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
    {
        $nRow = $row;
        foreach($row as $key => $val)
        {
            $nRow[$key] = PonerAcentosHTML($val);
        }
        $arr[] = $nRow;
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $jsonresult = JEncode($arr);
    if (!is_null($jsonresult))
        echo '({"total":"0","results":'. $jsonresult .'})';
}
function Listar_ConsultoriosxProfe(){
    $pEmpresa = isset($_REQUEST['pEmpresa'])?$_REQUEST['pEmpresa']:0;
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pProfesional = isset($_REQUEST['pProfesional'])?$_REQUEST['pProfesional']:0;
    $pNomBaseDatos = isset($_REQUEST['pNomBaseDatos'])?$_REQUEST['pNomBaseDatos']:"NA";
    if($pNomBaseDatos == "NA"){
        $gBaseDatos = new ofiMySQLi();
    }else{
        $gBaseDatos = new ofiMySQLi($pNomBaseDatos);
    }
    $gBaseDatos->conectar();
    $pCodBloqueo = isset($_REQUEST['pCodBloqueo'])?$_REQUEST['pCodBloqueo']:"-1";
    $qry = "CALL sp_asignarcitas_consultorios_grid('" . $pIPS . "','" . $pProfesional . "',\"" . $pCodBloqueo . "\")";
    //echo $qry;
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
    {
        $nRow = $row;
        foreach($row as $key => $val)
        {
            $nRow[$key] = PonerAcentosHTML($val);
        }
        $arr[] = $nRow;
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $jsonresult = JEncode($arr);
    if (!is_null($jsonresult))
        echo '({"total":"0","results":'. $jsonresult .'})';
}
function Listar_AgendasDispxProfexConsultorio(){
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pProfesional = isset($_REQUEST['pProfesional'])?$_REQUEST['pProfesional']:0;
    $pConsultorio = isset($_REQUEST['pConsultorio'])?$_REQUEST['pConsultorio']:0;
    $pNomBaseDatos = isset($_REQUEST['pNomBaseDatos'])?$_REQUEST['pNomBaseDatos']:"NA";
    if($pNomBaseDatos == "NA"){
        $gBaseDatos = new ofiMySQLi();
    }else{
        $gBaseDatos = new ofiMySQLi($pNomBaseDatos);
    }
    $gBaseDatos->conectar();
    $pCodBloqueo = isset($_REQUEST['pCodBloqueo'])?$_REQUEST['pCodBloqueo']:"-1";
    $qry = "CALL sp_asignarcitas_agendasdisp_grid('" . $pIPS . "','" . $pProfesional . "','" . $pConsultorio . "',\"" . $pCodBloqueo . "\")";
    //echo $qry;
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
    {
        $nRow = $row;
        foreach($row as $key => $val)
        {
            $nRow[$key] = PonerAcentosHTML($val);
        }
        $arr[] = $nRow;
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $jsonresult = JEncode($arr);
    if (!is_null($jsonresult))
        echo '({"total":"0","results":'. $jsonresult .'})';
}

function Listar_AgendasBloqueadasxProfexConsultorio(){
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pProfesional = isset($_REQUEST['pProfesional'])?$_REQUEST['pProfesional']:0;
    $pConsultorio = isset($_REQUEST['pConsultorio'])?$_REQUEST['pConsultorio']:0;
    $pNomBaseDatos = isset($_REQUEST['pNomBaseDatos'])?$_REQUEST['pNomBaseDatos']:"NA";
    if($pNomBaseDatos == "NA"){
        $gBaseDatos = new ofiMySQLi();
    }else{
        $gBaseDatos = new ofiMySQLi($pNomBaseDatos);
    }
    $gBaseDatos->conectar();
    $qry = "CALL sp_asignarcitas_agendasbloq_grid('" . $pIPS . "','" . $pProfesional . "','" . $pConsultorio . "')";
    //echo $qry;
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
    {
        $nRow = $row;
        foreach($row as $key => $val)
        {
            $nRow[$key] = PonerAcentosHTML($val);
        }
        $arr[] = $nRow;
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $jsonresult = JEncode($arr);
    if (!is_null($jsonresult))
        echo '({"total":"0","results":'. $jsonresult .'})';
}

function Listar_HorariosDispxAgendasSesiones(){
    $pIPS = isset($_REQUEST['pIPS'])?$_REQUEST['pIPS']:0;
    $pProfesional = isset($_REQUEST['pProfesional'])?$_REQUEST['pProfesional']:0;
    $pCodBloqueo = isset($_REQUEST['pCodBloqueo'])?$_REQUEST['pCodBloqueo']:"-1";
    $pNomBaseDatos = isset($_REQUEST['pNomBaseDatos'])?$_REQUEST['pNomBaseDatos']:"NA";
    if($pNomBaseDatos == "NA"){
        $gBaseDatos = new ofiMySQLi();
    }else{
        $gBaseDatos = new ofiMySQLi($pNomBaseDatos);
    }
    $gBaseDatos->conectar();
    $qry = "CALL sp_asignarcitas_horariosdisp_sesiones_grid('" . $pIPS . "','" . $pProfesional . "',\"" . $pCodBloqueo . "\")";
    //rafa
    //echo $qry;
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
    {
        $nRow = $row;
        foreach($row as $key => $val)
        {
            $nRow[$key] = PonerAcentosHTML($val);
        }
        $arr[] = $nRow;
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $jsonresult = JEncode($arr);
    if (!is_null($jsonresult))
        echo '({"total":"0","results":'. $jsonresult .'})';
}

function Listar_HorariosDispxAgendas(){
    $pAgenda = isset($_REQUEST['pAgenda'])?$_REQUEST['pAgenda']:0;
    $pCodBloqueo = isset($_REQUEST['pCodBloqueo'])?$_REQUEST['pCodBloqueo']:"-1";
    $pUsuario = isset($_REQUEST['pUsuario'])?$_REQUEST['pUsuario']:0;
    $pNroHoras = isset($_REQUEST['pNroHoras'])?$_REQUEST['pNroHoras']:1;
    $pNomBaseDatos = isset($_REQUEST['pNomBaseDatos'])?$_REQUEST['pNomBaseDatos']:"NA";
    if($pNomBaseDatos == "NA"){
        $gBaseDatos = new ofiMySQLi();
    }else{
        $gBaseDatos = new ofiMySQLi($pNomBaseDatos);
    }
    $gBaseDatos->conectar();
    $qry = "CALL sp_asignarcitas_horariosdisp_grid('" . $pAgenda . "',\"" . $pCodBloqueo . "\",'" . $pUsuario . "')";
    //echo $qry;
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
    {
        $nRow = $row;
        foreach($row as $key => $val)
        {
            $nRow[$key] = PonerAcentosHTML($val);
        }
        $arr[] = $nRow;
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $pRegistros = count($arr);
    $Grupo = 0;
    $descHoraFin = "";
    //echo $pNroHoras . "malo - " . $pRegistros;
    for($i=0;$i<$pRegistros;$i++)
    {
        $Grupo ++;
        $descHoraFin = "";
        if(($i+($pNroHoras-1))<$pRegistros){
            if($arr[$i]["GrupoCita"]==0){
                if($pNroHoras == 1){
                    $arr[$i]["GrupoCita"] = $Grupo;
                    $arr[$i]["MostrarGrupoCita"] = 1;
                }else{
                    for($j=1;$j<=$pNroHoras;$j++){
                        if($j==1){
                            $horaAct = substr($arr[$i]["IdCita"],-5);
                            $horaSig = substr($arr[$i+$j]["IdCita"],0,5);
                        }else{
                            $horaAct = $horaSig;
                            $horaSig = substr($arr[$i+$j]["IdCita"],0,5);
                        }
                        if($horaAct == $horaSig){
                            $arr[$i]["GrupoCita"] = $Grupo;
                            $arr[$i]["MostrarGrupoCita"] = 1;
                            for($k=1;$k<$pNroHoras;$k++){
                                $arr[$i+$k]["GrupoCita"] = $Grupo;
                                $descHoraFin = substr($arr[$i+$k]["citaDescripcion"],-8);
                            }
                            $arr[$i]["citaDescripcion"] = substr($arr[$i]["citaDescripcion"],0,8) . $descHoraFin;
                        }
                    }
                }
            }
        }
    }
    $jsonresult = JEncode($arr);
    if (!is_null($jsonresult))
        echo '({"total":"0","results":'. $jsonresult .'})';
}

function Listar_HorariosDispxAgendasOriginal(){
    $pAgenda = isset($_REQUEST['pAgenda'])?$_REQUEST['pAgenda']:0;
    $pCodBloqueo = isset($_REQUEST['pCodBloqueo'])?$_REQUEST['pCodBloqueo']:"-1";
    $pUsuario = isset($_REQUEST['pUsuario'])?$_REQUEST['pUsuario']:0;
    $pNomBaseDatos = isset($_REQUEST['pNomBaseDatos'])?$_REQUEST['pNomBaseDatos']:"NA";
    if($pNomBaseDatos == "NA"){
        $gBaseDatos = new ofiMySQLi();
    }else{
        $gBaseDatos = new ofiMySQLi($pNomBaseDatos);
    }
    $gBaseDatos->conectar();
    $qry = "CALL sp_asignarcitas_horariosdisp_grid('" . $pAgenda . "',\"" . $pCodBloqueo . "\",'" . $pUsuario . "')";
    //echo $qry;
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $arr = array();
    while($row = @mysqli_fetch_assoc($gBaseDatos->QryID))
    {
        $nRow = $row;
        foreach($row as $key => $val)
        {
            $nRow[$key] = PonerAcentosHTML($val);
        }
        $arr[] = $nRow;
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    $jsonresult = JEncode($arr);
    if (!is_null($jsonresult))
        echo '({"total":"0","results":'. $jsonresult .'})';
}

?>
