<?php
    require_once('../../../lib/tcpdf/config/lang/spa.php');
    require_once('../../../lib/tcpdf/tcpdf.php');
    require("../../../core/php/_database.php");
    require("../../../core/php/php_functions.php");
    header('Content-type: application/pdf; charset: UTF-8');
    
    $estructura = explode("¬", $_REQUEST['param']);
    $pNomParametros = spNomParametrosMI($estructura,"NO");
    $NameParam = explode("¬", $pNomParametros);
    $pParametros = spParametrosMI($estructura,"NO");
    $DataParam = explode("¬", $pParametros);
    
    $items = count($NameParam);
    for ($i=0; $i<$items; $i++)
    {
        switch ($NameParam[$i]) 
        {
            case "intEmpresa":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                    $pEmpresa = 0;
                else
                    $pEmpresa = $DataParam[$i];
                break;
                
            case "intProfesional":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null"){
                    $pProfesional = 0;
                    $pFiltroProfesional = 'n';
                }else{
                    $pProfesional = $DataParam[$i];
                    $pFiltroProfesional = 's';
                }
                break;
                
            case "fecDesde":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                {    
                    $pDesde = date('Y-m-d');
                    $pFiltroFechas = 'n';
                }else{
                    $pDesde = $DataParam[$i];
                    $pFiltroFechas = 's';
                }
                break;
                
            case "fecHasta":
                if ($DataParam[$i] == "" || $DataParam[$i] == null || $DataParam[$i] == "null")
                {
                    $pFiltroFechas = 'n';
                    $pHasta = date('Y-m-d');
                }else{
                    $pHasta = $DataParam[$i];
                    $pFiltroFechas = 's';
                }
                break;
                
            default:
                break;
        }
    }
    $pFiltroAgenda = 'n';
    $pAgenda = 0;
    $qry = "CALL sp_profesionales_agendas_programadas_detallexprofe('" . $pEmpresa . "',\"" . $pFiltroFechas . "\",\"" . $pDesde . "\",\"" . $pHasta . "\",\"" . $pFiltroAgenda . "\",'" . $pAgenda . "',\"" . $pFiltroProfesional . "\",'" . $pProfesional . "')";
    //echo $qry;
    
    // create new PDF document
    $pdf = new TCPDF("L", PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

    // set document information
    $pdf->SetCreator(PDF_CREATOR);
    $pdf->SetAuthor('Sistemas Ofisalud © - 2011');
    $pdf->SetTitle('Agendas por Profesional');
    $pdf->SetSubject('Agendas');

    // set default header data
    session_start();
    $pdf->pAlineacionEncabezado = "L";
    $pdf->pTituloInforme = "AGENDA POR PROFESIONAL";
    $pdf->pImprimeLogo = "NO";
    $pdf->pAnchoTxtPagina = 270;
    $pdf->pNomEmpresa = $_SESSION['NOM_EMPRESA'];
    $pdf->pNomSede = $_SESSION['NOM_SEDE'];
    $pdf->pNomIPS = $_SESSION['NOM_IPS'];
    $pdf->pMargenPie = -20;
    if($_SESSION['IdAplicacion'] == "OfiMedical"){
        $pdf->pLogoCliente = "../../../consultoriovirtual/" . $_SESSION['IDBD'] . "/logo/logoenc.gif";
    }else{
        $pdf->pLogoCliente = "../../../empresas/" . $_SESSION['ID_EMPRESA'] . "/logo/logoenc.gif";
    }

    $pdf->SetHeaderData($pdf->pLogoCliente, PDF_HEADER_LOGO_WIDTH, $pdf->pTituloInforme, PDF_HEADER_STRING);
    // set header and footer fonts
    $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
    $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
    // set default monospaced font
    $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
    //set margins
    $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
    $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
    $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
    //set auto page breaks
    $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
    //set image scale factor
    $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
    //set some language-dependent strings
    $pdf->setLanguageArray($l);
    // set default font subsetting mode
    $pdf->setFontSubsetting(true);
    $pdf->SetFont('dejavusans', '', 14, '', true);

    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    
    $gBaseDatos->QryID = @mysqli_query($gBaseDatos->ConexionID, $qry);
    $i =0;
    $controlAgenda = "0";
    while ($row = @mysqli_fetch_row($gBaseDatos->QryID))
    {
        $xProfe = $row[18] . "-" . $row[22];
        if ($controlAgenda != $xProfe)
        {
            $pdf->AddPage();
            $pdf->SetFont(PDF_FONT_NAME_MAIN,'B',11);
            //$pdf->MultiCell(264,10,"qry: " . $qry,0,'L',0,0);
            $pdf->MultiCell(264,10,"Profesional: " . utf8_decode($row[16]) . " - " . utf8_decode($row[18]),0,'L',0,0);
            $pdf->Ln(4);
            //$pdf->MultiCell(264,10,"Fecha: " . utf8_decode($row[22]) . " - Plantilla: " . utf8_decode($row[20]),0,'L',0,0);
            $pdf->writeHTMLCell(264, 10, '', '', "Fecha: " . utf8_decode($row[22]) . " - Plantilla: " . utf8_decode($row[20]), 0, 0, $fill, true, 'L', true);
            $pdf->Ln(2);
            //$pdf->MultiCell(264,10,"UBICACIÓN: " . utf8_decode($row[14]),0,'R',0,0);
            $pdf->MultiCell(264,10,"",0,'R',0,0);
            $pdf->Ln(4.5);
            $pdf->SetFillColor(242 , 236, 236);
            $pdf->SetFont(PDF_FONT_NAME_MAIN,'B',9);
            $pdf->MultiCell(22,5,utf8_decode("Hora"),1,'C',1,0);
            $pdf->MultiCell(23,5,"Ubicacion",1,'C',1,0);
            $pdf->MultiCell(45,5,"Paciente",1,'C',1,0);
            $pdf->MultiCell(30,5,"Teléfonos",1,'C',1,0);
            $pdf->MultiCell(45,5,"Actividad",1,'C',1,0);
            $pdf->MultiCell(33,5,"Cliente",1,'C',1,0);
            $pdf->MultiCell(15,5,"CAS",1,'C',1,0);
            $pdf->MultiCell(30,5,"Observaciones",1,'C',1,0);
            $pdf->MultiCell(20,5,"Firma",1,'C',1,0);
            $pdf->Ln();
        }
        $arrfila = array();   
        $rowcount = 0;
        $fill = 0;
        $rowcount = max($pdf->getNumLines(utf8_decode($row[14]),23),$pdf->getNumLines(utf8_decode($row[34]), 22),$pdf->getNumLines(utf8_decode($row[32]), 13),$pdf->getNumLines(utf8_decode($row[53]) . " " . utf8_decode($row[54]) . " - " . utf8_decode($row[57]) . " " . utf8_decode($row[58]) . " " . utf8_decode($row[55]) . " " . utf8_decode($row[56]), 45),$pdf->getNumLines(utf8_decode($row[42]) . " [" . utf8_decode($row[41]) . "]", 45),$pdf->getNumLines(utf8_decode($row[36]), 33),$pdf->getNumLines(utf8_decode($row[52]), 30)) * 2;
        $pdf->SetFont(PDF_FONT_NAME_MAIN, '', 7);
        if (utf8_decode($row[50])=='b')
        {
            $pdf->SetFillColor(241 , 194, 194);
            $fill = 0;
        }else{
            $fill = 0;
        }
        //Hora
        $pdf->writeHTMLCell(22, $rowcount, '', '', utf8_decode($row[34]), 0, 0, $fill, true, 'L', true);
        //$pdf->MultiCell(22,$rowcount,utf8_decode($row[34]),0,'L',$fill,0);
        //InfoAdd
        $pdf->writeHTMLCell(23, $rowcount, '', '', utf8_decode($row[14]), 0, 0, $fill, true, 'L', true);
        //$pdf->MultiCell(13,$rowcount,utf8_decode($row[32]),0,'L',$fill,0);
        //Paciente
        if (utf8_decode($row[54])==null || utf8_decode($row[54])=="")
        {
            $pdf->writeHTMLCell(45, $rowcount, '', '', utf8_decode($row[57]) . " " . utf8_decode($row[58]) . " " . utf8_decode($row[55]) . " " . utf8_decode($row[56]), 0, 0, $fill, true, 'L', true);
            //$pdf->MultiCell(45,$rowcount,utf8_decode($row[57]) . " " . utf8_decode($row[58]) . " " . utf8_decode($row[55]) . " " . utf8_decode($row[56]),0,'L',$fill,0);
        }
        else
        {
            $pdf->writeHTMLCell(45, $rowcount, '', '', utf8_decode($row[53]) . " " . utf8_decode($row[54]) . " - " . utf8_decode($row[57]) . " " . utf8_decode($row[58]) . " " . utf8_decode($row[55]) . " " . utf8_decode($row[56]), 0, 0, $fill, true, 'L', true);
            //$pdf->MultiCell(45,$rowcount,utf8_decode($row[53]) . " " . utf8_decode($row[54]) . " - " . utf8_decode($row[57]) . " " . utf8_decode($row[58]) . " " . utf8_decode($row[55]) . " " . utf8_decode($row[56]),0,'L',$fill,0);
        }
        //Tel
        $pdf->writeHTMLCell(30, $rowcount, '', '', utf8_decode($row[63]) . " " . utf8_decode($row[64]), 0, 0, $fill, true, 'L', true);
        //$pdf->MultiCell(30,10,utf8_decode($row[63]) . " " . utf8_decode($row[64]),0,'L',$fill,0);
        //Actividad
        if (utf8_decode($row[41]) == null || utf8_decode($row[41]) == "")
        {
            //$pdf->MultiCell(45,$rowcount,utf8_decode($row[42]),0,'L',$fill,0);
            $pdf->writeHTMLCell(45, $rowcount, '', '', utf8_decode($row[42]), 0, 0, $fill, true, 'L', true);
        }
        else
        {
            //$pdf->MultiCell(45,$rowcount,utf8_decode($row[42]) . " [" . utf8_decode($row[41]) . "]",0,'L',$fill,0);
            $pdf->writeHTMLCell(45, $rowcount, '', '', utf8_decode($row[42]) . " [" . utf8_decode($row[41]) . "]", 0, 0, $fill, true, 'L', true);
        }
        //Cliente
        //$pdf->MultiCell(33,$rowcount,utf8_decode($row[36]),0,'L',$fill,0);
        $pdf->writeHTMLCell(33, $rowcount, '', '', utf8_decode($row[36]), 0, 0, $fill, true, 'L', true);
        //Cas
        $pdf->writeHTMLCell(15, $rowcount, '', '', utf8_decode($row[40]), 0, 0, $fill, true, 'L', true);
        //$pdf->MultiCell(15,$rowcount,utf8_decode($row[40]),0,'L',$fill,0);
        //Onservaciones
        $pdf->writeHTMLCell(20, $rowcount, '', '', utf8_decode($row[52]), 0, 0, $fill, true, 'L', true);

        //Firma
        $pdf->MultiCell(20,$rowcount,"",'B','L',0,0);
        $controlAgenda = $row[18] . "-" . $row[22];
        $pdf->Ln();
        if ($pdf->GetY() < 180){
            $pdf->Ln();
        }else
        {
            $pdf->AddPage();
            $pdf->SetFont(PDF_FONT_NAME_MAIN,'B',11);
            $pdf->MultiCell(264,10,"Profesional: " . utf8_decode($row[16]) . " - " . utf8_decode($row[18]),0,'L',0,0);
            $pdf->Ln(4);
            $pdf->MultiCell(264,10,"Fecha: " . utf8_decode($row[22]) . " - Plantilla: " . utf8_decode($row[20]),0,'L',0,0);
            $pdf->Ln(2);
            //$pdf->MultiCell(264,10,"UBICACIÓN: " . utf8_decode($row[14]),0,'R',0,0);
            $pdf->MultiCell(264,10,"",0,'R',0,0);
            $pdf->Ln(4.5);
            $pdf->SetFillColor(242 , 236, 236);
            $pdf->SetFont(PDF_FONT_NAME_MAIN,'B',9);
            $pdf->MultiCell(22,5,utf8_decode("Hora"),1,'C',1,0);
            $pdf->MultiCell(23,5,"Ubicacion",1,'C',1,0);
            $pdf->MultiCell(45,5,"Paciente",1,'C',1,0);
            $pdf->MultiCell(30,5,"Teléfonos",1,'C',1,0);
            $pdf->MultiCell(45,5,"Actividad",1,'C',1,0);
            $pdf->MultiCell(33,5,"Cliente",1,'C',1,0);
            $pdf->MultiCell(15,5,"CAS",1,'C',1,0);
            $pdf->MultiCell(20,5,"Observa.",1,'C',1,0);
            $pdf->MultiCell(20,5,"Firma",1,'C',1,0);
            $pdf->Ln();
        }
    }
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    
    //CONTROL IMPRESION DE DOCUMENTOS
    $gBaseDatos = new ofiMySQLi();
    $gBaseDatos->conectar();
    $qry = "CALL sp_controlimpresion_add('" .  $_SESSION['ID_USUARIO'] . "',\"AGENDA CITAS\",null)";
    @mysqli_query($gBaseDatos->ConexionID, $qry);
    $gBaseDatos->liberar();
    $gBaseDatos->cerrar();
    
    $pdf->Output('AgendaxProfesional.pdf', 'I');

?>
