/*
* @category    Fieldset Vejez
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


fsMiniMental2022Ui = Ext.extend(Ext.form.FieldSet, {
    anchor: '100%',
    autoHeight: true,
    layout: 'form',
    title: 'TEST MINIMENTAL',
    collapseFirst: false,
    collapsible: true,
    animCollapse: true,
    titleCollapse: true,
    padding: 0,
    id: 'fsMiniMental',
    initComponent: function() {
        
        this.items = [
            {
                html:'NOTA: Escriba un punto por cada respuesta correcta '
            },
            {
                xtype: 'fieldset',
                title: 'ORIENTACION',
                layout: 'form',
                collapsible: true,
                titleCollapse: true,
                anchor: '100%',
                autoHeight: true,
                id: 'fsOrientacion',
                items: [
                    {
                        html:'¿QUÉ FECHA ES HOY? ESCRIBA UN PUNTO POR CADA RESPUESTA CORRECTA'
                    },
                    {   
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'numberfield',
                                width: 60,
                                minValue: 0,
                                maxValue: 1,
                                decimalPrecision: 2,
                                allowBlank: true,
                                fieldLabel: 'FECHA',
                                name:"FECHA",
                                emptyText: 'PUNTUACIÓN',
                                id: 'intMinimentalOriFecha'
                            },
                            {
                                html:'DÍA DE LA SEMANA'
                            },
                            {
                                xtype: 'numberfield',
                                width: 60,
                                minValue: 0,
                                maxValue: 1,
                                decimalPrecision: 2,
                                allowBlank: true,
                                name:"DÍA DE LA SEMANA",
                                emptyText: 'PUNTUACIÓN',
                                id: 'intMinimentalOriDiaSemana'
                            },
                            {
                                html:'DÍA DEL MES'
                            },
                            {
                                xtype: 'numberfield',
                                width: 60,
                                minValue: 0,
                                maxValue: 1,
                                emptyText: 'PUNTUACIÓN',
                                decimalPrecision: 2,
                                allowBlank: true,
                                name:"DÍA DE LA SEMANA",
                                id: 'intMinimentalOriDiaSemana'
                            },
                            {
                                html:'DÍA DEL MES'
                            },
                            {
                                xtype: 'numberfield',
                                width: 60,
                                minValue: 0,
                                maxValue: 1,
                                emptyText: 'PUNTUACIÓN',
                                decimalPrecision: 2,
                                allowBlank: true,
                                name:"DÍA DE LA SEMANA",
                                id: 'intMinimentalOriDiaSemana'
                            },
                            {
                                html:'AÑO'
                            },
                            {
                                xtype: 'numberfield',
                                width: 60,
                                minValue: 0,
                                maxValue: 1,
                                emptyText: 'PUNTUACIÓN',
                                decimalPrecision: 2,
                                allowBlank: true,
                                name:"AÑO",
                                id: 'intMinimentalOriAno'
                            },
                            {
                                html:'MAÑANA O TARDE'
                            },
                            {
                                xtype: 'numberfield',
                                width: 60,
                                minValue: 0,
                                maxValue: 1,
                                emptyText: 'PUNTUACIÓN',
                                decimalPrecision: 2,
                                allowBlank: true,
                                name:"MAÑANA O TARDE",
                                id: 'intMinimentalOriManTarde'
                            }
                        ]
                    },
                    {
                        html:'¿DÓNDE ESTAMOS?'
                    },
                    {   
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'numberfield',
                                width: 60,
                                minValue: 0,
                                maxValue: 1,
                                decimalPrecision: 2,
                                allowBlank: true,
                                fieldLabel: 'PAIS',
                                name:"PAIS",
                                emptyText: 'PUNTUACIÓN',
                                id: 'intMinimentalOriPais'
                            },
                            {
                                html:'DEPARTAMENTO'
                            },
                            {
                                xtype: 'numberfield',
                                width: 60,
                                minValue: 0,
                                maxValue: 1,
                                decimalPrecision: 2,
                                allowBlank: true,
                                name:"DEPARTAMENTO",
                                emptyText: 'PUNTUACIÓN',
                                id: 'intMinimentalOriDepartamento'
                            },
                            {
                                html:'CIUDAD'
                            },
                            {
                                xtype: 'numberfield',
                                width: 60,
                                minValue: 0,
                                maxValue: 1,
                                emptyText: 'PUNTUACIÓN',
                                decimalPrecision: 2,
                                allowBlank: true,
                                name:"CIUDAD",
                                id: 'intMinimentalOriCiudad'
                            },
                            {
                                html:'CENTRO DE ATENCIÓN AMBULATORIA'
                            },
                            {
                                xtype: 'numberfield',
                                width: 60,
                                minValue: 0,
                                maxValue: 1,
                                emptyText: 'PUNTUACIÓN',
                                decimalPrecision: 2,
                                allowBlank: true,
                                name:"CENTRO DE ATENCIÓN AMBULATORIA",
                                id: 'intMinimentalOriCenAteAmbulatoria'
                            },
                            {
                                html:'SERVICIO'
                            },
                            {
                                xtype: 'numberfield',
                                width: 60,
                                minValue: 0,
                                maxValue: 1,
                                emptyText: 'PUNTUACIÓN',
                                decimalPrecision: 2,
                                allowBlank: true,
                                name:"SERVICIO",
                                id: 'intMinimentalOriServicio'
                            },
                            {
                                html:'MAÑANA O TARDE'
                            },
                            {
                                xtype: 'numberfield',
                                width: 60,
                                minValue: 0,
                                maxValue: 1,
                                emptyText: 'PUNTUACIÓN',
                                decimalPrecision: 2,
                                allowBlank: true,
                                name:"MAÑANA O TARDE",
                                id: 'intMinimentalOriManTarde'
                            }
                        ]
                    }
                ]
            },
            {
                xtype: 'fieldset',
                title: 'FIJACIÓN',
                layout: 'form',
                collapsible: true,
                titleCollapse: true,
                anchor: '100%',
                autoHeight: true,
                labelWidth: 450,
                id: 'fsFijacion',
                items: [
                    {
                        html:'REPITA: SILLA, MESA, PARED, EMPLEANDO 1 SEGUNDO PARA DECIR CADA UNA. ESCRIBA UN PUNTO POR CADA UNA. LUEGO REPÍTALAS HASTA QUE EL PACIENTE LAS APRENDA. CUENTE LOS INTENTOS PARA HACERLO. NÚMERO DE INTENTOS'
                    },
                    {   
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'numberfield',
                                width: 60,
                                minValue: 0,
                                maxValue: 1,
                                decimalPrecision: 2,
                                allowBlank: true,
                                emptyText: 'PUNTUACIÓN',
                                fieldLabel: 'SILLA',
                                name:"SILLA",
                                id: 'intMinimentalFijSilla'
                            },
                            {
                                html:'MESA'
                            },
                            {
                                xtype: 'numberfield',
                                width: 60,
                                minValue: 0,
                                maxValue: 1,
                                decimalPrecision: 2,
                                allowBlank: true,
                                emptyText: 'PUNTUACIÓN',
                                fieldLabel: 'MESA',
                                name:"MESA",
                                id: 'intMinimentalFijSilla'
                            },
                            {
                                html:'PARED'
                            },
                            {
                                xtype: 'numberfield',
                                width: 60,
                                minValue: 0,
                                maxValue: 1,
                                decimalPrecision: 2,
                                allowBlank: true,
                                emptyText: 'PUNTUACIÓN',
                                fieldLabel: 'PARED',
                                name:"PARED",
                                id: 'intMinimentalFijPared'
                            },
                            {
                                html:'NUMERO DE INTENTOS'
                            },
                            {
                                xtype: 'numberfield',
                                width: 60,
                                minValue: 0,
                                maxValue: 255,
                                decimalPrecision: 2,
                                allowBlank: true,
                                emptyText: 'PUNTUACIÓN',
                                fieldLabel: 'NUMERO DE INTENTOS',
                                name:"NUMERO DE INTENTOS",
                                id: 'intMinimentalFijNumIntentos'
                            }
                        ]
                    }
                ]
            },
            {
                xtype: 'fieldset',
                title: 'ATENCIÓN Y CÁLCULO',
                layout: 'form',
                collapsible: true,
                titleCollapse: true,
                anchor: '100%',
                autoHeight: true,
                labelWidth: 450,
                id: 'fsAteCalculo',
                items: [
                    {
                        xtype: 'numberfield',
                        width: 60,
                        minValue: 0,
                        maxValue: 5,
                        decimalPrecision: 2,
                        allowBlank: true,
                        fieldLabel: 'SI TIENE 30 PESOS Y VA GASTANDO DE 3 EN 3 ¿CUÁNTO LE VA QUEDANDO?',
                        name:"SI TIENE 30 PESOS Y VA GASTANDO DE 3 EN 3 ¿CUÁNTO LE VA QUEDANDO?",
                        id: 'intMinimentalAteCalCuaQuedan'
                    },
                    {
                        html:'INTERRUMPA CUANDO LLEVE 5 RESTAS. SI LO ANTERIOR NO ES POSIBLE PÍDALE QUE DELETREE MUNDO AL REVÉS.'
                    },
                    {
                        xtype: 'numberfield',
                        width: 60,
                        minValue: 0,
                        maxValue: 5,
                        decimalPrecision: 2,
                        allowBlank: true,
                        name:"INTERRUMPA CUANDO LLEVE 5 RESTAS. SI LO ANTERIOR NO ES POSIBLE PÍDALE QUE DELETREE MUNDO AL REVÉS.",
                        id: 'intMinimentalAteCalMunReves'
                    }
                ]
            },
            {
                xtype: 'fieldset',
                title: 'MEMORIA',
                layout: 'form',
                collapsible: true,
                titleCollapse: true,
                anchor: '100%',
                autoHeight: true,
                labelWidth: 450,
                id: 'fsMemoria',
                items: [
                    {
                        xtype: 'numberfield',
                        width: 60,
                        minValue: 0,
                        maxValue: 3,
                        decimalPrecision: 2,
                        allowBlank: true,
                        fieldLabel: '¿RECUERDA LAS TRES PALABRAS QUE LE PEDÍ REPITIERA ANTES?',
                        name:"¿RECUERDA LAS TRES PALABRAS QUE LE PEDÍ REPITIERA ANTES?",
                        id: 'intMinimentalMemRecTrePalabras'
                    }
                ]
            },
            {
                xtype: 'fieldset',
                title: 'LENGUAJE Y PRAXIAS',
                layout: 'form',
                collapsible: true,
                titleCollapse: true,
                anchor: '100%',
                autoHeight: true,
                labelWidth: 450,
                id: 'fsLenPraxias',
                items: [
                    {
                        xtype: 'numberfield',
                        width: 60,
                        minValue: 0,
                        maxValue: 2,
                        decimalPrecision: 2,
                        allowBlank: true,
                        fieldLabel: 'MUÉSTRELE AL PACIENTE UN LAPICERO Y UN RELOJ. PÍDALE QUE LOS NOMBRE.',
                        name:"MUÉSTRELE AL PACIENTE UN LAPICERO Y UN RELOJ. PÍDALE QUE LOS NOMBRE.",
                        id: 'intMinimentalLenPraMuesPacLapReloj'
                    },
                    {
                        xtype: 'numberfield',
                        width: 60,
                        minValue: 0,
                        maxValue: 1,
                        decimalPrecision: 2,
                        allowBlank: true,
                        fieldLabel: 'REPITA LO SIGUIENTE: " PA, LE, TU, TRANS, CLA, BRA" O " TIGRE CONTRA TIGRE "',
                        name:'REPITA LO SIGUIENTE: "PA, LE, TU, TRANS, CLA, BRA O " TIGRE CONTRA TIGRE "',
                        id: 'intMinimentalLenPraTigConTig'
                    },
                    {
                        xtype: 'numberfield',
                        width: 60,
                        minValue: 0,
                        maxValue: 3,
                        decimalPrecision: 2,
                        allowBlank: true,
                        fieldLabel: 'PÍDALE QUE EJECUTE UNA ORDEN DE TRES PASOS: "COJA ESTE PAPEL CON LA MANO DERECHA, DÓBLELO POR LA MITAD Y PÓNGALO EN EL SUELO".',
                        name:'PÍDALE QUE EJECUTE UNA ORDEN DE TRES PASOS: "COJA ESTE PAPEL CON LA MANO DERECHA, DÓBLELO POR LA MITAD Y PÓNGALO EN EL SUELO".',
                        id: 'intMinimentalLenPraEjeOrdTrePasos'
                    },
                    {
                        xtype: 'numberfield',
                        width: 60,
                        minValue: 0,
                        maxValue: 1,
                        decimalPrecision: 2,
                        allowBlank: true,
                        fieldLabel: 'LEA Y OBEDEZCA LA SIGUIENTE ORDEN: "CIERRE LOS OJOS"',
                        name:'LEA Y OBEDEZCA LA SIGUIENTE ORDEN: "CIERRE LOS OJOS"',
                        id: 'intMinimentalLenPraLeaObeSigOrden'
                    },
                    {
                        xtype: 'numberfield',
                        width: 60,
                        minValue: 0,
                        maxValue: 1,
                        decimalPrecision: 2,
                        allowBlank: true,
                        fieldLabel: 'ESCRIBA UNA FRASE.',
                        name:'ESCRIBA UNA FRASE.',
                        id: 'intMinimentalLenPraEscFrase'
                    },
                    {
                        xtype: 'numberfield',
                        width: 60,
                        minValue: 0,
                        maxValue: 1,
                        decimalPrecision: 2,
                        allowBlank: true,
                        fieldLabel: 'COPIE ESTE DIBUJO',
                        name:'COPIE ESTE DIBUJO',
                        id: 'intMinimentalLenPraCopDibujo'
                    }
                ]
            }
        ];
        this.on({
            afterlayout:{
                scope:this, 
                single:true, 
                fn:function() {
                    /*var MyDate = new Date();
                    MyDate.setDate(MyDate.getDate() - 360);
                    Ext.getCmp('fecVejezValoracion').setMinValue(MyDate.format("d/m/Y"));
                    Ext.getCmp('fecVejezValoracion').setMaxValue(new Date().format("d/m/Y"));*/
                }
            }
        });
        fsMiniMental2022Ui.superclass.initComponent.call(this);
    }
});

