
/*
* @category    Fieldset Examen Fisico
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


fsExamenFisicoUi = Ext.extend(Ext.form.FieldSet, {
    anchor: '100%',
    autoHeight: true,
    layout: 'form',
    title: 'EXAMEN FISICO',
    collapseFirst: false,
    collapsible: true,
    animCollapse: true,
    titleCollapse: true,
    labelSeparator: '',
    padding: 0,
    id: 'fsExamenFisico',
    initComponent: function() {
        this.tbar = [
            {
                xtype: 'toolbar',
                anchor: '99%',
                items: [
                    '->',
                    {
                        xtype: 'button',
                        text: 'Peso',
                        tooltip: 'Ver Seguimiento del Peso del Paciente',
                        iconCls: 'btnGraficar',
                        listeners: {
                            click: function(){
                                viewSeguimientoTomaSignos(Ext.getCmp('sysIdPacienteHC').getValue(), "VerHistoricoPesoxPac","Fecha");
                            }
                        }
                    },
                    {
                        xtype: 'tbseparator'
                    },
                    {
                        xtype: 'button',
                        text: 'T.A.',
                        tooltip: 'Ver Seguimiento de la Presion Arterial del Paciente',
                        iconCls: 'btnGraficar',
                        listeners: {
                            click: function(){
                                viewSeguimientoTomaSignos(Ext.getCmp('sysIdPacienteHC').getValue(), "VerHistoricoTAxPac","Fecha");
                            }
                        }
                    },
                    {
                        xtype: 'tbseparator'
                    }
                ]
            }
        ];
        this.items = [
            {
                html: '<br>'
            },
            {
                xtype: 'compositefield',
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'numberfield',
                        fieldLabel: 'T.A. (Sentado)',
                        name: 'T.A. (Sentado) Sistolica',
                        width: 70,
                        minValue: 0,
                        maxValue: 300,
                        decimalPrecision: 0,
                        allowBlank: false,
                        emptyText: 'Sistolica',
                        id: 'intEXAFISTASentadoSistolica',
                        listeners: {
                            change : function( t, newValue, oldValue){
                                if(newValue !== "" && newValue !== null){
                                    if((parseInt(Ext.getCmp('intEXAFISTASentadoSistolica').getValue()) - parseInt(Ext.getCmp('intEXAFISTASentadoDiastolica').getValue())) < 20){
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Debe haber una diferencia minimo de 20 MMH/HG con respecto a la Siastolica',
                                            buttons: Ext.Msg.OK,
                                            icon: Ext.Msg.ERROR
                                        });
                                        Ext.getCmp('intEXAFISTASentadoSistolica').setValue(null);
                                    }
                                    Ext.getCmp('intRCV18_Sistolica').setValue(Ext.getCmp('intEXAFISTASentadoSistolica').getValue());
                                    calculoMetasIni2018();
                                    if(Ext.getCmp('sysGeneroPacHC').getValue() === "MASCULINO"){
                                        if(parseInt(Ext.getCmp('intEXAFISTASentadoSistolica').getValue()) < 120){
                                            CalculadoraPresionArterial = 0;
                                        }else{
                                            if(parseInt(Ext.getCmp('intEXAFISTASentadoSistolica').getValue()) > 120 && parseInt(Ext.getCmp('intEXAFISTASentadoSistolica').getValue()) < 129){
                                                CalculadoraPresionArterial = 0;
                                            }else{
                                                if(parseInt(Ext.getCmp('intEXAFISTASentadoSistolica').getValue()) > 130 && parseInt(Ext.getCmp('intEXAFISTASentadoSistolica').getValue()) <  139){
                                                    CalculadoraPresionArterial = 1;
                                                }else{
                                                    if(parseInt(Ext.getCmp('intEXAFISTASentadoSistolica').getValue()) > 140 && parseInt(Ext.getCmp('intEXAFISTASentadoSistolica').getValue()) < 159){
                                                        CalculadoraPresionArterial = 2;
                                                    }else{
                                                        if(parseInt(Ext.getCmp('intEXAFISTASentadoSistolica').getValue()) > 160){
                                                            CalculadoraPresionArterial = 3;
                                                        }else{
                                                            CalculadoraPresionArterial = 0;
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }else{
                                        if(Ext.getCmp('sysGeneroPacHC').getValue() === "FEMENINO"){
                                            if(parseInt(Ext.getCmp('intEXAFISTASentadoSistolica').getValue()) < 120){
                                                CalculadoraPresionArterial = -3;
                                            }else{
                                                if(parseInt(Ext.getCmp('intEXAFISTASentadoSistolica').getValue()) > 120 && parseInt(Ext.getCmp('intEXAFISTASentadoSistolica').getValue()) < 129){
                                                    CalculadoraPresionArterial = 0;
                                                }else{
                                                    if(parseInt(Ext.getCmp('intEXAFISTASentadoSistolica').getValue()) > 130 && parseInt(Ext.getCmp('intEXAFISTASentadoSistolica').getValue()) < 139){
                                                        CalculadoraPresionArterial = 0;
                                                    }else{
                                                        if(parseInt(Ext.getCmp('intEXAFISTASentadoSistolica').getValue()) > 140 && parseInt(Ext.getCmp('intEXAFISTASentadoSistolica').getValue()) < 140){
                                                            CalculadoraPresionArterial = 2;
                                                        }else{
                                                            if(parseInt(Ext.getCmp('intEXAFISTASentadoSistolica').getValue()) > 160){
                                                                CalculadoraPresionArterial = 3;
                                                            }else{
                                                                CalculadoraPresionArterial = 0;
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }else{
                                            CalculadoraPresionArterial = 0;
                                        }
                                    }
                                    calculadoraRiesgo();
                                }
                            }
                        }
                    },
                    {
                        html: '/'
                    },
                    {
                        xtype: 'numberfield',
                        name: 'T.A. (Sentado) Diastolica',
                        width: 70,
                        minValue: 0,
                        maxValue: 300,
                        decimalPrecision: 0,
                        allowBlank: false,
                        emptyText: 'Diastolica',
                        id: 'intEXAFISTASentadoDiastolica',
                        listeners: {
                            change : function( t, newValue, oldValue){
                                if(newValue !== "" && newValue !== null){
                                    if((parseInt(Ext.getCmp('intEXAFISTASentadoSistolica').getValue()) - parseInt(Ext.getCmp('intEXAFISTASentadoDiastolica').getValue())) < 20){
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Debe haber una diferencia minimo de 20 MMH/HG con respecto a la Diastolica',
                                            buttons: Ext.Msg.OK,
                                            icon: Ext.Msg.ERROR
                                        });
                                        Ext.getCmp('intEXAFISTASentadoDiastolica').setValue(null);
                                    }
                                    Ext.getCmp('intRCV18_Diastolica').setValue(Ext.getCmp('intEXAFISTASentadoDiastolica').getValue());
                                    calculoMetasIni2018();
                                    if(Ext.getCmp('sysGeneroPacHC').getValue() === "MASCULINO"){
                                        if(parseInt(Ext.getCmp('intEXAFISTASentadoDiastolica').getValue()) < 80){
                                            CalculadoraPresionArterial = 0;
                                        }else{
                                            if(parseInt(Ext.getCmp('intEXAFISTASentadoDiastolica').getValue()) > 80 && parseInt(Ext.getCmp('intEXAFISTASentadoDiastolica').getValue()) < 84){
                                                CalculadoraPresionArterial = 0;
                                            }else{
                                                if(parseInt(Ext.getCmp('intEXAFISTASentadoDiastolica').getValue()) > 85 && parseInt(Ext.getCmp('intEXAFISTASentadoDiastolica').getValue()) < 89){
                                                    CalculadoraPresionArterial = 1;
                                                }else{
                                                    if(parseInt(Ext.getCmp('intEXAFISTASentadoDiastolica').getValue()) > 90 && parseInt(Ext.getCmp('intEXAFISTASentadoDiastolica').getValue()) < 99){
                                                        CalculadoraPresionArterial = 2;
                                                    }else{
                                                        if(parseInt(Ext.getCmp('intEXAFISTASentadoDiastolica').getValue()) > 100){
                                                            CalculadoraPresionArterial = 3;
                                                        }else{
                                                            CalculadoraPresionArterial = 0;
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }else{
                                        if(Ext.getCmp('sysGeneroPacHC').getValue() === "FEMENINO"){
                                            if(parseInt(Ext.getCmp('intEXAFISTASentadoDiastolica').getValue()) < 80){
                                                CalculadoraPresionArterial = -3;
                                            }else{
                                                if(parseInt(Ext.getCmp('intEXAFISTASentadoDiastolica').getValue()) > 80 && parseInt(Ext.getCmp('intEXAFISTASentadoDiastolica').getValue()) < 84){
                                                    CalculadoraPresionArterial = 0;
                                                }else{
                                                    if(parseInt(Ext.getCmp('intEXAFISTASentadoDiastolica').getValue()) > 85 && parseInt(Ext.getCmp('intEXAFISTASentadoDiastolica').getValue()) < 89){
                                                        CalculadoraPresionArterial = 0;
                                                    }else{
                                                        if(parseInt(Ext.getCmp('intEXAFISTASentadoDiastolica').getValue()) > 90 && parseInt(Ext.getCmp('intEXAFISTASentadoDiastolica').getValue()) < 99){
                                                            CalculadoraPresionArterial = 2;
                                                        }else{
                                                            if(parseInt(Ext.getCmp('intEXAFISTASentadoDiastolica').getValue()) > 100){
                                                                CalculadoraPresionArterial = 3;
                                                            }else{
                                                                CalculadoraPresionArterial = 0;
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }else{
                                            CalculadoraPresionArterial = 0;
                                        }
                                    }
                                    calculadoraRiesgo();
                                }
                            }
                        }
                    },
                    {
                        html: 'Ultimo Control: - T.A. (Sentado):',
                        style: 'color: red;'
                    },
                    {
                        xtype: 'textfield',
                        name: 'T.A. (Sentado) Sistolica',
                        width: 70,
                        allowBlank: true,
                        readOnly: true,
                        style: 'color: red;',
                        id: 'sysEXAFISTASentadoSistolica'
                    },
                    {
                        html: '/'
                    },
                    {
                        xtype: 'textfield',
                        name: 'T.A. (Sentado) Diastolica',
                        width: 70,
                        allowBlank: true,
                        readOnly: true,
                        style: 'color: red;',
                        id: 'sysEXAFISTASentadoDiastolica'
                    }
                ]
            },
            {
                xtype: 'compositefield',
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'numberfield',
                        fieldLabel: 'T.A. (de Pie)',
                        name: 'T.A. (de Pie)',
                        width: 70,
                        minValue: 0,
                        maxValue: 300,
                        decimalPrecision: 0,
                        allowBlank: false,
                        emptyText: 'Sistolica',
                        id: 'intEXAFISTAdePieSistolica',
                        listeners: {
                            change : function( t, newValue, oldValue){
                                if(newValue !== "" && newValue !== null){
                                    if((parseInt(Ext.getCmp('intEXAFISTAdePieSistolica').getValue()) - parseInt(Ext.getCmp('intEXAFISTAdePieDiastolica').getValue())) < 20){
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Debe haber una diferencia minimo de 20 MMH/HG con respecto a la Siastolica',
                                            buttons: Ext.Msg.OK,
                                            icon: Ext.Msg.ERROR
                                        });
                                        Ext.getCmp('intEXAFISTAdePieSistolica').setValue(null);
                                    }
                                }
                            }
                        }
                    },
                    {
                        html: '/'
                    },
                    {
                        xtype: 'numberfield',
                        name: 'T.A. (de Pie) Diastolica',
                        width: 70,
                        minValue: 0,
                        maxValue: 300,
                        decimalPrecision: 0,
                        allowBlank: false,
                        emptyText: 'Diastolica',
                        id: 'intEXAFISTAdePieDiastolica',
                        listeners: {
                            change : function( t, newValue, oldValue){
                                if(newValue !== "" && newValue !== null){
                                    if((parseInt(Ext.getCmp('intEXAFISTAdePieSistolica').getValue()) - parseInt(Ext.getCmp('intEXAFISTAdePieDiastolica').getValue())) < 20){
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Debe haber una diferencia minimo de 20 MMH/HG con respecto a la Diastolica',
                                            buttons: Ext.Msg.OK,
                                            icon: Ext.Msg.ERROR
                                        });
                                        Ext.getCmp('intEXAFISTAdePieDiastolica').setValue(null);
                                    }
                                }
                            }
                        }
                    },
                    {
                        html: 'Ultimo Control: - T.A. (de Pie):',
                        style: 'color: red;'
                    },
                    {
                        xtype: 'textfield',
                        name: 'T.A. (de Pie) Sistolica',
                        width: 70,
                        allowBlank: true,
                        readOnly: true,
                        style: 'color: red;',
                        id: 'sysEXAFISTAdePieSistolica'
                    },
                    {
                        html: '/'
                    },
                    {
                        xtype: 'textfield',
                        name: 'T.A. (de Pie) Diastolica',
                        width: 70,
                        allowBlank: true,
                        readOnly: true,
                        style: 'color: red;',
                        id: 'sysEXAFISTAdePieDiastolica'
                    }
                ]
            },
            {
                xtype: 'compositefield',
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'numberfield',
                        width: 60,
                        minValue: 0,
                        maxValue: 250,
                        decimalPrecision: 2,
                        allowBlank: false,
                        fieldLabel: 'TALLA (cm)',
                        name:"TALLA (cm)",
                        emptyText: '(cm)',
                        id: 'intEXAFISTalla',
                        listeners:{
                            change : function(f,pNew, pOld){
                                if(pNew == null || pNew == 0){
                                    Ext.getCmp('intEXAFISTalla').setValue(null);
                                    Ext.getCmp('intEXAFISIMC').setValue(0);
                                }else{
                                    if(Ext.getCmp('intEXAFISPeso').getValue() > 0){
                                        var pTalla = Ext.getCmp('intEXAFISTalla').getValue() / 100;
                                        Ext.getCmp('intEXAFISIMC').setValue(Ext.getCmp('intEXAFISPeso').getValue()/(pTalla*pTalla));
                                    }else{
                                        Ext.getCmp('intEXAFISIMC').setValue(0);
                                    }
                                }
                               if(Ext.getCmp('intEXAFISIMC').getValue()<1){
                                   Ext.getCmp('strEXAFISIMCClasificacon').setValue(null);
                                }else{
                                    if(Ext.getCmp('intEXAFISIMC').getValue() < 16.00){
                                       Ext.getCmp('strEXAFISIMCClasificacon').setValue("DELGADEZ SEVERA");
                                    }else{
                                        if(Ext.getCmp('intEXAFISIMC').getValue()<=16.90 && Ext.getCmp('intEXAFISIMC').getValue()>=16.00){
                                           Ext.getCmp('strEXAFISIMCClasificacon').setValue("DELGADEZ MODERADA");
                                        }else{
                                            if(Ext.getCmp('intEXAFISIMC').getValue()<=18.49 && Ext.getCmp('intEXAFISIMC').getValue()>=17.00){
                                               Ext.getCmp('strEXAFISIMCClasificacon').setValue("DELGADEZ ACEPTABLE");
                                            }else{
                                                if(Ext.getCmp('intEXAFISIMC').getValue()<=24.99 && Ext.getCmp('intEXAFISIMC').getValue()>=18.50){
                                                   Ext.getCmp('strEXAFISIMCClasificacon').setValue("NORMAL");
                                                }else{
                                                    if(Ext.getCmp('intEXAFISIMC').getValue()<=29.99 && Ext.getCmp('intEXAFISIMC').getValue()>=25.00){
                                                       Ext.getCmp('strEXAFISIMCClasificacon').setValue("PREOBESO");
                                                    }else{
                                                        if(Ext.getCmp('intEXAFISIMC').getValue()<=34.99 && Ext.getCmp('intEXAFISIMC').getValue()>=30.00){
                                                           Ext.getCmp('strEXAFISIMCClasificacon').setValue("OBESO TIPO I");
                                                        }else{
                                                            if(Ext.getCmp('intEXAFISIMC').getValue()<=39.99 && Ext.getCmp('intEXAFISIMC').getValue()>=35.00){
                                                               Ext.getCmp('strEXAFISIMCClasificacon').setValue("OBESO TIPO II");
                                                            }else{
                                                                if(Ext.getCmp('intEXAFISIMC').getValue()>=40.00){
                                                                Ext.getCmp('strEXAFISIMCClasificacon').setValue("OBESO TIPO III");
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                                Ext.getCmp('intRCV18_Talla').setValue(Ext.getCmp('intEXAFISTalla').getValue());
                                Ext.getCmp('intRCV18_Peso').setValue(Ext.getCmp('intEXAFISPeso').getValue());
                                Ext.getCmp('intRCV18_IMC').setValue(Ext.getCmp('intEXAFISIMC').getValue());
                                
                                if(parseInt(Ext.getCmp('intRCV18_IMC').getValue()) >= 25){
                                    if(parseInt(Ext.getCmp('intRCV18_Peso').getValue()) >= parseInt(Ext.getCmp('sysEXAFISPesoAnt').getValue())){
                                        Ext.Msg.show({
                                            title: 'NO CUMPLE META TERAPEUTICA',
                                            msg: 'El paciente no evidencia perdida en el peso, verifique el peso y/o de indicaciones claras al paciente para seguir las recomensaciones nutricionales',
                                            buttons: Ext.Msg.OK,
                                            icon: Ext.Msg.ERROR
                                        });
                                    }
                                }else{
                                    if(parseInt(Ext.getCmp('intRCV18_Peso').getValue()) > parseInt(Ext.getCmp('sysEXAFISPesoAnt').getValue())){
                                        Ext.Msg.show({
                                            title: 'NO CUMPLE META TERAPEUTICA',
                                            msg: 'El paciente no evidencia perdida en el peso, verifique el peso y/o de indicaciones claras al paciente para seguir las recomensaciones nutricionales',
                                            buttons: Ext.Msg.OK,
                                            icon: Ext.Msg.ERROR
                                        });
                                    }
                                }
                                calculoMetasIni2018();
                            }
                        }
                    },
                    {
                        xtype: 'displayfield',
                        id: 'sysEXAFISPeso',
                        value: 'PESO (Kg) '
                    },
                    {
                        xtype: 'numberfield',
                        width: 60,
                        minValue: 0,
                        maxValue: 250,
                        decimalPrecision: 2,
                        allowBlank: false,
                        emptyText: '(Kg)',
                        name:"PESO (Kg)",
                        id: 'intEXAFISPeso',
                        listeners:{
                            change : function(f,pNew, pOld){
                                if(pNew == null || pNew == 0){
                                    Ext.getCmp('intEXAFISPeso').setValue(null);
                                    Ext.getCmp('intEXAFISIMC').setValue(0);
                                }else{
                                    //peso [kg]/ estatura [m2]
                                    if(Ext.getCmp('intEXAFISTalla').getValue() > 0){
                                        var pTalla = Ext.getCmp('intEXAFISTalla').getValue() / 100;
                                        Ext.getCmp('intEXAFISIMC').setValue(Ext.getCmp('intEXAFISPeso').getValue()/(pTalla*pTalla));
                                    }else{
                                        Ext.getCmp('intEXAFISIMC').setValue(0);
                                    }
                                }
                                if(Ext.getCmp('intEXAFISIMC').getValue()<1){
                                   Ext.getCmp('strEXAFISIMCClasificacon').setValue(null);
                                }else{
                                    if(Ext.getCmp('intEXAFISIMC').getValue() < 16.00){
                                       Ext.getCmp('strEXAFISIMCClasificacon').setValue("DELGADEZ SEVERA");
                                    }else{
                                        if(Ext.getCmp('intEXAFISIMC').getValue()<=16.90 && Ext.getCmp('intEXAFISIMC').getValue()>=16.00){
                                           Ext.getCmp('strEXAFISIMCClasificacon').setValue("DELGADEZ MODERADA");
                                        }else{
                                            if(Ext.getCmp('intEXAFISIMC').getValue()<=18.49 && Ext.getCmp('intEXAFISIMC').getValue()>=17.00){
                                               Ext.getCmp('strEXAFISIMCClasificacon').setValue("DELGADEZ ACEPTABLE");
                                            }else{
                                                if(Ext.getCmp('intEXAFISIMC').getValue()<=24.99 && Ext.getCmp('intEXAFISIMC').getValue()>=18.50){
                                                   Ext.getCmp('strEXAFISIMCClasificacon').setValue("NORMAL");
                                                }else{
                                                    if(Ext.getCmp('intEXAFISIMC').getValue()<=29.99 && Ext.getCmp('intEXAFISIMC').getValue()>=25.00){
                                                       Ext.getCmp('strEXAFISIMCClasificacon').setValue("PREOBESO");
                                                    }else{
                                                        if(Ext.getCmp('intEXAFISIMC').getValue()<=34.99 && Ext.getCmp('intEXAFISIMC').getValue()>=30.00){
                                                           Ext.getCmp('strEXAFISIMCClasificacon').setValue("OBESO TIPO I");
                                                        }else{
                                                            if(Ext.getCmp('intEXAFISIMC').getValue()<=39.99 && Ext.getCmp('intEXAFISIMC').getValue()>=35.00){
                                                               Ext.getCmp('strEXAFISIMCClasificacon').setValue("OBESO TIPO II");
                                                            }else{
                                                                if(Ext.getCmp('intEXAFISIMC').getValue()>=40.00){
                                                                Ext.getCmp('strEXAFISIMCClasificacon').setValue("OBESO TIPO III");
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                                Ext.getCmp('intRCV18_Talla').setValue(Ext.getCmp('intEXAFISTalla').getValue());
                                Ext.getCmp('intRCV18_Peso').setValue(Ext.getCmp('intEXAFISPeso').getValue());
                                Ext.getCmp('intRCV18_IMC').setValue(Ext.getCmp('intEXAFISIMC').getValue());
                                
                                if(parseInt(Ext.getCmp('intRCV18_IMC').getValue()) >= 25){
                                    if(parseInt(Ext.getCmp('intRCV18_Peso').getValue()) >= parseInt(Ext.getCmp('sysEXAFISPesoAnt').getValue())){
                                        Ext.Msg.show({
                                            title: 'NO CUMPLE META TERAPEUTICA',
                                            msg: 'El paciente no evidencia perdida en el peso, verifique el peso y/o de indicaciones claras al paciente para seguir las recomensaciones nutricionales',
                                            buttons: Ext.Msg.OK,
                                            icon: Ext.Msg.ERROR
                                        });
                                    }
                                }else{
                                    if(parseInt(Ext.getCmp('intRCV18_Peso').getValue()) > parseInt(Ext.getCmp('sysEXAFISPesoAnt').getValue())){
                                        Ext.Msg.show({
                                            title: 'NO CUMPLE META TERAPEUTICA',
                                            msg: 'El paciente no evidencia perdida en el peso, verifique el peso y/o de indicaciones claras al paciente para seguir las recomensaciones nutricionales',
                                            buttons: Ext.Msg.OK,
                                            icon: Ext.Msg.ERROR
                                        });
                                    }
                                }
                                calcularTFG();
                                calculoMetasIni2018();
                            }
                        }
                    },
                    {
                        html: 'Ultimo:',
                        style: 'color: red;'
                    },
                    {
                        xtype: 'textfield',
                        name: 'Peso Anterior',
                        width: 70,
                        allowBlank: true,
                        readOnly: true,
                        style: 'color: red;',
                        id: 'sysEXAFISPesoAnt'
                    },
                    {
                        xtype: 'displayfield',
                        id: 'sysEXAFISIMC',
                        value: 'IMC '
                    },
                    {
                        xtype: 'numberfield',
                        width: 60,
                        minValue: 0,
                        decimalPrecision: 2,
                        allowBlank: false,
                        readOnly: true,
                        name: "IMC",
                        id: 'intEXAFISIMC'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: false,
                        readOnly: true,
                        name: "IMC - CLASIFICACION",
                        id: 'strEXAFISIMCClasificacon'
                    },
                    {
                        xtype: 'displayfield',
                        id: 'sysEXAFISPA',
                        value: 'P. Abd.'
                    },
                    {
                        xtype: 'numberfield',
                        width: 60,
                        minValue: 0,
                        decimalPrecision: 2,
                        name: 'Perimetro Abdominal',
                        allowBlank: false,
                        id: 'strEXAFISPA',
                        listeners:{
                            change : function(f,pNew, pOld){
                                if(pNew == null || pNew == 0){
                                    Ext.getCmp('strEXAFISPA').setValue(null);
                                }
                                Ext.getCmp('intRCV18_CircunferenciaAbd').setValue(Ext.getCmp('strEXAFISPA').getValue());
                                calculoMetasIni2018();
                            }
                        }
                    }
                ]
            },
            {
                xtype: 'compositefield',
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'numberfield',
                        fieldLabel: 'Temp',
                        width: 60,
                        minValue: 0,
                        decimalPrecision: 2,
                        name: 'Temperatura',
                        allowBlank: false,
                        id: 'intEXAFISTemp'
                    },
                    {
                        html: 'F.C.'
                    },                                                            
                    {
                        xtype: 'numberfield',
                        width: 60,
                        minValue: 0,
                        decimalPrecision: 2,
                        name: 'FC',
                        allowBlank: false,
                        id: 'intEXAFISFC'
                    },
                    {
                        html: 'F.R.'
                    },                                                            
                    {
                        xtype: 'numberfield',
                        width: 60,
                        minValue: 0,
                        decimalPrecision: 2,
                        name: 'FR',
                        allowBlank: false,
                        id: 'intEXAFISFR'
                    },
                    {
                        html: 'SpO2.'
                    },                                                            
                    {
                        xtype: 'numberfield',
                        width: 60,
                        minValue: 0,
                        decimalPrecision: 0,
                        name: 'SpO2',
                        allowBlank: false,
                        id: 'intEXAFISSpO2'
                    }
                ]
            },
            {
                xtype: 'textfield',
                anchor: '100%',
                fieldLabel: 'Piel y Anexos',
                name: 'Piel y Anexos',
                allowBlank: false,
                id: 'strEXAFISPielyAnexos',
                listeners: {
                    render: function( p ) {
                        p.getEl().on('dblclick', function (){
                            Ext.getCmp('strEXAFISPielyAnexos').setValue("Normal");
                        });
                    }
                }
            },
            {
                xtype: 'textfield',
                anchor: '100%',
                fieldLabel: 'Cabeza',
                name: 'Cabeza',
                allowBlank: false,
                id: 'strEXAFISCabeza',
                listeners: {
                    render: function( p ) {
                        p.getEl().on('dblclick', function (){
                            Ext.getCmp('strEXAFISCabeza').setValue("Normal");
                        });
                    }
                }

            },    
            {
                xtype: 'textfield',
                anchor: '100%',
                fieldLabel: 'Ojos',
                name: 'Ojos',
                allowBlank: false,
                id: 'strEXAFISOjos',
                listeners: {
                    render: function( p ) {
                        p.getEl().on('dblclick', function (){
                            Ext.getCmp('strEXAFISOjos').setValue("Normal");
                        });
                    }
                }
            },
            {
                xtype: 'textfield',
                anchor: '100%',
                fieldLabel: 'Fondo de Ojo',
                name: 'Fondo Ojo',
                allowBlank: false,
                id: 'strEXAFISFondoOjo',
                listeners: {
                    render: function( p ) {
                        p.getEl().on('dblclick', function (){
                            Ext.getCmp('strEXAFISFondoOjo').setValue("Normal");
                        });
                    }
                }
            },
            {
                xtype: 'textfield',
                anchor: '100%',
                fieldLabel: 'ORL',
                name: 'ORL',
                allowBlank: false,
                id: 'strEXAFISORL',
                listeners: {
                    render: function( p ) {
                        p.getEl().on('dblclick', function (){
                            Ext.getCmp('strEXAFISORL').setValue("Normal");
                        });
                    }
                }
            },
            /*{
                xtype: 'textfield',
                anchor: '100%',
                fieldLabel: 'Orofaringe',
                name: 'Orofaringe',
                allowBlank: false,
                id: 'strEXAFISOrofaringe',
                listeners: {
                    render: function( p ) {
                        p.getEl().on('dblclick', function (){
                            Ext.getCmp('strEXAFISOrofaringe').setValue("Normal");
                        });
                    }
                }
            },*/
            {
                xtype: 'textfield',
                anchor: '100%',
                fieldLabel: 'Cuello',
                name: 'Cuello',
                allowBlank: false,
                id: 'strEXAFISCuello',
                listeners: {
                    render: function( p ) {
                        p.getEl().on('dblclick', function (){
                            Ext.getCmp('strEXAFISCuello').setValue("Normal");
                        });
                    }
                }
            },
            {
                xtype: 'textfield',
                anchor: '100%',
                fieldLabel: 'Valoracion Mamaria',
                name: 'Valoracion Mamaria',
                allowBlank: false,
                id: 'strEXAFISValoracionMamaria',
                listeners: {
                    render: function( p ) {
                        p.getEl().on('dblclick', function (){
                            Ext.getCmp('strEXAFISValoracionMamaria').setValue("Normal");
                        });
                    }
                }
            },            
            {
                xtype: 'textfield',
                anchor: '100%',
                fieldLabel: 'Dorso-Lumbar',
                name: 'Dorso-Lumbar',
                allowBlank: false,
                id: 'strEXAFISDorso',
                listeners: {
                    render: function( p ) {
                        p.getEl().on('dblclick', function (){
                            Ext.getCmp('strEXAFISDorso').setValue("Normal");
                        });
                    }
                }
            },
            {
                xtype: 'textfield',
                anchor: '100%',
                fieldLabel: 'Cardio-Pulmonar',
                name: 'Cardio-Pulmonar',
                allowBlank: false,
                id: 'strEXAFISCardioPulmonar',
                listeners: {
                    render: function( p ) {
                        p.getEl().on('dblclick', function (){
                            Ext.getCmp('strEXAFISCardioPulmonar').setValue("Normal");
                        });
                    }
                }
            },
            {
                xtype: 'textfield',
                anchor: '100%',
                fieldLabel: 'Abdomen',
                name: 'Abdomen',
                allowBlank: false,
                id: 'strEXAFISAbdomen',
                listeners: {
                    render: function( p ) {
                        p.getEl().on('dblclick', function (){
                            Ext.getCmp('strEXAFISAbdomen').setValue("Normal");
                        });
                    }
                }
            },
            {
                xtype: 'textfield',
                anchor: '100%',
                fieldLabel: 'Genitales',
                name: 'Genitales',
                allowBlank: false,
                id: 'strEXAFISGenitales',
                listeners: {
                    render: function( p ) {
                        p.getEl().on('dblclick', function (){
                            Ext.getCmp('strEXAFISGenitales').setValue("Normal");
                        });
                    }
                }
            },
            {
                xtype: 'textfield',
                anchor: '100%',
                fieldLabel: 'Extremidades',
                name: 'Extremidades',
                allowBlank: false,
                id: 'strEXAFISExtremidades',
                listeners: {
                    render: function( p ) {
                        p.getEl().on('dblclick', function (){
                            Ext.getCmp('strEXAFISExtremidades').setValue("Normal");
                        });
                    }
                }
            },
            {
                xtype: 'textfield',
                anchor: '100%',
                fieldLabel: 'Neurologico',
                name: 'Neurologico',
                allowBlank: false,
                id: 'strEXAFISNeurologico',
                listeners: {
                    render: function( p ) {
                        p.getEl().on('dblclick', function (){
                            Ext.getCmp('strEXAFISNeurologico').setValue("Normal");
                        });
                    }
                }
            },
            {
                xtype: 'fieldset',
                title: 'Asesoria Pre y Post VIH',
                layout: 'form',
                collapseFirst: false,
                collapsible: true,
                animCollapse: true,
                titleCollapse: true,
                anchor: '100%',
                autoHeight: true,
                padding: 5,
                labelWidth: 180,
                items: [
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'combo',
                                fieldLabel: 'Va a Realizar Asesoria Pre-Test',
                                width: 60,
                                allowBlank: true,
                                forceSelection: true,
                                mode: 'local',
                                typeAhead: true,
                                typeAheadDelay: 50,
                                listEmptyText: '',
                                triggerAction: 'all',
                                store:'StoreSiNo',
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                name:'Se Hace Asesoria Pre-Test VIH',
                                id: 'strAsesoriaPreTestVIH'
                            },
                            {
                                html: 'Va a Realizar Asesoria Post-Test:'
                            },
                            {
                                xtype: 'combo',
                                width: 60,
                                allowBlank: true,
                                forceSelection: true,
                                mode: 'local',
                                typeAhead: true,
                                typeAheadDelay: 50,
                                listEmptyText: '',
                                triggerAction: 'all',
                                store:'StoreSiNo',
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                name:'Se Hace Asesoria Post-Test VIH',
                                id: 'strAsesoriaPostTestVIH'
                            }
                        ]
                    }
                ]
            },
            {
                html: '<br><hr><br>'
            },
            {
                xtype: 'panel',
                layout: 'form',
                anchor: '100%',
                autoHeight: true,
                padding: 5,
                labelWidth: 400,
                items: [
                    {
                        xtype: 'combo',
                        //fieldLabel: 'Ha tenido tos u otros sintomas respiratorios en los ultimos 15 dias?',
                        //name: 'Ha tenido tos u otros sintomas respiratorios en los ultimos 15 dias?',
                        fieldLabel: 'HA TENIDO TOS CON EXPECTORACION EN LOS ÚLTIMOS 15 DÍAS ?',
                        name: 'HA TENIDO TOS CON EXPECTORACION EN LOS ÚLTIMOS 15 DÍAS ?',
                        width: 60,
                        allowBlank: false,
                        store: 'StoreSiNo',
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        mode: 'local',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 10,
                        triggerAction: 'all',
                        id: 'strBaciloscopia',
                        listeners:{
                            change : function( t, newValue, oldValue){
                                if(newValue === "SI"){
                                    Ext.Msg.show({
                                        title: 'eOfiClinic',
                                        msg: 'ESTA SEGURO QUE HA TENIDO TOS CON EXPECTORACION EN LOS ÚLTIMOS 15 DÍAS?',
                                        buttons: Ext.Msg.YESNO,
                                        icon: Ext.Msg.QUESTION,
                                        fn: function(btn){
                                            if(btn=="yes"){
                                                //Adicionar Solicitud de la mamografia
                                                if(parseInt(Ext.getCmp('sysSolicitaBaciloscopia').getValue()) === 0){
                                                    Ext.getCmp('sysSolicitaBaciloscopia').setValue(1);
                                                }
                                            }else{
                                                Ext.getCmp('sysSolicitaBaciloscopia').setValue(0);
                                                Ext.getCmp('strBaciloscopia').setValue("NO");
                                                // Borrar Solicitud de la Baciloscopia
                                                Ext.Ajax.request({
                                                    url: '../../controlador/asistencial/evolucionhc2015.php',
                                                    params:{
                                                        task: 'BORRAR_SERVICIOS_ANTECEDENTES',
                                                        pCodProced: "901101",
                                                        pCAS: Ext.getCmp('sysCASHC').getValue()
                                                    },
                                                    success: function(response,options)
                                                    {
                                                        var el = Ext.get('response'); // get the LOG
                                                        var Respuesta = response.responseText;
                                                        var Contenido = Respuesta.split('^');
                                                        if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                            //
                                                        } else {
                                                            Ext.getCmp('gridExamenesHC').store.reload();
                                                            Ext.getCmp('sysSolicitaBaciloscopia').setValue(0);
                                                        }
                                                    },
                                                    failure: function(response,options){
                                                        //
                                                    },
                                                    scope:this
                                                });
                                                // Borrar Solicitud de la Cultivo
                                                Ext.Ajax.request({
                                                    url: '../../controlador/asistencial/evolucionhc2015.php',
                                                    params:{
                                                        task: 'BORRAR_SERVICIOS_ANTECEDENTES',
                                                        pCodProced: "901230",
                                                        pCAS: Ext.getCmp('sysCASHC').getValue()
                                                    },
                                                    success: function(response,options)
                                                    {
                                                        var el = Ext.get('response'); // get the LOG
                                                        var Respuesta = response.responseText;
                                                        var Contenido = Respuesta.split('^');
                                                        if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                            //
                                                        } else {
                                                            Ext.getCmp('gridExamenesHC').store.reload();
                                                            Ext.getCmp('sysSolicitaBaciloscopia').setValue(0);
                                                        }
                                                    },
                                                    failure: function(response,options){
                                                        //
                                                    },
                                                    scope:this
                                                });
                                            }
                                        }
                                    });
                                    
                                }else{  
                                    // Borrar Solicitud de la Baciloscopia
                                    Ext.Ajax.request({
                                        url: '../../controlador/asistencial/evolucionhc2015.php',
                                        params:{
                                            task: 'BORRAR_SERVICIOS_ANTECEDENTES',
                                            pCodProced: "901101",
                                            pCAS: Ext.getCmp('sysCASHC').getValue()
                                        },
                                        success: function(response,options)
                                        {
                                            var el = Ext.get('response'); // get the LOG
                                            var Respuesta = response.responseText;
                                            var Contenido = Respuesta.split('^');
                                            if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                //
                                            } else {
                                                Ext.getCmp('gridExamenesHC').store.reload();
                                                Ext.getCmp('sysSolicitaBaciloscopia').setValue(0);
                                            }
                                        },
                                        failure: function(response,options){
                                            //
                                        },
                                        scope:this
                                    });
                                    // Borrar Solicitud de la Cultivo
                                    Ext.Ajax.request({
                                        url: '../../controlador/asistencial/evolucionhc2015.php',
                                        params:{
                                            task: 'BORRAR_SERVICIOS_ANTECEDENTES',
                                            pCodProced: "901230",
                                            pCAS: Ext.getCmp('sysCASHC').getValue()
                                        },
                                        success: function(response,options)
                                        {
                                            var el = Ext.get('response'); // get the LOG
                                            var Respuesta = response.responseText;
                                            var Contenido = Respuesta.split('^');
                                            if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                //
                                            } else {
                                                Ext.getCmp('gridExamenesHC').store.reload();
                                                Ext.getCmp('sysSolicitaBaciloscopia').setValue(0);
                                            }
                                        },
                                        failure: function(response,options){
                                            //
                                        },
                                        scope:this
                                    });
                                }
                            }
                        }
                    }
                ]
            }
        ];
        fsExamenFisicoUi.superclass.initComponent.call(this);
    }
});
