/*
* @category    Fieldset Adolescencia
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


fsRES202Adolescencia2022Ui = Ext.extend(Ext.form.FieldSet, {
    anchor: '100%',
    autoHeight: true,
    layout: 'form',
    title: '** ADOLESCENCIA **',
    collapseFirst: false,
    collapsible: true,
    animCollapse: true,
    labelWidth: 150,
    titleCollapse: true,
    padding: 0,
    id: 'fsRES202Adolescencia',
    initComponent: function() {
        
        this.items = [
            {
                html: '<br>'
            },
            {
                xtype: 'fieldset',
                title: 'VALE',
                layout: 'form',
                collapseFirst: false,
                collapsible: true,
                animCollapse: true,
                titleCollapse: true,
                anchor: '100%',
                autoHeight: true,
                id: 'fsAdolescenciaVale',
                items: [
                    {
                        xtype: 'combo',
                        fieldLabel: 'No se Realiza',
                        name: 'ADOLESCENCIA - VALE - NO SE REALIZA',
                        anchor: '100%',
                        allowBlank: true,
                        store: stRES202NoRealiza,
                        forceSelection: true,
                        triggerAction: 'all',
                        typeAhead: true,
                        typeAheadDelay: 50,
                        mode: 'local',
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        id: 'strAdolescenciaValeNoSeRealiza',
                        listeners: {
                            change: function( t, newValue, oldValue ){
                                if(newValue === "" || newValue === null){
                                    Ext.getCmp('fecAdolescenciaVale63').setValue(null);
                                    Ext.getCmp('strAdolescenciaVale40').setValue(null);
                                }else{
                                    if(newValue === "No se tiene el dato"){
                                        Ext.getCmp('fecAdolescenciaVale63').setValue("01/01/1800");
                                        Ext.getCmp('strAdolescenciaVale40').setValue("21 - Riesgo no evaluado");
                                    }else if(newValue === "No se realiza por una tradición"){
                                        Ext.getCmp('fecAdolescenciaVale63').setValue("01/01/1805");
                                        Ext.getCmp('strAdolescenciaVale40').setValue("21 - Riesgo no evaluado");
                                    }else if(newValue === "No se realiza por una condición de salud registrar"){
                                        Ext.getCmp('fecAdolescenciaVale63').setValue("01/01/1810");
                                        Ext.getCmp('strAdolescenciaVale40').setValue("21 - Riesgo no evaluado");
                                    }else if(newValue === "No se realiza por una negación del usuario"){
                                        Ext.getCmp('fecAdolescenciaVale63').setValue("01/01/1825");
                                        Ext.getCmp('strAdolescenciaVale40').setValue("21 - Riesgo no evaluado");
                                    }else if(newValue === "No se realiza por otras razones"){
                                        Ext.getCmp('fecAdolescenciaVale63').setValue("01/01/1835");
                                        Ext.getCmp('strAdolescenciaVale40').setValue("21 - Riesgo no evaluado");
                                    }
                                }
                            }
                        }
                    },
                    {
                        xtype: 'datefield',
                        fieldLabel: 'Fecha Valoracion',
                        name: 'ADOLESCENCIA - VALE - FECHA VALORACION',
                        width: 110,
                        allowBlank: true,
                        //value: new Date().format('d/m/Y'),
                        disabledDates: '',
                        emptyText: '(dia/mes/año) ',
                        style: 'text-align:center;',
                        id: 'fecAdolescenciaVale63',
                        listeners: {
                            render: function( p ) {
                                p.getEl().on('dblclick', function (){
                                    Ext.getCmp('strAdolescenciaValeNoSeRealiza').setValue(null);
                                    Ext.getCmp('fecAdolescenciaVale63').setValue(localStorage.getItem('fecVALE'));
                                    Ext.getCmp('strAdolescenciaVale40').setValue(localStorage.getItem('resVALE'));
                                });
                            }
                        }
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: 'Resultado',
                        name: 'ADOLESCENCIA - VALE - RESULTADO',
                        anchor: '100%',
                        allowBlank: true,
                        store: stRES202VALE,
                        forceSelection: true,
                        triggerAction: 'all',
                        typeAhead: true,
                        typeAheadDelay: 50,
                        mode: 'local',
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        id: 'strAdolescenciaVale40',
                        listeners: {
                            render: function( p ) {
                                p.getEl().on('dblclick', function (){
                                    Ext.getCmp('strAdolescenciaValeNoSeRealiza').setValue(null);
                                    Ext.getCmp('fecAdolescenciaVale63').setValue(localStorage.getItem('fecVALE'));
                                    Ext.getCmp('strAdolescenciaVale40').setValue(localStorage.getItem('resVALE'));
                                });
                            }
                        }
                    },
                    {
                        xtype: 'textarea',
                        fieldLabel: 'Observaciones',
                        name: 'ADOLESCENCIA - VALE - OBSERVACIONES',
                        anchor: '100%',
                        allowBlank: true,
                        id: 'memAdolescenciaVale'
                    }
                ]
            },
            {
                xtype: 'fieldset',
                title: 'TANNER FEMENINO',
                layout: 'form',
                collapseFirst: false,
                collapsible: true,
                animCollapse: true,
                titleCollapse: true,
                anchor: '100%',
                autoHeight: true,
                id: 'fsAdolescenciaTannerMujer',
                items: [
                    {
                        xtype: 'combo',
                        fieldLabel: 'Desarrollo Mamario',
                        name: 'ADOLESCENCIA - TANNER - DESARROLLO MAMARIO',
                        anchor: '100%',
                        allowBlank: true,
                        store: stTannerMamaMujer,
                        forceSelection: true,
                        triggerAction: 'all',
                        typeAhead: true,
                        typeAheadDelay: 50,
                        mode: 'local',
                        valueField: 'Codigo',
                        displayField: 'Codigo',
                        itemSelector: 'div.mujer-mama',
                        tpl: new Ext.XTemplate('<tpl for="."><div class="mujer-mama"><table><tr><td><img src="{urlImagen}"></td><td>{Codigo}<br>{Descripcion}</td></tr></table></div></tpl>'),
                        id: 'strAdolescenciaTannerMujerMama'
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: 'Desarrollo Vello Pubiano',
                        name: 'ADOLESCENCIA - TANNER - DESARROLLO DEL VELLO PUBIANO ',
                        anchor: '100%',
                        allowBlank: true,
                        store: stTannerVelloMujer,
                        forceSelection: true,
                        triggerAction: 'all',
                        typeAhead: true,
                        typeAheadDelay: 50,
                        mode: 'local',
                        valueField: 'Codigo',
                        displayField: 'Codigo',
                        itemSelector: 'div.mujer-vello',
                        tpl: new Ext.XTemplate('<tpl for="."><div class="mujer-vello"><table><tr><td><img src="{urlImagen}"></td><td>{Codigo}<br>{Descripcion}</td></tr></table></div></tpl>'),
                        id: 'strAdolescenciaTannerMujerVello'
                    }
                ]
            },
            {
                xtype: 'fieldset',
                title: 'TANNER MASCULINO',
                layout: 'form',
                collapseFirst: false,
                collapsible: true,
                animCollapse: true,
                titleCollapse: true,
                anchor: '100%',
                autoHeight: true,
                id: 'fsAdolescenciaTannerHombre',
                items: [
                    {
                        xtype: 'combo',
                        fieldLabel: 'Desarrollo Genital',
                        name: 'ADOLESCENCIA - TANNER - DESARROLLO GENITAL',
                        anchor: '100%',
                        allowBlank: true,
                        store: stTannerGenitalHombre,
                        forceSelection: true,
                        triggerAction: 'all',
                        typeAhead: true,
                        typeAheadDelay: 50,
                        mode: 'local',
                        valueField: 'Codigo',
                        displayField: 'Codigo',
                        itemSelector: 'div.hombre-genital',
                        tpl: new Ext.XTemplate('<tpl for="."><div class="hombre-genital"><table><tr><td><img src="{urlImagen}"></td><td>{Codigo}<br>{Descripcion}</td></tr></table></div></tpl>'),
                        id: 'strAdolescenciaTannerHombrGenital'
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: 'Desarrollo Vello Pubiano',
                        name: 'ADOLESCENCIA - TANNER - DESARROLLO DEL VELLO PUBIANO ',
                        anchor: '100%',
                        allowBlank: true,
                        store: stTannerVelloHombre,
                        forceSelection: true,
                        triggerAction: 'all',
                        typeAhead: true,
                        typeAheadDelay: 50,
                        mode: 'local',
                        valueField: 'Codigo',
                        displayField: 'Codigo',
                        itemSelector: 'div.hombre-vello',
                        tpl: new Ext.XTemplate('<tpl for="."><div class="hombre-vello"><table><tr><td><img src="{urlImagen}"></td><td>{Codigo}<br>{Descripcion}</td></tr></table></div></tpl>'),
                        id: 'strAdolescenciaTannerHombreVello'
                    }
                ]
            },
            {
                xtype: 'fieldset',
                title: 'RQC',
                layout: 'form',
                collapseFirst: false,
                collapsible: true,
                animCollapse: true,
                titleCollapse: true,
                anchor: '100%',
                autoHeight: true,
                labelWidth: 650,
                id: 'fsAdolescenciaRQC',
                items: [
                    {
                        xtype: 'combo',
                        fieldLabel: '¿El lenguaje del niño es anormal en alguna forma?',
                        name: 'ADOLESCENCIA - RQC - ¿EL LENGUAJE DEL NIÑO ES ANORMAL EN ALGUNA FORMA?',
                        anchor: '100%',
                        allowBlank: true,
                        store: 'StoreSiNo',
                        forceSelection: true,
                        triggerAction: 'all',
                        typeAhead: true,
                        typeAheadDelay: 50,
                        mode: 'local',
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        id: 'strAdolecenciaRQC1'
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: '¿El niño duerme mal?',
                        name: 'ADOLESCENCIA - RQC - ¿EL NIÑO DUERME MAL?',
                        anchor: '100%',
                        allowBlank: true,
                        store: 'StoreSiNo',
                        forceSelection: true,
                        triggerAction: 'all',
                        typeAhead: true,
                        typeAheadDelay: 50,
                        mode: 'local',
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        id: 'strAdolecenciaRQC2'
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: '¿Ha tenido el niño en algunas ocasiones convulsiones o caídas al suelo sin razón?',
                        name: 'ADOLESCENCIA - RQC - ¿HA TENIDO EL NIÑO EN ALGUNAS OCASIONES CONVULSIONES O CAÍDAS AL SUELO SIN RAZÓN?',
                        anchor: '100%',
                        allowBlank: true,
                        store: 'StoreSiNo',
                        forceSelection: true,
                        triggerAction: 'all',
                        typeAhead: true,
                        typeAheadDelay: 50,
                        mode: 'local',
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        id: 'strAdolecenciaRQC3'
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: '¿Sufre el niño de dolores frecuentes de cabeza?',
                        name: 'ADOLESCENCIA - RQC - ¿SUFRE EL NIÑO DE DOLORES FRECUENTES DE CABEZA?',
                        anchor: '100%',
                        allowBlank: true,
                        store: 'StoreSiNo',
                        forceSelection: true,
                        triggerAction: 'all',
                        typeAhead: true,
                        typeAheadDelay: 50,
                        mode: 'local',
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        id: 'strAdolecenciaRQC4'
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: '¿El niño ha huido de casa frecuentemente?',
                        name: 'ADOLESCENCIA - RQC - ¿EL NIÑO HA HUIDO DE CASA FRECUENTEMENTE?',
                        anchor: '100%',
                        allowBlank: true,
                        store: 'StoreSiNo',
                        forceSelection: true,
                        triggerAction: 'all',
                        typeAhead: true,
                        typeAheadDelay: 50,
                        mode: 'local',
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        id: 'strAdolecenciaRQC5'
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: '¿Ha robado algo de la casa?',
                        name: 'ADOLESCENCIA - RQC - ¿HA ROBADO ALGO DE LA CASA?',
                        anchor: '100%',
                        allowBlank: true,
                        store: 'StoreSiNo',
                        forceSelection: true,
                        triggerAction: 'all',
                        typeAhead: true,
                        typeAheadDelay: 50,
                        mode: 'local',
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        id: 'strAdolecenciaRQC6'
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: '¿Se asusta o se pone nervioso sin razón?',
                        name: 'ADOLESCENCIA - RQC - ¿SE ASUSTA O SE PONE NERVIOSO SIN RAZÓN?',
                        anchor: '100%',
                        allowBlank: true,
                        store: 'StoreSiNo',
                        forceSelection: true,
                        triggerAction: 'all',
                        typeAhead: true,
                        typeAheadDelay: 50,
                        mode: 'local',
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        id: 'strAdolecenciaRQC7'
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: '¿Parece como retardado o lento para aprender?',
                        name: 'ADOLESCENCIA - RQC - ¿PARECE COMO RETARDADO O LENTO PARA APRENDER?',
                        anchor: '100%',
                        allowBlank: true,
                        store: 'StoreSiNo',
                        forceSelection: true,
                        triggerAction: 'all',
                        typeAhead: true,
                        typeAheadDelay: 50,
                        mode: 'local',
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        id: 'strAdolecenciaRQC8'
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: '¿El niño casi nunca juega con otros niños?',
                        name: 'ADOLESCENCIA - RQC - ¿EL NIÑO CASI NUNCA JUEGA CON OTROS NIÑOS?',
                        anchor: '100%',
                        allowBlank: true,
                        store: 'StoreSiNo',
                        forceSelection: true,
                        triggerAction: 'all',
                        typeAhead: true,
                        typeAheadDelay: 50,
                        mode: 'local',
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        id: 'strAdolecenciaRQC9'
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: '¿El niño se orina o defeca en la ropa?',
                        name: 'ADOLESCENCIA - RQC - ¿EL NIÑO SE ORINA O DEFECA EN LA ROPA?',
                        anchor: '100%',
                        allowBlank: true,
                        store: 'StoreSiNo',
                        forceSelection: true,
                        triggerAction: 'all',
                        typeAhead: true,
                        typeAheadDelay: 50,
                        mode: 'local',
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        id: 'strAdolecenciaRQC10'
                    }
                ]
            },
            {
                xtype: 'fieldset',
                title: 'SRQ',
                layout: 'form',
                collapseFirst: false,
                collapsible: true,
                animCollapse: true,
                titleCollapse: true,
                anchor: '100%',
                autoHeight: true,
                labelWidth: 650,
                id: 'fsAdolescenciaSRQ',
                items: [
                    {
                        xtype: 'combo',
                        fieldLabel: '¿Tiene frecuentes dolores de cabeza?',
                        name: 'ADOLESCENCIA - SRQ - ¿TIENE FRECUENTES DOLORES DE CABEZA?',
                        anchor: '100%',
                        allowBlank: true,
                        store: 'StoreSiNo',
                        forceSelection: true,
                        triggerAction: 'all',
                        typeAhead: true,
                        typeAheadDelay: 50,
                        mode: 'local',
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        id: 'strAdolecenciaSRQ1'
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: '¿Tiene mal apetito?',
                        name: 'ADOLESCENCIA - SRQ - ¿TIENE MAL APETITO?',
                        anchor: '100%',
                        allowBlank: true,
                        store: 'StoreSiNo',
                        forceSelection: true,
                        triggerAction: 'all',
                        typeAhead: true,
                        typeAheadDelay: 50,
                        mode: 'local',
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        id: 'strAdolecenciaSRQ2'
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: '¿Duerme mal?',
                        name: 'ADOLESCENCIA - SRQ - ¿DUERME MAL?',
                        anchor: '100%',
                        allowBlank: true,
                        store: 'StoreSiNo',
                        forceSelection: true,
                        triggerAction: 'all',
                        typeAhead: true,
                        typeAheadDelay: 50,
                        mode: 'local',
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        id: 'strAdolecenciaSRQ3'
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: '¿Se asusta con facilidad?',
                        name: 'ADOLESCENCIA - SRQ - ¿SE ASUSTA CON FACILIDAD?',
                        anchor: '100%',
                        allowBlank: true,
                        store: 'StoreSiNo',
                        forceSelection: true,
                        triggerAction: 'all',
                        typeAhead: true,
                        typeAheadDelay: 50,
                        mode: 'local',
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        id: 'strAdolecenciaSRQ4'
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: '¿Sufre de temblor de manos?',
                        name: 'ADOLESCENCIA - SRQ - ¿SUFRE DE TEMBLOR DE MANOS?',
                        anchor: '100%',
                        allowBlank: true,
                        store: 'StoreSiNo',
                        forceSelection: true,
                        triggerAction: 'all',
                        typeAhead: true,
                        typeAheadDelay: 50,
                        mode: 'local',
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        id: 'strAdolecenciaSRQ5'
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: '¿Se siente nervioso, tenso o aburrido?',
                        name: 'ADOLESCENCIA - SRQ - ¿SE SIENTE NERVIOSO, TENSO O ABURRIDO?',
                        anchor: '100%',
                        allowBlank: true,
                        store: 'StoreSiNo',
                        forceSelection: true,
                        triggerAction: 'all',
                        typeAhead: true,
                        typeAheadDelay: 50,
                        mode: 'local',
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        id: 'strAdolecenciaSRQ6'
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: '¿Sufre de mala digestión?',
                        name: 'ADOLESCENCIA - SRQ - ¿SUFRE DE MALA DIGESTIÓN?',
                        anchor: '100%',
                        allowBlank: true,
                        store: 'StoreSiNo',
                        forceSelection: true,
                        triggerAction: 'all',
                        typeAhead: true,
                        typeAheadDelay: 50,
                        mode: 'local',
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        id: 'strAdolecenciaSRQ7'
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: '¿No puede pensar con claridad?',
                        name: 'ADOLESCENCIA - SRQ - ¿NO PUEDE PENSAR CON CLARIDAD?',
                        anchor: '100%',
                        allowBlank: true,
                        store: 'StoreSiNo',
                        forceSelection: true,
                        triggerAction: 'all',
                        typeAhead: true,
                        typeAheadDelay: 50,
                        mode: 'local',
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        id: 'strAdolecenciaSRQ8'
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: '¿Se siente triste?',
                        name: 'ADOLESCENCIA - SRQ - ¿SE SIENTE TRISTE?',
                        anchor: '100%',
                        allowBlank: true,
                        store: 'StoreSiNo',
                        forceSelection: true,
                        triggerAction: 'all',
                        typeAhead: true,
                        typeAheadDelay: 50,
                        mode: 'local',
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        id: 'strAdolecenciaSRQ9'
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: '¿Llora usted con mucha frecuencia?',
                        name: 'ADOLESCENCIA - SRQ - ¿LLORA USTED CON MUCHA FRECUENCIA?',
                        anchor: '100%',
                        allowBlank: true,
                        store: 'StoreSiNo',
                        forceSelection: true,
                        triggerAction: 'all',
                        typeAhead: true,
                        typeAheadDelay: 50,
                        mode: 'local',
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        id: 'strAdolecenciaSRQ10'
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: '¿Tiene dificultad en disfrutar de sus actividades diarias?',
                        name: 'ADOLESCENCIA - SRQ - ¿TIENE DIFICULTAD EN DISFRUTAR DE SUS ACTIVIDADES DIARIAS?',
                        anchor: '100%',
                        allowBlank: true,
                        store: 'StoreSiNo',
                        forceSelection: true,
                        triggerAction: 'all',
                        typeAhead: true,
                        typeAheadDelay: 50,
                        mode: 'local',
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        id: 'strAdolecenciaSRQ11'
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: '¿Tiene dificultad para tomar decisiones?',
                        name: 'ADOLESCENCIA - SRQ - ¿TIENE DIFICULTAD PARA TOMAR DECISIONES?',
                        anchor: '100%',
                        allowBlank: true,
                        store: 'StoreSiNo',
                        forceSelection: true,
                        triggerAction: 'all',
                        typeAhead: true,
                        typeAheadDelay: 50,
                        mode: 'local',
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        id: 'strAdolecenciaSRQ12'
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: '¿Tiene dificultad en hacer su trabajo? (¿Sufre usted con su trabajo?)',
                        name: 'ADOLESCENCIA - SRQ - ¿TIENE DIFICULTAD EN HACER SU TRABAJO? (¿SUFRE USTED CON SU TRABAJO?)',
                        anchor: '100%',
                        allowBlank: true,
                        store: 'StoreSiNo',
                        forceSelection: true,
                        triggerAction: 'all',
                        typeAhead: true,
                        typeAheadDelay: 50,
                        mode: 'local',
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        id: 'strAdolecenciaSRQ13'
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: '¿Es incapaz de desempeñar un papel útil en su vida?',
                        name: 'ADOLESCENCIA - SRQ - ¿ES INCAPAZ DE DESEMPEÑAR UN PAPEL ÚTIL EN SU VIDA?',
                        anchor: '100%',
                        allowBlank: true,
                        store: 'StoreSiNo',
                        forceSelection: true,
                        triggerAction: 'all',
                        typeAhead: true,
                        typeAheadDelay: 50,
                        mode: 'local',
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        id: 'strAdolecenciaSRQ14'
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: '¿Ha perdido interés en las cosas?',
                        name: 'ADOLESCENCIA - SRQ - ¿HA PERDIDO INTERÉS EN LAS COSAS?',
                        anchor: '100%',
                        allowBlank: true,
                        store: 'StoreSiNo',
                        forceSelection: true,
                        triggerAction: 'all',
                        typeAhead: true,
                        typeAheadDelay: 50,
                        mode: 'local',
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        id: 'strAdolecenciaSRQ15'
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: '¿Siente que usted es una persona inútil?',
                        name: 'ADOLESCENCIA - SRQ - ¿SIENTE QUE USTED ES UNA PERSONA INÚTIL?',
                        anchor: '100%',
                        allowBlank: true,
                        store: 'StoreSiNo',
                        forceSelection: true,
                        triggerAction: 'all',
                        typeAhead: true,
                        typeAheadDelay: 50,
                        mode: 'local',
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        id: 'strAdolecenciaSRQ16'
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: '¿Ha tenido la idea de acabar con su vida?',
                        name: 'ADOLESCENCIA - SRQ - ¿HA TENIDO LA IDEA DE ACABAR CON SU VIDA?',
                        anchor: '100%',
                        allowBlank: true,
                        store: 'StoreSiNo',
                        forceSelection: true,
                        triggerAction: 'all',
                        typeAhead: true,
                        typeAheadDelay: 50,
                        mode: 'local',
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        id: 'strAdolecenciaSRQ17'
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: '¿Se siente cansado todo el tiempo?',
                        name: 'ADOLESCENCIA - SRQ - ¿SE SIENTE CANSADO TODO EL TIEMPO?',
                        anchor: '100%',
                        allowBlank: true,
                        store: 'StoreSiNo',
                        forceSelection: true,
                        triggerAction: 'all',
                        typeAhead: true,
                        typeAheadDelay: 50,
                        mode: 'local',
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        id: 'strAdolecenciaSRQ18'
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: '¿Tiene sensaciones desagradables en su estómago?',
                        name: 'ADOLESCENCIA - SRQ - ¿TIENE SENSACIONES DESAGRADABLES EN SU ESTÓMAGO?',
                        anchor: '100%',
                        allowBlank: true,
                        store: 'StoreSiNo',
                        forceSelection: true,
                        triggerAction: 'all',
                        typeAhead: true,
                        typeAheadDelay: 50,
                        mode: 'local',
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        id: 'strAdolecenciaSRQ19'
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: '¿Se cansa con facilidad?',
                        name: 'ADOLESCENCIA - SRQ - ¿SE CANSA CON FACILIDAD?',
                        anchor: '100%',
                        allowBlank: true,
                        store: 'StoreSiNo',
                        forceSelection: true,
                        triggerAction: 'all',
                        typeAhead: true,
                        typeAheadDelay: 50,
                        mode: 'local',
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        id: 'strAdolecenciaSRQ20'
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: '¿Siente usted que alguien ha tratado de herirlo en alguna forma?',
                        name: 'ADOLESCENCIA - SRQ - ¿SIENTE USTED QUE ALGUIEN HA TRATADO DE HERIRLO EN ALGUNA FORMA?',
                        anchor: '100%',
                        allowBlank: true,
                        store: 'StoreSiNo',
                        forceSelection: true,
                        triggerAction: 'all',
                        typeAhead: true,
                        typeAheadDelay: 50,
                        mode: 'local',
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        id: 'strAdolecenciaSRQ21'
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: '¿Es usted una persona mucho más importante que lo que piensan los demás?',
                        name: 'ADOLESCENCIA - SRQ - ¿ES USTED UNA PERSONA MUCHO MÁS IMPORTANTE QUE LO QUE PIENSAN LOS DEMÁS?',
                        anchor: '100%',
                        allowBlank: true,
                        store: 'StoreSiNo',
                        forceSelection: true,
                        triggerAction: 'all',
                        typeAhead: true,
                        typeAheadDelay: 50,
                        mode: 'local',
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        id: 'strAdolecenciaSRQ22'
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: '¿Ha notado interferencias o algo raro en sus pensamientos?',
                        name: 'ADOLESCENCIA - SRQ - ¿HA NOTADO INTERFERENCIAS O ALGO RARO EN SUS PENSAMIENTOS?',
                        anchor: '100%',
                        allowBlank: true,
                        store: 'StoreSiNo',
                        forceSelection: true,
                        triggerAction: 'all',
                        typeAhead: true,
                        typeAheadDelay: 50,
                        mode: 'local',
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        id: 'strAdolecenciaSRQ23'
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: '¿Oye voces sin saber de dónde vienen o que otras personas no pueden oír?',
                        name: 'ADOLESCENCIA - SRQ - ¿OYE VOCES SIN SABER DE DÓNDE VIENEN O QUE OTRAS PERSONAS NO PUEDEN OÍR?',
                        anchor: '100%',
                        allowBlank: true,
                        store: 'StoreSiNo',
                        forceSelection: true,
                        triggerAction: 'all',
                        typeAhead: true,
                        typeAheadDelay: 50,
                        mode: 'local',
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        id: 'strAdolecenciaSRQ24'
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: '¿Ha tenido convulsiones, ataques o caídas al suelo, como movimientos de brazos y piernas; con mordeduras de lengua o pérdida del conocimiento?',
                        name: 'ADOLESCENCIA - SRQ - ¿HA TENIDO CONVULSIONES, ATAQUES O CAÍDAS AL SUELO, COMO MOVIMIENTOS DE BRAZOS Y PIERNAS; CON MORDEDURAS DE LENGUA O PÉRDIDA DEL CONOCIMIENTO?',
                        anchor: '100%',
                        allowBlank: true,
                        store: 'StoreSiNo',
                        forceSelection: true,
                        triggerAction: 'all',
                        typeAhead: true,
                        typeAheadDelay: 50,
                        mode: 'local',
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        id: 'strAdolecenciaSRQ25'
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: '¿Alguna vez le ha parecido a su familia, sus amigos, su médico o a su sacerdote que usted estaba bebiendo demasiado licor?',
                        name: 'ADOLESCENCIA - SRQ - ¿ALGUNA VEZ LE HA PARECIDO A SU FAMILIA, SUS AMIGOS, SU MÉDICO O A SU SACERDOTE QUE USTED ESTABA BEBIENDO DEMASIADO LICOR?',
                        anchor: '100%',
                        allowBlank: true,
                        store: 'StoreSiNo',
                        forceSelection: true,
                        triggerAction: 'all',
                        typeAhead: true,
                        typeAheadDelay: 50,
                        mode: 'local',
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        id: 'strAdolecenciaSRQ26'
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: '¿Alguna vez ha querido dejar de beber, pero no ha podido?',
                        name: 'ADOLESCENCIA - SRQ - ¿ALGUNA VEZ HA QUERIDO DEJAR DE BEBER, PERO NO HA PODIDO?',
                        anchor: '100%',
                        allowBlank: true,
                        store: 'StoreSiNo',
                        forceSelection: true,
                        triggerAction: 'all',
                        typeAhead: true,
                        typeAheadDelay: 50,
                        mode: 'local',
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        id: 'strAdolecenciaSRQ27'
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: '¿Ha tenido alguna vez dificultades en el trabajo (o estudio) a causa de la bebida, como beber en el trabajo o en el colegio, o faltar a ellos?',
                        name: 'ADOLESCENCIA - SRQ - ¿HA TENIDO ALGUNA VEZ DIFICULTADES EN EL TRABAJO (O ESTUDIO) A CAUSA DE LA BEBIDA, COMO BEBER EN EL TRABAJO O EN EL COLEGIO, O FALTAR A ELLOS? ',
                        anchor: '100%',
                        allowBlank: true,
                        store: 'StoreSiNo',
                        forceSelection: true,
                        triggerAction: 'all',
                        typeAhead: true,
                        typeAheadDelay: 50,
                        mode: 'local',
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        id: 'strAdolecenciaSRQ28'
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: '¿Ha estado en riñas o lo han detenido estando borracho?',
                        name: 'ADOLESCENCIA - SRQ - ¿HA ESTADO EN RIÑAS O LO HAN DETENIDO ESTANDO BORRACHO?',
                        anchor: '100%',
                        allowBlank: true,
                        store: 'StoreSiNo',
                        forceSelection: true,
                        triggerAction: 'all',
                        typeAhead: true,
                        typeAheadDelay: 50,
                        mode: 'local',
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        id: 'strAdolecenciaSRQ29'
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: '¿Le ha parecido alguna vez que usted bebía demasiado?',
                        name: 'ADOLESCENCIA - SRQ - ¿LE HA PARECIDO ALGUNA VEZ QUE USTED BEBÍA DEMASIADO?',
                        anchor: '100%',
                        allowBlank: true,
                        store: 'StoreSiNo',
                        forceSelection: true,
                        triggerAction: 'all',
                        typeAhead: true,
                        typeAheadDelay: 50,
                        mode: 'local',
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        id: 'strAdolecenciaSRQ30'
                    }
                ]
            },
            {
                xtype: 'fieldset',
                title: 'FAMILIOGRAMA',
                layout: 'table',
                collapseFirst: false,
                collapsible: true,
                animCollapse: true,
                titleCollapse: true,
                anchor: '100%',
                autoHeight: true,
                padding: 7,
                items: [
                    {
                        xtype: 'textarea',
                        fieldLabel: 'Familiograma',
                        name: 'ADOLESCENCIA - FAMILIOGRAMA',
                        width: 830,
                        allowBlank: true,
                        id: 'memAdolecenciaFamiliograma'
                    }
                ]
            },
            {
                xtype: 'fieldset',
                title: 'ECOMAPA',
                layout: 'table',
                collapseFirst: false,
                collapsible: true,
                animCollapse: true,
                titleCollapse: true,
                anchor: '100%',
                autoHeight: true,
                padding: 7,
                items: [
                    {
                        xtype: 'textarea',
                        fieldLabel: 'Ecomapa',
                        name: 'ADOLESCENCIA - ECOMAPA',
                        width: 830,
                        allowBlank: true,
                        id: 'memAdolecenciaEcomapa'
                    }
                ]
            },
            {
                xtype: 'fieldset',
                title: 'DERECHOS SEXUALES',
                layout: 'table',
                collapseFirst: false,
                collapsible: true,
                animCollapse: true,
                titleCollapse: true,
                anchor: '100%',
                autoHeight: true,
                padding: 7,
                items: [
                    {
                        xtype: 'textarea',
                        fieldLabel: 'Derechos Sexuales',
                        name: 'ADOLESCENCIA - DERECHOS SEXUALES',
                        width: 830,
                        allowBlank: true,
                        id: 'memAdolecenciaDerechosSexuales'
                    }
                ]
            },
            {
                xtype: 'fieldset',
                title: 'IDENTIDAD',
                layout: 'table',
                collapseFirst: false,
                collapsible: true,
                animCollapse: true,
                titleCollapse: true,
                anchor: '100%',
                autoHeight: true,
                padding: 7,
                items: [
                    {
                        xtype: 'textarea',
                        fieldLabel: 'Identidad',
                        name: 'ADOLESCENCIA - IDENTIDAD',
                        width: 830,
                        allowBlank: true,
                        id: 'memAdolecenciaIdentidad'
                    }
                ]
            },
            {
                xtype: 'fieldset',
                title: 'AUTONOMIA',
                layout: 'table',
                collapseFirst: false,
                collapsible: true,
                animCollapse: true,
                titleCollapse: true,
                anchor: '100%',
                autoHeight: true,
                padding: 7,
                items: [
                    {
                        xtype: 'textarea',
                        fieldLabel: 'Autonomia',
                        name: 'ADOLESCENCIA - AUTONOMIA',
                        width: 830,
                        allowBlank: true,
                        id: 'memAdolecenciaAutonomia'
                    }
                ]
            },
            {
                xtype: 'fieldset',
                title: 'ASSIST',
                layout: 'table',
                collapseFirst: false,
                collapsible: true,
                animCollapse: true,
                titleCollapse: true,
                anchor: '100%',
                autoHeight: true,
                padding: 7,
                items: [
                    {
                        xtype: 'textarea',
                        fieldLabel: 'ASSIST',
                        name: 'ADOLESCENCIA - ASSIST',
                        width: 830,
                        allowBlank: true,
                        id: 'memAdolecenciaASSIST'
                    }
                ]
            },
            {
                xtype: 'fieldset',
                title: 'AUDIT',
                layout: 'table',
                collapseFirst: false,
                collapsible: true,
                animCollapse: true,
                titleCollapse: true,
                anchor: '100%',
                autoHeight: true,
                padding: 7,
                items: [
                    {
                        xtype: 'textarea',
                        fieldLabel: 'AUDIT',
                        name: 'ADOLESCENCIA - AUDIT',
                        width: 830,
                        allowBlank: true,
                        id: 'memAdolecenciaAUDIT'
                    }
                ]
            },
            {
                xtype: 'textarea',
                fieldLabel: 'Observaciones',
                name: 'ADOLESCENCIA - OBSERVACIONES',
                anchor: '100%',
                allowBlank: false,
                id: 'memAdolescenciaObservaciones'
            }
        ];
        this.on({
            afterlayout:{
                scope:this, 
                single:true, 
                fn:function() {
                    /*var MyDate = new Date();
                    MyDate.setDate(MyDate.getDate() - 360);
                    Ext.getCmp('fecAdolescenciaValoracion').setMinValue(MyDate.format("d/m/Y"));
                    Ext.getCmp('fecAdolescenciaValoracion').setMaxValue(new Date().format("d/m/Y"));*/
                }
            }
        });
        fsRES202Adolescencia2022Ui.superclass.initComponent.call(this);
    }
});
