/*
* @category    Formulario Modelo Kardex CLAP 2010
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


winHCCLAP2010Ui = Ext.extend(Ext.Window, {
    title: 'eOfiClinic ©  .:: CLAP ::.',
    width: 990,
    height: 606,
    closable: false,
    resizable: false,
    draggable: false,
    modal: true,
    id: 'winHC',
    initComponent: function() {
        this.items = [
            {
                xtype: 'panel',
                frame: true,
                anchor: '100%',
                id: 'panelHC',
                padding: 10,
                border: false,
                height: 560,
                autoScroll: true,
                layout: 'form',
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysIdCodPlantillaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        value: 1,
                        id: 'sysUsaGridSalida'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                        value: 0,
                        id: 'sysYaGuardoHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysPlantillaHC',
                        name: 'PLANTILLA'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptMx'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptExa'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptRem'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Actividad',
                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                        id: 'sysActividadHC',
                        name: 'PLANTILLA'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Empresa',
                        id: 'sysEmpresaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'IPS',
                        id: 'sysIPSHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Usuario',
                        id: 'sysUsuarioHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Profesional',
                        id: 'sysProfesionalHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Paciente',
                        id: 'sysIdPacienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Apertura',
                        id: 'sysAperturaHC'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Cliente',
                        id: 'sysClienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdClienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdPlanHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdSubPlanHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdContratoHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Genero',
                        id: 'sysGeneroPacHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Edad',
                        id: 'sysEdadPacHC'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Profesional',
                        id: 'sysProfesionalAgendaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'ConsecutivoDetalle',
                        id: 'sysConsecutivoDetalleHC'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'CAS',
                                id: 'sysCASHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysFechaHC',
                                value: 'Fecha: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysFechaHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysHoraHC',
                                value: 'Hora: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysHoraHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysLegalizacionHC',
                                value: 'Legalización: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysLegalizaHC'
                            }
                        ]
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Paciente',
                        value: 'CC 792558261  - JORGE GALEANO RUIZ - (Masculino) FechaNac: 1973-01-30, Edad 38 Años',
                        id: 'sysPacienteHC'
                    },
                    {
                        html: '<hr>',
                        style: 'background:transparent;',
                        border: false
                    },
                    
                    //Empezar AQUI
                    {
                        xtype: 'panel',
                        layout: 'table',
                        anchor: '100%',
                        autoHeight: true,
                        layoutConfig: {
                            columns: 2
                        }, 
                        items: [
                            {
                                xtype: 'panel',
                                layout: 'form',
                                width: '630',
                                autoHeight: true,
                                padding: 7,
                                items: [ 
                                    { 
                                        xtype: 'fieldset',
                                        title: 'IDENTIFICACION',
                                        layout: 'form',
                                        collapsible: true,
                                        titleCollapse: true,
                                        width:590,
                                        anchor: '100%',
                                        autoHeight: true,
                                        padding: 5,
                                        items: [
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'datefield',
                                                        fieldLabel: 'Fecha Nacimiento',
                                                        name: 'Fecha Nacimiento',
                                                        anchor: '100%',
                                                        allowBlank: false,
                                                        width:120,
                                                        disabledDates: '',
                                                        emptyText: '(dia/mes/año) ',
                                                        style: 'text-align:center;',
                                                        id: 'fecFechaNacClAP'
                                                    },
                                                    {
                                                        xtype: 'displayfield',
                                                        id: 'sysEdadCLAP',
                                                        value: 'Edad: '
                                                    },
                                                    {
                                                        xtype: 'numberfield',
                                                        name: 'Edad',
                                                        width: 80,
                                                        allowBlank: false,
                                                        id: 'intEdadCLAP'
                                                    },
                                                    {
                                                        xtype: 'displayfield',
                                                        id: 'sysEdadCLAP1',
                                                        value: ' - '
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        width: 100,
                                                        name: 'Edad Clasificacion',
                                                        allowBlank: false,
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: "NO",
                                                        id: 'strEdadClasificacionCLAP'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        width: 100,
                                                        fieldLabel: 'Etnia',
                                                        name: 'Etnia',
                                                        allowBlank: false,
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: "NO",
                                                        id: 'strEtdiaCLAP'
                                                    },
                                                    {
                                                        xtype: 'displayfield',
                                                        id: 'sysLeeEscribeCLAP',
                                                        value: 'Lee y Escribre: '
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        width: 100,
                                                        name: 'Lee y Escribe',
                                                        allowBlank: false,
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: "NO",
                                                        id: 'strLeeEscribeCLAP'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        width: 100,
                                                        name: 'Estudios',
                                                        fieldLabel:'Estudios',
                                                        allowBlank: false,
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: "NO",
                                                        id: 'strEstudiosCLAP'
                                                    },
                                                    {
                                                        xtype: 'displayfield',
                                                        id: 'sysEstudiosAnioSupCLAP',
                                                        value: 'Años Nivel Superior: '
                                                    },
                                                    {
                                                        xtype: 'numberfield',
                                                        name: 'Años Nivel Superior',
                                                        width: 80,
                                                        allowBlank: false,
                                                        id: 'intAnioNivelSupCLAP'
                                                    },
                                                    {
                                                        xtype: 'displayfield',
                                                        id: 'sysEstadoCivil',
                                                        value:'Estado Civil:'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        width: 100,
                                                        name: 'Estado Civil',
                                                        allowBlank: false,
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: "NO",
                                                        id: 'strEstadoCivilCLAP'
                                                    }
                                                ]
                                            }
                                        ]
                                    }
                                ]
                            },
                            { 
                                xtype: 'panel',
                                layout: 'form',
                                width:'300',
                                autoHeight: true,
                                padding: 7,
                                items: [     
                                    {
                                        xtype: 'fieldset',
                                        title: '',
                                        layout: 'form',
                                        collapsible: false,
                                        titleCollapse: false,
                                        autoHeight: true,
                                        padding: 5,
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                name:'Control Prenatal',
                                                fieldLabel: 'Control Prenatal En',
                                                allowBlank: false,
                                                id: 'strControPrenatalCLAP'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name:'Parto En',
                                                fieldLabel:'Parto En',
                                                allowBlank: false,
                                                id: 'strPartoCLAP'
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 100,
                                                fieldLabel:'Regimen',
                                                name: 'Regimen',
                                                allowBlank: false,
                                                store: 'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                value: "NO",
                                                id: 'strRegimenCLAP'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name:'Nombre eps',
                                                fieldLabel:'Nombre Eps/Ars',
                                                allowBlank: false,
                                                id: 'strNombreEpsCLAP'
                                            }
                                        ]
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        xtype: 'panel',
                        title: '<center>ANTECEDENTES</center>',
                        layout: 'table',
                        anchor: '100%',
                        boder: true,
                        autoHeight: true,
                        layoutConfig: {
                            columns: 2
                        },
                        items: [
                            {
                                xtype: 'panel',
                                title: 'FAMILIARES',
                                layout: 'form',
                                width: 475,
                                collapsible: true,
                                padding: 7,
                                titleCollapse: true,
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 100,
                                        fieldLabel: 'TBC',
                                        name: 'TBC',
                                        allowBlank: false,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        value: "NO",
                                        id: 'strAFTBCCLAP'
                                    },
                                    {
                                        xtype: 'combo',
                                        width: 100,
                                        fieldLabel: 'Diabetes',
                                        name: 'Diabetes',
                                        allowBlank: false,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        value: "NO",
                                        id: 'strAFDiabetesCLAP'
                                    },
                                    {
                                        xtype: 'combo',
                                        width: 100,
                                        fieldLabel: 'Hipertensión',
                                        name: 'Hipertensión',
                                        allowBlank: false,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        value: "NO",
                                        id: 'strAFHTACLAP'
                                    },
                                    {
                                        xtype: 'combo',
                                        width: 100,
                                        fieldLabel: 'Preclampsia Eclampsia',
                                        name: 'Preclampsia Eclampsia',
                                        allowBlank: false,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        value: "NO",
                                        id: 'strAFPreEclampsiaCLAP'
                                    },
                                    {
                                        xtype: 'combo',
                                        width: 100,
                                        fieldLabel:'Otros',
                                        name: 'Otros',
                                        allowBlank: false,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        value: "NO",
                                        id: 'strAFOtrosCLAP'
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'PERSONALES',
                                width: 470,
                                layout: 'table',
                                collapsible: true,
                                titleCollapse: true,
                                autoHeight: true,
                                layoutConfig: {
                                columns: 2
                                },
                                items: [
                                    {
                                        xtype: 'panel',
                                        layout: 'form',
                                        padding: 7,
                                        items:[
                                            {
                                                xtype: 'combo',
                                                width: 100,
                                                fieldLabel: 'TBC',
                                                name: 'TBC',
                                                allowBlank: false,
                                                store: 'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                value: "NO",
                                                id: 'strAPTBCClap'
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 100,
                                                fieldLabel: 'Diabetes',
                                                name: 'Diabetes',
                                                allowBlank: false,
                                                store: 'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                value: "NO",
                                                id: 'strAPDiabetesClap'
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 100,
                                                fieldLabel: 'Hipertensión',
                                                name: 'Hipertensión',
                                                allowBlank: false,
                                                store: 'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                value: "NO",
                                                id: 'strAPHTAClap'
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 100,
                                                fieldLabel: 'Preclampsia Eclampsia',
                                                name: 'Preclampsia Eclampsia',
                                                allowBlank: false,
                                                store: 'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                value: "NO",
                                                id: 'strAPPreEclampsiaCLAP'
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 100,
                                                fieldLabel:'Otros',
                                                name: 'Otros',
                                                allowBlank: false,
                                                store: 'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                value: "NO",
                                                id: 'strAPOtrosCLAP'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'panel',
                                        layout: 'form',
                                        items:[
                                            {
                                                xtype: 'combo',
                                                width: 100,
                                                fieldLabel: 'Cirugìa Pelvica',
                                                name: 'Cirugìa Pelvica',
                                                allowBlank: false,
                                                store: 'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                value: "NO",
                                                id: 'strAPCirPevicaCLAP'
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 100,
                                                fieldLabel:'Infertilidad',
                                                name: 'Infertilidad',
                                                allowBlank: false,
                                                store: 'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                value: "NO",
                                                id: 'strAPInfertilidadCLAP'
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 100,
                                                fieldLabel:'VIH+',
                                                name: 'VIH+',
                                                allowBlank: false,
                                                store: 'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                value: "NO",
                                                id: 'strAPVIHCLAP'
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 100,
                                                fieldLabel:'Cardiop/nefropatia',
                                                name: 'Cardio Nefropatia',
                                                allowBlank: false,
                                                store: 'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                value: "NO",
                                                id: 'strAPCarNefropatiaCLAP'
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 100,
                                                fieldLabel:'Cond.mèdica grave',
                                                name: 'Cond medica grave',
                                                allowBlank: false,
                                                store: 'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                value: "NO",
                                                id: 'strAPConMedicaCLAP'
                                            }
                                        ]
                                    }   
                                ]
                            }
                        ]
                    },
                    {
                        xtype: 'panel',
                        title: '<center>OBSTÈTRICOS</center>',
                        layout: 'form',
                        width: 475,
                        anchor:'100%',
                        collapsible: true,
                        padding: 7,
                        titleCollapse: true,
                        autoHeight: true,
                        items:[
                            {
                                xtype: 'fieldset',
                                title: '',
                                layout: 'form',
                                collapsible: false,
                                titleCollapse: false,
                                autoHeight: true,
                                padding: 5,
                                items: [
                                    {    
                                        xtype: 'fieldset',
                                        title: '',
                                        layout: 'form',
                                        collapsible: false,
                                        titleCollapse: false,
                                        autoHeight: true,
                                        padding: 5,
                                        items: [  
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        name:'Gestas Previas',
                                                        width:100,
                                                        fieldLabel:'Gestas Previas',
                                                        allowBlank: false,
                                                        id: 'intGesPreviasCLAP'
                                                    },
                                                    {
                                                        xtype: 'displayfield',
                                                        id: 'sysAbortoCLAP',
                                                        value: 'Aborto:'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        width:100,
                                                        name:'Abortos',
                                                        allowBlank: false,
                                                        id: 'intAbortoCLAP'   
                                                    },
                                                    {
                                                        xtype: 'displayfield',
                                                        id: 'sysVaginalesCLAP',
                                                        value: 'Vaginales:'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        width:100,
                                                        name:'Vaginales',
                                                        allowBlank: false,
                                                        id: 'intVaginalesCLAP'   
                                                    },
                                                    {
                                                        xtype: 'displayfield',
                                                        id: 'sysNacVivosCLAP',
                                                        value: 'Nac. Vivos:'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        width:100,
                                                        name:'Nac. Vivos',
                                                        allowBlank: false,
                                                        id: 'intNacVivosCLAP'   
                                                    },
                                                    {
                                                        xtype: 'displayfield',
                                                        id: 'sysVivenCLAP',
                                                        value: 'Viven:'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        width:100,
                                                        name:'Viven',
                                                        allowBlank: false,
                                                        id: 'intVivenCLAP'   
                                                    },
                                                ]
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        name:'Ultimo Previo',
                                                        width:100,
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: "NO",
                                                        fieldLabel:'Ùltimo Previo',
                                                        allowBlank: false,
                                                        id: 'intUltPrevioCLAP'
                                                    },
                                                    {
                                                        xtype: 'displayfield',
                                                        id: 'sysAbortCLAP',
                                                        value: '3 Espont. Consecutivo:'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        width:100,
                                                        name:'Espont. Consecutivo',
                                                        allowBlank: false,
                                                        id: 'intEspConsecutivoCLAP'   
                                                    },
                                                    {
                                                        xtype: 'displayfield',
                                                        id: 'sysMuertosSemCLAP',
                                                        value: 'Muertos 1 Sem:'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        width:100,
                                                        name:'Muertos 1 Sem',
                                                        allowBlank: false,
                                                        id: 'intMuertosSemCLAP'   
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        width:100,
                                                        name:'Partos',
                                                        allowBlank: false,
                                                        fieldLabel:'Partos',
                                                        id: 'intPartosCLAP'   
                                                    },
                                                    {
                                                        xtype: 'displayfield',
                                                        id: 'sysCesareasCLAP',
                                                        value:'Cesareas:'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        width:100,
                                                        name:'Cesareas',
                                                        allowBlank: false,
                                                        id: 'intCesareasCLAP'   
                                                    },
                                                    {
                                                        xtype: 'displayfield',
                                                        id: 'sysNacMuertosCLAP',
                                                        value: 'Nac. Muertos:'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        width:100,
                                                        name:'Nac. Muertos',
                                                        allowBlank: false,
                                                        id: 'intNacMuertosCLAP'   
                                                    },
                                                    {
                                                        xtype: 'displayfield',
                                                        id: 'sysDesSemestreCLAP',
                                                        value: 'Despues 1 Semestre:'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        width:100,
                                                        name:'Despues 1 Semestre',
                                                        allowBlank: false,
                                                        id: 'intDesSemestreCLAP'   
                                                    }
                                                ]    
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'fieldset',
                                        title: '',
                                        layout: 'form',
                                        collapsible: false,
                                        titleCollapse: false,
                                        autoHeight: true,
                                        padding: 5,
                                        items: [
                                            {  
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        anchor:'100%',
                                                        name:'Fin Embarazo Anterior',
                                                        allowBlank: false,
                                                        fieldLabel:'Fin Embarazo Anterior',
                                                        id: 'strFinEmbAnteriorCLAP'   
                                                    },
                                                    {
                                                        xtype: 'displayfield',
                                                        id: 'sysMenorAñosCLAP',
                                                        value:'Menor 1 Año / Mas De 5 Años:'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name:'menor 1 año /mas de 5 años',
                                                        anchor:'100%',
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: "NO",
                                                        allowBlank: false,
                                                        id: 'intMenorAñosCLAP'
                                                    }
                                                ]    
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        name:'Fracaso De Metòdo Anti.',
                                                        anchor:'100%',
                                                        store: 'StoreSiNo',
                                                        fieldLabel:'Fracaso De Metòdo Anti',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: "NO",
                                                        allowBlank: false,
                                                        id: 'strFracMetAntiCLAP'
                                                    },
                                                    {
                                                        xtype: 'displayfield',
                                                        id: 'sysEmbPlaneadoCLAP',
                                                        value:'Embarazo Planeado/Deseado'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name:'Embarazo Planeado.',
                                                        anchor:'100%',
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: "NO",
                                                        allowBlank: false,
                                                        id: 'strEmbPlaneadoCLAP'
                                                    },
                                                ]       
                                            }
                                        ]
                                    } 
                                ]
                            }
                        ]
                    },
                    {
                        xtype: 'panel',
                        title: '<center>GESTACIÒN ACTUAL</center>',
                        layout: 'form',
                        width: 475,
                        anchor:'100%',
                        collapsible: true,
                        padding: 7,
                        titleCollapse: true,
                        autoHeight: true,
                        items:[
                            {
                                xtype: 'fieldset',
                                title: '',
                                layout: 'form',
                                collapsible: false,
                                titleCollapse: false,
                                autoHeight: true,
                                padding: 5,
                                items: [
                                    {    
                                        xtype: 'fieldset',
                                        title: '',
                                        layout: 'form',
                                        collapsible: false,
                                        titleCollapse: false,
                                        autoHeight: true,
                                        padding: 5,
                                        items: [  
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        anchor:'100%',
                                                        width:100,
                                                        name:'Peso Anterior',
                                                        allowBlank: false,
                                                        fieldLabel:'Peso Anterior',
                                                        id: 'strPesAnteriorCLAP'   
                                                    },
                                                    {
                                                        xtype: 'displayfield',
                                                        id: 'sysTallaCLAP',
                                                        value:'Talla:'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        width:100,
                                                        anchor:'100%',
                                                        name:'Talla',
                                                        allowBlank: false,
                                                        id: 'strTallaCLAP'   
                                                    },
                                                    {
                                                        xtype: 'displayfield',                                                   
                                                        id: 'sysGesNumeroCLAP',
                                                        value:'Gestaciòn Nùmero:'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor:'100%',
                                                        width:100,
                                                        name:'Gestacion Numero',
                                                        allowBlank: false,
                                                        id: 'intGesNumeroCLAP'   
                                                    },
                                                    {
                                                        xtype: 'displayfield',
                                                        id: 'sysFUMCLAP',
                                                        value:'FUM:'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor:'100%',
                                                        name:'FUM',
                                                        width:100,
                                                        allowBlank: false,
                                                        id: 'strFUMCLAP'   
                                                    },
                                                    {
                                                        xtype: 'displayfield',
                                                        id: 'sysFPPCLAP',
                                                        value:'FPP:'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor:'100%',
                                                        name:'FPP',
                                                        width:100,
                                                        allowBlank: false,
                                                        id: 'strFPPCLAP'   
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        name:'Eg Confiable Por FUM',
                                                        anchor:'100%',
                                                        width:50,
                                                        fieldLabel:'Eg Confiable Por FUM',
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: "NO",
                                                        allowBlank: false,
                                                        id: 'strEgConFUMCLAP'
                                                    },
                                                    {
                                                        xtype: 'displayfield',
                                                        id: 'sysEcoCLAP',
                                                        value:'Eco < 20s:'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name:'eco<20s',
                                                        width:50,
                                                        anchor:'100%',
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: "NO",
                                                        allowBlank: false,
                                                        id: 'strEcoFUMCLAP'
                                                    },
                                                    {
                                                        xtype: 'displayfield',
                                                        id: 'sysFumaCLAP',
                                                        value:'Fuma:'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name:'Fuma',
                                                        width:50,
                                                        anchor:'100%',
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: "NO",
                                                        allowBlank: false,
                                                        id: 'strFumaCLAP'
                                                    },
                                                    {
                                                        xtype: 'displayfield',
                                                        id: 'sysCigDiaCLAP',
                                                        value:'Cigarrillos Por Dia:'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor:'100%',
                                                        name:'Cigarrillos Por Dia',
                                                        width:50,
                                                        allowBlank: false,
                                                        id: 'strCigDiaCLAP'   
                                                    },
                                                    {
                                                        xtype: 'displayfield',
                                                        id: 'sysAlcoholCLAP',
                                                        value:'Alcohol:'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name:'Alcohol',
                                                        anchor:'100%',
                                                        store: 'StoreSiNo',
                                                        width:50,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: "NO",
                                                        allowBlank: false,
                                                        id: 'strAlcoholCLAP'
                                                    },
                                                    {
                                                        xtype: 'displayfield',
                                                        id: 'sysDrogasCLAP',
                                                        value:'Drogas:'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name:'Drogas',
                                                        width:50,
                                                        anchor:'100%',
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: "NO",
                                                        allowBlank: false,
                                                        id: 'strDrogasCLAP'
                                                    }
                                                ] 
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        name:'Hierro',
                                                        anchor:'100%',
                                                        width:50,
                                                        fieldLabel:'Hierro',
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: "NO",
                                                        allowBlank: false,
                                                        id: 'strHierroFUMCLAP'
                                                    },
                                                    {
                                                        xtype: 'displayfield',
                                                        id: 'sysFolatoCLAP',
                                                        value:'Folato:'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name:'Folato',
                                                        width:50,
                                                        anchor:'100%',
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: "NO",
                                                        allowBlank: false,
                                                        id: 'strFolatoCLAP'
                                                    },
                                                    {
                                                        xtype: 'displayfield',
                                                        id: 'sysAntVigenteCLAP',
                                                        value:'Antitetanica Vigente:'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name:'Antitetanica Vigente',
                                                        width:50,
                                                        anchor:'100%',
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: "NO",
                                                        allowBlank: false,
                                                        id: 'strAntVigenteCLAP'
                                                    },
                                                    {
                                                        xtype: 'displayfield',
                                                        id: 'sys1raDosisCLAP',
                                                        value:'1ra Dosis:'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor:'100%',
                                                        name:'1ra Dosis',
                                                        width:50,
                                                        allowBlank: false,
                                                        id: 'str1raDosisCLAP'   
                                                    },
                                                    {
                                                        xtype: 'displayfield',
                                                        id: 'sys2raDosisCLAP',
                                                        value:'2ra Dosis:'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor:'100%',
                                                        name:'2ra Dosis',
                                                        width:50,
                                                        allowBlank: false,
                                                        id: 'str2raDosisCLAP'   
                                                    }
                                                ] 
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'fieldset',
                                        title: '',
                                        layout: 'form',
                                        collapsible: false,
                                        titleCollapse: false,
                                        autoHeight: true,
                                        padding: 5,
                                        items: [ 
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items:[
                                                    {
                                                        xtype: 'combo',
                                                        name:'Anti-Rubeola',
                                                        anchor:'100%',
                                                        width:50,
                                                        fieldLabel:'Anti-Rubeola',
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: "NO",
                                                        allowBlank: false,
                                                        id: 'strAnRubeolaCLAP'
                                                    },
                                                    {
                                                        xtype: 'displayfield',
                                                        id: 'sysCitologiaCLAP',
                                                        value:'Citologia:'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name:'Citologia',
                                                        anchor:'100%',
                                                        width:50,
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: "NO",
                                                        allowBlank: false,
                                                        id: 'strCitologiaCLAP'
                                                    },
                                                    {
                                                        xtype: 'displayfield',
                                                        id: 'sysColposcopiaCLAP',
                                                        value:'Colposcopia:'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name:'Colposcopia',
                                                        anchor:'100%',
                                                        width:50,
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: "NO",
                                                        allowBlank: false,
                                                        id: 'strColposcopiaCLAP'
                                                    },
                                                    {
                                                        xtype: 'displayfield',
                                                        id: 'sysExNormOdonCLAP',
                                                        value:'Ex. Normal: Odont:'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name:'Ex. Normal: Odont',
                                                        anchor:'100%',
                                                        width:50,
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: "NO",
                                                        allowBlank: false,
                                                        id: 'strExNormOdonCLAP'
                                                    },
                                                    {
                                                        xtype: 'displayfield',
                                                        id: 'sysMamasCLAP',
                                                        value:'Mamas:'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name:'Mamas',
                                                        anchor:'100%',
                                                        width:50,
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: "NO",
                                                        allowBlank: false,
                                                        id: 'strMamasCLAP'
                                                    },
                                                    {
                                                        xtype: 'displayfield',
                                                        id: 'sysCervisCLAP',
                                                        value:'Cervis:'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name:'Cervis',
                                                        anchor:'100%',
                                                        width:50,
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: "NO",
                                                        allowBlank: false,
                                                        id: 'strCervisCLAP'
                                                    }
                                                ]
                                            }
                                        ] 
                                    }
                                ]
                            } 
                        ]
                    },
                    {
                        xtype: 'panel',
                        anchor:'100%',
                        layout: 'table',
                        autoHeight: true,
                        border:true,
                        layoutConfig: {
                        columns: 3
                        },
                        items:[
                            {
                                xtype: 'panel',
                                title: '<center>INGRESO</center>',
                                layout: 'form',
                                width: 430,
                                anchor:'100%',
                                collapsible: true,
                                padding: 7,
                                titleCollapse: true,
                                height: 180,
                                items:[
                                    {    
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                anchor:'100%',
                                                fieldLabel:'Grupo',
                                                name:'Grupo',
                                                width:50,
                                                allowBlank: false,
                                                id: 'strGrupoCLAP'   
                                            },
                                            {
                                                xtype: 'displayfield',
                                                id: 'sysRHCLAP',
                                                value:'RH:'
                                            },
                                            {
                                                xtype: 'combo',
                                                name:'RH',
                                                anchor:'100%',
                                                width:50,
                                                store: 'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                value: "NO",
                                                allowBlank: false,
                                                id: 'strRHCLAP'
                                            },
                                            {
                                                xtype: 'displayfield',
                                                id: 'sysSensibilCLAP',
                                                value:'Sensibil:'
                                            },
                                            {
                                                xtype: 'combo',
                                                name:'Sensibil',
                                                width:50,
                                                anchor:'100%',
                                                store: 'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                value: "NO",
                                                allowBlank: false,
                                                id: 'strSensibilCLAP'
                                            }
                                        ] 
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'combo',
                                                name:'VIH Cconsejeria',
                                                anchor:'100%',
                                                width:50,
                                                fieldLabel:'VIH Cconsejeria',
                                                store: 'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                value: "NO",
                                                allowBlank: false,
                                                id: 'strVIHConsejeriaCLAP'
                                            },
                                            {
                                                xtype: 'displayfield',
                                                id: 'sysSolicitadoCLAP',
                                                value:'Solicidato:'
                                            },
                                            {
                                                xtype: 'combo',
                                                name:'Solicitado',
                                                anchor:'100%',
                                                width:50,
                                                fieldLabel:'Solicitado',
                                                store: 'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                value: "NO",
                                                allowBlank: false,
                                                id: 'strSolicitadoCLAP'
                                            },
                                            {
                                                xtype: 'displayfield',
                                                id: 'sysUroanalisisCLAP',
                                                value:'Uroanalisis:'
                                            },
                                            {
                                                xtype: 'combo',
                                                name:'Uroanalisis',
                                                width:75,
                                                anchor:'100%',
                                                store: 'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                value: "NO",
                                                allowBlank: false,
                                                id: 'strUroanalisisCLAP'
                                            }
                                        ] 
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                anchor:'100%',
                                                fieldLabel:'Hb < 14 Sem',
                                                name:'Hb < 14 Sem',
                                                width:50,
                                                allowBlank: false,
                                                id: 'strHBCLAP'   
                                            },
                                            {
                                                xtype: 'displayfield',
                                                id: 'sysHBCLAP',
                                                value:'-'
                                            },
                                            {
                                                xtype: 'textfield',
                                                anchor:'100%',
                                                name:'Hb1 < 14 Sem',
                                                width:50,
                                                allowBlank: false,
                                                id: 'strHB1CLAP'   
                                            },
                                            {
                                                xtype: 'combo',
                                                name:'cbHB',
                                                anchor:'100%',
                                                width:100,
                                                store: 'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                value: "NO",
                                                allowBlank: false,
                                                id: 'strHbCbCLAP'
                                            }
                                        ] 
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'combo',
                                                name:'Glicemia Ayunas',
                                                anchor:'100%',
                                                fieldLabel:'Glicemia Ayunas',
                                                width:100,
                                                store: 'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                value: "NO",
                                                allowBlank: false,
                                                id: 'strGliAyunasCLAP'
                                            },
                                            {
                                                xtype: 'displayfield',
                                                id: 'sysVDRLCLAP',
                                                value:'VDRL < 14 Sem:'
                                            },
                                            {
                                                xtype: 'combo',
                                                name:'VDRL < 14 Sem',
                                                anchor:'100%',
                                                width:100,
                                                store: 'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                value: "NO",
                                                allowBlank: false,
                                                id: 'strVDRLCLAP'
                                            }
                                        ] 
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'combo',
                                                name:'Ecografia < 14 Sem:',
                                                anchor:'100%',
                                                width:150,
                                                fieldLabel:'Ecografia < 14 Sem',
                                                store: 'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                value: "NO",
                                                allowBlank: false,
                                                id: 'strEcografiaCLAP'
                                            }
                                        ] 
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: '<center>2do TRIMESTRE</center>',
                                layout: 'form',
                                width: 250,
                                anchor:'100%',
                                collapsible: true,
                                padding: 7,
                                titleCollapse: true,
                                height: 180,
                                items:[
                                    {
                                        xtype: 'combo',
                                        name:'Uroanalisis ',
                                        anchor:'100%',
                                        fieldLabel:'Uroanalisis 2do trimestre',
                                        width:50,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        value: "NO",
                                        allowBlank: false,
                                        id: 'str2TriUroanalisisCLAP'
                                    },
                                    {
                                        xtype: 'combo',
                                        name:'Test O.Sullivan',
                                        width:50,
                                        fieldLabel:'Test O.Sullivan',
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        anchor:'100%',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        value: "NO",
                                        allowBlank: false,
                                        id: 'strTesSullivanCLAP'
                                    },
                                    {
                                        xtype: 'combo',
                                        name:'Ecografia',
                                        width:50,
                                        anchor:'100%',
                                        fieldLabel:'Ecografia',
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        value: "NO",
                                        allowBlank: false,
                                        id: 'str2TriEcografiaCLAP'
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: '<center>3er TRIMESTRE</center>',
                                layout: 'form',
                                width: 250,
                                anchor:'100%',
                                collapsible: true,
                                padding: 7,
                                titleCollapse: true,
                                height: 180,
                                items:[
                                    {
                                        xtype: 'combo',
                                        name:'Uroanalisis ',
                                        anchor:'100%',
                                        fieldLabel:'Uroanalisis 3er trimestre',
                                        width:50,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        value: "NO",
                                        allowBlank: false,
                                        id: 'str3TriUroanalisisCLAP'
                                    },
                                    {
                                        xtype: 'combo',
                                        name:'VRDL>27 sem',
                                        width:50,
                                        fieldLabel:'VRDL > 27 Sem',
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        anchor:'100%',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        value: "NO",
                                        allowBlank: false,
                                        id: 'str3TriVRDLCLAP'
                                    },
                                    {
                                        xtype: 'combo',
                                        name:'Sifilis',
                                        width:50,
                                        anchor:'100%',
                                        fieldLabel:'Sifilis',
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        value: "NO",
                                        allowBlank: false,
                                        id: 'str2TriSifilisCLAP'
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        xtype: 'fieldset',
                        title: 'Notas :',
                        layout: 'table',
                        collapsible: false,
                        titleCollapse: false,
                        autoHeight: true,
                        padding: 5,
                        items: [ 
                            {
                                xtype: 'textarea',
                                name:'Notas',
                                width: 880,
                                allowBlank: false,
                                id: 'strNotasCLAP'
                            }
                        ] 
                    },
                    {
                        xtype: 'grid',
                        title: '<CENTER>Toma de Signos</CENTER>',
                        height: 235,
                        ANCHOR: '100%',
                        border: true,
                        store: 'StoreSiNo',
                        id: 'gridClap',
                        columns :[
                            {
                                xtype: 'gridcolumn',
                                header: 'Profesional',
                                sortable: false,
                                width: 330,
                                hidden: false,
                                hideable: false
                            },
                            {
                                xtype: 'gridcolumn',
                                header: 'FecReporte',
                                sortable: false,
                                width: 330,
                                hidden: false,
                                hideable: false
                            },
                            {
                                xtype: 'gridcolumn',
                                header: 'Peso',
                                sortable: false,
                                width: 330,
                                hidden: false,
                                hideable: false
                            },
                            {
                                xtype: 'gridcolumn',
                                header: 'Talla',
                                sortable: false,
                                width: 330,
                                hidden: false,
                                hideable: false
                            },
                            {
                                xtype: 'gridcolumn',
                                header: 'IMC',
                                sortable: false,
                                width: 330,
                                hidden: false,
                                hideable: false
                            },
                            {
                                xtype: 'gridcolumn',
                                header: 'PC',
                                sortable: false,
                                width: 330,
                                hidden: false,
                                hideable: false
                            },
                            {
                                xtype: 'gridcolumn',
                                header: 'TE',
                                sortable: false,
                                width: 330,
                                hidden: false,
                                hideable: false
                            },
                            {
                                xtype: 'gridcolumn',
                                header: 'FC',
                                sortable: false,
                                width: 330,
                                hidden: false,
                                hideable: false
                            },
                            {
                                xtype: 'gridcolumn',
                                header: 'FR',
                                sortable: false,
                                width: 330,
                                hidden: false,
                                hideable: false
                            },
                            {
                                xtype: 'gridcolumn',
                                header: 'P.Adbo',
                                sortable: false,
                                width: 330,
                                hidden: false,
                                hideable: false
                            }
                        ]
                    },
                    {
                        xtype: 'panel',
                        layout: 'table',
                        anchor:'100%',
                        autoHeight: true,
                        padding: 7,
                        layoutConfig: {
                            columns: 2
                        },
                        items:[
                            {
                                xtype: 'panel',
                                layout: 'form',
                                width:500,
                                height:370,
                                items:[
                                    {
                                        xtype: 'fieldset',
                                        title: 'Enfermedades',
                                        layout: 'form',
                                        height:360,
                                        width:490,
                                        collapsible: false,
                                        titleCollapse: false,
                                        padding: 5,
                                        items: [
                                            {
                                                xtype: 'panel',
                                                layout: 'table',
                                                width:470,
                                                height:350,
                                                layoutConfig: {
                                                    columns: 2
                                                },
                                                items:[
                                                    {
                                                        xtype: 'panel',
                                                        layout: 'form',
                                                        width:190,
                                                        height:300,
                                                        items:[
                                                            {
                                                                xtype: 'combo',
                                                                width: 50,
                                                                fieldLabel: 'HTA Crònica',
                                                                name: 'HTA Crònica',
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strHTACronicaClap'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 50,
                                                                fieldLabel: 'HTA',
                                                                name: 'HTA',
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strHTAClap'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 50,
                                                                fieldLabel: 'Gestacional',
                                                                name: 'Gestacional',
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strGestacionalClap'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 50,
                                                                fieldLabel: 'Preeclampsia',
                                                                name: 'Preeclampsia',
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strEnfPreeclampsiaClap'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 50,
                                                                fieldLabel: 'Eclampsia',
                                                                name: 'Eclampsia',
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strEnfEclampsiaClap'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 50,
                                                                fieldLabel: 'Cardipatia',
                                                                name: 'Cardipatia',
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strEnfCardipatiaClap'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 50,
                                                                fieldLabel: 'Nefropatia',
                                                                name: 'Nefropatia',
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strEnfNefropatiaClap'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 50,
                                                                fieldLabel: 'Diabetes',
                                                                name: 'Diabetes',
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strEnfDiabetesClap'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 50,
                                                                fieldLabel: 'Anemia',
                                                                name: 'Anemia',
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strEnfAnemiaClap'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        layout: 'form',
                                                        width:320,
                                                        height:300,
                                                        autoHeight: true,
                                                        items:[
                                                            {
                                                                xtype: 'combo',
                                                                width: 50,
                                                                fieldLabel: 'Infec. Urinaria',
                                                                name: 'Infec. Urinaria',
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strInfUrinariaClap'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 50,
                                                                fieldLabel: 'Amenaza Parto Pretermino',
                                                                name: 'Amenaza Parto Pretermino',
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strAmeParPreterminoClap'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 50,
                                                                fieldLabel: 'R.C.I.U.',
                                                                name: 'R.C.I.U.',
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strRCIUClap'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 50,
                                                                fieldLabel: 'Ruptura Prem De Membranas',
                                                                name: 'Ruptura Prem De Membranas',
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strRupPreMembranasClap'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 50,
                                                                fieldLabel: 'Corio-amnionitis',
                                                                name: 'Corio-amnionitis',
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strCoriamnionitisClap'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 50,
                                                                fieldLabel: 'Otras Graves',
                                                                name: 'Otras Graves',
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strOtraGravesClap'
                                                            },
                                                            {
                                                                xtype: 'fieldset',
                                                                layout: 'form',
                                                                width:270,
                                                                collapsible: false,
                                                                titleCollapse: false,
                                                                autoHeight: true,
                                                                padding: 5,
                                                                items:[
                                                                    { 
                                                                        xtype: 'panel',
                                                                        layout: 'form',
                                                                        anchor:'100%',
                                                                        width:180,
                                                                        autoHeight: true,
                                                                        items:[
                                                                            { 
                                                                                xtype: 'compositefield',
                                                                                style: 'background:transparent;',
                                                                                items: [
                                                                                    {
                                                                                        xtype: 'displayfield',
                                                                                        id: 'sysHemorragiaCLAP',
                                                                                        value:'HEMORRAGIA'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'displayfield',
                                                                                        id: 'sysEnfCodigoCLAP',
                                                                                        value:'CÒDIGO'
                                                                                    }
                                                                                ]
                                                                            },
                                                                            {
                                                                                xtype: 'compositefield',
                                                                                style: 'background:transparent;',
                                                                                items: [
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '1er Trim',
                                                                                        name: '1er Trim',
                                                                                        allowBlank: false,
                                                                                        store: 'StoreSiNo',
                                                                                        valueField: 'Descripcion',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: "NO",
                                                                                        id: 'strHem1erTrimClap'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'displayfield',
                                                                                        id: 'sysseparador1CLAP',
                                                                                        value:'---'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        anchor:'100%',
                                                                                        name:'Codigo 1er Trim',
                                                                                        width:50,
                                                                                        allowBlank: false,
                                                                                        id: 'strCod1erTrimClap'
                                                                                    }
                                                                                ]
                                                                            },
                                                                            {
                                                                                xtype: 'compositefield',
                                                                                style: 'background:transparent;',
                                                                                items: [
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '2er Trim',
                                                                                        name: '2er Trim',
                                                                                        allowBlank: false,
                                                                                        store: 'StoreSiNo',
                                                                                        valueField: 'Descripcion',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: "NO",
                                                                                        id: 'strHem2erTrimClap'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'displayfield',
                                                                                        id: 'sysseparador2CLAP',
                                                                                        value:'---'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        anchor:'100%',
                                                                                        name:'Codigo 2er Trim',
                                                                                        width:50,
                                                                                        allowBlank: false,
                                                                                        id: 'strCod2erTrimClap'
                                                                                    }
                                                                                ]
                                                                            },
                                                                            {
                                                                                xtype: 'compositefield',
                                                                                style: 'background:transparent;',
                                                                                items: [
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '3er Trim',
                                                                                        name: '3er Trim',
                                                                                        allowBlank: false,
                                                                                        store: 'StoreSiNo',
                                                                                        valueField: 'Descripcion',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: "NO",
                                                                                        id: 'strHem3erTrimClap'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'displayfield',
                                                                                        id: 'sysseparador3CLAP',
                                                                                        value:'---'
                                                                                    },
                                                                                    {  
                                                                                        xtype: 'textfield',
                                                                                        anchor:'100%',
                                                                                        name:'Codigo 3er Trim',
                                                                                        width:50,
                                                                                        allowBlank: false,
                                                                                        id: 'strCod3erTrimClap'
                                                                                    }
                                                                                ]
                                                                            } 
                                                                        ]
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    }
                                                ]
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'fieldset',
                                layout: 'form',
                                collapsible: false,
                                titleCollapse: false,
                                height:400,
                                width:420,
                                padding:7,
                                items:[
                                    {
                                        xtype: 'panel',
                                        layout: 'form',
                                        width:390,
                                        height: 390,
                                        items:[
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'fieldset',
                                                        layout: 'table',
                                                        collapsible: false,
                                                        titleCollapse: false,
                                                        autoHeight: true,
                                                        padding: 5,
                                                        items:[
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysPartoCLAP',
                                                                value:'Parto:'
                                                            },
                                                            { 
                                                                xtype: 'combo',
                                                                width: 70,
                                                                //fieldLabel: 'Parto',
                                                                name: 'EnfParto',
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strEnfPartoClap'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysEnfAbortoCLAP',
                                                                value:'Aborto:'
                                                            },
                                                            { 
                                                                xtype: 'combo',
                                                                width: 70,
                                                                name: 'EnfAborto',
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strEnfAbortoClap'
                                                            }
                                                        ]
                                                    }
                                                    
                                                ]                                                    
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'datefield',
                                                        anchor:'100%',
                                                        name:'Fecha Ingreso Carne',
                                                        width:90,
                                                        fieldLabel:'(Fecha Ingreso, Carnè)',
                                                        allowBlank: false,
                                                        id: 'fecIngCarneClap'
                                                    },
                                                    {
                                                        xtype: 'displayfield',
                                                        id: 'sysseparadorfechaCLAP',
                                                        value:'-'
                                                    },
                                                    { 
                                                        xtype: 'combo',
                                                        width: 70,
                                                        name: 'cbFecCarne',
                                                        allowBlank: false,
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: "NO",
                                                        id: 'strCbFecCarneClap'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        name:'Consultas Prenatales',
                                                        width:150,
                                                        fieldLabel:'Consultas Prenatales',
                                                        allowBlank: false,
                                                        id: 'strConPrenatalesClap'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        fieldLabel:'Hospitaliz. Embarazo Dias',
                                                        name:'Hospitaliz. Embarazo Dias',
                                                        width:150,
                                                        allowBlank: false,
                                                        id: 'strHosEmbDiaClap'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    { 
                                                        xtype: 'combo',
                                                        width: 60,
                                                        name: 'Corticoides Antenatales',
                                                        fieldLabel:'Corticoides Antenatales',
                                                        allowBlank: false,
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: "NO",
                                                        id: 'strCorAntenatalesClap'
                                                    },
                                                    {
                                                        xtype: 'displayfield',
                                                        id: 'sysSemInicioCLAP',
                                                        value:'Semana Inicio:'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor:'100%',
                                                        name:'Semana Inicio',
                                                        width:50,
                                                        allowBlank: false,
                                                        id: 'strSemInicioClap'
                                                    },
                                                    {
                                                        xtype: 'displayfield',
                                                        id: 'sysNCCLAP',
                                                        value:'N/C:'
                                                    },
                                                    { 
                                                        xtype: 'combo',
                                                        width: 50,
                                                        name: 'cbN/C',
                                                        allowBlank: false,
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: "NO",
                                                        id: 'strNCClap'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    { 
                                                        xtype: 'combo',
                                                        width: 60,
                                                        name: 'Inicio T De P',
                                                        fieldLabel:'Inicio T De P',
                                                        allowBlank: false,
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: "NO",
                                                        id: 'strIniTPClap'
                                                    },
                                                    {
                                                        xtype: 'displayfield',
                                                        id: 'sysRupturaCLAP',
                                                        value:'Ruptura:'
                                                    },
                                                    { 
                                                        xtype: 'combo',
                                                        width: 60,
                                                        name: 'Ruptura',
                                                        allowBlank: false,
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: "NO",
                                                        id: 'strRupturaClap'
                                                    },
                                                    {
                                                        xtype: 'displayfield',
                                                        id: 'sysRuptura1CLAP',
                                                        value:'-'
                                                    },
                                                    { 
                                                        xtype: 'combo',
                                                        width: 80,
                                                        name: 'Ruptura1',
                                                        allowBlank: false,
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: "NO",
                                                        id: 'strRuptura1Clap'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'datefield',
                                                        anchor:'100%',
                                                        fieldLabel:'Fecha',
                                                        name:'Fecha',
                                                        width:100,
                                                        allowBlank: false,
                                                        id: 'fecfecha1Clap'
                                                    },
                                                    {
                                                        xtype: 'displayfield',
                                                        id: 'sysHora1LAP',
                                                        value:'Hora:'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor:'100%',
                                                        name:'Hora',
                                                        width:100,
                                                        allowBlank: false,
                                                        id: 'strHora1Clap'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        width:200,
                                                        fieldLabel:'Desc',
                                                        name:'Descripcion',
                                                        allowBlank: false,
                                                        id: 'strDescripcionClap'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        name:'Horas Entre Ruptura y Parto',
                                                        fieldLabel:'Horas Entre Ruptura y Parto',
                                                        width:90,
                                                        allowBlank: false,
                                                        id: 'strHorRupPartoClap'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'displayfield',
                                                        id: 'sysEdaGesPartoCLAP',
                                                        value:'Edad Gestacional Al Parto:'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        name:'Sem',
                                                        fieldLabel:'Sem',
                                                        width:40,
                                                        allowBlank: false,
                                                        id: 'strSEMClap'
                                                    },
                                                    {
                                                        xtype: 'displayfield',
                                                        id: 'sysDiasCLAP',
                                                        value:'Dias:'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        name:'Dias',
                                                        width:30,
                                                        allowBlank: false,
                                                        id: 'strDiasClap'
                                                    },
                                                    {
                                                        xtype: 'displayfield',
                                                        id: 'sysFUMCLAP',
                                                        value:'FUM:'
                                                    },
                                                    { 
                                                        xtype: 'combo',
                                                        width: 50,
                                                        name: 'FUM',
                                                        allowBlank: false,
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: "NO",
                                                        id: 'strFUMClap'
                                                    },
                                                    {
                                                        xtype: 'displayfield',
                                                        id: 'sysECOCLAP',
                                                        value:'ECO:'
                                                    },
                                                    { 
                                                        xtype: 'combo',
                                                        width: 50,
                                                        name: 'ECO',
                                                        allowBlank: false,
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: "NO",
                                                        id: 'strECOClap'
                                                    }
                                                ]
                                            }
                                        ]
                                    } 
                                ]
                            }
                        ]
                    },
                    /*
                    {
                        xtype: 'panel',
                        layout: 'table',
                        anchor:'100%',
                        autoHeight: true,
                        padding: 7,
                        layoutConfig: {
                            columns: 2
                        },
                        items: [
                            { 
                                xtype: 'panel',
                                layout: 'form',
                                width:490,
                                height: 300,
                                items:[
                                    {
                                        xtype: 'fieldset',
                                        title: 'Enfermedades',
                                        layout: 'form',
                                        width:480,
                                        collapsible: false,
                                        titleCollapse: false,
                                        autoHeight: true,
                                        padding: 5,
                                        items: [  
                                            { 
                                                xtype: 'panel',
                                                layout: 'table',
                                                width:470,
                                                anchor:'100%',
                                                autoHeight: true,
                                                layoutConfig: {
                                                    columns: 2
                                                },
                                                items:[
                                                    {
                                                        xtype: 'panel',
                                                        layout: 'form',
                                                        anchor:'100%',
                                                        width:190,
                                                        autoHeight: true,
                                                        items:[
                                                            {
                                                                xtype: 'combo',
                                                                width: 50,
                                                                fieldLabel: 'HTA Crònica',
                                                                name: 'HTA Crònica',
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strHTACronicaClap'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 50,
                                                                fieldLabel: 'HTA',
                                                                name: 'HTA',
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strHTAClap'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 50,
                                                                fieldLabel: 'Gestacional',
                                                                name: 'Gestacional',
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strGestacionalClap'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 50,
                                                                fieldLabel: 'Preeclampsia',
                                                                name: 'Preeclampsia',
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strEnfPreeclampsiaClap'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 50,
                                                                fieldLabel: 'Eclampsia',
                                                                name: 'Eclampsia',
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strEnfEclampsiaClap'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 50,
                                                                fieldLabel: 'Cardipatia',
                                                                name: 'Cardipatia',
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strEnfCardipatiaClap'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 50,
                                                                fieldLabel: 'Nefropatia',
                                                                name: 'Nefropatia',
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strEnfNefropatiaClap'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 50,
                                                                fieldLabel: 'Diabetes',
                                                                name: 'Diabetes',
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strEnfDiabetesClap'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 50,
                                                                fieldLabel: 'Anemia',
                                                                name: 'Anemia',
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strEnfAnemiaClap'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        layout: 'form',
                                                        width:320,
                                                        anchor:'100%',
                                                        autoHeight: true,
                                                        items:[
                                                            {
                                                                xtype: 'combo',
                                                                width: 50,
                                                                fieldLabel: 'Infec. Urinaria',
                                                                name: 'Infec. Urinaria',
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strInfUrinariaClap'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 50,
                                                                fieldLabel: 'Amenaza Parto Pretermino',
                                                                name: 'Amenaza Parto Pretermino',
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strAmeParPreterminoClap'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 50,
                                                                fieldLabel: 'R.C.I.U.',
                                                                name: 'R.C.I.U.',
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strRCIUClap'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 50,
                                                                fieldLabel: 'Ruptura Prem De Membranas',
                                                                name: 'Ruptura Prem De Membranas',
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strRupPreMembranasClap'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 50,
                                                                fieldLabel: 'Corio-amnionitis',
                                                                name: 'Corio-amnionitis',
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strCoriamnionitisClap'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 50,
                                                                fieldLabel: 'Otras Graves',
                                                                name: 'Otras Graves',
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strOtraGravesClap'
                                                            },
                                                            {
                                                                xtype: 'fieldset',
                                                                layout: 'form',
                                                                width:270,
                                                                collapsible: false,
                                                                titleCollapse: false,
                                                                autoHeight: true,
                                                                padding: 5,
                                                                items:[
                                                                    { 
                                                                        xtype: 'panel',
                                                                        layout: 'form',
                                                                        anchor:'100%',
                                                                        width:180,
                                                                        autoHeight: true,
                                                                        items:[
                                                                            { 
                                                                                xtype: 'compositefield',
                                                                                style: 'background:transparent;',
                                                                                items: [
                                                                                    {
                                                                                        xtype: 'displayfield',
                                                                                        id: 'sysHemorragiaCLAP',
                                                                                        value:'HEMORRAGIA'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'displayfield',
                                                                                        id: 'sysEnfCodigoCLAP',
                                                                                        value:'CÒDIGO'
                                                                                    }
                                                                                ]
                                                                            },
                                                                            {
                                                                                xtype: 'compositefield',
                                                                                style: 'background:transparent;',
                                                                                items: [
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '1er Trim',
                                                                                        name: '1er Trim',
                                                                                        allowBlank: false,
                                                                                        store: 'StoreSiNo',
                                                                                        valueField: 'Descripcion',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: "NO",
                                                                                        id: 'strHem1erTrimClap'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'displayfield',
                                                                                        id: 'sysseparador1CLAP',
                                                                                        value:'---'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        anchor:'100%',
                                                                                        name:'Codigo 1er Trim',
                                                                                        width:50,
                                                                                        allowBlank: false,
                                                                                        id: 'strCod1erTrimClap'
                                                                                    }
                                                                                ]
                                                                            },
                                                                            {
                                                                                xtype: 'compositefield',
                                                                                style: 'background:transparent;',
                                                                                items: [
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '2er Trim',
                                                                                        name: '2er Trim',
                                                                                        allowBlank: false,
                                                                                        store: 'StoreSiNo',
                                                                                        valueField: 'Descripcion',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: "NO",
                                                                                        id: 'strHem2erTrimClap'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'displayfield',
                                                                                        id: 'sysseparador2CLAP',
                                                                                        value:'---'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        anchor:'100%',
                                                                                        name:'Codigo 2er Trim',
                                                                                        width:50,
                                                                                        allowBlank: false,
                                                                                        id: 'strCod2erTrimClap'
                                                                                    }
                                                                                ]
                                                                            },
                                                                            {
                                                                                xtype: 'compositefield',
                                                                                style: 'background:transparent;',
                                                                                items: [
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '3er Trim',
                                                                                        name: '3er Trim',
                                                                                        allowBlank: false,
                                                                                        store: 'StoreSiNo',
                                                                                        valueField: 'Descripcion',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: "NO",
                                                                                        id: 'strHem3erTrimClap'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'displayfield',
                                                                                        id: 'sysseparador3CLAP',
                                                                                        value:'---'
                                                                                    },
                                                                                    {  
                                                                                        xtype: 'textfield',
                                                                                        anchor:'100%',
                                                                                        name:'Codigo 3er Trim',
                                                                                        width:50,
                                                                                        allowBlank: false,
                                                                                        id: 'strCod3erTrimClap'
                                                                                    }
                                                                                ]
                                                                            } 
                                                                        ]
                                                                    }
                                                                ]
                                                            } 
                                                        ]
                                                    }
                                                ]
                                            }
                                        ]
                                    } // Aqui debe ir el otro
                                ]
                            },
                            {
                                xtype: 'panel',
                                layout: 'form',
                                width:320,
                                anchor:'100%',
                                autoHeight: true,
                                items:[
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'fieldset',
                                                layout: 'form',
                                                collapsible: false,
                                                titleCollapse: false,
                                                autoHeight: true,
                                                padding: 5,
                                                items:[
                                                    { 
                                                        xtype: 'combo',
                                                        width: 50,
                                                        fieldLabel: 'Parto',
                                                        name: 'EnfParto',
                                                        allowBlank: false,
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: "NO",
                                                        id: 'strEnfPartoClap'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                layout: 'form',
                                                collapsible: false,
                                                titleCollapse: false,
                                                autoHeight: true,
                                                padding: 5,
                                                items:[
                                                    { 
                                                        xtype: 'combo',
                                                        width: 50,
                                                        fieldLabel: 'Aborto',
                                                        name: 'EnfAborto',
                                                        allowBlank: false,
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: "NO",
                                                        id: 'strEnfAbortoClap'
                                                    }
                                                ]
                                            }
                                        ]                                                    
                                    }
                                ]
                            }
                        ]
                    },*/
                    {
                        xtype: 'panel',
                        layout: 'form',
                        anchor:'100%',
                        autoHeight: true,
                        items:[
                            {
                                xtype: 'fieldset',
                                layout: 'form',
                                anchor:'100%',
                                collapsible: false,
                                titleCollapse: false,
                                autoHeight: true,
                                padding: 5,
                                items:[
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'combo',
                                                width: 100,
                                                fieldLabel: 'Presentaciòn',
                                                name: 'Presentacion',
                                                allowBlank: false,
                                                store: 'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                value: "NO",
                                                id: 'strPresentacionClap'
                                            },
                                            {
                                                xtype: 'displayfield',
                                                id: 'sysAcomTPCLAP',
                                                value:'Acompañante En T de P:'
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 120,
                                                name: 'Acompañante En T de P',
                                                allowBlank: false,
                                                store: 'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                value: "NO",
                                                id: 'strAcomTPClap'
                                            },
                                            {
                                                xtype: 'displayfield',
                                                id: 'sysNacimientoCLAP',
                                                value:'Nacimiento:'
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 100,
                                                name: 'Nacimiento',
                                                allowBlank: false,
                                                store: 'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                value: "NO",
                                                id: 'strNacimientoClap'
                                            },
                                            {
                                                xtype: 'displayfield',
                                                id: 'sysHoraCLAP',
                                                value:'Hora:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 60,
                                                name: 'Hora',
                                                anchor:'100%',
                                                allowBlank: false,
                                                id: 'strHoraClap'
                                            },
                                            {
                                                xtype: 'displayfield',
                                                id: 'sysFechaCLAP',
                                                value:'Fecha:'
                                            },
                                            {
                                                xtype: 'datefield',
                                                width: 93,
                                                name: 'Fecha',
                                                anchor:'100%',
                                                allowBlank: false,
                                                id: 'fecFechaClap'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 100,
                                                fieldLabel: 'Multiple Feto1/Feto2',
                                                name: 'Multiple Feto1/Feto2',
                                                anchor:'100%',
                                                allowBlank: false,
                                                id: 'strMulFeto1Clap'
                                            },
                                            {
                                                xtype: 'displayfield',
                                                id: 'sysMulFetoSeparadorCLAP',
                                                value:'-'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 100,
                                                name: 'Multiple Feto2',
                                                anchor:'100%',
                                                allowBlank: false,
                                                id: 'strMulFeto2Clap'
                                            },
                                            {
                                                xtype: 'displayfield',
                                                id: 'sysTerminacionCLAP',
                                                value:'Terminacion:'
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 100,
                                                name: 'Terminacion',
                                                allowBlank: false,
                                                store: 'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                value: "NO",
                                                id: 'strTerminacionClap'
                                            },
                                            {
                                                xtype: 'displayfield',
                                                id: 'sysIndicacionCLAP',
                                                value:'Indicacion Ppal:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 150,
                                                name: 'Indicacion Ppal',
                                                anchor:'100%',
                                                allowBlank: false,
                                                id: 'strIndPpalClap'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'combo',
                                                width: 100,
                                                name: 'Posicion Parto',
                                                allowBlank: false,
                                                fieldLabel: 'Posicion Parto',
                                                store: 'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                value: "NO",
                                                id: 'strPosPartoClap'
                                            },
                                            {
                                                xtype: 'displayfield',
                                                id: 'sysEnemaCLAP',
                                                value:'Enema:'
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 100,
                                                name: 'Enema',
                                                allowBlank: false,
                                                store: 'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                value: "NO",
                                                id: 'strEnemaClap'
                                            },
                                            {
                                                xtype: 'displayfield',
                                                id: 'sysRasuradoCLAP',
                                                value:'Rasurado:'
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 100,
                                                name: 'Rasurado',
                                                allowBlank: false,
                                                store: 'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                value: "NO",
                                                id: 'strRasuradoClap'
                                            },
                                            {
                                                xtype: 'displayfield',
                                                id: 'sysEpisiotomiaCLAP',
                                                value:'Episiotomia:'
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 100,
                                                name: 'Episiotomia',
                                                allowBlank: false,
                                                store: 'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                value: "NO",
                                                id: 'strEpisiotomiaClap'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'combo',
                                                width: 100,
                                                name: 'Desgarros',
                                                allowBlank: false,
                                                fieldLabel: 'Desgarros',
                                                store: 'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                value: "NO",
                                                id: 'strDesgarrosClap'
                                            },
                                            {
                                                xtype: 'displayfield',
                                                id: 'sysOciAlumbramientoCLAP',
                                                value:'Ocitocicos En Alumbramiento:'
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 200,
                                                name: 'Ocitocicos En Alumbramiento',
                                                allowBlank: false,
                                                store: 'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                value: "NO",
                                                id: 'strOciAlumbramientoClap'
                                            },
                                            {
                                                xtype: 'displayfield',
                                                id: 'sysInduccionCLAP',
                                                value:'Induccion:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 150,
                                                name: 'Induccion',
                                                anchor:'100%',
                                                allowBlank: false,
                                                id: 'strInduccionClap'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'combo',
                                                width: 100,
                                                name: 'Placenta Completa',
                                                allowBlank: false,
                                                fieldLabel: 'Placenta Completa',
                                                store: 'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                value: "NO",
                                                id: 'strPlaCompletaClap'
                                            },
                                            {
                                                xtype: 'displayfield',
                                                id: 'sysPlaRetenidaCLAP',
                                                value:'Placenta Retenida:'
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 100,
                                                name: 'Placenta Retenida',
                                                allowBlank: false,
                                                store: 'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                value: "NO",
                                                id: 'strPlaRetenidaClap'
                                            },
                                            {
                                                xtype: 'displayfield',
                                                id: 'sysLigCordonCLAP',
                                                value:'Ligadura Cordon:'
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 100,
                                                name:'Ligadura Cordon',
                                                allowBlank: false,
                                                store: 'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                value: "NO",
                                                id: 'strLigCordonClap'
                                            },
                                            {
                                                xtype: 'displayfield',
                                                id: 'sysOciTPCLAP',
                                                value:'Ocitocicos  En T de P:'
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 100,
                                                name:'Ocitocicos  En T de P',
                                                allowBlank: false,
                                                store: 'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                value: "NO",
                                                id: 'strOciTPClap'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'combo',
                                                width: 100,
                                                name: 'Antibioticos',
                                                allowBlank: false,
                                                fieldLabel: 'Antibioticos',
                                                store: 'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                value: "NO",
                                                id: 'strAntibioticosClap'
                                            },
                                            {
                                                xtype: 'displayfield',
                                                id: 'sysAnaEpiduralCLAP',
                                                value:'Analgesia Epidural:'
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 100,
                                                name: 'Analgesia Epidural',
                                                allowBlank: false,
                                                store: 'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                value: "NO",
                                                id: 'strAnaEpiduralClap'
                                            },
                                            {
                                                xtype: 'displayfield',
                                                id: 'sysOperatorioCLAP',
                                                value:'Operatorio:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 150,
                                                name: 'Operatorio',
                                                anchor:'100%',
                                                allowBlank: false,
                                                id: 'strOperatorioClap'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'combo',
                                                width: 100,
                                                name: 'Anestesia Regional',
                                                allowBlank: false,
                                                fieldLabel: 'Anestesia Regional',
                                                store: 'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                value: "NO",
                                                id: 'strAneRegionalClap'
                                            },
                                            {
                                                xtype: 'displayfield',
                                                id: 'sysAneGeneralCLAP',
                                                value:'Anestesia General:'
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 100,
                                                name: 'Anestesia General',
                                                allowBlank: false,
                                                store: 'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                value: "NO",
                                                id: 'strAneGeneralClap'
                                            },
                                            {
                                                xtype: 'displayfield',
                                                id: 'sysSulMagnesioCLAP',
                                                value:'Sulfato Magnesio:'
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 100,
                                                name: 'Sulfato Magnesio',
                                                allowBlank: false,
                                                store: 'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                value: "NO",
                                                id: 'strSulMagnesioClap'
                                            },
                                            {
                                                xtype: 'displayfield',
                                                id: 'sysTransfusionCLAP',
                                                value:'Transfusion:'
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 100,
                                                name: 'Transfusion',
                                                allowBlank: false,
                                                store: 'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                value: "NO",
                                                id: 'strTransfusionClap'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'combo',
                                                width: 100,
                                                name: 'Otras',
                                                allowBlank: false,
                                                fieldLabel: 'Otras',
                                                store: 'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                value: "NO",
                                                id: 'strOtrasClap'
                                            },
                                            {
                                                xtype: 'displayfield',
                                                id: 'sysEspecificarCLAP',
                                                value:'Especificar:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 150,
                                                name: 'Especificar',
                                                anchor:'100%',
                                                allowBlank: false,
                                                id: 'strEspecificarClap'
                                            },
                                            {
                                                xtype: 'displayfield',
                                                id: 'sysHizPartogramaCLAP',
                                                value:'Se Hizo Partograma:'
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 100,
                                                name: 'Se Hizo Partograma',
                                                allowBlank: false,
                                                store: 'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                value: "NO",
                                                id: 'strHizPartogramaClap'
                                            }
                                        ]
                                    }
                                ]
                            }
                        ]
                    }
                   // FInaliar Aqui
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Salir',
                            iconCls: 'btnSalir',
                            id: 'btnSalirEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 1) 
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    if (Ext.getCmp('sysUsaGridSalida').getValue() == 1){
                                                        Ext.getCmp('gridFormulario').store.reload();
                                                    }
                                                    Ext.getCmp('winHC').close();
                                                }
                                            }
                                        });
                                    else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Usted No ha Guardado la Evolución del Paciente y Se Perdera la Información, Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.getCmp('winHC').close();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                },
                tbar:{
                    items: [
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Ver Historia Clínica',
                            iconCls: 'btnVerHC',
                            id: 'btnVerHC',
                            listeners:{
                                click : function(){
                                    var cmpResumenHC = new winFrmVerHistorialHC({
                                        renderTo: Ext.getBody()
                                    });
                                    Ext.getCmp('winViewEvolucionHC').title = "PACIENTE: " + Ext.getCmp('sysPacienteHC').getValue();
                                    Ext.getCmp('gridHistorialEvoluciones').store.load({
                                        params: {
                                            pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                                            pPaciente: Ext.getCmp('sysIdPacienteHC').getValue()
                                        }
                                    });
                                    cmpResumenHC.show();
                                }
                            }
                        },
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar Evolución',
                            iconCls: 'btnGuardar',
                            id: 'btnGuardarEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 0) 
                                    {
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea guardar la evolución, si hace esto ya no podra realizar ningun cambio?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnGuardarRegistros();
                                                }
                                            }
                                        });
                                    }else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'La evolución ya se guardo y no podra ser modificada nuevamente',
                                            buttons: Ext.Msg.OK,
                                            icon: Ext.Msg.ERROR
                                        });
                                    }
                                }
                            }
                        }
                    ]
                }
            }
        ];
        winHCCLAP2010Ui.superclass.initComponent.call(this);
    }
});

function fnGuardarRegistros(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc.php',
            params:{
                task: 'guardar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pidPlantillaHC : Ext.getCmp('sysIdCodPlantillaHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1); 
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}
