/*
* @category    Formulario Modelo Evolucion Historia Clinica Caminata 6 Minutos
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winHCCaminataUi = Ext.extend(Ext.Window, {
    title: 'eOfiClinic ©  .:: Plantilla HC Caminata 6 Minutos ::.',
    width: 990,
    height: 636,
    closable: false,
    resizable: false,
    draggable: false,
    modal: true,
    id: 'winHC',
    initComponent: function() {
        
        tmpmx = objMX;
        tmpmxadd = objMXADD;
        tmpexa = objEXA;
        tmprem = objREM;
        myPaciente = 0;
        myCAS = 0;

        try {
            var campo = Ext.getCmp('sysPacientePlantillaHC');
            if ( campo != null ) {
                myPaciente = Ext.getCmp('sysPacientePlantillaHC').getValue();
            }
        }catch(ex){
        }
        if(myPaciente == 0){
            try {
                var campo1 = Ext.getCmp('sysIdPacienteHC');
                if ( campo1 != null ) {
                    myPaciente = Ext.getCmp('sysIdPacienteHC').getValue();
                }
            }catch(ex){
            }
        }
        if(myPaciente == 0){
            try {
                var campo5 = Ext.getCmp('sysPacienteRefHC');
                if ( campo5 != null ) {
                    myPaciente = Ext.getCmp('sysPacienteRefHC').getValue();
                }
            }catch(ex){
            }
        }
        try {
            var campo2 = Ext.getCmp('sysCASPlantillaHC');
            if ( campo2 != null ) {
                myCAS = Ext.getCmp('sysCASPlantillaHC').getValue();
            }
        }catch(ex){
        }
        if(myCAS == 0){
            try {
                var campo3 = Ext.getCmp('sysCASHC');
                if ( campo3 != null ) {
                    myCAS = Ext.getCmp('sysCASHC').getValue();
                }
            }catch(ex){
            }
        }
        if(myCAS == 0){
            try {
                var campo4 = Ext.getCmp('sysCASRefHC');
                if ( campo4 != null ) {
                    myCAS = Ext.getCmp('sysCASRefHC').getValue();
                }
            }catch(ex){
            }
        }
        if (objMX != "NA"){
            var xSolMX = eval(objMX);
            Ext.getCmp('gridMedicamentosHC').store.load({
                params: {
                    task: 'MX_IPS_BASICA',
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: wPaciente,
                    pCAS: wCAS
                }
            });
        }
        else{
            var xSolMX = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        if (objEXA != "NA"){
            var xSolEXA = eval(objEXA);
            Ext.getCmp('gridExamenesHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: wPaciente,
                    pCAS: wCAS
                }
            });
        }else{
            var xSolEXA = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        if (objREM != "NA"){
            var xSolREM = eval(objREM);
            Ext.getCmp('gridRemisionesHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: wPaciente,
                    pCAS: wCAS
                }
            });
        }else{
            var xSolREM = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        var xSolNOPOS = new SolNOPOS001Ui();
        Ext.getCmp('gridSolicitudesNOPOSxPaciente').store.load({
            params: {
                task: 'LISTAR_NOPOS',
                pPaciente: myPaciente
            }
        });
        //
        
        var dataMetros = [
            [30,'30 Mt'],
            [60,'60 Mt'],
            [90,'90 Mt'],
            [120,'120 Mt'],
            [150,'150 Mt'],
            [180,'180 Mt'],
            [210,'210 Mt'],
            [240,'240 Mt'],
            [270,'270 Mt'],
            [300,'300 Mt'],
            [330,'330 Mt'],
            [360,'360 Mt'],
            [390,'390 Mt'],
            [420,'420 Mt'],
            [450,'450 Mt'],
            [480,'480 Mt'],
            [540,'540 Mt'],
            [570,'570 Mt'],
            [600,'600 Mt'],
            [630,'630 Mt'],
            [660,'660 Mt']
        ];
        var stMetros = new Ext.data.ArrayStore({
            fields: [
                {name: 'Codigo'},
                {name: 'Descripcion'}
            ]
        });
        stMetros.loadData(dataMetros);
        
        
        this.items = [
            {
                xtype: 'panel',
                frame: true,
                anchor: '100%',
                id: 'panelHC',
                border: false,
                height: 570,
                autoScroll: true,
                layout: 'form',
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysIdCodPlantillaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        value: 1,
                        id: 'sysUsaGridSalida'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                        value: 0,
                        id: 'sysYaGuardoHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysPlantillaHC',
                        name: 'PLANTILLA'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptMx'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptExa'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptRem'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Actividad',
                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                        id: 'sysActividadHC',
                        name: 'PLANTILLA'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Empresa',
                        id: 'sysEmpresaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'IPS',
                        id: 'sysIPSHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Usuario',
                        id: 'sysUsuarioHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Profesional',
                        id: 'sysProfesionalHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Paciente',
                        id: 'sysIdPacienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Apertura',
                        id: 'sysAperturaHC'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Cliente',
                        id: 'sysClienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdClienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdPlanHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdSubPlanHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdContratoHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Genero',
                        id: 'sysGeneroPacHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Edad',
                        id: 'sysEdadPacHC'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Profesional',
                        id: 'sysProfesionalAgendaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'ConsecutivoDetalle',
                        id: 'sysConsecutivoDetalleHC'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'CAS',
                                id: 'sysCASHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysFechaHC',
                                value: 'Fecha: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysFechaHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysHoraHC',
                                value: 'Hora: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysHoraHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysLegalizacionHC',
                                value: 'Legalización: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysLegalizaHC'
                            }
                        ]
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Paciente',
                        value: 'CC 792558261  - JORGE GALEANO RUIZ - (Masculino) FechaNac: 1973-01-30, Edad 38 Años',
                        id: 'sysPacienteHC'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'textfield',
                                width: 100,
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'Genero',
                                id: 'sysGeneroHC'
                            },
                            {
                                html: 'Fecha Nac:'
                            },
                            {
                                xtype: 'textfield',
                                width: 100,
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysFechaNac'
                            },
                            {
                                html: 'Edad:'
                            },
                            {
                                xtype: 'textfield',
                                width: 350,
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysEdadHC'
                            }
                        ]
                    },
                    /*{
                        xtype: 'button',
                        iconCls: 'btnImprimir',
                        text: 'Cargar Antecedentes',
                        tooltip: 'Cargar Antecedentes',
                        listeners:{
                            click : function(){
                                Ext.Ajax.request({
                                    url: '../../controlador/asistencial/evolucionhc.php',
                                    waitMsg: 'Cargando Información...',
                                    params:{
                                        pCAS: myCAS,
                                        pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                                        task: 'ImportarAntecedentesPersonalesOfiClinic001'
                                    },
                                    success: function(result, request)
                                    {
                                        var jsonAntPersonales = Ext.util.JSON.decode(result.responseText);
                                        UtilCargarAntecedentesOfiClinic001(jsonAntPersonales.data);
                                    },
                                    scope:this
                                });
                            }
                        }
                    },*/
                    {
                        html: '<hr>',
                        style: 'background:transparent;',
                        border: false
                    },
                    {
                        xtype: 'tabpanel',
                        anchor: '99%',
                        autoHeight: true,
                        border: false,
                        enableTabScroll: true,
                        ref: 'fTabPanel',
                        id: 'fTabPanel',
                        activeTab: 0,
                        items: [
                            {
                                xtype: 'panel',
                                title: 'Evolución',
                                autoHeight: true,
                                autoScroll: true,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaEvolucion',
                                layout: 'form',
                                items: [
                                    {
                                        xtype: 'form',
                                        frame: true,
                                        anchor: '100%',
                                        id: 'frmHC',
                                        padding: 10,
                                        border: false,
                                        autoScroll: true,
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'numberfield',
                                                        width: 60,
                                                        minValue: 0,
                                                        maxValue: 250,
                                                        decimalPrecision: 2,
                                                        allowBlank: false,
                                                        fieldLabel: 'Estatura (cm)',
                                                        name:"Estatura (cm)",
                                                        emptyText: '(cm)',
                                                        id: 'intEXAFISTalla',
                                                        listeners:{
                                                            change : function(f,pNew, pOld){
                                                                if(pNew == null || pNew == 0){
                                                                    Ext.getCmp('intEXAFISTalla').setValue(null);
                                                                    Ext.getCmp('intEXAFISIMC').setValue(0);
                                                                }else{
                                                                    if(Ext.getCmp('intEXAFISPeso').getValue() > 0){
                                                                        var pTalla = Ext.getCmp('intEXAFISTalla').getValue() / 100;
                                                                        Ext.getCmp('intEXAFISIMC').setValue(Ext.getCmp('intEXAFISPeso').getValue()/(pTalla*pTalla));
                                                                    }else{
                                                                        Ext.getCmp('intEXAFISIMC').setValue(0);
                                                                    }
                                                                }
                                                                if(Ext.getCmp('intEXAFISIMC').getValue()<1){
                                                                   Ext.getCmp('strEXAFISIMCClasificacon').setValue(null);
                                                                }else{
                                                                    if(Ext.getCmp('intEXAFISIMC').getValue() < 16.00){
                                                                       Ext.getCmp('strEXAFISIMCClasificacon').setValue("DELGADEZ SEVERA");
                                                                    }else{
                                                                        if(Ext.getCmp('intEXAFISIMC').getValue()<=16.90 && Ext.getCmp('intEXAFISIMC').getValue()>=16.00){
                                                                           Ext.getCmp('strEXAFISIMCClasificacon').setValue("DELGADEZ MODERADA");
                                                                        }else{
                                                                            if(Ext.getCmp('intEXAFISIMC').getValue()<=18.49 && Ext.getCmp('intEXAFISIMC').getValue()>=17.00){
                                                                               Ext.getCmp('strEXAFISIMCClasificacon').setValue("DELGADEZ ACEPTABLE");
                                                                            }else{
                                                                                if(Ext.getCmp('intEXAFISIMC').getValue()<=24.99 && Ext.getCmp('intEXAFISIMC').getValue()>=18.50){
                                                                                   Ext.getCmp('strEXAFISIMCClasificacon').setValue("NORMAL");
                                                                                }else{
                                                                                    if(Ext.getCmp('intEXAFISIMC').getValue()<=29.99 && Ext.getCmp('intEXAFISIMC').getValue()>=25.00){
                                                                                       Ext.getCmp('strEXAFISIMCClasificacon').setValue("PREOBESO");
                                                                                    }else{
                                                                                        if(Ext.getCmp('intEXAFISIMC').getValue()<=34.99 && Ext.getCmp('intEXAFISIMC').getValue()>=30.00){
                                                                                           Ext.getCmp('strEXAFISIMCClasificacon').setValue("OBESO TIPO I");
                                                                                        }else{
                                                                                            if(Ext.getCmp('intEXAFISIMC').getValue()<=39.99 && Ext.getCmp('intEXAFISIMC').getValue()>=35.00){
                                                                                               Ext.getCmp('strEXAFISIMCClasificacon').setValue("OBESO TIPO II");
                                                                                            }else{
                                                                                                if(Ext.getCmp('intEXAFISIMC').getValue()>=40.00){
                                                                                                Ext.getCmp('strEXAFISIMCClasificacon').setValue("OBESO TIPO III");
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                                calculoEdadPacienteMeses();
                                                                var pVariable1 = 5.14 * Ext.getCmp('intEXAFISTalla').getValue();
                                                                var pVariable2 = 5.32 * AniosCumplidos;
                                                                var pVariable3 = 1.8 * Ext.getCmp('intEXAFISPeso').getValue();
                                                                
                                                                if(pNew == null || pNew == 0){
                                                                    Ext.getCmp('intPredicho').setValue(0);
                                                                }else{
                                                                    if(Ext.getCmp('sysGeneroPacHC').getValue() == "FEMENINO"){
                                                                        Ext.getCmp('intPredicho').setValue(218 + pVariable1 - pVariable2 - pVariable3 + 51.31);
                                                                    }else{
                                                                        Ext.getCmp('intPredicho').setValue(218 + pVariable1 - pVariable2 - pVariable3);
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'displayfield',
                                                        id: 'sysEXAFISPeso',
                                                        value: 'PESO (Kg) '
                                                    },
                                                    {
                                                        xtype: 'numberfield',
                                                        width: 60,
                                                        minValue: 0,
                                                        maxValue: 250,
                                                        decimalPrecision: 2,
                                                        allowBlank: false,
                                                        emptyText: '(Kg)',
                                                        name:"PESO (Kg)",
                                                        id: 'intEXAFISPeso',
                                                        listeners:{
                                                            change : function(f,pNew, pOld){
                                                                if(pNew == null || pNew == 0){
                                                                    Ext.getCmp('intEXAFISPeso').setValue(null);
                                                                    Ext.getCmp('intEXAFISIMC').setValue(0);
                                                                }else{
                                                                    //peso [kg]/ estatura [m2]
                                                                    if(Ext.getCmp('intEXAFISTalla').getValue() > 0){
                                                                        var pTalla = Ext.getCmp('intEXAFISTalla').getValue() / 100;
                                                                        Ext.getCmp('intEXAFISIMC').setValue(Ext.getCmp('intEXAFISPeso').getValue()/(pTalla*pTalla));
                                                                    }else{
                                                                        Ext.getCmp('intEXAFISIMC').setValue(0);
                                                                    }
                                                                }
                                                                if(Ext.getCmp('intEXAFISIMC').getValue()<1){
                                                                   Ext.getCmp('strEXAFISIMCClasificacon').setValue(null);
                                                                }else{
                                                                    if(Ext.getCmp('intEXAFISIMC').getValue() < 16.00){
                                                                       Ext.getCmp('strEXAFISIMCClasificacon').setValue("DESGADEZ SEVERA");
                                                                    }else{
                                                                        if(Ext.getCmp('intEXAFISIMC').getValue()<=16.90 && Ext.getCmp('intEXAFISIMC').getValue()>=16.00){
                                                                           Ext.getCmp('strEXAFISIMCClasificacon').setValue("DELGADEZ MODERADA");
                                                                        }else{
                                                                            if(Ext.getCmp('intEXAFISIMC').getValue()<=18.49 && Ext.getCmp('intEXAFISIMC').getValue()>=17.00){
                                                                               Ext.getCmp('strEXAFISIMCClasificacon').setValue("DELGADEZ ACEPTABLE");
                                                                            }else{
                                                                                if(Ext.getCmp('intEXAFISIMC').getValue()<=24.99 && Ext.getCmp('intEXAFISIMC').getValue()>=18.50){
                                                                                   Ext.getCmp('strEXAFISIMCClasificacon').setValue("NORMAL");
                                                                                }else{
                                                                                    if(Ext.getCmp('intEXAFISIMC').getValue()<=29.99 && Ext.getCmp('intEXAFISIMC').getValue()>=25.00){
                                                                                       Ext.getCmp('strEXAFISIMCClasificacon').setValue("PREOBESO");
                                                                                    }else{
                                                                                        if(Ext.getCmp('intEXAFISIMC').getValue()<=34.99 && Ext.getCmp('intEXAFISIMC').getValue()>=30.00){
                                                                                           Ext.getCmp('strEXAFISIMCClasificacon').setValue("OBESO TIPO I");
                                                                                        }else{
                                                                                            if(Ext.getCmp('intEXAFISIMC').getValue()<=39.99 && Ext.getCmp('intEXAFISIMC').getValue()>=35.00){
                                                                                               Ext.getCmp('strEXAFISIMCClasificacon').setValue("OBESO TIPO II");
                                                                                            }else{
                                                                                                if(Ext.getCmp('intEXAFISIMC').getValue()>=40.00){
                                                                                                Ext.getCmp('strEXAFISIMCClasificacon').setValue("OBESO TIPO III");
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                                calculoEdadPacienteMeses();
                                                                var pVariable1 = 5.14 * Ext.getCmp('intEXAFISTalla').getValue();
                                                                var pVariable2 = 5.32 * AniosCumplidos;
                                                                var pVariable3 = 1.8 * Ext.getCmp('intEXAFISPeso').getValue();
                                                                
                                                                if(pNew == null || pNew == 0){
                                                                    Ext.getCmp('intPredicho').setValue(0);
                                                                }else{
                                                                    if(Ext.getCmp('sysGeneroHC').getValue() == "FEMENINO"){
                                                                        Ext.getCmp('intPredicho').setValue(218 + pVariable1 - pVariable2 - pVariable3 + 51.31);
                                                                    }else{
                                                                        Ext.getCmp('intPredicho').setValue(218 + pVariable1 - pVariable2 - pVariable3);
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'displayfield',
                                                        id: 'sysEXAFISIMC',
                                                        value: 'IMC '
                                                    },
                                                    {
                                                        xtype: 'numberfield',
                                                        width: 80,
                                                        minValue: 0,
                                                        decimalPrecision: 2,
                                                        allowBlank: false,
                                                        readOnly: true,
                                                        name: "IMC",
                                                        id: 'intEXAFISIMC'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        allowBlank: false,
                                                        readOnly: true,
                                                        name: "IMC - CLASIFICACION",
                                                        id: 'strEXAFISIMCClasificacon'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        fieldLabel: 'Prueba 1',
                                                        name: 'Prueba 1',
                                                        width: 190,
                                                        id: 'strPrueba1'
                                                    },
                                                    {
                                                        html: 'Prueba 2'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        name: 'Prueba 2',
                                                        width: 190,
                                                        id: 'strPrueba2'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'textfield',
                                                fieldLabel: 'Predicho',
                                                name: 'Predicho',
                                                width: 440,
                                                id: 'strPredicho'
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [                                           
                                                    {
                                                        xtype: 'numberfield',
                                                        width: 60,
                                                        minValue: 0,
                                                        decimalPrecision: 2,
                                                        name: 'FC Max',
                                                        fieldLabel: 'FC Max',
                                                        allowBlank: false,
                                                        id: 'intEXAFISFCMax'
                                                    },  
                                                    {
                                                        html: 'FC Sub Max'
                                                    },                                         
                                                    {
                                                        xtype: 'numberfield',
                                                        width: 60,
                                                        minValue: 0,
                                                        decimalPrecision: 2,
                                                        name: 'FC Sub Max',
                                                        allowBlank: false,
                                                        id: 'intEXAFISFCSubMax'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '<center>SIGNOS VITALES</center>',
                                                layout: 'form',
                                                anchor: '100%',
                                                autoHeight: true,
                                                items: [
                                                    {
                                                        xtype: 'panel',
                                                        layout: 'table',
                                                        anchor: '100%',
                                                        padding: 0,
                                                        layoutConfig: {
                                                            columns: 3
                                                        },
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'panel',
                                                                layout: 'form',
                                                                width: 150,
                                                                autoHeight: true,
                                                                labelWidth: 50,
                                                                labelSeparator: '',
                                                                labelStyle: 'color:blue;',
                                                                title: '<center>REPOSO</center>',
                                                                items: [
                                                                    {
                                                                        xtype: 'panel',
                                                                        layout: 'table',
                                                                        anchor: '100%',
                                                                        padding: 0,
                                                                        layoutConfig: {
                                                                            columns: 1
                                                                        },
                                                                        autoHeight: true,
                                                                        items: [
                                                                            {
                                                                                xtype: 'panel',
                                                                                layout: 'form',
                                                                                width: 150,
                                                                                autoHeight: true,
                                                                                labelWidth: 50,
                                                                                labelSeparator: '',
                                                                                labelStyle: 'color:blue;',
                                                                                title: '<center>.</center>',
                                                                                items: [
                                                                                    {
                                                                                        xtype: 'numberfield',
                                                                                        fieldLabel: 'FC',
                                                                                        name: 'FC',
                                                                                        width: 70,
                                                                                        decimalPrecision: 0,
                                                                                        allowBlank: true,
                                                                                        id: 'intReposoFC'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'numberfield',
                                                                                        fieldLabel: 'SpO2',
                                                                                        name: 'SpO2',
                                                                                        width: 70,
                                                                                        decimalPrecision: 0,
                                                                                        allowBlank: true,
                                                                                        id: 'intReposoSpO2'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'numberfield',
                                                                                        fieldLabel: 'FiO2',
                                                                                        name: 'FiO2',
                                                                                        width: 70,
                                                                                        decimalPrecision: 0,
                                                                                        allowBlank: true,
                                                                                        id: 'intReposoFiO2'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'numberfield',
                                                                                        fieldLabel: 'FR',
                                                                                        name: 'FR',
                                                                                        width: 70,
                                                                                        decimalPrecision: 0,
                                                                                        allowBlank: true,
                                                                                        id: 'intReposoFR'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        name: 'TA',
                                                                                        fieldLabel: 'TA',
                                                                                        width: 70,
                                                                                        allowBlank: true,
                                                                                        id: 'strReposoTA'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        name: 'Disnea',
                                                                                        fieldLabel: 'Disnea',
                                                                                        width: 70,
                                                                                        allowBlank: true,
                                                                                        id: 'strReposoDisnea'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        name: 'Fatiga',
                                                                                        fieldLabel: 'Fatiga',
                                                                                        width: 70,
                                                                                        allowBlank: true,
                                                                                        id: 'strReposoFatiga'
                                                                                    }
                                                                                ]
                                                                            }
                                                                        ]
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                layout: 'form',
                                                                width: 485,
                                                                autoHeight: true,
                                                                labelWidth: 1,
                                                                labelSeparator: '',
                                                                labelStyle: 'color:blue;',
                                                                title: '<center>ACTIVIDAD</center>',
                                                                items: [
                                                                    {
                                                                        xtype: 'panel',
                                                                        layout: 'table',
                                                                        anchor: '100%',
                                                                        padding: 0,
                                                                        layoutConfig: {
                                                                            columns: 6
                                                                        },
                                                                        autoHeight: true,
                                                                        items: [
                                                                            {
                                                                                xtype: 'panel',
                                                                                layout: 'form',
                                                                                width: 80,
                                                                                autoHeight: true,
                                                                                labelWidth: 1,
                                                                                labelSeparator: '',
                                                                                labelStyle: 'color:blue;',
                                                                                title: '<center>1 Minuto</center>',
                                                                                items: [
                                                                                    {
                                                                                        xtype: 'numberfield',
                                                                                        name: 'FC',
                                                                                        width: 70,
                                                                                        decimalPrecision: 0,
                                                                                        allowBlank: true,
                                                                                        id: 'intActividad1MinutoFC'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'numberfield',
                                                                                        name: 'SpO2',
                                                                                        width: 70,
                                                                                        decimalPrecision: 0,
                                                                                        allowBlank: true,
                                                                                        id: 'intActividad1MinutoSpO2'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'numberfield',
                                                                                        name: 'FiO2',
                                                                                        width: 70,
                                                                                        decimalPrecision: 0,
                                                                                        allowBlank: true,
                                                                                        id: 'intActividad1MinutoFiO2'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'numberfield',
                                                                                        name: 'FR',
                                                                                        width: 70,
                                                                                        decimalPrecision: 0,
                                                                                        allowBlank: true,
                                                                                        id: 'intActividad1MinutoFR'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        name: 'TA',
                                                                                        width: 70,
                                                                                        allowBlank: true,
                                                                                        id: 'strActividad1MinutoTA'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        name: 'Disnea',
                                                                                        width: 70,
                                                                                        allowBlank: true,
                                                                                        id: 'strActividad1MinutoDisnea'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        name: 'Fatiga',
                                                                                        width: 70,
                                                                                        allowBlank: true,
                                                                                        id: 'strActividad1MinutoFatiga'
                                                                                    }
                                                                                ]
                                                                            },
                                                                            {
                                                                                xtype: 'panel',
                                                                                layout: 'form',
                                                                                width: 80,
                                                                                autoHeight: true,
                                                                                labelWidth: 1,
                                                                                labelSeparator: '',
                                                                                labelStyle: 'color:blue;',
                                                                                title: '<center>2 Minuto</center>',
                                                                                items: [
                                                                                    {
                                                                                        xtype: 'numberfield',
                                                                                        name: 'FC',
                                                                                        width: 70,
                                                                                        decimalPrecision: 0,
                                                                                        allowBlank: true,
                                                                                        id: 'intActividad2MinutoFC'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'numberfield',
                                                                                        name: 'SpO2',
                                                                                        width: 70,
                                                                                        decimalPrecision: 0,
                                                                                        allowBlank: true,
                                                                                        id: 'intActividad2MinutoSpO2'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'numberfield',
                                                                                        name: 'FiO2',
                                                                                        width: 70,
                                                                                        decimalPrecision: 0,
                                                                                        allowBlank: true,
                                                                                        id: 'intActividad2MinutoFiO2'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'numberfield',
                                                                                        name: 'FR',
                                                                                        width: 70,
                                                                                        decimalPrecision: 0,
                                                                                        allowBlank: true,
                                                                                        id: 'intActividad2MinutoFR'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        name: 'TA',
                                                                                        width: 70,
                                                                                        allowBlank: true,
                                                                                        id: 'strActividad2MinutoTA'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        name: 'Disnea',
                                                                                        width: 70,
                                                                                        allowBlank: true,
                                                                                        id: 'strActividad2MinutoDisnea'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        name: 'Fatiga',
                                                                                        width: 70,
                                                                                        allowBlank: true,
                                                                                        id: 'strActividad2MinutoFatiga'
                                                                                    }
                                                                                ]
                                                                            },
                                                                            {
                                                                                xtype: 'panel',
                                                                                layout: 'form',
                                                                                width: 80,
                                                                                autoHeight: true,
                                                                                labelWidth: 1,
                                                                                labelSeparator: '',
                                                                                labelStyle: 'color:blue;',
                                                                                title: '<center>3 Minuto</center>',
                                                                                items: [
                                                                                    {
                                                                                        xtype: 'numberfield',
                                                                                        name: 'FC',
                                                                                        width: 70,
                                                                                        decimalPrecision: 0,
                                                                                        allowBlank: true,
                                                                                        id: 'intActividad3MinutoFC'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'numberfield',
                                                                                        name: 'SpO2',
                                                                                        width: 70,
                                                                                        decimalPrecision: 0,
                                                                                        allowBlank: true,
                                                                                        id: 'intActividad3MinutoSpO2'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'numberfield',
                                                                                        name: 'FiO2',
                                                                                        width: 70,
                                                                                        decimalPrecision: 0,
                                                                                        allowBlank: true,
                                                                                        id: 'intActividad3MinutoFiO2'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'numberfield',
                                                                                        name: 'FR',
                                                                                        width: 70,
                                                                                        decimalPrecision: 0,
                                                                                        allowBlank: true,
                                                                                        id: 'intActividad3MinutoFR'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        name: 'TA',
                                                                                        width: 70,
                                                                                        allowBlank: true,
                                                                                        id: 'strActividad3MinutoTA'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        name: 'Disnea',
                                                                                        width: 70,
                                                                                        allowBlank: true,
                                                                                        id: 'strActividad3MinutoDisnea'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        name: 'Fatiga',
                                                                                        width: 70,
                                                                                        allowBlank: true,
                                                                                        id: 'strActividad3MinutoFatiga'
                                                                                    }
                                                                                ]
                                                                            },
                                                                            {
                                                                                xtype: 'panel',
                                                                                layout: 'form',
                                                                                width: 80,
                                                                                autoHeight: true,
                                                                                labelWidth: 1,
                                                                                labelSeparator: '',
                                                                                labelStyle: 'color:blue;',
                                                                                title: '<center>4 Minuto</center>',
                                                                                items: [
                                                                                    {
                                                                                        xtype: 'numberfield',
                                                                                        name: 'FC',
                                                                                        width: 70,
                                                                                        decimalPrecision: 0,
                                                                                        allowBlank: true,
                                                                                        id: 'intActividad4MinutoFC'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'numberfield',
                                                                                        name: 'SpO2',
                                                                                        width: 70,
                                                                                        decimalPrecision: 0,
                                                                                        allowBlank: true,
                                                                                        id: 'intActividad4MinutoSpO2'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'numberfield',
                                                                                        name: 'FiO2',
                                                                                        width: 70,
                                                                                        decimalPrecision: 0,
                                                                                        allowBlank: true,
                                                                                        id: 'intActividad4MinutoFiO2'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'numberfield',
                                                                                        name: 'FR',
                                                                                        width: 70,
                                                                                        decimalPrecision: 0,
                                                                                        allowBlank: true,
                                                                                        id: 'intActividad4MinutoFR'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        name: 'TA',
                                                                                        width: 70,
                                                                                        allowBlank: true,
                                                                                        id: 'strActividad4MinutoTA'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        name: 'Disnea',
                                                                                        width: 70,
                                                                                        allowBlank: true,
                                                                                        id: 'strActividad4MinutoDisnea'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        name: 'Fatiga',
                                                                                        width: 70,
                                                                                        allowBlank: true,
                                                                                        id: 'strActividad4MinutoFatiga'
                                                                                    }
                                                                                ]
                                                                            },
                                                                            {
                                                                                xtype: 'panel',
                                                                                layout: 'form',
                                                                                width: 80,
                                                                                autoHeight: true,
                                                                                labelWidth: 1,
                                                                                labelSeparator: '',
                                                                                labelStyle: 'color:blue;',
                                                                                title: '<center>5 Minuto</center>',
                                                                                items: [
                                                                                    {
                                                                                        xtype: 'numberfield',
                                                                                        name: 'FC',
                                                                                        width: 70,
                                                                                        decimalPrecision: 0,
                                                                                        allowBlank: true,
                                                                                        id: 'intActividad5MinutoFC'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'numberfield',
                                                                                        name: 'SpO2',
                                                                                        width: 70,
                                                                                        decimalPrecision: 0,
                                                                                        allowBlank: true,
                                                                                        id: 'intActividad5MinutoSpO2'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'numberfield',
                                                                                        name: 'FiO2',
                                                                                        width: 70,
                                                                                        decimalPrecision: 0,
                                                                                        allowBlank: true,
                                                                                        id: 'intActividad5MinutoFiO2'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'numberfield',
                                                                                        name: 'FR',
                                                                                        width: 70,
                                                                                        decimalPrecision: 0,
                                                                                        allowBlank: true,
                                                                                        id: 'intActividad5MinutoFR'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        name: 'TA',
                                                                                        width: 70,
                                                                                        allowBlank: true,
                                                                                        id: 'strActividad5MinutoTA'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        name: 'Disnea',
                                                                                        width: 70,
                                                                                        allowBlank: true,
                                                                                        id: 'strActividad5MinutoDisnea'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        name: 'Fatiga',
                                                                                        width: 70,
                                                                                        allowBlank: true,
                                                                                        id: 'strActividad5MinutoFatiga'
                                                                                    }
                                                                                ]
                                                                            },
                                                                            {
                                                                                xtype: 'panel',
                                                                                layout: 'form',
                                                                                width: 80,
                                                                                autoHeight: true,
                                                                                labelWidth: 1,
                                                                                labelSeparator: '',
                                                                                labelStyle: 'color:blue;',
                                                                                title: '<center>6 Minuto</center>',
                                                                                items: [
                                                                                    {
                                                                                        xtype: 'numberfield',
                                                                                        name: 'FC',
                                                                                        width: 70,
                                                                                        decimalPrecision: 0,
                                                                                        allowBlank: true,
                                                                                        id: 'intActividad6MinutoFC'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'numberfield',
                                                                                        name: 'SpO2',
                                                                                        width: 70,
                                                                                        decimalPrecision: 0,
                                                                                        allowBlank: true,
                                                                                        id: 'intActividad6MinutoSpO2'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'numberfield',
                                                                                        name: 'FiO2',
                                                                                        width: 70,
                                                                                        decimalPrecision: 0,
                                                                                        allowBlank: true,
                                                                                        id: 'intActividad6MinutoFiO2'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'numberfield',
                                                                                        name: 'FR',
                                                                                        width: 70,
                                                                                        decimalPrecision: 0,
                                                                                        allowBlank: true,
                                                                                        id: 'intActividad6MinutoFR'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        name: 'TA',
                                                                                        width: 70,
                                                                                        allowBlank: true,
                                                                                        id: 'strActividad6MinutoTA'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        name: 'Disnea',
                                                                                        width: 70,
                                                                                        allowBlank: true,
                                                                                        id: 'strActividad6MinutoDisnea'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        name: 'Fatiga',
                                                                                        width: 70,
                                                                                        allowBlank: true,
                                                                                        id: 'strActividad6MinutoFatiga'
                                                                                    }
                                                                                ]
                                                                            }
                                                                        ]
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                layout: 'form',
                                                                width: 250,
                                                                autoHeight: true,
                                                                labelWidth: 1,
                                                                labelSeparator: '',
                                                                labelStyle: 'color:blue;',
                                                                title: '<center>RECUPERACION</center>',
                                                                items: [
                                                                    {
                                                                        xtype: 'panel',
                                                                        layout: 'table',
                                                                        anchor: '100%',
                                                                        padding: 0,
                                                                        layoutConfig: {
                                                                            columns: 3
                                                                        },
                                                                        autoHeight: true,
                                                                        items: [
                                                                            {
                                                                                xtype: 'panel',
                                                                                layout: 'form',
                                                                                width: 80,
                                                                                autoHeight: true,
                                                                                labelWidth: 1,
                                                                                labelSeparator: '',
                                                                                labelStyle: 'color:blue;',
                                                                                title: '<center>2 Minuto</center>',
                                                                                items: [
                                                                                    {
                                                                                        xtype: 'numberfield',
                                                                                        name: 'FC',
                                                                                        width: 70,
                                                                                        decimalPrecision: 0,
                                                                                        allowBlank: true,
                                                                                        id: 'intRecuperacion2MinutoFC'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'numberfield',
                                                                                        name: 'SpO2',
                                                                                        width: 70,
                                                                                        decimalPrecision: 0,
                                                                                        allowBlank: true,
                                                                                        id: 'intRecuperacion2MinutoSpO2'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'numberfield',
                                                                                        name: 'FiO2',
                                                                                        width: 70,
                                                                                        decimalPrecision: 0,
                                                                                        allowBlank: true,
                                                                                        id: 'intRecuperacion2MinutoFiO2'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'numberfield',
                                                                                        name: 'FR',
                                                                                        width: 70,
                                                                                        decimalPrecision: 0,
                                                                                        allowBlank: true,
                                                                                        id: 'intRecuperacion2MinutoFR'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        name: 'TA',
                                                                                        width: 70,
                                                                                        allowBlank: true,
                                                                                        id: 'strRecuperacion2MinutoTA'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        name: 'Disnea',
                                                                                        width: 70,
                                                                                        allowBlank: true,
                                                                                        id: 'strRecuperacion2MinutoDisnea'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        name: 'Fatiga',
                                                                                        width: 70,
                                                                                        allowBlank: true,
                                                                                        id: 'strRecuperacion2MinutoFatiga'
                                                                                    }
                                                                                ]
                                                                            },
                                                                            {
                                                                                xtype: 'panel',
                                                                                layout: 'form',
                                                                                width: 80,
                                                                                autoHeight: true,
                                                                                labelWidth: 1,
                                                                                labelSeparator: '',
                                                                                labelStyle: 'color:blue;',
                                                                                title: '<center>5 Minuto</center>',
                                                                                items: [
                                                                                    {
                                                                                        xtype: 'numberfield',
                                                                                        name: 'FC',
                                                                                        width: 70,
                                                                                        decimalPrecision: 0,
                                                                                        allowBlank: true,
                                                                                        id: 'intRecuperacion5MinutoFC'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'numberfield',
                                                                                        name: 'SpO2',
                                                                                        width: 70,
                                                                                        decimalPrecision: 0,
                                                                                        allowBlank: true,
                                                                                        id: 'intRecuperacion5MinutoSpO2'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'numberfield',
                                                                                        name: 'FiO2',
                                                                                        width: 70,
                                                                                        decimalPrecision: 0,
                                                                                        allowBlank: true,
                                                                                        id: 'intRecuperacion5MinutoFiO2'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'numberfield',
                                                                                        name: 'FR',
                                                                                        width: 70,
                                                                                        decimalPrecision: 0,
                                                                                        allowBlank: true,
                                                                                        id: 'intRecuperacion5MinutoFR'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        name: 'TA',
                                                                                        width: 70,
                                                                                        allowBlank: true,
                                                                                        id: 'strRecuperacion5MinutoTA'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        name: 'Disnea',
                                                                                        width: 70,
                                                                                        allowBlank: true,
                                                                                        id: 'strRecuperacion5MinutoDisnea'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        name: 'Fatiga',
                                                                                        width: 70,
                                                                                        allowBlank: true,
                                                                                        id: 'strRecuperacion5MinutoFatiga'
                                                                                    }
                                                                                ]
                                                                            },
                                                                            {
                                                                                xtype: 'panel',
                                                                                layout: 'form',
                                                                                width: 80,
                                                                                autoHeight: true,
                                                                                labelWidth: 1,
                                                                                labelSeparator: '',
                                                                                labelStyle: 'color:blue;',
                                                                                title: '<center>10 Minuto</center>',
                                                                                items: [
                                                                                    {
                                                                                        xtype: 'numberfield',
                                                                                        name: 'FC',
                                                                                        width: 70,
                                                                                        decimalPrecision: 0,
                                                                                        allowBlank: true,
                                                                                        id: 'intRecuperacion10MinutoFC'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'numberfield',
                                                                                        name: 'SpO2',
                                                                                        width: 70,
                                                                                        decimalPrecision: 0,
                                                                                        allowBlank: true,
                                                                                        id: 'intRecuperacion10MinutoSpO2'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'numberfield',
                                                                                        name: 'FiO2',
                                                                                        width: 70,
                                                                                        decimalPrecision: 0,
                                                                                        allowBlank: true,
                                                                                        id: 'intRecuperacion10MinutoFiO2'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'numberfield',
                                                                                        name: 'FR',
                                                                                        width: 70,
                                                                                        decimalPrecision: 0,
                                                                                        allowBlank: true,
                                                                                        id: 'intRecuperacion10MinutoFR'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        name: 'TA',
                                                                                        width: 70,
                                                                                        allowBlank: true,
                                                                                        id: 'strRecuperacion10MinutoTA'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        name: 'Disnea',
                                                                                        width: 70,
                                                                                        allowBlank: true,
                                                                                        id: 'strRecuperacion10MinutoDisnea'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        name: 'Fatiga',
                                                                                        width: 70,
                                                                                        allowBlank: true,
                                                                                        id: 'strRecuperacion10MinutoFatiga'
                                                                                    }
                                                                                ]
                                                                            }
                                                                        ]
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        name: 'Metros',
                                                        fieldLabel: 'Metros',
                                                        width: 150,
                                                        allowBlank: false,
                                                        store: stMetros,
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'intMetros',
                                                        listeners:{
                                                            change : function(f,pNew, pOld){
                                                                if(pNew === null || pNew === 0){
                                                                    Ext.getCmp('intDistanciaTotal').setValue(null);
                                                                }else{
                                                                    Ext.getCmp('intDistanciaTotal').setValue(Ext.getCmp('intMetros').getValue() + Ext.getCmp('intMetrosOtros').getValue())                                                                 
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        html: 'Otros'
                                                    },
                                                    {
                                                        xtype: 'numberfield',
                                                        name: 'Otros',
                                                        width: 150,
                                                        decimalPrecision: 0,
                                                        allowBlank: true,
                                                        id: 'intMetrosOtros',
                                                        listeners:{
                                                            change : function(f,pNew, pOld){
                                                                if(pNew === null || pNew === 0){
                                                                    Ext.getCmp('intDistanciaTotal').setValue(null);
                                                                }else{
                                                                    Ext.getCmp('intDistanciaTotal').setValue(Ext.getCmp('intMetros').getValue() + Ext.getCmp('intMetrosOtros').getValue())                                                                 
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        html: 'Distancia Total'
                                                    },
                                                    {
                                                        xtype: 'numberfield',
                                                        name: 'Distancia Total',
                                                        width: 150,
                                                        decimalPrecision: 0,
                                                        allowBlank: true,
                                                        id: 'intDistanciaTotal'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'numberfield',
                                                        name: 'Numero de Paradas',
                                                        fieldLabel: 'N. Paradas',
                                                        width: 150,
                                                        decimalPrecision: 0,
                                                        allowBlank: true,
                                                        id: 'intNumeroParadas'
                                                    },
                                                    {
                                                        html: 'Tiempo de Paradas'
                                                    },
                                                    {
                                                        xtype: 'numberfield',
                                                        name: 'Tiempo de Paradas',
                                                        width: 150,
                                                        decimalPrecision: 0,
                                                        allowBlank: true,
                                                        id: 'intTiempoParadas'
                                                    },
                                                    {
                                                        html: 'Tiempo Caminado'
                                                    },
                                                    {
                                                        xtype: 'numberfield',
                                                        name: 'Tiempo Caminado',
                                                        width: 150,
                                                        decimalPrecision: 0,
                                                        allowBlank: true,
                                                        id: 'intTiempoCaminado'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'numberfield',
                                                name: '% Predicho',
                                                fieldLabel: '% Predicho',
                                                width: 150,
                                                decimalPrecision: 2,
                                                allowBlank: true,
                                                id: 'intPredicho'
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'OBSERVACIONES',
                                                layout: 'table',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'OBSERVACIONES',
                                                        name: 'OBSERVACIONES',
                                                        height: 100,
                                                        allowBlank: false,
                                                        id: 'memObservaciones'
                                                    }
                                                ]
                                            },
                                            
                                            {
                                                xtype: 'fieldset',
                                                title: 'RIPS',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: false,
                                                                fieldLabel: 'Diagnostico Principal',
                                                                id: 'sysDiagPpalHC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request({
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagPpalHC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                        Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    },
                                                                    blur: function(t){
                                                                        if(Ext.getCmp('sysDiagPpalHCNom').getValue()==null || Ext.getCmp('sysDiagPpalHCNom').getValue()== "")
                                                                        {
                                                                            if (Ext.getCmp('sysDiagPpalHC').getValue() != "" && Ext.getCmp('sysDiagPpalHC').getValue() != null && Ext.getCmp('sysDiagPpalHC').getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && Ext.getCmp('sysDiagPpalHC').getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue() && Ext.getCmp('sysDiagPpalHC').getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request({
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: Ext.getCmp('sysDiagPpalHC').getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagPpalHC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                        Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagPpalHCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Principal',
                                                                id: 'btnSearchDiagPpalHC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagPpalHC','sysDiagPpalHCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.1',
                                                                id: 'sysDiagRel1HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel1HC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagRel1HCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    },
                                                                    blur: function(t){
                                                                        if (Ext.getCmp('sysDiagRel1HCNom').getValue == null ||  Ext.getCmp('sysDiagRel1HCNom').getValue() == "")
                                                                        {
                                                                            if (Ext.getCmp('sysDiagRel1HC').getValue() != "" && Ext.getCmp('sysDiagRel1HC').getValue() != null && Ext.getCmp('sysDiagRel1HC').getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && Ext.getCmp('sysDiagRel1HC').getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue() && Ext.getCmp('sysDiagRel1HC').getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: Ext.getCmp('sysDiagRel1HC').getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel1HC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagRel1HCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel1HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado1',
                                                                id: 'btnSearchDiagRel1HC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel1HC','sysDiagRel1HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.2',
                                                                id: 'sysDiagRel2HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel2HC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagRel2HCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    },
                                                                    blur: function(t){
                                                                        if (Ext.getCmp('sysDiagRel2HCNom').getValue == null || Ext.getCmp('sysDiagRel2HCNom').getValue() == "")
                                                                        {
                                                                            if (Ext.getCmp('sysDiagRel2HC').getValue() != "" && Ext.getCmp('sysDiagRel2HC').getValue() != null && Ext.getCmp('sysDiagRel2HC').getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && Ext.getCmp('sysDiagRel2HC').getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && Ext.getCmp('sysDiagRel2HC').getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: Ext.getCmp('sysDiagRel2HC').getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel2HC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagRel2HCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel2HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado2',
                                                                id: 'btnSearchDiagRel2HC1',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel2HC','sysDiagRel2HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.3',
                                                                id: 'sysDiagRel3HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel3HC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagRel3HCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    },
                                                                    blur: function(t){
                                                                        if (Ext.getCmp('sysDiagRel3HCNom').getValue == null || Ext.getCmp('sysDiagRel3HCNom').getValue() == "")
                                                                        {
                                                                            if (Ext.getCmp('sysDiagRel3HC').getValue() != "" && Ext.getCmp('sysDiagRel3HC').getValue() != null && Ext.getCmp('sysDiagRel3HC').getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && Ext.getCmp('sysDiagRel3HC').getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && Ext.getCmp('sysDiagRel3HC').getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: Ext.getCmp('sysDiagRel3HC').getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel3HC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagRel3HCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel3HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado3',
                                                                id: 'btnSearchDiagRel3HC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel3HC','sysDiagRel3HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Tipo de Diagnostico',
                                                        width:750,
                                                        name: 'Tipo de Diagnostico',
                                                        allowBlank: false,
                                                        store: 'StoreTipoDiagnostico',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        id: 'sysTipoDiagosticoHC'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Finalidad Consulta',
                                                        width:750,
                                                        name: 'Finalidad Consulta',
                                                        allowBlank: false,
                                                        store: 'StoreFinalidadConsulta',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        value: 10,
                                                        id: 'sysFinalidadConsultaHC'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Causa Externa',
                                                        width:750,
                                                        name: 'Causa Externa',
                                                        allowBlank: false,
                                                        store: 'StoreCausaExterna',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        value: 13,
                                                        id: 'sysCausaExternaHC'
                                                    }
                                                ]
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Medicamentos',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaMedicamentos',
                                items: [
                                    xSolMX
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Servicios',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaServicios',
                                items: [
                                    xSolEXA
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Remisiones',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaRemisiones',
                                items: [
                                    xSolREM
                                ]
                            },
                            /*{
                                xtype: 'panel',
                                title: 'Solicitud NO POS',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaNOPOS',
                                items: [
                                    xSolNOPOS
                                ]
                            }
                            ,
                            {
                                xtype: 'panel',
                                title: 'Consentimientos Informados',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaConsentimientos',
                                items: [
                                ]
                            },*/
                        ]
                    }
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Salir',
                            iconCls: 'btnSalir',
                            id: 'btnSalirEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 1)
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.getCmp('winHC').close();
                                                }
                                            }
                                        });
                                    else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Usted No ha Guardado la Evolución del Paciente y Se Perdera la Información, Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.getCmp('winHC').close();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                },
                tbar:{
                    items: [
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Ver Historia Clínica',
                            iconCls: 'btnVerHC',
                            id: 'btnVerHC',
                            listeners:{
                                click : function(){
                                    var cmpResumenHC = new winFrmVerHistorialHC({
                                        renderTo: Ext.getBody()
                                    });
                                    Ext.getCmp('winViewEvolucionHC').title = "PACIENTE: " + Ext.getCmp('sysPacienteHC').getValue();
                                    Ext.getCmp('gridHistorialEvoluciones').store.load({
                                        params: {
                                            pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                                            pPaciente: Ext.getCmp('sysIdPacienteHC').getValue()
                                        }
                                    });
                                    cmpResumenHC.show();
                                }
                            }
                        },
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar Evolución',
                            iconCls: 'btnGuardar',
                            id: 'btnGuardarEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 0)
                                    {
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Guardar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnGuardarRegistrosMedicinaGeneral();
                                                }
                                            }
                                        });
                                    }else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Modificar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnModificarRegistrosMedicinaGeneral();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                }
            }
        ];
        this.on({
            afterlayout:{
                scope:this, 
                single:true, 
                fn:function() {
                    Ext.Msg.hide();
                    //Predefinir Comportamiento Campos

                    if(Ext.getCmp('sysFechaHC').getValue() != null || Ext.getCmp('sysFechaHC').getValue() != 0){
                       calculoEdadPacienteMeses()
                    }
                    
                    
                    
                    //CARGAR ANTECEDENTES
                    if(paramOpcion === "Nuevo"){ 
                        Ext.Ajax.request({
                            url: '../../controlador/asistencial/evolucionhc.php',
                            waitMsg: 'Cargando Información...',
                            params:{
                                pCAS: myCAS,
                                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                                task: 'ImportarAntecedentesFamiliares'
                            },
                            success: function(result, request)
                            {
                                var jsonAntFamiliares = Ext.util.JSON.decode(result.responseText);
                                CargarDataHCAntecedentes(jsonAntFamiliares.data.sysEvolucion);
                                Ext.Ajax.request({
                                    url: '../../controlador/asistencial/evolucionhc.php',
                                    waitMsg: 'Cargando Información...',
                                    params:{
                                        pCAS: myCAS,
                                        pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                                        task: 'ImportarAntecedentesPersonalesOfiClinic001'
                                    },
                                    success: function(result, request)
                                    {
                                        var jsonAntPersonales = Ext.util.JSON.decode(result.responseText);
                                        UtilCargarAntecedentesOfiClinic001(jsonAntPersonales.data);
                                    },
                                    scope:this
                                });
                            },
                            scope:this
                        });
                    }
                }
            }
        });
        winHCCaminataUi.superclass.initComponent.call(this);
    }
});

function fnGuardarRegistrosMedicinaGeneral(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc2013.php',
            params:{
                task: 'guardar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pidPlantillaHC : Ext.getCmp('sysIdCodPlantillaHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue(),
                /*pFormulacion: Ext.getCmp('sysFormulacion').getValue(),
                pOcupacion4505: Ext.getCmp('strOcupacionHC').getValue(),
                pEtnia4505: Ext.getCmp('intEtniaHC').getValue(),
                pEscolaridad4505: Ext.getCmp('intEscolaridadHC').getValue(),
                pGestacion4505: Ext.getCmp('intIdentificacionRiesgoGestacion').getValue(),
                pSifilisGestacional4505: Ext.getCmp('intIdentificacionRiesgoSifilisGestacional').getValue(),
                pHipertencionGestacional4505: Ext.getCmp('intIdentificacionRiesgoHipertencionGestacional').getValue(),
                pHipotiroidismoCongenito4505: Ext.getCmp('intIdentificacionRiesgoHipotiroidismoCongenito').getValue(),
                pTuberculosisMultidrogoresistente4505: Ext.getCmp('intIdentificacionRiesgoTuberculosisMultidrogoresistente').getValue(),
                pLepra4505: Ext.getCmp('intIdentificacionRiesgoLepra').getValue(),
                pVictimaMaltrato4505: Ext.getCmp('intIdentificacionRiesgoVictimaMaltrato').getValue(),
                pViolenciaSexual4505: Ext.getCmp('intIdentificacionRiesgoViolenciaSexual').getValue(),
                pFluorosisDental4505: Ext.getCmp('intIdentificacionRiesgoFluorosisDental').getValue(),*/
                pGuardarSignos: "SI"/*,
                pTASIS: Ext.getCmp('intEXAFISTASentadoSistolica').getValue(),
                pTADIAS: Ext.getCmp('intEXAFISTASentadoDiastolica').getValue(),
                pTensionArterialSistolicaPie: Ext.getCmp('intEXAFISTAdePieSistolica').getValue(),
                pTensionArterialDiastolicaPie: Ext.getCmp('intEXAFISTAdePieDiastolica').getValue(),
                pTalla: Ext.getCmp('intEXAFISTalla').getValue(),
                pPeso: Ext.getCmp('intEXAFISPeso').getValue(),
                pIMC: Ext.getCmp('intEXAFISIMC').getValue(),
                pIMCClasifica: Ext.getCmp('strEXAFISIMCClasificacon').getValue(),
                pPerimetroAbdominal: Ext.getCmp('strEXAFISPA').getValue(),
                pTE: Ext.getCmp('intEXAFISTemp').getValue(),
                pFC: Ext.getCmp('intEXAFISFC').getValue(),
                pFR: Ext.getCmp('intEXAFISFR').getValue()*/
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1);
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function fnModificarRegistrosMedicinaGeneral(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc2013.php',
            params:{
                task: 'modificar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue(),
                /*pFormulacion: Ext.getCmp('sysFormulacion').getValue(),
                pOcupacion4505: Ext.getCmp('strOcupacionHC').getValue(),
                pEtnia4505: Ext.getCmp('intEtniaHC').getValue(),
                pEscolaridad4505: Ext.getCmp('intEscolaridadHC').getValue(),
                pGestacion4505: Ext.getCmp('intIdentificacionRiesgoGestacion').getValue(),
                pSifilisGestacional4505: Ext.getCmp('intIdentificacionRiesgoSifilisGestacional').getValue(),
                pHipertencionGestacional4505: Ext.getCmp('intIdentificacionRiesgoHipertencionGestacional').getValue(),
                pHipotiroidismoCongenito4505: Ext.getCmp('intIdentificacionRiesgoHipotiroidismoCongenito').getValue(),
                pTuberculosisMultidrogoresistente4505: Ext.getCmp('intIdentificacionRiesgoTuberculosisMultidrogoresistente').getValue(),
                pLepra4505: Ext.getCmp('intIdentificacionRiesgoLepra').getValue(),
                pVictimaMaltrato4505: Ext.getCmp('intIdentificacionRiesgoVictimaMaltrato').getValue(),
                pViolenciaSexual4505: Ext.getCmp('intIdentificacionRiesgoViolenciaSexual').getValue(),
                pFluorosisDental4505: Ext.getCmp('intIdentificacionRiesgoFluorosisDental').getValue(),*/
                pGuardarSignos: "SI"/*,
                pTASIS: Ext.getCmp('intEXAFISTASentadoSistolica').getValue(),
                pTADIAS: Ext.getCmp('intEXAFISTASentadoDiastolica').getValue(),
                pTensionArterialSistolicaPie: Ext.getCmp('intEXAFISTAdePieSistolica').getValue(),
                pTensionArterialDiastolicaPie: Ext.getCmp('intEXAFISTAdePieDiastolica').getValue(),
                pTalla: Ext.getCmp('intEXAFISTalla').getValue(),
                pPeso: Ext.getCmp('intEXAFISPeso').getValue(),
                pIMC: Ext.getCmp('intEXAFISIMC').getValue(),
                pIMCClasifica: Ext.getCmp('strEXAFISIMCClasificacon').getValue(),
                pPerimetroAbdominal: Ext.getCmp('strEXAFISPA').getValue(),
                pTE: Ext.getCmp('intEXAFISTemp').getValue(),
                pFC: Ext.getCmp('intEXAFISFC').getValue(),
                pFR: Ext.getCmp('intEXAFISFR').getValue()*/
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1);
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function calculoEdadPacienteMeses(){
    var valFecha1 = 0;
    var pFec2Anio = 0;
    var pFec2Mes = 0;
    var pFec2Dia = 0;
    var valFecha2 = 0;
    MesesCumplidos = 0;
    AniosCumplidos = 0;


    valFecha1 = Ext.getCmp('sysFechaHC').getValue();
    pFec2Anio = Ext.getCmp('sysFechaNac').getValue().substr(6,4);
    pFec2Mes = Ext.getCmp('sysFechaNac').getValue().substr(3,2);
    pFec2Dia = Ext.getCmp('sysFechaNac').getValue().substr(0,2);
    
    valFecha2 =  pFec2Anio + "/" + pFec2Mes + "/" + pFec2Dia;

    MesesCumplidos = MostrarEdadMeses(valFecha1, valFecha2);
    
    AniosCumplidos = MostrarEdadAnios(valFecha1, valFecha2);
}