/*
* @category    Formulario Modelo Historia Clinica Monitoreo Presion
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


winHCAfinamiento001Ui = Ext.extend(Ext.Window, {
    title: 'eOfiClinic ©  .:: Monitoreo Presion Arterial ::.',
    width: 990,
    height: 606,
    closable: false,
    resizable: false,
    draggable: false,
    modal: true,
    id: 'winHC',
    initComponent: function() {
        
        tmpmx = objMX;
        tmpmxadd = objMXADD;
        tmpexa = objEXA;
        tmprem = objREM;
        myPaciente = 0;
        myCAS = 0;
        
        try {
            var campo = Ext.getCmp('sysPacientePlantillaHC');
            if ( campo != null ) {
                myPaciente = Ext.getCmp('sysPacientePlantillaHC').getValue();
            }
        }catch(ex){
        }
        if(myPaciente == 0){
            try {
                var campo1 = Ext.getCmp('sysIdPacienteHC');
                if ( campo1 != null ) {
                    myPaciente = Ext.getCmp('sysIdPacienteHC').getValue();
                }
            }catch(ex){
            }
        }
        if(myPaciente == 0){
            try {
                var campo5 = Ext.getCmp('sysPacienteRefHC');
                if ( campo5 != null ) {
                    myPaciente = Ext.getCmp('sysPacienteRefHC').getValue();
                }
            }catch(ex){
            }
        }
        try {
            var campo2 = Ext.getCmp('sysCASPlantillaHC');
            if ( campo2 != null ) {
                myCAS = Ext.getCmp('sysCASPlantillaHC').getValue();
            }
        }catch(ex){
        }
        if(myCAS == 0){
            try {
                var campo3 = Ext.getCmp('sysCASHC');
                if ( campo3 != null ) {
                    myCAS = Ext.getCmp('sysCASHC').getValue();
                }
            }catch(ex){
            }
        }
        if(myCAS == 0){
            try {
                var campo4 = Ext.getCmp('sysCASRefHC');
                if ( campo4 != null ) {
                    myCAS = Ext.getCmp('sysCASRefHC').getValue();
                }
            }catch(ex){
            }
        }
        if (objMX != "NA"){
            var xSolMX = eval(objMX);
            Ext.getCmp('gridMedicamentosHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: wPaciente,
                    pCAS: wCAS
                }
            });
        }
        else{
            var xSolMX = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        if (objEXA != "NA"){
            var xSolEXA = eval(objEXA);
            Ext.getCmp('gridExamenesHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: wPaciente,
                    pCAS: wCAS
                }
            });
        }else{
            var xSolEXA = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }    
        if (objREM != "NA"){
            var xSolREM = eval(objREM);
            Ext.getCmp('gridRemisionesHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: wPaciente,
                    pCAS: wCAS
                }
            });
        }else{
            var xSolREM = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
                     
              
        //
        this.items = [
            {
                xtype: 'panel',
                frame: true,
                anchor: '100%',
                id: 'panelHC',
                border: false,
                height: 570,
                autoScroll: true,
                layout: 'form',
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'tabpanel',
                        anchor: '99%',
                        autoHeight: true,
                        border: false,
                        enableTabScroll: true,
                        ref: 'fTabPanel',
                        id: 'fTabPanel',
                        activeTab: 0,
                        items: [
                            {
                                xtype: 'panel',
                                title: 'Evolucion',
                                autoHeight: true,
                                autoScroll: true,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaEvolucion',
                                layout: 'form',
                                items: [
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysIdCodPlantillaHC'
                                    },
                                     {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        value: 1,
                                        id: 'sysUsaGridSalida'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                                        value: 0,
                                        id: 'sysYaGuardoHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Plantilla',
                                        id: 'sysPlantillaHC',
                                        name: 'PLANTILLA'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysRutaRptHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysRutaRptMx'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysRutaRptExa'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysRutaRptRem'
                                    },
                                    {
                                        xtype: 'textfield',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Actividad',
                                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                                        id: 'sysActividadHC',
                                        name: 'PLANTILLA'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Empresa',
                                        id: 'sysEmpresaHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'IPS',
                                        id: 'sysIPSHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Usuario',
                                        id: 'sysUsuarioHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Profesional',
                                        id: 'sysProfesionalHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Paciente',
                                        id: 'sysIdPacienteHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Apertura',
                                        id: 'sysAperturaHC'
                                    },
                                    {
                                        xtype: 'textfield',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Cliente',
                                        id: 'sysClienteHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Plantilla',
                                        id: 'sysIdClienteHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Plantilla',
                                        id: 'sysIdPlanHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Plantilla',
                                        id: 'sysIdSubPlanHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Plantilla',
                                        id: 'sysIdContratoHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Genero',
                                        id: 'sysGeneroPacHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Edad',
                                        id: 'sysEdadPacHC'
                                    },
                                    {
                                        xtype: 'textfield',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Profesional',
                                        id: 'sysProfesionalAgendaHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'ConsecutivoDetalle',
                                        id: 'sysConsecutivoDetalleHC'
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'CAS',
                                                id: 'sysCASHC'
                                            },
                                            {
                                                xtype: 'displayfield',
                                                id: 'sysFechaHC',
                                                value: 'Fecha: '
                                            },
                                            {
                                                xtype: 'textfield',
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysFechaHC'
                                            },
                                            {
                                                xtype: 'displayfield',
                                                id: 'sysHoraHC',
                                                value: 'Hora: '
                                            },
                                            {
                                                xtype: 'textfield',
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysHoraHC'
                                            },
                                            {
                                                xtype: 'displayfield',
                                                id: 'sysLegalizacionHC',
                                                value: 'Legalización: '
                                            },
                                            {
                                                xtype: 'textfield',
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysLegalizaHC'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'textfield',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Paciente',
                                        value: 'CC 792558261  - JORGE GALEANO RUIZ - (Masculino) FechaNac: 1973-01-30, Edad 38 Años',
                                        id: 'sysPacienteHC'
                                    },
                                    {
                                        HTML: '<hr>'
                                    },
                                    {
                                        xtype: 'hidden',
                                        width: 100,
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Genero',
                                        id: 'sysGeneroHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        width: 100,
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysFechaNac'
                                    },
                                    {
                                        xtype: 'hidden',
                                        width: 350,
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysEdadHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        width: 370,
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Ocupación',
                                        id: 'sysOcupacionHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        width: 370,
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysDiscapacidadHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        width: 370,
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Estado Civil',
                                        id: 'sysEstadoCivilHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        width: 380,
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysEscolaridadHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        width: 370,
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Dirección',
                                        id: 'sysDireccionHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        width: 390,
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysTelefonoHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        width: 380,
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Etnia',
                                        id: 'sysEtniaHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        width: 390,
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysEstratoHC'
                                    },
                                    {
                                        html: '<hr>',
                                        style: 'background:transparent;',
                                        border: false
                                    },
                                    {
                                        xtype: 'form',
                                        frame: true,
                                        anchor: '100%',
                                        id: 'frmHC',
                                        padding: 10,
                                        border: false,
                                        autoScroll: true,
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        fieldLabel: 'Acompañante',
                                                        name: 'Acompañante',
                                                        width: 350,
                                                        allowBlank: true,
                                                        id: 'strDATINGPROGAcompanante'
                                                    },
                                                    {
                                                        html: '   Parentesco:'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name: 'Parentezco',
                                                        width: 350,
                                                        allowBlank: true,
                                                        store: stParentesco,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strDATINGPROGParentesco'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'FACTORES DE RIESGO',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'panel',
                                                        layout: 'table',
                                                        anchor: '100%',
                                                        padding: 0,
                                                        layoutConfig: {
                                                            columns: 3
                                                        },
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'panel',
                                                                layout: 'form',
                                                                width: 250,
                                                                height: 80,
                                                                labelWidth: 200,
                                                                labelSeparator: '',
                                                                labelStyle: 'color:blue;',
                                                                items: [
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'Fuma',
                                                                        name: 'Fuma',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolFacRiFuma'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'Toma Licor',
                                                                        name: 'Toma Licor',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolFacRiTomaLicor'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'Toma Tinto Constantemente',
                                                                        name: 'Toma Tinto Constantemente',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolFacRiTomaTinto'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                layout: 'form',
                                                                width: 250,
                                                                height: 80,
                                                                labelWidth: 200,
                                                                labelSeparator: '',
                                                                labelStyle: 'color:blue;',
                                                                items: [
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'Sobre Peso',
                                                                        name: 'Sobre Peso',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolFacRiSobrePeso'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'Sedentarismo',
                                                                        name: 'Sedentarismo',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolFacRiSedentarismo'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                layout: 'form',
                                                                width: 250,
                                                                height: 80,
                                                                labelWidth: 200,
                                                                labelSeparator: '',
                                                                labelStyle: 'color:blue;',
                                                                items: [
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'Antecedentes Familiares HTA',
                                                                        name: 'Antecedentes Familiares HTA',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolFacRiAntecedentesHTA'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'Estres',
                                                                        name: 'Sedentarismo',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolFacRiEstres'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'CIFRAS T.A.',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'panel',
                                                        layout: 'table',
                                                        anchor: '100%',
                                                        padding: 0,
                                                        layoutConfig: {
                                                            columns: 5
                                                        },
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'panel',
                                                                layout: 'form',
                                                                width: 130,
                                                                labelWidth: 1,
                                                                autoHeight: true,
                                                                labelSeparator: '',
                                                                labelStyle: 'color:blue;',
                                                                title: '<center>FECHA</center>',
                                                                items: [
                                                                    {
                                                                        xtype: 'datefield',
                                                                        width: 120,
                                                                        name: 'Fecha 1.',
                                                                        allowBlank: true,
                                                                        emptyText: '(dia/mes/año) ',
                                                                        style: 'text-align:center;',
                                                                        id: 'fecCifrasFecha_1'
                                                                    },
                                                                    {
                                                                        xtype: 'datefield',
                                                                        width: 120,
                                                                        name: 'Fecha 2.',
                                                                        allowBlank: true,
                                                                        emptyText: '(dia/mes/año) ',
                                                                        style: 'text-align:center;',
                                                                        id: 'fecCifrasFecha_2'
                                                                    },
                                                                    {
                                                                        xtype: 'datefield',
                                                                        width: 120,
                                                                        name: 'Fecha 3.',
                                                                        allowBlank: true,
                                                                        emptyText: '(dia/mes/año) ',
                                                                        style: 'text-align:center;',
                                                                        id: 'fecCifrasFecha_3'
                                                                    },
                                                                    {
                                                                        xtype: 'datefield',
                                                                        width: 120,
                                                                        name: 'Fecha 4.',
                                                                        allowBlank: true,
                                                                        emptyText: '(dia/mes/año) ',
                                                                        style: 'text-align:center;',
                                                                        id: 'fecCifrasFecha_4'
                                                                    },
                                                                    {
                                                                        xtype: 'datefield',
                                                                        width: 120,
                                                                        name: 'Fecha 5.',
                                                                        allowBlank: true,
                                                                        emptyText: '(dia/mes/año) ',
                                                                        style: 'text-align:center;',
                                                                        id: 'fecCifrasFecha_5'
                                                                    },
                                                                    {
                                                                        xtype: 'datefield',
                                                                        width: 120,
                                                                        name: 'Fecha 6.',
                                                                        allowBlank: true,
                                                                        emptyText: '(dia/mes/año) ',
                                                                        style: 'text-align:center;',
                                                                        id: 'fecCifrasFecha_6'
                                                                    },
                                                                    {
                                                                        xtype: 'datefield',
                                                                        width: 120,
                                                                        name: 'Fecha 7.',
                                                                        allowBlank: true,
                                                                        emptyText: '(dia/mes/año) ',
                                                                        style: 'text-align:center;',
                                                                        id: 'fecCifrasFecha_7'
                                                                    },
                                                                    {
                                                                        xtype: 'datefield',
                                                                        width: 120,
                                                                        name: 'Fecha 8.',
                                                                        allowBlank: true,
                                                                        emptyText: '(dia/mes/año) ',
                                                                        style: 'text-align:center;',
                                                                        id: 'fecCifrasFecha_8'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                layout: 'form',
                                                                width: 165,
                                                                labelWidth: 1,
                                                                autoHeight: true,
                                                                labelSeparator: '',
                                                                labelStyle: 'color:blue;',
                                                                title: '<center>ACOSTADO</center>',
                                                                items: [
                                                                    {
                                                                        xtype: 'compositefield',
                                                                        style: 'background:transparent;',
                                                                        items: [
                                                                            {
                                                                                xtype: 'numberfield',
                                                                                name: 'T.A. (Acostado) Sistolica 1.',
                                                                                width: 70,
                                                                                minValue: 0,
                                                                                maxValue: 300,
                                                                                decimalPrecision: 0,
                                                                                allowBlank: true,
                                                                                id: 'intCifrasAcostadoSistolica_1'
                                                                            },
                                                                            {
                                                                                html: '/'
                                                                            },
                                                                            {
                                                                                xtype: 'numberfield',
                                                                                name: 'T.A. (Acostado) Diastolica 1.',
                                                                                width: 70,
                                                                                minValue: 0,
                                                                                maxValue: 300,
                                                                                decimalPrecision: 0,
                                                                                allowBlank: true,
                                                                                id: 'intCifrasAcostadoDiastolica_1'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'compositefield',
                                                                        style: 'background:transparent;',
                                                                        items: [
                                                                            {
                                                                                xtype: 'numberfield',
                                                                                name: 'T.A. (Acostado) Sistolica 2.',
                                                                                width: 70,
                                                                                minValue: 0,
                                                                                maxValue: 300,
                                                                                decimalPrecision: 0,
                                                                                allowBlank: true,
                                                                                id: 'intCifrasAcostadoSistolica_2'
                                                                            },
                                                                            {
                                                                                html: '/'
                                                                            },
                                                                            {
                                                                                xtype: 'numberfield',
                                                                                name: 'T.A. (Acostado) Diastolica 2.',
                                                                                width: 70,
                                                                                minValue: 0,
                                                                                maxValue: 300,
                                                                                decimalPrecision: 0,
                                                                                allowBlank: true,
                                                                                id: 'intCifrasAcostadoDiastolica_2'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'compositefield',
                                                                        style: 'background:transparent;',
                                                                        items: [
                                                                            {
                                                                                xtype: 'numberfield',
                                                                                name: 'T.A. (Acostado) Sistolica 3.',
                                                                                width: 70,
                                                                                minValue: 0,
                                                                                maxValue: 300,
                                                                                decimalPrecision: 0,
                                                                                allowBlank: true,
                                                                                id: 'intCifrasAcostadoSistolica_3'
                                                                            },
                                                                            {
                                                                                html: '/'
                                                                            },
                                                                            {
                                                                                xtype: 'numberfield',
                                                                                name: 'T.A. (Acostado) Diastolica 3.',
                                                                                width: 70,
                                                                                minValue: 0,
                                                                                maxValue: 300,
                                                                                decimalPrecision: 0,
                                                                                allowBlank: true,
                                                                                id: 'intCifrasAcostadoDiastolica_3'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'compositefield',
                                                                        style: 'background:transparent;',
                                                                        items: [
                                                                            {
                                                                                xtype: 'numberfield',
                                                                                name: 'T.A. (Acostado) Sistolica 4.',
                                                                                width: 70,
                                                                                minValue: 0,
                                                                                maxValue: 300,
                                                                                decimalPrecision: 0,
                                                                                allowBlank: true,
                                                                                id: 'intCifrasAcostadoSistolica_4'
                                                                            },
                                                                            {
                                                                                html: '/'
                                                                            },
                                                                            {
                                                                                xtype: 'numberfield',
                                                                                name: 'T.A. (Acostado) Diastolica 4.',
                                                                                width: 70,
                                                                                minValue: 0,
                                                                                maxValue: 300,
                                                                                decimalPrecision: 0,
                                                                                allowBlank: true,
                                                                                id: 'intCifrasAcostadoDiastolica_4'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'compositefield',
                                                                        style: 'background:transparent;',
                                                                        items: [
                                                                            {
                                                                                xtype: 'numberfield',
                                                                                name: 'T.A. (Acostado) Sistolica 5.',
                                                                                width: 70,
                                                                                minValue: 0,
                                                                                maxValue: 300,
                                                                                decimalPrecision: 0,
                                                                                allowBlank: true,
                                                                                id: 'intCifrasAcostadoSistolica_5'
                                                                            },
                                                                            {
                                                                                html: '/'
                                                                            },
                                                                            {
                                                                                xtype: 'numberfield',
                                                                                name: 'T.A. (Acostado) Diastolica 5.',
                                                                                width: 70,
                                                                                minValue: 0,
                                                                                maxValue: 300,
                                                                                decimalPrecision: 0,
                                                                                allowBlank: true,
                                                                                id: 'intCifrasAcostadoDiastolica_5'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'compositefield',
                                                                        style: 'background:transparent;',
                                                                        items: [
                                                                            {
                                                                                xtype: 'numberfield',
                                                                                name: 'T.A. (Acostado) Sistolica 6.',
                                                                                width: 70,
                                                                                minValue: 0,
                                                                                maxValue: 300,
                                                                                decimalPrecision: 0,
                                                                                allowBlank: true,
                                                                                id: 'intCifrasAcostadoSistolica_6'
                                                                            },
                                                                            {
                                                                                html: '/'
                                                                            },
                                                                            {
                                                                                xtype: 'numberfield',
                                                                                name: 'T.A. (Acostado) Diastolica 6.',
                                                                                width: 70,
                                                                                minValue: 0,
                                                                                maxValue: 300,
                                                                                decimalPrecision: 0,
                                                                                allowBlank: true,
                                                                                id: 'intCifrasAcostadoDiastolica_6'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'compositefield',
                                                                        style: 'background:transparent;',
                                                                        items: [
                                                                            {
                                                                                xtype: 'numberfield',
                                                                                name: 'T.A. (Acostado) Sistolica 7.',
                                                                                width: 70,
                                                                                minValue: 0,
                                                                                maxValue: 300,
                                                                                decimalPrecision: 0,
                                                                                allowBlank: true,
                                                                                id: 'intCifrasAcostadoSistolica_7'
                                                                            },
                                                                            {
                                                                                html: '/'
                                                                            },
                                                                            {
                                                                                xtype: 'numberfield',
                                                                                name: 'T.A. (Acostado) Diastolica 7.',
                                                                                width: 70,
                                                                                minValue: 0,
                                                                                maxValue: 300,
                                                                                decimalPrecision: 0,
                                                                                allowBlank: true,
                                                                                id: 'intCifrasAcostadoDiastolica_7'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'compositefield',
                                                                        style: 'background:transparent;',
                                                                        items: [
                                                                            {
                                                                                xtype: 'numberfield',
                                                                                name: 'T.A. (Acostado) Sistolica 8.',
                                                                                width: 70,
                                                                                minValue: 0,
                                                                                maxValue: 300,
                                                                                decimalPrecision: 0,
                                                                                allowBlank: true,
                                                                                id: 'intCifrasAcostadoSistolica_8'
                                                                            },
                                                                            {
                                                                                html: '/'
                                                                            },
                                                                            {
                                                                                xtype: 'numberfield',
                                                                                name: 'T.A. (Acostado) Diastolica 8.',
                                                                                width: 70,
                                                                                minValue: 0,
                                                                                maxValue: 300,
                                                                                decimalPrecision: 0,
                                                                                allowBlank: true,
                                                                                id: 'intCifrasAcostadoDiastolica_8'
                                                                            }
                                                                        ]
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                layout: 'form',
                                                                width: 165,
                                                                labelWidth: 1,
                                                                autoHeight: true,
                                                                labelSeparator: '',
                                                                labelStyle: 'color:blue;',
                                                                title: '<center>SENTADO</center>',
                                                                items: [
                                                                    {
                                                                        xtype: 'compositefield',
                                                                        style: 'background:transparent;',
                                                                        items: [
                                                                            {
                                                                                xtype: 'numberfield',
                                                                                name: 'T.A. (Sentado) Sistolica 1.',
                                                                                width: 70,
                                                                                minValue: 0,
                                                                                maxValue: 300,
                                                                                decimalPrecision: 0,
                                                                                allowBlank: true,
                                                                                id: 'intCifrasSentadoSistolica_1'
                                                                            },
                                                                            {
                                                                                html: '/'
                                                                            },
                                                                            {
                                                                                xtype: 'numberfield',
                                                                                name: 'T.A. (Sentado) Diastolica 1.',
                                                                                width: 70,
                                                                                minValue: 0,
                                                                                maxValue: 300,
                                                                                decimalPrecision: 0,
                                                                                allowBlank: true,
                                                                                id: 'intCifrasSentadoDiastolica_1'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'compositefield',
                                                                        style: 'background:transparent;',
                                                                        items: [
                                                                            {
                                                                                xtype: 'numberfield',
                                                                                name: 'T.A. (Sentado) Sistolica 2.',
                                                                                width: 70,
                                                                                minValue: 0,
                                                                                maxValue: 300,
                                                                                decimalPrecision: 0,
                                                                                allowBlank: true,
                                                                                id: 'intCifrasSentadoSistolica_2'
                                                                            },
                                                                            {
                                                                                html: '/'
                                                                            },
                                                                            {
                                                                                xtype: 'numberfield',
                                                                                name: 'T.A. (Sentado) Diastolica 2.',
                                                                                width: 70,
                                                                                minValue: 0,
                                                                                maxValue: 300,
                                                                                decimalPrecision: 0,
                                                                                allowBlank: true,
                                                                                id: 'intCifrasSentadoDiastolica_2'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'compositefield',
                                                                        style: 'background:transparent;',
                                                                        items: [
                                                                            {
                                                                                xtype: 'numberfield',
                                                                                name: 'T.A. (Sentado) Sistolica 3.',
                                                                                width: 70,
                                                                                minValue: 0,
                                                                                maxValue: 300,
                                                                                decimalPrecision: 0,
                                                                                allowBlank: true,
                                                                                id: 'intCifrasSentadoSistolica_3'
                                                                            },
                                                                            {
                                                                                html: '/'
                                                                            },
                                                                            {
                                                                                xtype: 'numberfield',
                                                                                name: 'T.A. (Sentado) Diastolica 3.',
                                                                                width: 70,
                                                                                minValue: 0,
                                                                                maxValue: 300,
                                                                                decimalPrecision: 0,
                                                                                allowBlank: true,
                                                                                id: 'intCifrasSentadoDiastolica_3'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'compositefield',
                                                                        style: 'background:transparent;',
                                                                        items: [
                                                                            {
                                                                                xtype: 'numberfield',
                                                                                name: 'T.A. (Sentado) Sistolica 4.',
                                                                                width: 70,
                                                                                minValue: 0,
                                                                                maxValue: 300,
                                                                                decimalPrecision: 0,
                                                                                allowBlank: true,
                                                                                id: 'intCifrasSentadoSistolica_4'
                                                                            },
                                                                            {
                                                                                html: '/'
                                                                            },
                                                                            {
                                                                                xtype: 'numberfield',
                                                                                name: 'T.A. (Sentado) Diastolica 4.',
                                                                                width: 70,
                                                                                minValue: 0,
                                                                                maxValue: 300,
                                                                                decimalPrecision: 0,
                                                                                allowBlank: true,
                                                                                id: 'intCifrasSentadoDiastolica_4'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'compositefield',
                                                                        style: 'background:transparent;',
                                                                        items: [
                                                                            {
                                                                                xtype: 'numberfield',
                                                                                name: 'T.A. (Sentado) Sistolica 5.',
                                                                                width: 70,
                                                                                minValue: 0,
                                                                                maxValue: 300,
                                                                                decimalPrecision: 0,
                                                                                allowBlank: true,
                                                                                id: 'intCifrasSentadoSistolica_5'
                                                                            },
                                                                            {
                                                                                html: '/'
                                                                            },
                                                                            {
                                                                                xtype: 'numberfield',
                                                                                name: 'T.A. (Sentado) Diastolica 5.',
                                                                                width: 70,
                                                                                minValue: 0,
                                                                                maxValue: 300,
                                                                                decimalPrecision: 0,
                                                                                allowBlank: true,
                                                                                id: 'intCifrasSentadoDiastolica_5'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'compositefield',
                                                                        style: 'background:transparent;',
                                                                        items: [
                                                                            {
                                                                                xtype: 'numberfield',
                                                                                name: 'T.A. (Sentado) Sistolica 6.',
                                                                                width: 70,
                                                                                minValue: 0,
                                                                                maxValue: 300,
                                                                                decimalPrecision: 0,
                                                                                allowBlank: true,
                                                                                id: 'intCifrasSentadoSistolica_6'
                                                                            },
                                                                            {
                                                                                html: '/'
                                                                            },
                                                                            {
                                                                                xtype: 'numberfield',
                                                                                name: 'T.A. (Sentado) Diastolica 6.',
                                                                                width: 70,
                                                                                minValue: 0,
                                                                                maxValue: 300,
                                                                                decimalPrecision: 0,
                                                                                allowBlank: true,
                                                                                id: 'intCifrasSentadoDiastolica_6'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'compositefield',
                                                                        style: 'background:transparent;',
                                                                        items: [
                                                                            {
                                                                                xtype: 'numberfield',
                                                                                name: 'T.A. (Sentado) Sistolica 7.',
                                                                                width: 70,
                                                                                minValue: 0,
                                                                                maxValue: 300,
                                                                                decimalPrecision: 0,
                                                                                allowBlank: true,
                                                                                id: 'intCifrasSentadoSistolica_7'
                                                                            },
                                                                            {
                                                                                html: '/'
                                                                            },
                                                                            {
                                                                                xtype: 'numberfield',
                                                                                name: 'T.A. (Sentado) Diastolica 7.',
                                                                                width: 70,
                                                                                minValue: 0,
                                                                                maxValue: 300,
                                                                                decimalPrecision: 0,
                                                                                allowBlank: true,
                                                                                id: 'intCifrasSentadoDiastolica_7'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'compositefield',
                                                                        style: 'background:transparent;',
                                                                        items: [
                                                                            {
                                                                                xtype: 'numberfield',
                                                                                name: 'T.A. (Sentado) Sistolica 8.',
                                                                                width: 70,
                                                                                minValue: 0,
                                                                                maxValue: 300,
                                                                                decimalPrecision: 0,
                                                                                allowBlank: true,
                                                                                id: 'intCifrasSentadoSistolica_8'
                                                                            },
                                                                            {
                                                                                html: '/'
                                                                            },
                                                                            {
                                                                                xtype: 'numberfield',
                                                                                name: 'T.A. (Sentado) Diastolica 8.',
                                                                                width: 70,
                                                                                minValue: 0,
                                                                                maxValue: 300,
                                                                                decimalPrecision: 0,
                                                                                allowBlank: true,
                                                                                id: 'intCifrasSentadoDiastolica_8'
                                                                            }
                                                                        ]
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                layout: 'form',
                                                                width: 165,
                                                                labelWidth: 1,
                                                                autoHeight: true,
                                                                labelSeparator: '',
                                                                labelStyle: 'color:blue;',
                                                                title: '<center>DE PIE</center>',
                                                                items: [
                                                                    {
                                                                        xtype: 'compositefield',
                                                                        style: 'background:transparent;',
                                                                        items: [
                                                                            {
                                                                                xtype: 'numberfield',
                                                                                name: 'T.A. (De Pie) Sistolica 1.',
                                                                                width: 70,
                                                                                minValue: 0,
                                                                                maxValue: 300,
                                                                                decimalPrecision: 0,
                                                                                allowBlank: true,
                                                                                id: 'intCifrasDePieSistolica_1'
                                                                            },
                                                                            {
                                                                                html: '/'
                                                                            },
                                                                            {
                                                                                xtype: 'numberfield',
                                                                                name: 'T.A. (De Pie) Diastolica 1.',
                                                                                width: 70,
                                                                                minValue: 0,
                                                                                maxValue: 300,
                                                                                decimalPrecision: 0,
                                                                                allowBlank: true,
                                                                                id: 'intCifrasDePieDiastolica_1'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'compositefield',
                                                                        style: 'background:transparent;',
                                                                        items: [
                                                                            {
                                                                                xtype: 'numberfield',
                                                                                name: 'T.A. (De Pie) Sistolica 2.',
                                                                                width: 70,
                                                                                minValue: 0,
                                                                                maxValue: 300,
                                                                                decimalPrecision: 0,
                                                                                allowBlank: true,
                                                                                id: 'intCifrasDePieSistolica_2'
                                                                            },
                                                                            {
                                                                                html: '/'
                                                                            },
                                                                            {
                                                                                xtype: 'numberfield',
                                                                                name: 'T.A. (De Pie) Diastolica 2.',
                                                                                width: 70,
                                                                                minValue: 0,
                                                                                maxValue: 300,
                                                                                decimalPrecision: 0,
                                                                                allowBlank: true,
                                                                                id: 'intCifrasDePieDiastolica_2'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'compositefield',
                                                                        style: 'background:transparent;',
                                                                        items: [
                                                                            {
                                                                                xtype: 'numberfield',
                                                                                name: 'T.A. (De Pie) Sistolica 3.',
                                                                                width: 70,
                                                                                minValue: 0,
                                                                                maxValue: 300,
                                                                                decimalPrecision: 0,
                                                                                allowBlank: true,
                                                                                id: 'intCifrasDePieSistolica_3'
                                                                            },
                                                                            {
                                                                                html: '/'
                                                                            },
                                                                            {
                                                                                xtype: 'numberfield',
                                                                                name: 'T.A. (De Pie) Diastolica 3.',
                                                                                width: 70,
                                                                                minValue: 0,
                                                                                maxValue: 300,
                                                                                decimalPrecision: 0,
                                                                                allowBlank: true,
                                                                                id: 'intCifrasDePieDiastolica_3'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'compositefield',
                                                                        style: 'background:transparent;',
                                                                        items: [
                                                                            {
                                                                                xtype: 'numberfield',
                                                                                name: 'T.A. (De Pie) Sistolica 4.',
                                                                                width: 70,
                                                                                minValue: 0,
                                                                                maxValue: 300,
                                                                                decimalPrecision: 0,
                                                                                allowBlank: true,
                                                                                id: 'intCifrasDePieSistolica_4'
                                                                            },
                                                                            {
                                                                                html: '/'
                                                                            },
                                                                            {
                                                                                xtype: 'numberfield',
                                                                                name: 'T.A. (De Pie) Diastolica 4.',
                                                                                width: 70,
                                                                                minValue: 0,
                                                                                maxValue: 300,
                                                                                decimalPrecision: 0,
                                                                                allowBlank: true,
                                                                                id: 'intCifrasDePieDiastolica_4'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'compositefield',
                                                                        style: 'background:transparent;',
                                                                        items: [
                                                                            {
                                                                                xtype: 'numberfield',
                                                                                name: 'T.A. (De Pie) Sistolica 5.',
                                                                                width: 70,
                                                                                minValue: 0,
                                                                                maxValue: 300,
                                                                                decimalPrecision: 0,
                                                                                allowBlank: true,
                                                                                id: 'intCifrasDePieSistolica_5'
                                                                            },
                                                                            {
                                                                                html: '/'
                                                                            },
                                                                            {
                                                                                xtype: 'numberfield',
                                                                                name: 'T.A. (De Pie) Diastolica 5.',
                                                                                width: 70,
                                                                                minValue: 0,
                                                                                maxValue: 300,
                                                                                decimalPrecision: 0,
                                                                                allowBlank: true,
                                                                                id: 'intCifrasDePieDiastolica_5'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'compositefield',
                                                                        style: 'background:transparent;',
                                                                        items: [
                                                                            {
                                                                                xtype: 'numberfield',
                                                                                name: 'T.A. (De Pie) Sistolica 6.',
                                                                                width: 70,
                                                                                minValue: 0,
                                                                                maxValue: 300,
                                                                                decimalPrecision: 0,
                                                                                allowBlank: true,
                                                                                id: 'intCifrasDePieSistolica_6'
                                                                            },
                                                                            {
                                                                                html: '/'
                                                                            },
                                                                            {
                                                                                xtype: 'numberfield',
                                                                                name: 'T.A. (De Pie) Diastolica 6.',
                                                                                width: 70,
                                                                                minValue: 0,
                                                                                maxValue: 300,
                                                                                decimalPrecision: 0,
                                                                                allowBlank: true,
                                                                                id: 'intCifrasDePieDiastolica_6'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'compositefield',
                                                                        style: 'background:transparent;',
                                                                        items: [
                                                                            {
                                                                                xtype: 'numberfield',
                                                                                name: 'T.A. (De Pie) Sistolica 7.',
                                                                                width: 70,
                                                                                minValue: 0,
                                                                                maxValue: 300,
                                                                                decimalPrecision: 0,
                                                                                allowBlank: true,
                                                                                id: 'intCifrasDePieSistolica_7'
                                                                            },
                                                                            {
                                                                                html: '/'
                                                                            },
                                                                            {
                                                                                xtype: 'numberfield',
                                                                                name: 'T.A. (De Pie) Diastolica 7.',
                                                                                width: 70,
                                                                                minValue: 0,
                                                                                maxValue: 300,
                                                                                decimalPrecision: 0,
                                                                                allowBlank: true,
                                                                                id: 'intCifrasDePieDiastolica_7'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'compositefield',
                                                                        style: 'background:transparent;',
                                                                        items: [
                                                                            {
                                                                                xtype: 'numberfield',
                                                                                name: 'T.A. (De Pie) Sistolica 8.',
                                                                                width: 70,
                                                                                minValue: 0,
                                                                                maxValue: 300,
                                                                                decimalPrecision: 0,
                                                                                allowBlank: true,
                                                                                id: 'intCifrasDePieSistolica_8'
                                                                            },
                                                                            {
                                                                                html: '/'
                                                                            },
                                                                            {
                                                                                xtype: 'numberfield',
                                                                                name: 'T.A. (De Pie) Diastolica 8.',
                                                                                width: 70,
                                                                                minValue: 0,
                                                                                maxValue: 300,
                                                                                decimalPrecision: 0,
                                                                                allowBlank: true,
                                                                                id: 'intCifrasDePieDiastolica_8'
                                                                            }
                                                                        ]
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                layout: 'form',
                                                                width: 210,
                                                                labelWidth: 1,
                                                                autoHeight: true,
                                                                labelSeparator: '',
                                                                labelStyle: 'color:blue;',
                                                                title: '<center>RESPONSABLE</center>',
                                                                items: [
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 200,
                                                                        allowBlank: true,
                                                                        name: "Responsable 1.",
                                                                        id: 'intCifrasResposanble_1'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 200,
                                                                        allowBlank: true,
                                                                        name: "Responsable 2.",
                                                                        id: 'intCifrasResposanble_2'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 200,
                                                                        allowBlank: true,
                                                                        name: "Responsable 3.",
                                                                        id: 'intCifrasResposanble_3'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 200,
                                                                        allowBlank: true,
                                                                        name: "Responsable 4.",
                                                                        id: 'intCifrasResposanble_4'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 200,
                                                                        allowBlank: true,
                                                                        name: "Responsable 5.",
                                                                        id: 'intCifrasResposanble_5'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 200,
                                                                        allowBlank: true,
                                                                        name: "Responsable 6.",
                                                                        id: 'intCifrasResposanble_6'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 200,
                                                                        allowBlank: true,
                                                                        name: "Responsable 7.",
                                                                        id: 'intCifrasResposanble_7'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 200,
                                                                        allowBlank: true,
                                                                        name: "Responsable 8.",
                                                                        id: 'intCifrasResposanble_8'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'textarea',
                                                fieldLabel: 'Observaciones',
                                                name: 'Observaciones',
                                                anchor: '100%',
                                                allowBlank: true,
                                                id: 'memObservaciones'
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'RIPS',
                                                layout: 'form',
                                                anchor: '100%',
                                                autoHeight: true,
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                id: 'fsRIPSAP',
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Principal',
                                                                id: 'sysDiagPpalProc',
                                                                value: 'Z013',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1Proc').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1Proc').getValue()){
                                                                                Ext.Ajax.request({
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagPpalProc').setValue(null);
                                                                                            Ext.getCmp('sysDiagPpalProcNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagPpalProc').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagPpalProcNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagPpalProc').setValue(null);
                                                                                        Ext.getCmp('sysDiagPpalProcNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagPpalProc').setValue(null);
                                                                                Ext.getCmp('sysDiagPpalProcNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 600,
                                                                height: 22,
                                                                id: 'sysDiagPpalProcNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Principal',
                                                                id: 'btnSearchDiagPpalProc',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagPpalProc','sysDiagPpalProcNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado',
                                                                id: 'sysDiagRel1Proc',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalProc').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2Proc').getValue()){
                                                                                Ext.Ajax.request({
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel1Proc').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel1ProcNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel1Proc').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagRel1ProcNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel1Proc').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel1ProcNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel1Proc').setValue(null);
                                                                                Ext.getCmp('sysDiagRel1ProcNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 600,
                                                                height: 22,
                                                                id: 'sysDiagRel1ProcNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado',
                                                                id: 'btnSearchDiagRel1Proc',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel1Proc','sysDiagRel1ProcNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Complicación',
                                                                id: 'sysDiagRel2Proc',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalProc').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1Proc').getValue()){
                                                                                Ext.Ajax.request({
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel2Proc').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel2ProcNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel2Proc').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagRel2ProcNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel2Proc').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel2ProcNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel2Proc').setValue(null);
                                                                                Ext.getCmp('sysDiagRel2ProcNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 600,
                                                                height: 22,
                                                                id: 'sysDiagRel2ProcNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Complicación',
                                                                id: 'btnSearchDiagRel1Proc',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel2Proc','sysDiagRel2ProcNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Ambito',
                                                        width:700,
                                                        name: 'Ambito',
                                                        allowBlank: false,
                                                        store: 'StoreAmbitoProcedimiento',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        value: 1,
                                                        id: 'sysAmbitoProc'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Finalidad Procedimiento',
                                                        width:700,
                                                        name: 'Finalidad Procedimiento',
                                                        allowBlank: false,
                                                        store: 'StoreFinalidadProcedimiento',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        value: 1,
                                                        id: 'sysFinalidadProcedimientoProc'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Personal Atiende',
                                                        width:700,
                                                        name: 'Personal Atiende',
                                                        allowBlank: false,
                                                        store: 'StorePersonalAtiendeProcedimiento',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        value: 4,
                                                        id: 'sysPersonalAtiendeProcedimientoProc'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Forma Realización Acto Quirúrgico',
                                                        width:700,
                                                        name: 'Forma Realización Acto Quirúrgico',
                                                        allowBlank: false,
                                                        store: 'StoreFormaRealizacionProcedimiento',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        value: 1,
                                                        id: 'sysFormaRealizaProcedimientoProc'
                                                    }
                                                ]
                                            }
                                        ]
                                    }
                                ]
                            }
                        ]
                    }
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Salir',
                            iconCls: 'btnSalir',
                            id: 'btnSalirEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 1) 
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.getCmp('winHC').close();
                                                }
                                            }
                                        });
                                    else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Usted No ha Guardado la Evolución del Paciente y Se Perdera la Información, Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.getCmp('winHC').close();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                },
                tbar:{
                    items: [
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Ver Historia Clínica',
                            iconCls: 'btnVerHC',
                            id: 'btnVerHC',
                            listeners:{
                                click : function(){
                                    var cmpResumenHC = new winFrmVerHistorialHC({
                                        renderTo: Ext.getBody()
                                    });
                                    Ext.getCmp('winViewEvolucionHC').title = "PACIENTE: " + Ext.getCmp('sysPacienteHC').getValue();
                                    Ext.getCmp('gridHistorialEvoluciones').store.load({
                                        params: {
                                            pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                                            pPaciente: Ext.getCmp('sysIdPacienteHC').getValue()
                                        }
                                    });
                                    cmpResumenHC.show();
                                }
                            }
                        },
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar Evolución',
                            iconCls: 'btnGuardar',
                            id: 'btnGuardarEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 0) 
                                    {
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Guardar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnGuardarRegistrosMedicinaGeneral();
                                                }
                                            }
                                        });
                                    }else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Modificar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnModificarRegistrosMedicinaGeneral();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                }
            }
        ];
        this.on({
            afterlayout:{
                scope:this, 
                single:true, 
                fn:function() {
                    Ext.Msg.hide();
                    //Ext.getCmp('fsRips').setVisible(false);
                    
                }
            }
        });      
        winHCAfinamiento001Ui.superclass.initComponent.call(this);
    }
});

function fnGuardarRegistrosMedicinaGeneral(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc.php',
            params:{
                task: 'guardar_proc',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pidPlantillaHC : Ext.getCmp('sysIdCodPlantillaHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalProc').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1Proc').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2Proc').getValue(),
                pAmbito: Ext.getCmp('sysAmbitoProc').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadProcedimientoProc').getValue(),
                pPersona: Ext.getCmp('sysPersonalAtiendeProcedimientoProc').getValue(),
                pForma: Ext.getCmp('sysFormaRealizaProcedimientoProc').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1); 
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function fnModificarRegistrosMedicinaGeneral(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc.php',
            params:{
                task: 'modificar_proc',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalProc').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1Proc').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2Proc').getValue(),
                pAmbito: Ext.getCmp('sysAmbitoProc').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadProcedimientoProc').getValue(),
                pPersona: Ext.getCmp('sysPersonalAtiendeProcedimientoProc').getValue(),
                pForma: Ext.getCmp('sysFormaRealizaProcedimientoProc').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1);
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}
