/*
* @category    Formulario Modelo Plantilla HC Programas Especiales (HTA - Diabetes Mellitus - Nefroproteccion)
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winHCProgramasEspeciales001Ui = Ext.extend(Ext.Window, {
    title: 'eOfiClinic ©  .:: Plantilla HC Programas Especiales (HTA - Diabetes Mellitus - Nefroproteccion) ::.',
    width: 990,
    height: 636,
    closable: false,
    resizable: false,
    draggable: false,
    modal: true,
    id: 'winHC',
    initComponent: function() {
        
        var fsDiagnosticosConsulta = new fsDiagnosticosConsultaUi();
        var fsRevisionxSistemas = new fsRevisionxSistemasUi();
        var fsAntecedentesPersonales = new fsAntecedentesPersonalesUi();
        var fsAntecedentesFamiliares = new fsAntecedentesFamiliaresUi();
        var pnProgramasEspeciales = new pnProgramasEspecialesUi();
        
        //NUEVO 2014
        //Consentimientos Informados
        var xConsentimientosInformados = new GridConsentimientosInformadosUi();
        //Consentimientos Informados
        var xEventosAdversos = new GridEventosAdversosUi();
        //KardexProgramas
        var xKardexProgramas = new GridKardexxPacUi();
        
        //Reporte Paraclinicos
        var stReporteParaclinicos = new StoreGridReporteParaclinicos();
        stReporteParaclinicos.load({
            params: {
                pPaciente: wPaciente
            }
        });
        //Alertas Medicas
        var xAlertasxPaciente = new AlertasxPaciente001Ui();
        Ext.getCmp('gridAlertasPacientes').store.baseParams = {
            task: 'LISTAR_ALERTAS',
            pPaciente: wPaciente,
            pIPS: ID_IPS
        };
        Ext.getCmp('gridAlertasPacientes').store.load({
            params: {
                pPaciente: wPaciente
            }
        });
        function renderClasificacionReporte(val, x, store){
            switch(val){
                case "A":
                    return '<span style="color:#F00">Anormal</span>';
                    break;
                case "N":
                    return '<span style="color:#090">Normal</span>';
                    break;
                default:
                    break;
            }
        }
        function renderValorReporte(value, metaData, record, rowIndex, colIndex, store){  
            metaData.attr = 'style="white-space:normal"';  
            if(record.get('ReporteVal') !== "" && record.get('ReporteVal') !== null){
                return value + "<br><hr>Valor: " + record.get('ReporteVal');  
            }else{
                return value;  
            }
        }
        function renderObservaReporte(value, metaData, record, rowIndex, colIndex, store){  
            metaData.attr = 'style="white-space:normal"';  
            return value;  
        }
        //
        tmpmx = objMX;
        tmpmxadd = objMXADD;
        tmpexa = objEXA;
        tmprem = objREM;
        myPaciente = 0;
        myCAS = 0;

        try {
            var campo = Ext.getCmp('sysPacientePlantillaHC');
            if ( campo != null ) {
                myPaciente = Ext.getCmp('sysPacientePlantillaHC').getValue();
            }
        }catch(ex){
        }
        if(myPaciente == 0){
            try {
                var campo1 = Ext.getCmp('sysIdPacienteHC');
                if ( campo1 != null ) {
                    myPaciente = Ext.getCmp('sysIdPacienteHC').getValue();
                }
            }catch(ex){
            }
        }
        if(myPaciente == 0){
            try {
                var campo5 = Ext.getCmp('sysPacienteRefHC');
                if ( campo5 != null ) {
                    myPaciente = Ext.getCmp('sysPacienteRefHC').getValue();
                }
            }catch(ex){
            }
        }
        try {
            var campo2 = Ext.getCmp('sysCASPlantillaHC');
            if ( campo2 != null ) {
                myCAS = Ext.getCmp('sysCASPlantillaHC').getValue();
            }
        }catch(ex){
        }
        if(myCAS == 0){
            try {
                var campo3 = Ext.getCmp('sysCASHC');
                if ( campo3 != null ) {
                    myCAS = Ext.getCmp('sysCASHC').getValue();
                }
            }catch(ex){
            }
        }
        if(myCAS == 0){
            try {
                var campo4 = Ext.getCmp('sysCASRefHC');
                if ( campo4 != null ) {
                    myCAS = Ext.getCmp('sysCASRefHC').getValue();
                }
            }catch(ex){
            }
        }
        if (objMX != "NA"){
            var xSolMX = eval(objMX);
            Ext.getCmp('gridMedicamentosHC').store.load({
                params: {
                    task: 'MX_IPS_BASICA',
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: wPaciente,
                    pCAS: wCAS
                }
            });
        }
        else{
            var xSolMX = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        if (objEXA != "NA"){
            var xSolEXA = eval(objEXA);
            Ext.getCmp('gridExamenesHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: wPaciente,
                    pCAS: wCAS
                }
            });
        }else{
            var xSolEXA = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        if (objREM != "NA"){
            var xSolREM = eval(objREM);
            Ext.getCmp('gridRemisionesHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: wPaciente,
                    pCAS: wCAS
                }
            });
        }else{
            var xSolREM = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        var xSolNOPOS = new SolNOPOS001Ui();
        Ext.getCmp('gridSolicitudesNOPOSxPaciente').store.load({
            params: {
                task: 'LISTAR_NOPOS',
                pPaciente: myPaciente
            }
        });
        //
        this.items = [
            {
                xtype: 'panel',
                frame: true,
                anchor: '100%',
                id: 'panelHC',
                border: false,
                height: 570,
                autoScroll: true,
                layout: 'form',
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                        value: 0,
                        id: 'sysYaOrdenamientosHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysIdCodPlantillaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        value: 1,
                        id: 'sysUsaGridSalida'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                        value: 0,
                        id: 'sysYaGuardoHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysPlantillaHC',
                        name: 'PLANTILLA'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptMx'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptExa'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptRem'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Actividad',
                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                        id: 'sysActividadHC',
                        name: 'PLANTILLA'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Empresa',
                        id: 'sysEmpresaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'IPS',
                        id: 'sysIPSHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Usuario',
                        id: 'sysUsuarioHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Profesional',
                        id: 'sysProfesionalHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Paciente',
                        id: 'sysIdPacienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Apertura',
                        id: 'sysAperturaHC'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Cliente',
                        id: 'sysClienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdClienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdPlanHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdSubPlanHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdContratoHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Genero',
                        id: 'sysGeneroPacHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Edad',
                        id: 'sysEdadPacHC'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Profesional',
                        id: 'sysProfesionalAgendaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'ConsecutivoDetalle',
                        id: 'sysConsecutivoDetalleHC'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'CAS',
                                id: 'sysCASHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysFechaHC',
                                value: 'Fecha: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysFechaHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysHoraHC',
                                value: 'Hora: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysHoraHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysLegalizacionHC',
                                value: 'Legalización: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysLegalizaHC'
                            }
                        ]
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Paciente',
                        value: 'CC 792558261  - JORGE GALEANO RUIZ - (Masculino) FechaNac: 1973-01-30, Edad 38 Años',
                        id: 'sysPacienteHC'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'textfield',
                                width: 100,
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'Genero',
                                id: 'sysGeneroHC'
                            },
                            {
                                html: 'Fecha Nac:'
                            },
                            {
                                xtype: 'textfield',
                                width: 100,
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysFechaNac'
                            },
                            {
                                html: 'Edad:'
                            },
                            {
                                xtype: 'textfield',
                                width: 350,
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysEdadHC'
                            }
                        ]
                    },
                    /*{
                        xtype: 'button',
                        iconCls: 'btnImprimir',
                        text: 'Cargar Antecedentes',
                        tooltip: 'Cargar Antecedentes',
                        listeners:{
                            click : function(){
                                Ext.Ajax.request({
                                    url: '../../controlador/asistencial/evolucionhc.php',
                                    waitMsg: 'Cargando Información...',
                                    params:{
                                        pCAS: myCAS,
                                        pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                                        task: 'ImportarAntecedentesPersonalesOfiClinic001'
                                    },
                                    success: function(result, request)
                                    {
                                        var jsonAntPersonales = Ext.util.JSON.decode(result.responseText);
                                        UtilCargarAntecedentesOfiClinic001(jsonAntPersonales.data);
                                    },
                                    scope:this
                                });
                            }
                        }
                    },*/
                    {
                        html: '<hr>',
                        style: 'background:transparent;',
                        border: false
                    },
                    {
                        xtype: 'tabpanel',
                        anchor: '99%',
                        autoHeight: true,
                        border: false,
                        enableTabScroll: true,
                        ref: 'fTabPanel',
                        id: 'fTabPanel',
                        activeTab: 0,
                        items: [
                            {
                                xtype: 'panel',
                                title: 'Evolución',
                                autoHeight: true,
                                autoScroll: true,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaEvolucion',
                                layout: 'form',
                                items: [
                                    {
                                        xtype: 'form',
                                        frame: true,
                                        anchor: '100%',
                                        id: 'frmHC',
                                        padding: 10,
                                        border: false,
                                        autoScroll: true,
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        fieldLabel: 'Acompañante',
                                                        name: 'Acompañante',
                                                        width: 350,
                                                        allowBlank: true,
                                                        id: 'strDATINGPROGAcompanante'
                                                    },
                                                    {
                                                        html: '   Parentesco:'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name: 'Parentezco',
                                                        width: 350,
                                                        allowBlank: true,
                                                        store: stParentesco,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strDATINGPROGParentesco'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'MOTIVO DE CONSULTA',
                                                layout: 'table',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'MOTIVO DE CONSULTA',
                                                        name: 'MOTIVO DE CONSULTA',
                                                        height: 100,
                                                        allowBlank: false,
                                                        id: 'memMotivoConsulta'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'ENFERMEDAD ACTUAL',
                                                layout: 'table',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'ENFERMEDAD ACTUAL',
                                                        name: 'ENFERMEDAD ACTUAL',
                                                        height: 100,
                                                        allowBlank: false,
                                                        id: 'memEnfermedadActual'
                                                    }
                                                ]
                                            },
                                            fsRevisionxSistemas,
                                            fsAntecedentesPersonales,
                                            fsAntecedentesFamiliares,
                                            {
                                                xtype: 'fieldset',
                                                title: 'EXAMEN FISICO',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                labelSeparator: '',
                                                autoHeight: true,
                                                padding: 0,
                                                items: [
                                                    {
                                                        xtype: 'toolbar',
                                                        anchor: '99%',
                                                        items: [
                                                            '->',
                                                            {
                                                                xtype: 'button',
                                                                text: 'Peso',
                                                                tooltip: 'Ver Seguimiento del Peso del Paciente',
                                                                iconCls: 'btnGraficar',
                                                                listeners: {
                                                                    click: function(){
                                                                        viewSeguimientoTomaSignos(Ext.getCmp('sysIdPacienteHC').getValue(), "VerHistoricoPesoxPac","Fecha");
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'tbseparator'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                text: 'T.A.',
                                                                tooltip: 'Ver Seguimiento de la Presion Arterial del Paciente',
                                                                iconCls: 'btnGraficar',
                                                                listeners: {
                                                                    click: function(){
                                                                        viewSeguimientoTomaSignos(Ext.getCmp('sysIdPacienteHC').getValue(), "VerHistoricoTAxPac","Fecha");
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'tbseparator'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                fieldLabel: 'T.A. (Sentado)',
                                                                name: 'T.A. (Sentado) Sistolica',
                                                                width: 70,
                                                                minValue: 0,
                                                                maxValue: 300,
                                                                decimalPrecision: 0,
                                                                allowBlank: false,
                                                                emptyText: 'Sistolica',
                                                                id: 'intEXAFISTASentadoSistolica'
                                                            },
                                                            {
                                                                html: '/'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                name: 'T.A. (Sentado) Diastolica',
                                                                width: 70,
                                                                minValue: 0,
                                                                maxValue: 300,
                                                                decimalPrecision: 0,
                                                                allowBlank: false,
                                                                emptyText: 'Diastolica',
                                                                id: 'intEXAFISTASentadoDiastolica'
                                                            },
                                                            {
                                                                html: 'Ultimo Control: - T.A. (Sentado):',
                                                                style: 'color: red;'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'T.A. (Sentado) Sistolica',
                                                                width: 70,
                                                                allowBlank: true,
                                                                readOnly: true,
                                                                style: 'color: red;',
                                                                id: 'sysEXAFISTASentadoSistolica'
                                                            },
                                                            {
                                                                html: '/'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'T.A. (Sentado) Diastolica',
                                                                width: 70,
                                                                allowBlank: true,
                                                                readOnly: true,
                                                                style: 'color: red;',
                                                                id: 'sysEXAFISTASentadoDiastolica'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                fieldLabel: 'T.A. (de Pie)',
                                                                name: 'T.A. (de Pie)',
                                                                width: 70,
                                                                minValue: 0,
                                                                maxValue: 300,
                                                                decimalPrecision: 0,
                                                                allowBlank: false,
                                                                emptyText: 'Sistolica',
                                                                id: 'intEXAFISTAdePieSistolica'
                                                            },
                                                            {
                                                                html: '/'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                name: 'T.A. (de Pie) Diastolica',
                                                                width: 70,
                                                                minValue: 0,
                                                                maxValue: 300,
                                                                decimalPrecision: 0,
                                                                allowBlank: false,
                                                                emptyText: 'Diastolica',
                                                                id: 'intEXAFISTAdePieDiastolica'
                                                            },
                                                            {
                                                                html: 'Ultimo Control: - T.A. (de Pie):',
                                                                style: 'color: red;'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'T.A. (de Pie) Sistolica',
                                                                width: 70,
                                                                allowBlank: true,
                                                                readOnly: true,
                                                                style: 'color: red;',
                                                                id: 'sysEXAFISTAdePieSistolica'
                                                            },
                                                            {
                                                                html: '/'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'T.A. (de Pie) Diastolica',
                                                                width: 70,
                                                                allowBlank: true,
                                                                readOnly: true,
                                                                style: 'color: red;',
                                                                id: 'sysEXAFISTAdePieDiastolica'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                decimalPrecision: 2,
                                                                allowBlank: false,
                                                                fieldLabel: 'TALLA (cm)',
                                                                name:"TALLA (cm)",
                                                                emptyText: '(cm)',
                                                                id: 'intEXAFISTalla',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        if(pNew == null || pNew == 0){
                                                                            Ext.getCmp('intEXAFISTalla').setValue(null);
                                                                            Ext.getCmp('intEXAFISIMC').setValue(0);
                                                                        }else{
                                                                            if(Ext.getCmp('intEXAFISPeso').getValue() > 0){
                                                                                var pTalla = Ext.getCmp('intEXAFISTalla').getValue() / 100;
                                                                                Ext.getCmp('intEXAFISIMC').setValue(Ext.getCmp('intEXAFISPeso').getValue()/(pTalla*pTalla));
                                                                            }else{
                                                                                Ext.getCmp('intEXAFISIMC').setValue(0);
                                                                            }
                                                                        }
                                                                       if(Ext.getCmp('intEXAFISIMC').getValue()<1){
                                                                           Ext.getCmp('strEXAFISIMCClasificacon').setValue(null);
                                                                        }else{
                                                                            if(Ext.getCmp('intEXAFISIMC').getValue() < 16.00){
                                                                               Ext.getCmp('strEXAFISIMCClasificacon').setValue("DELGADEZ SEVERA");
                                                                            }else{
                                                                                if(Ext.getCmp('intEXAFISIMC').getValue()<=16.90 && Ext.getCmp('intEXAFISIMC').getValue()>=16.00){
                                                                                   Ext.getCmp('strEXAFISIMCClasificacon').setValue("DELGADEZ MODERADA");
                                                                                }else{
                                                                                    if(Ext.getCmp('intEXAFISIMC').getValue()<=18.49 && Ext.getCmp('intEXAFISIMC').getValue()>=17.00){
                                                                                       Ext.getCmp('strEXAFISIMCClasificacon').setValue("DELGADEZ ACEPTABLE");
                                                                                    }else{
                                                                                        if(Ext.getCmp('intEXAFISIMC').getValue()<=24.99 && Ext.getCmp('intEXAFISIMC').getValue()>=18.50){
                                                                                           Ext.getCmp('strEXAFISIMCClasificacon').setValue("NORMAL");
                                                                                        }else{
                                                                                            if(Ext.getCmp('intEXAFISIMC').getValue()<=29.99 && Ext.getCmp('intEXAFISIMC').getValue()>=25.00){
                                                                                               Ext.getCmp('strEXAFISIMCClasificacon').setValue("PREOBESO");
                                                                                            }else{
                                                                                                if(Ext.getCmp('intEXAFISIMC').getValue()<=34.99 && Ext.getCmp('intEXAFISIMC').getValue()>=30.00){
                                                                                                   Ext.getCmp('strEXAFISIMCClasificacon').setValue("OBESO TIPO I");
                                                                                                }else{
                                                                                                    if(Ext.getCmp('intEXAFISIMC').getValue()<=39.99 && Ext.getCmp('intEXAFISIMC').getValue()>=35.00){
                                                                                                       Ext.getCmp('strEXAFISIMCClasificacon').setValue("OBESO TIPO II");
                                                                                                    }else{
                                                                                                        if(Ext.getCmp('intEXAFISIMC').getValue()>=40.00){
                                                                                                        Ext.getCmp('strEXAFISIMCClasificacon').setValue("OBESO TIPO III");
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysEXAFISPeso',
                                                                value: 'PESO (Kg) '
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                decimalPrecision: 2,
                                                                allowBlank: false,
                                                                emptyText: '(Kg)',
                                                                name:"PESO (Kg)",
                                                                id: 'intEXAFISPeso',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        if(pNew == null || pNew == 0){
                                                                            Ext.getCmp('intEXAFISPeso').setValue(null);
                                                                            Ext.getCmp('intEXAFISIMC').setValue(0);
                                                                        }else{
                                                                            //peso [kg]/ estatura [m2]
                                                                            if(Ext.getCmp('intEXAFISTalla').getValue() > 0){
                                                                                var pTalla = Ext.getCmp('intEXAFISTalla').getValue() / 100;
                                                                                Ext.getCmp('intEXAFISIMC').setValue(Ext.getCmp('intEXAFISPeso').getValue()/(pTalla*pTalla));
                                                                            }else{
                                                                                Ext.getCmp('intEXAFISIMC').setValue(0);
                                                                            }
                                                                        }
                                                                        if(Ext.getCmp('intEXAFISIMC').getValue()<1){
                                                                           Ext.getCmp('strEXAFISIMCClasificacon').setValue(null);
                                                                        }else{
                                                                            if(Ext.getCmp('intEXAFISIMC').getValue() < 16.00){
                                                                               Ext.getCmp('strEXAFISIMCClasificacon').setValue("DELGADEZ SEVERA");
                                                                            }else{
                                                                                if(Ext.getCmp('intEXAFISIMC').getValue()<=16.90 && Ext.getCmp('intEXAFISIMC').getValue()>=16.00){
                                                                                   Ext.getCmp('strEXAFISIMCClasificacon').setValue("DELGADEZ MODERADA");
                                                                                }else{
                                                                                    if(Ext.getCmp('intEXAFISIMC').getValue()<=18.49 && Ext.getCmp('intEXAFISIMC').getValue()>=17.00){
                                                                                       Ext.getCmp('strEXAFISIMCClasificacon').setValue("DELGADEZ ACEPTABLE");
                                                                                    }else{
                                                                                        if(Ext.getCmp('intEXAFISIMC').getValue()<=24.99 && Ext.getCmp('intEXAFISIMC').getValue()>=18.50){
                                                                                           Ext.getCmp('strEXAFISIMCClasificacon').setValue("NORMAL");
                                                                                        }else{
                                                                                            if(Ext.getCmp('intEXAFISIMC').getValue()<=29.99 && Ext.getCmp('intEXAFISIMC').getValue()>=25.00){
                                                                                               Ext.getCmp('strEXAFISIMCClasificacon').setValue("PREOBESO");
                                                                                            }else{
                                                                                                if(Ext.getCmp('intEXAFISIMC').getValue()<=34.99 && Ext.getCmp('intEXAFISIMC').getValue()>=30.00){
                                                                                                   Ext.getCmp('strEXAFISIMCClasificacon').setValue("OBESO TIPO I");
                                                                                                }else{
                                                                                                    if(Ext.getCmp('intEXAFISIMC').getValue()<=39.99 && Ext.getCmp('intEXAFISIMC').getValue()>=35.00){
                                                                                                       Ext.getCmp('strEXAFISIMCClasificacon').setValue("OBESO TIPO II");
                                                                                                    }else{
                                                                                                        if(Ext.getCmp('intEXAFISIMC').getValue()>=40.00){
                                                                                                        Ext.getCmp('strEXAFISIMCClasificacon').setValue("OBESO TIPO III");
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html: 'Ultimo:',
                                                                style: 'color: red;'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Peso Anterior',
                                                                width: 70,
                                                                allowBlank: true,
                                                                readOnly: true,
                                                                style: 'color: red;',
                                                                id: 'sysEXAFISPesoAnt'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysEXAFISIMC',
                                                                value: 'IMC '
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                minValue: 0,
                                                                decimalPrecision: 2,
                                                                allowBlank: false,
                                                                readOnly: true,
                                                                name: "IMC",
                                                                id: 'intEXAFISIMC'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                allowBlank: false,
                                                                readOnly: true,
                                                                name: "IMC - CLASIFICACION",
                                                                id: 'strEXAFISIMCClasificacon'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysEXAFISPA',
                                                                value: 'P. Abd.'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                minValue: 0,
                                                                decimalPrecision: 2,
                                                                name: 'Perimetro Abdominal',
                                                                allowBlank: true,
                                                                id: 'strEXAFISPA'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                fieldLabel: 'Temp',
                                                                width: 60,
                                                                minValue: 0,
                                                                decimalPrecision: 2,
                                                                name: 'Temperatura',
                                                                allowBlank: false,
                                                                id: 'intEXAFISTemp'
                                                            },
                                                            {
                                                                html: 'F.C.'
                                                            },                                                            
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                minValue: 0,
                                                                decimalPrecision: 2,
                                                                name: 'FC',
                                                                allowBlank: false,
                                                                id: 'intEXAFISFC'
                                                            },
                                                            {
                                                                html: 'F.R.'
                                                            },                                                            
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                minValue: 0,
                                                                decimalPrecision: 2,
                                                                name: 'FR',
                                                                allowBlank: false,
                                                                id: 'intEXAFISFR'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Condiciones Generales',
                                                        name: 'Condiciones Generales',
                                                        allowBlank: false,
                                                        value: "No Evaluado",
                                                        id: 'strEXAFISCondicionesGenerales',
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strEXAFISCondicionesGenerales').setValue("Normal");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Piel y Anexos<br>&nbsp;',
                                                        name: 'Piel y Anexos',
                                                        allowBlank: false,
                                                        value: "No Evaluado",
                                                        id: 'strEXAFISPielyAnexos',
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strEXAFISPielyAnexos').setValue("Normal");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Cabeza<br>&nbsp;',
                                                        name: 'Cabeza',
                                                        allowBlank: false,
                                                        value: "No Evaluado",
                                                        id: 'strEXAFISCabeza',
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strEXAFISCabeza').setValue("Normal");
                                                                });
                                                            }
                                                        }

                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Ojos<br>&nbsp;',
                                                        name: 'Ojos',
                                                        allowBlank: false,
                                                        id: 'strEXAFISOjos',
                                                        value: "No Evaluado",
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strEXAFISOjos').setValue("Normal");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'ORL<br>&nbsp;',
                                                        name: 'ORL',
                                                        allowBlank: false,
                                                        value: "No Evaluado",
                                                        id: 'strEXAFISORL',
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strEXAFISORL').setValue("Normal");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Orofaringe<br>&nbsp;',
                                                        name: 'Orofaringe',
                                                        allowBlank: false,
                                                        value: "No Evaluado",
                                                        id: 'strEXAFISOrofaringe',
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strEXAFISOrofaringe').setValue("Normal");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Cuello<br>&nbsp;',
                                                        name: 'Cuello',
                                                        allowBlank: false,
                                                        value: "No Evaluado",
                                                        id: 'strEXAFISCuello',
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strEXAFISCuello').setValue("Normal");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'fieldset',
                                                        title: 'Valoracion Mamaria',
                                                        layout: 'form',
                                                        collapsible: true,
                                                        titleCollapse: true,
                                                        anchor: '100%',
                                                        autoHeight: true,
                                                        padding: 7,
                                                        id: 'fsEXAMFISValMamaria',
                                                        items:[
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                fieldLabel: 'Aspecto',
                                                                name: 'Aspecto',
                                                                allowBlank: true,
                                                                id: 'strEXAFISMamaAspecto',
                                                                listeners: {
                                                                    render: function( p ) {
                                                                        p.getEl().on('dblclick', function (){
                                                                            Ext.getCmp('strEXAFISMamaAspecto').setValue("No Evaluado");
                                                                        });
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                fieldLabel: 'Ganglios',
                                                                name: 'Ganglios',
                                                                allowBlank: true,
                                                                id: 'strEXAFISMamaGanglios',
                                                                listeners: {
                                                                    render: function( p ) {
                                                                        p.getEl().on('dblclick', function (){
                                                                            Ext.getCmp('strEXAFISMamaGanglios').setValue("No Evaluado");
                                                                        });
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                fieldLabel: 'Malestar',
                                                                name: 'Malestar',
                                                                allowBlank: true,
                                                                id: 'strEXAFISMamaMalestar',
                                                                listeners: {
                                                                    render: function( p ) {
                                                                        p.getEl().on('dblclick', function (){
                                                                            Ext.getCmp('strEXAFISMamaMalestar').setValue("No Evaluado");
                                                                        });
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                fieldLabel: 'Dolores',
                                                                name: 'Dolores',
                                                                allowBlank: true,
                                                                id: 'strEXAFISMamaDolor',
                                                                listeners: {
                                                                    render: function( p ) {
                                                                        p.getEl().on('dblclick', function (){
                                                                            Ext.getCmp('strEXAFISMamaDolor').setValue("No Evaluado");
                                                                        });
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                fieldLabel: 'Descargas',
                                                                name: 'Descargas',
                                                                allowBlank: true,
                                                                id: 'strEXAFISMamaDescargas',
                                                                listeners: {
                                                                    render: function( p ) {
                                                                        p.getEl().on('dblclick', function (){
                                                                            Ext.getCmp('strEXAFISMamaDescargas').setValue("No Evaluado");
                                                                        });
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                fieldLabel: 'Masas o Bultos',
                                                                name: 'Masas o Bultos',
                                                                allowBlank: true,
                                                                id: 'strEXAFISMamaMasas',
                                                                listeners: {
                                                                    render: function( p ) {
                                                                        p.getEl().on('dblclick', function (){
                                                                            Ext.getCmp('strEXAFISMamaMasas').setValue("No Evaluado");
                                                                        });
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Dorso<br>&nbsp;',
                                                        name: 'Dorso',
                                                        allowBlank: false,
                                                        id: 'strEXAFISDorso',
                                                        value: "No Evaluado",
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strEXAFISDorso').setValue("Normal");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Cardiaco<br>&nbsp;',
                                                        name: 'Cardiaco',
                                                        allowBlank: false,
                                                        id: 'strEXAFISCardiaco',
                                                        value: "No Evaluado",
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strEXAFISCardiaco').setValue("Normal");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Pulmonar<br>&nbsp;',
                                                        name: 'Pulmonar',
                                                        allowBlank: false,
                                                        id: 'strEXAFISPulmonar',
                                                        value: "No Evaluado",
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strEXAFISPulmonar').setValue("Normal");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Abdomen<br>&nbsp;',
                                                        name: 'Abdomen',
                                                        allowBlank: false,
                                                        id: 'strEXAFISAbdomen',
                                                        value: "No Evaluado",
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strEXAFISAbdomen').setValue("Normal");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Genitales<br>&nbsp;',
                                                        name: 'Genitales',
                                                        allowBlank: false,
                                                        id: 'strEXAFISGenitales',
                                                        value: "No Evaluado",
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strEXAFISGenitales').setValue("Normal");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Extremidades<br>&nbsp;',
                                                        name: 'Extremidades',
                                                        allowBlank: false,
                                                        id: 'strEXAFISExtremidades',
                                                        value: "No Evaluado",
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strEXAFISExtremidades').setValue("Normal");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Neurologico<br>&nbsp;',
                                                        name: 'Neurologico',
                                                        allowBlank: false,
                                                        id: 'strEXAFISNeurologico',
                                                        value: "No Evaluado",
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strEXAFISNeurologico').setValue("Normal");
                                                                });
                                                            }
                                                        }
                                                    }
                                                ]
                                            },
                                            pnProgramasEspeciales,
                                            {
                                                xtype: 'fieldset',
                                                title: 'COMPLICACIONES ASOCIADAS',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                labelSeparator: '',
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 0,
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Complicacion Cardiovascular',
                                                                fieldLabel: 'Cardiovascular<br>&nbsp;',
                                                                width: 400,
                                                                allowBlank: true,
                                                                id: 'strComplicacionCardiovascular'
                                                            },
                                                            {
                                                                html: 'Mes'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Mes Complicacion Cardiovascular',
                                                                width: 100,
                                                                allowBlank: true,
                                                                id: 'strComplicacionCardiovascularMes'
                                                            },
                                                            {
                                                                html: 'Año'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Año Complicacion Cardiovascular',
                                                                width: 100,
                                                                allowBlank: true,
                                                                id: 'strComplicacionCardiovascularAño'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Complicacion Cerebrovascular',
                                                                fieldLabel: 'Cerebrovascular<br>&nbsp;',
                                                                width: 400,
                                                                allowBlank: true,
                                                                id: 'strComplicacionCerebrovascular'
                                                            },
                                                            {
                                                                html: 'Mes'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Mes Complicacion Cerebrovascular',
                                                                width: 100,
                                                                allowBlank: true,
                                                                id: 'strComplicacionCerebrovascularMes'
                                                            },
                                                            {
                                                                html: 'Año'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Año Complicacion Cerebrovascular',
                                                                width: 100,
                                                                allowBlank: true,
                                                                id: 'strComplicacionCerebrovascularAño'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Complicacion Pie Diabetico',
                                                                fieldLabel: 'Pie Diabetico<br>&nbsp;',
                                                                width: 400,
                                                                allowBlank: true,
                                                                id: 'strComplicacionPieDiabetico'
                                                            },
                                                            {
                                                                html: 'Mes'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Mes Complicacion Pie Diabetico',
                                                                width: 100,
                                                                allowBlank: true,
                                                                id: 'strComplicacionPieDiabeticoMes'
                                                            },
                                                            {
                                                                html: 'Año'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Año Complicacion Pie Diabetico',
                                                                width: 100,
                                                                allowBlank: true,
                                                                id: 'strComplicacionPieDiabeticoAño'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Complicacion Retinopatia',
                                                                fieldLabel: 'Retinopatia<br>&nbsp;',
                                                                width: 400,
                                                                allowBlank: true,
                                                                id: 'strComplicacionRetinopatia'
                                                            },
                                                            {
                                                                html: 'Mes'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Mes Complicacion Retinopatia',
                                                                width: 100,
                                                                allowBlank: true,
                                                                id: 'strComplicacionRetinopatiaMes'
                                                            },
                                                            {
                                                                html: 'Año'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Año Complicacion Retinopatia',
                                                                width: 100,
                                                                allowBlank: true,
                                                                id: 'strComplicacionRetinopatiaAño'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Hospitalizacion Piso',
                                                                fieldLabel: 'Hospitalizacion Piso',
                                                                width: 400,
                                                                allowBlank: true,
                                                                id: 'strHospitalizacionPiso'
                                                            },
                                                            {
                                                                html: 'Mes'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Mes Hospitalizacion Piso',
                                                                width: 100,
                                                                allowBlank: true,
                                                                id: 'strHospitalizacionPisoMes'
                                                            },
                                                            {
                                                                html: 'Año'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Año Hospitalizacion Piso',
                                                                width: 100,
                                                                allowBlank: true,
                                                                id: 'strHospitalizacionPisoAño'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Hospitalizacion UCI',
                                                                fieldLabel: 'Hospitalizacion UCI',
                                                                width: 400,
                                                                allowBlank: true,
                                                                id: 'strHospitalizacionUCI'
                                                            },
                                                            {
                                                                html: 'Mes'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Mes Hospitalizacion UCI',
                                                                width: 100,
                                                                allowBlank: true,
                                                                id: 'strHospitalizacionUCIMes'
                                                            },
                                                            {
                                                                html: 'Año'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Año Hospitalizacion UCI',
                                                                width: 100,
                                                                allowBlank: true,
                                                                id: 'strHospitalizacionUCIAño'
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'EVOLUCION',
                                                layout: 'table',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'EVOLUCION',
                                                        name: 'EVOLUCION',
                                                        height: 100,
                                                        allowBlank: false,
                                                        id: 'memEvolucion'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'FORMULACION POST-FECHA',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Realizar Formulacion para',
                                                        name: 'Realizar Formulacion para',
                                                        width: 250,
                                                        allowBlank: true,
                                                        store: stMesesFormulacion,
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: 1,
                                                        id: 'sysFormulacion'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'INFORMACION PROXIMA CITA',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 5,
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'datefield',
                                                                width: 120,
                                                                fieldLabel: 'Fecha Probable Proxima Cita',
                                                                name: 'Fecha Probable Proxima Cita',
                                                                allowBlank: true,
                                                                emptyText: '(dia/mes/año) ',
                                                                style: 'text-align:center;',
                                                                id: 'fecPROXCITACita'
                                                            },
                                                            {
                                                                html: 'Profesional que Atiende'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Profesional que Atiende',
                                                                width: 250,
                                                                allowBlank: true,
                                                                store: stProfesionalAtiende,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strPROXCITAProfesionalAtiende'
                                                            },
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'Observacion',
                                                        name: 'Observacion',
                                                        height: 100,
                                                        allowBlank: true,
                                                        id: 'memPROXCITAObservacion'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'CONDUCTA',
                                                layout: 'table',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'CONDUCTA',
                                                        name: 'CONDUCTA',
                                                        height: 100,
                                                        allowBlank: false,
                                                        id: 'memConducta'
                                                    }
                                                ]
                                            },
                                            fsDiagnosticosConsulta
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Reporte de Paraclinicos y/o Examenes',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaParaclinicos',
                                layout: 'form',
                                items: [
                                     {
                                        xtype: 'grid',
                                        title: ' ',
                                        id: 'gridReporteParaclinicos',
                                        store: stReporteParaclinicos,
                                        anchor: "100%",
                                        height: 320,
                                        border: false,
                                        frame: true,
                                        loadMask: true,
                                        colModel: new Ext.ux.grid.LockingColumnModel([
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Id',
                                                sortable: false,
                                                width: 1,
                                                hidden: true,
                                                hideable: false,
                                                dataIndex: 'IdConsecutivoReporte'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Descripcion',
                                                sortable: false,
                                                width: 300,
                                                dataIndex: 'DescProced'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Fecha Solicitud',
                                                sortable: false,
                                                width: 90,
                                                dataIndex: 'FechaSolicitud'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Fecha Realiza',
                                                sortable: false,
                                                width: 120,
                                                dataIndex: 'FechaRealizacion'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Reporte',
                                                sortable: false,
                                                width: 150,
                                                renderer: renderValorReporte,
                                                dataIndex: 'ReporteTxt'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Observaciones',
                                                sortable: false,
                                                width: 150,
                                                renderer: renderObservaReporte,
                                                dataIndex: 'Observaciones'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Clasificacion',
                                                sortable: false,
                                                width: 80,
                                                renderer: renderClasificacionReporte,
                                                dataIndex: 'Clasificacion'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Solicitante',
                                                sortable: false,
                                                width: 150,
                                                dataIndex: 'Solicitante'
                                            }
                                        ]),
                                        selModel: new Ext.grid.RowSelectionModel({singleSelect:false}),
                                        viewConfig: {
                                            getRowClass: function(record, index) {
                                                if (record.get('Estado') === 'S')
                                                    return 'Negado';
                                                else
                                                    return;
                                            }
                                        },
                                        iconCls:'icon-grid',
                                        tbar:
                                            {
                                                xtype: 'toolbar',
                                                items: [
                                                    {
                                                        xtype: 'button',
                                                        text: 'Adicionar',
                                                        iconCls: 'btnAddRow',
                                                        listeners: {
                                                            click : function() {
                                                                var winReporteParaclinicos = new winReporteParaclinicos001Ui();
                                                                Ext.getCmp('intPacienteReporteParaclin').setValue(wPaciente);
                                                                Ext.getCmp('intCASReporteParaclin').setValue(wCAS);
                                                                Ext.getCmp('intUsuarioReporteParaclin').setValue(ID_USUARIO);
                                                                Ext.getCmp('intIdConsecutivoReporteParaclin').setValue(0);
                                                                winReporteParaclinicos.show();
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'tbseparator'
                                                    },
                                                    {
                                                        xtype: 'button',
                                                        text: 'Reportar',
                                                        iconCls: 'btnEditRow',
                                                        listeners: {
                                                            click : function() {
                                                                if(Ext.getCmp('gridReporteParaclinicos').selModel.getCount() === 1){
                                                                    var selections = Ext.getCmp('gridReporteParaclinicos').selModel.getSelections();
                                                                    if(parseInt(selections[0].json.CASReporte) === parseInt(wCAS)){
                                                                        var winReporteParaclinicos = new winReporteParaclinicos001Ui();
                                                                        Ext.getCmp('intPacienteReporteParaclin').setValue(wPaciente);
                                                                        Ext.getCmp('intCASReporteParaclin').setValue(wCAS);
                                                                        Ext.getCmp('intUsuarioReporteParaclin').setValue(ID_USUARIO);
                                                                        Ext.getCmp('intIdConsecutivoReporteParaclin').setValue(selections[0].json.IdConsecutivoReporte);
                                                                        Ext.getCmp('intConceptoOfiMedicalReporteParaclin').setValue(selections[0].json.IdProced);
                                                                        Ext.getCmp('strNomConceptoOfiMedicalReporteParaclin').setValue(selections[0].json.DescProced);
                                                                        Ext.getCmp('strNomQuienSolicitaReporteParaclin').setValue(selections[0].json.Solicitante);
                                                                        Ext.getCmp('fecFecSolicitudReporteParaclin').setValue(selections[0].json.FechaSolicitud);
                                                                        Ext.getCmp('fecFecRealizacionReporteParaclin').setValue(selections[0].json.FechaRealizacion);
                                                                        Ext.getCmp('strResultadoReporteParaclin').setValue(selections[0].json.ReporteTxt);
                                                                        Ext.getCmp('intValorReporteParaclin').setValue(selections[0].json.ReporteVal);
                                                                        Ext.getCmp('strClasificacionReporteParaclin').setValue(selections[0].json.Clasificacion);
                                                                        Ext.getCmp('strObservacionesReporteParaclin').setValue(selections[0].json.Observaciones);
                                                                        Ext.getCmp('sysSearchReporteParaclin').setVisible(false);
                                                                        winReporteParaclinicos.show();
                                                                    }else{
                                                                        if(selections[0].json.Estado === "S"){
                                                                            var winReporteParaclinicos = new winReporteParaclinicos001Ui();
                                                                            Ext.getCmp('intPacienteReporteParaclin').setValue(wPaciente);
                                                                            Ext.getCmp('intCASReporteParaclin').setValue(wCAS);
                                                                            Ext.getCmp('intUsuarioReporteParaclin').setValue(ID_USUARIO);
                                                                            Ext.getCmp('intIdConsecutivoReporteParaclin').setValue(selections[0].json.IdConsecutivoReporte);
                                                                            Ext.getCmp('intConceptoOfiMedicalReporteParaclin').setValue(selections[0].json.IdProced);
                                                                            Ext.getCmp('strNomConceptoOfiMedicalReporteParaclin').setValue(selections[0].json.DescProced);
                                                                            Ext.getCmp('strNomQuienSolicitaReporteParaclin').setValue(selections[0].json.Solicitante);
                                                                            //Ext.getCmp('strNomQuienSolicitaReporteParaclin').setReadOnly(true);
                                                                            Ext.getCmp('fecFecSolicitudReporteParaclin').setValue(selections[0].json.FechaSolicitud);
                                                                            Ext.getCmp('fecFecRealizacionReporteParaclin').setValue(selections[0].json.FechaRealizacion);
                                                                            Ext.getCmp('sysSearchReporteParaclin').setVisible(false);
                                                                            winReporteParaclinicos.show();
                                                                        }else{
                                                                            Ext.MessageBox.show({
                                                                                title: 'Error',
                                                                                msg: 'El registro no esta disponible para ser reportado',
                                                                                buttons: Ext.MessageBox.OK,
                                                                                icon: Ext.MessageBox.ERROR
                                                                            });
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'tbseparator'
                                                    },
                                                    {
                                                        xtype: 'button',
                                                        text: 'Eliminar',
                                                        iconCls: 'btnDelRow',
                                                        listeners: {
                                                            click : function() {
                                                                if(Ext.getCmp('gridReporteParaclinicos').selModel.getCount() === 1){
                                                                    var selections = Ext.getCmp('gridReporteParaclinicos').selModel.getSelections();
                                                                    if((selections[0].json.CAS === null || selections[0].json.CAS === "") && selections[0].json.Estado === "S" && parseInt(selections[0].json.Usuario) === parseInt(Ext.getCmp('sysUsuarioHC').getValue())){
                                                                        Ext.Msg.show({
                                                                            title: 'Reporte Paraclinicos',
                                                                            msg: 'Esta Seguro que Desea Eliminar el Registro ' + selections[0].json.DescProced + '?',
                                                                            buttons: Ext.Msg.YESNO,
                                                                            icon: Ext.Msg.QUESTION,
                                                                            fn: function(btn){
                                                                                if(btn ==="yes"){
                                                                                    fnEliminarRegistrosReporteParaclinicos001("../../controlador/asistencial/evolucionhc2013.php",{task: "ELIMINAR_REPORTEEXA", pIdReporte: selections[0].json.IdConsecutivoReporte}, 'gridReporteParaclinicos');
                                                                                }
                                                                            }
                                                                        });
                                                                    }else{
                                                                        Ext.MessageBox.show({
                                                                            title: 'Error',
                                                                            msg: 'No podemos eliminar los registro en estos momentos',
                                                                            buttons: Ext.MessageBox.OK,
                                                                            icon: Ext.MessageBox.ERROR
                                                                        });
                                                                    }
                                                                }else{
                                                                    Ext.MessageBox.show({
                                                                        title: 'Error',
                                                                        msg: 'No podemos eliminar los registros en estos momentos, verifique que solo haya seleccionado un registro',
                                                                        buttons: Ext.MessageBox.OK,
                                                                        icon: Ext.MessageBox.ERROR
                                                                    });
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'tbseparator'
                                                    },
                                                    '->',
                                                    new Ext.app.SearchField({
                                                        id: 'qryReporteParaclin',
                                                        store: stReporteParaclinicos,
                                                        ValparamP1: wPaciente,
                                                        emptyText: 'Escriba el criterio que desea buscar',
                                                        width: 120,
                                                        pLoadGrid: false,
                                                        pGrid: 'gridReporteParaclinicos',
                                                        parrParam: {params:{pPaciente: wPaciente}}
                                                    })
                                                ]
                                            }
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Medicamentos',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaMedicamentos',
                                items: [
                                    xSolMX
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Servicios',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaServicios',
                                items: [
                                    xSolEXA
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Remisiones',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaRemisiones',
                                items: [
                                    xSolREM
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud NO POS',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaNOPOS',
                                items: [
                                    xSolNOPOS
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Registro de Alertas',
                                height: 380,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaAlertas',
                                items: [
                                    xAlertasxPaciente
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Consentimientos Informados',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaConsentimientos',
                                layout: 'form',
                                items: [
                                    xConsentimientosInformados
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Notificacion Eventos Adversos',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaEventosAdversos',
                                layout: 'form',
                                items: [
                                    xEventosAdversos
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Kardex PyP - Programas Especiales',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaKardex',
                                layout: 'form',
                                items: [
                                    xKardexProgramas
                                ]
                            }
                        ]
                    }
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Salir',
                            iconCls: 'btnSalir',
                            id: 'btnSalirEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 1)
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.getCmp('winHC').close();
                                                }
                                            }
                                        });
                                    else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Usted No ha Guardado la Evolución del Paciente y Se Perdera la Información, Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.getCmp('winHC').close();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                },
                tbar:{
                    items: [
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Ver Historia Clínica',
                            iconCls: 'btnVerHC',
                            id: 'btnVerHC',
                            listeners:{
                                click : function(){
                                    var cmpResumenHC = new winFrmVerHistorialHC({
                                        renderTo: Ext.getBody()
                                    });
                                    Ext.getCmp('winViewEvolucionHC').title = "PACIENTE: " + Ext.getCmp('sysPacienteHC').getValue();
                                    Ext.getCmp('gridHistorialEvoluciones').store.load({
                                        params: {
                                            pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                                            pPaciente: Ext.getCmp('sysIdPacienteHC').getValue()
                                        }
                                    });
                                    cmpResumenHC.show();
                                }
                            }
                        },
                        
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar Evolución',
                            iconCls: 'btnGuardar',
                            id: 'btnGuardarEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 0)
                                    {
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Guardar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnGuardarRegistrosMedicinaGeneral();
                                                }
                                            }
                                        });
                                    }else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Modificar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnModificarRegistrosMedicinaGeneral();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                }
            }
        ];
        this.on({
            afterlayout:{
                scope:this, 
                single:true, 
                fn:function() {
                    Ext.Msg.hide();
                    //Deshabilitar botones solicitud de examenes
                    Ext.getCmp('btnImportarUltimaExamen').disable();
                    Ext.getCmp('btnAddExaEvolucion').disable();
                    Ext.getCmp('btnDelExaEvolucion').disable();
                    ////////////////////////////////////////////
                    if(paramOpcion === "Nuevo"){ 
                        var frm = Ext.getCmp('frmHC').getForm();
                        frm.doAction('load', {
                            url: '../../controlador/asistencial/evolucionhc2014.php',
                            waitMsg: 'Cargando Información...',
                            params:{
                                pCAS: myCAS,
                                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                                task: 'ImportarAntecedentesPersonalesOfiClinic002'
                            },
                            failure: function(response,options){
                                importarcronicos('frmHC', myCAS, Ext.getCmp('sysIdPacienteHC').getValue(),"CRONICOS");
                            },
                            success:function(form, action) {
                                importarcronicos('frmHC', myCAS, Ext.getCmp('sysIdPacienteHC').getValue(),"CRONICOS");
                            }
                        });
                    }
                }
            }
        });
        winHCProgramasEspeciales001Ui.superclass.initComponent.call(this);
    }
});

function fnGuardarRegistrosMedicinaGeneral(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc2014.php',
            params:{
                task: 'guardar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pidPlantillaHC : Ext.getCmp('sysIdCodPlantillaHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue(),
                pFormulacion: Ext.getCmp('sysFormulacion').getValue(),
                
                //4505 IDENTIFICACION RIESGO
                pOcupacion4505: Ext.getCmp('strOcupacionHC').getValue(),
                pEtnia4505: Ext.getCmp('intEtniaHC').getValue(),
                pEscolaridad4505: Ext.getCmp('intEscolaridadHC').getValue(),
                pGestacion4505: Ext.getCmp('intIdentificacionRiesgoGestacion').getValue(),
                pSifilisGestacional4505: Ext.getCmp('intIdentificacionRiesgoSifilisGestacional').getValue(),
                pHipertencionGestacional4505: Ext.getCmp('intIdentificacionRiesgoHipertencionGestacional').getValue(),
                pHipotiroidismoCongenito4505: Ext.getCmp('intIdentificacionRiesgoHipotiroidismoCongenito').getValue(),
                pTuberculosisMultidrogoresistente4505: Ext.getCmp('intIdentificacionRiesgoTuberculosisMultidrogoresistente').getValue(),
                pLepra4505: Ext.getCmp('intIdentificacionRiesgoLepra').getValue(),
                pVictimaMaltrato4505: Ext.getCmp('intIdentificacionRiesgoVictimaMaltrato').getValue(),
                pViolenciaSexual4505: Ext.getCmp('intIdentificacionRiesgoViolenciaSexual').getValue(),
                pFluorosisDental4505: Ext.getCmp('intIdentificacionRiesgoFluorosisDental').getValue(),
                pEnfermedadMental4505: Ext.getCmp('intIdentificacionRiesgoEnfermedadMental').getValue(),
                pTransmisionSexual4505: Ext.getCmp('intIdentificacionRiesgoInfeccionesTransmisionSexual').getValue(),
                pSintomaticoRespiratorio4505: Ext.getCmp('intIdentificacionRiesgoSintomaticoRespiratorio').getValue(),
                
                //SIGNOS VITALES
                pGuardarSignos: "SI",
                pTASIS: Ext.getCmp('intEXAFISTASentadoSistolica').getValue(),
                pTADIAS: Ext.getCmp('intEXAFISTASentadoDiastolica').getValue(),
                pTensionArterialSistolicaPie: Ext.getCmp('intEXAFISTAdePieSistolica').getValue(),
                pTensionArterialDiastolicaPie: Ext.getCmp('intEXAFISTAdePieDiastolica').getValue(),
                pTalla: Ext.getCmp('intEXAFISTalla').getValue(),
                pPeso: Ext.getCmp('intEXAFISPeso').getValue(),
                pIMC: Ext.getCmp('intEXAFISIMC').getValue(),
                pIMCClasifica: Ext.getCmp('strEXAFISIMCClasificacon').getValue(),
                pPerimetroAbdominal: Ext.getCmp('strEXAFISPA').getValue(),
                pTE: Ext.getCmp('intEXAFISTemp').getValue(),
                pFC: Ext.getCmp('intEXAFISFC').getValue(),
                pFR: Ext.getCmp('intEXAFISFR').getValue(),
                
                //ANTECEDENTES
                pPatologicos: Ext.getCmp('memANTPERSOPatologicos').getValue(),
                pFarmacologicos: Ext.getCmp('memANTPERSOFarmacologicos').getValue(),
                pQuirurgicos: Ext.getCmp('memANTPERSOQuirurgicos').getValue(),
                pTraumatologicos: Ext.getCmp('memANTPERSOTraumatologicos').getValue(),
                pToxicologicos: Ext.getCmp('memANTPERSOToxicologicos').getValue(),
                pAlergicos: Ext.getCmp('memANTPERSOAlergicos').getValue(),
                pHTA: Ext.getCmp('bolANTPERSOHTA').getValue(),
                pDiabetes: Ext.getCmp('bolANTPERSODiabetes').getValue(),
                pNefropatias: Ext.getCmp('bolANTPERSONefropatias').getValue(),
                pInfertilidad: Ext.getCmp('bolANTPERSOInfertilidad').getValue(),
                pVIH: Ext.getCmp('bolANTPERSOVIH').getValue(),
                pCardiopatias: Ext.getCmp('bolANTPERSOCardiopatias').getValue(),
                pGest: Ext.getCmp('intANTGINECOG').getValue(),
                pPartos: Ext.getCmp('intANTGINECOP').getValue(),
                pPVaginales: Ext.getCmp('intANTGINECOPV').getValue(),
                pAbortos: Ext.getCmp('intANTGINECOA').getValue(),
                pVivos: Ext.getCmp('intANTGINECOVivos').getValue(),
                pMuertos: Ext.getCmp('intANTGINECOMuertos').getValue(),
                pMola: Ext.getCmp('bolANTGINECOMola').getValue(),
                pEmbEctopico: Ext.getCmp('bolANTGINECOEmbEctopico').getValue(),
                pPreclampsia: Ext.getCmp('bolANTPERSOPreclampsia').getValue(),
                pEclampsia: Ext.getCmp('bolANTPERSOEclampsia').getValue(),
                pLactanciaHoy: Ext.getCmp('strANTGINECOLactanciaHoy').getValue(),
                pLactanciaPasado: Ext.getCmp('strANTGINECOLactanciaPasado').getValue(),
                pTiempoLactancia: Ext.getCmp('strANTGONECOTiempoLactancia').getValue(),
                pMenarquia: Ext.getCmp('strANTGINECOMenarquia').getValue(),
                pFum: Ext.getCmp('fecANTGINECOFum').getValue(),
                pFup: Ext.getCmp('fecANTGINECOFup').getValue(),
                pfecfuc: Ext.getCmp('fecANTGINECOFuc').getValue(),
                pFucRes: Ext.getCmp('strANTGINECOFucRes').getValue(),
                pMetodoPlanifica: Ext.getCmp('strANTGINECOMetodoPlanifica').getValue(),
                pCiclosMeuales: Ext.getCmp('strANTGINECOCiclosMestruales').getValue(),
                pActividadSexual: Ext.getCmp('strANTGINECOActividadSexual').getValue(),
                pPatologiaEmbarazo: Ext.getCmp('strANTGINECOPatologiaEmbarazo').getValue(),
                pMenopausia: Ext.getCmp('strANTGINECOMenopausia').getValue(),
                pAntFamiliares: Ext.getCmp('memAntecedentesFamiliares').getValue(),
                pGuardarAntecedentes: "SI",
                
                //PROGRAMA CRONICOS
                pProgramasEspecialesFechaIngreso : Ext.getCmp('fecPROGESPEIngreso').getValue(),
                pProgramasEspecialesViaCaptacion : Ext.getCmp('strPROGESPEViaCaptacion').getValue(),
                pProgramasEspecialesHTA : Ext.getCmp('strPROGESPEDxHTA').getValue(),
                pProgramasEspecialesHTATipoDx : Ext.getCmp('strPROGESPETipoDxHTA').getValue(),
                pProgramasEspecialesHTARiesgo : Ext.getCmp('strPROGESPENivelRiesgoHTA').getValue(),
                pProgramasEspecialesHTAMesDx : Ext.getCmp('intPROGESPEDxHTAMes').getValue(),
                pProgramasEspecialesHTAAnioDx : Ext.getCmp('intPROGESPEDxHTAAno').getValue(),
                pProgramasEspecialesHTAEstadio : Ext.getCmp('strPROGESPEDxHTAEstadio').getValue(),
                pProgramasEspecialesDM : Ext.getCmp('strPROGESPEDxDM').getValue(),
                pProgramasEspecialesDMTipoDx : Ext.getCmp('strPROGESPETipoDxDM').getValue(),
                pProgramasEspecialesDMRiesgo : Ext.getCmp('strPROGESPENivelRiesgoDM').getValue(),
                pProgramasEspecialesDMMesDx : Ext.getCmp('intPROGESPEDxDMMes').getValue(),
                pProgramasEspecialesDMAnioDx : Ext.getCmp('intPROGESPEDxDMAno').getValue(),
                pProgramasEspecialesTipoDM : Ext.getCmp('strPROGESPETipoDM').getValue(),
                pProgramasEspecialesNefro : Ext.getCmp('strPROGESPEDxNefroProteccion').getValue(),
                pProgramasEspecialesNefroTipoDx : Ext.getCmp('strPROGESPETipoDxNefroProteccion').getValue(),
                pProgramasEspecialesNefroRiesgo : Ext.getCmp('strPROGESPENivelRiesgoNefroProteccion').getValue(),
                pProgramasEspecialesNefroMesDx : Ext.getCmp('intPROGESPEDxNefroProteccionMes').getValue(),
                pProgramasEspecialesNefroAniosDx : Ext.getCmp('intPROGESPEDxNefroProteccionAno').getValue(),
                pProgramasEspecialesNefroEstadio : Ext.getCmp('strPROGESPEEstadioNefroProteccion').getValue(),
                pProgramasEspecialesMetasCifras : Ext.getCmp('bolPROESPMetasCifras').getValue(),
                pProgramasEspecialesMetasGlicemia : Ext.getCmp('bolPROESPMetasGlicemia').getValue(),
                pProgramasEspecialesMetasHbA1 : Ext.getCmp('bolPROESPMetasHbA1').getValue(),
                pProgramasEspecialesMetasTrigliceridos : Ext.getCmp('bolPROESPMetasTrigliceridos').getValue(),
                pProgramasEspecialesMetasLDL : Ext.getCmp('bolPROESPMetasLDL').getValue(),
                pProgramasEspecialesMetasHDL : Ext.getCmp('bolPROESPMetasHDL').getValue(),
                pProgramasEspecialesMetasMicroalbuminuria : Ext.getCmp('bolPROESPMetasMicroalbuminuria').getValue(),
                pProgramasEspecialesMetasIMC : Ext.getCmp('bolPROESPMetasIMC').getValue(),
                pProgramasEspecialesMetasPerimetroCintura : Ext.getCmp('bolPROESPMetasPerimetroCintura').getValue(),
                pProgramasEspecialesMetasManejoEstres : Ext.getCmp('bolPROESPMetasManejoEstres').getValue(),
                pProgramasEspecialesMetasCumplidas : Ext.getCmp('intPROGESPENumCumplimientoMetas').getValue(),
                pProgramasEspecialesIngresoUroanalisisFec : Ext.getCmp('fecPROGESPEParcialorina').getValue(),
                pProgramasEspecialesIngresoUroanalisisRes : Ext.getCmp('strPROGESPEParcialorinaRes').getValue(),
                pProgramasEspecialesIngresoColesterolTotalFec : Ext.getCmp('fecPROGESPEColesterolTotal').getValue(),
                pProgramasEspecialesIngresoColesterolTotalRes : Ext.getCmp('strPROGESPEColesterolTotalRes').getValue(),
                pProgramasEspecialesIngresoHDLFec : Ext.getCmp('fecPROGESPEColesterolHDL').getValue(),
                pProgramasEspecialesIngresoHDLRes : Ext.getCmp('strPROGESPEColesterolHDLRes').getValue(),
                pProgramasEspecialesIngresoLDLFec : Ext.getCmp('fecPROGESPEColesterolLDL').getValue(),
                pProgramasEspecialesIngresoLDLRes : Ext.getCmp('strPROGESPEColesterolLDLRes').getValue(),
                pProgramasEspecialesIngresoTrigliceridosFec : Ext.getCmp('fecPROGESPETrigliceridos').getValue(),
                pProgramasEspecialesIngresoTrigliceridosRes : Ext.getCmp('strPROGESPETrigliceridosRes').getValue(),
                pProgramasEspecialesIngresoHemoGlicosiladaFec : Ext.getCmp('fecPROGESPEHemoglobinaGlicosilada').getValue(),
                pProgramasEspecialesIngresoHemoGlicosiladaRes : Ext.getCmp('strPROGESPEHemoglobinaGlicosiladaRes').getValue(),
                pProgramasEspecialesIngresoGlicemiaFec : Ext.getCmp('fecPROGESPEGlicemia').getValue(),
                pProgramasEspecialesIngresoGlicemiaRes : Ext.getCmp('strPROGESPEGlicemiaRes').getValue(),
                pProgramasEspecialesIngresoMicroalbuminuriaFec : Ext.getCmp('fecPROGESPEMicroAlbuminuria').getValue(),
                pProgramasEspecialesIngresoMicroalbuminuriaRes : Ext.getCmp('strPROGESPEMicroAlbuminuriaRes').getValue(),
                pProgramasEspecialesIngresoCreatininaFec : Ext.getCmp('fecPROGESPECreatinina').getValue(),
                pProgramasEspecialesIngresoCreatininaRes : Ext.getCmp('strPROGESPECreatininaRes').getValue(),
                pProgramasEspecialesIngresoTFG : Ext.getCmp('intPROGESPETFGIngreso').getValue(),
                pProgramasEspecialesIngresoTFGEstadio : Ext.getCmp('strPROGESPETFGIngresoCalsifica').getValue(),
                pProgramasEspecialesSeguimientoUroanalisisFec : Ext.getCmp('fecPROGESPESeguimientoParcialorina').getValue(),
                pProgramasEspecialesSeguimientoUroanalisisRes : Ext.getCmp('strPROGESPESeguimientoParcialorinaRes').getValue(),
                pProgramasEspecialesSeguimientoColesterolTotalFec : Ext.getCmp('fecPROGESPESeguimientoColesterolTotal').getValue(),
                pProgramasEspecialesSeguimientoColesterolTotalRes : Ext.getCmp('strPROGESPESeguimientoColesterolTotalRes').getValue(),
                pProgramasEspecialesSeguimientoHDLFec : Ext.getCmp('fecPROGESPESeguimientoColesterolHDL').getValue(),
                pProgramasEspecialesSeguimientoHDLRes : Ext.getCmp('strPROGESPESeguimientoColesterolHDLRes').getValue(),
                pProgramasEspecialesSeguimientoLDLFec : Ext.getCmp('fecPROGESPESeguimientoColesterolLDL').getValue(),
                pProgramasEspecialesSeguimientoLDLRes : Ext.getCmp('strPROGESPESeguimientoColesterolLDLRes').getValue(),
                pProgramasEspecialesSeguimientoTrigliceridosFec : Ext.getCmp('fecPROGESPESeguimientoTrigliceridos').getValue(),
                pProgramasEspecialesSeguimientoTrigliceridosRes : Ext.getCmp('strPROGESPESeguimientoTrigliceridosRes').getValue(),
                pProgramasEspecialesSeguimientoHemoGlicosiladaFec : Ext.getCmp('fecPROGESPESeguimientoHemoglobinaGlicosilada').getValue(),
                pProgramasEspecialesSeguimientoHemoGlicosiladaRes : Ext.getCmp('strPROGESPESeguimientoHemoglobinaGlicosiladaRes').getValue(),
                pProgramasEspecialesSeguimientoGlicemiaFec : Ext.getCmp('fecPROGESPESeguimientoGlicemia').getValue(),
                pProgramasEspecialesSeguimientoGlicemiaRes : Ext.getCmp('strPROGESPESeguimientoGlicemiaRes').getValue(),
                pProgramasEspecialesSeguimientoMicroalbuminuriaFec : Ext.getCmp('fecPROGESPESeguimientoMicroAlbuminuria').getValue(),
                pProgramasEspecialesSeguimientoMicroalbuminuriaRes : Ext.getCmp('strPROGESPESeguimientoMicroAlbuminuriaRes').getValue(),
                pProgramasEspecialesSeguimientoCreatininaFec : Ext.getCmp('fecPROGESPESeguimientoCreatinina').getValue(),
                pProgramasEspecialesSeguimientoCreatininaRes : Ext.getCmp('strPROGESPESeguimientoCreatininaRes').getValue(),
                pProgramasEspecialesSeguimientoTFG : Ext.getCmp('strPROGESPETFGSeguimiento').getValue(),
                pProgramasEspecialesSeguimientoTFGEstadio : Ext.getCmp('strPROGESPETFGSeguimientoCalsifica').getValue(),
                pProgramasEspecialesComplicacionesCardiovascular : Ext.getCmp('strComplicacionCardiovascular').getValue(),
                pProgramasEspecialesComplicacionesCardiovascularMes : Ext.getCmp('strComplicacionCardiovascularMes').getValue(),
                pProgramasEspecialesComplicacionesCardiovascularAnio : Ext.getCmp('strComplicacionCardiovascularAño').getValue(),
                pProgramasEspecialesComplicacionesCerebrovascular : Ext.getCmp('strComplicacionCerebrovascular').getValue(),
                pProgramasEspecialesComplicacionesCerebrovascularMes : Ext.getCmp('strComplicacionCerebrovascularMes').getValue(),
                pProgramasEspecialesComplicacionesCerebrovascularAnio : Ext.getCmp('strComplicacionCerebrovascularAño').getValue(),
                pProgramasEspecialesComplicacionesPieDiabetico : Ext.getCmp('strComplicacionPieDiabetico').getValue(),
                pProgramasEspecialesComplicacionesPieDiabeticoMes : Ext.getCmp('strComplicacionPieDiabeticoMes').getValue(),
                pProgramasEspecialesComplicacionesPieDiabeticoAnio : Ext.getCmp('strComplicacionPieDiabeticoAño').getValue(),
                pProgramasEspecialesComplicacionesRetinopatia : Ext.getCmp('strComplicacionRetinopatia').getValue(),
                pProgramasEspecialesComplicacionesRetinopatiaMes : Ext.getCmp('strComplicacionRetinopatiaMes').getValue(),
                pProgramasEspecialesComplicacionesRetinopatiaAnio : Ext.getCmp('strComplicacionRetinopatiaAño').getValue(),
                pProgramasEspecialesComplicacionesHospPiso : Ext.getCmp('strHospitalizacionPiso').getValue(),
                pProgramasEspecialesComplicacionesHospPisoMes : Ext.getCmp('strHospitalizacionPisoMes').getValue(),
                pProgramasEspecialesComplicacionesHospPisoAnio : Ext.getCmp('strHospitalizacionPisoAño').getValue(),
                pProgramasEspecialesComplicacionesHospUCI : Ext.getCmp('strHospitalizacionUCI').getValue(),
                pProgramasEspecialesComplicacionesHospUCIMes : Ext.getCmp('strHospitalizacionUCIMes').getValue(),
                pProgramasEspecialesComplicacionesHospUCIAnio : Ext.getCmp('strHospitalizacionUCIAño').getValue(),
                pGuardarCronicos: "SI"
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1);
                        if(parseInt(Ext.getCmp('sysYaOrdenamientosHC').getValue()) === 0){
                            solicitarOrdenamientosProgramaCronicos();
                        }
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function fnModificarRegistrosMedicinaGeneral(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc2014.php',
            params:{
                task: 'modificar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pidPlantillaHC : Ext.getCmp('sysIdCodPlantillaHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue(),
                pFormulacion: Ext.getCmp('sysFormulacion').getValue(),
                
                //4505 IDENTIFICACION RIESGO
                pOcupacion4505: Ext.getCmp('strOcupacionHC').getValue(),
                pEtnia4505: Ext.getCmp('intEtniaHC').getValue(),
                pEscolaridad4505: Ext.getCmp('intEscolaridadHC').getValue(),
                pGestacion4505: Ext.getCmp('intIdentificacionRiesgoGestacion').getValue(),
                pSifilisGestacional4505: Ext.getCmp('intIdentificacionRiesgoSifilisGestacional').getValue(),
                pHipertencionGestacional4505: Ext.getCmp('intIdentificacionRiesgoHipertencionGestacional').getValue(),
                pHipotiroidismoCongenito4505: Ext.getCmp('intIdentificacionRiesgoHipotiroidismoCongenito').getValue(),
                pTuberculosisMultidrogoresistente4505: Ext.getCmp('intIdentificacionRiesgoTuberculosisMultidrogoresistente').getValue(),
                pLepra4505: Ext.getCmp('intIdentificacionRiesgoLepra').getValue(),
                pVictimaMaltrato4505: Ext.getCmp('intIdentificacionRiesgoVictimaMaltrato').getValue(),
                pViolenciaSexual4505: Ext.getCmp('intIdentificacionRiesgoViolenciaSexual').getValue(),
                pFluorosisDental4505: Ext.getCmp('intIdentificacionRiesgoFluorosisDental').getValue(),
                pEnfermedadMental4505: Ext.getCmp('intIdentificacionRiesgoEnfermedadMental').getValue(),
                pTransmisionSexual4505: Ext.getCmp('intIdentificacionRiesgoInfeccionesTransmisionSexual').getValue(),
                pSintomaticoRespiratorio4505: Ext.getCmp('intIdentificacionRiesgoSintomaticoRespiratorio').getValue(),
                
                //SIGNOS VITALES
                pGuardarSignos: "SI",
                pTASIS: Ext.getCmp('intEXAFISTASentadoSistolica').getValue(),
                pTADIAS: Ext.getCmp('intEXAFISTASentadoDiastolica').getValue(),
                pTensionArterialSistolicaPie: Ext.getCmp('intEXAFISTAdePieSistolica').getValue(),
                pTensionArterialDiastolicaPie: Ext.getCmp('intEXAFISTAdePieDiastolica').getValue(),
                pTalla: Ext.getCmp('intEXAFISTalla').getValue(),
                pPeso: Ext.getCmp('intEXAFISPeso').getValue(),
                pIMC: Ext.getCmp('intEXAFISIMC').getValue(),
                pIMCClasifica: Ext.getCmp('strEXAFISIMCClasificacon').getValue(),
                pPerimetroAbdominal: Ext.getCmp('strEXAFISPA').getValue(),
                pTE: Ext.getCmp('intEXAFISTemp').getValue(),
                pFC: Ext.getCmp('intEXAFISFC').getValue(),
                pFR: Ext.getCmp('intEXAFISFR').getValue(),
                
                //ANTECEDENTES
                pPatologicos: Ext.getCmp('memANTPERSOPatologicos').getValue(),
                pFarmacologicos: Ext.getCmp('memANTPERSOFarmacologicos').getValue(),
                pQuirurgicos: Ext.getCmp('memANTPERSOQuirurgicos').getValue(),
                pTraumatologicos: Ext.getCmp('memANTPERSOTraumatologicos').getValue(),
                pToxicologicos: Ext.getCmp('memANTPERSOToxicologicos').getValue(),
                pAlergicos: Ext.getCmp('memANTPERSOAlergicos').getValue(),
                pHTA: Ext.getCmp('bolANTPERSOHTA').getValue(),
                pDiabetes: Ext.getCmp('bolANTPERSODiabetes').getValue(),
                pNefropatias: Ext.getCmp('bolANTPERSONefropatias').getValue(),
                pInfertilidad: Ext.getCmp('bolANTPERSOInfertilidad').getValue(),
                pVIH: Ext.getCmp('bolANTPERSOVIH').getValue(),
                pCardiopatias: Ext.getCmp('bolANTPERSOCardiopatias').getValue(),
                pGest: Ext.getCmp('intANTGINECOG').getValue(),
                pPartos: Ext.getCmp('intANTGINECOP').getValue(),
                pPVaginales: Ext.getCmp('intANTGINECOPV').getValue(),
                pAbortos: Ext.getCmp('intANTGINECOA').getValue(),
                pVivos: Ext.getCmp('intANTGINECOVivos').getValue(),
                pMuertos: Ext.getCmp('intANTGINECOMuertos').getValue(),
                pMola: Ext.getCmp('bolANTGINECOMola').getValue(),
                pEmbEctopico: Ext.getCmp('bolANTGINECOEmbEctopico').getValue(),
                pPreclampsia: Ext.getCmp('bolANTPERSOPreclampsia').getValue(),
                pEclampsia: Ext.getCmp('bolANTPERSOEclampsia').getValue(),
                pLactanciaHoy: Ext.getCmp('strANTGINECOLactanciaHoy').getValue(),
                pLactanciaPasado: Ext.getCmp('strANTGINECOLactanciaPasado').getValue(),
                pTiempoLactancia: Ext.getCmp('strANTGONECOTiempoLactancia').getValue(),
                pMenarquia: Ext.getCmp('strANTGINECOMenarquia').getValue(),
                pFum: Ext.getCmp('fecANTGINECOFum').getValue(),
                pFup: Ext.getCmp('fecANTGINECOFup').getValue(),
                pfecfuc: Ext.getCmp('fecANTGINECOFuc').getValue(),
                pFucRes: Ext.getCmp('strANTGINECOFucRes').getValue(),
                pMetodoPlanifica: Ext.getCmp('strANTGINECOMetodoPlanifica').getValue(),
                pCiclosMeuales: Ext.getCmp('strANTGINECOCiclosMestruales').getValue(),
                pActividadSexual: Ext.getCmp('strANTGINECOActividadSexual').getValue(),
                pPatologiaEmbarazo: Ext.getCmp('strANTGINECOPatologiaEmbarazo').getValue(),
                pMenopausia: Ext.getCmp('strANTGINECOMenopausia').getValue(),
                pAntFamiliares: Ext.getCmp('memAntecedentesFamiliares').getValue(),
                pGuardarAntecedentes: "SI",
                
                //PROGRAMA CRONICOS
                pProgramasEspecialesFechaIngreso : Ext.getCmp('fecPROGESPEIngreso').getValue(),
                pProgramasEspecialesViaCaptacion : Ext.getCmp('strPROGESPEViaCaptacion').getValue(),
                pProgramasEspecialesHTA : Ext.getCmp('strPROGESPEDxHTA').getValue(),
                pProgramasEspecialesHTATipoDx : Ext.getCmp('strPROGESPETipoDxHTA').getValue(),
                pProgramasEspecialesHTARiesgo : Ext.getCmp('strPROGESPENivelRiesgoHTA').getValue(),
                pProgramasEspecialesHTAMesDx : Ext.getCmp('intPROGESPEDxHTAMes').getValue(),
                pProgramasEspecialesHTAAnioDx : Ext.getCmp('intPROGESPEDxHTAAno').getValue(),
                pProgramasEspecialesHTAEstadio : Ext.getCmp('strPROGESPEDxHTAEstadio').getValue(),
                pProgramasEspecialesDM : Ext.getCmp('strPROGESPEDxDM').getValue(),
                pProgramasEspecialesDMTipoDx : Ext.getCmp('strPROGESPETipoDxDM').getValue(),
                pProgramasEspecialesDMRiesgo : Ext.getCmp('strPROGESPENivelRiesgoDM').getValue(),
                pProgramasEspecialesDMMesDx : Ext.getCmp('intPROGESPEDxDMMes').getValue(),
                pProgramasEspecialesDMAnioDx : Ext.getCmp('intPROGESPEDxDMAno').getValue(),
                pProgramasEspecialesTipoDM : Ext.getCmp('strPROGESPETipoDM').getValue(),
                pProgramasEspecialesNefro : Ext.getCmp('strPROGESPEDxNefroProteccion').getValue(),
                pProgramasEspecialesNefroTipoDx : Ext.getCmp('strPROGESPETipoDxNefroProteccion').getValue(),
                pProgramasEspecialesNefroRiesgo : Ext.getCmp('strPROGESPENivelRiesgoNefroProteccion').getValue(),
                pProgramasEspecialesNefroMesDx : Ext.getCmp('intPROGESPEDxNefroProteccionMes').getValue(),
                pProgramasEspecialesNefroAniosDx : Ext.getCmp('intPROGESPEDxNefroProteccionAno').getValue(),
                pProgramasEspecialesNefroEstadio : Ext.getCmp('strPROGESPEEstadioNefroProteccion').getValue(),
                pProgramasEspecialesMetasCifras : Ext.getCmp('bolPROESPMetasCifras').getValue(),
                pProgramasEspecialesMetasGlicemia : Ext.getCmp('bolPROESPMetasGlicemia').getValue(),
                pProgramasEspecialesMetasHbA1 : Ext.getCmp('bolPROESPMetasHbA1').getValue(),
                pProgramasEspecialesMetasTrigliceridos : Ext.getCmp('bolPROESPMetasTrigliceridos').getValue(),
                pProgramasEspecialesMetasLDL : Ext.getCmp('bolPROESPMetasLDL').getValue(),
                pProgramasEspecialesMetasHDL : Ext.getCmp('bolPROESPMetasHDL').getValue(),
                pProgramasEspecialesMetasMicroalbuminuria : Ext.getCmp('bolPROESPMetasMicroalbuminuria').getValue(),
                pProgramasEspecialesMetasIMC : Ext.getCmp('bolPROESPMetasIMC').getValue(),
                pProgramasEspecialesMetasPerimetroCintura : Ext.getCmp('bolPROESPMetasPerimetroCintura').getValue(),
                pProgramasEspecialesMetasManejoEstres : Ext.getCmp('bolPROESPMetasManejoEstres').getValue(),
                pProgramasEspecialesMetasCumplidas : Ext.getCmp('intPROGESPENumCumplimientoMetas').getValue(),
                pProgramasEspecialesIngresoUroanalisisFec : Ext.getCmp('fecPROGESPEParcialorina').getValue(),
                pProgramasEspecialesIngresoUroanalisisRes : Ext.getCmp('strPROGESPEParcialorinaRes').getValue(),
                pProgramasEspecialesIngresoColesterolTotalFec : Ext.getCmp('fecPROGESPEColesterolTotal').getValue(),
                pProgramasEspecialesIngresoColesterolTotalRes : Ext.getCmp('strPROGESPEColesterolTotalRes').getValue(),
                pProgramasEspecialesIngresoHDLFec : Ext.getCmp('fecPROGESPEColesterolHDL').getValue(),
                pProgramasEspecialesIngresoHDLRes : Ext.getCmp('strPROGESPEColesterolHDLRes').getValue(),
                pProgramasEspecialesIngresoLDLFec : Ext.getCmp('fecPROGESPEColesterolLDL').getValue(),
                pProgramasEspecialesIngresoLDLRes : Ext.getCmp('strPROGESPEColesterolLDLRes').getValue(),
                pProgramasEspecialesIngresoTrigliceridosFec : Ext.getCmp('fecPROGESPETrigliceridos').getValue(),
                pProgramasEspecialesIngresoTrigliceridosRes : Ext.getCmp('strPROGESPETrigliceridosRes').getValue(),
                pProgramasEspecialesIngresoHemoGlicosiladaFec : Ext.getCmp('fecPROGESPEHemoglobinaGlicosilada').getValue(),
                pProgramasEspecialesIngresoHemoGlicosiladaRes : Ext.getCmp('strPROGESPEHemoglobinaGlicosiladaRes').getValue(),
                pProgramasEspecialesIngresoGlicemiaFec : Ext.getCmp('fecPROGESPEGlicemia').getValue(),
                pProgramasEspecialesIngresoGlicemiaRes : Ext.getCmp('strPROGESPEGlicemiaRes').getValue(),
                pProgramasEspecialesIngresoMicroalbuminuriaFec : Ext.getCmp('fecPROGESPEMicroAlbuminuria').getValue(),
                pProgramasEspecialesIngresoMicroalbuminuriaRes : Ext.getCmp('strPROGESPEMicroAlbuminuriaRes').getValue(),
                pProgramasEspecialesIngresoCreatininaFec : Ext.getCmp('fecPROGESPECreatinina').getValue(),
                pProgramasEspecialesIngresoCreatininaRes : Ext.getCmp('strPROGESPECreatininaRes').getValue(),
                pProgramasEspecialesIngresoTFG : Ext.getCmp('intPROGESPETFGIngreso').getValue(),
                pProgramasEspecialesIngresoTFGEstadio : Ext.getCmp('strPROGESPETFGIngresoCalsifica').getValue(),
                pProgramasEspecialesSeguimientoUroanalisisFec : Ext.getCmp('fecPROGESPESeguimientoParcialorina').getValue(),
                pProgramasEspecialesSeguimientoUroanalisisRes : Ext.getCmp('strPROGESPESeguimientoParcialorinaRes').getValue(),
                pProgramasEspecialesSeguimientoColesterolTotalFec : Ext.getCmp('fecPROGESPESeguimientoColesterolTotal').getValue(),
                pProgramasEspecialesSeguimientoColesterolTotalRes : Ext.getCmp('strPROGESPESeguimientoColesterolTotalRes').getValue(),
                pProgramasEspecialesSeguimientoHDLFec : Ext.getCmp('fecPROGESPESeguimientoColesterolHDL').getValue(),
                pProgramasEspecialesSeguimientoHDLRes : Ext.getCmp('strPROGESPESeguimientoColesterolHDLRes').getValue(),
                pProgramasEspecialesSeguimientoLDLFec : Ext.getCmp('fecPROGESPESeguimientoColesterolLDL').getValue(),
                pProgramasEspecialesSeguimientoLDLRes : Ext.getCmp('strPROGESPESeguimientoColesterolLDLRes').getValue(),
                pProgramasEspecialesSeguimientoTrigliceridosFec : Ext.getCmp('fecPROGESPESeguimientoTrigliceridos').getValue(),
                pProgramasEspecialesSeguimientoTrigliceridosRes : Ext.getCmp('strPROGESPESeguimientoTrigliceridosRes').getValue(),
                pProgramasEspecialesSeguimientoHemoGlicosiladaFec : Ext.getCmp('fecPROGESPESeguimientoHemoglobinaGlicosilada').getValue(),
                pProgramasEspecialesSeguimientoHemoGlicosiladaRes : Ext.getCmp('strPROGESPESeguimientoHemoglobinaGlicosiladaRes').getValue(),
                pProgramasEspecialesSeguimientoGlicemiaFec : Ext.getCmp('fecPROGESPESeguimientoGlicemia').getValue(),
                pProgramasEspecialesSeguimientoGlicemiaRes : Ext.getCmp('strPROGESPESeguimientoGlicemiaRes').getValue(),
                pProgramasEspecialesSeguimientoMicroalbuminuriaFec : Ext.getCmp('fecPROGESPESeguimientoMicroAlbuminuria').getValue(),
                pProgramasEspecialesSeguimientoMicroalbuminuriaRes : Ext.getCmp('strPROGESPESeguimientoMicroAlbuminuriaRes').getValue(),
                pProgramasEspecialesSeguimientoCreatininaFec : Ext.getCmp('fecPROGESPESeguimientoCreatinina').getValue(),
                pProgramasEspecialesSeguimientoCreatininaRes : Ext.getCmp('strPROGESPESeguimientoCreatininaRes').getValue(),
                pProgramasEspecialesSeguimientoTFG : Ext.getCmp('strPROGESPETFGSeguimiento').getValue(),
                pProgramasEspecialesSeguimientoTFGEstadio : Ext.getCmp('strPROGESPETFGSeguimientoCalsifica').getValue(),
                pProgramasEspecialesComplicacionesCardiovascular : Ext.getCmp('strComplicacionCardiovascular').getValue(),
                pProgramasEspecialesComplicacionesCardiovascularMes : Ext.getCmp('strComplicacionCardiovascularMes').getValue(),
                pProgramasEspecialesComplicacionesCardiovascularAnio : Ext.getCmp('strComplicacionCardiovascularAño').getValue(),
                pProgramasEspecialesComplicacionesCerebrovascular : Ext.getCmp('strComplicacionCerebrovascular').getValue(),
                pProgramasEspecialesComplicacionesCerebrovascularMes : Ext.getCmp('strComplicacionCerebrovascularMes').getValue(),
                pProgramasEspecialesComplicacionesCerebrovascularAnio : Ext.getCmp('strComplicacionCerebrovascularAño').getValue(),
                pProgramasEspecialesComplicacionesPieDiabetico : Ext.getCmp('strComplicacionPieDiabetico').getValue(),
                pProgramasEspecialesComplicacionesPieDiabeticoMes : Ext.getCmp('strComplicacionPieDiabeticoMes').getValue(),
                pProgramasEspecialesComplicacionesPieDiabeticoAnio : Ext.getCmp('strComplicacionPieDiabeticoAño').getValue(),
                pProgramasEspecialesComplicacionesRetinopatia : Ext.getCmp('strComplicacionRetinopatia').getValue(),
                pProgramasEspecialesComplicacionesRetinopatiaMes : Ext.getCmp('strComplicacionRetinopatiaMes').getValue(),
                pProgramasEspecialesComplicacionesRetinopatiaAnio : Ext.getCmp('strComplicacionRetinopatiaAño').getValue(),
                pProgramasEspecialesComplicacionesHospPiso : Ext.getCmp('strHospitalizacionPiso').getValue(),
                pProgramasEspecialesComplicacionesHospPisoMes : Ext.getCmp('strHospitalizacionPisoMes').getValue(),
                pProgramasEspecialesComplicacionesHospPisoAnio : Ext.getCmp('strHospitalizacionPisoAño').getValue(),
                pProgramasEspecialesComplicacionesHospUCI : Ext.getCmp('strHospitalizacionUCI').getValue(),
                pProgramasEspecialesComplicacionesHospUCIMes : Ext.getCmp('strHospitalizacionUCIMes').getValue(),
                pProgramasEspecialesComplicacionesHospUCIAnio : Ext.getCmp('strHospitalizacionUCIAño').getValue(),
                pGuardarCronicos: "SI"
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1);
                        if(parseInt(Ext.getCmp('sysYaOrdenamientosHC').getValue()) === 0){
                            solicitarOrdenamientosProgramaCronicos();
                        }
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function calculoEdadPacienteMeses(){
    var valFecha1 = 0;
    var pFec2Anio = 0;
    var pFec2Mes = 0;
    var pFec2Dia = 0;
    var valFecha2 = 0;
    MesesCumplidos = 0;
    AniosCumplidos = 0;


    valFecha1 = Ext.getCmp('sysFechaHC').getValue();
    pFec2Anio = Ext.getCmp('sysFechaNac').getValue().substr(6,4);
    pFec2Mes = Ext.getCmp('sysFechaNac').getValue().substr(3,2);
    pFec2Dia = Ext.getCmp('sysFechaNac').getValue().substr(0,2);
    
    valFecha2 =  pFec2Anio + "/" + pFec2Mes + "/" + pFec2Dia;

    MesesCumplidos = MostrarEdadMeses(valFecha1, valFecha2);
    
    AniosCumplidos = MostrarEdadAnios(valFecha1, valFecha2);
}

function solicitarOrdenamientosProgramaCronicos(){
    var wTask = "";
    //if(parseInt(Ext.getCmp('sysYaOrdenamientosHC').getValue()) === 0){
        if(Ext.getCmp('strPROGESPEIngreso').getValue() === "SI"){
            wTask = "CRONICOS_PRIMERA_VEZ";
        }else{
            wTask = "CRONICOS_CONTROL";
        }
        Ext.Ajax.request({
            url: '../../controlador/asistencial/controlador_programas.php',
            params:{
                task: wTask,
                pTipo: "E",
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue()   
            },
            success: function(response,options)
            {
                var el = Ext.get('response'); // get the LOG
                var Respuesta = response.responseText;
                var Contenido = Respuesta.split('^');
                if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                    Ext.MessageBox.show({
                        title: 'OfiClinic',
                        msg: 'Error al cargar los registros de solicitud de paraclinicos',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.ERROR
                    });
                    Ext.getCmp('sysYaOrdenamientosHC').setValue(0);
                } else {
                    Ext.getCmp('gridExamenesHC').store.reload();
                    Ext.MessageBox.show({
                        title: 'OfiClinic',
                        msg: 'Se genero la solicitud de paraclinicos',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.INFO
                    });
                    Ext.getCmp('sysYaOrdenamientosHC').setValue(1);
                }
            },
            failure: function(response,options){
                Ext.MessageBox.show({
                    title: 'OfiClinic - Base Datos',
                    msg: 'Error al cargar los registros de solicitud de paraclinicos',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
                Ext.getCmp('sysYaOrdenamientosHC').setValue(0);
            },
            scope:this
        });
    //}
}