/*
* @category    Formulario Modelo Evolucion Historia Clinica Crecimiento y Desarrollo
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winHCCrecimientoyDesarrollo001Ui = Ext.extend(Ext.Window, {
    title: 'eOfiClinic ©  .:: Plantilla HC Crecimiento y Desarrollo ::.',
    width: 990,
    height: 636,
    closable: false,
    resizable: false,
    draggable: false,
    modal: true,
    id: 'winHCCyD01',
    initComponent: function() {
        
        var fsDiagnosticosConsulta = new fsDiagnosticosConsultaUi();
        var fsRevisionxSistemas = new fsRevisionxSistemasUi();
        var fsAntecedentesPersonales = new fsAntecedentesPersonalesUi();
        var fsAntecedentesFamiliares = new fsAntecedentesFamiliaresUi();
        
        
        //NUEVO 2014
        //Consentimientos Informados
        var xConsentimientosInformados = new GridConsentimientosInformadosUi();
        //Consentimientos Informados
        var xEventosAdversos = new GridEventosAdversosUi();
        //KardexProgramas
        var xKardexProgramas = new GridKardexxPacUi();
        
        //Reporte Paraclinicos
        var stReporteParaclinicos = new StoreGridReporteParaclinicos();
        stReporteParaclinicos.load({
            params: {
                pPaciente: wPaciente
            }
        });
        //Alertas Medicas
        var xAlertasxPaciente = new AlertasxPaciente001Ui();
        Ext.getCmp('gridAlertasPacientes').store.baseParams = {
            task: 'LISTAR_ALERTAS',
            pPaciente: wPaciente,
            pIPS: ID_IPS
        };
        Ext.getCmp('gridAlertasPacientes').store.load({
            params: {
                pPaciente: wPaciente
            }
        });
        function renderClasificacionReporte(val, x, store){
            switch(val){
                case "A":
                    return '<span style="color:#F00">Anormal</span>';
                    break;
                case "N":
                    return '<span style="color:#090">Normal</span>';
                    break;
                default:
                    break;
            }
        }
        function renderValorReporte(value, metaData, record, rowIndex, colIndex, store){  
            metaData.attr = 'style="white-space:normal"';  
            if(record.get('ReporteVal') !== "" && record.get('ReporteVal') !== null){
                return value + "<br><hr>Valor: " + record.get('ReporteVal');  
            }else{
                return value;  
            }
        }
        function renderObservaReporte(value, metaData, record, rowIndex, colIndex, store){  
            metaData.attr = 'style="white-space:normal"';  
            return value;  
        }
        //
        
        tmpmx = objMX;
        tmpmxadd = objMXADD;
        tmpexa = objEXA;
        tmprem = objREM;
        myPaciente = 0;
        myCAS = 0;

        try {
            var campo = Ext.getCmp('sysPacientePlantillaHC');
            if ( campo !== null ) {
                myPaciente = Ext.getCmp('sysPacientePlantillaHC').getValue();
            }
        }catch(ex){
        }
        if(myPaciente === 0){
            try {
                var campo1 = Ext.getCmp('sysIdPacienteHC');
                if ( campo1 !== null ) {
                    myPaciente = Ext.getCmp('sysIdPacienteHC').getValue();
                }
            }catch(ex){
            }
        }
        if(myPaciente === 0){
            try {
                var campo5 = Ext.getCmp('sysPacienteRefHC');
                if ( campo5 !== null ) {
                    myPaciente = Ext.getCmp('sysPacienteRefHC').getValue();
                }
            }catch(ex){
            }
        }
        try {
            var campo2 = Ext.getCmp('sysCASPlantillaHC');
            if ( campo2 !== null ) {
                myCAS = Ext.getCmp('sysCASPlantillaHC').getValue();
            }
        }catch(ex){
        }
        if(myCAS === 0){
            try {
                var campo3 = Ext.getCmp('sysCASHC');
                if ( campo3 !== null ) {
                    myCAS = Ext.getCmp('sysCASHC').getValue();
                }
            }catch(ex){
            }
        }
        if(myCAS === 0){
            try {
                var campo4 = Ext.getCmp('sysCASRefHC');
                if ( campo4 !== null ) {
                    myCAS = Ext.getCmp('sysCASRefHC').getValue();
                }
            }catch(ex){
            }
        }
        if (objMX !== "NA"){
            var xSolMX = eval(objMX);
            Ext.getCmp('gridMedicamentosHC').store.load({
                params: {
                    task: 'MX_IPS_BASICA',
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: wPaciente,
                    pCAS: wCAS
                }
            });
        }
        else{
            var xSolMX = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        if (objEXA !== "NA"){
            var xSolEXA = eval(objEXA);
            Ext.getCmp('gridExamenesHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: wPaciente,
                    pCAS: wCAS
                }
            });
        }else{
            var xSolEXA = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        if (objREM !== "NA"){
            var xSolREM = eval(objREM);
            Ext.getCmp('gridRemisionesHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: wPaciente,
                    pCAS: wCAS
                }
            });
        }else{
            var xSolREM = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        var xSolNOPOS = new SolNOPOS001Ui();
        Ext.getCmp('gridSolicitudesNOPOSxPaciente').store.load({
            params: {
                task: 'LISTAR_NOPOS',
                pPaciente: myPaciente
            }
        });

        var dataEstadoNutricional = [
            ['NORMAL'],
            ['DESNUTRICION']
        ];
        var stEstadoNutricional = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stEstadoNutricional.loadData(dataEstadoNutricional);
        
        
        var dataDesnutricion = [
            ['RECIENTE'],
            ['CRONICA']
        ];
        var stDesnutricion = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stDesnutricion.loadData(dataDesnutricion);

        //
        this.items = [
            {
                xtype: 'panel',
                frame: true,
                anchor: '100%',
                id: 'panelHC',
                border: false,
                height: 570,
                autoScroll: true,
                layout: 'form',
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysIdCodPlantillaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        value: 1,
                        id: 'sysUsaGridSalida'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                        value: 0,
                        id: 'sysYaGuardoHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysPlantillaHC',
                        name: 'PLANTILLA'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptMx'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptExa'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptRem'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Actividad',
                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                        id: 'sysActividadHC',
                        name: 'PLANTILLA'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Empresa',
                        id: 'sysEmpresaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'IPS',
                        id: 'sysIPSHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Usuario',
                        id: 'sysUsuarioHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Profesional',
                        id: 'sysProfesionalHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Paciente',
                        id: 'sysIdPacienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Apertura',
                        id: 'sysAperturaHC'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Cliente',
                        id: 'sysClienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdClienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdPlanHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdSubPlanHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdContratoHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Genero',
                        id: 'sysGeneroPacHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Edad',
                        id: 'sysEdadPacHC'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Profesional',
                        id: 'sysProfesionalAgendaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'ConsecutivoDetalle',
                        id: 'sysConsecutivoDetalleHC'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'CAS',
                                id: 'sysCASHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysFechaHC',
                                value: 'Fecha: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysFechaHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysHoraHC',
                                value: 'Hora: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysHoraHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysLegalizacionHC',
                                value: 'Legalización: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysLegalizaHC'
                            }
                        ]
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Paciente',
                        value: 'CC 792558261  - JORGE GALEANO RUIZ - (Masculino) FechaNac: 1973-01-30, Edad 38 Años',
                        id: 'sysPacienteHC'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'textfield',
                                width: 100,
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'Genero',
                                id: 'sysGeneroHC'
                            },
                            {
                                html: 'Fecha Nac:'
                            },
                            {
                                xtype: 'textfield',
                                width: 100,
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysFechaNac'
                            },
                            {
                                html: 'Edad:'
                            },
                            {
                                xtype: 'textfield',
                                width: 350,
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysEdadHC'
                            }
                        ]
                    },
                    /*{
                        xtype: 'button',
                        iconCls: 'btnImprimir',
                        text: 'Cargar Antecedentes',
                        tooltip: 'Cargar Antecedentes',
                        listeners:{
                            click : function(){
                                Ext.Ajax.request({
                                    url: '../../controlador/asistencial/evolucionhc.php',
                                    waitMsg: 'Cargando Información...',
                                    params:{
                                        pCAS: myCAS,
                                        pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                                        task: 'ImportarAntecedentesPersonalesOfiClinic001'
                                    },
                                    success: function(result, request)
                                    {
                                        var jsonAntPersonales = Ext.util.JSON.decode(result.responseText);
                                        UtilCargarAntecedentesOfiClinic001(jsonAntPersonales.data);
                                    },
                                    scope:this
                                });
                            }
                        }
                    },*/
                    {
                        html: '<hr>',
                        style: 'background:transparent;',
                        border: false
                    },
                    {
                        xtype: 'tabpanel',
                        anchor: '99%',
                        autoHeight: true,
                        border: false,
                        enableTabScroll: true,
                        ref: 'fTabPanel',
                        id: 'fTabPanel',
                        activeTab: 0,
                        items: [
                            {
                                xtype: 'panel',
                                title: 'Evolución',
                                autoHeight: true,
                                autoScroll: true,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaEvolucion',
                                layout: 'form',
                                items: [
                                    {
                                        xtype: 'form',
                                        frame: true,
                                        anchor: '100%',
                                        id: 'frmHCCyD01',
                                        padding: 10,
                                        border: false,
                                        autoScroll: true,
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        fieldLabel: 'Acompañante',
                                                        name: 'Acompañante',
                                                        width: 350,
                                                        allowBlank: false,
                                                        id: 'strDATINGPROGAcompanante'
                                                    },
                                                    {
                                                        html: '   Parentesco:'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name: 'Parentezco',
                                                        width: 350,
                                                        allowBlank: false,
                                                        store: stParentesco,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strDATINGPROGParentesco'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 60,
                                                forceSelection: true,
                                                emptyText: 'SI/NO',
                                                mode: 'local',
                                                typeAhead: true,
                                                typeAheadDelay: 50,
                                                listEmptyText: '',
                                                triggerAction: 'all',
                                                store:'StoreSiNo',
                                                fieldLabel:'Consulta de Primera Vez?',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                name:'Primera Vez CyD',
                                                id: 'sysPrimeraVezCyD',
                                                listeners:{
                                                    change : function(f,pNew, pOld){
                                                        if(pNew === null || pNew === 0 || pNew === "NO"){
                                                            Ext.getCmp('sysCyDPrimeraVez4505').setValue(null);
                                                        }else{
                                                            Ext.getCmp('sysCyDPrimeraVez4505').setValue(Ext.getCmp('sysFechaHC').getValue());
                                                        }
                                                    }
                                                }
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'CyD Primera Vez',
                                                allowBlank: true,
                                                hidden: true,
                                                id: 'sysCyDPrimeraVez4505'
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'MOTIVO DE CONSULTA',
                                                layout: 'table',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'MOTIVO DE CONSULTA',
                                                        name: 'MOTIVO DE CONSULTA',
                                                        height: 100,
                                                        allowBlank: false,
                                                        id: 'memMotivoConsulta'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'ENFERMEDAD ACTUAL',
                                                layout: 'table',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'ENFERMEDAD ACTUAL',
                                                        name: 'ENFERMEDAD ACTUAL',
                                                        height: 100,
                                                        allowBlank: false,
                                                        id: 'memEnfermedadActual'
                                                    }
                                                ]
                                            },
                                            fsRevisionxSistemas,
                                            fsAntecedentesPersonales,
                                            fsAntecedentesFamiliares,
                                            {
                                                xtype: 'fieldset',
                                                title: 'EXAMEN FISICO',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                labelSeparator: '',
                                                autoHeight: true,
                                                padding: 0,
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                fieldLabel: 'T.A.',
                                                                name: 'T.A. Sistolica',
                                                                width: 70,
                                                                minValue: 0,
                                                                maxValue: 300,
                                                                decimalPrecision: 0,
                                                                allowBlank: true,
                                                                id: 'intEXAFISTASistolica'
                                                            },
                                                            {
                                                                html: '/'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                name: 'T.A. Diastolica',
                                                                width: 70,
                                                                minValue: 0,
                                                                maxValue: 300,
                                                                decimalPrecision: 0,
                                                                allowBlank: true,
                                                                id: 'intEXAFISTADiastolica'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                decimalPrecision: 2,
                                                                allowBlank: false,
                                                                fieldLabel: 'TALLA (cm)',
                                                                name:"TALLA (cm)",
                                                                emptyText: '(cm)',
                                                                id: 'intEXAFISTalla',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        if(pNew === null || pNew === 0){
                                                                            Ext.getCmp('intEXAFISTalla').setValue(null);
                                                                            Ext.getCmp('intEXAFISIMC').setValue(0);
                                                                        }else{
                                                                            if(Ext.getCmp('intEXAFISPeso').getValue() > 0){
                                                                                var pTalla = Ext.getCmp('intEXAFISTalla').getValue() / 100;
                                                                                Ext.getCmp('intEXAFISIMC').setValue(Ext.getCmp('intEXAFISPeso').getValue()/(pTalla*pTalla));
                                                                            }else{
                                                                                Ext.getCmp('intEXAFISIMC').setValue(0);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysEXAFISPeso',
                                                                value: 'PESO (Kg) '
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                decimalPrecision: 2,
                                                                allowBlank: false,
                                                                emptyText: '(Kg)',
                                                                name:"PESO (Kg)",
                                                                id: 'intEXAFISPeso',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        if(pNew === null || pNew === 0){
                                                                            Ext.getCmp('intEXAFISPeso').setValue(null);
                                                                            Ext.getCmp('intEXAFISIMC').setValue(0);
                                                                        }else{
                                                                            //peso [kg]/ estatura [m2]
                                                                            if(Ext.getCmp('intEXAFISTalla').getValue() > 0){
                                                                                var pTalla = Ext.getCmp('intEXAFISTalla').getValue() / 100;
                                                                                Ext.getCmp('intEXAFISIMC').setValue(Ext.getCmp('intEXAFISPeso').getValue()/(pTalla*pTalla));
                                                                            }else{
                                                                                Ext.getCmp('intEXAFISIMC').setValue(0);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysEXAFISIMC',
                                                                value: 'IMC '
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                minValue: 0,
                                                                decimalPrecision: 2,
                                                                allowBlank: false,
                                                                readOnly: true,
                                                                name: "IMC",
                                                                id: 'intEXAFISIMC'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysEXAFISPA',
                                                                value: 'P. Cefalico '
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                minValue: 0,
                                                                decimalPrecision: 2,
                                                                name: 'Perimetro Cefalico',
                                                                allowBlank: true,
                                                                id: 'strEXAFISPC'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                fieldLabel: 'Temp',
                                                                width: 60,
                                                                minValue: 0,
                                                                decimalPrecision: 2,
                                                                name: 'Temperatura',
                                                                allowBlank: false,
                                                                id: 'intEXAFISTemp'
                                                            },
                                                            {
                                                                html: 'F.C.'
                                                            },                                                            
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                minValue: 0,
                                                                decimalPrecision: 2,
                                                                name: 'FC',
                                                                allowBlank: false,
                                                                id: 'intEXAFISFC'
                                                            },
                                                            {
                                                                html: 'F.R.'
                                                            },                                                            
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 60,
                                                                minValue: 0,
                                                                decimalPrecision: 2,
                                                                name: 'FR',
                                                                allowBlank: false,
                                                                id: 'intEXAFISFR'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Condiciones Generales',
                                                        name: 'Condiciones Generales',
                                                        allowBlank: false,
                                                        value: "No Evaluado",
                                                        id: 'strEXAFISCondicionesGenerales',
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strEXAFISCondicionesGenerales').setValue("Normal");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Piel y Anexos<br>&nbsp;',
                                                        name: 'Piel y Anexos',
                                                        allowBlank: false,
                                                        value: "No Evaluado",
                                                        id: 'strEXAFISPielyAnexos',
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strEXAFISPielyAnexos').setValue("Normal");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Cabeza<br>&nbsp;',
                                                        name: 'Cabeza',
                                                        allowBlank: false,
                                                        value: "No Evaluado",
                                                        id: 'strEXAFISCabeza',
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strEXAFISCabeza').setValue("Normal");
                                                                });
                                                            }
                                                        }

                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Ojos<br>&nbsp;',
                                                        name: 'Ojos',
                                                        allowBlank: false,
                                                        id: 'strEXAFISOjos',
                                                        value: "No Evaluado",
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strEXAFISOjos').setValue("Normal");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'ORL<br>&nbsp;',
                                                        name: 'ORL',
                                                        allowBlank: false,
                                                        value: "No Evaluado",
                                                        id: 'strEXAFISORL',
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strEXAFISORL').setValue("Normal");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Orofaringe<br>&nbsp;',
                                                        name: 'Orofaringe',
                                                        allowBlank: false,
                                                        value: "No Evaluado",
                                                        id: 'strEXAFISOrofaringe',
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strEXAFISOrofaringe').setValue("Normal");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Cuello<br>&nbsp;',
                                                        name: 'Cuello',
                                                        allowBlank: false,
                                                        value: "No Evaluado",
                                                        id: 'strEXAFISCuello',
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strEXAFISCuello').setValue("Normal");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Dorso<br>&nbsp;',
                                                        name: 'Dorso',
                                                        allowBlank: false,
                                                        id: 'strEXAFISDorso',
                                                        value: "No Evaluado",
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strEXAFISDorso').setValue("Normal");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Cardiaco<br>&nbsp;',
                                                        name: 'Cardiaco',
                                                        allowBlank: false,
                                                        id: 'strEXAFISCardiaco',
                                                        value: "No Evaluado",
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strEXAFISCardiaco').setValue("Normal");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Pulmonar<br>&nbsp;',
                                                        name: 'Pulmonar',
                                                        allowBlank: false,
                                                        id: 'strEXAFISPulmonar',
                                                        value: "No Evaluado",
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strEXAFISPulmonar').setValue("Normal");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Abdomen<br>&nbsp;',
                                                        name: 'Abdomen',
                                                        allowBlank: false,
                                                        id: 'strEXAFISAbdomen',
                                                        value: "No Evaluado",
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strEXAFISAbdomen').setValue("Normal");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Genitales<br>&nbsp;',
                                                        name: 'Genitales',
                                                        allowBlank: false,
                                                        id: 'strEXAFISGenitales',
                                                        value: "No Evaluado",
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strEXAFISGenitales').setValue("Normal");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Extremidades<br>&nbsp;',
                                                        name: 'Extremidades',
                                                        allowBlank: false,
                                                        id: 'strEXAFISExtremidades',
                                                        value: "No Evaluado",
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strEXAFISExtremidades').setValue("Normal");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Neurologico<br>&nbsp;',
                                                        name: 'Neurologico',
                                                        allowBlank: false,
                                                        id: 'strEXAFISNeurologico',
                                                        value: "No Evaluado",
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strEXAFISNeurologico').setValue("Normal");
                                                                });
                                                            }
                                                        }
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'datefield',
                                                        fieldLabel: 'Fecha Ingreso Programa',
                                                        name: 'Fecha Ingreso Programa',
                                                        emptyText: '(dia/mes/año)',
                                                        width: 120,
                                                        allowBlank: true,
                                                        id: 'fecCYDIngresoPrograma'
                                                    },
                                                    {
                                                        html: 'Ultimo Control'
                                                    },
                                                    {
                                                        xtype: 'datefield',
                                                        name: 'Fecha Ultimo Control',
                                                        emptyText: '(dia/mes/año)',
                                                        width: 120,
                                                        allowBlank: true,
                                                        id: 'fecCYDUltimoControl'
                                                    },
                                                    {
                                                        html: 'Control Numero'
                                                    },
                                                    {
                                                        xtype: 'numberfield',
                                                        width: 120,
                                                        name: 'Control Numero',
                                                        minValue: 0,
                                                        vaue: 0,
                                                        allowBlank: true,
                                                        style: 'text-align:center;',
                                                        id: 'intCYDControlNumero'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '<center>ESCALA ABREVIADA DEL DESARROLLO</center>',
                                                layout: 'form',
                                                anchor: '100%',
                                                autoHeight: true,
                                                items: [
                                                    {
                                                        xtype: 'panel',
                                                        layout: 'table',
                                                        anchor: '100%',
                                                        padding: 0,
                                                        layoutConfig: {
                                                            columns: 5
                                                        },
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'panel',
                                                                layout: 'form',
                                                                width: 25,
                                                                height: 1500,
                                                                labelWidth: 0,
                                                                labelSeparator: '',
                                                                labelStyle: 'color:blue;',
                                                                title: '<center>M</center>',
                                                                items: [
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: '<br>&nbsp;< 1<br>&nbsp;',
                                                                        width: 1,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaA'
                                                                    },
                                                                    {
                                                                        html: '<hr>' 
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: '<br>',
                                                                        width: 1,
                                                                        height: 7,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaB'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: '&nbsp;1<br>&nbsp;a<br>&nbsp;3',
                                                                        width: 1,
                                                                        height: 7,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaC'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        width: 1,
                                                                        height: 7,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaD'
                                                                    },
                                                                    {
                                                                        html: '<hr>' 
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: '<br>',
                                                                        width: 1,
                                                                        height: 7,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaE'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: '&nbsp;4<br>&nbsp;a<br>&nbsp;6',
                                                                        width: 1,
                                                                        height: 7,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaF'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        width: 1,
                                                                        height: 7,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaG'
                                                                    },
                                                                    {
                                                                        html: '<hr>' 
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: '<br>',
                                                                        width: 1,
                                                                        height: 7,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaH'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: '&nbsp;7<br>&nbsp;a<br>&nbsp;9',
                                                                        width: 1,
                                                                        height: 7,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaI'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        width: 1,
                                                                        height: 7,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaJ'
                                                                    },
                                                                    {
                                                                        html: '<hr>' 
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: '<br>',
                                                                        width: 1,
                                                                        height: 7,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaK'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: '10&nbsp;<br>&nbsp;a<br>12&nbsp;',
                                                                        width: 1,
                                                                        height: 7,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaL'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        width: 1,
                                                                        height: 7,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaM'
                                                                    },
                                                                    {
                                                                        html: '<hr>' 
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: '<br>',
                                                                        width: 1,
                                                                        height: 7,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaN'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: '13&nbsp;<br>&nbsp;a<br>18&nbsp;',
                                                                        width: 1,
                                                                        height: 7,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaO'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        width: 1,
                                                                        height: 7,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaP'
                                                                    },
                                                                    {
                                                                        html: '<hr>' 
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: '<br>',
                                                                        width: 1,
                                                                        height: 7,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaQ'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: '19&nbsp;<br>&nbsp;a<br>24&nbsp;',
                                                                        width: 1,
                                                                        height: 7,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaR'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        width: 1,
                                                                        height: 7,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaS'
                                                                    },
                                                                    {
                                                                        html: '<hr>' 
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: '<br>',
                                                                        width: 1,
                                                                        height: 7,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaT'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: '25&nbsp;<br>&nbsp;a<br>36&nbsp;',
                                                                        width: 1,
                                                                        height: 7,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaU'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        width: 1,
                                                                        height: 7,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaV'
                                                                    },
                                                                    {
                                                                        html: '<hr>' 
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: '<br>',
                                                                        width: 1,
                                                                        height: 7,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaW'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: '37&nbsp;<br>&nbsp;a<br>48&nbsp;',
                                                                        width: 1,
                                                                        height: 7,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaX'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        width: 1,
                                                                        height: 7,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaY'
                                                                    },
                                                                    {
                                                                        html: '<hr>' 
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: '<br>',
                                                                        width: 1,
                                                                        height: 7,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaZ'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: '49&nbsp;<br>&nbsp;a<br>60&nbsp;',
                                                                        width: 1,
                                                                        height: 7,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaAA'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        width: 1,
                                                                        height: 7,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaAB'
                                                                    },
                                                                    {
                                                                        html: '<hr>' 
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: '<br>',
                                                                        width: 1,
                                                                        height: 7,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaAC'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: '61&nbsp;<br>&nbsp;a<br>72&nbsp;',
                                                                        width: 1,
                                                                        height: 7,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaAD'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: '<br>&nbsp;',
                                                                        width: 1,
                                                                        height: 7,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaAE'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                layout: 'form',
                                                                width: 210,
                                                                height: 1500,
                                                                labelWidth: 150,
                                                                labelSeparator: '',
                                                                labelStyle: 'color:blue;',
                                                                title: '<center>MOTRIZ - GRUEZA</center>',
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '0. Patea vigorosamente?<br>&nbsp;<br>&nbsp;',
                                                                        name: '0. Patea vigorosamente?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_A0',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_AClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_A0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        html: '<hr>'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '1. Levanta la cabeza en prona?',
                                                                        name: '1. Levanta la cabeza en prona?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_A1',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_AClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_A0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '2. Levanta cabeza pecho en prona?',
                                                                        name: '2. Levanta cabeza pecho en prona?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_A2',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_AClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_A0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '3. Sostiene cabeza al levantarlo de los brazos?',
                                                                        name: '3. Sostiene cabeza al levantarlo de los brazos?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_A3',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_AClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_A0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        html: '<hr>'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '4. Control de cabeza sentado?',
                                                                        name: '4. Control de cabeza sentado?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_A4',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_AClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_A0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '5. Se voltea de un lado a otro?',
                                                                        name: '5. Se voltea de un lado a otro?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_A5',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_AClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_A0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '6. Intenta sentarse solo?<br>&nbsp;',
                                                                        name: '6. Intenta sentarse solo?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_A6',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_AClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_A0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        html: '<hr>'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '7.Se sostiene sentado con ayuda?',
                                                                        name: '7. Se sostiene sentado con ayuda?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_A7',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_AClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_A0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '8. Se arrastra en posicion prona?',
                                                                        name: '8. Se arrastra en posicion prona?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_A8',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_AClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_A0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '9. Se sienta por si solo?<br>&nbsp;',
                                                                        name: '9. Se sienta por si solo?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_A9',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_AClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_A0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        html: '<hr>'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '10.Gatea bien?<br>&nbsp;',
                                                                        name: '10.Gatea bien?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_A10',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_AClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_A0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '11.Se agarra y sostiene de pie?',
                                                                        name: '11.Se agarra y sostiene de pie?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_A11',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_AClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_A0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '12.Se para solo?<br>&nbsp;',
                                                                        name: '12.Se para solo?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_A12',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_AClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_A0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        html: '<hr>'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '13.Da pasitos solo?<br>&nbsp;',
                                                                        name: '13.Da pasitos solo?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_A13',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_AClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_A0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '14.Camina solo bien?<br>&nbsp;',
                                                                        name: '14.Camina solo bien?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_A14',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_AClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_A0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '15.Corre?<br>&nbsp;',
                                                                        name: '15.Corre?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_A15',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_AClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_A0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        html: '<hr>'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '16.Patea la pelota?<br>&nbsp;',
                                                                        name: '16.Patea la pelota?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_A16',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_AClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_A0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '17.Lanza la pelota con las manos?',
                                                                        name: '17.Lanza la pelota con las manos?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_A17',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_AClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_A0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '18.Salta en los dos pies?<br>&nbsp;',
                                                                        name: '18.Salta en los dos pies?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_A18',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_AClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_A0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        html: '<hr>'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '19.Se empina en ambos pies?',
                                                                        name: '19.Se empina en ambos pies?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_A19',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_AClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_A0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '20.Se levanta sin usar las manos?',
                                                                        name: '20.Se levanta sin usar las manos?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_A20',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_AClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_A0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '21.Camina hacia atras?<br>&nbsp;',
                                                                        name: '21.Camina hacia atras?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_A21',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_AClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_A0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        html: '<hr>'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '22.Camina en punta de pies?',
                                                                        name: '22.Camina en punta de pies?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_A22',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_AClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_A0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '23.Se para en un solo pie?<br>&nbsp;',
                                                                        name: '23.Se para en un solo pie?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_A23',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_AClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_A0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '24.Lanza y agarra la pelota?',
                                                                        name: '24.Lanza y agarra la pelota?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_A24',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_AClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_A0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        html: '<hr>'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '25.Camina en linea recta?<br>&nbsp;',
                                                                        name: '25.Camina en linea recta?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_A25',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_AClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_A0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '26.Tres o mas pasos en un pie?',
                                                                        name: '26.Tres o mas pasos en un pie?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_A26',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_AClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_A0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '27.Hace rebotar y agarra la pelota?',
                                                                        name: '27.Hace rebotar y agarra la pelota?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_A27',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_AClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_A0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        html: '<hr>'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '28.Salta a pies juntillas cuerda a 25 cms?',
                                                                        name: '28.Salta a pies juntillas cuerda a 25 cms?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_A28',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_AClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_A0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '29.Hace "caballitos" alternando los pies?',
                                                                        name: '29.Hace "caballitos" alternando los pies?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_A29',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_AClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_A0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '30.Salta desde 60 cms de altura?',
                                                                        name: '30.Salta desde 60 cms de altura?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_A30',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_AClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_A0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },  //Escala Motrizidad Gruesa
                                                            {
                                                                xtype: 'panel',
                                                                layout: 'form',
                                                                labelWidth: 150,
                                                                labelSeparator: '',
                                                                labelStyle: 'color:red;',
                                                                width: 210,
                                                                height: 1500,
                                                                title: '<center>MOTRIZ - FINO ADAPTATIVA</center>',
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '0. Sigue movimiento horizontal y vertical del objeto?',
                                                                        name: '0. Sigue movimiento horizontal y vertical del objeto?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_B0',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_BClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_B0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        html: '<hr>'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '1. Abre y mira sus manos?<br>&nbsp;',
                                                                        name: '1. Abre y mira sus manos?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_B1',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_BClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_B0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '2. Sostiene objeto en la mano?',
                                                                        name: '2. Sostiene objeto en la mano?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_B2',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_BClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_B0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '3. Se lleva objeto a la boca?',
                                                                        name: '3. Se lleva objeto a la boca?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_B3',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_BClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_B0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        html: '<hr>'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '4. Agarra objetos voluntariamente?',
                                                                        name: '4. Agarra objetos voluntariamente?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_B4',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_BClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_B0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '5. Sostiene un objetos en cada mano?',
                                                                        name: '5. Sostiene un objetos en cada mano?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_B5',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_BClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_B0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '6. Pasa objetos de una mano a otra?',
                                                                        name: '6. Pasa objetos de una mano a otra?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_B6',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_BClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_B0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        html: '<hr>'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '7. Manipula varios objetos a la vez?',
                                                                        name: '7. Manipula varios objetos a la vez?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_B7',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_BClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_B0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '8. Agarra objetos pequeños con los dedos?',
                                                                        name: '8. Agarra objetos pequeños con los dedos?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_B8',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_BClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_B0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '9. Agarra cubo con pulgar e indice?',
                                                                        name: '9. Agarra cubo con pulgar e indice?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_B9',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_BClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_B0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        html: '<hr>'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '10.Mete y saca objetos en caja?',
                                                                        name: '10.Mete y saca objetos en caja?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_B10',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_BClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_B0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '11.Agarra tercer objeto sin soltar otros?',
                                                                        name: '11.Agarra tercer objeto sin soltar otros?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_B11',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_BClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_B0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '12.Busca objetos escondidos?',
                                                                        name: '12.Busca objetos escondidos?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_B12',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_BClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_B0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        html: '<hr>'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '13.Hace torre de tres cubos?',
                                                                        name: '13.Hace torre de tres cubos?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_B13',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_BClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_B0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '14.Pasa hojas de un libro?<br>&nbsp;',
                                                                        name: '14.Pasa hojas de un libro?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_B14',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_BClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_B0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '15.Anticipa salida del objeto?',
                                                                        name: '15.Anticipa salida del objeto?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_B15',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_BClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_B0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        html: '<hr>'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '16.Tapa bien la caja?<br>&nbsp;',
                                                                        name: '16.Tapa bien la caja?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_B16',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_BClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_B0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '17.Hace garabatos circulares?',
                                                                        name: '17.Hace garabatos circulares?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_B17',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_BClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_B0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '18.Hace torre de cinco o mas cubo?',
                                                                        name: '18.Hace torre de cinco o mas cubos?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_B18',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_BClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_B0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        html: '<hr>'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '19.Ensarta seis o mas cuentas?',
                                                                        name: '19.Ensarta seis o mas cuentas?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_B19',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_BClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_B0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '20.Copia linea horizontal y vertical?',
                                                                        name: '20.Copia linea horizontal y vertical?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_B20',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_BClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_B0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '21.Separa objetos grandes y pequeños?',
                                                                        name: '21.Separa objetos grandes y pequeños?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_B21',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_BClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_B0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        html: '<hr>'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '22.Figura humana rudimentaria 1?',
                                                                        name: '22.Figura humana rudimentaria 1?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_B22',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_BClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_B0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '23.Corta papel con tijeras?<br>&nbsp;',
                                                                        name: '23.Corta papel con tijeras?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_B23',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_BClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_B0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '24.Copia cuadrado y circulo?',
                                                                        name: '24.Copia cuadrado y circulo?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_B24',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_BClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_B0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        html: '<hr>'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '25.Figura humana rudimentaria 2?',
                                                                        name: '25.Figura humana rudimentaria 2?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_B25',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_BClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_B0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '26.Agrupa por color y forma?',
                                                                        name: '26.Agrupa por color y forma?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_B26',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_BClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_B0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '27.Dibuja escalera (imita)?<br>&nbsp;',
                                                                        name: '27.Dibuja escalera (imita)?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_B27',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_BClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_B0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        html: '<hr>'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '28.Agrupa por color, forma y tamaño?',
                                                                        name: '28.Agrupa por color, forma y tamaño?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_B28',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_BClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_B0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '29.Reconstruye escalera 10 cubos?',
                                                                        name: '29.Reconstruye escalera 10 cubos?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_B29',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_BClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_B0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '30.Dibuja casa?<br>&nbsp;',
                                                                        name: '30.Dibuja casa?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_B30',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_BClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_B0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            }, //Escala Motrizidad Fino Adaptativa
                                                            {
                                                                xtype: 'panel',
                                                                layout: 'form',
                                                                labelWidth: 150,
                                                                labelSeparator: '',
                                                                width: 210,
                                                                height: 1500,
                                                                title: '<center>AUDICION Y LENGUUAJE</center>',
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '0. Se sobresalta con ruido?<br>&nbsp;<br>&nbsp;',
                                                                        name: '0. Se sobresalta con ruido?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_C0',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_CClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_C0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        html: '<hr>'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '1. Busca Sonido con la Mirada?',
                                                                        name: '1. Busca Sonido con la Mirada?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_C1',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_CClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_C0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '2. Dos Sonidos Guturales Diferentes?',
                                                                        name: '2. Dos Sonidos Guturales Diferentes?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_C2',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_CClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_C0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '3. Balbucea con las Personas?',
                                                                        name: '3. Balbucea con las Personas?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_C3',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_CClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_C0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        html: '<hr>'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '4. Cuatro o mas sonidos diferentes?',
                                                                        name: '4. Cuatro o mas sonidos diferentes?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_C4',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_CClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_C0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '5. Rie a "carcajadas"?<br>&nbsp;',
                                                                        name: '5. Rie a "carcajadas"',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_C5',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_CClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_C0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '6. Reacciona cuando se llama?',
                                                                        name: '6. Reacciona cuando se llama?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_C6',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_CClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_C0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        html: '<hr>'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '7. Pronuncia tres o mas silabas?',
                                                                        name: '7. Pronuncia tres o mas silabas?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_C7',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_CClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_C0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '8. Hace sonar la campanilla?&nbsp;',
                                                                        name: '8. Hace sonar la campanilla?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_C8',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_CClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_C0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '9. Una palabra clara?<br>&nbsp;',
                                                                        name: '9. Una palabra clara?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_C9',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_CClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_C0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        html: '<hr>'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '10.Niega con la Cabeza?<br>&nbsp;',
                                                                        name: '10.Niega con la Cabeza?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_C10',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_CClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_C0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '11.Llama a la madre o acompañante?',
                                                                        name: '11.Llama a la madre o acompañante?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_C11',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_CClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_C0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '12.Entiende orden sencilla?<br>&nbsp;',
                                                                        name: '12.Entiende orden sencilla?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_C12',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_CClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_C0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        html: '<hr>'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '13.Reconoce tres objetos?<br>&nbsp;',
                                                                        name: '13.Reconoce tres objetos?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_C13',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_CClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_C0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '14.Combina dos palabras?<br>&nbsp;',
                                                                        name: '14.Combina dos palabras?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_C14',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_CClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_C0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '15.Reconoce seis objetos?<br>&nbsp;',
                                                                        name: '15.Reconoce seis objetos?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_C15',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_CClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_C0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        html: '<hr>'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '16.Nombra cinco objetos?<br>&nbsp;',
                                                                        name: '16.Nombra cinco objetos?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_C16',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_CClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_C0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '17.Usa fraces de tres palabras?',
                                                                        name: '17.Usa fraces de tres palabras?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_C17',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_CClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_C0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '18.Mas de veinte palabras claras?',
                                                                        name: '18.Mas de veinte palabras claras?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_C18',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_CClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_C0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        html: '<hr>'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '19.Dice su nombre completo?',
                                                                        name: '19.Dice su nombre completo?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_C19',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_CClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_C0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '20.Conoce: Alto, bajo, grande, pequeño?',
                                                                        name: '20.Conoce: Alto, bajo, grande, pequeño?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_C20',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_CClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_C0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '21.Usa oraciones completas?',
                                                                        name: '21.Usa oraciones completas?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_C21',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_CClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_C0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        html: '<hr>'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '22.Define por uso cinco objetos?',
                                                                        name: '22.Define por uso cinco objetos?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_C22',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_CClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_C0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '23.Repite tres digitos?<br>&nbsp;',
                                                                        name: '23.Repite tres digitos?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_C23',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_CClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_C0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '24.Describe bien el dibujo?<br>&nbsp;',
                                                                        name: '24.Describe bien el dibujo?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_C24',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_CClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_C0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        html: '<hr>'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '25.Cuenta los dedos de la mano?',
                                                                        name: '25.Cuenta los dedos de la mano?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_C25',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_CClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_C0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '26.Distingue: Adelante, atras, arriba, abajo?',
                                                                        name: '26.Distingue: Adelante, atras, arriba, abajo?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_C26',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_CClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_C0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '27.Nombra cuatro, cinco colores?',
                                                                        name: '27.Nombra cuatro, cinco colores?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_C27',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_CClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_C0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        html: '<hr>'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '28.Expresa opiniones?<br>&nbsp;',
                                                                        name: '28.Expresa opiniones?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_C28',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_CClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_C0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '29.Conoce izquierda, derecha?',
                                                                        name: '29.Conoce izquierda, derecha?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_C29',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_CClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_C0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '30.Conoce dias de la semana?',
                                                                        name: '30.Conoce dias de la semana?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_C30',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_CClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_C0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },  //Escala Audicion Lenguaje
                                                            {
                                                                xtype: 'panel',
                                                                layout: 'form',
                                                                labelWidth: 150,
                                                                labelSeparator: '',
                                                                width: 210,
                                                                height: 1500,
                                                                title: '<center>PERSONA SOCIAL</center>',
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '0. Sigue movimiento del rostro?<br>&nbsp;',
                                                                        name: '0. Sigue movimiento del rostro?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_D0',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_DClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_D0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        html: '<hr>'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '1. Reconoce a la madre?<br>&nbsp;',
                                                                        name: '1. Reconoce a la madre?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_D1',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_DClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_D0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '2. Sonrie al acariciarlo?<br>&nbsp;',
                                                                        name: '2. Sonrie al acariciarlo?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_D2',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_DClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_D0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '3. Se voltea cuando se le habla?',
                                                                        name: '3. Se voltea cuando se le habla?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_D3',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_DClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_D0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        html: '<hr>'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '4. Coge mano del examinador?',
                                                                        name: '4. Coge mano del examinador?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_D4',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_DClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_D0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '5. Acepta y coge juguete?<br>&nbsp;',
                                                                        name: '5. Acepta y coge juguete?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_D5',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_DClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_D0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '6. Pone atencion a la conversacion?',
                                                                        name: '6. Pone atencion a la conversacion?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_D6',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_DClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_D0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        html: '<hr>'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '7. Ayuda a sostener tasa para beber?',
                                                                        name: '7. Ayuda a sostener tasa para beber?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_D7',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_DClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_D0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '8. Reacciona a imagen en el espejo?',
                                                                        name: '8. Reacciona a imagen en el espejo?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_D8',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_DClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_D0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '9. Imita aplausos?<br>&nbsp;',
                                                                        name: '9. Imita aplausos?<br>',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_D9',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_DClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_D0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        html: '<hr>'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '10.Entrega juguetes al examinador?',
                                                                        name: '10.Entrega juguetes al examinador?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_D10',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_DClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_D0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '11.Pide un objeto o juguete?',
                                                                        name: '11.Pide un objeto o juguete?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_D11',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_DClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_D0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '12.Bebe en tasa solo?<br>&nbsp;',
                                                                        name: '12.Bebe en tasa solo',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_D12',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_DClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_D0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        html: '<hr>'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '13.Señala una prenda de vestir?',
                                                                        name: '13.Señala una prenda de vestir?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_D13',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_DClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_D0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '14.Señala dos partes del cuerpo?',
                                                                        name: '14.Señala dos partes del cuerpo?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_D14',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_DClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_D0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '15. Avisa higiene personal?<br>&nbsp;',
                                                                        name: '15. Avisa higiene personal?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_D15',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_DClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_D0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        html: '<hr>'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '16.Señala cinco partes del cuerpo?',
                                                                        name: '16.Señala cinco partes del cuerpo?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_D16',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_DClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_D0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '17.Trata de contar experiencias?',
                                                                        name: '17.Trata de contar experiencias?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_D17',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_DClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_D0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '18.Control diurno de orina?<br>&nbsp;',
                                                                        name: '18.Control diurno de orina?',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_D18',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_DClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_D0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        html: '<hr>'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '19.Diferencia niño-niña?<br>&nbsp;',
                                                                        name: '19.Diferencia niño-niña',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_D19',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_DClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_D0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '20.Dice nombre Papa-Mama?',
                                                                        name: '20.Dice nombre Papa-Mama',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_D20',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_DClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_D0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '21.Se lava solo Manos y Cara',
                                                                        name: '21.Se lava solo Manos y Cara',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_D21',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_DClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_D0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        html: '<hr>'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '22. Puede Desvestirse Solo<br>&nbsp;',
                                                                        name: '22. Puede Desvestirse Solo',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_D22',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_DClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_D0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '23. Comparte Juego con otros Niños',
                                                                        name: '23. Comparte Juego con otros Niños',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_D23',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_DClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_D0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '24. Tiene Amigo Especial<br>&nbsp;',
                                                                        name: '24. Tiene Amigo Especial',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_D24',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_DClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_D0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        html: '<hr>'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '25. Puede Vestirse y Desvestirse Solo',
                                                                        name: '25. Puede Vestirse y Desvestirse Solo',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_D25',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_DClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_D0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '26. Sabe Cuantos Años Tiene',
                                                                        name: '26. Sabe Cuantos Años Tiene',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_D26',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_DClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_D0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '27. Organiza Juegos<br>&nbsp;',
                                                                        name: '27. Organiza Juegos',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_D27',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_DClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_D0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        html: '<hr>'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '28. Hace Mandados<br>&nbsp;',
                                                                        name: '28. Hace Mandados',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_D28',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_DClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_D0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '29. Conoce Nombre Barrio o Pueblo de Recidencia',
                                                                        name: '29. Conoce Nombre Barrio o Pueblo de Recidencia',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_D29',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_DClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_D0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 50,
                                                                        fieldLabel: '30. Comenta Vida Familiar<br>&nbsp;',
                                                                        name: '30. Comenta Vida Familiar',
                                                                        allowBlank: true,
                                                                        store: 'StoreEscalaValoracion',
                                                                        valueField: 'Valor',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_D30',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null){
                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(0);
                                                                                    Ext.getCmp('strEVALDESACyD_DClasificacion').setValue(null);
                                                                                }else{
                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_D0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D30').getValue())); 
                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                    clasificacionEscala()
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            } //Escala Pesona Social
                                                        ]
                                                    }
                                                ]
                                            },
                                            { //rafa
                                                xtype: 'panel',
                                                layout: 'table',
                                                anchor: '100%',
                                                padding: 0,
                                                layoutConfig: {
                                                    columns: 3
                                                },
                                                autoHeight: true,
                                                items: [
                                                    {
                                                        xtype: 'panel',
                                                        layout: 'form',
                                                        width: 450,
                                                        autoHeight: true,
                                                        labelWidth: 200,
                                                        items: [ 
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        readOnly: true,
                                                                        name: 'Total Motricidad Gruesa',
                                                                        fieldLabel: 'Calificacion Motricidad Gruesa',
                                                                        width: 50,
                                                                        minValue: 0,
                                                                        decimalPrecision: 0,
                                                                        allowBlank: true,
                                                                        value: 0,
                                                                        id: 'intEVALDESACyD_ACalificacion'
                                                                    },
                                                                    {
                                                                        html: '-'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        readOnly: true,
                                                                        name: 'Clasificacion Motricidad Gruesa',
                                                                        width: 150,
                                                                        allowBlank: true,
                                                                        id: 'strEVALDESACyD_AClasificacion'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        readOnly: true,
                                                                        name: 'Total Motricidad Fina Adaptativa',
                                                                        fieldLabel: 'Total Motricidad Fina Adaptativa',
                                                                        width: 50,
                                                                        minValue: 0,
                                                                        value: 0,
                                                                        decimalPrecision: 0,
                                                                        allowBlank: true,
                                                                        id: 'intEVALDESACyD_BCalificacion'
                                                                    },
                                                                    {
                                                                        html: '-'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        readOnly: true,
                                                                        name: 'Clasificacion Motricidad Fina Adaptativa',
                                                                        width: 150,
                                                                        allowBlank: true,
                                                                        id: 'strEVALDESACyD_BClasificacion'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        readOnly: true,
                                                                        name: 'Total Audicion y Lenguaje',
                                                                        fieldLabel: 'Total Audicion y Lenguaje',
                                                                        width: 50,
                                                                        minValue: 0,
                                                                        value: 0,
                                                                        decimalPrecision: 0,
                                                                        allowBlank: true,
                                                                        id: 'intEVALDESACyD_CCalificacion'
                                                                    },
                                                                    {
                                                                        html: '-'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        readOnly: true,
                                                                        name: 'Clasificacion Audicion y Lenguaje',
                                                                        width: 150,
                                                                        allowBlank: true,
                                                                        id: 'strEVALDESACyD_CClasificacion'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        readOnly: true,
                                                                        name: 'Total Persona Social',
                                                                        fieldLabel: 'Total Persona Social',
                                                                        width: 50,
                                                                        minValue: 0,
                                                                        value: 0,
                                                                        decimalPrecision: 0,
                                                                        allowBlank: true,
                                                                        id: 'intEVALDESACyD_DCalificacion'
                                                                    },
                                                                    {
                                                                        html: '-'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        readOnly: true,
                                                                        name: 'Clasificacion Persona Social',
                                                                        width: 150,
                                                                        allowBlank: true,
                                                                        id: 'strEVALDESACyD_DClasificacion'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        readOnly: true,
                                                                        name: 'Total',
                                                                        fieldLabel: 'Total',
                                                                        width: 50,
                                                                        minValue: 0,
                                                                        value: 0,
                                                                        decimalPrecision: 0,
                                                                        allowBlank: true,
                                                                        id: 'intEVALDESACyD_TotalCalificacion'
                                                                    },
                                                                    {
                                                                        html: '-'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        readOnly: true,
                                                                        name: 'Clasificacion Total',
                                                                        width: 150,
                                                                        allowBlank: true,
                                                                        id: 'strEVALDESACyD_TotalClasificacion'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        title: '<center>CURVA PESO</center>',
                                                        layout: 'form',
                                                        width: 200,
                                                        autoHeight: true,
                                                        id: 'paFisExpCurPeso',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                forceSelection: true,
                                                                emptyText: 'SI/NO',
                                                                mode: 'local',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                listEmptyText: '',
                                                                triggerAction: 'all',
                                                                store:'StoreSiNo',
                                                                fieldLabel:'Satisfactoria',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                name:'Satisfactoria',
                                                                id: 'strCurPesoSatisfactorio'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        title: '<center>CURVA TALLA</center>',
                                                        layout: 'form',
                                                        width: 200,
                                                        autoHeight: true,
                                                        id: 'paFisExpCurTalla',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                forceSelection: true,
                                                                emptyText: 'SI/NO',
                                                                mode: 'local',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                listEmptyText: '',
                                                                triggerAction: 'all',
                                                                store:'StoreSiNo',
                                                                fieldLabel:'Satisfactoria',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                name:'Satisfactoria',
                                                                id: 'strCurTalSatisfactorio'
                                                            }
                                                        ]
                                                    }
                                                ],
                                                bbar:{
                                                    items: [
                                                        {
                                                            xtype: 'button',
                                                            text: 'Peso para Edad',
                                                            iconCls: 'btnGraficar',
                                                            listeners:{
                                                                click : function(){
                                                                    var valFecha1 = 0;
                                                                    var pFec2Anio = 0;
                                                                    var pFec2Mes = 0;
                                                                    var pFec2Dia = 0;
                                                                    var valFecha2 = 0;
                                                                    valFecha1 = Ext.getCmp('sysFechaHC').getValue();
                                                                    pFec2Anio = Ext.getCmp('sysFechaNac').getValue().substr(6,4);
                                                                    pFec2Mes = Ext.getCmp('sysFechaNac').getValue().substr(3,2);
                                                                    pFec2Dia = Ext.getCmp('sysFechaNac').getValue().substr(0,2);
                                                                    valFecha2 =  pFec2Anio + "/" + pFec2Mes + "/" + pFec2Dia;
                                                                    MesesCumplidosGrafica = MostrarEdadMeses(valFecha1, valFecha2);
                                                                    if(parseInt(MesesCumplidosGrafica) <= 24){
                                                                        window.open("../../../app/frm/pyp/frmchartscyd.php?pPaciente=" + Ext.getCmp('sysIdPacienteHC').getValue() + "&pGrafica=CYD001&pGenero=" + Ext.getCmp('sysGeneroPacHC').getValue(),"Grafica Peso para la Edad");
                                                                    }else{
                                                                        window.open("../../../app/frm/pyp/frmchartscyd.php?pPaciente=" + Ext.getCmp('sysIdPacienteHC').getValue() + "&pGrafica=CYD009&pGenero=" + Ext.getCmp('sysGeneroPacHC').getValue(),"Grafica Peso para la Edad");
                                                                    }
                                                                }
                                                            }
                                                        },
                                                        {
                                                            xtype: 'tbseparator'
                                                        },
                                                        {
                                                            xtype: 'button',
                                                            text: 'Talla para Edad',
                                                            iconCls: 'btnGraficar',
                                                            listeners:{
                                                                click : function(){
                                                                    var valFecha1 = 0;
                                                                    var pFec2Anio = 0;
                                                                    var pFec2Mes = 0;
                                                                    var pFec2Dia = 0;
                                                                    var valFecha2 = 0;
                                                                    valFecha1 = Ext.getCmp('sysFechaHC').getValue();
                                                                    pFec2Anio = Ext.getCmp('sysFechaNac').getValue().substr(6,4);
                                                                    pFec2Mes = Ext.getCmp('sysFechaNac').getValue().substr(3,2);
                                                                    pFec2Dia = Ext.getCmp('sysFechaNac').getValue().substr(0,2);
                                                                    valFecha2 =  pFec2Anio + "/" + pFec2Mes + "/" + pFec2Dia;
                                                                    MesesCumplidosGrafica = MostrarEdadMeses(valFecha1, valFecha2);
                                                                    if(parseInt(MesesCumplidosGrafica) <= 24){
                                                                        window.open("../../../app/frm/pyp/frmchartscyd.php?pPaciente=" + Ext.getCmp('sysIdPacienteHC').getValue() + "&pGrafica=CYD002&pGenero=" + Ext.getCmp('sysGeneroPacHC').getValue(),"Grafica Talla para la Edad");
                                                                    }else{
                                                                        if(parseInt(MesesCumplidosGrafica) <= 60){
                                                                            window.open("../../../app/frm/pyp/frmchartscyd.php?pPaciente=" + Ext.getCmp('sysIdPacienteHC').getValue() + "&pGrafica=CYD006&pGenero=" + Ext.getCmp('sysGeneroPacHC').getValue(),"Grafica Talla para la Edad");
                                                                        }else{
                                                                            window.open("../../../app/frm/pyp/frmchartscyd.php?pPaciente=" + Ext.getCmp('sysIdPacienteHC').getValue() + "&pGrafica=CYD010&pGenero=" + Ext.getCmp('sysGeneroPacHC').getValue(),"Grafica Talla para la Edad");
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        },
                                                        {
                                                            xtype: 'tbseparator'
                                                        },
                                                        {
                                                            xtype: 'button',
                                                            text: 'Peso para Talla',
                                                            iconCls: 'btnGraficar',
                                                            listeners:{
                                                                click : function(){
                                                                    var valFecha1 = 0;
                                                                    var pFec2Anio = 0;
                                                                    var pFec2Mes = 0;
                                                                    var pFec2Dia = 0;
                                                                    var valFecha2 = 0;
                                                                    valFecha1 = Ext.getCmp('sysFechaHC').getValue();
                                                                    pFec2Anio = Ext.getCmp('sysFechaNac').getValue().substr(6,4);
                                                                    pFec2Mes = Ext.getCmp('sysFechaNac').getValue().substr(3,2);
                                                                    pFec2Dia = Ext.getCmp('sysFechaNac').getValue().substr(0,2);
                                                                    valFecha2 =  pFec2Anio + "/" + pFec2Mes + "/" + pFec2Dia;
                                                                    MesesCumplidosGrafica = MostrarEdadMeses(valFecha1, valFecha2);
                                                                    if(parseInt(MesesCumplidosGrafica) <= 24){
                                                                        window.open("../../../app/frm/pyp/frmchartscyd.php?pPaciente=" + Ext.getCmp('sysIdPacienteHC').getValue() + "&pGrafica=CYD003&pGenero=" + Ext.getCmp('sysGeneroPacHC').getValue(),"Grafica Peso para la Talla");
                                                                    }else{
                                                                        window.open("../../../app/frm/pyp/frmchartscyd.php?pPaciente=" + Ext.getCmp('sysIdPacienteHC').getValue() + "&pGrafica=CYD007&pGenero=" + Ext.getCmp('sysGeneroPacHC').getValue(),"Grafica Peso para la Talla");
                                                                    }
                                                                }
                                                            }
                                                        },
                                                        {
                                                            xtype: 'tbseparator'
                                                        },
                                                        {
                                                            xtype: 'button',
                                                            text: 'IMC',
                                                            iconCls: 'btnGraficar',
                                                            listeners:{
                                                                click : function(){
                                                                    var valFecha1 = 0;
                                                                    var pFec2Anio = 0;
                                                                    var pFec2Mes = 0;
                                                                    var pFec2Dia = 0;
                                                                    var valFecha2 = 0;
                                                                    valFecha1 = Ext.getCmp('sysFechaHC').getValue();
                                                                    pFec2Anio = Ext.getCmp('sysFechaNac').getValue().substr(6,4);
                                                                    pFec2Mes = Ext.getCmp('sysFechaNac').getValue().substr(3,2);
                                                                    pFec2Dia = Ext.getCmp('sysFechaNac').getValue().substr(0,2);
                                                                    valFecha2 =  pFec2Anio + "/" + pFec2Mes + "/" + pFec2Dia;
                                                                    MesesCumplidosGrafica = MostrarEdadMeses(valFecha1, valFecha2);
                                                                    if(parseInt(MesesCumplidosGrafica) <= 24){
                                                                        window.open("../../../app/frm/pyp/frmchartscyd.php?pPaciente=" + Ext.getCmp('sysIdPacienteHC').getValue() + "&pGrafica=CYD004&pGenero=" + Ext.getCmp('sysGeneroPacHC').getValue(),"Grafica Peso para la Talla");
                                                                    }else{
                                                                        if(parseInt(MesesCumplidosGrafica) <= 60){
                                                                            window.open("../../../app/frm/pyp/frmchartscyd.php?pPaciente=" + Ext.getCmp('sysIdPacienteHC').getValue() + "&pGrafica=CYD008&pGenero=" + Ext.getCmp('sysGeneroPacHC').getValue(),"Grafica Peso para la Talla");
                                                                        }else{
                                                                            window.open("../../../app/frm/pyp/frmchartscyd.php?pPaciente=" + Ext.getCmp('sysIdPacienteHC').getValue() + "&pGrafica=CYD011&pGenero=" + Ext.getCmp('sysGeneroPacHC').getValue(),"Grafica Peso para la Talla");
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        },
                                                        {
                                                            xtype: 'tbseparator'
                                                        },
                                                        {
                                                            xtype: 'button',
                                                            text: 'Perimetro Cefalico',
                                                            iconCls: 'btnGraficar',
                                                            listeners:{
                                                                click : function(){
                                                                    window.open("../../../app/frm/pyp/frmchartscyd.php?pPaciente=" + Ext.getCmp('sysIdPacienteHC').getValue() + "&pGrafica=CYD005&pGenero=" + Ext.getCmp('sysGeneroPacHC').getValue(),"Grafica Peso para la Talla");
                                                                }
                                                            }
                                                        },
                                                        '->',
                                                        {
                                                            xtype: 'button',
                                                            iconCls: 'btnImprimir',
                                                            text: 'Imprimir Certificado',
                                                            tooltip: 'Imprimir Certificado',
                                                            id: 'btnPrintCertificadoCyDHC',
                                                            listeners:{
                                                                click : function(){
                                                                    if (parseInt(Ext.getCmp('sysYaGuardoHC').getValue()) === 1)
                                                                        window.open ("../../controlador/asistencial/printcertificacioncyd0.php?pEmpresa=" + ID_EMPRESA + "&pIPS=" + ID_IPS + "&pPaciente=" + Ext.getCmp('sysIdPacienteHC').getValue() + "&pCAS=" + Ext.getCmp('sysCASHC').getValue() + "&pConsecutivo=" + Ext.getCmp('sysConsecutivoDetalleHC').getValue(),"Incapacidad");
                                                                    else{
                                                                        Ext.Msg.show({
                                                                            title: 'eOfiClinic',
                                                                            msg: 'Usted No ha Guardado la Evolución',
                                                                            buttons: Ext.Msg.OK,
                                                                            icon: Ext.Msg.ERROR
                                                                        });
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    ]
                                                }
                                            },
                                            {
                                                html: '<br>'
                                            },
                                            {
                                                html: '<br>'
                                            },
                                            {
                                                xtype: 'panel',
                                                layout: 'table',
                                                title: '<center>ESCALA DE GOODENOUGH - HARRIS</center><br><center>CAPACIDAD VISUAL - MOTORA</center>',
                                                anchor: '100%',
                                                padding: 0,
                                                layoutConfig: {
                                                    columns: 2
                                                },
                                                autoHeight: true,
                                                items: [
                                                    {
                                                        xtype: 'panel',
                                                        layout: 'form',
                                                        labelWidth: 250,
                                                        width: 450,
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                width: 50,
                                                                fieldLabel: 'Cabeza',
                                                                name: 'Cabeza',
                                                                allowBlank: true,
                                                                store: 'StoreEscalaValoracion',
                                                                valueField: 'Valor',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: 0,
                                                                id: 'intCabeza',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        if(pNew == null){
                                                                            Ext.getCmp('intPuntajeEscalaTotal').setValue(0);
                                                                        }else{
                                                                            Ext.getCmp('intPuntajeEscalaTotal').setValue(parseInt(Ext.getCmp('intCabeza').getValue()) + parseInt(Ext.getCmp('intPiernas').getValue()) + parseInt(Ext.getCmp('intBrazos').getValue()) + parseInt(Ext.getCmp('intTroncoPresente').getValue()) + parseInt(Ext.getCmp('intMayorLongitudAncho').getValue()) + parseInt(Ext.getCmp('intHombros').getValue()) + parseInt(Ext.getCmp('intMMSSUnidosTronco').getValue()) + parseInt(Ext.getCmp('intMMSSLugar').getValue()) + parseInt(Ext.getCmp('intCuelloPresente').getValue()) + parseInt(Ext.getCmp('intCuelloLugar').getValue()) + parseInt(Ext.getCmp('intOjos').getValue()) + parseInt(Ext.getCmp('intNariz').getValue()) + parseInt(Ext.getCmp('intBoca').getValue()) + parseInt(Ext.getCmp('int1213DosDimenciones').getValue()) + parseInt(Ext.getCmp('intOrificiosNasales').getValue()) + parseInt(Ext.getCmp('intPeloPresente').getValue()) + parseInt(Ext.getCmp('intPeloMejorDefinido').getValue()) + parseInt(Ext.getCmp('intManoDiferenteBrazo').getValue()) + parseInt(Ext.getCmp('intArticulacionCodoHombro').getValue()) + parseInt(Ext.getCmp('intCaderaRodilla').getValue()) + parseInt(Ext.getCmp('intCabezaAreaTronco').getValue()) + parseInt(Ext.getCmp('intBrazosIgualTronco').getValue()) + parseInt(Ext.getCmp('intPiernasTronco').getValue()) + parseInt(Ext.getCmp('intPiePierna').getValue()) + parseInt(Ext.getCmp('intBrazosPiernas2Dimensiones').getValue()) + parseInt(Ext.getCmp('intTalon').getValue()) + parseInt(Ext.getCmp('intLineasFirmesConectadas').getValue()) + parseInt(Ext.getCmp('intUnionesCorrectas').getValue()) + parseInt(Ext.getCmp('intPerfilCabeza').getValue()) + parseInt(Ext.getCmp('intPerfilTronco').getValue()) + parseInt(Ext.getCmp('intPerfilBrazosPiernas').getValue()) + parseInt(Ext.getCmp('intRasgos').getValue()) + parseInt(Ext.getCmp('intOidoPresente').getValue()) + parseInt(Ext.getCmp('intPocisionProporcionCorrectasOidos').getValue()));
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 50,
                                                                fieldLabel: 'Piernas(2)',
                                                                name: 'Piernas(2)',
                                                                allowBlank: true,
                                                                store: 'StoreEscalaValoracion',
                                                                valueField: 'Valor',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: 0,
                                                                id: 'intPiernas',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        if(pNew == null){
                                                                            Ext.getCmp('intPuntajeEscalaTotal').setValue(0);
                                                                        }else{
                                                                            Ext.getCmp('intPuntajeEscalaTotal').setValue(parseInt(Ext.getCmp('intCabeza').getValue()) + parseInt(Ext.getCmp('intPiernas').getValue()) + parseInt(Ext.getCmp('intBrazos').getValue()) + parseInt(Ext.getCmp('intTroncoPresente').getValue()) + parseInt(Ext.getCmp('intMayorLongitudAncho').getValue()) + parseInt(Ext.getCmp('intHombros').getValue()) + parseInt(Ext.getCmp('intMMSSUnidosTronco').getValue()) + parseInt(Ext.getCmp('intMMSSLugar').getValue()) + parseInt(Ext.getCmp('intCuelloPresente').getValue()) + parseInt(Ext.getCmp('intCuelloLugar').getValue()) + parseInt(Ext.getCmp('intOjos').getValue()) + parseInt(Ext.getCmp('intNariz').getValue()) + parseInt(Ext.getCmp('intBoca').getValue()) + parseInt(Ext.getCmp('int1213DosDimenciones').getValue()) + parseInt(Ext.getCmp('intOrificiosNasales').getValue()) + parseInt(Ext.getCmp('intPeloPresente').getValue()) + parseInt(Ext.getCmp('intPeloMejorDefinido').getValue()) + parseInt(Ext.getCmp('intManoDiferenteBrazo').getValue()) + parseInt(Ext.getCmp('intArticulacionCodoHombro').getValue()) + parseInt(Ext.getCmp('intCaderaRodilla').getValue()) + parseInt(Ext.getCmp('intCabezaAreaTronco').getValue()) + parseInt(Ext.getCmp('intBrazosIgualTronco').getValue()) + parseInt(Ext.getCmp('intPiernasTronco').getValue()) + parseInt(Ext.getCmp('intPiePierna').getValue()) + parseInt(Ext.getCmp('intBrazosPiernas2Dimensiones').getValue()) + parseInt(Ext.getCmp('intTalon').getValue()) + parseInt(Ext.getCmp('intLineasFirmesConectadas').getValue()) + parseInt(Ext.getCmp('intUnionesCorrectas').getValue()) + parseInt(Ext.getCmp('intPerfilCabeza').getValue()) + parseInt(Ext.getCmp('intPerfilTronco').getValue()) + parseInt(Ext.getCmp('intPerfilBrazosPiernas').getValue()) + parseInt(Ext.getCmp('intRasgos').getValue()) + parseInt(Ext.getCmp('intOidoPresente').getValue()) + parseInt(Ext.getCmp('intPocisionProporcionCorrectasOidos').getValue()));
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 50,
                                                                fieldLabel: 'Brazos(2)',
                                                                name: 'Brazos(2)',
                                                                allowBlank: true,
                                                                store: 'StoreEscalaValoracion',
                                                                valueField: 'Valor',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: 0,
                                                                id: 'intBrazos',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        if(pNew == null){
                                                                            Ext.getCmp('intPuntajeEscalaTotal').setValue(0);
                                                                        }else{
                                                                            Ext.getCmp('intPuntajeEscalaTotal').setValue(parseInt(Ext.getCmp('intCabeza').getValue()) + parseInt(Ext.getCmp('intPiernas').getValue()) + parseInt(Ext.getCmp('intBrazos').getValue()) + parseInt(Ext.getCmp('intTroncoPresente').getValue()) + parseInt(Ext.getCmp('intMayorLongitudAncho').getValue()) + parseInt(Ext.getCmp('intHombros').getValue()) + parseInt(Ext.getCmp('intMMSSUnidosTronco').getValue()) + parseInt(Ext.getCmp('intMMSSLugar').getValue()) + parseInt(Ext.getCmp('intCuelloPresente').getValue()) + parseInt(Ext.getCmp('intCuelloLugar').getValue()) + parseInt(Ext.getCmp('intOjos').getValue()) + parseInt(Ext.getCmp('intNariz').getValue()) + parseInt(Ext.getCmp('intBoca').getValue()) + parseInt(Ext.getCmp('int1213DosDimenciones').getValue()) + parseInt(Ext.getCmp('intOrificiosNasales').getValue()) + parseInt(Ext.getCmp('intPeloPresente').getValue()) + parseInt(Ext.getCmp('intPeloMejorDefinido').getValue()) + parseInt(Ext.getCmp('intManoDiferenteBrazo').getValue()) + parseInt(Ext.getCmp('intArticulacionCodoHombro').getValue()) + parseInt(Ext.getCmp('intCaderaRodilla').getValue()) + parseInt(Ext.getCmp('intCabezaAreaTronco').getValue()) + parseInt(Ext.getCmp('intBrazosIgualTronco').getValue()) + parseInt(Ext.getCmp('intPiernasTronco').getValue()) + parseInt(Ext.getCmp('intPiePierna').getValue()) + parseInt(Ext.getCmp('intBrazosPiernas2Dimensiones').getValue()) + parseInt(Ext.getCmp('intTalon').getValue()) + parseInt(Ext.getCmp('intLineasFirmesConectadas').getValue()) + parseInt(Ext.getCmp('intUnionesCorrectas').getValue()) + parseInt(Ext.getCmp('intPerfilCabeza').getValue()) + parseInt(Ext.getCmp('intPerfilTronco').getValue()) + parseInt(Ext.getCmp('intPerfilBrazosPiernas').getValue()) + parseInt(Ext.getCmp('intRasgos').getValue()) + parseInt(Ext.getCmp('intOidoPresente').getValue()) + parseInt(Ext.getCmp('intPocisionProporcionCorrectasOidos').getValue()));
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 50,
                                                                fieldLabel: 'Tronco Presente',
                                                                name: 'Tronco Presente',
                                                                allowBlank: true,
                                                                store: 'StoreEscalaValoracion',
                                                                valueField: 'Valor',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: 0,
                                                                id: 'intTroncoPresente',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        if(pNew == null){
                                                                            Ext.getCmp('intPuntajeEscalaTotal').setValue(0);
                                                                        }else{
                                                                            Ext.getCmp('intPuntajeEscalaTotal').setValue(parseInt(Ext.getCmp('intCabeza').getValue()) + parseInt(Ext.getCmp('intPiernas').getValue()) + parseInt(Ext.getCmp('intBrazos').getValue()) + parseInt(Ext.getCmp('intTroncoPresente').getValue()) + parseInt(Ext.getCmp('intMayorLongitudAncho').getValue()) + parseInt(Ext.getCmp('intHombros').getValue()) + parseInt(Ext.getCmp('intMMSSUnidosTronco').getValue()) + parseInt(Ext.getCmp('intMMSSLugar').getValue()) + parseInt(Ext.getCmp('intCuelloPresente').getValue()) + parseInt(Ext.getCmp('intCuelloLugar').getValue()) + parseInt(Ext.getCmp('intOjos').getValue()) + parseInt(Ext.getCmp('intNariz').getValue()) + parseInt(Ext.getCmp('intBoca').getValue()) + parseInt(Ext.getCmp('int1213DosDimenciones').getValue()) + parseInt(Ext.getCmp('intOrificiosNasales').getValue()) + parseInt(Ext.getCmp('intPeloPresente').getValue()) + parseInt(Ext.getCmp('intPeloMejorDefinido').getValue()) + parseInt(Ext.getCmp('intManoDiferenteBrazo').getValue()) + parseInt(Ext.getCmp('intArticulacionCodoHombro').getValue()) + parseInt(Ext.getCmp('intCaderaRodilla').getValue()) + parseInt(Ext.getCmp('intCabezaAreaTronco').getValue()) + parseInt(Ext.getCmp('intBrazosIgualTronco').getValue()) + parseInt(Ext.getCmp('intPiernasTronco').getValue()) + parseInt(Ext.getCmp('intPiePierna').getValue()) + parseInt(Ext.getCmp('intBrazosPiernas2Dimensiones').getValue()) + parseInt(Ext.getCmp('intTalon').getValue()) + parseInt(Ext.getCmp('intLineasFirmesConectadas').getValue()) + parseInt(Ext.getCmp('intUnionesCorrectas').getValue()) + parseInt(Ext.getCmp('intPerfilCabeza').getValue()) + parseInt(Ext.getCmp('intPerfilTronco').getValue()) + parseInt(Ext.getCmp('intPerfilBrazosPiernas').getValue()) + parseInt(Ext.getCmp('intRasgos').getValue()) + parseInt(Ext.getCmp('intOidoPresente').getValue()) + parseInt(Ext.getCmp('intPocisionProporcionCorrectasOidos').getValue()));
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 50,
                                                                fieldLabel: 'Mayor Longitud que Ancho',
                                                                name: 'Mayor Longitud que Ancho',
                                                                allowBlank: true,
                                                                store: 'StoreEscalaValoracion',
                                                                valueField: 'Valor',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: 0,
                                                                id: 'intMayorLongitudAncho',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        if(pNew == null){
                                                                            Ext.getCmp('intPuntajeEscalaTotal').setValue(0);
                                                                        }else{
                                                                            Ext.getCmp('intPuntajeEscalaTotal').setValue(parseInt(Ext.getCmp('intCabeza').getValue()) + parseInt(Ext.getCmp('intPiernas').getValue()) + parseInt(Ext.getCmp('intBrazos').getValue()) + parseInt(Ext.getCmp('intTroncoPresente').getValue()) + parseInt(Ext.getCmp('intMayorLongitudAncho').getValue()) + parseInt(Ext.getCmp('intHombros').getValue()) + parseInt(Ext.getCmp('intMMSSUnidosTronco').getValue()) + parseInt(Ext.getCmp('intMMSSLugar').getValue()) + parseInt(Ext.getCmp('intCuelloPresente').getValue()) + parseInt(Ext.getCmp('intCuelloLugar').getValue()) + parseInt(Ext.getCmp('intOjos').getValue()) + parseInt(Ext.getCmp('intNariz').getValue()) + parseInt(Ext.getCmp('intBoca').getValue()) + parseInt(Ext.getCmp('int1213DosDimenciones').getValue()) + parseInt(Ext.getCmp('intOrificiosNasales').getValue()) + parseInt(Ext.getCmp('intPeloPresente').getValue()) + parseInt(Ext.getCmp('intPeloMejorDefinido').getValue()) + parseInt(Ext.getCmp('intManoDiferenteBrazo').getValue()) + parseInt(Ext.getCmp('intArticulacionCodoHombro').getValue()) + parseInt(Ext.getCmp('intCaderaRodilla').getValue()) + parseInt(Ext.getCmp('intCabezaAreaTronco').getValue()) + parseInt(Ext.getCmp('intBrazosIgualTronco').getValue()) + parseInt(Ext.getCmp('intPiernasTronco').getValue()) + parseInt(Ext.getCmp('intPiePierna').getValue()) + parseInt(Ext.getCmp('intBrazosPiernas2Dimensiones').getValue()) + parseInt(Ext.getCmp('intTalon').getValue()) + parseInt(Ext.getCmp('intLineasFirmesConectadas').getValue()) + parseInt(Ext.getCmp('intUnionesCorrectas').getValue()) + parseInt(Ext.getCmp('intPerfilCabeza').getValue()) + parseInt(Ext.getCmp('intPerfilTronco').getValue()) + parseInt(Ext.getCmp('intPerfilBrazosPiernas').getValue()) + parseInt(Ext.getCmp('intRasgos').getValue()) + parseInt(Ext.getCmp('intOidoPresente').getValue()) + parseInt(Ext.getCmp('intPocisionProporcionCorrectasOidos').getValue()));
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 50,
                                                                fieldLabel: 'Hombros',
                                                                name: 'Hombros',
                                                                allowBlank: true,
                                                                store: 'StoreEscalaValoracion',
                                                                valueField: 'Valor',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: 0,
                                                                id: 'intHombros',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        if(pNew == null){
                                                                            Ext.getCmp('intPuntajeEscalaTotal').setValue(0);
                                                                        }else{
                                                                            Ext.getCmp('intPuntajeEscalaTotal').setValue(parseInt(Ext.getCmp('intCabeza').getValue()) + parseInt(Ext.getCmp('intPiernas').getValue()) + parseInt(Ext.getCmp('intBrazos').getValue()) + parseInt(Ext.getCmp('intTroncoPresente').getValue()) + parseInt(Ext.getCmp('intMayorLongitudAncho').getValue()) + parseInt(Ext.getCmp('intHombros').getValue()) + parseInt(Ext.getCmp('intMMSSUnidosTronco').getValue()) + parseInt(Ext.getCmp('intMMSSLugar').getValue()) + parseInt(Ext.getCmp('intCuelloPresente').getValue()) + parseInt(Ext.getCmp('intCuelloLugar').getValue()) + parseInt(Ext.getCmp('intOjos').getValue()) + parseInt(Ext.getCmp('intNariz').getValue()) + parseInt(Ext.getCmp('intBoca').getValue()) + parseInt(Ext.getCmp('int1213DosDimenciones').getValue()) + parseInt(Ext.getCmp('intOrificiosNasales').getValue()) + parseInt(Ext.getCmp('intPeloPresente').getValue()) + parseInt(Ext.getCmp('intPeloMejorDefinido').getValue()) + parseInt(Ext.getCmp('intManoDiferenteBrazo').getValue()) + parseInt(Ext.getCmp('intArticulacionCodoHombro').getValue()) + parseInt(Ext.getCmp('intCaderaRodilla').getValue()) + parseInt(Ext.getCmp('intCabezaAreaTronco').getValue()) + parseInt(Ext.getCmp('intBrazosIgualTronco').getValue()) + parseInt(Ext.getCmp('intPiernasTronco').getValue()) + parseInt(Ext.getCmp('intPiePierna').getValue()) + parseInt(Ext.getCmp('intBrazosPiernas2Dimensiones').getValue()) + parseInt(Ext.getCmp('intTalon').getValue()) + parseInt(Ext.getCmp('intLineasFirmesConectadas').getValue()) + parseInt(Ext.getCmp('intUnionesCorrectas').getValue()) + parseInt(Ext.getCmp('intPerfilCabeza').getValue()) + parseInt(Ext.getCmp('intPerfilTronco').getValue()) + parseInt(Ext.getCmp('intPerfilBrazosPiernas').getValue()) + parseInt(Ext.getCmp('intRasgos').getValue()) + parseInt(Ext.getCmp('intOidoPresente').getValue()) + parseInt(Ext.getCmp('intPocisionProporcionCorrectasOidos').getValue()));
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 50,
                                                                fieldLabel: 'MMSS Unidos al Tronco',
                                                                name: 'MMSS Unidos al Tronco',
                                                                allowBlank: true,
                                                                store: 'StoreEscalaValoracion',
                                                                valueField: 'Valor',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: 0,
                                                                id: 'intMMSSUnidosTronco',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        if(pNew == null){
                                                                            Ext.getCmp('intPuntajeEscalaTotal').setValue(0);
                                                                        }else{
                                                                            Ext.getCmp('intPuntajeEscalaTotal').setValue(parseInt(Ext.getCmp('intCabeza').getValue()) + parseInt(Ext.getCmp('intPiernas').getValue()) + parseInt(Ext.getCmp('intBrazos').getValue()) + parseInt(Ext.getCmp('intTroncoPresente').getValue()) + parseInt(Ext.getCmp('intMayorLongitudAncho').getValue()) + parseInt(Ext.getCmp('intHombros').getValue()) + parseInt(Ext.getCmp('intMMSSUnidosTronco').getValue()) + parseInt(Ext.getCmp('intMMSSLugar').getValue()) + parseInt(Ext.getCmp('intCuelloPresente').getValue()) + parseInt(Ext.getCmp('intCuelloLugar').getValue()) + parseInt(Ext.getCmp('intOjos').getValue()) + parseInt(Ext.getCmp('intNariz').getValue()) + parseInt(Ext.getCmp('intBoca').getValue()) + parseInt(Ext.getCmp('int1213DosDimenciones').getValue()) + parseInt(Ext.getCmp('intOrificiosNasales').getValue()) + parseInt(Ext.getCmp('intPeloPresente').getValue()) + parseInt(Ext.getCmp('intPeloMejorDefinido').getValue()) + parseInt(Ext.getCmp('intManoDiferenteBrazo').getValue()) + parseInt(Ext.getCmp('intArticulacionCodoHombro').getValue()) + parseInt(Ext.getCmp('intCaderaRodilla').getValue()) + parseInt(Ext.getCmp('intCabezaAreaTronco').getValue()) + parseInt(Ext.getCmp('intBrazosIgualTronco').getValue()) + parseInt(Ext.getCmp('intPiernasTronco').getValue()) + parseInt(Ext.getCmp('intPiePierna').getValue()) + parseInt(Ext.getCmp('intBrazosPiernas2Dimensiones').getValue()) + parseInt(Ext.getCmp('intTalon').getValue()) + parseInt(Ext.getCmp('intLineasFirmesConectadas').getValue()) + parseInt(Ext.getCmp('intUnionesCorrectas').getValue()) + parseInt(Ext.getCmp('intPerfilCabeza').getValue()) + parseInt(Ext.getCmp('intPerfilTronco').getValue()) + parseInt(Ext.getCmp('intPerfilBrazosPiernas').getValue()) + parseInt(Ext.getCmp('intRasgos').getValue()) + parseInt(Ext.getCmp('intOidoPresente').getValue()) + parseInt(Ext.getCmp('intPocisionProporcionCorrectasOidos').getValue()));
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 50,
                                                                fieldLabel: 'MMSS en su Lugar',
                                                                name: 'MMSS en su Lugar',
                                                                allowBlank: true,
                                                                store: 'StoreEscalaValoracion',
                                                                valueField: 'Valor',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: 0,
                                                                id: 'intMMSSLugar',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        if(pNew == null){
                                                                            Ext.getCmp('intPuntajeEscalaTotal').setValue(0);
                                                                        }else{
                                                                            Ext.getCmp('intPuntajeEscalaTotal').setValue(parseInt(Ext.getCmp('intCabeza').getValue()) + parseInt(Ext.getCmp('intPiernas').getValue()) + parseInt(Ext.getCmp('intBrazos').getValue()) + parseInt(Ext.getCmp('intTroncoPresente').getValue()) + parseInt(Ext.getCmp('intMayorLongitudAncho').getValue()) + parseInt(Ext.getCmp('intHombros').getValue()) + parseInt(Ext.getCmp('intMMSSUnidosTronco').getValue()) + parseInt(Ext.getCmp('intMMSSLugar').getValue()) + parseInt(Ext.getCmp('intCuelloPresente').getValue()) + parseInt(Ext.getCmp('intCuelloLugar').getValue()) + parseInt(Ext.getCmp('intOjos').getValue()) + parseInt(Ext.getCmp('intNariz').getValue()) + parseInt(Ext.getCmp('intBoca').getValue()) + parseInt(Ext.getCmp('int1213DosDimenciones').getValue()) + parseInt(Ext.getCmp('intOrificiosNasales').getValue()) + parseInt(Ext.getCmp('intPeloPresente').getValue()) + parseInt(Ext.getCmp('intPeloMejorDefinido').getValue()) + parseInt(Ext.getCmp('intManoDiferenteBrazo').getValue()) + parseInt(Ext.getCmp('intArticulacionCodoHombro').getValue()) + parseInt(Ext.getCmp('intCaderaRodilla').getValue()) + parseInt(Ext.getCmp('intCabezaAreaTronco').getValue()) + parseInt(Ext.getCmp('intBrazosIgualTronco').getValue()) + parseInt(Ext.getCmp('intPiernasTronco').getValue()) + parseInt(Ext.getCmp('intPiePierna').getValue()) + parseInt(Ext.getCmp('intBrazosPiernas2Dimensiones').getValue()) + parseInt(Ext.getCmp('intTalon').getValue()) + parseInt(Ext.getCmp('intLineasFirmesConectadas').getValue()) + parseInt(Ext.getCmp('intUnionesCorrectas').getValue()) + parseInt(Ext.getCmp('intPerfilCabeza').getValue()) + parseInt(Ext.getCmp('intPerfilTronco').getValue()) + parseInt(Ext.getCmp('intPerfilBrazosPiernas').getValue()) + parseInt(Ext.getCmp('intRasgos').getValue()) + parseInt(Ext.getCmp('intOidoPresente').getValue()) + parseInt(Ext.getCmp('intPocisionProporcionCorrectasOidos').getValue()));
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 50,
                                                                fieldLabel: 'Cuello Presente',
                                                                name: 'Cuello Presente',
                                                                allowBlank: true,
                                                                store: 'StoreEscalaValoracion',
                                                                valueField: 'Valor',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: 0,
                                                                id: 'intCuelloPresente',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        if(pNew == null){
                                                                            Ext.getCmp('intPuntajeEscalaTotal').setValue(0);
                                                                        }else{
                                                                            Ext.getCmp('intPuntajeEscalaTotal').setValue(parseInt(Ext.getCmp('intCabeza').getValue()) + parseInt(Ext.getCmp('intPiernas').getValue()) + parseInt(Ext.getCmp('intBrazos').getValue()) + parseInt(Ext.getCmp('intTroncoPresente').getValue()) + parseInt(Ext.getCmp('intMayorLongitudAncho').getValue()) + parseInt(Ext.getCmp('intHombros').getValue()) + parseInt(Ext.getCmp('intMMSSUnidosTronco').getValue()) + parseInt(Ext.getCmp('intMMSSLugar').getValue()) + parseInt(Ext.getCmp('intCuelloPresente').getValue()) + parseInt(Ext.getCmp('intCuelloLugar').getValue()) + parseInt(Ext.getCmp('intOjos').getValue()) + parseInt(Ext.getCmp('intNariz').getValue()) + parseInt(Ext.getCmp('intBoca').getValue()) + parseInt(Ext.getCmp('int1213DosDimenciones').getValue()) + parseInt(Ext.getCmp('intOrificiosNasales').getValue()) + parseInt(Ext.getCmp('intPeloPresente').getValue()) + parseInt(Ext.getCmp('intPeloMejorDefinido').getValue()) + parseInt(Ext.getCmp('intManoDiferenteBrazo').getValue()) + parseInt(Ext.getCmp('intArticulacionCodoHombro').getValue()) + parseInt(Ext.getCmp('intCaderaRodilla').getValue()) + parseInt(Ext.getCmp('intCabezaAreaTronco').getValue()) + parseInt(Ext.getCmp('intBrazosIgualTronco').getValue()) + parseInt(Ext.getCmp('intPiernasTronco').getValue()) + parseInt(Ext.getCmp('intPiePierna').getValue()) + parseInt(Ext.getCmp('intBrazosPiernas2Dimensiones').getValue()) + parseInt(Ext.getCmp('intTalon').getValue()) + parseInt(Ext.getCmp('intLineasFirmesConectadas').getValue()) + parseInt(Ext.getCmp('intUnionesCorrectas').getValue()) + parseInt(Ext.getCmp('intPerfilCabeza').getValue()) + parseInt(Ext.getCmp('intPerfilTronco').getValue()) + parseInt(Ext.getCmp('intPerfilBrazosPiernas').getValue()) + parseInt(Ext.getCmp('intRasgos').getValue()) + parseInt(Ext.getCmp('intOidoPresente').getValue()) + parseInt(Ext.getCmp('intPocisionProporcionCorrectasOidos').getValue()));
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 50,
                                                                fieldLabel: 'Cuello en su Lugar',
                                                                name: 'Cuello en su Lugar',
                                                                allowBlank: true,
                                                                store: 'StoreEscalaValoracion',
                                                                valueField: 'Valor',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: 0,
                                                                id: 'intCuelloLugar',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        if(pNew == null){
                                                                            Ext.getCmp('intPuntajeEscalaTotal').setValue(0);
                                                                        }else{
                                                                            Ext.getCmp('intPuntajeEscalaTotal').setValue(parseInt(Ext.getCmp('intCabeza').getValue()) + parseInt(Ext.getCmp('intPiernas').getValue()) + parseInt(Ext.getCmp('intBrazos').getValue()) + parseInt(Ext.getCmp('intTroncoPresente').getValue()) + parseInt(Ext.getCmp('intMayorLongitudAncho').getValue()) + parseInt(Ext.getCmp('intHombros').getValue()) + parseInt(Ext.getCmp('intMMSSUnidosTronco').getValue()) + parseInt(Ext.getCmp('intMMSSLugar').getValue()) + parseInt(Ext.getCmp('intCuelloPresente').getValue()) + parseInt(Ext.getCmp('intCuelloLugar').getValue()) + parseInt(Ext.getCmp('intOjos').getValue()) + parseInt(Ext.getCmp('intNariz').getValue()) + parseInt(Ext.getCmp('intBoca').getValue()) + parseInt(Ext.getCmp('int1213DosDimenciones').getValue()) + parseInt(Ext.getCmp('intOrificiosNasales').getValue()) + parseInt(Ext.getCmp('intPeloPresente').getValue()) + parseInt(Ext.getCmp('intPeloMejorDefinido').getValue()) + parseInt(Ext.getCmp('intManoDiferenteBrazo').getValue()) + parseInt(Ext.getCmp('intArticulacionCodoHombro').getValue()) + parseInt(Ext.getCmp('intCaderaRodilla').getValue()) + parseInt(Ext.getCmp('intCabezaAreaTronco').getValue()) + parseInt(Ext.getCmp('intBrazosIgualTronco').getValue()) + parseInt(Ext.getCmp('intPiernasTronco').getValue()) + parseInt(Ext.getCmp('intPiePierna').getValue()) + parseInt(Ext.getCmp('intBrazosPiernas2Dimensiones').getValue()) + parseInt(Ext.getCmp('intTalon').getValue()) + parseInt(Ext.getCmp('intLineasFirmesConectadas').getValue()) + parseInt(Ext.getCmp('intUnionesCorrectas').getValue()) + parseInt(Ext.getCmp('intPerfilCabeza').getValue()) + parseInt(Ext.getCmp('intPerfilTronco').getValue()) + parseInt(Ext.getCmp('intPerfilBrazosPiernas').getValue()) + parseInt(Ext.getCmp('intRasgos').getValue()) + parseInt(Ext.getCmp('intOidoPresente').getValue()) + parseInt(Ext.getCmp('intPocisionProporcionCorrectasOidos').getValue()));
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 50,
                                                                fieldLabel: 'Ojos',
                                                                name: 'Ojos',
                                                                allowBlank: true,
                                                                store: 'StoreEscalaValoracion',
                                                                valueField: 'Valor',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: 0,
                                                                id: 'intOjos',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        if(pNew == null){
                                                                            Ext.getCmp('intPuntajeEscalaTotal').setValue(0);
                                                                        }else{
                                                                            Ext.getCmp('intPuntajeEscalaTotal').setValue(parseInt(Ext.getCmp('intCabeza').getValue()) + parseInt(Ext.getCmp('intPiernas').getValue()) + parseInt(Ext.getCmp('intBrazos').getValue()) + parseInt(Ext.getCmp('intTroncoPresente').getValue()) + parseInt(Ext.getCmp('intMayorLongitudAncho').getValue()) + parseInt(Ext.getCmp('intHombros').getValue()) + parseInt(Ext.getCmp('intMMSSUnidosTronco').getValue()) + parseInt(Ext.getCmp('intMMSSLugar').getValue()) + parseInt(Ext.getCmp('intCuelloPresente').getValue()) + parseInt(Ext.getCmp('intCuelloLugar').getValue()) + parseInt(Ext.getCmp('intOjos').getValue()) + parseInt(Ext.getCmp('intNariz').getValue()) + parseInt(Ext.getCmp('intBoca').getValue()) + parseInt(Ext.getCmp('int1213DosDimenciones').getValue()) + parseInt(Ext.getCmp('intOrificiosNasales').getValue()) + parseInt(Ext.getCmp('intPeloPresente').getValue()) + parseInt(Ext.getCmp('intPeloMejorDefinido').getValue()) + parseInt(Ext.getCmp('intManoDiferenteBrazo').getValue()) + parseInt(Ext.getCmp('intArticulacionCodoHombro').getValue()) + parseInt(Ext.getCmp('intCaderaRodilla').getValue()) + parseInt(Ext.getCmp('intCabezaAreaTronco').getValue()) + parseInt(Ext.getCmp('intBrazosIgualTronco').getValue()) + parseInt(Ext.getCmp('intPiernasTronco').getValue()) + parseInt(Ext.getCmp('intPiePierna').getValue()) + parseInt(Ext.getCmp('intBrazosPiernas2Dimensiones').getValue()) + parseInt(Ext.getCmp('intTalon').getValue()) + parseInt(Ext.getCmp('intLineasFirmesConectadas').getValue()) + parseInt(Ext.getCmp('intUnionesCorrectas').getValue()) + parseInt(Ext.getCmp('intPerfilCabeza').getValue()) + parseInt(Ext.getCmp('intPerfilTronco').getValue()) + parseInt(Ext.getCmp('intPerfilBrazosPiernas').getValue()) + parseInt(Ext.getCmp('intRasgos').getValue()) + parseInt(Ext.getCmp('intOidoPresente').getValue()) + parseInt(Ext.getCmp('intPocisionProporcionCorrectasOidos').getValue()));
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 50,
                                                                fieldLabel: 'Nariz',
                                                                name: 'Nariz',
                                                                allowBlank: true,
                                                                store: 'StoreEscalaValoracion',
                                                                valueField: 'Valor',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: 0,
                                                                id: 'intNariz',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        if(pNew == null){
                                                                            Ext.getCmp('intPuntajeEscalaTotal').setValue(0);
                                                                        }else{
                                                                            Ext.getCmp('intPuntajeEscalaTotal').setValue(parseInt(Ext.getCmp('intCabeza').getValue()) + parseInt(Ext.getCmp('intPiernas').getValue()) + parseInt(Ext.getCmp('intBrazos').getValue()) + parseInt(Ext.getCmp('intTroncoPresente').getValue()) + parseInt(Ext.getCmp('intMayorLongitudAncho').getValue()) + parseInt(Ext.getCmp('intHombros').getValue()) + parseInt(Ext.getCmp('intMMSSUnidosTronco').getValue()) + parseInt(Ext.getCmp('intMMSSLugar').getValue()) + parseInt(Ext.getCmp('intCuelloPresente').getValue()) + parseInt(Ext.getCmp('intCuelloLugar').getValue()) + parseInt(Ext.getCmp('intOjos').getValue()) + parseInt(Ext.getCmp('intNariz').getValue()) + parseInt(Ext.getCmp('intBoca').getValue()) + parseInt(Ext.getCmp('int1213DosDimenciones').getValue()) + parseInt(Ext.getCmp('intOrificiosNasales').getValue()) + parseInt(Ext.getCmp('intPeloPresente').getValue()) + parseInt(Ext.getCmp('intPeloMejorDefinido').getValue()) + parseInt(Ext.getCmp('intManoDiferenteBrazo').getValue()) + parseInt(Ext.getCmp('intArticulacionCodoHombro').getValue()) + parseInt(Ext.getCmp('intCaderaRodilla').getValue()) + parseInt(Ext.getCmp('intCabezaAreaTronco').getValue()) + parseInt(Ext.getCmp('intBrazosIgualTronco').getValue()) + parseInt(Ext.getCmp('intPiernasTronco').getValue()) + parseInt(Ext.getCmp('intPiePierna').getValue()) + parseInt(Ext.getCmp('intBrazosPiernas2Dimensiones').getValue()) + parseInt(Ext.getCmp('intTalon').getValue()) + parseInt(Ext.getCmp('intLineasFirmesConectadas').getValue()) + parseInt(Ext.getCmp('intUnionesCorrectas').getValue()) + parseInt(Ext.getCmp('intPerfilCabeza').getValue()) + parseInt(Ext.getCmp('intPerfilTronco').getValue()) + parseInt(Ext.getCmp('intPerfilBrazosPiernas').getValue()) + parseInt(Ext.getCmp('intRasgos').getValue()) + parseInt(Ext.getCmp('intOidoPresente').getValue()) + parseInt(Ext.getCmp('intPocisionProporcionCorrectasOidos').getValue()));
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 50,
                                                                fieldLabel: 'Boca',
                                                                name: 'Boca',
                                                                allowBlank: true,
                                                                store: 'StoreEscalaValoracion',
                                                                valueField: 'Valor',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: 0,
                                                                id: 'intBoca',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        if(pNew == null){
                                                                            Ext.getCmp('intPuntajeEscalaTotal').setValue(0);
                                                                        }else{
                                                                            Ext.getCmp('intPuntajeEscalaTotal').setValue(parseInt(Ext.getCmp('intCabeza').getValue()) + parseInt(Ext.getCmp('intPiernas').getValue()) + parseInt(Ext.getCmp('intBrazos').getValue()) + parseInt(Ext.getCmp('intTroncoPresente').getValue()) + parseInt(Ext.getCmp('intMayorLongitudAncho').getValue()) + parseInt(Ext.getCmp('intHombros').getValue()) + parseInt(Ext.getCmp('intMMSSUnidosTronco').getValue()) + parseInt(Ext.getCmp('intMMSSLugar').getValue()) + parseInt(Ext.getCmp('intCuelloPresente').getValue()) + parseInt(Ext.getCmp('intCuelloLugar').getValue()) + parseInt(Ext.getCmp('intOjos').getValue()) + parseInt(Ext.getCmp('intNariz').getValue()) + parseInt(Ext.getCmp('intBoca').getValue()) + parseInt(Ext.getCmp('int1213DosDimenciones').getValue()) + parseInt(Ext.getCmp('intOrificiosNasales').getValue()) + parseInt(Ext.getCmp('intPeloPresente').getValue()) + parseInt(Ext.getCmp('intPeloMejorDefinido').getValue()) + parseInt(Ext.getCmp('intManoDiferenteBrazo').getValue()) + parseInt(Ext.getCmp('intArticulacionCodoHombro').getValue()) + parseInt(Ext.getCmp('intCaderaRodilla').getValue()) + parseInt(Ext.getCmp('intCabezaAreaTronco').getValue()) + parseInt(Ext.getCmp('intBrazosIgualTronco').getValue()) + parseInt(Ext.getCmp('intPiernasTronco').getValue()) + parseInt(Ext.getCmp('intPiePierna').getValue()) + parseInt(Ext.getCmp('intBrazosPiernas2Dimensiones').getValue()) + parseInt(Ext.getCmp('intTalon').getValue()) + parseInt(Ext.getCmp('intLineasFirmesConectadas').getValue()) + parseInt(Ext.getCmp('intUnionesCorrectas').getValue()) + parseInt(Ext.getCmp('intPerfilCabeza').getValue()) + parseInt(Ext.getCmp('intPerfilTronco').getValue()) + parseInt(Ext.getCmp('intPerfilBrazosPiernas').getValue()) + parseInt(Ext.getCmp('intRasgos').getValue()) + parseInt(Ext.getCmp('intOidoPresente').getValue()) + parseInt(Ext.getCmp('intPocisionProporcionCorrectasOidos').getValue()));
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 50,
                                                                fieldLabel: '12 y 13 dos Dimenciones',
                                                                name: '12 y 13 dos Dimenciones',
                                                                allowBlank: true,
                                                                store: 'StoreEscalaValoracion',
                                                                valueField: 'Valor',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: 0,
                                                                id: 'int1213DosDimenciones',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        if(pNew == null){
                                                                            Ext.getCmp('intPuntajeEscalaTotal').setValue(0);
                                                                        }else{
                                                                            Ext.getCmp('intPuntajeEscalaTotal').setValue(parseInt(Ext.getCmp('intCabeza').getValue()) + parseInt(Ext.getCmp('intPiernas').getValue()) + parseInt(Ext.getCmp('intBrazos').getValue()) + parseInt(Ext.getCmp('intTroncoPresente').getValue()) + parseInt(Ext.getCmp('intMayorLongitudAncho').getValue()) + parseInt(Ext.getCmp('intHombros').getValue()) + parseInt(Ext.getCmp('intMMSSUnidosTronco').getValue()) + parseInt(Ext.getCmp('intMMSSLugar').getValue()) + parseInt(Ext.getCmp('intCuelloPresente').getValue()) + parseInt(Ext.getCmp('intCuelloLugar').getValue()) + parseInt(Ext.getCmp('intOjos').getValue()) + parseInt(Ext.getCmp('intNariz').getValue()) + parseInt(Ext.getCmp('intBoca').getValue()) + parseInt(Ext.getCmp('int1213DosDimenciones').getValue()) + parseInt(Ext.getCmp('intOrificiosNasales').getValue()) + parseInt(Ext.getCmp('intPeloPresente').getValue()) + parseInt(Ext.getCmp('intPeloMejorDefinido').getValue()) + parseInt(Ext.getCmp('intManoDiferenteBrazo').getValue()) + parseInt(Ext.getCmp('intArticulacionCodoHombro').getValue()) + parseInt(Ext.getCmp('intCaderaRodilla').getValue()) + parseInt(Ext.getCmp('intCabezaAreaTronco').getValue()) + parseInt(Ext.getCmp('intBrazosIgualTronco').getValue()) + parseInt(Ext.getCmp('intPiernasTronco').getValue()) + parseInt(Ext.getCmp('intPiePierna').getValue()) + parseInt(Ext.getCmp('intBrazosPiernas2Dimensiones').getValue()) + parseInt(Ext.getCmp('intTalon').getValue()) + parseInt(Ext.getCmp('intLineasFirmesConectadas').getValue()) + parseInt(Ext.getCmp('intUnionesCorrectas').getValue()) + parseInt(Ext.getCmp('intPerfilCabeza').getValue()) + parseInt(Ext.getCmp('intPerfilTronco').getValue()) + parseInt(Ext.getCmp('intPerfilBrazosPiernas').getValue()) + parseInt(Ext.getCmp('intRasgos').getValue()) + parseInt(Ext.getCmp('intOidoPresente').getValue()) + parseInt(Ext.getCmp('intPocisionProporcionCorrectasOidos').getValue()));
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 50,
                                                                fieldLabel: 'Orificios Nasales',
                                                                name: 'Orificios Nasales',
                                                                allowBlank: true,
                                                                store: 'StoreEscalaValoracion',
                                                                valueField: 'Valor',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: 0,
                                                                id: 'intOrificiosNasales',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        if(pNew == null){
                                                                            Ext.getCmp('intPuntajeEscalaTotal').setValue(0);
                                                                        }else{
                                                                            Ext.getCmp('intPuntajeEscalaTotal').setValue(parseInt(Ext.getCmp('intCabeza').getValue()) + parseInt(Ext.getCmp('intPiernas').getValue()) + parseInt(Ext.getCmp('intBrazos').getValue()) + parseInt(Ext.getCmp('intTroncoPresente').getValue()) + parseInt(Ext.getCmp('intMayorLongitudAncho').getValue()) + parseInt(Ext.getCmp('intHombros').getValue()) + parseInt(Ext.getCmp('intMMSSUnidosTronco').getValue()) + parseInt(Ext.getCmp('intMMSSLugar').getValue()) + parseInt(Ext.getCmp('intCuelloPresente').getValue()) + parseInt(Ext.getCmp('intCuelloLugar').getValue()) + parseInt(Ext.getCmp('intOjos').getValue()) + parseInt(Ext.getCmp('intNariz').getValue()) + parseInt(Ext.getCmp('intBoca').getValue()) + parseInt(Ext.getCmp('int1213DosDimenciones').getValue()) + parseInt(Ext.getCmp('intOrificiosNasales').getValue()) + parseInt(Ext.getCmp('intPeloPresente').getValue()) + parseInt(Ext.getCmp('intPeloMejorDefinido').getValue()) + parseInt(Ext.getCmp('intManoDiferenteBrazo').getValue()) + parseInt(Ext.getCmp('intArticulacionCodoHombro').getValue()) + parseInt(Ext.getCmp('intCaderaRodilla').getValue()) + parseInt(Ext.getCmp('intCabezaAreaTronco').getValue()) + parseInt(Ext.getCmp('intBrazosIgualTronco').getValue()) + parseInt(Ext.getCmp('intPiernasTronco').getValue()) + parseInt(Ext.getCmp('intPiePierna').getValue()) + parseInt(Ext.getCmp('intBrazosPiernas2Dimensiones').getValue()) + parseInt(Ext.getCmp('intTalon').getValue()) + parseInt(Ext.getCmp('intLineasFirmesConectadas').getValue()) + parseInt(Ext.getCmp('intUnionesCorrectas').getValue()) + parseInt(Ext.getCmp('intPerfilCabeza').getValue()) + parseInt(Ext.getCmp('intPerfilTronco').getValue()) + parseInt(Ext.getCmp('intPerfilBrazosPiernas').getValue()) + parseInt(Ext.getCmp('intRasgos').getValue()) + parseInt(Ext.getCmp('intOidoPresente').getValue()) + parseInt(Ext.getCmp('intPocisionProporcionCorrectasOidos').getValue()));
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 50,
                                                                fieldLabel: 'Pelo Presente',
                                                                name: 'Pelo Presente',
                                                                allowBlank: true,
                                                                store: 'StoreEscalaValoracion',
                                                                valueField: 'Valor',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: 0,
                                                                id: 'intPeloPresente',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        if(pNew == null){
                                                                            Ext.getCmp('intPuntajeEscalaTotal').setValue(0);
                                                                        }else{
                                                                            Ext.getCmp('intPuntajeEscalaTotal').setValue(parseInt(Ext.getCmp('intCabeza').getValue()) + parseInt(Ext.getCmp('intPiernas').getValue()) + parseInt(Ext.getCmp('intBrazos').getValue()) + parseInt(Ext.getCmp('intTroncoPresente').getValue()) + parseInt(Ext.getCmp('intMayorLongitudAncho').getValue()) + parseInt(Ext.getCmp('intHombros').getValue()) + parseInt(Ext.getCmp('intMMSSUnidosTronco').getValue()) + parseInt(Ext.getCmp('intMMSSLugar').getValue()) + parseInt(Ext.getCmp('intCuelloPresente').getValue()) + parseInt(Ext.getCmp('intCuelloLugar').getValue()) + parseInt(Ext.getCmp('intOjos').getValue()) + parseInt(Ext.getCmp('intNariz').getValue()) + parseInt(Ext.getCmp('intBoca').getValue()) + parseInt(Ext.getCmp('int1213DosDimenciones').getValue()) + parseInt(Ext.getCmp('intOrificiosNasales').getValue()) + parseInt(Ext.getCmp('intPeloPresente').getValue()) + parseInt(Ext.getCmp('intPeloMejorDefinido').getValue()) + parseInt(Ext.getCmp('intManoDiferenteBrazo').getValue()) + parseInt(Ext.getCmp('intArticulacionCodoHombro').getValue()) + parseInt(Ext.getCmp('intCaderaRodilla').getValue()) + parseInt(Ext.getCmp('intCabezaAreaTronco').getValue()) + parseInt(Ext.getCmp('intBrazosIgualTronco').getValue()) + parseInt(Ext.getCmp('intPiernasTronco').getValue()) + parseInt(Ext.getCmp('intPiePierna').getValue()) + parseInt(Ext.getCmp('intBrazosPiernas2Dimensiones').getValue()) + parseInt(Ext.getCmp('intTalon').getValue()) + parseInt(Ext.getCmp('intLineasFirmesConectadas').getValue()) + parseInt(Ext.getCmp('intUnionesCorrectas').getValue()) + parseInt(Ext.getCmp('intPerfilCabeza').getValue()) + parseInt(Ext.getCmp('intPerfilTronco').getValue()) + parseInt(Ext.getCmp('intPerfilBrazosPiernas').getValue()) + parseInt(Ext.getCmp('intRasgos').getValue()) + parseInt(Ext.getCmp('intOidoPresente').getValue()) + parseInt(Ext.getCmp('intPocisionProporcionCorrectasOidos').getValue()));
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 50,
                                                                fieldLabel: 'Pelo Mejor Definido',
                                                                name: 'Pelo Mejor Definido',
                                                                allowBlank: true,
                                                                store: 'StoreEscalaValoracion',
                                                                valueField: 'Valor',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: 0,
                                                                id: 'intPeloMejorDefinido',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        if(pNew == null){
                                                                            Ext.getCmp('intPuntajeEscalaTotal').setValue(0);
                                                                        }else{
                                                                            Ext.getCmp('intPuntajeEscalaTotal').setValue(parseInt(Ext.getCmp('intCabeza').getValue()) + parseInt(Ext.getCmp('intPiernas').getValue()) + parseInt(Ext.getCmp('intBrazos').getValue()) + parseInt(Ext.getCmp('intTroncoPresente').getValue()) + parseInt(Ext.getCmp('intMayorLongitudAncho').getValue()) + parseInt(Ext.getCmp('intHombros').getValue()) + parseInt(Ext.getCmp('intMMSSUnidosTronco').getValue()) + parseInt(Ext.getCmp('intMMSSLugar').getValue()) + parseInt(Ext.getCmp('intCuelloPresente').getValue()) + parseInt(Ext.getCmp('intCuelloLugar').getValue()) + parseInt(Ext.getCmp('intOjos').getValue()) + parseInt(Ext.getCmp('intNariz').getValue()) + parseInt(Ext.getCmp('intBoca').getValue()) + parseInt(Ext.getCmp('int1213DosDimenciones').getValue()) + parseInt(Ext.getCmp('intOrificiosNasales').getValue()) + parseInt(Ext.getCmp('intPeloPresente').getValue()) + parseInt(Ext.getCmp('intPeloMejorDefinido').getValue()) + parseInt(Ext.getCmp('intManoDiferenteBrazo').getValue()) + parseInt(Ext.getCmp('intArticulacionCodoHombro').getValue()) + parseInt(Ext.getCmp('intCaderaRodilla').getValue()) + parseInt(Ext.getCmp('intCabezaAreaTronco').getValue()) + parseInt(Ext.getCmp('intBrazosIgualTronco').getValue()) + parseInt(Ext.getCmp('intPiernasTronco').getValue()) + parseInt(Ext.getCmp('intPiePierna').getValue()) + parseInt(Ext.getCmp('intBrazosPiernas2Dimensiones').getValue()) + parseInt(Ext.getCmp('intTalon').getValue()) + parseInt(Ext.getCmp('intLineasFirmesConectadas').getValue()) + parseInt(Ext.getCmp('intUnionesCorrectas').getValue()) + parseInt(Ext.getCmp('intPerfilCabeza').getValue()) + parseInt(Ext.getCmp('intPerfilTronco').getValue()) + parseInt(Ext.getCmp('intPerfilBrazosPiernas').getValue()) + parseInt(Ext.getCmp('intRasgos').getValue()) + parseInt(Ext.getCmp('intOidoPresente').getValue()) + parseInt(Ext.getCmp('intPocisionProporcionCorrectasOidos').getValue()));
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        layout: 'form',
                                                        labelWidth: 250,
                                                        width: 450,
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                width: 50,
                                                                fieldLabel: 'Mano Diferente a Brazo',
                                                                name: 'Mano Diferente a Brazo',
                                                                allowBlank: true,
                                                                store: 'StoreEscalaValoracion',
                                                                valueField: 'Valor',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: 0,
                                                                id: 'intManoDiferenteBrazo',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        if(pNew == null){
                                                                            Ext.getCmp('intPuntajeEscalaTotal').setValue(0);
                                                                        }else{
                                                                            Ext.getCmp('intPuntajeEscalaTotal').setValue(parseInt(Ext.getCmp('intCabeza').getValue()) + parseInt(Ext.getCmp('intPiernas').getValue()) + parseInt(Ext.getCmp('intBrazos').getValue()) + parseInt(Ext.getCmp('intTroncoPresente').getValue()) + parseInt(Ext.getCmp('intMayorLongitudAncho').getValue()) + parseInt(Ext.getCmp('intHombros').getValue()) + parseInt(Ext.getCmp('intMMSSUnidosTronco').getValue()) + parseInt(Ext.getCmp('intMMSSLugar').getValue()) + parseInt(Ext.getCmp('intCuelloPresente').getValue()) + parseInt(Ext.getCmp('intCuelloLugar').getValue()) + parseInt(Ext.getCmp('intOjos').getValue()) + parseInt(Ext.getCmp('intNariz').getValue()) + parseInt(Ext.getCmp('intBoca').getValue()) + parseInt(Ext.getCmp('int1213DosDimenciones').getValue()) + parseInt(Ext.getCmp('intOrificiosNasales').getValue()) + parseInt(Ext.getCmp('intPeloPresente').getValue()) + parseInt(Ext.getCmp('intPeloMejorDefinido').getValue()) + parseInt(Ext.getCmp('intManoDiferenteBrazo').getValue()) + parseInt(Ext.getCmp('intArticulacionCodoHombro').getValue()) + parseInt(Ext.getCmp('intCaderaRodilla').getValue()) + parseInt(Ext.getCmp('intCabezaAreaTronco').getValue()) + parseInt(Ext.getCmp('intBrazosIgualTronco').getValue()) + parseInt(Ext.getCmp('intPiernasTronco').getValue()) + parseInt(Ext.getCmp('intPiePierna').getValue()) + parseInt(Ext.getCmp('intBrazosPiernas2Dimensiones').getValue()) + parseInt(Ext.getCmp('intTalon').getValue()) + parseInt(Ext.getCmp('intLineasFirmesConectadas').getValue()) + parseInt(Ext.getCmp('intUnionesCorrectas').getValue()) + parseInt(Ext.getCmp('intPerfilCabeza').getValue()) + parseInt(Ext.getCmp('intPerfilTronco').getValue()) + parseInt(Ext.getCmp('intPerfilBrazosPiernas').getValue()) + parseInt(Ext.getCmp('intRasgos').getValue()) + parseInt(Ext.getCmp('intOidoPresente').getValue()) + parseInt(Ext.getCmp('intPocisionProporcionCorrectasOidos').getValue()));
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 50,
                                                                fieldLabel: 'Articulacion de Codo y/o Hombro',
                                                                name: 'Articulacion de Codo y/o Hombro',
                                                                allowBlank: true,
                                                                store: 'StoreEscalaValoracion',
                                                                valueField: 'Valor',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: 0,
                                                                id: 'intArticulacionCodoHombro',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        if(pNew == null){
                                                                            Ext.getCmp('intPuntajeEscalaTotal').setValue(0);
                                                                        }else{
                                                                            Ext.getCmp('intPuntajeEscalaTotal').setValue(parseInt(Ext.getCmp('intCabeza').getValue()) + parseInt(Ext.getCmp('intPiernas').getValue()) + parseInt(Ext.getCmp('intBrazos').getValue()) + parseInt(Ext.getCmp('intTroncoPresente').getValue()) + parseInt(Ext.getCmp('intMayorLongitudAncho').getValue()) + parseInt(Ext.getCmp('intHombros').getValue()) + parseInt(Ext.getCmp('intMMSSUnidosTronco').getValue()) + parseInt(Ext.getCmp('intMMSSLugar').getValue()) + parseInt(Ext.getCmp('intCuelloPresente').getValue()) + parseInt(Ext.getCmp('intCuelloLugar').getValue()) + parseInt(Ext.getCmp('intOjos').getValue()) + parseInt(Ext.getCmp('intNariz').getValue()) + parseInt(Ext.getCmp('intBoca').getValue()) + parseInt(Ext.getCmp('int1213DosDimenciones').getValue()) + parseInt(Ext.getCmp('intOrificiosNasales').getValue()) + parseInt(Ext.getCmp('intPeloPresente').getValue()) + parseInt(Ext.getCmp('intPeloMejorDefinido').getValue()) + parseInt(Ext.getCmp('intManoDiferenteBrazo').getValue()) + parseInt(Ext.getCmp('intArticulacionCodoHombro').getValue()) + parseInt(Ext.getCmp('intCaderaRodilla').getValue()) + parseInt(Ext.getCmp('intCabezaAreaTronco').getValue()) + parseInt(Ext.getCmp('intBrazosIgualTronco').getValue()) + parseInt(Ext.getCmp('intPiernasTronco').getValue()) + parseInt(Ext.getCmp('intPiePierna').getValue()) + parseInt(Ext.getCmp('intBrazosPiernas2Dimensiones').getValue()) + parseInt(Ext.getCmp('intTalon').getValue()) + parseInt(Ext.getCmp('intLineasFirmesConectadas').getValue()) + parseInt(Ext.getCmp('intUnionesCorrectas').getValue()) + parseInt(Ext.getCmp('intPerfilCabeza').getValue()) + parseInt(Ext.getCmp('intPerfilTronco').getValue()) + parseInt(Ext.getCmp('intPerfilBrazosPiernas').getValue()) + parseInt(Ext.getCmp('intRasgos').getValue()) + parseInt(Ext.getCmp('intOidoPresente').getValue()) + parseInt(Ext.getCmp('intPocisionProporcionCorrectasOidos').getValue()));
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 50,
                                                                fieldLabel: 'Cadera y/o Rodilla',
                                                                name: 'Cadera y/o Rodilla',
                                                                allowBlank: true,
                                                                store: 'StoreEscalaValoracion',
                                                                valueField: 'Valor',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: 0,
                                                                id: 'intCaderaRodilla',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        if(pNew == null){
                                                                            Ext.getCmp('intPuntajeEscalaTotal').setValue(0);
                                                                        }else{
                                                                            Ext.getCmp('intPuntajeEscalaTotal').setValue(parseInt(Ext.getCmp('intCabeza').getValue()) + parseInt(Ext.getCmp('intPiernas').getValue()) + parseInt(Ext.getCmp('intBrazos').getValue()) + parseInt(Ext.getCmp('intTroncoPresente').getValue()) + parseInt(Ext.getCmp('intMayorLongitudAncho').getValue()) + parseInt(Ext.getCmp('intHombros').getValue()) + parseInt(Ext.getCmp('intMMSSUnidosTronco').getValue()) + parseInt(Ext.getCmp('intMMSSLugar').getValue()) + parseInt(Ext.getCmp('intCuelloPresente').getValue()) + parseInt(Ext.getCmp('intCuelloLugar').getValue()) + parseInt(Ext.getCmp('intOjos').getValue()) + parseInt(Ext.getCmp('intNariz').getValue()) + parseInt(Ext.getCmp('intBoca').getValue()) + parseInt(Ext.getCmp('int1213DosDimenciones').getValue()) + parseInt(Ext.getCmp('intOrificiosNasales').getValue()) + parseInt(Ext.getCmp('intPeloPresente').getValue()) + parseInt(Ext.getCmp('intPeloMejorDefinido').getValue()) + parseInt(Ext.getCmp('intManoDiferenteBrazo').getValue()) + parseInt(Ext.getCmp('intArticulacionCodoHombro').getValue()) + parseInt(Ext.getCmp('intCaderaRodilla').getValue()) + parseInt(Ext.getCmp('intCabezaAreaTronco').getValue()) + parseInt(Ext.getCmp('intBrazosIgualTronco').getValue()) + parseInt(Ext.getCmp('intPiernasTronco').getValue()) + parseInt(Ext.getCmp('intPiePierna').getValue()) + parseInt(Ext.getCmp('intBrazosPiernas2Dimensiones').getValue()) + parseInt(Ext.getCmp('intTalon').getValue()) + parseInt(Ext.getCmp('intLineasFirmesConectadas').getValue()) + parseInt(Ext.getCmp('intUnionesCorrectas').getValue()) + parseInt(Ext.getCmp('intPerfilCabeza').getValue()) + parseInt(Ext.getCmp('intPerfilTronco').getValue()) + parseInt(Ext.getCmp('intPerfilBrazosPiernas').getValue()) + parseInt(Ext.getCmp('intRasgos').getValue()) + parseInt(Ext.getCmp('intOidoPresente').getValue()) + parseInt(Ext.getCmp('intPocisionProporcionCorrectasOidos').getValue()));
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 50,
                                                                fieldLabel: 'Cabeza 1/10 a 1/2 area Tronco',
                                                                name: 'Cabeza 1/10 a 1/2 area Tronco',
                                                                allowBlank: true,
                                                                store: 'StoreEscalaValoracion',
                                                                valueField: 'Valor',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: 0,
                                                                id: 'intCabezaAreaTronco',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        if(pNew == null){
                                                                            Ext.getCmp('intPuntajeEscalaTotal').setValue(0);
                                                                        }else{
                                                                            Ext.getCmp('intPuntajeEscalaTotal').setValue(parseInt(Ext.getCmp('intCabeza').getValue()) + parseInt(Ext.getCmp('intPiernas').getValue()) + parseInt(Ext.getCmp('intBrazos').getValue()) + parseInt(Ext.getCmp('intTroncoPresente').getValue()) + parseInt(Ext.getCmp('intMayorLongitudAncho').getValue()) + parseInt(Ext.getCmp('intHombros').getValue()) + parseInt(Ext.getCmp('intMMSSUnidosTronco').getValue()) + parseInt(Ext.getCmp('intMMSSLugar').getValue()) + parseInt(Ext.getCmp('intCuelloPresente').getValue()) + parseInt(Ext.getCmp('intCuelloLugar').getValue()) + parseInt(Ext.getCmp('intOjos').getValue()) + parseInt(Ext.getCmp('intNariz').getValue()) + parseInt(Ext.getCmp('intBoca').getValue()) + parseInt(Ext.getCmp('int1213DosDimenciones').getValue()) + parseInt(Ext.getCmp('intOrificiosNasales').getValue()) + parseInt(Ext.getCmp('intPeloPresente').getValue()) + parseInt(Ext.getCmp('intPeloMejorDefinido').getValue()) + parseInt(Ext.getCmp('intManoDiferenteBrazo').getValue()) + parseInt(Ext.getCmp('intArticulacionCodoHombro').getValue()) + parseInt(Ext.getCmp('intCaderaRodilla').getValue()) + parseInt(Ext.getCmp('intCabezaAreaTronco').getValue()) + parseInt(Ext.getCmp('intBrazosIgualTronco').getValue()) + parseInt(Ext.getCmp('intPiernasTronco').getValue()) + parseInt(Ext.getCmp('intPiePierna').getValue()) + parseInt(Ext.getCmp('intBrazosPiernas2Dimensiones').getValue()) + parseInt(Ext.getCmp('intTalon').getValue()) + parseInt(Ext.getCmp('intLineasFirmesConectadas').getValue()) + parseInt(Ext.getCmp('intUnionesCorrectas').getValue()) + parseInt(Ext.getCmp('intPerfilCabeza').getValue()) + parseInt(Ext.getCmp('intPerfilTronco').getValue()) + parseInt(Ext.getCmp('intPerfilBrazosPiernas').getValue()) + parseInt(Ext.getCmp('intRasgos').getValue()) + parseInt(Ext.getCmp('intOidoPresente').getValue()) + parseInt(Ext.getCmp('intPocisionProporcionCorrectasOidos').getValue()));
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 50,
                                                                fieldLabel: 'Brazos igual al Tronco',
                                                                name: 'Brazos igual al Tronco',
                                                                allowBlank: true,
                                                                store: 'StoreEscalaValoracion',
                                                                valueField: 'Valor',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: 0,
                                                                id: 'intBrazosIgualTronco',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        if(pNew == null){
                                                                            Ext.getCmp('intPuntajeEscalaTotal').setValue(0);
                                                                        }else{
                                                                            Ext.getCmp('intPuntajeEscalaTotal').setValue(parseInt(Ext.getCmp('intCabeza').getValue()) + parseInt(Ext.getCmp('intPiernas').getValue()) + parseInt(Ext.getCmp('intBrazos').getValue()) + parseInt(Ext.getCmp('intTroncoPresente').getValue()) + parseInt(Ext.getCmp('intMayorLongitudAncho').getValue()) + parseInt(Ext.getCmp('intHombros').getValue()) + parseInt(Ext.getCmp('intMMSSUnidosTronco').getValue()) + parseInt(Ext.getCmp('intMMSSLugar').getValue()) + parseInt(Ext.getCmp('intCuelloPresente').getValue()) + parseInt(Ext.getCmp('intCuelloLugar').getValue()) + parseInt(Ext.getCmp('intOjos').getValue()) + parseInt(Ext.getCmp('intNariz').getValue()) + parseInt(Ext.getCmp('intBoca').getValue()) + parseInt(Ext.getCmp('int1213DosDimenciones').getValue()) + parseInt(Ext.getCmp('intOrificiosNasales').getValue()) + parseInt(Ext.getCmp('intPeloPresente').getValue()) + parseInt(Ext.getCmp('intPeloMejorDefinido').getValue()) + parseInt(Ext.getCmp('intManoDiferenteBrazo').getValue()) + parseInt(Ext.getCmp('intArticulacionCodoHombro').getValue()) + parseInt(Ext.getCmp('intCaderaRodilla').getValue()) + parseInt(Ext.getCmp('intCabezaAreaTronco').getValue()) + parseInt(Ext.getCmp('intBrazosIgualTronco').getValue()) + parseInt(Ext.getCmp('intPiernasTronco').getValue()) + parseInt(Ext.getCmp('intPiePierna').getValue()) + parseInt(Ext.getCmp('intBrazosPiernas2Dimensiones').getValue()) + parseInt(Ext.getCmp('intTalon').getValue()) + parseInt(Ext.getCmp('intLineasFirmesConectadas').getValue()) + parseInt(Ext.getCmp('intUnionesCorrectas').getValue()) + parseInt(Ext.getCmp('intPerfilCabeza').getValue()) + parseInt(Ext.getCmp('intPerfilTronco').getValue()) + parseInt(Ext.getCmp('intPerfilBrazosPiernas').getValue()) + parseInt(Ext.getCmp('intRasgos').getValue()) + parseInt(Ext.getCmp('intOidoPresente').getValue()) + parseInt(Ext.getCmp('intPocisionProporcionCorrectasOidos').getValue()));
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 50,
                                                                fieldLabel: 'Piernas una o dos Veces Tronco',
                                                                name: 'Piernas una o dos Veces Tronco',
                                                                allowBlank: true,
                                                                store: 'StoreEscalaValoracion',
                                                                valueField: 'Valor',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: 0,
                                                                id: 'intPiernasTronco',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        if(pNew == null){
                                                                            Ext.getCmp('intPuntajeEscalaTotal').setValue(0);
                                                                        }else{
                                                                            Ext.getCmp('intPuntajeEscalaTotal').setValue(parseInt(Ext.getCmp('intCabeza').getValue()) + parseInt(Ext.getCmp('intPiernas').getValue()) + parseInt(Ext.getCmp('intBrazos').getValue()) + parseInt(Ext.getCmp('intTroncoPresente').getValue()) + parseInt(Ext.getCmp('intMayorLongitudAncho').getValue()) + parseInt(Ext.getCmp('intHombros').getValue()) + parseInt(Ext.getCmp('intMMSSUnidosTronco').getValue()) + parseInt(Ext.getCmp('intMMSSLugar').getValue()) + parseInt(Ext.getCmp('intCuelloPresente').getValue()) + parseInt(Ext.getCmp('intCuelloLugar').getValue()) + parseInt(Ext.getCmp('intOjos').getValue()) + parseInt(Ext.getCmp('intNariz').getValue()) + parseInt(Ext.getCmp('intBoca').getValue()) + parseInt(Ext.getCmp('int1213DosDimenciones').getValue()) + parseInt(Ext.getCmp('intOrificiosNasales').getValue()) + parseInt(Ext.getCmp('intPeloPresente').getValue()) + parseInt(Ext.getCmp('intPeloMejorDefinido').getValue()) + parseInt(Ext.getCmp('intManoDiferenteBrazo').getValue()) + parseInt(Ext.getCmp('intArticulacionCodoHombro').getValue()) + parseInt(Ext.getCmp('intCaderaRodilla').getValue()) + parseInt(Ext.getCmp('intCabezaAreaTronco').getValue()) + parseInt(Ext.getCmp('intBrazosIgualTronco').getValue()) + parseInt(Ext.getCmp('intPiernasTronco').getValue()) + parseInt(Ext.getCmp('intPiePierna').getValue()) + parseInt(Ext.getCmp('intBrazosPiernas2Dimensiones').getValue()) + parseInt(Ext.getCmp('intTalon').getValue()) + parseInt(Ext.getCmp('intLineasFirmesConectadas').getValue()) + parseInt(Ext.getCmp('intUnionesCorrectas').getValue()) + parseInt(Ext.getCmp('intPerfilCabeza').getValue()) + parseInt(Ext.getCmp('intPerfilTronco').getValue()) + parseInt(Ext.getCmp('intPerfilBrazosPiernas').getValue()) + parseInt(Ext.getCmp('intRasgos').getValue()) + parseInt(Ext.getCmp('intOidoPresente').getValue()) + parseInt(Ext.getCmp('intPocisionProporcionCorrectasOidos').getValue()));
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 50,
                                                                fieldLabel: 'Pie 1/10 a 1/3 Longitud Pierna',
                                                                name: 'Pie 1/10 a 1/3 Longitud Pierna',
                                                                allowBlank: true,
                                                                store: 'StoreEscalaValoracion',
                                                                valueField: 'Valor',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: 0,
                                                                id: 'intPiePierna',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        if(pNew == null){
                                                                            Ext.getCmp('intPuntajeEscalaTotal').setValue(0);
                                                                        }else{
                                                                            Ext.getCmp('intPuntajeEscalaTotal').setValue(parseInt(Ext.getCmp('intCabeza').getValue()) + parseInt(Ext.getCmp('intPiernas').getValue()) + parseInt(Ext.getCmp('intBrazos').getValue()) + parseInt(Ext.getCmp('intTroncoPresente').getValue()) + parseInt(Ext.getCmp('intMayorLongitudAncho').getValue()) + parseInt(Ext.getCmp('intHombros').getValue()) + parseInt(Ext.getCmp('intMMSSUnidosTronco').getValue()) + parseInt(Ext.getCmp('intMMSSLugar').getValue()) + parseInt(Ext.getCmp('intCuelloPresente').getValue()) + parseInt(Ext.getCmp('intCuelloLugar').getValue()) + parseInt(Ext.getCmp('intOjos').getValue()) + parseInt(Ext.getCmp('intNariz').getValue()) + parseInt(Ext.getCmp('intBoca').getValue()) + parseInt(Ext.getCmp('int1213DosDimenciones').getValue()) + parseInt(Ext.getCmp('intOrificiosNasales').getValue()) + parseInt(Ext.getCmp('intPeloPresente').getValue()) + parseInt(Ext.getCmp('intPeloMejorDefinido').getValue()) + parseInt(Ext.getCmp('intManoDiferenteBrazo').getValue()) + parseInt(Ext.getCmp('intArticulacionCodoHombro').getValue()) + parseInt(Ext.getCmp('intCaderaRodilla').getValue()) + parseInt(Ext.getCmp('intCabezaAreaTronco').getValue()) + parseInt(Ext.getCmp('intBrazosIgualTronco').getValue()) + parseInt(Ext.getCmp('intPiernasTronco').getValue()) + parseInt(Ext.getCmp('intPiePierna').getValue()) + parseInt(Ext.getCmp('intBrazosPiernas2Dimensiones').getValue()) + parseInt(Ext.getCmp('intTalon').getValue()) + parseInt(Ext.getCmp('intLineasFirmesConectadas').getValue()) + parseInt(Ext.getCmp('intUnionesCorrectas').getValue()) + parseInt(Ext.getCmp('intPerfilCabeza').getValue()) + parseInt(Ext.getCmp('intPerfilTronco').getValue()) + parseInt(Ext.getCmp('intPerfilBrazosPiernas').getValue()) + parseInt(Ext.getCmp('intRasgos').getValue()) + parseInt(Ext.getCmp('intOidoPresente').getValue()) + parseInt(Ext.getCmp('intPocisionProporcionCorrectasOidos').getValue()));
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 50,
                                                                fieldLabel: 'Brazos y Piernas de 2 Dimensiones',
                                                                name: 'Brazos y Piernas de 2 Dimensiones',
                                                                allowBlank: true,
                                                                store: 'StoreEscalaValoracion',
                                                                valueField: 'Valor',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: 0,
                                                                id: 'intBrazosPiernas2Dimensiones',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        if(pNew == null){
                                                                            Ext.getCmp('intPuntajeEscalaTotal').setValue(0);
                                                                        }else{
                                                                            Ext.getCmp('intPuntajeEscalaTotal').setValue(parseInt(Ext.getCmp('intCabeza').getValue()) + parseInt(Ext.getCmp('intPiernas').getValue()) + parseInt(Ext.getCmp('intBrazos').getValue()) + parseInt(Ext.getCmp('intTroncoPresente').getValue()) + parseInt(Ext.getCmp('intMayorLongitudAncho').getValue()) + parseInt(Ext.getCmp('intHombros').getValue()) + parseInt(Ext.getCmp('intMMSSUnidosTronco').getValue()) + parseInt(Ext.getCmp('intMMSSLugar').getValue()) + parseInt(Ext.getCmp('intCuelloPresente').getValue()) + parseInt(Ext.getCmp('intCuelloLugar').getValue()) + parseInt(Ext.getCmp('intOjos').getValue()) + parseInt(Ext.getCmp('intNariz').getValue()) + parseInt(Ext.getCmp('intBoca').getValue()) + parseInt(Ext.getCmp('int1213DosDimenciones').getValue()) + parseInt(Ext.getCmp('intOrificiosNasales').getValue()) + parseInt(Ext.getCmp('intPeloPresente').getValue()) + parseInt(Ext.getCmp('intPeloMejorDefinido').getValue()) + parseInt(Ext.getCmp('intManoDiferenteBrazo').getValue()) + parseInt(Ext.getCmp('intArticulacionCodoHombro').getValue()) + parseInt(Ext.getCmp('intCaderaRodilla').getValue()) + parseInt(Ext.getCmp('intCabezaAreaTronco').getValue()) + parseInt(Ext.getCmp('intBrazosIgualTronco').getValue()) + parseInt(Ext.getCmp('intPiernasTronco').getValue()) + parseInt(Ext.getCmp('intPiePierna').getValue()) + parseInt(Ext.getCmp('intBrazosPiernas2Dimensiones').getValue()) + parseInt(Ext.getCmp('intTalon').getValue()) + parseInt(Ext.getCmp('intLineasFirmesConectadas').getValue()) + parseInt(Ext.getCmp('intUnionesCorrectas').getValue()) + parseInt(Ext.getCmp('intPerfilCabeza').getValue()) + parseInt(Ext.getCmp('intPerfilTronco').getValue()) + parseInt(Ext.getCmp('intPerfilBrazosPiernas').getValue()) + parseInt(Ext.getCmp('intRasgos').getValue()) + parseInt(Ext.getCmp('intOidoPresente').getValue()) + parseInt(Ext.getCmp('intPocisionProporcionCorrectasOidos').getValue()));
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 50,
                                                                fieldLabel: 'Talon',
                                                                name: 'Talon',
                                                                allowBlank: true,
                                                                store: 'StoreEscalaValoracion',
                                                                valueField: 'Valor',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: 0,
                                                                id: 'intTalon',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        if(pNew == null){
                                                                            Ext.getCmp('intPuntajeEscalaTotal').setValue(0);
                                                                        }else{
                                                                            Ext.getCmp('intPuntajeEscalaTotal').setValue(parseInt(Ext.getCmp('intCabeza').getValue()) + parseInt(Ext.getCmp('intPiernas').getValue()) + parseInt(Ext.getCmp('intBrazos').getValue()) + parseInt(Ext.getCmp('intTroncoPresente').getValue()) + parseInt(Ext.getCmp('intMayorLongitudAncho').getValue()) + parseInt(Ext.getCmp('intHombros').getValue()) + parseInt(Ext.getCmp('intMMSSUnidosTronco').getValue()) + parseInt(Ext.getCmp('intMMSSLugar').getValue()) + parseInt(Ext.getCmp('intCuelloPresente').getValue()) + parseInt(Ext.getCmp('intCuelloLugar').getValue()) + parseInt(Ext.getCmp('intOjos').getValue()) + parseInt(Ext.getCmp('intNariz').getValue()) + parseInt(Ext.getCmp('intBoca').getValue()) + parseInt(Ext.getCmp('int1213DosDimenciones').getValue()) + parseInt(Ext.getCmp('intOrificiosNasales').getValue()) + parseInt(Ext.getCmp('intPeloPresente').getValue()) + parseInt(Ext.getCmp('intPeloMejorDefinido').getValue()) + parseInt(Ext.getCmp('intManoDiferenteBrazo').getValue()) + parseInt(Ext.getCmp('intArticulacionCodoHombro').getValue()) + parseInt(Ext.getCmp('intCaderaRodilla').getValue()) + parseInt(Ext.getCmp('intCabezaAreaTronco').getValue()) + parseInt(Ext.getCmp('intBrazosIgualTronco').getValue()) + parseInt(Ext.getCmp('intPiernasTronco').getValue()) + parseInt(Ext.getCmp('intPiePierna').getValue()) + parseInt(Ext.getCmp('intBrazosPiernas2Dimensiones').getValue()) + parseInt(Ext.getCmp('intTalon').getValue()) + parseInt(Ext.getCmp('intLineasFirmesConectadas').getValue()) + parseInt(Ext.getCmp('intUnionesCorrectas').getValue()) + parseInt(Ext.getCmp('intPerfilCabeza').getValue()) + parseInt(Ext.getCmp('intPerfilTronco').getValue()) + parseInt(Ext.getCmp('intPerfilBrazosPiernas').getValue()) + parseInt(Ext.getCmp('intRasgos').getValue()) + parseInt(Ext.getCmp('intOidoPresente').getValue()) + parseInt(Ext.getCmp('intPocisionProporcionCorrectasOidos').getValue()));
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 50,
                                                                fieldLabel: 'Lineas Firmes y Conectadas',
                                                                name: 'Lineas Firmes y Conectadas',
                                                                allowBlank: true,
                                                                store: 'StoreEscalaValoracion',
                                                                valueField: 'Valor',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: 0,
                                                                id: 'intLineasFirmesConectadas',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        if(pNew == null){
                                                                            Ext.getCmp('intPuntajeEscalaTotal').setValue(0);
                                                                        }else{
                                                                            Ext.getCmp('intPuntajeEscalaTotal').setValue(parseInt(Ext.getCmp('intCabeza').getValue()) + parseInt(Ext.getCmp('intPiernas').getValue()) + parseInt(Ext.getCmp('intBrazos').getValue()) + parseInt(Ext.getCmp('intTroncoPresente').getValue()) + parseInt(Ext.getCmp('intMayorLongitudAncho').getValue()) + parseInt(Ext.getCmp('intHombros').getValue()) + parseInt(Ext.getCmp('intMMSSUnidosTronco').getValue()) + parseInt(Ext.getCmp('intMMSSLugar').getValue()) + parseInt(Ext.getCmp('intCuelloPresente').getValue()) + parseInt(Ext.getCmp('intCuelloLugar').getValue()) + parseInt(Ext.getCmp('intOjos').getValue()) + parseInt(Ext.getCmp('intNariz').getValue()) + parseInt(Ext.getCmp('intBoca').getValue()) + parseInt(Ext.getCmp('int1213DosDimenciones').getValue()) + parseInt(Ext.getCmp('intOrificiosNasales').getValue()) + parseInt(Ext.getCmp('intPeloPresente').getValue()) + parseInt(Ext.getCmp('intPeloMejorDefinido').getValue()) + parseInt(Ext.getCmp('intManoDiferenteBrazo').getValue()) + parseInt(Ext.getCmp('intArticulacionCodoHombro').getValue()) + parseInt(Ext.getCmp('intCaderaRodilla').getValue()) + parseInt(Ext.getCmp('intCabezaAreaTronco').getValue()) + parseInt(Ext.getCmp('intBrazosIgualTronco').getValue()) + parseInt(Ext.getCmp('intPiernasTronco').getValue()) + parseInt(Ext.getCmp('intPiePierna').getValue()) + parseInt(Ext.getCmp('intBrazosPiernas2Dimensiones').getValue()) + parseInt(Ext.getCmp('intTalon').getValue()) + parseInt(Ext.getCmp('intLineasFirmesConectadas').getValue()) + parseInt(Ext.getCmp('intUnionesCorrectas').getValue()) + parseInt(Ext.getCmp('intPerfilCabeza').getValue()) + parseInt(Ext.getCmp('intPerfilTronco').getValue()) + parseInt(Ext.getCmp('intPerfilBrazosPiernas').getValue()) + parseInt(Ext.getCmp('intRasgos').getValue()) + parseInt(Ext.getCmp('intOidoPresente').getValue()) + parseInt(Ext.getCmp('intPocisionProporcionCorrectasOidos').getValue()));
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 50,
                                                                fieldLabel: 'Uniones Correctas',
                                                                name: 'Uniones Correctas',
                                                                allowBlank: true,
                                                                store: 'StoreEscalaValoracion',
                                                                valueField: 'Valor',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: 0,
                                                                id: 'intUnionesCorrectas',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        if(pNew == null){
                                                                            Ext.getCmp('intPuntajeEscalaTotal').setValue(0);
                                                                        }else{
                                                                            Ext.getCmp('intPuntajeEscalaTotal').setValue(parseInt(Ext.getCmp('intCabeza').getValue()) + parseInt(Ext.getCmp('intPiernas').getValue()) + parseInt(Ext.getCmp('intBrazos').getValue()) + parseInt(Ext.getCmp('intTroncoPresente').getValue()) + parseInt(Ext.getCmp('intMayorLongitudAncho').getValue()) + parseInt(Ext.getCmp('intHombros').getValue()) + parseInt(Ext.getCmp('intMMSSUnidosTronco').getValue()) + parseInt(Ext.getCmp('intMMSSLugar').getValue()) + parseInt(Ext.getCmp('intCuelloPresente').getValue()) + parseInt(Ext.getCmp('intCuelloLugar').getValue()) + parseInt(Ext.getCmp('intOjos').getValue()) + parseInt(Ext.getCmp('intNariz').getValue()) + parseInt(Ext.getCmp('intBoca').getValue()) + parseInt(Ext.getCmp('int1213DosDimenciones').getValue()) + parseInt(Ext.getCmp('intOrificiosNasales').getValue()) + parseInt(Ext.getCmp('intPeloPresente').getValue()) + parseInt(Ext.getCmp('intPeloMejorDefinido').getValue()) + parseInt(Ext.getCmp('intManoDiferenteBrazo').getValue()) + parseInt(Ext.getCmp('intArticulacionCodoHombro').getValue()) + parseInt(Ext.getCmp('intCaderaRodilla').getValue()) + parseInt(Ext.getCmp('intCabezaAreaTronco').getValue()) + parseInt(Ext.getCmp('intBrazosIgualTronco').getValue()) + parseInt(Ext.getCmp('intPiernasTronco').getValue()) + parseInt(Ext.getCmp('intPiePierna').getValue()) + parseInt(Ext.getCmp('intBrazosPiernas2Dimensiones').getValue()) + parseInt(Ext.getCmp('intTalon').getValue()) + parseInt(Ext.getCmp('intLineasFirmesConectadas').getValue()) + parseInt(Ext.getCmp('intUnionesCorrectas').getValue()) + parseInt(Ext.getCmp('intPerfilCabeza').getValue()) + parseInt(Ext.getCmp('intPerfilTronco').getValue()) + parseInt(Ext.getCmp('intPerfilBrazosPiernas').getValue()) + parseInt(Ext.getCmp('intRasgos').getValue()) + parseInt(Ext.getCmp('intOidoPresente').getValue()) + parseInt(Ext.getCmp('intPocisionProporcionCorrectasOidos').getValue()));
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 50,
                                                                fieldLabel: 'Perfil de Cabeza',
                                                                name: 'Perfil de Cabeza',
                                                                allowBlank: true,
                                                                store: 'StoreEscalaValoracion',
                                                                valueField: 'Valor',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: 0,
                                                                id: 'intPerfilCabeza',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        if(pNew == null){
                                                                            Ext.getCmp('intPuntajeEscalaTotal').setValue(0);
                                                                        }else{
                                                                            Ext.getCmp('intPuntajeEscalaTotal').setValue(parseInt(Ext.getCmp('intCabeza').getValue()) + parseInt(Ext.getCmp('intPiernas').getValue()) + parseInt(Ext.getCmp('intBrazos').getValue()) + parseInt(Ext.getCmp('intTroncoPresente').getValue()) + parseInt(Ext.getCmp('intMayorLongitudAncho').getValue()) + parseInt(Ext.getCmp('intHombros').getValue()) + parseInt(Ext.getCmp('intMMSSUnidosTronco').getValue()) + parseInt(Ext.getCmp('intMMSSLugar').getValue()) + parseInt(Ext.getCmp('intCuelloPresente').getValue()) + parseInt(Ext.getCmp('intCuelloLugar').getValue()) + parseInt(Ext.getCmp('intOjos').getValue()) + parseInt(Ext.getCmp('intNariz').getValue()) + parseInt(Ext.getCmp('intBoca').getValue()) + parseInt(Ext.getCmp('int1213DosDimenciones').getValue()) + parseInt(Ext.getCmp('intOrificiosNasales').getValue()) + parseInt(Ext.getCmp('intPeloPresente').getValue()) + parseInt(Ext.getCmp('intPeloMejorDefinido').getValue()) + parseInt(Ext.getCmp('intManoDiferenteBrazo').getValue()) + parseInt(Ext.getCmp('intArticulacionCodoHombro').getValue()) + parseInt(Ext.getCmp('intCaderaRodilla').getValue()) + parseInt(Ext.getCmp('intCabezaAreaTronco').getValue()) + parseInt(Ext.getCmp('intBrazosIgualTronco').getValue()) + parseInt(Ext.getCmp('intPiernasTronco').getValue()) + parseInt(Ext.getCmp('intPiePierna').getValue()) + parseInt(Ext.getCmp('intBrazosPiernas2Dimensiones').getValue()) + parseInt(Ext.getCmp('intTalon').getValue()) + parseInt(Ext.getCmp('intLineasFirmesConectadas').getValue()) + parseInt(Ext.getCmp('intUnionesCorrectas').getValue()) + parseInt(Ext.getCmp('intPerfilCabeza').getValue()) + parseInt(Ext.getCmp('intPerfilTronco').getValue()) + parseInt(Ext.getCmp('intPerfilBrazosPiernas').getValue()) + parseInt(Ext.getCmp('intRasgos').getValue()) + parseInt(Ext.getCmp('intOidoPresente').getValue()) + parseInt(Ext.getCmp('intPocisionProporcionCorrectasOidos').getValue()));
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 50,
                                                                fieldLabel: 'Perfil de Tronco',
                                                                name: 'Perfil de Tronco',
                                                                allowBlank: true,
                                                                store: 'StoreEscalaValoracion',
                                                                valueField: 'Valor',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: 0,
                                                                id: 'intPerfilTronco',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        if(pNew == null){
                                                                            Ext.getCmp('intPuntajeEscalaTotal').setValue(0);
                                                                        }else{
                                                                            Ext.getCmp('intPuntajeEscalaTotal').setValue(parseInt(Ext.getCmp('intCabeza').getValue()) + parseInt(Ext.getCmp('intPiernas').getValue()) + parseInt(Ext.getCmp('intBrazos').getValue()) + parseInt(Ext.getCmp('intTroncoPresente').getValue()) + parseInt(Ext.getCmp('intMayorLongitudAncho').getValue()) + parseInt(Ext.getCmp('intHombros').getValue()) + parseInt(Ext.getCmp('intMMSSUnidosTronco').getValue()) + parseInt(Ext.getCmp('intMMSSLugar').getValue()) + parseInt(Ext.getCmp('intCuelloPresente').getValue()) + parseInt(Ext.getCmp('intCuelloLugar').getValue()) + parseInt(Ext.getCmp('intOjos').getValue()) + parseInt(Ext.getCmp('intNariz').getValue()) + parseInt(Ext.getCmp('intBoca').getValue()) + parseInt(Ext.getCmp('int1213DosDimenciones').getValue()) + parseInt(Ext.getCmp('intOrificiosNasales').getValue()) + parseInt(Ext.getCmp('intPeloPresente').getValue()) + parseInt(Ext.getCmp('intPeloMejorDefinido').getValue()) + parseInt(Ext.getCmp('intManoDiferenteBrazo').getValue()) + parseInt(Ext.getCmp('intArticulacionCodoHombro').getValue()) + parseInt(Ext.getCmp('intCaderaRodilla').getValue()) + parseInt(Ext.getCmp('intCabezaAreaTronco').getValue()) + parseInt(Ext.getCmp('intBrazosIgualTronco').getValue()) + parseInt(Ext.getCmp('intPiernasTronco').getValue()) + parseInt(Ext.getCmp('intPiePierna').getValue()) + parseInt(Ext.getCmp('intBrazosPiernas2Dimensiones').getValue()) + parseInt(Ext.getCmp('intTalon').getValue()) + parseInt(Ext.getCmp('intLineasFirmesConectadas').getValue()) + parseInt(Ext.getCmp('intUnionesCorrectas').getValue()) + parseInt(Ext.getCmp('intPerfilCabeza').getValue()) + parseInt(Ext.getCmp('intPerfilTronco').getValue()) + parseInt(Ext.getCmp('intPerfilBrazosPiernas').getValue()) + parseInt(Ext.getCmp('intRasgos').getValue()) + parseInt(Ext.getCmp('intOidoPresente').getValue()) + parseInt(Ext.getCmp('intPocisionProporcionCorrectasOidos').getValue()));
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 50,
                                                                fieldLabel: 'Perfil Brazos y Piernas',
                                                                name: 'Perfil Brazos y Piernas',
                                                                allowBlank: true,
                                                                store: 'StoreEscalaValoracion',
                                                                valueField: 'Valor',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: 0,
                                                                id: 'intPerfilBrazosPiernas',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        if(pNew == null){
                                                                            Ext.getCmp('intPuntajeEscalaTotal').setValue(0);
                                                                        }else{
                                                                            Ext.getCmp('intPuntajeEscalaTotal').setValue(parseInt(Ext.getCmp('intCabeza').getValue()) + parseInt(Ext.getCmp('intPiernas').getValue()) + parseInt(Ext.getCmp('intBrazos').getValue()) + parseInt(Ext.getCmp('intTroncoPresente').getValue()) + parseInt(Ext.getCmp('intMayorLongitudAncho').getValue()) + parseInt(Ext.getCmp('intHombros').getValue()) + parseInt(Ext.getCmp('intMMSSUnidosTronco').getValue()) + parseInt(Ext.getCmp('intMMSSLugar').getValue()) + parseInt(Ext.getCmp('intCuelloPresente').getValue()) + parseInt(Ext.getCmp('intCuelloLugar').getValue()) + parseInt(Ext.getCmp('intOjos').getValue()) + parseInt(Ext.getCmp('intNariz').getValue()) + parseInt(Ext.getCmp('intBoca').getValue()) + parseInt(Ext.getCmp('int1213DosDimenciones').getValue()) + parseInt(Ext.getCmp('intOrificiosNasales').getValue()) + parseInt(Ext.getCmp('intPeloPresente').getValue()) + parseInt(Ext.getCmp('intPeloMejorDefinido').getValue()) + parseInt(Ext.getCmp('intManoDiferenteBrazo').getValue()) + parseInt(Ext.getCmp('intArticulacionCodoHombro').getValue()) + parseInt(Ext.getCmp('intCaderaRodilla').getValue()) + parseInt(Ext.getCmp('intCabezaAreaTronco').getValue()) + parseInt(Ext.getCmp('intBrazosIgualTronco').getValue()) + parseInt(Ext.getCmp('intPiernasTronco').getValue()) + parseInt(Ext.getCmp('intPiePierna').getValue()) + parseInt(Ext.getCmp('intBrazosPiernas2Dimensiones').getValue()) + parseInt(Ext.getCmp('intTalon').getValue()) + parseInt(Ext.getCmp('intLineasFirmesConectadas').getValue()) + parseInt(Ext.getCmp('intUnionesCorrectas').getValue()) + parseInt(Ext.getCmp('intPerfilCabeza').getValue()) + parseInt(Ext.getCmp('intPerfilTronco').getValue()) + parseInt(Ext.getCmp('intPerfilBrazosPiernas').getValue()) + parseInt(Ext.getCmp('intRasgos').getValue()) + parseInt(Ext.getCmp('intOidoPresente').getValue()) + parseInt(Ext.getCmp('intPocisionProporcionCorrectasOidos').getValue()));
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 50,
                                                                fieldLabel: 'Rasgos',
                                                                name: 'Rasgos',
                                                                allowBlank: true,
                                                                store: 'StoreEscalaValoracion',
                                                                valueField: 'Valor',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: 0,
                                                                id: 'intRasgos',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        if(pNew == null){
                                                                            Ext.getCmp('intPuntajeEscalaTotal').setValue(0);
                                                                        }else{
                                                                            Ext.getCmp('intPuntajeEscalaTotal').setValue(parseInt(Ext.getCmp('intCabeza').getValue()) + parseInt(Ext.getCmp('intPiernas').getValue()) + parseInt(Ext.getCmp('intBrazos').getValue()) + parseInt(Ext.getCmp('intTroncoPresente').getValue()) + parseInt(Ext.getCmp('intMayorLongitudAncho').getValue()) + parseInt(Ext.getCmp('intHombros').getValue()) + parseInt(Ext.getCmp('intMMSSUnidosTronco').getValue()) + parseInt(Ext.getCmp('intMMSSLugar').getValue()) + parseInt(Ext.getCmp('intCuelloPresente').getValue()) + parseInt(Ext.getCmp('intCuelloLugar').getValue()) + parseInt(Ext.getCmp('intOjos').getValue()) + parseInt(Ext.getCmp('intNariz').getValue()) + parseInt(Ext.getCmp('intBoca').getValue()) + parseInt(Ext.getCmp('int1213DosDimenciones').getValue()) + parseInt(Ext.getCmp('intOrificiosNasales').getValue()) + parseInt(Ext.getCmp('intPeloPresente').getValue()) + parseInt(Ext.getCmp('intPeloMejorDefinido').getValue()) + parseInt(Ext.getCmp('intManoDiferenteBrazo').getValue()) + parseInt(Ext.getCmp('intArticulacionCodoHombro').getValue()) + parseInt(Ext.getCmp('intCaderaRodilla').getValue()) + parseInt(Ext.getCmp('intCabezaAreaTronco').getValue()) + parseInt(Ext.getCmp('intBrazosIgualTronco').getValue()) + parseInt(Ext.getCmp('intPiernasTronco').getValue()) + parseInt(Ext.getCmp('intPiePierna').getValue()) + parseInt(Ext.getCmp('intBrazosPiernas2Dimensiones').getValue()) + parseInt(Ext.getCmp('intTalon').getValue()) + parseInt(Ext.getCmp('intLineasFirmesConectadas').getValue()) + parseInt(Ext.getCmp('intUnionesCorrectas').getValue()) + parseInt(Ext.getCmp('intPerfilCabeza').getValue()) + parseInt(Ext.getCmp('intPerfilTronco').getValue()) + parseInt(Ext.getCmp('intPerfilBrazosPiernas').getValue()) + parseInt(Ext.getCmp('intRasgos').getValue()) + parseInt(Ext.getCmp('intOidoPresente').getValue()) + parseInt(Ext.getCmp('intPocisionProporcionCorrectasOidos').getValue()));
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 50,
                                                                fieldLabel: 'Oido Presente',
                                                                name: 'Oido Presente',
                                                                allowBlank: true,
                                                                store: 'StoreEscalaValoracion',
                                                                valueField: 'Valor',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: 0,
                                                                id: 'intOidoPresente',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        if(pNew == null){
                                                                            Ext.getCmp('intPuntajeEscalaTotal').setValue(0);
                                                                        }else{
                                                                            Ext.getCmp('intPuntajeEscalaTotal').setValue(parseInt(Ext.getCmp('intCabeza').getValue()) + parseInt(Ext.getCmp('intPiernas').getValue()) + parseInt(Ext.getCmp('intBrazos').getValue()) + parseInt(Ext.getCmp('intTroncoPresente').getValue()) + parseInt(Ext.getCmp('intMayorLongitudAncho').getValue()) + parseInt(Ext.getCmp('intHombros').getValue()) + parseInt(Ext.getCmp('intMMSSUnidosTronco').getValue()) + parseInt(Ext.getCmp('intMMSSLugar').getValue()) + parseInt(Ext.getCmp('intCuelloPresente').getValue()) + parseInt(Ext.getCmp('intCuelloLugar').getValue()) + parseInt(Ext.getCmp('intOjos').getValue()) + parseInt(Ext.getCmp('intNariz').getValue()) + parseInt(Ext.getCmp('intBoca').getValue()) + parseInt(Ext.getCmp('int1213DosDimenciones').getValue()) + parseInt(Ext.getCmp('intOrificiosNasales').getValue()) + parseInt(Ext.getCmp('intPeloPresente').getValue()) + parseInt(Ext.getCmp('intPeloMejorDefinido').getValue()) + parseInt(Ext.getCmp('intManoDiferenteBrazo').getValue()) + parseInt(Ext.getCmp('intArticulacionCodoHombro').getValue()) + parseInt(Ext.getCmp('intCaderaRodilla').getValue()) + parseInt(Ext.getCmp('intCabezaAreaTronco').getValue()) + parseInt(Ext.getCmp('intBrazosIgualTronco').getValue()) + parseInt(Ext.getCmp('intPiernasTronco').getValue()) + parseInt(Ext.getCmp('intPiePierna').getValue()) + parseInt(Ext.getCmp('intBrazosPiernas2Dimensiones').getValue()) + parseInt(Ext.getCmp('intTalon').getValue()) + parseInt(Ext.getCmp('intLineasFirmesConectadas').getValue()) + parseInt(Ext.getCmp('intUnionesCorrectas').getValue()) + parseInt(Ext.getCmp('intPerfilCabeza').getValue()) + parseInt(Ext.getCmp('intPerfilTronco').getValue()) + parseInt(Ext.getCmp('intPerfilBrazosPiernas').getValue()) + parseInt(Ext.getCmp('intRasgos').getValue()) + parseInt(Ext.getCmp('intOidoPresente').getValue()) + parseInt(Ext.getCmp('intPocisionProporcionCorrectasOidos').getValue()));
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 50,
                                                                fieldLabel: 'Pocision y Proporcion correctas de Oidos',
                                                                name: 'Pocision y Proporcion correctas de Oidos',
                                                                allowBlank: true,
                                                                store: 'StoreEscalaValoracion',
                                                                valueField: 'Valor',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: 0,
                                                                id: 'intPocisionProporcionCorrectasOidos',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        if(pNew == null){
                                                                            Ext.getCmp('intPuntajeEscalaTotal').setValue(0);
                                                                        }else{
                                                                            Ext.getCmp('intPuntajeEscalaTotal').setValue(parseInt(Ext.getCmp('intCabeza').getValue()) + parseInt(Ext.getCmp('intPiernas').getValue()) + parseInt(Ext.getCmp('intBrazos').getValue()) + parseInt(Ext.getCmp('intTroncoPresente').getValue()) + parseInt(Ext.getCmp('intMayorLongitudAncho').getValue()) + parseInt(Ext.getCmp('intHombros').getValue()) + parseInt(Ext.getCmp('intMMSSUnidosTronco').getValue()) + parseInt(Ext.getCmp('intMMSSLugar').getValue()) + parseInt(Ext.getCmp('intCuelloPresente').getValue()) + parseInt(Ext.getCmp('intCuelloLugar').getValue()) + parseInt(Ext.getCmp('intOjos').getValue()) + parseInt(Ext.getCmp('intNariz').getValue()) + parseInt(Ext.getCmp('intBoca').getValue()) + parseInt(Ext.getCmp('int1213DosDimenciones').getValue()) + parseInt(Ext.getCmp('intOrificiosNasales').getValue()) + parseInt(Ext.getCmp('intPeloPresente').getValue()) + parseInt(Ext.getCmp('intPeloMejorDefinido').getValue()) + parseInt(Ext.getCmp('intManoDiferenteBrazo').getValue()) + parseInt(Ext.getCmp('intArticulacionCodoHombro').getValue()) + parseInt(Ext.getCmp('intCaderaRodilla').getValue()) + parseInt(Ext.getCmp('intCabezaAreaTronco').getValue()) + parseInt(Ext.getCmp('intBrazosIgualTronco').getValue()) + parseInt(Ext.getCmp('intPiernasTronco').getValue()) + parseInt(Ext.getCmp('intPiePierna').getValue()) + parseInt(Ext.getCmp('intBrazosPiernas2Dimensiones').getValue()) + parseInt(Ext.getCmp('intTalon').getValue()) + parseInt(Ext.getCmp('intLineasFirmesConectadas').getValue()) + parseInt(Ext.getCmp('intUnionesCorrectas').getValue()) + parseInt(Ext.getCmp('intPerfilCabeza').getValue()) + parseInt(Ext.getCmp('intPerfilTronco').getValue()) + parseInt(Ext.getCmp('intPerfilBrazosPiernas').getValue()) + parseInt(Ext.getCmp('intRasgos').getValue()) + parseInt(Ext.getCmp('intOidoPresente').getValue()) + parseInt(Ext.getCmp('intPocisionProporcionCorrectasOidos').getValue()));
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                html: '<br>'
                                            },
                                            {
                                                xtype: 'numberfield',
                                                name: 'Puntaje Total',
                                                fieldLabel: 'Puntaje Total',
                                                width: 100,
                                                minValue: 0,
                                                value: 0,
                                                decimalPrecision: 0,
                                                allowBlank: true,
                                                id: 'intPuntajeEscalaTotal'
                                            },
                                            {
                                                html: '<br>'
                                            },
                                                        
                                            {
                                                xtype: 'fieldset',
                                                title: 'ESTADO NUTRICIONAL',
                                                layout: 'form',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Estado',
                                                                fieldLabel: 'Estado',
                                                                width: 250,
                                                                allowBlank: true,
                                                                store: stEstadoNutricional,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strEstadoNutricional',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue === "DESNUTRICION"){
                                                                            Ext.getCmp('strDesnutricion').allowBlank = false;
                                                                            Ext.getCmp('strDesnutricion').enable();
                                                                        }else{
                                                                            Ext.getCmp('strDesnutricion').allowBlank = true;
                                                                            Ext.getCmp('strDesnutricion').disable();
                                                                            Ext.getCmp('strDesnutricion').clearInvalid();
                                                                            Ext.getCmp('strDesnutricion').setValue(null);
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html: ' - '
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Estado',
                                                                width: 250,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                store: stDesnutricion,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strDesnutricion'
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'EVOLUCION',
                                                layout: 'table',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'EVOLUCION',
                                                        name: 'EVOLUCION',
                                                        height: 100,
                                                        allowBlank: false,
                                                        id: 'memEvolucion'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'FORMULACION POST-FECHA',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Realizar Formulacion para',
                                                        name: 'Realizar Formulacion para',
                                                        width: 250,
                                                        allowBlank: true,
                                                        store: stMesesFormulacion,
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: 1,
                                                        id: 'sysFormulacion'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'INFORMACION PROXIMA CITA',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 5,
                                                items: [
                                                        {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'datefield',
                                                                width: 120,
                                                                fieldLabel: 'Fecha Probable Proxima Cita',
                                                                name: 'Fecha Probable Proxima Cita',
                                                                allowBlank: true,
                                                                emptyText: '(dia/mes/año) ',
                                                                style: 'text-align:center;',
                                                                id: 'fecPROXCITACita'
                                                            },
                                                            {
                                                                html: 'Profesional que Atiende'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Profesional que Atiende',
                                                                width: 250,
                                                                allowBlank: true,
                                                                store: stProfesionalAtiende,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strPROXCITAProfesionalAtiende'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'Observacion',
                                                        name: 'Observacion',
                                                        height: 100,
                                                        allowBlank: true,
                                                        id: 'memPROXCITAObservacion'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'CONDUCTA',
                                                layout: 'table',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'CONDUCTA',
                                                        name: 'CONDUCTA',
                                                        height: 100,
                                                        allowBlank: false,
                                                        id: 'memConducta'
                                                    }
                                                ]
                                            },
                                            fsDiagnosticosConsulta
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Reporte de Paraclinicos y/o Examenes',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaParaclinicos',
                                layout: 'form',
                                items: [
                                     {
                                        xtype: 'grid',
                                        title: ' ',
                                        id: 'gridReporteParaclinicos',
                                        store: stReporteParaclinicos,
                                        anchor: "100%",
                                        height: 320,
                                        border: false,
                                        frame: true,
                                        loadMask: true,
                                        colModel: new Ext.ux.grid.LockingColumnModel([
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Id',
                                                sortable: false,
                                                width: 1,
                                                hidden: true,
                                                hideable: false,
                                                dataIndex: 'IdConsecutivoReporte'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Descripcion',
                                                sortable: false,
                                                width: 300,
                                                dataIndex: 'DescProced'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Fecha Solicitud',
                                                sortable: false,
                                                width: 90,
                                                dataIndex: 'FechaSolicitud'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Fecha Realiza',
                                                sortable: false,
                                                width: 120,
                                                dataIndex: 'FechaRealizacion'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Reporte',
                                                sortable: false,
                                                width: 150,
                                                renderer: renderValorReporte,
                                                dataIndex: 'ReporteTxt'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Observaciones',
                                                sortable: false,
                                                width: 150,
                                                renderer: renderObservaReporte,
                                                dataIndex: 'Observaciones'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Clasificacion',
                                                sortable: false,
                                                width: 80,
                                                renderer: renderClasificacionReporte,
                                                dataIndex: 'Clasificacion'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Solicitante',
                                                sortable: false,
                                                width: 150,
                                                dataIndex: 'Solicitante'
                                            }
                                        ]),
                                        selModel: new Ext.grid.RowSelectionModel({singleSelect:false}),
                                        viewConfig: {
                                            getRowClass: function(record, index) {
                                                if (record.get('Estado') === 'S')
                                                    return 'Negado';
                                                else
                                                    return;
                                            }
                                        },
                                        iconCls:'icon-grid',
                                        tbar:
                                            {
                                                xtype: 'toolbar',
                                                items: [
                                                    {
                                                        xtype: 'button',
                                                        text: 'Adicionar',
                                                        iconCls: 'btnAddRow',
                                                        listeners: {
                                                            click : function() {
                                                                var winReporteParaclinicos = new winReporteParaclinicos001Ui();
                                                                Ext.getCmp('intPacienteReporteParaclin').setValue(wPaciente);
                                                                Ext.getCmp('intCASReporteParaclin').setValue(wCAS);
                                                                Ext.getCmp('intUsuarioReporteParaclin').setValue(ID_USUARIO);
                                                                Ext.getCmp('intIdConsecutivoReporteParaclin').setValue(0);
                                                                winReporteParaclinicos.show();
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'tbseparator'
                                                    },
                                                    {
                                                        xtype: 'button',
                                                        text: 'Reportar',
                                                        iconCls: 'btnEditRow',
                                                        listeners: {
                                                            click : function() {
                                                                if(Ext.getCmp('gridReporteParaclinicos').selModel.getCount() === 1){
                                                                    var selections = Ext.getCmp('gridReporteParaclinicos').selModel.getSelections();
                                                                    if(parseInt(selections[0].json.CASReporte) === parseInt(wCAS)){
                                                                        var winReporteParaclinicos = new winReporteParaclinicos001Ui();
                                                                        Ext.getCmp('intPacienteReporteParaclin').setValue(wPaciente);
                                                                        Ext.getCmp('intCASReporteParaclin').setValue(wCAS);
                                                                        Ext.getCmp('intUsuarioReporteParaclin').setValue(ID_USUARIO);
                                                                        Ext.getCmp('intIdConsecutivoReporteParaclin').setValue(selections[0].json.IdConsecutivoReporte);
                                                                        Ext.getCmp('intConceptoOfiMedicalReporteParaclin').setValue(selections[0].json.IdProced);
                                                                        Ext.getCmp('strNomConceptoOfiMedicalReporteParaclin').setValue(selections[0].json.DescProced);
                                                                        Ext.getCmp('strNomQuienSolicitaReporteParaclin').setValue(selections[0].json.Solicitante);
                                                                        Ext.getCmp('fecFecSolicitudReporteParaclin').setValue(selections[0].json.FechaSolicitud);
                                                                        Ext.getCmp('fecFecRealizacionReporteParaclin').setValue(selections[0].json.FechaRealizacion);
                                                                        Ext.getCmp('strResultadoReporteParaclin').setValue(selections[0].json.ReporteTxt);
                                                                        Ext.getCmp('intValorReporteParaclin').setValue(selections[0].json.ReporteVal);
                                                                        Ext.getCmp('strClasificacionReporteParaclin').setValue(selections[0].json.Clasificacion);
                                                                        Ext.getCmp('strObservacionesReporteParaclin').setValue(selections[0].json.Observaciones);
                                                                        Ext.getCmp('sysSearchReporteParaclin').setVisible(false);
                                                                        winReporteParaclinicos.show();
                                                                    }else{
                                                                        if(selections[0].json.Estado === "S"){
                                                                            var winReporteParaclinicos = new winReporteParaclinicos001Ui();
                                                                            Ext.getCmp('intPacienteReporteParaclin').setValue(wPaciente);
                                                                            Ext.getCmp('intCASReporteParaclin').setValue(wCAS);
                                                                            Ext.getCmp('intUsuarioReporteParaclin').setValue(ID_USUARIO);
                                                                            Ext.getCmp('intIdConsecutivoReporteParaclin').setValue(selections[0].json.IdConsecutivoReporte);
                                                                            Ext.getCmp('intConceptoOfiMedicalReporteParaclin').setValue(selections[0].json.IdProced);
                                                                            Ext.getCmp('strNomConceptoOfiMedicalReporteParaclin').setValue(selections[0].json.DescProced);
                                                                            Ext.getCmp('strNomQuienSolicitaReporteParaclin').setValue(selections[0].json.Solicitante);
                                                                            //Ext.getCmp('strNomQuienSolicitaReporteParaclin').setReadOnly(true);
                                                                            Ext.getCmp('fecFecSolicitudReporteParaclin').setValue(selections[0].json.FechaSolicitud);
                                                                            Ext.getCmp('fecFecRealizacionReporteParaclin').setValue(selections[0].json.FechaRealizacion);
                                                                            Ext.getCmp('sysSearchReporteParaclin').setVisible(false);
                                                                            winReporteParaclinicos.show();
                                                                        }else{
                                                                            Ext.MessageBox.show({
                                                                                title: 'Error',
                                                                                msg: 'El registro no esta disponible para ser reportado',
                                                                                buttons: Ext.MessageBox.OK,
                                                                                icon: Ext.MessageBox.ERROR
                                                                            });
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'tbseparator'
                                                    },
                                                    {
                                                        xtype: 'button',
                                                        text: 'Eliminar',
                                                        iconCls: 'btnDelRow',
                                                        listeners: {
                                                            click : function() {
                                                                if(Ext.getCmp('gridReporteParaclinicos').selModel.getCount() === 1){
                                                                    var selections = Ext.getCmp('gridReporteParaclinicos').selModel.getSelections();
                                                                    if((selections[0].json.CAS === null || selections[0].json.CAS === "") && selections[0].json.Estado === "S" && parseInt(selections[0].json.Usuario) === parseInt(Ext.getCmp('sysUsuarioHC').getValue())){
                                                                        Ext.Msg.show({
                                                                            title: 'Reporte Paraclinicos',
                                                                            msg: 'Esta Seguro que Desea Eliminar el Registro ' + selections[0].json.DescProced + '?',
                                                                            buttons: Ext.Msg.YESNO,
                                                                            icon: Ext.Msg.QUESTION,
                                                                            fn: function(btn){
                                                                                if(btn ==="yes"){
                                                                                    fnEliminarRegistrosReporteParaclinicos001("../../controlador/asistencial/evolucionhc2013.php",{task: "ELIMINAR_REPORTEEXA", pIdReporte: selections[0].json.IdConsecutivoReporte}, 'gridReporteParaclinicos');
                                                                                }
                                                                            }
                                                                        });
                                                                    }else{
                                                                        Ext.MessageBox.show({
                                                                            title: 'Error',
                                                                            msg: 'No podemos eliminar los registro en estos momentos',
                                                                            buttons: Ext.MessageBox.OK,
                                                                            icon: Ext.MessageBox.ERROR
                                                                        });
                                                                    }
                                                                }else{
                                                                    Ext.MessageBox.show({
                                                                        title: 'Error',
                                                                        msg: 'No podemos eliminar los registros en estos momentos, verifique que solo haya seleccionado un registro',
                                                                        buttons: Ext.MessageBox.OK,
                                                                        icon: Ext.MessageBox.ERROR
                                                                    });
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'tbseparator'
                                                    },
                                                    '->',
                                                    new Ext.app.SearchField({
                                                        id: 'qryReporteParaclin',
                                                        store: stReporteParaclinicos,
                                                        ValparamP1: wPaciente,
                                                        emptyText: 'Escriba el criterio que desea buscar',
                                                        width: 120,
                                                        pLoadGrid: false,
                                                        pGrid: 'gridReporteParaclinicos',
                                                        parrParam: {params:{pPaciente: wPaciente}}
                                                    })
                                                ]
                                            }
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Medicamentos',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaMedicamentos',
                                items: [
                                    xSolMX
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Servicios',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaServicios',
                                items: [
                                    xSolEXA
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Remisiones',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaRemisiones',
                                items: [
                                    xSolREM
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud NO POS',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaNOPOS',
                                items: [
                                    xSolNOPOS
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Registro de Alertas',
                                height: 380,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaAlertas',
                                items: [
                                    xAlertasxPaciente
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Consentimientos Informados',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaConsentimientos',
                                layout: 'form',
                                items: [
                                    xConsentimientosInformados
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Notificacion Eventos Adversos',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaEventosAdversos',
                                layout: 'form',
                                items: [
                                    xEventosAdversos
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Kardex PyP - Programas Especiales',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaKardex',
                                layout: 'form',
                                items: [
                                    xKardexProgramas
                                ]
                            }
                        ]
                    }
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Salir',
                            iconCls: 'btnSalir',
                            id: 'btnSalirEvolucion',
                            listeners:{
                                click : function(){
                                    if (parseInt(Ext.getCmp('sysYaGuardoHC').getValue()) === 1){
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn === "yes")
                                                {
                                                    Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.getCmp('winHCCyD01').close();
                                                }
                                            }
                                        });
                                    }else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Usted No ha Guardado la Evolución del Paciente y Se Perdera la Información, Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn === "yes")
                                                {
                                                    Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.getCmp('winHCCyD01').close();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                },
                tbar:{
                    items: [
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Ver Historia Clínica',
                            iconCls: 'btnVerHC',
                            id: 'btnVerHC',
                            listeners:{
                                click : function(){
                                    var cmpResumenHC = new winFrmVerHistorialHC({
                                        renderTo: Ext.getBody()
                                    });
                                    Ext.getCmp('winViewEvolucionHC').title = "PACIENTE: " + Ext.getCmp('sysPacienteHC').getValue();
                                    Ext.getCmp('gridHistorialEvoluciones').store.load({
                                        params: {
                                            pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                                            pPaciente: Ext.getCmp('sysIdPacienteHC').getValue()
                                        }
                                    });
                                    cmpResumenHC.show();
                                }
                            }
                        },
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar Evolución',
                            iconCls: 'btnGuardar',
                            id: 'btnGuardarEvolucion',
                            listeners:{
                                click : function(){
                                    if (parseInt(Ext.getCmp('sysYaGuardoHC').getValue()) === 0)
                                    {
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Guardar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn === "yes")
                                                {
                                                    fnGuardarRegistrosCyD01();
                                                }
                                            }
                                        });
                                    }else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Modificar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn === "yes")
                                                {
                                                    fnModificarRegistrosCyD01();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                }
            }
        ];
        
        this.on({
            afterlayout:{
                scope:this, 
                single:true, 
                fn:function() {
                    Ext.Msg.hide();
                    if(paramOpcion === "Nuevo"){ 
                        var frm = Ext.getCmp('frmHCCyD01').getForm();
                        frm.doAction('load', {
                            url: '../../controlador/asistencial/evolucionhc2014.php',
                            waitMsg: 'Cargando Información...',
                            params:{
                                pCAS: myCAS,
                                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                                task: 'ImportarAntecedentesPersonalesOfiClinic002'
                            },
                            failure: function(response,options){
                                importarcrecimientoydesarrollo('frmHCCyD01', myCAS, Ext.getCmp('sysIdPacienteHC').getValue(),"CYD");
                            },
                            success:function(form, action) {
                                importarcrecimientoydesarrollo('frmHCCyD01', myCAS, Ext.getCmp('sysIdPacienteHC').getValue(),"CYD");
                            }
                        });
                        
                    }
                }
            }
        });
        winHCCrecimientoyDesarrollo001Ui.superclass.initComponent.call(this);
    }
});

function fnGuardarRegistrosCyD01(){
    var frm = Ext.getCmp('frmHCCyD01').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc2014.php',
            params:{
                task: 'guardar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue(),
                pFormulacion: Ext.getCmp('sysFormulacion').getValue(),
                
                //4505 IDENTIFICACION RIESGO
                pOcupacion4505: Ext.getCmp('strOcupacionHC').getValue(),
                pEtnia4505: Ext.getCmp('intEtniaHC').getValue(),
                pEscolaridad4505: Ext.getCmp('intEscolaridadHC').getValue(),
                pGestacion4505: Ext.getCmp('intIdentificacionRiesgoGestacion').getValue(),
                pSifilisGestacional4505: Ext.getCmp('intIdentificacionRiesgoSifilisGestacional').getValue(),
                pHipertencionGestacional4505: Ext.getCmp('intIdentificacionRiesgoHipertencionGestacional').getValue(),
                pHipotiroidismoCongenito4505: Ext.getCmp('intIdentificacionRiesgoHipotiroidismoCongenito').getValue(),
                pTuberculosisMultidrogoresistente4505: Ext.getCmp('intIdentificacionRiesgoTuberculosisMultidrogoresistente').getValue(),
                pLepra4505: Ext.getCmp('intIdentificacionRiesgoLepra').getValue(),
                pVictimaMaltrato4505: Ext.getCmp('intIdentificacionRiesgoVictimaMaltrato').getValue(),
                pViolenciaSexual4505: Ext.getCmp('intIdentificacionRiesgoViolenciaSexual').getValue(),
                pFluorosisDental4505: Ext.getCmp('intIdentificacionRiesgoFluorosisDental').getValue(),
                pEnfermedadMental4505: Ext.getCmp('intIdentificacionRiesgoEnfermedadMental').getValue(),
                pTransmisionSexual4505: Ext.getCmp('intIdentificacionRiesgoInfeccionesTransmisionSexual').getValue(),
                pSintomaticoRespiratorio4505: Ext.getCmp('intIdentificacionRiesgoSintomaticoRespiratorio').getValue(),
                
                //4505 CYD PRIMERA VEZ
                pCyDPrimeraVez4505: Ext.getCmp('sysCyDPrimeraVez4505').getValue(),
                
                //CRECIMIENTO Y DESARROLLO
                pGuardarCyD: "SI",
                pEscalaDesarrolloMotricidadGruesa0: Ext.getCmp('intEVALDESACyD_A0').getValue(),
                pEscalaDesarrolloMotricidadGruesa1: Ext.getCmp('intEVALDESACyD_A1').getValue(),
                pEscalaDesarrolloMotricidadGruesa2: Ext.getCmp('intEVALDESACyD_A2').getValue(),
                pEscalaDesarrolloMotricidadGruesa3: Ext.getCmp('intEVALDESACyD_A3').getValue(),
                pEscalaDesarrolloMotricidadGruesa4: Ext.getCmp('intEVALDESACyD_A4').getValue(),
                pEscalaDesarrolloMotricidadGruesa5: Ext.getCmp('intEVALDESACyD_A5').getValue(),
                pEscalaDesarrolloMotricidadGruesa6: Ext.getCmp('intEVALDESACyD_A6').getValue(),
                pEscalaDesarrolloMotricidadGruesa7: Ext.getCmp('intEVALDESACyD_A7').getValue(),
                pEscalaDesarrolloMotricidadGruesa8: Ext.getCmp('intEVALDESACyD_A8').getValue(),
                pEscalaDesarrolloMotricidadGruesa9: Ext.getCmp('intEVALDESACyD_A9').getValue(),
                pEscalaDesarrolloMotricidadGruesa10: Ext.getCmp('intEVALDESACyD_A10').getValue(),
                pEscalaDesarrolloMotricidadGruesa11: Ext.getCmp('intEVALDESACyD_A11').getValue(),
                pEscalaDesarrolloMotricidadGruesa12: Ext.getCmp('intEVALDESACyD_A12').getValue(),
                pEscalaDesarrolloMotricidadGruesa13: Ext.getCmp('intEVALDESACyD_A13').getValue(),
                pEscalaDesarrolloMotricidadGruesa14: Ext.getCmp('intEVALDESACyD_A14').getValue(),
                pEscalaDesarrolloMotricidadGruesa15: Ext.getCmp('intEVALDESACyD_A15').getValue(),
                pEscalaDesarrolloMotricidadGruesa16: Ext.getCmp('intEVALDESACyD_A16').getValue(),
                pEscalaDesarrolloMotricidadGruesa17: Ext.getCmp('intEVALDESACyD_A17').getValue(),
                pEscalaDesarrolloMotricidadGruesa18: Ext.getCmp('intEVALDESACyD_A18').getValue(),
                pEscalaDesarrolloMotricidadGruesa19: Ext.getCmp('intEVALDESACyD_A19').getValue(),
                pEscalaDesarrolloMotricidadGruesa20: Ext.getCmp('intEVALDESACyD_A20').getValue(),
                pEscalaDesarrolloMotricidadGruesa21: Ext.getCmp('intEVALDESACyD_A21').getValue(),
                pEscalaDesarrolloMotricidadGruesa22: Ext.getCmp('intEVALDESACyD_A22').getValue(),
                pEscalaDesarrolloMotricidadGruesa23: Ext.getCmp('intEVALDESACyD_A23').getValue(),
                pEscalaDesarrolloMotricidadGruesa24: Ext.getCmp('intEVALDESACyD_A24').getValue(),
                pEscalaDesarrolloMotricidadGruesa25: Ext.getCmp('intEVALDESACyD_A25').getValue(),
                pEscalaDesarrolloMotricidadGruesa26: Ext.getCmp('intEVALDESACyD_A26').getValue(),
                pEscalaDesarrolloMotricidadGruesa27: Ext.getCmp('intEVALDESACyD_A27').getValue(),
                pEscalaDesarrolloMotricidadGruesa28: Ext.getCmp('intEVALDESACyD_A28').getValue(),
                pEscalaDesarrolloMotricidadGruesa29: Ext.getCmp('intEVALDESACyD_A29').getValue(),
                pEscalaDesarrolloMotricidadGruesa30: Ext.getCmp('intEVALDESACyD_A30').getValue(),
                pEscalaDesarrolloMotricidadFina0: Ext.getCmp('intEVALDESACyD_B0').getValue(),
                pEscalaDesarrolloMotricidadFina1: Ext.getCmp('intEVALDESACyD_B1').getValue(),
                pEscalaDesarrolloMotricidadFina2: Ext.getCmp('intEVALDESACyD_B2').getValue(),
                pEscalaDesarrolloMotricidadFina3: Ext.getCmp('intEVALDESACyD_B3').getValue(),
                pEscalaDesarrolloMotricidadFina4: Ext.getCmp('intEVALDESACyD_B4').getValue(),
                pEscalaDesarrolloMotricidadFina5: Ext.getCmp('intEVALDESACyD_B5').getValue(),
                pEscalaDesarrolloMotricidadFina6: Ext.getCmp('intEVALDESACyD_B6').getValue(),
                pEscalaDesarrolloMotricidadFina7: Ext.getCmp('intEVALDESACyD_B7').getValue(),
                pEscalaDesarrolloMotricidadFina8: Ext.getCmp('intEVALDESACyD_B8').getValue(),
                pEscalaDesarrolloMotricidadFina9: Ext.getCmp('intEVALDESACyD_B9').getValue(),
                pEscalaDesarrolloMotricidadFina10: Ext.getCmp('intEVALDESACyD_B10').getValue(),
                pEscalaDesarrolloMotricidadFina11: Ext.getCmp('intEVALDESACyD_B11').getValue(),
                pEscalaDesarrolloMotricidadFina12: Ext.getCmp('intEVALDESACyD_B12').getValue(),
                pEscalaDesarrolloMotricidadFina13: Ext.getCmp('intEVALDESACyD_B13').getValue(),
                pEscalaDesarrolloMotricidadFina14: Ext.getCmp('intEVALDESACyD_B14').getValue(),
                pEscalaDesarrolloMotricidadFina15: Ext.getCmp('intEVALDESACyD_B15').getValue(),
                pEscalaDesarrolloMotricidadFina16: Ext.getCmp('intEVALDESACyD_B16').getValue(),
                pEscalaDesarrolloMotricidadFina17: Ext.getCmp('intEVALDESACyD_B17').getValue(),
                pEscalaDesarrolloMotricidadFina18: Ext.getCmp('intEVALDESACyD_B18').getValue(),
                pEscalaDesarrolloMotricidadFina19: Ext.getCmp('intEVALDESACyD_B19').getValue(),
                pEscalaDesarrolloMotricidadFina20: Ext.getCmp('intEVALDESACyD_B20').getValue(),
                pEscalaDesarrolloMotricidadFina21: Ext.getCmp('intEVALDESACyD_B21').getValue(),
                pEscalaDesarrolloMotricidadFina22: Ext.getCmp('intEVALDESACyD_B22').getValue(),
                pEscalaDesarrolloMotricidadFina23: Ext.getCmp('intEVALDESACyD_B23').getValue(),
                pEscalaDesarrolloMotricidadFina24: Ext.getCmp('intEVALDESACyD_B24').getValue(),
                pEscalaDesarrolloMotricidadFina25: Ext.getCmp('intEVALDESACyD_B25').getValue(),
                pEscalaDesarrolloMotricidadFina26: Ext.getCmp('intEVALDESACyD_B26').getValue(),
                pEscalaDesarrolloMotricidadFina27: Ext.getCmp('intEVALDESACyD_B27').getValue(),
                pEscalaDesarrolloMotricidadFina28: Ext.getCmp('intEVALDESACyD_B28').getValue(),
                pEscalaDesarrolloMotricidadFina29: Ext.getCmp('intEVALDESACyD_B29').getValue(),
                pEscalaDesarrolloMotricidadFina30: Ext.getCmp('intEVALDESACyD_B30').getValue(),
                pEscalaDesarrolloAudicionLenguaje0: Ext.getCmp('intEVALDESACyD_C0').getValue(),
                pEscalaDesarrolloAudicionLenguaje1: Ext.getCmp('intEVALDESACyD_C1').getValue(),
                pEscalaDesarrolloAudicionLenguaje2: Ext.getCmp('intEVALDESACyD_C2').getValue(),
                pEscalaDesarrolloAudicionLenguaje3: Ext.getCmp('intEVALDESACyD_C3').getValue(),
                pEscalaDesarrolloAudicionLenguaje4: Ext.getCmp('intEVALDESACyD_C4').getValue(),
                pEscalaDesarrolloAudicionLenguaje5: Ext.getCmp('intEVALDESACyD_C5').getValue(),
                pEscalaDesarrolloAudicionLenguaje6: Ext.getCmp('intEVALDESACyD_C6').getValue(),
                pEscalaDesarrolloAudicionLenguaje7: Ext.getCmp('intEVALDESACyD_C7').getValue(),
                pEscalaDesarrolloAudicionLenguaje8: Ext.getCmp('intEVALDESACyD_C8').getValue(),
                pEscalaDesarrolloAudicionLenguaje9: Ext.getCmp('intEVALDESACyD_C9').getValue(),
                pEscalaDesarrolloAudicionLenguaje10: Ext.getCmp('intEVALDESACyD_C10').getValue(),
                pEscalaDesarrolloAudicionLenguaje11: Ext.getCmp('intEVALDESACyD_C11').getValue(),
                pEscalaDesarrolloAudicionLenguaje12: Ext.getCmp('intEVALDESACyD_C12').getValue(),
                pEscalaDesarrolloAudicionLenguaje13: Ext.getCmp('intEVALDESACyD_C13').getValue(),
                pEscalaDesarrolloAudicionLenguaje14: Ext.getCmp('intEVALDESACyD_C14').getValue(),
                pEscalaDesarrolloAudicionLenguaje15: Ext.getCmp('intEVALDESACyD_C15').getValue(),
                pEscalaDesarrolloAudicionLenguaje16: Ext.getCmp('intEVALDESACyD_C16').getValue(),
                pEscalaDesarrolloAudicionLenguaje17: Ext.getCmp('intEVALDESACyD_C17').getValue(),
                pEscalaDesarrolloAudicionLenguaje18: Ext.getCmp('intEVALDESACyD_C18').getValue(),
                pEscalaDesarrolloAudicionLenguaje19: Ext.getCmp('intEVALDESACyD_C19').getValue(),
                pEscalaDesarrolloAudicionLenguaje20: Ext.getCmp('intEVALDESACyD_C20').getValue(),
                pEscalaDesarrolloAudicionLenguaje21: Ext.getCmp('intEVALDESACyD_C21').getValue(),
                pEscalaDesarrolloAudicionLenguaje22: Ext.getCmp('intEVALDESACyD_C22').getValue(),
                pEscalaDesarrolloAudicionLenguaje23: Ext.getCmp('intEVALDESACyD_C23').getValue(),
                pEscalaDesarrolloAudicionLenguaje24: Ext.getCmp('intEVALDESACyD_C24').getValue(),
                pEscalaDesarrolloAudicionLenguaje25: Ext.getCmp('intEVALDESACyD_C25').getValue(),
                pEscalaDesarrolloAudicionLenguaje26: Ext.getCmp('intEVALDESACyD_C26').getValue(),
                pEscalaDesarrolloAudicionLenguaje27: Ext.getCmp('intEVALDESACyD_C27').getValue(),
                pEscalaDesarrolloAudicionLenguaje28: Ext.getCmp('intEVALDESACyD_C28').getValue(),
                pEscalaDesarrolloAudicionLenguaje29: Ext.getCmp('intEVALDESACyD_C29').getValue(),
                pEscalaDesarrolloAudicionLenguaje30: Ext.getCmp('intEVALDESACyD_C30').getValue(),
                pEscalaDesarrolloPersonaSocial0: Ext.getCmp('intEVALDESACyD_D0').getValue(),
                pEscalaDesarrolloPersonaSocial1: Ext.getCmp('intEVALDESACyD_D1').getValue(),
                pEscalaDesarrolloPersonaSocial2: Ext.getCmp('intEVALDESACyD_D2').getValue(),
                pEscalaDesarrolloPersonaSocial3: Ext.getCmp('intEVALDESACyD_D3').getValue(),
                pEscalaDesarrolloPersonaSocial4: Ext.getCmp('intEVALDESACyD_D4').getValue(),
                pEscalaDesarrolloPersonaSocial5: Ext.getCmp('intEVALDESACyD_D5').getValue(),
                pEscalaDesarrolloPersonaSocial6: Ext.getCmp('intEVALDESACyD_D6').getValue(),
                pEscalaDesarrolloPersonaSocial7: Ext.getCmp('intEVALDESACyD_D7').getValue(),
                pEscalaDesarrolloPersonaSocial8: Ext.getCmp('intEVALDESACyD_D8').getValue(),
                pEscalaDesarrolloPersonaSocial9: Ext.getCmp('intEVALDESACyD_D9').getValue(),
                pEscalaDesarrolloPersonaSocial10: Ext.getCmp('intEVALDESACyD_D10').getValue(),
                pEscalaDesarrolloPersonaSocial11: Ext.getCmp('intEVALDESACyD_D11').getValue(),
                pEscalaDesarrolloPersonaSocial12: Ext.getCmp('intEVALDESACyD_D12').getValue(),
                pEscalaDesarrolloPersonaSocial13: Ext.getCmp('intEVALDESACyD_D13').getValue(),
                pEscalaDesarrolloPersonaSocial14: Ext.getCmp('intEVALDESACyD_D14').getValue(),
                pEscalaDesarrolloPersonaSocial15: Ext.getCmp('intEVALDESACyD_D15').getValue(),
                pEscalaDesarrolloPersonaSocial16: Ext.getCmp('intEVALDESACyD_D16').getValue(),
                pEscalaDesarrolloPersonaSocial17: Ext.getCmp('intEVALDESACyD_D17').getValue(),
                pEscalaDesarrolloPersonaSocial18: Ext.getCmp('intEVALDESACyD_D18').getValue(),
                pEscalaDesarrolloPersonaSocial19: Ext.getCmp('intEVALDESACyD_D19').getValue(),
                pEscalaDesarrolloPersonaSocial20: Ext.getCmp('intEVALDESACyD_D20').getValue(),
                pEscalaDesarrolloPersonaSocial21: Ext.getCmp('intEVALDESACyD_D21').getValue(),
                pEscalaDesarrolloPersonaSocial22: Ext.getCmp('intEVALDESACyD_D22').getValue(),
                pEscalaDesarrolloPersonaSocial23: Ext.getCmp('intEVALDESACyD_D23').getValue(),
                pEscalaDesarrolloPersonaSocial24: Ext.getCmp('intEVALDESACyD_D24').getValue(),
                pEscalaDesarrolloPersonaSocial25: Ext.getCmp('intEVALDESACyD_D25').getValue(),
                pEscalaDesarrolloPersonaSocial26: Ext.getCmp('intEVALDESACyD_D26').getValue(),
                pEscalaDesarrolloPersonaSocial27: Ext.getCmp('intEVALDESACyD_D27').getValue(),
                pEscalaDesarrolloPersonaSocial28: Ext.getCmp('intEVALDESACyD_D28').getValue(),
                pEscalaDesarrolloPersonaSocial29: Ext.getCmp('intEVALDESACyD_D29').getValue(),
                pEscalaDesarrolloPersonaSocial30: Ext.getCmp('intEVALDESACyD_D30').getValue(),
                pEscalaDesarrolloMotricidadGruesaCalificacion: Ext.getCmp('intEVALDESACyD_ACalificacion').getValue(),
                pEscalaDesarrolloMotricidadGruesaClasificacion: Ext.getCmp('strEVALDESACyD_AClasificacion').getValue(),
                pEscalaDesarrolloMotricidadFinaCalificacion: Ext.getCmp('intEVALDESACyD_BCalificacion').getValue(),
                pEscalaDesarrolloMotricidadFinaClasificacion: Ext.getCmp('strEVALDESACyD_BClasificacion').getValue(),
                pEscalaDesarrolloAudicionLenguajeCalificacion: Ext.getCmp('intEVALDESACyD_CCalificacion').getValue(),
                pEscalaDesarrolloAudicionLenguajeClasificacion: Ext.getCmp('strEVALDESACyD_CClasificacion').getValue(),
                pEscalaDesarrolloPersonaSocialCalificacion: Ext.getCmp('intEVALDESACyD_DCalificacion').getValue(),
                pEscalaDesarrolloPersonaSocialClasificacion: Ext.getCmp('strEVALDESACyD_DClasificacion').getValue(),
                pEscalaDesarrolloTotalCalificacion: Ext.getCmp('intEVALDESACyD_TotalCalificacion').getValue(),
                pEscalaDesarrolloTotalClasificacion: Ext.getCmp('strEVALDESACyD_TotalClasificacion').getValue(),
                pCurvaPesoSatisfactorio: Ext.getCmp('strCurPesoSatisfactorio').getValue(),
                pCurvaTalSatisfactorio: Ext.getCmp('strCurTalSatisfactorio').getValue(),
                pEscalaGoodenoughCabeza: Ext.getCmp('intCabeza').getValue(),
                pEscalaGoodenoughPiernas: Ext.getCmp('intPiernas').getValue(),
                pEscalaGoodenoughBrazos: Ext.getCmp('intBrazos').getValue(),
                pEscalaGoodenoughTroncoPresente: Ext.getCmp('intTroncoPresente').getValue(),
                pEscalaGoodenoughMayorLongitudAncho: Ext.getCmp('intMayorLongitudAncho').getValue(),
                pEscalaGoodenoughHombros: Ext.getCmp('intHombros').getValue(),
                pEscalaGoodenoughMMSSUnidoonco: Ext.getCmp('intMMSSUnidosTronco').getValue(),
                pEscalaGoodenoughMMSSLugar: Ext.getCmp('intMMSSLugar').getValue(),
                pEscalaGoodenoughCuelloPresente: Ext.getCmp('intCuelloPresente').getValue(),
                pEscalaGoodenoughCuelloLugar: Ext.getCmp('intCuelloLugar').getValue(),
                pEscalaGoodenoughOjos: Ext.getCmp('intOjos').getValue(),
                pEscalaGoodenoughNariz: Ext.getCmp('intNariz').getValue(),
                pEscalaGoodenoughBoca: Ext.getCmp('intBoca').getValue(),
                pEscalaGoodenough1213DosDimenciones: Ext.getCmp('int1213DosDimenciones').getValue(),
                pEscalaGoodenoughOrificiosNasales: Ext.getCmp('intOrificiosNasales').getValue(),
                pEscalaGoodenoughPeloPresente: Ext.getCmp('intPeloPresente').getValue(),
                pEscalaGoodenoughPeloMejorDefinido: Ext.getCmp('intPeloMejorDefinido').getValue(),
                pEscalaGoodenoughManoDiferenteBrazo: Ext.getCmp('intManoDiferenteBrazo').getValue(),
                pEscalaGoodenoughArticulacionCodoHombro: Ext.getCmp('intArticulacionCodoHombro').getValue(),
                pEscalaGoodenoughCaderaRodilla: Ext.getCmp('intCaderaRodilla').getValue(),
                pEscalaGoodenoughCabezaAreaTronco: Ext.getCmp('intCabezaAreaTronco').getValue(),
                pEscalaGoodenoughBrazosIgualTronco: Ext.getCmp('intBrazosIgualTronco').getValue(),
                pEscalaGoodenoughPiernaonco: Ext.getCmp('intPiernasTronco').getValue(),
                pEscalaGoodenoughPiePierna: Ext.getCmp('intPiePierna').getValue(),
                pEscalaGoodenoughBrazosPiernas2Dimensiones: Ext.getCmp('intBrazosPiernas2Dimensiones').getValue(),
                pEscalaGoodenoughTalon: Ext.getCmp('intTalon').getValue(),
                pEscalaGoodenoughLineasFirmesConectadas: Ext.getCmp('intLineasFirmesConectadas').getValue(),
                pEscalaGoodenoughUnionesCorrectas: Ext.getCmp('intUnionesCorrectas').getValue(),
                pEscalaGoodenoughPerfilCabeza: Ext.getCmp('intPerfilCabeza').getValue(),
                pEscalaGoodenoughPerfilTronco: Ext.getCmp('intPerfilTronco').getValue(),
                pEscalaGoodenoughPerfilBrazosPiernas: Ext.getCmp('intPerfilBrazosPiernas').getValue(),
                pEscalaGoodenoughRasgos: Ext.getCmp('intRasgos').getValue(),
                pEscalaGoodenoughOidoPresente: Ext.getCmp('intOidoPresente').getValue(),
                pEscalaGoodenoughPocisionProporcionCorrectasOidos: Ext.getCmp('intPocisionProporcionCorrectasOidos').getValue(),
                pEscalaGoodenoughPuntajeEscalaTotal: Ext.getCmp('intPuntajeEscalaTotal').getValue(),
                pEstadoNutricional: Ext.getCmp('strEstadoNutricional').getValue(),
                pEstadoNutricionalDesnutricion: Ext.getCmp('strDesnutricion').getValue(),

                //SIGNOS VITALES
                pGuardarSignos: "SI",
                pTASIS: Ext.getCmp('intEXAFISTASistolica').getValue(),
                pTADIAS: Ext.getCmp('intEXAFISTADiastolica').getValue(),
                pTalla: Ext.getCmp('intEXAFISTalla').getValue(),
                pPeso: Ext.getCmp('intEXAFISPeso').getValue(),
                pIMC: Ext.getCmp('intEXAFISIMC').getValue(),
                pTE: Ext.getCmp('intEXAFISTemp').getValue(),
                pFC: Ext.getCmp('intEXAFISFC').getValue(),
                pFR: Ext.getCmp('intEXAFISFR').getValue(),
                
                //ANTECEDENTES
                pPatologicos: Ext.getCmp('memANTPERSOPatologicos').getValue(),
                pFarmacologicos: Ext.getCmp('memANTPERSOFarmacologicos').getValue(),
                pQuirurgicos: Ext.getCmp('memANTPERSOQuirurgicos').getValue(),
                pTraumatologicos: Ext.getCmp('memANTPERSOTraumatologicos').getValue(),
                pToxicologicos: Ext.getCmp('memANTPERSOToxicologicos').getValue(),
                pAlergicos: Ext.getCmp('memANTPERSOAlergicos').getValue(),
                pHTA: Ext.getCmp('bolANTPERSOHTA').getValue(),
                pDiabetes: Ext.getCmp('bolANTPERSODiabetes').getValue(),
                pNefropatias: Ext.getCmp('bolANTPERSONefropatias').getValue(),
                pInfertilidad: Ext.getCmp('bolANTPERSOInfertilidad').getValue(),
                pVIH: Ext.getCmp('bolANTPERSOVIH').getValue(),
                pCardiopatias: Ext.getCmp('bolANTPERSOCardiopatias').getValue(),
                pGest: Ext.getCmp('intANTGINECOG').getValue(),
                pPartos: Ext.getCmp('intANTGINECOP').getValue(),
                pPVaginales: Ext.getCmp('intANTGINECOPV').getValue(),
                pAbortos: Ext.getCmp('intANTGINECOA').getValue(),
                pVivos: Ext.getCmp('intANTGINECOVivos').getValue(),
                pMuertos: Ext.getCmp('intANTGINECOMuertos').getValue(),
                pMola: Ext.getCmp('bolANTGINECOMola').getValue(),
                pEmbEctopico: Ext.getCmp('bolANTGINECOEmbEctopico').getValue(),
                pPreclampsia: Ext.getCmp('bolANTPERSOPreclampsia').getValue(),
                pEclampsia: Ext.getCmp('bolANTPERSOEclampsia').getValue(),
                pLactanciaHoy: Ext.getCmp('strANTGINECOLactanciaHoy').getValue(),
                pLactanciaPasado: Ext.getCmp('strANTGINECOLactanciaPasado').getValue(),
                pTiempoLactancia: Ext.getCmp('strANTGONECOTiempoLactancia').getValue(),
                pMenarquia: Ext.getCmp('strANTGINECOMenarquia').getValue(),
                pFum: Ext.getCmp('fecANTGINECOFum').getValue(),
                pFup: Ext.getCmp('fecANTGINECOFup').getValue(),
                pfecfuc: Ext.getCmp('fecANTGINECOFuc').getValue(),
                pFucRes: Ext.getCmp('strANTGINECOFucRes').getValue(),
                pMetodoPlanifica: Ext.getCmp('strANTGINECOMetodoPlanifica').getValue(),
                pCiclosMeuales: Ext.getCmp('strANTGINECOCiclosMestruales').getValue(),
                pActividadSexual: Ext.getCmp('strANTGINECOActividadSexual').getValue(),
                pPatologiaEmbarazo: Ext.getCmp('strANTGINECOPatologiaEmbarazo').getValue(),
                pMenopausia: Ext.getCmp('strANTGINECOMenopausia').getValue(),
                pAntFamiliares: Ext.getCmp('memAntecedentesFamiliares').getValue(),
                pGuardarAntecedentes: "SI"
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1);
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function fnModificarRegistrosCyD01(){
    var frm = Ext.getCmp('frmHCCyD01').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc2014.php',
            params:{
                task: 'modificar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue(),
                pFormulacion: Ext.getCmp('sysFormulacion').getValue(),
                
                //4505 IDENTIFICACION RIESGO
                pOcupacion4505: Ext.getCmp('strOcupacionHC').getValue(),
                pEtnia4505: Ext.getCmp('intEtniaHC').getValue(),
                pEscolaridad4505: Ext.getCmp('intEscolaridadHC').getValue(),
                pGestacion4505: Ext.getCmp('intIdentificacionRiesgoGestacion').getValue(),
                pSifilisGestacional4505: Ext.getCmp('intIdentificacionRiesgoSifilisGestacional').getValue(),
                pHipertencionGestacional4505: Ext.getCmp('intIdentificacionRiesgoHipertencionGestacional').getValue(),
                pHipotiroidismoCongenito4505: Ext.getCmp('intIdentificacionRiesgoHipotiroidismoCongenito').getValue(),
                pTuberculosisMultidrogoresistente4505: Ext.getCmp('intIdentificacionRiesgoTuberculosisMultidrogoresistente').getValue(),
                pLepra4505: Ext.getCmp('intIdentificacionRiesgoLepra').getValue(),
                pVictimaMaltrato4505: Ext.getCmp('intIdentificacionRiesgoVictimaMaltrato').getValue(),
                pViolenciaSexual4505: Ext.getCmp('intIdentificacionRiesgoViolenciaSexual').getValue(),
                pFluorosisDental4505: Ext.getCmp('intIdentificacionRiesgoFluorosisDental').getValue(),
                pEnfermedadMental4505: Ext.getCmp('intIdentificacionRiesgoEnfermedadMental').getValue(),
                pTransmisionSexual4505: Ext.getCmp('intIdentificacionRiesgoInfeccionesTransmisionSexual').getValue(),
                pSintomaticoRespiratorio4505: Ext.getCmp('intIdentificacionRiesgoSintomaticoRespiratorio').getValue(),
                
                //4505 CYD PRIMERA VEZ
                pCyDPrimeraVez4505: Ext.getCmp('sysCyDPrimeraVez4505').getValue(),
                
                
                //CRECIMIENTO Y DESARROLLO
                pGuardarCyD: "SI",
                pEscalaDesarrolloMotricidadGruesa0: Ext.getCmp('intEVALDESACyD_A0').getValue(),
                pEscalaDesarrolloMotricidadGruesa1: Ext.getCmp('intEVALDESACyD_A1').getValue(),
                pEscalaDesarrolloMotricidadGruesa2: Ext.getCmp('intEVALDESACyD_A2').getValue(),
                pEscalaDesarrolloMotricidadGruesa3: Ext.getCmp('intEVALDESACyD_A3').getValue(),
                pEscalaDesarrolloMotricidadGruesa4: Ext.getCmp('intEVALDESACyD_A4').getValue(),
                pEscalaDesarrolloMotricidadGruesa5: Ext.getCmp('intEVALDESACyD_A5').getValue(),
                pEscalaDesarrolloMotricidadGruesa6: Ext.getCmp('intEVALDESACyD_A6').getValue(),
                pEscalaDesarrolloMotricidadGruesa7: Ext.getCmp('intEVALDESACyD_A7').getValue(),
                pEscalaDesarrolloMotricidadGruesa8: Ext.getCmp('intEVALDESACyD_A8').getValue(),
                pEscalaDesarrolloMotricidadGruesa9: Ext.getCmp('intEVALDESACyD_A9').getValue(),
                pEscalaDesarrolloMotricidadGruesa10: Ext.getCmp('intEVALDESACyD_A10').getValue(),
                pEscalaDesarrolloMotricidadGruesa11: Ext.getCmp('intEVALDESACyD_A11').getValue(),
                pEscalaDesarrolloMotricidadGruesa12: Ext.getCmp('intEVALDESACyD_A12').getValue(),
                pEscalaDesarrolloMotricidadGruesa13: Ext.getCmp('intEVALDESACyD_A13').getValue(),
                pEscalaDesarrolloMotricidadGruesa14: Ext.getCmp('intEVALDESACyD_A14').getValue(),
                pEscalaDesarrolloMotricidadGruesa15: Ext.getCmp('intEVALDESACyD_A15').getValue(),
                pEscalaDesarrolloMotricidadGruesa16: Ext.getCmp('intEVALDESACyD_A16').getValue(),
                pEscalaDesarrolloMotricidadGruesa17: Ext.getCmp('intEVALDESACyD_A17').getValue(),
                pEscalaDesarrolloMotricidadGruesa18: Ext.getCmp('intEVALDESACyD_A18').getValue(),
                pEscalaDesarrolloMotricidadGruesa19: Ext.getCmp('intEVALDESACyD_A19').getValue(),
                pEscalaDesarrolloMotricidadGruesa20: Ext.getCmp('intEVALDESACyD_A20').getValue(),
                pEscalaDesarrolloMotricidadGruesa21: Ext.getCmp('intEVALDESACyD_A21').getValue(),
                pEscalaDesarrolloMotricidadGruesa22: Ext.getCmp('intEVALDESACyD_A22').getValue(),
                pEscalaDesarrolloMotricidadGruesa23: Ext.getCmp('intEVALDESACyD_A23').getValue(),
                pEscalaDesarrolloMotricidadGruesa24: Ext.getCmp('intEVALDESACyD_A24').getValue(),
                pEscalaDesarrolloMotricidadGruesa25: Ext.getCmp('intEVALDESACyD_A25').getValue(),
                pEscalaDesarrolloMotricidadGruesa26: Ext.getCmp('intEVALDESACyD_A26').getValue(),
                pEscalaDesarrolloMotricidadGruesa27: Ext.getCmp('intEVALDESACyD_A27').getValue(),
                pEscalaDesarrolloMotricidadGruesa28: Ext.getCmp('intEVALDESACyD_A28').getValue(),
                pEscalaDesarrolloMotricidadGruesa29: Ext.getCmp('intEVALDESACyD_A29').getValue(),
                pEscalaDesarrolloMotricidadGruesa30: Ext.getCmp('intEVALDESACyD_A30').getValue(),
                pEscalaDesarrolloMotricidadFina0: Ext.getCmp('intEVALDESACyD_B0').getValue(),
                pEscalaDesarrolloMotricidadFina1: Ext.getCmp('intEVALDESACyD_B1').getValue(),
                pEscalaDesarrolloMotricidadFina2: Ext.getCmp('intEVALDESACyD_B2').getValue(),
                pEscalaDesarrolloMotricidadFina3: Ext.getCmp('intEVALDESACyD_B3').getValue(),
                pEscalaDesarrolloMotricidadFina4: Ext.getCmp('intEVALDESACyD_B4').getValue(),
                pEscalaDesarrolloMotricidadFina5: Ext.getCmp('intEVALDESACyD_B5').getValue(),
                pEscalaDesarrolloMotricidadFina6: Ext.getCmp('intEVALDESACyD_B6').getValue(),
                pEscalaDesarrolloMotricidadFina7: Ext.getCmp('intEVALDESACyD_B7').getValue(),
                pEscalaDesarrolloMotricidadFina8: Ext.getCmp('intEVALDESACyD_B8').getValue(),
                pEscalaDesarrolloMotricidadFina9: Ext.getCmp('intEVALDESACyD_B9').getValue(),
                pEscalaDesarrolloMotricidadFina10: Ext.getCmp('intEVALDESACyD_B10').getValue(),
                pEscalaDesarrolloMotricidadFina11: Ext.getCmp('intEVALDESACyD_B11').getValue(),
                pEscalaDesarrolloMotricidadFina12: Ext.getCmp('intEVALDESACyD_B12').getValue(),
                pEscalaDesarrolloMotricidadFina13: Ext.getCmp('intEVALDESACyD_B13').getValue(),
                pEscalaDesarrolloMotricidadFina14: Ext.getCmp('intEVALDESACyD_B14').getValue(),
                pEscalaDesarrolloMotricidadFina15: Ext.getCmp('intEVALDESACyD_B15').getValue(),
                pEscalaDesarrolloMotricidadFina16: Ext.getCmp('intEVALDESACyD_B16').getValue(),
                pEscalaDesarrolloMotricidadFina17: Ext.getCmp('intEVALDESACyD_B17').getValue(),
                pEscalaDesarrolloMotricidadFina18: Ext.getCmp('intEVALDESACyD_B18').getValue(),
                pEscalaDesarrolloMotricidadFina19: Ext.getCmp('intEVALDESACyD_B19').getValue(),
                pEscalaDesarrolloMotricidadFina20: Ext.getCmp('intEVALDESACyD_B20').getValue(),
                pEscalaDesarrolloMotricidadFina21: Ext.getCmp('intEVALDESACyD_B21').getValue(),
                pEscalaDesarrolloMotricidadFina22: Ext.getCmp('intEVALDESACyD_B22').getValue(),
                pEscalaDesarrolloMotricidadFina23: Ext.getCmp('intEVALDESACyD_B23').getValue(),
                pEscalaDesarrolloMotricidadFina24: Ext.getCmp('intEVALDESACyD_B24').getValue(),
                pEscalaDesarrolloMotricidadFina25: Ext.getCmp('intEVALDESACyD_B25').getValue(),
                pEscalaDesarrolloMotricidadFina26: Ext.getCmp('intEVALDESACyD_B26').getValue(),
                pEscalaDesarrolloMotricidadFina27: Ext.getCmp('intEVALDESACyD_B27').getValue(),
                pEscalaDesarrolloMotricidadFina28: Ext.getCmp('intEVALDESACyD_B28').getValue(),
                pEscalaDesarrolloMotricidadFina29: Ext.getCmp('intEVALDESACyD_B29').getValue(),
                pEscalaDesarrolloMotricidadFina30: Ext.getCmp('intEVALDESACyD_B30').getValue(),
                pEscalaDesarrolloAudicionLenguaje0: Ext.getCmp('intEVALDESACyD_C0').getValue(),
                pEscalaDesarrolloAudicionLenguaje1: Ext.getCmp('intEVALDESACyD_C1').getValue(),
                pEscalaDesarrolloAudicionLenguaje2: Ext.getCmp('intEVALDESACyD_C2').getValue(),
                pEscalaDesarrolloAudicionLenguaje3: Ext.getCmp('intEVALDESACyD_C3').getValue(),
                pEscalaDesarrolloAudicionLenguaje4: Ext.getCmp('intEVALDESACyD_C4').getValue(),
                pEscalaDesarrolloAudicionLenguaje5: Ext.getCmp('intEVALDESACyD_C5').getValue(),
                pEscalaDesarrolloAudicionLenguaje6: Ext.getCmp('intEVALDESACyD_C6').getValue(),
                pEscalaDesarrolloAudicionLenguaje7: Ext.getCmp('intEVALDESACyD_C7').getValue(),
                pEscalaDesarrolloAudicionLenguaje8: Ext.getCmp('intEVALDESACyD_C8').getValue(),
                pEscalaDesarrolloAudicionLenguaje9: Ext.getCmp('intEVALDESACyD_C9').getValue(),
                pEscalaDesarrolloAudicionLenguaje10: Ext.getCmp('intEVALDESACyD_C10').getValue(),
                pEscalaDesarrolloAudicionLenguaje11: Ext.getCmp('intEVALDESACyD_C11').getValue(),
                pEscalaDesarrolloAudicionLenguaje12: Ext.getCmp('intEVALDESACyD_C12').getValue(),
                pEscalaDesarrolloAudicionLenguaje13: Ext.getCmp('intEVALDESACyD_C13').getValue(),
                pEscalaDesarrolloAudicionLenguaje14: Ext.getCmp('intEVALDESACyD_C14').getValue(),
                pEscalaDesarrolloAudicionLenguaje15: Ext.getCmp('intEVALDESACyD_C15').getValue(),
                pEscalaDesarrolloAudicionLenguaje16: Ext.getCmp('intEVALDESACyD_C16').getValue(),
                pEscalaDesarrolloAudicionLenguaje17: Ext.getCmp('intEVALDESACyD_C17').getValue(),
                pEscalaDesarrolloAudicionLenguaje18: Ext.getCmp('intEVALDESACyD_C18').getValue(),
                pEscalaDesarrolloAudicionLenguaje19: Ext.getCmp('intEVALDESACyD_C19').getValue(),
                pEscalaDesarrolloAudicionLenguaje20: Ext.getCmp('intEVALDESACyD_C20').getValue(),
                pEscalaDesarrolloAudicionLenguaje21: Ext.getCmp('intEVALDESACyD_C21').getValue(),
                pEscalaDesarrolloAudicionLenguaje22: Ext.getCmp('intEVALDESACyD_C22').getValue(),
                pEscalaDesarrolloAudicionLenguaje23: Ext.getCmp('intEVALDESACyD_C23').getValue(),
                pEscalaDesarrolloAudicionLenguaje24: Ext.getCmp('intEVALDESACyD_C24').getValue(),
                pEscalaDesarrolloAudicionLenguaje25: Ext.getCmp('intEVALDESACyD_C25').getValue(),
                pEscalaDesarrolloAudicionLenguaje26: Ext.getCmp('intEVALDESACyD_C26').getValue(),
                pEscalaDesarrolloAudicionLenguaje27: Ext.getCmp('intEVALDESACyD_C27').getValue(),
                pEscalaDesarrolloAudicionLenguaje28: Ext.getCmp('intEVALDESACyD_C28').getValue(),
                pEscalaDesarrolloAudicionLenguaje29: Ext.getCmp('intEVALDESACyD_C29').getValue(),
                pEscalaDesarrolloAudicionLenguaje30: Ext.getCmp('intEVALDESACyD_C30').getValue(),
                pEscalaDesarrolloPersonaSocial0: Ext.getCmp('intEVALDESACyD_D0').getValue(),
                pEscalaDesarrolloPersonaSocial1: Ext.getCmp('intEVALDESACyD_D1').getValue(),
                pEscalaDesarrolloPersonaSocial2: Ext.getCmp('intEVALDESACyD_D2').getValue(),
                pEscalaDesarrolloPersonaSocial3: Ext.getCmp('intEVALDESACyD_D3').getValue(),
                pEscalaDesarrolloPersonaSocial4: Ext.getCmp('intEVALDESACyD_D4').getValue(),
                pEscalaDesarrolloPersonaSocial5: Ext.getCmp('intEVALDESACyD_D5').getValue(),
                pEscalaDesarrolloPersonaSocial6: Ext.getCmp('intEVALDESACyD_D6').getValue(),
                pEscalaDesarrolloPersonaSocial7: Ext.getCmp('intEVALDESACyD_D7').getValue(),
                pEscalaDesarrolloPersonaSocial8: Ext.getCmp('intEVALDESACyD_D8').getValue(),
                pEscalaDesarrolloPersonaSocial9: Ext.getCmp('intEVALDESACyD_D9').getValue(),
                pEscalaDesarrolloPersonaSocial10: Ext.getCmp('intEVALDESACyD_D10').getValue(),
                pEscalaDesarrolloPersonaSocial11: Ext.getCmp('intEVALDESACyD_D11').getValue(),
                pEscalaDesarrolloPersonaSocial12: Ext.getCmp('intEVALDESACyD_D12').getValue(),
                pEscalaDesarrolloPersonaSocial13: Ext.getCmp('intEVALDESACyD_D13').getValue(),
                pEscalaDesarrolloPersonaSocial14: Ext.getCmp('intEVALDESACyD_D14').getValue(),
                pEscalaDesarrolloPersonaSocial15: Ext.getCmp('intEVALDESACyD_D15').getValue(),
                pEscalaDesarrolloPersonaSocial16: Ext.getCmp('intEVALDESACyD_D16').getValue(),
                pEscalaDesarrolloPersonaSocial17: Ext.getCmp('intEVALDESACyD_D17').getValue(),
                pEscalaDesarrolloPersonaSocial18: Ext.getCmp('intEVALDESACyD_D18').getValue(),
                pEscalaDesarrolloPersonaSocial19: Ext.getCmp('intEVALDESACyD_D19').getValue(),
                pEscalaDesarrolloPersonaSocial20: Ext.getCmp('intEVALDESACyD_D20').getValue(),
                pEscalaDesarrolloPersonaSocial21: Ext.getCmp('intEVALDESACyD_D21').getValue(),
                pEscalaDesarrolloPersonaSocial22: Ext.getCmp('intEVALDESACyD_D22').getValue(),
                pEscalaDesarrolloPersonaSocial23: Ext.getCmp('intEVALDESACyD_D23').getValue(),
                pEscalaDesarrolloPersonaSocial24: Ext.getCmp('intEVALDESACyD_D24').getValue(),
                pEscalaDesarrolloPersonaSocial25: Ext.getCmp('intEVALDESACyD_D25').getValue(),
                pEscalaDesarrolloPersonaSocial26: Ext.getCmp('intEVALDESACyD_D26').getValue(),
                pEscalaDesarrolloPersonaSocial27: Ext.getCmp('intEVALDESACyD_D27').getValue(),
                pEscalaDesarrolloPersonaSocial28: Ext.getCmp('intEVALDESACyD_D28').getValue(),
                pEscalaDesarrolloPersonaSocial29: Ext.getCmp('intEVALDESACyD_D29').getValue(),
                pEscalaDesarrolloPersonaSocial30: Ext.getCmp('intEVALDESACyD_D30').getValue(),
                pEscalaDesarrolloMotricidadGruesaCalificacion: Ext.getCmp('intEVALDESACyD_ACalificacion').getValue(),
                pEscalaDesarrolloMotricidadGruesaClasificacion: Ext.getCmp('strEVALDESACyD_AClasificacion').getValue(),
                pEscalaDesarrolloMotricidadFinaCalificacion: Ext.getCmp('intEVALDESACyD_BCalificacion').getValue(),
                pEscalaDesarrolloMotricidadFinaClasificacion: Ext.getCmp('strEVALDESACyD_BClasificacion').getValue(),
                pEscalaDesarrolloAudicionLenguajeCalificacion: Ext.getCmp('intEVALDESACyD_CCalificacion').getValue(),
                pEscalaDesarrolloAudicionLenguajeClasificacion: Ext.getCmp('strEVALDESACyD_CClasificacion').getValue(),
                pEscalaDesarrolloPersonaSocialCalificacion: Ext.getCmp('intEVALDESACyD_DCalificacion').getValue(),
                pEscalaDesarrolloPersonaSocialClasificacion: Ext.getCmp('strEVALDESACyD_DClasificacion').getValue(),
                pEscalaDesarrolloTotalCalificacion: Ext.getCmp('intEVALDESACyD_TotalCalificacion').getValue(),
                pEscalaDesarrolloTotalClasificacion: Ext.getCmp('strEVALDESACyD_TotalClasificacion').getValue(),
                pCurvaPesoSatisfactorio: Ext.getCmp('strCurPesoSatisfactorio').getValue(),
                pCurvaTalSatisfactorio: Ext.getCmp('strCurTalSatisfactorio').getValue(),
                pEscalaGoodenoughCabeza: Ext.getCmp('intCabeza').getValue(),
                pEscalaGoodenoughPiernas: Ext.getCmp('intPiernas').getValue(),
                pEscalaGoodenoughBrazos: Ext.getCmp('intBrazos').getValue(),
                pEscalaGoodenoughTroncoPresente: Ext.getCmp('intTroncoPresente').getValue(),
                pEscalaGoodenoughMayorLongitudAncho: Ext.getCmp('intMayorLongitudAncho').getValue(),
                pEscalaGoodenoughHombros: Ext.getCmp('intHombros').getValue(),
                pEscalaGoodenoughMMSSUnidoonco: Ext.getCmp('intMMSSUnidosTronco').getValue(),
                pEscalaGoodenoughMMSSLugar: Ext.getCmp('intMMSSLugar').getValue(),
                pEscalaGoodenoughCuelloPresente: Ext.getCmp('intCuelloPresente').getValue(),
                pEscalaGoodenoughCuelloLugar: Ext.getCmp('intCuelloLugar').getValue(),
                pEscalaGoodenoughOjos: Ext.getCmp('intOjos').getValue(),
                pEscalaGoodenoughNariz: Ext.getCmp('intNariz').getValue(),
                pEscalaGoodenoughBoca: Ext.getCmp('intBoca').getValue(),
                pEscalaGoodenough1213DosDimenciones: Ext.getCmp('int1213DosDimenciones').getValue(),
                pEscalaGoodenoughOrificiosNasales: Ext.getCmp('intOrificiosNasales').getValue(),
                pEscalaGoodenoughPeloPresente: Ext.getCmp('intPeloPresente').getValue(),
                pEscalaGoodenoughPeloMejorDefinido: Ext.getCmp('intPeloMejorDefinido').getValue(),
                pEscalaGoodenoughManoDiferenteBrazo: Ext.getCmp('intManoDiferenteBrazo').getValue(),
                pEscalaGoodenoughArticulacionCodoHombro: Ext.getCmp('intArticulacionCodoHombro').getValue(),
                pEscalaGoodenoughCaderaRodilla: Ext.getCmp('intCaderaRodilla').getValue(),
                pEscalaGoodenoughCabezaAreaTronco: Ext.getCmp('intCabezaAreaTronco').getValue(),
                pEscalaGoodenoughBrazosIgualTronco: Ext.getCmp('intBrazosIgualTronco').getValue(),
                pEscalaGoodenoughPiernaonco: Ext.getCmp('intPiernasTronco').getValue(),
                pEscalaGoodenoughPiePierna: Ext.getCmp('intPiePierna').getValue(),
                pEscalaGoodenoughBrazosPiernas2Dimensiones: Ext.getCmp('intBrazosPiernas2Dimensiones').getValue(),
                pEscalaGoodenoughTalon: Ext.getCmp('intTalon').getValue(),
                pEscalaGoodenoughLineasFirmesConectadas: Ext.getCmp('intLineasFirmesConectadas').getValue(),
                pEscalaGoodenoughUnionesCorrectas: Ext.getCmp('intUnionesCorrectas').getValue(),
                pEscalaGoodenoughPerfilCabeza: Ext.getCmp('intPerfilCabeza').getValue(),
                pEscalaGoodenoughPerfilTronco: Ext.getCmp('intPerfilTronco').getValue(),
                pEscalaGoodenoughPerfilBrazosPiernas: Ext.getCmp('intPerfilBrazosPiernas').getValue(),
                pEscalaGoodenoughRasgos: Ext.getCmp('intRasgos').getValue(),
                pEscalaGoodenoughOidoPresente: Ext.getCmp('intOidoPresente').getValue(),
                pEscalaGoodenoughPocisionProporcionCorrectasOidos: Ext.getCmp('intPocisionProporcionCorrectasOidos').getValue(),
                pEscalaGoodenoughPuntajeEscalaTotal: Ext.getCmp('intPuntajeEscalaTotal').getValue(),
                pEstadoNutricional: Ext.getCmp('strEstadoNutricional').getValue(),
                pEstadoNutricionalDesnutricion: Ext.getCmp('strDesnutricion').getValue(),

                //SIGNOS VITALES
                pGuardarSignos: "SI",
                pTASIS: Ext.getCmp('intEXAFISTASistolica').getValue(),
                pTADIAS: Ext.getCmp('intEXAFISTADiastolica').getValue(),
                pTalla: Ext.getCmp('intEXAFISTalla').getValue(),
                pPeso: Ext.getCmp('intEXAFISPeso').getValue(),
                pIMC: Ext.getCmp('intEXAFISIMC').getValue(),
                pTE: Ext.getCmp('intEXAFISTemp').getValue(),
                pFC: Ext.getCmp('intEXAFISFC').getValue(),
                pFR: Ext.getCmp('intEXAFISFR').getValue(),
                
                //ANTECEDENTES
                pPatologicos: Ext.getCmp('memANTPERSOPatologicos').getValue(),
                pFarmacologicos: Ext.getCmp('memANTPERSOFarmacologicos').getValue(),
                pQuirurgicos: Ext.getCmp('memANTPERSOQuirurgicos').getValue(),
                pTraumatologicos: Ext.getCmp('memANTPERSOTraumatologicos').getValue(),
                pToxicologicos: Ext.getCmp('memANTPERSOToxicologicos').getValue(),
                pAlergicos: Ext.getCmp('memANTPERSOAlergicos').getValue(),
                pHTA: Ext.getCmp('bolANTPERSOHTA').getValue(),
                pDiabetes: Ext.getCmp('bolANTPERSODiabetes').getValue(),
                pNefropatias: Ext.getCmp('bolANTPERSONefropatias').getValue(),
                pInfertilidad: Ext.getCmp('bolANTPERSOInfertilidad').getValue(),
                pVIH: Ext.getCmp('bolANTPERSOVIH').getValue(),
                pCardiopatias: Ext.getCmp('bolANTPERSOCardiopatias').getValue(),
                pGest: Ext.getCmp('intANTGINECOG').getValue(),
                pPartos: Ext.getCmp('intANTGINECOP').getValue(),
                pPVaginales: Ext.getCmp('intANTGINECOPV').getValue(),
                pAbortos: Ext.getCmp('intANTGINECOA').getValue(),
                pVivos: Ext.getCmp('intANTGINECOVivos').getValue(),
                pMuertos: Ext.getCmp('intANTGINECOMuertos').getValue(),
                pMola: Ext.getCmp('bolANTGINECOMola').getValue(),
                pEmbEctopico: Ext.getCmp('bolANTGINECOEmbEctopico').getValue(),
                pPreclampsia: Ext.getCmp('bolANTPERSOPreclampsia').getValue(),
                pEclampsia: Ext.getCmp('bolANTPERSOEclampsia').getValue(),
                pLactanciaHoy: Ext.getCmp('strANTGINECOLactanciaHoy').getValue(),
                pLactanciaPasado: Ext.getCmp('strANTGINECOLactanciaPasado').getValue(),
                pTiempoLactancia: Ext.getCmp('strANTGONECOTiempoLactancia').getValue(),
                pMenarquia: Ext.getCmp('strANTGINECOMenarquia').getValue(),
                pFum: Ext.getCmp('fecANTGINECOFum').getValue(),
                pFup: Ext.getCmp('fecANTGINECOFup').getValue(),
                pfecfuc: Ext.getCmp('fecANTGINECOFuc').getValue(),
                pFucRes: Ext.getCmp('strANTGINECOFucRes').getValue(),
                pMetodoPlanifica: Ext.getCmp('strANTGINECOMetodoPlanifica').getValue(),
                pCiclosMeuales: Ext.getCmp('strANTGINECOCiclosMestruales').getValue(),
                pActividadSexual: Ext.getCmp('strANTGINECOActividadSexual').getValue(),
                pPatologiaEmbarazo: Ext.getCmp('strANTGINECOPatologiaEmbarazo').getValue(),
                pMenopausia: Ext.getCmp('strANTGINECOMenopausia').getValue(),
                pAntFamiliares: Ext.getCmp('memAntecedentesFamiliares').getValue(),
                pGuardarAntecedentes: "SI"
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1);
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function calculoEdadPacienteMeses(){
    var valFecha1 = 0;
    var pFec2Anio = 0;
    var pFec2Mes = 0;
    var pFec2Dia = 0;
    var valFecha2 = 0;
    MesesCumplidos = 0;
    AniosCumplidos = 0;


    valFecha1 = Ext.getCmp('sysFechaHC').getValue();
    pFec2Anio = Ext.getCmp('sysFechaNac').getValue().substr(6,4);
    pFec2Mes = Ext.getCmp('sysFechaNac').getValue().substr(3,2);
    pFec2Dia = Ext.getCmp('sysFechaNac').getValue().substr(0,2);
    
    valFecha2 =  pFec2Anio + "/" + pFec2Mes + "/" + pFec2Dia;

    MesesCumplidos = MostrarEdadMeses(valFecha1, valFecha2);
    
    AniosCumplidos = MostrarEdadAnios(valFecha1, valFecha2);
}


    
function clasificacionEscala(){
    var valFecha1 = 0;
    var pFec2Anio = 0;
    var pFec2Mes = 0;
    var pFec2Dia = 0;
    var valFecha2 = 0;

    valFecha1 = Ext.getCmp('sysFechaHC').getValue();
    pFec2Anio = Ext.getCmp('sysFechaNac').getValue().substr(6,4);
    pFec2Mes = Ext.getCmp('sysFechaNac').getValue().substr(3,2);
    pFec2Dia = Ext.getCmp('sysFechaNac').getValue().substr(0,2);
    
    valFecha2 =  pFec2Anio + "/" + pFec2Mes + "/" + pFec2Dia;

    MesesCumplidos = MostrarEdadMeses(valFecha1, valFecha2);
    
    //alert("MESES CUMPLIDOS: " + MesesCumplidos);
    if(MesesCumplidos >= 0 && MesesCumplidos <= 72){
        //CRECIMIENTO Y DESARROLLO MOTRICIDAD GRUESA
        if(MesesCumplidos <= 3 && Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() <= 1){
            Ext.getCmp('strEVALDESACyD_AClasificacion').setValue("Alerta");
        }else{
            if(MesesCumplidos <= 3 && Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() >= 2 && Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() <= 3){
                Ext.getCmp('strEVALDESACyD_AClasificacion').setValue("Medio");
            }else{
                if(MesesCumplidos <= 3 && Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() >= 4 && Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() <= 5){
                    Ext.getCmp('strEVALDESACyD_AClasificacion').setValue("Medio Alto");
                }else{
                    if(MesesCumplidos >= 4 && MesesCumplidos <= 6 && Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() <= 4){
                        Ext.getCmp('strEVALDESACyD_AClasificacion').setValue("Alerta");
                    }else{
                        if(MesesCumplidos >= 4 && MesesCumplidos <= 6 && Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() <= 5 && Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() <= 6){
                            Ext.getCmp('strEVALDESACyD_AClasificacion').setValue("Medio");
                        }else{
                            if(MesesCumplidos >= 4 && MesesCumplidos <= 6 && Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() <= 7 && Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() <= 9){
                                Ext.getCmp('strEVALDESACyD_AClasificacion').setValue("Medio Alto");
                            }else{
                                if(MesesCumplidos >= 7 && MesesCumplidos <= 9 && Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() <= 7){
                                    Ext.getCmp('strEVALDESACyD_AClasificacion').setValue("Alerta");
                                }else{
                                    if(MesesCumplidos >= 7 && MesesCumplidos <= 9 && Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() <= 8 && Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() <= 10){
                                        Ext.getCmp('strEVALDESACyD_AClasificacion').setValue("Medio");
                                    }else{
                                        if(MesesCumplidos >= 7 && MesesCumplidos <= 9 && Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() <= 11 && Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() <= 13){
                                            Ext.getCmp('strEVALDESACyD_AClasificacion').setValue("Medio Alto");
                                        }else{
                                            if(MesesCumplidos >= 10 && MesesCumplidos <= 12 && Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() <= 11){
                                                Ext.getCmp('strEVALDESACyD_AClasificacion').setValue("Alerta");
                                            }else{
                                                if(MesesCumplidos >= 10 && MesesCumplidos <= 12 && Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() <= 12 && Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() <= 13){
                                                    Ext.getCmp('strEVALDESACyD_AClasificacion').setValue("Medio");
                                                }else{
                                                    if(MesesCumplidos >= 10 && MesesCumplidos <= 12 && Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() <= 14 && Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() <= 16){
                                                        Ext.getCmp('strEVALDESACyD_AClasificacion').setValue("Medio Alto");
                                                    }else{
                                                        if(MesesCumplidos >= 13 && MesesCumplidos <= 18 && Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() <= 13){
                                                            Ext.getCmp('strEVALDESACyD_AClasificacion').setValue("Alerta");
                                                        }else{
                                                            if(MesesCumplidos >= 13 && MesesCumplidos <= 18 && Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() <= 14 && Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() <= 16){
                                                                Ext.getCmp('strEVALDESACyD_AClasificacion').setValue("Medio");
                                                            }else{
                                                                if(MesesCumplidos >= 13 && MesesCumplidos <= 18 && Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() <= 17 && Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() <= 19){
                                                                    Ext.getCmp('strEVALDESACyD_AClasificacion').setValue("Medio Alto");
                                                                }else{
                                                                    if(MesesCumplidos >= 19 && MesesCumplidos <= 24 && Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() <= 16){
                                                                        Ext.getCmp('strEVALDESACyD_AClasificacion').setValue("Alerta");
                                                                    }else{
                                                                        if(MesesCumplidos >= 19 && MesesCumplidos <= 24 && Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() <= 17 && Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() <= 19){
                                                                            Ext.getCmp('strEVALDESACyD_AClasificacion').setValue("Medio");
                                                                        }else{
                                                                            if(MesesCumplidos >= 19 && MesesCumplidos <= 24 && Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() <= 20 && Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() <= 23){
                                                                                Ext.getCmp('strEVALDESACyD_AClasificacion').setValue("Medio Alto");
                                                                            }else{
                                                                                if(MesesCumplidos >= 25 && MesesCumplidos <= 36 && Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() <= 19){
                                                                                    Ext.getCmp('strEVALDESACyD_AClasificacion').setValue("Alerta");
                                                                                }else{
                                                                                    if(MesesCumplidos >= 25 && MesesCumplidos <= 36 && Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() <= 20 && Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() <= 23){
                                                                                        Ext.getCmp('strEVALDESACyD_AClasificacion').setValue("Medio");
                                                                                    }else{
                                                                                        if(MesesCumplidos >= 25 && MesesCumplidos <= 36 && Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() <= 24 && Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() <= 27){
                                                                                            Ext.getCmp('strEVALDESACyD_AClasificacion').setValue("Medio Alto");
                                                                                        }else{
                                                                                            if(MesesCumplidos >= 37 && MesesCumplidos <= 48 && Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() <= 22){
                                                                                                Ext.getCmp('strEVALDESACyD_AClasificacion').setValue("Alerta");
                                                                                            }else{
                                                                                                if(MesesCumplidos >= 37 && MesesCumplidos <= 48 && Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() <= 23 && Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() <= 26){
                                                                                                    Ext.getCmp('strEVALDESACyD_AClasificacion').setValue("Medio");
                                                                                                }else{
                                                                                                    if(MesesCumplidos >= 37 && MesesCumplidos <= 48 && Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() <= 27 && Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() <= 29){
                                                                                                        Ext.getCmp('strEVALDESACyD_AClasificacion').setValue("Medio Alto");
                                                                                                    }else{
                                                                                                        if(MesesCumplidos >= 49 && MesesCumplidos <= 60 && Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() <= 26){
                                                                                                            Ext.getCmp('strEVALDESACyD_AClasificacion').setValue("Alerta");
                                                                                                        }else{
                                                                                                            if(MesesCumplidos >= 49 && MesesCumplidos <= 60 && Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() <= 27 && Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() <= 29){
                                                                                                                Ext.getCmp('strEVALDESACyD_AClasificacion').setValue("Medio");
                                                                                                            }else{
                                                                                                                if(MesesCumplidos >= 49 && MesesCumplidos <= 60 && Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() === 30){
                                                                                                                    Ext.getCmp('strEVALDESACyD_AClasificacion').setValue("Medio Alto");
                                                                                                                }else{
                                                                                                                    Ext.getCmp('strEVALDESACyD_AClasificacion').setValue("Alto");
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }

        //CRECIMIENTO Y DESARROLLO MOTRICIDAD FINA
        if(MesesCumplidos <= 3 && Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() <= 1){
            Ext.getCmp('strEVALDESACyD_BClasificacion').setValue("Alerta");
        }else{
            if(MesesCumplidos <= 3 && Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() >= 2 && Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() <= 3){
                Ext.getCmp('strEVALDESACyD_BClasificacion').setValue("Medio");
            }else{
                if(MesesCumplidos <= 3 && Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() >= 4 && Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() <= 5){
                    Ext.getCmp('strEVALDESACyD_BClasificacion').setValue("Medio Alto");
                }else{
                    if(MesesCumplidos >= 4 && MesesCumplidos <= 6 && Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() <= 4){
                        Ext.getCmp('strEVALDESACyD_BClasificacion').setValue("Alerta");
                    }else{
                        if(MesesCumplidos >= 4 && MesesCumplidos <= 6 && Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() <= 5 && Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() <= 6){
                            Ext.getCmp('strEVALDESACyD_BClasificacion').setValue("Medio");
                        }else{
                            if(MesesCumplidos >= 4 && MesesCumplidos <= 6 && Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() <= 7 && Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() <= 9){
                                Ext.getCmp('strEVALDESACyD_BClasificacion').setValue("Medio Alto");
                            }else{
                                if(MesesCumplidos >= 7 && MesesCumplidos <= 9 && Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() <= 7){
                                    Ext.getCmp('strEVALDESACyD_BClasificacion').setValue("Alerta");
                                }else{
                                    if(MesesCumplidos >= 7 && MesesCumplidos <= 9 && Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() <= 8 && Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() <= 10){
                                        Ext.getCmp('strEVALDESACyD_BClasificacion').setValue("Medio");
                                    }else{
                                        if(MesesCumplidos >= 7 && MesesCumplidos <= 9 && Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() <= 11 && Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() <= 13){
                                            Ext.getCmp('strEVALDESACyD_BClasificacion').setValue("Medio Alto");
                                        }else{
                                            if(MesesCumplidos >= 10 && MesesCumplidos <= 12 && Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() <= 9){
                                                Ext.getCmp('strEVALDESACyD_BClasificacion').setValue("Alerta");
                                            }else{
                                                if(MesesCumplidos >= 10 && MesesCumplidos <= 12 && Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() <= 10 && Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() <= 12){
                                                    Ext.getCmp('strEVALDESACyD_BClasificacion').setValue("Medio");
                                                }else{
                                                    if(MesesCumplidos >= 10 && MesesCumplidos <= 12 && Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() <= 13 && Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() <= 14){
                                                        Ext.getCmp('strEVALDESACyD_BClasificacion').setValue("Medio Alto");
                                                    }else{
                                                        if(MesesCumplidos >= 13 && MesesCumplidos <= 18 && Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() <= 12){
                                                            Ext.getCmp('strEVALDESACyD_BClasificacion').setValue("Alerta");
                                                        }else{
                                                            if(MesesCumplidos >= 13 && MesesCumplidos <= 18 && Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() <= 13 && Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() <= 15){
                                                                Ext.getCmp('strEVALDESACyD_BClasificacion').setValue("Medio");
                                                            }else{
                                                                if(MesesCumplidos >= 13 && MesesCumplidos <= 18 && Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() <= 16 && Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() <= 18){
                                                                    Ext.getCmp('strEVALDESACyD_BClasificacion').setValue("Medio Alto");
                                                                }else{
                                                                    if(MesesCumplidos >= 19 && MesesCumplidos <= 24 && Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() <= 14){
                                                                        Ext.getCmp('strEVALDESACyD_BClasificacion').setValue("Alerta");
                                                                    }else{
                                                                        if(MesesCumplidos >= 19 && MesesCumplidos <= 24 && Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() <= 15 && Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() <= 18){
                                                                            Ext.getCmp('strEVALDESACyD_BClasificacion').setValue("Medio");
                                                                        }else{
                                                                            if(MesesCumplidos >= 19 && MesesCumplidos <= 24 && Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() <= 19 && Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() <= 20){
                                                                                Ext.getCmp('strEVALDESACyD_BClasificacion').setValue("Medio Alto");
                                                                            }else{
                                                                                if(MesesCumplidos >= 25 && MesesCumplidos <= 36 && Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() <= 18){
                                                                                    Ext.getCmp('strEVALDESACyD_BClasificacion').setValue("Alerta");
                                                                                }else{
                                                                                    if(MesesCumplidos >= 25 && MesesCumplidos <= 36 && Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() <= 19 && Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() <= 21){
                                                                                        Ext.getCmp('strEVALDESACyD_BClasificacion').setValue("Medio");
                                                                                    }else{
                                                                                        if(MesesCumplidos >= 25 && MesesCumplidos <= 36 && Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() <= 22 && Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() <= 24){
                                                                                            Ext.getCmp('strEVALDESACyD_BClasificacion').setValue("Medio Alto");
                                                                                        }else{
                                                                                            if(MesesCumplidos >= 37 && MesesCumplidos <= 48 && Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() <= 21){
                                                                                                Ext.getCmp('strEVALDESACyD_BClasificacion').setValue("Alerta");
                                                                                            }else{
                                                                                                if(MesesCumplidos >= 37 && MesesCumplidos <= 48 && Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() <= 22 && Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() <= 24){
                                                                                                    Ext.getCmp('strEVALDESACyD_BClasificacion').setValue("Medio");
                                                                                                }else{
                                                                                                    if(MesesCumplidos >= 37 && MesesCumplidos <= 48 && Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() <= 25 && Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() <= 28){
                                                                                                        Ext.getCmp('strEVALDESACyD_BClasificacion').setValue("Medio Alto");
                                                                                                    }else{
                                                                                                        if(MesesCumplidos >= 49 && MesesCumplidos <= 60 && Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() <= 23){
                                                                                                            Ext.getCmp('strEVALDESACyD_BClasificacion').setValue("Alerta");
                                                                                                        }else{
                                                                                                            if(MesesCumplidos >= 49 && MesesCumplidos <= 60 && Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() <= 24 && Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() <= 28){
                                                                                                                Ext.getCmp('strEVALDESACyD_BClasificacion').setValue("Medio");
                                                                                                            }else{
                                                                                                                if(MesesCumplidos >= 49 && MesesCumplidos <= 60 && Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() === 29){
                                                                                                                    Ext.getCmp('strEVALDESACyD_BClasificacion').setValue("Medio Alto");
                                                                                                                }else{
                                                                                                                    Ext.getCmp('strEVALDESACyD_BClasificacion').setValue("Alto");
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }

        //CRECIMIENTO Y DESARROLLO AUDICION LENGUAJE
        if(MesesCumplidos <= 3 && Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() <= 1){
            Ext.getCmp('strEVALDESACyD_CClasificacion').setValue("Alerta");
        }else{
            if(MesesCumplidos <= 3 && Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() >= 2 && Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() <= 3){
                Ext.getCmp('strEVALDESACyD_CClasificacion').setValue("Medio");
            }else{
                if(MesesCumplidos <= 3 && Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() >= 4 && Ext.getCmp(