/*
* @category    Panel Programas Especiales
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


pnProgramasEspecialesUi = Ext.extend(Ext.Panel, {
    anchor: '100%',
    autoHeight: true,
    layout: 'form',
    collapseFirst: false,
    collapsible: false,
    animCollapse: false,
    titleCollapse: false,
    border: false,
    padding: 0,
    id: 'pnProgramasEspeciales',
    initComponent: function() {
        this.items = [
            {
                xtype: 'panel',
                anchor: '100%',
                autoHeight: true,
                layout: 'form',
                labelWidth: 260,
                padding: 5,
                items: [
                    {
                        xtype: 'combo',
                        labelStyle: 'background-color:#FF0; color:#F00; text-decoration:blink;',
                        fieldLabel: 'Registrar HC Programas Especiales?',
                        name: 'Registrar HC Programas Especiales?',
                        width: 60,
                        allowBlank: false,
                        store: 'StoreSiNo',
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        mode: 'local',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 10,
                        triggerAction: 'all',
                        id: 'strRegistrarProgramasEspeciales',
                        listeners:{
                            change : function( t, newValue, oldValue){
                                if(newValue == "NO"){
                                    Ext.getCmp('fsProgramasEspeciales').setVisible(false);
                                    Ext.getCmp('strPROGESPEProfesionalAtiende').allowBlank = true;
                                    Ext.getCmp('fecPROGESPECita').allowBlank = true;
                                    Ext.getCmp('fecPROGESPEIngreso').allowBlank = true;
                                    Ext.getCmp('strPROGESPEViaCaptacion').allowBlank = true;
                                    Ext.getCmp('strPROGESPEDxHTA').allowBlank = true;
                                    Ext.getCmp('strPROGESPETipoDxHTA').allowBlank = true;
                                    Ext.getCmp('strPROGESPENivelRiesgoHTA').allowBlank = true;
                                    Ext.getCmp('intPROGESPEDxHTAMes').allowBlank = true;
                                    Ext.getCmp('intPROGESPEDxHTAAno').allowBlank = true;
                                    Ext.getCmp('strPROGESPEDxDM').allowBlank = true;
                                    Ext.getCmp('strPROGESPETipoDxDM').allowBlank = true;
                                    Ext.getCmp('strPROGESPENivelRiesgoDM').allowBlank = true;
                                    Ext.getCmp('intPROGESPEDxDMMes').allowBlank = true;
                                    Ext.getCmp('intPROGESPEDxDMAno').allowBlank = true;
                                    Ext.getCmp('strPROGESPETipoDM').allowBlank = true;
                                    Ext.getCmp('strPROGESPEDxNefroProteccion').allowBlank = true;
                                    Ext.getCmp('strPROGESPETipoDxNefroProteccion').allowBlank = true;
                                    Ext.getCmp('strPROGESPENivelRiesgoNefroProteccion').allowBlank = true;
                                    Ext.getCmp('intPROGESPEDxNefroProteccionMes').allowBlank = true;
                                    Ext.getCmp('intPROGESPEDxNefroProteccionAno').allowBlank = true;
                                    Ext.getCmp('strPROGESPEEstadioNefroProteccion').allowBlank = true;
                                    Ext.getCmp('memPROGESPEMetasTerapeuticas').allowBlank = true;
                                    Ext.getCmp('strPROGESPECumplimientoMetas').allowBlank = true;
                                    Ext.getCmp('intPROGESPENumCumplimientoMetas').allowBlank = true;
                                    Ext.getCmp('strPROGESPETraeParcialorina').allowBlank=true;
                                    Ext.getCmp('fecPROGESPEParcialorina').allowBlank=true;
                                    Ext.getCmp('strPROGESPEParcialorinaRes').allowBlank=true;
                                    Ext.getCmp('strPROGESPETraeColesterolTotal').allowBlank=true;
                                    Ext.getCmp('fecPROGESPEColesterolTotal').allowBlank=true;
                                    Ext.getCmp('strPROGESPEColesterolTotalRes').allowBlank=true;
                                    Ext.getCmp('strPROGESPETraeColesterolHDL').allowBlank=true;
                                    Ext.getCmp('fecPROGESPEColesterolHDL').allowBlank=true;
                                    Ext.getCmp('strPROGESPEColesterolHDLRes').allowBlank=true;
                                    Ext.getCmp('strPROGESPETraeColesterolLDL').allowBlank=true;
                                    Ext.getCmp('fecPROGESPEColesterolLDL').allowBlank=true;
                                    Ext.getCmp('strPROGESPEColesterolLDLRes').allowBlank=true;
                                    Ext.getCmp('strPROGESPETraeTrigliceridos').allowBlank=true;
                                    Ext.getCmp('fecPROGESPETrigliceridos').allowBlank=true;
                                    Ext.getCmp('strPROGESPETrigliceridosRes').allowBlank=true;
                                    Ext.getCmp('strPROGESPETraeHemoglobinaGlicosilada').allowBlank=true;
                                    Ext.getCmp('fecPROGESPEHemoglobinaGlicosilada').allowBlank=true;
                                    Ext.getCmp('strPROGESPEHemoglobinaGlicosiladaRes').allowBlank=true;
                                    Ext.getCmp('strPROGESPETraeGlicemia').allowBlank=true;
                                    Ext.getCmp('fecPROGESPEGlicemia').allowBlank=true;
                                    Ext.getCmp('strPROGESPEGlicemiaRes').allowBlank=true;
                                    Ext.getCmp('strPROGESPETraeMicroAlbuminuria').allowBlank=true;
                                    Ext.getCmp('fecPROGESPEMicroAlbuminuria').allowBlank=true;
                                    Ext.getCmp('strPROGESPEMicroAlbuminuriaRes').allowBlank=true;
                                    Ext.getCmp('strPROGESPETraeUrea').allowBlank=true;
                                    Ext.getCmp('fecPROGESPEUrea').allowBlank=true;
                                    Ext.getCmp('strPROGESPEUreaRes').allowBlank=true;
                                    Ext.getCmp('strPROGESPETraeCreatinina').allowBlank=true;
                                    Ext.getCmp('fecPROGESPECreatinina').allowBlank=true;
                                    Ext.getCmp('strPROGESPECreatininaRes').allowBlank=true;
                                    Ext.getCmp('strPROGESPEAnteriorTraeParcialorina').allowBlank=true;
                                    Ext.getCmp('fecPROGESPEAnteriorParcialorina').allowBlank=true;
                                    Ext.getCmp('strPROGESPEAnteriorParcialorinaRes').allowBlank=true;
                                    Ext.getCmp('strPROGESPEAnteriorTraeColesterolTotal').allowBlank=true;
                                    Ext.getCmp('fecPROGESPEAnteriorColesterolTotal').allowBlank=true;
                                    Ext.getCmp('strPROGESPEAnteriorColesterolTotalRes').allowBlank=true;
                                    Ext.getCmp('strPROGESPEAnteriorTraeColesterolHDL').allowBlank=true;
                                    Ext.getCmp('fecPROGESPEAnteriorColesterolHDL').allowBlank=true;
                                    Ext.getCmp('strPROGESPEAnteriorColesterolHDLRes').allowBlank=true;
                                    Ext.getCmp('strPROGESPEAnteriorTraeColesterolLDL').allowBlank=true;
                                    Ext.getCmp('fecPROGESPEAnteriorColesterolLDL').allowBlank=true;
                                    Ext.getCmp('strPROGESPEAnteriorColesterolLDLRes').allowBlank=true;
                                    Ext.getCmp('strPROGESPEAnteriorTraeTrigliceridos').allowBlank=true;
                                    Ext.getCmp('fecPROGESPEAnteriorTrigliceridos').allowBlank=true;
                                    Ext.getCmp('strPROGESPEAnteriorTrigliceridosRes').allowBlank=true;
                                    Ext.getCmp('strPROGESPEAnteriorTraeHemoglobinaGlicosilada').allowBlank=true;
                                    Ext.getCmp('fecPROGESPEAnteriorHemoglobinaGlicosilada').allowBlank=true;
                                    Ext.getCmp('strPROGESPEAnteriorHemoglobinaGlicosiladaRes').allowBlank=true;
                                    Ext.getCmp('strPROGESPEAnteriorTraeGlicemia').allowBlank=true;
                                    Ext.getCmp('fecPROGESPEAnteriorGlicemia').allowBlank=true;
                                    Ext.getCmp('strPROGESPEAnteriorGlicemiaRes').allowBlank=true;
                                    Ext.getCmp('strPROGESPEAnteriorTraeMicroAlbuminuria').allowBlank=true;
                                    Ext.getCmp('fecPROGESPEAnteriorMicroAlbuminuria').allowBlank=true;
                                    Ext.getCmp('strPROGESPEAnteriorMicroAlbuminuriaRes').allowBlank=true;
                                    Ext.getCmp('strPROGESPEAnteriorTraeUrea').allowBlank=true;
                                    Ext.getCmp('fecPROGESPEAnteriorUrea').allowBlank=true;
                                    Ext.getCmp('strPROGESPEAnteriorUreaRes').allowBlank=true;
                                    Ext.getCmp('strPROGESPEAnteriorTraeCreatinina').allowBlank=true;
                                    Ext.getCmp('fecPROGESPEAnteriorCreatinina').allowBlank=true;
                                    Ext.getCmp('strPROGESPEAnteriorCreatininaRes').allowBlank=true;
                                    Ext.getCmp('strPROGESPEAnteriorTFG').allowBlank=true;
                                    Ext.getCmp('strPROGESPESeguimientoTraeParcialorina').allowBlank=true;
                                    Ext.getCmp('fecPROGESPESeguimientoParcialorina').allowBlank=true;
                                    Ext.getCmp('strPROGESPESeguimientoParcialorinaRes').allowBlank=true;
                                    Ext.getCmp('strPROGESPESeguimientoTraeColesterolTotal').allowBlank=true;
                                    Ext.getCmp('fecPROGESPESeguimientoColesterolTotal').allowBlank=true;
                                    Ext.getCmp('strPROGESPESeguimientoColesterolTotalRes').allowBlank=true;
                                    Ext.getCmp('strPROGESPESeguimientoTraeColesterolHDL').allowBlank=true;
                                    Ext.getCmp('fecPROGESPESeguimientoColesterolHDL').allowBlank=true;
                                    Ext.getCmp('strPROGESPESeguimientoColesterolHDLRes').allowBlank=true;
                                    Ext.getCmp('strPROGESPESeguimientoTraeColesterolLDL').allowBlank=true;
                                    Ext.getCmp('fecPROGESPESeguimientoColesterolLDL').allowBlank=true;
                                    Ext.getCmp('strPROGESPESeguimientoColesterolLDLRes').allowBlank=true;
                                    Ext.getCmp('strPROGESPESeguimientoTraeTrigliceridos').allowBlank=true;
                                    Ext.getCmp('fecPROGESPESeguimientoTrigliceridos').allowBlank=true;
                                    Ext.getCmp('strPROGESPESeguimientoTrigliceridosRes').allowBlank=true;
                                    Ext.getCmp('strPROGESPESeguimientoTraeHemoglobinaGlicosilada').allowBlank=true;
                                    Ext.getCmp('fecPROGESPESeguimientoHemoglobinaGlicosilada').allowBlank=true;
                                    Ext.getCmp('strPROGESPESeguimientoHemoglobinaGlicosiladaRes').allowBlank=true;
                                    Ext.getCmp('strPROGESPESeguimientoTraeGlicemia').allowBlank=true;
                                    Ext.getCmp('fecPROGESPESeguimientoGlicemia').allowBlank=true;
                                    Ext.getCmp('strPROGESPESeguimientoGlicemiaRes').allowBlank=true;
                                    Ext.getCmp('strPROGESPESeguimientoTraeMicroAlbuminuria').allowBlank=true;
                                    Ext.getCmp('fecPROGESPESeguimientoMicroAlbuminuria').allowBlank=true;
                                    Ext.getCmp('strPROGESPESeguimientoMicroAlbuminuriaRes').allowBlank=true;
                                    Ext.getCmp('strPROGESPESeguimientoTraeUrea').allowBlank=true;
                                    Ext.getCmp('fecPROGESPESeguimientoUrea').allowBlank=true;
                                    Ext.getCmp('strPROGESPESeguimientoUreaRes').allowBlank=true;
                                    Ext.getCmp('strPROGESPESeguimientoTraeCreatinina').allowBlank=true;
                                    Ext.getCmp('fecPROGESPESeguimientoCreatinina').allowBlank=true;
                                    Ext.getCmp('strPROGESPESeguimientoCreatininaRes').allowBlank=true;
                                    Ext.getCmp('strPROGESPEProfesionalAtiende').setValue(null);
                                    Ext.getCmp('fecPROGESPECita').setValue(null);
                                    Ext.getCmp('strPROGESPETraeParcialorina').setValue(null);
                                    Ext.getCmp('fecPROGESPEParcialorina').setValue(null);
                                    Ext.getCmp('strPROGESPEParcialorinaRes').setValue(null);
                                    Ext.getCmp('strPROGESPETraeColesterolTotal').setValue(null);
                                    Ext.getCmp('fecPROGESPEColesterolTotal').setValue(null);
                                    Ext.getCmp('strPROGESPEColesterolTotalRes').setValue(null);
                                    Ext.getCmp('strPROGESPETraeColesterolHDL').setValue(null);
                                    Ext.getCmp('fecPROGESPEColesterolHDL').setValue(null);
                                    Ext.getCmp('strPROGESPEColesterolHDLRes').setValue(null);
                                    Ext.getCmp('strPROGESPETraeColesterolLDL').setValue(null);
                                    Ext.getCmp('fecPROGESPEColesterolLDL').setValue(null);
                                    Ext.getCmp('strPROGESPEColesterolLDLRes').setValue(null);
                                    Ext.getCmp('strPROGESPETraeTrigliceridos').setValue(null);
                                    Ext.getCmp('fecPROGESPETrigliceridos').setValue(null);
                                    Ext.getCmp('strPROGESPETrigliceridosRes').setValue(null);
                                    Ext.getCmp('strPROGESPETraeHemoglobinaGlicosilada').setValue(null);
                                    Ext.getCmp('fecPROGESPEHemoglobinaGlicosilada').setValue(null);
                                    Ext.getCmp('strPROGESPEHemoglobinaGlicosiladaRes').setValue(null);
                                    Ext.getCmp('strPROGESPETraeGlicemia').setValue(null);
                                    Ext.getCmp('fecPROGESPEGlicemia').setValue(null);
                                    Ext.getCmp('strPROGESPEGlicemiaRes').setValue(null);
                                    Ext.getCmp('strPROGESPETraeMicroAlbuminuria').setValue(null);
                                    Ext.getCmp('fecPROGESPEMicroAlbuminuria').setValue(null);
                                    Ext.getCmp('strPROGESPEMicroAlbuminuriaRes').setValue(null);
                                    Ext.getCmp('strPROGESPETraeUrea').setValue(null);
                                    Ext.getCmp('fecPROGESPEUrea').setValue(null);
                                    Ext.getCmp('strPROGESPEUreaRes').setValue(null);
                                    Ext.getCmp('strPROGESPETraeCreatinina').setValue(null);
                                    Ext.getCmp('fecPROGESPECreatinina').setValue(null);
                                    Ext.getCmp('strPROGESPECreatininaRes').setValue(null);
                                    Ext.getCmp('strPROGESPEAnteriorTraeParcialorina').setValue(null);
                                    Ext.getCmp('fecPROGESPEAnteriorParcialorina').setValue(null);
                                    Ext.getCmp('strPROGESPEAnteriorParcialorinaRes').setValue(null);
                                    Ext.getCmp('strPROGESPEAnteriorTraeColesterolTotal').setValue(null);
                                    Ext.getCmp('fecPROGESPEAnteriorColesterolTotal').setValue(null);
                                    Ext.getCmp('strPROGESPEAnteriorColesterolTotalRes').setValue(null);
                                    Ext.getCmp('strPROGESPEAnteriorTraeColesterolHDL').setValue(null);
                                    Ext.getCmp('fecPROGESPEAnteriorColesterolHDL').setValue(null);
                                    Ext.getCmp('strPROGESPEAnteriorColesterolHDLRes').setValue(null);
                                    Ext.getCmp('strPROGESPEAnteriorTraeColesterolLDL').setValue(null);
                                    Ext.getCmp('fecPROGESPEAnteriorColesterolLDL').setValue(null);
                                    Ext.getCmp('strPROGESPEAnteriorColesterolLDLRes').setValue(null);
                                    Ext.getCmp('strPROGESPEAnteriorTraeTrigliceridos').setValue(null);
                                    Ext.getCmp('fecPROGESPEAnteriorTrigliceridos').setValue(null);
                                    Ext.getCmp('strPROGESPEAnteriorTrigliceridosRes').setValue(null);
                                    Ext.getCmp('strPROGESPEAnteriorTraeHemoglobinaGlicosilada').setValue(null);
                                    Ext.getCmp('fecPROGESPEAnteriorHemoglobinaGlicosilada').setValue(null);
                                    Ext.getCmp('strPROGESPEAnteriorHemoglobinaGlicosiladaRes').setValue(null);
                                    Ext.getCmp('strPROGESPEAnteriorTraeGlicemia').setValue(null);
                                    Ext.getCmp('fecPROGESPEAnteriorGlicemia').setValue(null);
                                    Ext.getCmp('strPROGESPEAnteriorGlicemiaRes').setValue(null);
                                    Ext.getCmp('strPROGESPEAnteriorTraeMicroAlbuminuria').setValue(null);
                                    Ext.getCmp('fecPROGESPEAnteriorMicroAlbuminuria').setValue(null);
                                    Ext.getCmp('strPROGESPEAnteriorMicroAlbuminuriaRes').setValue(null);
                                    Ext.getCmp('strPROGESPEAnteriorTraeUrea').setValue(null);
                                    Ext.getCmp('fecPROGESPEAnteriorUrea').setValue(null);
                                    Ext.getCmp('strPROGESPEAnteriorUreaRes').setValue(null);
                                    Ext.getCmp('strPROGESPEAnteriorTraeCreatinina').setValue(null);
                                    Ext.getCmp('fecPROGESPEAnteriorCreatinina').setValue(null);
                                    Ext.getCmp('strPROGESPEAnteriorCreatininaRes').setValue(null);
                                    Ext.getCmp('strPROGESPEAnteriorTFG').setValue(null);
                                    Ext.getCmp('strPROGESPESeguimientoTraeParcialorina').setValue(null);
                                    Ext.getCmp('fecPROGESPESeguimientoParcialorina').setValue(null);
                                    Ext.getCmp('strPROGESPESeguimientoParcialorinaRes').setValue(null);
                                    Ext.getCmp('strPROGESPESeguimientoTraeColesterolTotal').setValue(null);
                                    Ext.getCmp('fecPROGESPESeguimientoColesterolTotal').setValue(null);
                                    Ext.getCmp('strPROGESPESeguimientoColesterolTotalRes').setValue(null);
                                    Ext.getCmp('strPROGESPESeguimientoTraeColesterolHDL').setValue(null);
                                    Ext.getCmp('fecPROGESPESeguimientoColesterolHDL').setValue(null);
                                    Ext.getCmp('strPROGESPESeguimientoColesterolHDLRes').setValue(null);
                                    Ext.getCmp('strPROGESPESeguimientoTraeColesterolLDL').setValue(null);
                                    Ext.getCmp('fecPROGESPESeguimientoColesterolLDL').setValue(null);
                                    Ext.getCmp('strPROGESPESeguimientoColesterolLDLRes').setValue(null);
                                    Ext.getCmp('strPROGESPESeguimientoTraeTrigliceridos').setValue(null);
                                    Ext.getCmp('fecPROGESPESeguimientoTrigliceridos').setValue(null);
                                    Ext.getCmp('strPROGESPESeguimientoTrigliceridosRes').setValue(null);
                                    Ext.getCmp('strPROGESPESeguimientoTraeHemoglobinaGlicosilada').setValue(null);
                                    Ext.getCmp('fecPROGESPESeguimientoHemoglobinaGlicosilada').setValue(null);
                                    Ext.getCmp('strPROGESPESeguimientoHemoglobinaGlicosiladaRes').setValue(null);
                                    Ext.getCmp('strPROGESPESeguimientoTraeGlicemia').setValue(null);
                                    Ext.getCmp('fecPROGESPESeguimientoGlicemia').setValue(null);
                                    Ext.getCmp('strPROGESPESeguimientoGlicemiaRes').setValue(null);
                                    Ext.getCmp('strPROGESPESeguimientoTraeMicroAlbuminuria').setValue(null);
                                    Ext.getCmp('fecPROGESPESeguimientoMicroAlbuminuria').setValue(null);
                                    Ext.getCmp('strPROGESPESeguimientoMicroAlbuminuriaRes').setValue(null);
                                    Ext.getCmp('strPROGESPESeguimientoTraeUrea').setValue(null);
                                    Ext.getCmp('fecPROGESPESeguimientoUrea').setValue(null);
                                    Ext.getCmp('strPROGESPESeguimientoUreaRes').setValue(null);
                                    Ext.getCmp('strPROGESPESeguimientoTraeCreatinina').setValue(null);
                                    Ext.getCmp('fecPROGESPESeguimientoCreatinina').setValue(null);
                                    Ext.getCmp('strPROGESPESeguimientoCreatininaRes').setValue(null);
                                    Ext.getCmp('fecPROGESPEIngreso').setValue(null);
                                    Ext.getCmp('strPROGESPEViaCaptacion').setValue(null);
                                    Ext.getCmp('strPROGESPEDxHTA').setValue(null);
                                    Ext.getCmp('strPROGESPETipoDxHTA').setValue(null);
                                    Ext.getCmp('strPROGESPENivelRiesgoHTA').setValue(null);
                                    Ext.getCmp('intPROGESPEDxHTAMes').setValue(null);
                                    Ext.getCmp('intPROGESPEDxHTAAno').setValue(null);
                                    Ext.getCmp('strPROGESPEDxDM').setValue(null);
                                    Ext.getCmp('strPROGESPETipoDxDM').setValue(null);
                                    Ext.getCmp('strPROGESPENivelRiesgoDM').setValue(null);
                                    Ext.getCmp('intPROGESPEDxDMMes').setValue(null);
                                    Ext.getCmp('intPROGESPEDxDMAno').setValue(null);
                                    Ext.getCmp('strPROGESPETipoDM').setValue(null);
                                    Ext.getCmp('strPROGESPEDxNefroProteccion').setValue(null);
                                    Ext.getCmp('strPROGESPETipoDxNefroProteccion').setValue(null);
                                    Ext.getCmp('strPROGESPENivelRiesgoNefroProteccion').setValue(null);
                                    Ext.getCmp('intPROGESPEDxNefroProteccionMes').setValue(null);
                                    Ext.getCmp('intPROGESPEDxNefroProteccionAno').setValue(null);
                                    Ext.getCmp('strPROGESPEEstadioNefroProteccion').setValue(null);
                                    Ext.getCmp('memPROGESPEMetasTerapeuticas').setValue(null);
                                    Ext.getCmp('strPROGESPECumplimientoMetas').setValue(null);
                                    Ext.getCmp('intPROGESPENumCumplimientoMetas').setValue(null);
                                    Ext.getCmp('fecPROGESPECita').disable();
                                    Ext.getCmp('strPROGESPEProfesionalAtiende').disable();
                                    Ext.getCmp('fecPROGESPEIngreso').disable();
                                    Ext.getCmp('strPROGESPEViaCaptacion').disable();
                                    Ext.getCmp('strPROGESPEDxHTA').disable();
                                    Ext.getCmp('strPROGESPETipoDxHTA').disable();
                                    Ext.getCmp('strPROGESPENivelRiesgoHTA').disable();
                                    Ext.getCmp('intPROGESPEDxHTAMes').disable();
                                    Ext.getCmp('intPROGESPEDxHTAAno').disable();
                                    Ext.getCmp('strPROGESPEDxDM').disable();
                                    Ext.getCmp('strPROGESPETipoDxDM').disable();
                                    Ext.getCmp('strPROGESPENivelRiesgoDM').disable();
                                    Ext.getCmp('intPROGESPEDxDMMes').disable();
                                    Ext.getCmp('intPROGESPEDxDMAno').disable();
                                    Ext.getCmp('strPROGESPETipoDM').disable();
                                    Ext.getCmp('strPROGESPEDxNefroProteccion').disable();
                                    Ext.getCmp('strPROGESPETipoDxNefroProteccion').disable();
                                    Ext.getCmp('strPROGESPENivelRiesgoNefroProteccion').disable();
                                    Ext.getCmp('intPROGESPEDxNefroProteccionMes').disable();
                                    Ext.getCmp('intPROGESPEDxNefroProteccionAno').disable();
                                    Ext.getCmp('strPROGESPEEstadioNefroProteccion').disable();
                                    Ext.getCmp('memPROGESPEMetasTerapeuticas').disable();
                                    Ext.getCmp('strPROGESPECumplimientoMetas').disable();
                                    Ext.getCmp('intPROGESPENumCumplimientoMetas').disable();
                                    Ext.getCmp('strPROGESPETraeParcialorina').disable();
                                    Ext.getCmp('fecPROGESPEParcialorina').disable();
                                    Ext.getCmp('strPROGESPEParcialorinaRes').disable();
                                    Ext.getCmp('strPROGESPETraeColesterolTotal').disable();
                                    Ext.getCmp('fecPROGESPEColesterolTotal').disable();
                                    Ext.getCmp('strPROGESPEColesterolTotalRes').disable();
                                    Ext.getCmp('strPROGESPETraeColesterolHDL').disable();
                                    Ext.getCmp('fecPROGESPEColesterolHDL').disable();
                                    Ext.getCmp('strPROGESPEColesterolHDLRes').disable();
                                    Ext.getCmp('strPROGESPETraeColesterolLDL').disable();
                                    Ext.getCmp('fecPROGESPEColesterolLDL').disable();
                                    Ext.getCmp('strPROGESPEColesterolLDLRes').disable();
                                    Ext.getCmp('strPROGESPETraeTrigliceridos').disable();
                                    Ext.getCmp('fecPROGESPETrigliceridos').disable();
                                    Ext.getCmp('strPROGESPETrigliceridosRes').disable();
                                    Ext.getCmp('strPROGESPETraeHemoglobinaGlicosilada').disable();
                                    Ext.getCmp('fecPROGESPEHemoglobinaGlicosilada').disable();
                                    Ext.getCmp('strPROGESPEHemoglobinaGlicosiladaRes').disable();
                                    Ext.getCmp('strPROGESPETraeGlicemia').disable();
                                    Ext.getCmp('fecPROGESPEGlicemia').disable();
                                    Ext.getCmp('strPROGESPEGlicemiaRes').disable();
                                    Ext.getCmp('strPROGESPETraeMicroAlbuminuria').disable();
                                    Ext.getCmp('fecPROGESPEMicroAlbuminuria').disable();
                                    Ext.getCmp('strPROGESPEMicroAlbuminuriaRes').disable();
                                    Ext.getCmp('strPROGESPETraeUrea').disable();
                                    Ext.getCmp('fecPROGESPEUrea').disable();
                                    Ext.getCmp('strPROGESPEUreaRes').disable();
                                    Ext.getCmp('strPROGESPETraeCreatinina').disable();
                                    Ext.getCmp('fecPROGESPECreatinina').disable();
                                    Ext.getCmp('strPROGESPECreatininaRes').disable();
                                    Ext.getCmp('strPROGESPEAnteriorTraeParcialorina').disable();
                                    Ext.getCmp('fecPROGESPEAnteriorParcialorina').disable();
                                    Ext.getCmp('strPROGESPEAnteriorParcialorinaRes').disable();
                                    Ext.getCmp('strPROGESPEAnteriorTraeColesterolTotal').disable();
                                    Ext.getCmp('fecPROGESPEAnteriorColesterolTotal').disable();
                                    Ext.getCmp('strPROGESPEAnteriorColesterolTotalRes').disable();
                                    Ext.getCmp('strPROGESPEAnteriorTraeColesterolHDL').disable();
                                    Ext.getCmp('fecPROGESPEAnteriorColesterolHDL').disable();
                                    Ext.getCmp('strPROGESPEAnteriorColesterolHDLRes').disable();
                                    Ext.getCmp('strPROGESPEAnteriorTraeColesterolLDL').disable();
                                    Ext.getCmp('fecPROGESPEAnteriorColesterolLDL').disable();
                                    Ext.getCmp('strPROGESPEAnteriorColesterolLDLRes').disable();
                                    Ext.getCmp('strPROGESPEAnteriorTraeTrigliceridos').disable();
                                    Ext.getCmp('fecPROGESPEAnteriorTrigliceridos').disable();
                                    Ext.getCmp('strPROGESPEAnteriorTrigliceridosRes').disable();
                                    Ext.getCmp('strPROGESPEAnteriorTraeHemoglobinaGlicosilada').disable();
                                    Ext.getCmp('fecPROGESPEAnteriorHemoglobinaGlicosilada').disable();
                                    Ext.getCmp('strPROGESPEAnteriorHemoglobinaGlicosiladaRes').disable();
                                    Ext.getCmp('strPROGESPEAnteriorTraeGlicemia').disable();
                                    Ext.getCmp('fecPROGESPEAnteriorGlicemia').disable();
                                    Ext.getCmp('strPROGESPEAnteriorGlicemiaRes').disable();
                                    Ext.getCmp('strPROGESPEAnteriorTraeMicroAlbuminuria').disable();
                                    Ext.getCmp('fecPROGESPEAnteriorMicroAlbuminuria').disable();
                                    Ext.getCmp('strPROGESPEAnteriorMicroAlbuminuriaRes').disable();
                                    Ext.getCmp('strPROGESPEAnteriorTraeUrea').disable();
                                    Ext.getCmp('fecPROGESPEAnteriorUrea').disable();
                                    Ext.getCmp('strPROGESPEAnteriorUreaRes').disable();
                                    Ext.getCmp('strPROGESPEAnteriorTraeCreatinina').disable();
                                    Ext.getCmp('fecPROGESPEAnteriorCreatinina').disable();
                                    Ext.getCmp('strPROGESPEAnteriorCreatininaRes').disable();
                                    Ext.getCmp('strPROGESPEAnteriorTFG').disable();
                                    Ext.getCmp('strPROGESPESeguimientoTraeParcialorina').disable();
                                    Ext.getCmp('fecPROGESPESeguimientoParcialorina').disable();
                                    Ext.getCmp('strPROGESPESeguimientoParcialorinaRes').disable();
                                    Ext.getCmp('strPROGESPESeguimientoTraeColesterolTotal').disable();
                                    Ext.getCmp('fecPROGESPESeguimientoColesterolTotal').disable();
                                    Ext.getCmp('strPROGESPESeguimientoColesterolTotalRes').disable();
                                    Ext.getCmp('strPROGESPESeguimientoTraeColesterolHDL').disable();
                                    Ext.getCmp('fecPROGESPESeguimientoColesterolHDL').disable();
                                    Ext.getCmp('strPROGESPESeguimientoColesterolHDLRes').disable();
                                    Ext.getCmp('strPROGESPESeguimientoTraeColesterolLDL').disable();
                                    Ext.getCmp('fecPROGESPESeguimientoColesterolLDL').disable();
                                    Ext.getCmp('strPROGESPESeguimientoColesterolLDLRes').disable();
                                    Ext.getCmp('strPROGESPESeguimientoTraeTrigliceridos').disable();
                                    Ext.getCmp('fecPROGESPESeguimientoTrigliceridos').disable();
                                    Ext.getCmp('strPROGESPESeguimientoTrigliceridosRes').disable();
                                    Ext.getCmp('strPROGESPESeguimientoTraeHemoglobinaGlicosilada').disable();
                                    Ext.getCmp('fecPROGESPESeguimientoHemoglobinaGlicosilada').disable();
                                    Ext.getCmp('strPROGESPESeguimientoHemoglobinaGlicosiladaRes').disable();
                                    Ext.getCmp('strPROGESPESeguimientoTraeGlicemia').disable();
                                    Ext.getCmp('fecPROGESPESeguimientoGlicemia').disable();
                                    Ext.getCmp('strPROGESPESeguimientoGlicemiaRes').disable();
                                    Ext.getCmp('strPROGESPESeguimientoTraeMicroAlbuminuria').disable();
                                    Ext.getCmp('fecPROGESPESeguimientoMicroAlbuminuria').disable();
                                    Ext.getCmp('strPROGESPESeguimientoMicroAlbuminuriaRes').disable();
                                    Ext.getCmp('strPROGESPESeguimientoTraeUrea').disable();
                                    Ext.getCmp('fecPROGESPESeguimientoUrea').disable();
                                    Ext.getCmp('strPROGESPESeguimientoUreaRes').disable();
                                    Ext.getCmp('strPROGESPESeguimientoTraeCreatinina').disable();
                                    Ext.getCmp('fecPROGESPESeguimientoCreatinina').disable();
                                    Ext.getCmp('strPROGESPESeguimientoCreatininaRes').disable();
                                    Ext.getCmp('fecPROGESPECita').clearInvalid();
                                    Ext.getCmp('strPROGESPEProfesionalAtiende').clearInvalid();
                                    Ext.getCmp('fecPROGESPEIngreso').clearInvalid();
                                    Ext.getCmp('strPROGESPEViaCaptacion').clearInvalid();
                                    Ext.getCmp('strPROGESPEDxHTA').clearInvalid();
                                    Ext.getCmp('strPROGESPETipoDxHTA').clearInvalid();
                                    Ext.getCmp('strPROGESPENivelRiesgoHTA').clearInvalid();
                                    Ext.getCmp('intPROGESPEDxHTAMes').clearInvalid();
                                    Ext.getCmp('intPROGESPEDxHTAAno').clearInvalid();
                                    Ext.getCmp('strPROGESPEDxDM').clearInvalid();
                                    Ext.getCmp('strPROGESPETipoDxDM').clearInvalid();
                                    Ext.getCmp('strPROGESPENivelRiesgoDM').clearInvalid();
                                    Ext.getCmp('intPROGESPEDxDMMes').clearInvalid();
                                    Ext.getCmp('intPROGESPEDxDMAno').clearInvalid();
                                    Ext.getCmp('strPROGESPETipoDM').clearInvalid();
                                    Ext.getCmp('strPROGESPEDxNefroProteccion').clearInvalid();
                                    Ext.getCmp('strPROGESPETipoDxNefroProteccion').clearInvalid();
                                    Ext.getCmp('strPROGESPENivelRiesgoNefroProteccion').clearInvalid();
                                    Ext.getCmp('intPROGESPEDxNefroProteccionMes').clearInvalid();
                                    Ext.getCmp('intPROGESPEDxNefroProteccionAno').clearInvalid();
                                    Ext.getCmp('strPROGESPEEstadioNefroProteccion').clearInvalid();
                                    Ext.getCmp('memPROGESPEMetasTerapeuticas').clearInvalid();
                                    Ext.getCmp('strPROGESPECumplimientoMetas').clearInvalid();
                                    Ext.getCmp('intPROGESPENumCumplimientoMetas').clearInvalid();
                                    Ext.getCmp('strPROGESPETraeParcialorina').clearInvalid();
                                    Ext.getCmp('fecPROGESPEParcialorina').clearInvalid();
                                    Ext.getCmp('strPROGESPEParcialorinaRes').clearInvalid();
                                    Ext.getCmp('strPROGESPETraeColesterolTotal').clearInvalid();
                                    Ext.getCmp('fecPROGESPEColesterolTotal').clearInvalid();
                                    Ext.getCmp('strPROGESPEColesterolTotalRes').clearInvalid();
                                    Ext.getCmp('strPROGESPETraeColesterolHDL').clearInvalid();
                                    Ext.getCmp('fecPROGESPEColesterolHDL').clearInvalid();
                                    Ext.getCmp('strPROGESPEColesterolHDLRes').clearInvalid();
                                    Ext.getCmp('strPROGESPETraeColesterolLDL').clearInvalid();
                                    Ext.getCmp('fecPROGESPEColesterolLDL').clearInvalid();
                                    Ext.getCmp('strPROGESPEColesterolLDLRes').clearInvalid();
                                    Ext.getCmp('strPROGESPETraeTrigliceridos').clearInvalid();
                                    Ext.getCmp('fecPROGESPETrigliceridos').clearInvalid();
                                    Ext.getCmp('strPROGESPETrigliceridosRes').clearInvalid();
                                    Ext.getCmp('strPROGESPETraeHemoglobinaGlicosilada').clearInvalid();
                                    Ext.getCmp('fecPROGESPEHemoglobinaGlicosilada').clearInvalid();
                                    Ext.getCmp('strPROGESPEHemoglobinaGlicosiladaRes').clearInvalid();
                                    Ext.getCmp('strPROGESPETraeGlicemia').clearInvalid();
                                    Ext.getCmp('fecPROGESPEGlicemia').clearInvalid();
                                    Ext.getCmp('strPROGESPEGlicemiaRes').clearInvalid();
                                    Ext.getCmp('strPROGESPETraeMicroAlbuminuria').clearInvalid();
                                    Ext.getCmp('fecPROGESPEMicroAlbuminuria').clearInvalid();
                                    Ext.getCmp('strPROGESPEMicroAlbuminuriaRes').clearInvalid();
                                    Ext.getCmp('strPROGESPETraeUrea').clearInvalid();
                                    Ext.getCmp('fecPROGESPEUrea').clearInvalid();
                                    Ext.getCmp('strPROGESPEUreaRes').clearInvalid();
                                    Ext.getCmp('strPROGESPETraeCreatinina').clearInvalid();
                                    Ext.getCmp('fecPROGESPECreatinina').clearInvalid();
                                    Ext.getCmp('strPROGESPECreatininaRes').clearInvalid();
                                    Ext.getCmp('strPROGESPEAnteriorTraeParcialorina').clearInvalid();
                                    Ext.getCmp('fecPROGESPEAnteriorParcialorina').clearInvalid();
                                    Ext.getCmp('strPROGESPEAnteriorParcialorinaRes').clearInvalid();
                                    Ext.getCmp('strPROGESPEAnteriorTraeColesterolTotal').clearInvalid();
                                    Ext.getCmp('fecPROGESPEAnteriorColesterolTotal').clearInvalid();
                                    Ext.getCmp('strPROGESPEAnteriorColesterolTotalRes').clearInvalid();
                                    Ext.getCmp('strPROGESPEAnteriorTraeColesterolHDL').clearInvalid();
                                    Ext.getCmp('fecPROGESPEAnteriorColesterolHDL').clearInvalid();
                                    Ext.getCmp('strPROGESPEAnteriorColesterolHDLRes').clearInvalid();
                                    Ext.getCmp('strPROGESPEAnteriorTraeColesterolLDL').clearInvalid();
                                    Ext.getCmp('fecPROGESPEAnteriorColesterolLDL').clearInvalid();
                                    Ext.getCmp('strPROGESPEAnteriorColesterolLDLRes').clearInvalid();
                                    Ext.getCmp('strPROGESPEAnteriorTraeTrigliceridos').clearInvalid();
                                    Ext.getCmp('fecPROGESPEAnteriorTrigliceridos').clearInvalid();
                                    Ext.getCmp('strPROGESPEAnteriorTrigliceridosRes').clearInvalid();
                                    Ext.getCmp('strPROGESPEAnteriorTraeHemoglobinaGlicosilada').clearInvalid();
                                    Ext.getCmp('fecPROGESPEAnteriorHemoglobinaGlicosilada').clearInvalid();
                                    Ext.getCmp('strPROGESPEAnteriorHemoglobinaGlicosiladaRes').clearInvalid();
                                    Ext.getCmp('strPROGESPEAnteriorTraeGlicemia').clearInvalid();
                                    Ext.getCmp('fecPROGESPEAnteriorGlicemia').clearInvalid();
                                    Ext.getCmp('strPROGESPEAnteriorGlicemiaRes').clearInvalid();
                                    Ext.getCmp('strPROGESPEAnteriorTraeMicroAlbuminuria').clearInvalid();
                                    Ext.getCmp('fecPROGESPEAnteriorMicroAlbuminuria').clearInvalid();
                                    Ext.getCmp('strPROGESPEAnteriorMicroAlbuminuriaRes').clearInvalid();
                                    Ext.getCmp('strPROGESPEAnteriorTraeUrea').clearInvalid();
                                    Ext.getCmp('fecPROGESPEAnteriorUrea').clearInvalid();
                                    Ext.getCmp('strPROGESPEAnteriorUreaRes').clearInvalid();
                                    Ext.getCmp('strPROGESPEAnteriorTraeCreatinina').clearInvalid();
                                    Ext.getCmp('fecPROGESPEAnteriorCreatinina').clearInvalid();
                                    Ext.getCmp('strPROGESPEAnteriorCreatininaRes').clearInvalid();
                                    Ext.getCmp('strPROGESPEAnteriorTFG').clearInvalid();
                                    Ext.getCmp('strPROGESPESeguimientoTraeParcialorina').clearInvalid();
                                    Ext.getCmp('fecPROGESPESeguimientoParcialorina').clearInvalid();
                                    Ext.getCmp('strPROGESPESeguimientoParcialorinaRes').clearInvalid();
                                    Ext.getCmp('strPROGESPESeguimientoTraeColesterolTotal').clearInvalid();
                                    Ext.getCmp('fecPROGESPESeguimientoColesterolTotal').clearInvalid();
                                    Ext.getCmp('strPROGESPESeguimientoColesterolTotalRes').clearInvalid();
                                    Ext.getCmp('strPROGESPESeguimientoTraeColesterolHDL').clearInvalid();
                                    Ext.getCmp('fecPROGESPESeguimientoColesterolHDL').clearInvalid();
                                    Ext.getCmp('strPROGESPESeguimientoColesterolHDLRes').clearInvalid();
                                    Ext.getCmp('strPROGESPESeguimientoTraeColesterolLDL').clearInvalid();
                                    Ext.getCmp('fecPROGESPESeguimientoColesterolLDL').clearInvalid();
                                    Ext.getCmp('strPROGESPESeguimientoColesterolLDLRes').clearInvalid();
                                    Ext.getCmp('strPROGESPESeguimientoTraeTrigliceridos').clearInvalid();
                                    Ext.getCmp('fecPROGESPESeguimientoTrigliceridos').clearInvalid();
                                    Ext.getCmp('strPROGESPESeguimientoTrigliceridosRes').clearInvalid();
                                    Ext.getCmp('strPROGESPESeguimientoTraeHemoglobinaGlicosilada').clearInvalid();
                                    Ext.getCmp('fecPROGESPESeguimientoHemoglobinaGlicosilada').clearInvalid();
                                    Ext.getCmp('strPROGESPESeguimientoHemoglobinaGlicosiladaRes').clearInvalid();
                                    Ext.getCmp('strPROGESPESeguimientoTraeGlicemia').clearInvalid();
                                    Ext.getCmp('fecPROGESPESeguimientoGlicemia').clearInvalid();
                                    Ext.getCmp('strPROGESPESeguimientoGlicemiaRes').clearInvalid();
                                    Ext.getCmp('strPROGESPESeguimientoTraeMicroAlbuminuria').clearInvalid();
                                    Ext.getCmp('fecPROGESPESeguimientoMicroAlbuminuria').clearInvalid();
                                    Ext.getCmp('strPROGESPESeguimientoMicroAlbuminuriaRes').clearInvalid();
                                    Ext.getCmp('strPROGESPESeguimientoTraeUrea').clearInvalid();
                                    Ext.getCmp('fecPROGESPESeguimientoUrea').clearInvalid();
                                    Ext.getCmp('strPROGESPESeguimientoUreaRes').clearInvalid();
                                    Ext.getCmp('strPROGESPESeguimientoTraeCreatinina').clearInvalid();
                                    Ext.getCmp('fecPROGESPESeguimientoCreatinina').clearInvalid();
                                    Ext.getCmp('strPROGESPESeguimientoCreatininaRes').clearInvalid();
                                }else{
                                    Ext.getCmp('fsProgramasEspeciales').setVisible(true);
                                    Ext.getCmp('fecPROGESPECita').allowBlank = true;
                                    Ext.getCmp('strPROGESPEProfesionalAtiende').allowBlank = true;
                                    Ext.getCmp('fecPROGESPEIngreso').allowBlank = false;
                                    Ext.getCmp('strPROGESPEViaCaptacion').allowBlank = false;
                                    Ext.getCmp('strPROGESPEDxHTA').allowBlank = false;
                                    Ext.getCmp('strPROGESPETipoDxHTA').allowBlank = true;
                                    Ext.getCmp('strPROGESPENivelRiesgoHTA').allowBlank = true;
                                    Ext.getCmp('intPROGESPEDxHTAMes').allowBlank = true;
                                    Ext.getCmp('intPROGESPEDxHTAAno').allowBlank = true;
                                    Ext.getCmp('strPROGESPEDxDM').allowBlank = false;
                                    Ext.getCmp('strPROGESPETipoDxDM').allowBlank = true;
                                    Ext.getCmp('strPROGESPENivelRiesgoDM').allowBlank = true;
                                    Ext.getCmp('intPROGESPEDxDMMes').allowBlank = true;
                                    Ext.getCmp('intPROGESPEDxDMAno').allowBlank = true;
                                    Ext.getCmp('strPROGESPETipoDM').allowBlank = true;
                                    Ext.getCmp('strPROGESPEDxNefroProteccion').allowBlank = false;
                                    Ext.getCmp('strPROGESPETipoDxNefroProteccion').allowBlank = true;
                                    Ext.getCmp('strPROGESPENivelRiesgoNefroProteccion').allowBlank = true;
                                    Ext.getCmp('intPROGESPEDxNefroProteccionMes').allowBlank = true;
                                    Ext.getCmp('intPROGESPEDxNefroProteccionAno').allowBlank = true;
                                    Ext.getCmp('strPROGESPEEstadioNefroProteccion').allowBlank = true;
                                    Ext.getCmp('memPROGESPEMetasTerapeuticas').allowBlank = false;
                                    Ext.getCmp('strPROGESPECumplimientoMetas').allowBlank = true;
                                    Ext.getCmp('intPROGESPENumCumplimientoMetas').allowBlank = true;
                                    Ext.getCmp('strPROGESPETraeParcialorina').allowBlank=true;
                                    Ext.getCmp('fecPROGESPEParcialorina').allowBlank=true;
                                    Ext.getCmp('strPROGESPEParcialorinaRes').allowBlank=true;
                                    Ext.getCmp('strPROGESPETraeColesterolTotal').allowBlank=true;
                                    Ext.getCmp('fecPROGESPEColesterolTotal').allowBlank=true;
                                    Ext.getCmp('strPROGESPEColesterolTotalRes').allowBlank=true;
                                    Ext.getCmp('strPROGESPETraeColesterolHDL').allowBlank=true;
                                    Ext.getCmp('fecPROGESPEColesterolHDL').allowBlank=true;
                                    Ext.getCmp('strPROGESPEColesterolHDLRes').allowBlank=true;
                                    Ext.getCmp('strPROGESPETraeColesterolLDL').allowBlank=true;
                                    Ext.getCmp('fecPROGESPEColesterolLDL').allowBlank=true;
                                    Ext.getCmp('strPROGESPEColesterolLDLRes').allowBlank=true;
                                    Ext.getCmp('strPROGESPETraeTrigliceridos').allowBlank=true;
                                    Ext.getCmp('fecPROGESPETrigliceridos').allowBlank=true;
                                    Ext.getCmp('strPROGESPETrigliceridosRes').allowBlank=true;
                                    Ext.getCmp('strPROGESPETraeHemoglobinaGlicosilada').allowBlank=true;
                                    Ext.getCmp('fecPROGESPEHemoglobinaGlicosilada').allowBlank=true;
                                    Ext.getCmp('strPROGESPEHemoglobinaGlicosiladaRes').allowBlank=true;
                                    Ext.getCmp('strPROGESPETraeGlicemia').allowBlank=true;
                                    Ext.getCmp('fecPROGESPEGlicemia').allowBlank=true;
                                    Ext.getCmp('strPROGESPEGlicemiaRes').allowBlank=true;
                                    Ext.getCmp('strPROGESPETraeMicroAlbuminuria').allowBlank=true;
                                    Ext.getCmp('fecPROGESPEMicroAlbuminuria').allowBlank=true;
                                    Ext.getCmp('strPROGESPEMicroAlbuminuriaRes').allowBlank=true;
                                    Ext.getCmp('strPROGESPETraeUrea').allowBlank=true;
                                    Ext.getCmp('fecPROGESPEUrea').allowBlank=true;
                                    Ext.getCmp('strPROGESPEUreaRes').allowBlank=true;
                                    Ext.getCmp('strPROGESPETraeCreatinina').allowBlank=true;
                                    Ext.getCmp('fecPROGESPECreatinina').allowBlank=true;
                                    Ext.getCmp('strPROGESPECreatininaRes').allowBlank=true;
                                    Ext.getCmp('strPROGESPEAnteriorTraeParcialorina').allowBlank=true;
                                    Ext.getCmp('fecPROGESPEAnteriorParcialorina').allowBlank=true;
                                    Ext.getCmp('strPROGESPEAnteriorParcialorinaRes').allowBlank=true;
                                    Ext.getCmp('strPROGESPEAnteriorTraeColesterolTotal').allowBlank=true;
                                    Ext.getCmp('fecPROGESPEAnteriorColesterolTotal').allowBlank=true;
                                    Ext.getCmp('strPROGESPEAnteriorColesterolTotalRes').allowBlank=true;
                                    Ext.getCmp('strPROGESPEAnteriorTraeColesterolHDL').allowBlank=true;
                                    Ext.getCmp('fecPROGESPEAnteriorColesterolHDL').allowBlank=true;
                                    Ext.getCmp('strPROGESPEAnteriorColesterolHDLRes').allowBlank=true;
                                    Ext.getCmp('strPROGESPEAnteriorTraeColesterolLDL').allowBlank=true;
                                    Ext.getCmp('fecPROGESPEAnteriorColesterolLDL').allowBlank=true;
                                    Ext.getCmp('strPROGESPEAnteriorColesterolLDLRes').allowBlank=true;
                                    Ext.getCmp('strPROGESPEAnteriorTraeTrigliceridos').allowBlank=true;
                                    Ext.getCmp('fecPROGESPEAnteriorTrigliceridos').allowBlank=true;
                                    Ext.getCmp('strPROGESPEAnteriorTrigliceridosRes').allowBlank=true;
                                    Ext.getCmp('strPROGESPEAnteriorTraeHemoglobinaGlicosilada').allowBlank=true;
                                    Ext.getCmp('fecPROGESPEAnteriorHemoglobinaGlicosilada').allowBlank=true;
                                    Ext.getCmp('strPROGESPEAnteriorHemoglobinaGlicosiladaRes').allowBlank=true;
                                    Ext.getCmp('strPROGESPEAnteriorTraeGlicemia').allowBlank=true;
                                    Ext.getCmp('fecPROGESPEAnteriorGlicemia').allowBlank=true;
                                    Ext.getCmp('strPROGESPEAnteriorGlicemiaRes').allowBlank=true;
                                    Ext.getCmp('strPROGESPEAnteriorTraeMicroAlbuminuria').allowBlank=true;
                                    Ext.getCmp('fecPROGESPEAnteriorMicroAlbuminuria').allowBlank=true;
                                    Ext.getCmp('strPROGESPEAnteriorMicroAlbuminuriaRes').allowBlank=true;
                                    Ext.getCmp('strPROGESPEAnteriorTraeUrea').allowBlank=true;
                                    Ext.getCmp('fecPROGESPEAnteriorUrea').allowBlank=true;
                                    Ext.getCmp('strPROGESPEAnteriorUreaRes').allowBlank=true;
                                    Ext.getCmp('strPROGESPEAnteriorTraeCreatinina').allowBlank=true;
                                    Ext.getCmp('fecPROGESPEAnteriorCreatinina').allowBlank=true;
                                    Ext.getCmp('strPROGESPEAnteriorCreatininaRes').allowBlank=true;
                                    Ext.getCmp('strPROGESPEAnteriorTFG').allowBlank=true;
                                    Ext.getCmp('strPROGESPESeguimientoTraeParcialorina').allowBlank=true;
                                    Ext.getCmp('fecPROGESPESeguimientoParcialorina').allowBlank=true;
                                    Ext.getCmp('strPROGESPESeguimientoParcialorinaRes').allowBlank=true;
                                    Ext.getCmp('strPROGESPESeguimientoTraeColesterolTotal').allowBlank=true;
                                    Ext.getCmp('fecPROGESPESeguimientoColesterolTotal').allowBlank=true;
                                    Ext.getCmp('strPROGESPESeguimientoColesterolTotalRes').allowBlank=true;
                                    Ext.getCmp('strPROGESPESeguimientoTraeColesterolHDL').allowBlank=true;
                                    Ext.getCmp('fecPROGESPESeguimientoColesterolHDL').allowBlank=true;
                                    Ext.getCmp('strPROGESPESeguimientoColesterolHDLRes').allowBlank=true;
                                    Ext.getCmp('strPROGESPESeguimientoTraeColesterolLDL').allowBlank=true;
                                    Ext.getCmp('fecPROGESPESeguimientoColesterolLDL').allowBlank=true;
                                    Ext.getCmp('strPROGESPESeguimientoColesterolLDLRes').allowBlank=true;
                                    Ext.getCmp('strPROGESPESeguimientoTraeTrigliceridos').allowBlank=true;
                                    Ext.getCmp('fecPROGESPESeguimientoTrigliceridos').allowBlank=true;
                                    Ext.getCmp('strPROGESPESeguimientoTrigliceridosRes').allowBlank=true;
                                    Ext.getCmp('strPROGESPESeguimientoTraeHemoglobinaGlicosilada').allowBlank=true;
                                    Ext.getCmp('fecPROGESPESeguimientoHemoglobinaGlicosilada').allowBlank=true;
                                    Ext.getCmp('strPROGESPESeguimientoHemoglobinaGlicosiladaRes').allowBlank=true;
                                    Ext.getCmp('strPROGESPESeguimientoTraeGlicemia').allowBlank=true;
                                    Ext.getCmp('fecPROGESPESeguimientoGlicemia').allowBlank=true;
                                    Ext.getCmp('strPROGESPESeguimientoGlicemiaRes').allowBlank=true;
                                    Ext.getCmp('strPROGESPESeguimientoTraeMicroAlbuminuria').allowBlank=true;
                                    Ext.getCmp('fecPROGESPESeguimientoMicroAlbuminuria').allowBlank=true;
                                    Ext.getCmp('strPROGESPESeguimientoMicroAlbuminuriaRes').allowBlank=true;
                                    Ext.getCmp('strPROGESPESeguimientoTraeUrea').allowBlank=true;
                                    Ext.getCmp('fecPROGESPESeguimientoUrea').allowBlank=true;
                                    Ext.getCmp('strPROGESPESeguimientoUreaRes').allowBlank=true;
                                    Ext.getCmp('strPROGESPESeguimientoTraeCreatinina').allowBlank=true;
                                    Ext.getCmp('fecPROGESPESeguimientoCreatinina').allowBlank=true;
                                    Ext.getCmp('strPROGESPESeguimientoCreatininaRes').allowBlank=true;
                                    Ext.getCmp('strPROGESPEProfesionalAtiende').enable();
                                    Ext.getCmp('fecPROGESPECita').enable();
                                    Ext.getCmp('fecPROGESPEIngreso').enable();
                                    Ext.getCmp('strPROGESPEViaCaptacion').enable();
                                    Ext.getCmp('strPROGESPEDxHTA').enable();
                                    Ext.getCmp('strPROGESPETipoDxHTA').enable();
                                    Ext.getCmp('strPROGESPENivelRiesgoHTA').enable();
                                    Ext.getCmp('intPROGESPEDxHTAMes').enable();
                                    Ext.getCmp('intPROGESPEDxHTAAno').enable();
                                    Ext.getCmp('strPROGESPEDxDM').enable();
                                    Ext.getCmp('strPROGESPETipoDxDM').enable();
                                    Ext.getCmp('strPROGESPENivelRiesgoDM').enable();
                                    Ext.getCmp('intPROGESPEDxDMMes').enable();
                                    Ext.getCmp('intPROGESPEDxDMAno').enable();
                                    Ext.getCmp('strPROGESPETipoDM').enable();
                                    Ext.getCmp('strPROGESPEDxNefroProteccion').enable();
                                    Ext.getCmp('strPROGESPETipoDxNefroProteccion').enable();
                                    Ext.getCmp('strPROGESPENivelRiesgoNefroProteccion').enable();
                                    Ext.getCmp('intPROGESPEDxNefroProteccionMes').enable();
                                    Ext.getCmp('intPROGESPEDxNefroProteccionAno').enable();
                                    Ext.getCmp('strPROGESPEEstadioNefroProteccion').enable();
                                    Ext.getCmp('memPROGESPEMetasTerapeuticas').enable();
                                    Ext.getCmp('strPROGESPECumplimientoMetas').enable();
                                    Ext.getCmp('intPROGESPENumCumplimientoMetas').enable();
                                    Ext.getCmp('strPROGESPETraeParcialorina').enable();
                                    Ext.getCmp('fecPROGESPEParcialorina').enable();
                                    Ext.getCmp('strPROGESPEParcialorinaRes').enable();
                                    Ext.getCmp('strPROGESPETraeColesterolTotal').enable();
                                    Ext.getCmp('fecPROGESPEColesterolTotal').enable();
                                    Ext.getCmp('strPROGESPEColesterolTotalRes').enable();
                                    Ext.getCmp('strPROGESPETraeColesterolHDL').enable();
                                    Ext.getCmp('fecPROGESPEColesterolHDL').enable();
                                    Ext.getCmp('strPROGESPEColesterolHDLRes').enable();
                                    Ext.getCmp('strPROGESPETraeColesterolLDL').enable();
                                    Ext.getCmp('fecPROGESPEColesterolLDL').enable();
                                    Ext.getCmp('strPROGESPEColesterolLDLRes').enable();
                                    Ext.getCmp('strPROGESPETraeTrigliceridos').enable();
                                    Ext.getCmp('fecPROGESPETrigliceridos').enable();
                                    Ext.getCmp('strPROGESPETrigliceridosRes').enable();
                                    Ext.getCmp('strPROGESPETraeHemoglobinaGlicosilada').enable();
                                    Ext.getCmp('fecPROGESPEHemoglobinaGlicosilada').enable();
                                    Ext.getCmp('strPROGESPEHemoglobinaGlicosiladaRes').enable();
                                    Ext.getCmp('strPROGESPETraeGlicemia').enable();
                                    Ext.getCmp('fecPROGESPEGlicemia').enable();
                                    Ext.getCmp('strPROGESPEGlicemiaRes').enable();
                                    Ext.getCmp('strPROGESPETraeMicroAlbuminuria').enable();
                                    Ext.getCmp('fecPROGESPEMicroAlbuminuria').enable();
                                    Ext.getCmp('strPROGESPEMicroAlbuminuriaRes').enable();
                                    Ext.getCmp('strPROGESPETraeUrea').enable();
                                    Ext.getCmp('fecPROGESPEUrea').enable();
                                    Ext.getCmp('strPROGESPEUreaRes').enable();
                                    Ext.getCmp('strPROGESPETraeCreatinina').enable();
                                    Ext.getCmp('fecPROGESPECreatinina').enable();
                                    Ext.getCmp('strPROGESPECreatininaRes').enable();
                                    Ext.getCmp('strPROGESPEAnteriorTraeParcialorina').enable();
                                    Ext.getCmp('fecPROGESPEAnteriorParcialorina').enable();
                                    Ext.getCmp('strPROGESPEAnteriorParcialorinaRes').enable();
                                    Ext.getCmp('strPROGESPEAnteriorTraeColesterolTotal').enable();
                                    Ext.getCmp('fecPROGESPEAnteriorColesterolTotal').enable();
                                    Ext.getCmp('strPROGESPEAnteriorColesterolTotalRes').enable();
                                    Ext.getCmp('strPROGESPEAnteriorTraeColesterolHDL').enable();
                                    Ext.getCmp('fecPROGESPEAnteriorColesterolHDL').enable();
                                    Ext.getCmp('strPROGESPEAnteriorColesterolHDLRes').enable();
                                    Ext.getCmp('strPROGESPEAnteriorTraeColesterolLDL').enable();
                                    Ext.getCmp('fecPROGESPEAnteriorColesterolLDL').enable();
                                    Ext.getCmp('strPROGESPEAnteriorColesterolLDLRes').enable();
                                    Ext.getCmp('strPROGESPEAnteriorTraeTrigliceridos').enable();
                                    Ext.getCmp('fecPROGESPEAnteriorTrigliceridos').enable();
                                    Ext.getCmp('strPROGESPEAnteriorTrigliceridosRes').enable();
                                    Ext.getCmp('strPROGESPEAnteriorTraeHemoglobinaGlicosilada').enable();
                                    Ext.getCmp('fecPROGESPEAnteriorHemoglobinaGlicosilada').enable();
                                    Ext.getCmp('strPROGESPEAnteriorHemoglobinaGlicosiladaRes').enable();
                                    Ext.getCmp('strPROGESPEAnteriorTraeGlicemia').enable();
                                    Ext.getCmp('fecPROGESPEAnteriorGlicemia').enable();
                                    Ext.getCmp('strPROGESPEAnteriorGlicemiaRes').enable();
                                    Ext.getCmp('strPROGESPEAnteriorTraeMicroAlbuminuria').enable();
                                    Ext.getCmp('fecPROGESPEAnteriorMicroAlbuminuria').enable();
                                    Ext.getCmp('strPROGESPEAnteriorMicroAlbuminuriaRes').enable();
                                    Ext.getCmp('strPROGESPEAnteriorTraeUrea').enable();
                                    Ext.getCmp('fecPROGESPEAnteriorUrea').enable();
                                    Ext.getCmp('strPROGESPEAnteriorUreaRes').enable();
                                    Ext.getCmp('strPROGESPEAnteriorTraeCreatinina').enable();
                                    Ext.getCmp('fecPROGESPEAnteriorCreatinina').enable();
                                    Ext.getCmp('strPROGESPEAnteriorCreatininaRes').enable();
                                    Ext.getCmp('strPROGESPEAnteriorTFG').enable();
                                    Ext.getCmp('strPROGESPESeguimientoTraeParcialorina').enable();
                                    Ext.getCmp('fecPROGESPESeguimientoParcialorina').enable();
                                    Ext.getCmp('strPROGESPESeguimientoParcialorinaRes').enable();
                                    Ext.getCmp('strPROGESPESeguimientoTraeColesterolTotal').enable();
                                    Ext.getCmp('fecPROGESPESeguimientoColesterolTotal').enable();
                                    Ext.getCmp('strPROGESPESeguimientoColesterolTotalRes').enable();
                                    Ext.getCmp('strPROGESPESeguimientoTraeColesterolHDL').enable();
                                    Ext.getCmp('fecPROGESPESeguimientoColesterolHDL').enable();
                                    Ext.getCmp('strPROGESPESeguimientoColesterolHDLRes').enable();
                                    Ext.getCmp('strPROGESPESeguimientoTraeColesterolLDL').enable();
                                    Ext.getCmp('fecPROGESPESeguimientoColesterolLDL').enable();
                                    Ext.getCmp('strPROGESPESeguimientoColesterolLDLRes').enable();
                                    Ext.getCmp('strPROGESPESeguimientoTraeTrigliceridos').enable();
                                    Ext.getCmp('fecPROGESPESeguimientoTrigliceridos').enable();
                                    Ext.getCmp('strPROGESPESeguimientoTrigliceridosRes').enable();
                                    Ext.getCmp('strPROGESPESeguimientoTraeHemoglobinaGlicosilada').enable();
                                    Ext.getCmp('fecPROGESPESeguimientoHemoglobinaGlicosilada').enable();
                                    Ext.getCmp('strPROGESPESeguimientoHemoglobinaGlicosiladaRes').enable();
                                    Ext.getCmp('strPROGESPESeguimientoTraeGlicemia').enable();
                                    Ext.getCmp('fecPROGESPESeguimientoGlicemia').enable();
                                    Ext.getCmp('strPROGESPESeguimientoGlicemiaRes').enable();
                                    Ext.getCmp('strPROGESPESeguimientoTraeMicroAlbuminuria').enable();
                                    Ext.getCmp('fecPROGESPESeguimientoMicroAlbuminuria').enable();
                                    Ext.getCmp('strPROGESPESeguimientoMicroAlbuminuriaRes').enable();
                                    Ext.getCmp('strPROGESPESeguimientoTraeUrea').enable();
                                    Ext.getCmp('fecPROGESPESeguimientoUrea').enable();
                                    Ext.getCmp('strPROGESPESeguimientoUreaRes').enable();
                                    Ext.getCmp('strPROGESPESeguimientoTraeCreatinina').enable();
                                    Ext.getCmp('fecPROGESPESeguimientoCreatinina').enable();
                                    Ext.getCmp('strPROGESPESeguimientoCreatininaRes').enable();
                                }
                            }
                        }
                    }
                ]
            },
            {
                xtype: 'fieldset',
                title: 'PROGRAMAS ESPECIALES (HTA - DM - NEFROPROTECCION)',
                layout: 'form',
                collapseFirst: false,
                collapsible: true,
                animCollapse: true,
                titleCollapse: true,
                anchor: '100%',
                autoHeight: true,
                padding: 5,
                id: 'fsProgramasEspeciales',
                items: [
                    {
                        xtype: 'panel',
                        anchor: '100%',
                        autoHeight: true,
                        labelWidth: 290,
                        layout: 'form',
                        items: [
                            {
                                xtype: 'combo',
                                fieldLabel: 'Esta Atencion corresponde a ingreso al programa?',
                                name: 'Esta Atencion corresponde a ingreso al programa?',
                                width: 90,
                                allowBlank: true,
                                store: 'StoreSiNo',
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strPROGESPEIngreso',
                                listeners:{
                                    change : function( t, newValue, oldValue){
                                        if(newValue == "NO"){
                                            Ext.getCmp('fecPROGESPEIngreso').allowBlank = true;
                                            Ext.getCmp('strPROGESPEViaCaptacion').allowBlank = true;
                                            Ext.getCmp('fecPROGESPEIngreso').readOnly = true;
                                            Ext.getCmp('strPROGESPEViaCaptacion').readOnly = true;
                                            Ext.getCmp('fsProgramaEspecialesExamAnteriores').setVisible(true);
                                            Ext.getCmp('fsProgramaEspecialesExamSeguimiento').setVisible(true);
                                            Ext.getCmp('strPROGESPETraeParcialorina').readOnly=true;
                                            Ext.getCmp('fecPROGESPEParcialorina').readOnly=true;
                                            Ext.getCmp('strPROGESPEParcialorinaRes').readOnly=true;
                                            Ext.getCmp('strPROGESPETraeColesterolTotal').readOnly=true;
                                            Ext.getCmp('fecPROGESPEColesterolTotal').readOnly=true;
                                            Ext.getCmp('strPROGESPEColesterolTotalRes').readOnly=true;
                                            Ext.getCmp('strPROGESPETraeColesterolHDL').readOnly=true;
                                            Ext.getCmp('fecPROGESPEColesterolHDL').readOnly=true;
                                            Ext.getCmp('strPROGESPEColesterolHDLRes').readOnly=true;
                                            Ext.getCmp('strPROGESPETraeColesterolLDL').readOnly=true;
                                            Ext.getCmp('fecPROGESPEColesterolLDL').readOnly=true;
                                            Ext.getCmp('strPROGESPEColesterolLDLRes').readOnly=true;
                                            Ext.getCmp('strPROGESPETraeTrigliceridos').readOnly=true;
                                            Ext.getCmp('fecPROGESPETrigliceridos').readOnly=true;
                                            Ext.getCmp('strPROGESPETrigliceridosRes').readOnly=true;
                                            Ext.getCmp('strPROGESPETraeHemoglobinaGlicosilada').readOnly=true;
                                            Ext.getCmp('fecPROGESPEHemoglobinaGlicosilada').readOnly=true;
                                            Ext.getCmp('strPROGESPEHemoglobinaGlicosiladaRes').readOnly=true;
                                            Ext.getCmp('strPROGESPETraeGlicemia').readOnly=true;
                                            Ext.getCmp('fecPROGESPEGlicemia').readOnly=true;
                                            Ext.getCmp('strPROGESPEGlicemiaRes').readOnly=true;
                                            Ext.getCmp('strPROGESPETraeMicroAlbuminuria').readOnly=true;
                                            Ext.getCmp('fecPROGESPEMicroAlbuminuria').readOnly=true;
                                            Ext.getCmp('strPROGESPEMicroAlbuminuriaRes').readOnly=true;
                                            Ext.getCmp('strPROGESPETraeUrea').readOnly=true;
                                            Ext.getCmp('fecPROGESPEUrea').readOnly=true;
                                            Ext.getCmp('strPROGESPEUreaRes').readOnly=true;
                                            Ext.getCmp('strPROGESPETraeCreatinina').readOnly=true;
                                            Ext.getCmp('fecPROGESPECreatinina').readOnly=true;
                                            Ext.getCmp('strPROGESPECreatininaRes').readOnly=true;
                                            Ext.getCmp('intPROGESPETFGIngreso').readOnly=true;
                                            Ext.getCmp('strPROGESPEAnteriorTraeParcialorina').readOnly=true;
                                            Ext.getCmp('fecPROGESPEAnteriorParcialorina').readOnly=true;
                                            Ext.getCmp('strPROGESPEAnteriorParcialorinaRes').readOnly=true;
                                            Ext.getCmp('strPROGESPEAnteriorTraeColesterolTotal').readOnly=true;
                                            Ext.getCmp('fecPROGESPEAnteriorColesterolTotal').readOnly=true;
                                            Ext.getCmp('strPROGESPEAnteriorColesterolTotalRes').readOnly=true;
                                            Ext.getCmp('strPROGESPEAnteriorTraeColesterolHDL').readOnly=true;
                                            Ext.getCmp('fecPROGESPEAnteriorColesterolHDL').readOnly=true;
                                            Ext.getCmp('strPROGESPEAnteriorColesterolHDLRes').readOnly=true;
                                            Ext.getCmp('strPROGESPEAnteriorTraeColesterolLDL').readOnly=true;
                                            Ext.getCmp('fecPROGESPEAnteriorColesterolLDL').readOnly=true;
                                            Ext.getCmp('strPROGESPEAnteriorColesterolLDLRes').readOnly=true;
                                            Ext.getCmp('strPROGESPEAnteriorTraeTrigliceridos').readOnly=true;
                                            Ext.getCmp('fecPROGESPEAnteriorTrigliceridos').readOnly=true;
                                            Ext.getCmp('strPROGESPEAnteriorTrigliceridosRes').readOnly=true;
                                            Ext.getCmp('strPROGESPEAnteriorTraeHemoglobinaGlicosilada').readOnly=true;
                                            Ext.getCmp('fecPROGESPEAnteriorHemoglobinaGlicosilada').readOnly=true;
                                            Ext.getCmp('strPROGESPEAnteriorHemoglobinaGlicosiladaRes').readOnly=true;
                                            Ext.getCmp('strPROGESPEAnteriorTraeGlicemia').readOnly=true;
                                            Ext.getCmp('fecPROGESPEAnteriorGlicemia').readOnly=true;
                                            Ext.getCmp('strPROGESPEAnteriorGlicemiaRes').readOnly=true;
                                            Ext.getCmp('strPROGESPEAnteriorTraeMicroAlbuminuria').readOnly=true;
                                            Ext.getCmp('fecPROGESPEAnteriorMicroAlbuminuria').readOnly=true;
                                            Ext.getCmp('strPROGESPEAnteriorMicroAlbuminuriaRes').readOnly=true;
                                            Ext.getCmp('strPROGESPEAnteriorTraeUrea').readOnly=true;
                                            Ext.getCmp('fecPROGESPEAnteriorUrea').readOnly=true;
                                            Ext.getCmp('strPROGESPEAnteriorUreaRes').readOnly=true;
                                            Ext.getCmp('strPROGESPEAnteriorTraeCreatinina').readOnly=true;
                                            Ext.getCmp('fecPROGESPEAnteriorCreatinina').readOnly=true;
                                            Ext.getCmp('strPROGESPEAnteriorCreatininaRes').readOnly=true;
                                            Ext.getCmp('strPROGESPEAnteriorTFG').readOnly=true;
                                            Ext.getCmp('strPROGESPESeguimientoTraeParcialorina').readOnly=false;
                                            Ext.getCmp('fecPROGESPESeguimientoParcialorina').readOnly=false;
                                            Ext.getCmp('strPROGESPESeguimientoParcialorinaRes').readOnly=false;
                                            Ext.getCmp('strPROGESPESeguimientoTraeColesterolTotal').readOnly=false;
                                            Ext.getCmp('fecPROGESPESeguimientoColesterolTotal').readOnly=false;
                                            Ext.getCmp('strPROGESPESeguimientoColesterolTotalRes').readOnly=false;
                                            Ext.getCmp('strPROGESPESeguimientoTraeColesterolHDL').readOnly=false;
                                            Ext.getCmp('fecPROGESPESeguimientoColesterolHDL').readOnly=false;
                                            Ext.getCmp('strPROGESPESeguimientoColesterolHDLRes').readOnly=false;
                                            Ext.getCmp('strPROGESPESeguimientoTraeColesterolLDL').readOnly=false;
                                            Ext.getCmp('fecPROGESPESeguimientoColesterolLDL').readOnly=false;
                                            Ext.getCmp('strPROGESPESeguimientoColesterolLDLRes').readOnly=false;
                                            Ext.getCmp('strPROGESPESeguimientoTraeTrigliceridos').readOnly=false;
                                            Ext.getCmp('fecPROGESPESeguimientoTrigliceridos').readOnly=false;
                                            Ext.getCmp('strPROGESPESeguimientoTrigliceridosRes').readOnly=false;
                                            Ext.getCmp('strPROGESPESeguimientoTraeHemoglobinaGlicosilada').readOnly=false;
                                            Ext.getCmp('fecPROGESPESeguimientoHemoglobinaGlicosilada').readOnly=false;
                                            Ext.getCmp('strPROGESPESeguimientoHemoglobinaGlicosiladaRes').readOnly=false;
                                            Ext.getCmp('strPROGESPESeguimientoTraeGlicemia').readOnly=false;
                                            Ext.getCmp('fecPROGESPESeguimientoGlicemia').readOnly=false;
                                            Ext.getCmp('strPROGESPESeguimientoGlicemiaRes').readOnly=false;
                                            Ext.getCmp('strPROGESPESeguimientoTraeMicroAlbuminuria').readOnly=false;
                                            Ext.getCmp('fecPROGESPESeguimientoMicroAlbuminuria').readOnly=false;
                                            Ext.getCmp('strPROGESPESeguimientoMicroAlbuminuriaRes').readOnly=false;
                                            Ext.getCmp('strPROGESPESeguimientoTraeUrea').readOnly=false;
                                            Ext.getCmp('fecPROGESPESeguimientoUrea').readOnly=false;
                                            Ext.getCmp('strPROGESPESeguimientoUreaRes').readOnly=false;
                                            Ext.getCmp('strPROGESPESeguimientoTraeCreatinina').readOnly=false;
                                            Ext.getCmp('fecPROGESPESeguimientoCreatinina').readOnly=false;
                                            Ext.getCmp('strPROGESPESeguimientoCreatininaRes').readOnly=false;
                                            Ext.getCmp('strPROGESPETFGSeguimiento').readOnly=false;
                                            Ext.getCmp('strPROGESPETraeParcialorina').allowBlank=true;
                                            Ext.getCmp('fecPROGESPEParcialorina').allowBlank=true;
                                            Ext.getCmp('strPROGESPEParcialorinaRes').allowBlank=true;
                                            Ext.getCmp('strPROGESPETraeColesterolTotal').allowBlank=true;
                                            Ext.getCmp('fecPROGESPEColesterolTotal').allowBlank=true;
                                            Ext.getCmp('strPROGESPEColesterolTotalRes').allowBlank=true;
                                            Ext.getCmp('strPROGESPETraeColesterolHDL').allowBlank=true;
                                            Ext.getCmp('fecPROGESPEColesterolHDL').allowBlank=true;
                                            Ext.getCmp('strPROGESPEColesterolHDLRes').allowBlank=true;
                                            Ext.getCmp('strPROGESPETraeColesterolLDL').allowBlank=true;
                                            Ext.getCmp('fecPROGESPEColesterolLDL').allowBlank=true;
                                            Ext.getCmp('strPROGESPEColesterolLDLRes').allowBlank=true;
                                            Ext.getCmp('strPROGESPETraeTrigliceridos').allowBlank=true;
                                            Ext.getCmp('fecPROGESPETrigliceridos').allowBlank=true;
                                            Ext.getCmp('strPROGESPETrigliceridosRes').allowBlank=true;
                                            Ext.getCmp('strPROGESPETraeHemoglobinaGlicosilada').allowBlank=true;
                                            Ext.getCmp('fecPROGESPEHemoglobinaGlicosilada').allowBlank=true;
                                            Ext.getCmp('strPROGESPEHemoglobinaGlicosiladaRes').allowBlank=true;
                                            Ext.getCmp('strPROGESPETraeGlicemia').allowBlank=true;
                                            Ext.getCmp('fecPROGESPEGlicemia').allowBlank=true;
                                            Ext.getCmp('strPROGESPEGlicemiaRes').allowBlank=true;
                                            Ext.getCmp('strPROGESPETraeMicroAlbuminuria').allowBlank=true;
                                            Ext.getCmp('fecPROGESPEMicroAlbuminuria').allowBlank=true;
                                            Ext.getCmp('strPROGESPEMicroAlbuminuriaRes').allowBlank=true;
                                            Ext.getCmp('strPROGESPETraeUrea').allowBlank=true;
                                            Ext.getCmp('fecPROGESPEUrea').allowBlank=true;
                                            Ext.getCmp('strPROGESPEUreaRes').allowBlank=true;
                                            Ext.getCmp('strPROGESPETraeCreatinina').allowBlank=true;
                                            Ext.getCmp('fecPROGESPECreatinina').allowBlank=true;
                                            Ext.getCmp('strPROGESPECreatininaRes').allowBlank=true;
                                            Ext.getCmp('intPROGESPETFGIngreso').allowBlank=true;
                                            Ext.getCmp('strPROGESPESeguimientoTraeParcialorina').allowBlank=false;
                                            Ext.getCmp('strPROGESPESeguimientoTraeColesterolTotal').allowBlank=false;
                                            Ext.getCmp('strPROGESPESeguimientoTraeColesterolHDL').allowBlank=false;
                                            Ext.getCmp('strPROGESPESeguimientoTraeColesterolLDL').allowBlank=false;
                                            Ext.getCmp('strPROGESPESeguimientoTraeTrigliceridos').allowBlank=false;
                                            Ext.getCmp('strPROGESPESeguimientoTraeHemoglobinaGlicosilada').allowBlank=false;
                                            Ext.getCmp('strPROGESPESeguimientoTraeGlicemia').allowBlank=false;
                                            Ext.getCmp('strPROGESPESeguimientoTraeMicroAlbuminuria').allowBlank=false;
                                            Ext.getCmp('strPROGESPESeguimientoTraeUrea').allowBlank=false;
                                            Ext.getCmp('strPROGESPESeguimientoTraeCreatinina').allowBlank=false;
                                            Ext.getCmp('strPROGESPEAnteriorTraeParcialorina').allowBlank=true;
                                            Ext.getCmp('fecPROGESPEAnteriorParcialorina').allowBlank=true;
                                            Ext.getCmp('strPROGESPEAnteriorParcialorinaRes').allowBlank=true;
                                            Ext.getCmp('strPROGESPEAnteriorTraeColesterolTotal').allowBlank=true;
                                            Ext.getCmp('fecPROGESPEAnteriorColesterolTotal').allowBlank=true;
                                            Ext.getCmp('strPROGESPEAnteriorColesterolTotalRes').allowBlank=true;
                                            Ext.getCmp('strPROGESPEAnteriorTraeColesterolHDL').allowBlank=true;
                                            Ext.getCmp('fecPROGESPEAnteriorColesterolHDL').allowBlank=true;
                                            Ext.getCmp('strPROGESPEAnteriorColesterolHDLRes').allowBlank=true;
                                            Ext.getCmp('strPROGESPEAnteriorTraeColesterolLDL').allowBlank=true;
                                            Ext.getCmp('fecPROGESPEAnteriorColesterolLDL').allowBlank=true;
                                            Ext.getCmp('strPROGESPEAnteriorColesterolLDLRes').allowBlank=true;
                                            Ext.getCmp('strPROGESPEAnteriorTraeTrigliceridos').allowBlank=true;
                                            Ext.getCmp('fecPROGESPEAnteriorTrigliceridos').allowBlank=true;
                                            Ext.getCmp('strPROGESPEAnteriorTrigliceridosRes').allowBlank=true;
                                            Ext.getCmp('strPROGESPEAnteriorTraeHemoglobinaGlicosilada').allowBlank=true;
                                            Ext.getCmp('fecPROGESPEAnteriorHemoglobinaGlicosilada').allowBlank=true;
                                            Ext.getCmp('strPROGESPEAnteriorHemoglobinaGlicosiladaRes').allowBlank=true;
                                            Ext.getCmp('strPROGESPEAnteriorTraeGlicemia').allowBlank=true;
                                            Ext.getCmp('fecPROGESPEAnteriorGlicemia').allowBlank=true;
                                            Ext.getCmp('strPROGESPEAnteriorGlicemiaRes').allowBlank=true;
                                            Ext.getCmp('strPROGESPEAnteriorTraeMicroAlbuminuria').allowBlank=true;
                                            Ext.getCmp('fecPROGESPEAnteriorMicroAlbuminuria').allowBlank=true;
                                            Ext.getCmp('strPROGESPEAnteriorMicroAlbuminuriaRes').allowBlank=true;
                                            Ext.getCmp('strPROGESPEAnteriorTraeUrea').allowBlank=true;
                                            Ext.getCmp('fecPROGESPEAnteriorUrea').allowBlank=true;
                                            Ext.getCmp('strPROGESPEAnteriorUreaRes').allowBlank=true;
                                            Ext.getCmp('strPROGESPEAnteriorTraeCreatinina').allowBlank=true;
                                            Ext.getCmp('fecPROGESPEAnteriorCreatinina').allowBlank=true;
                                            Ext.getCmp('strPROGESPEAnteriorCreatininaRes').allowBlank=true;
                                            Ext.getCmp('strPROGESPEAnteriorTFG').allowBlank=true;
                                        }else{
                                            Ext.getCmp('fecPROGESPEIngreso').allowBlank = false;
                                            Ext.getCmp('strPROGESPEViaCaptacion').allowBlank = false;
                                            Ext.getCmp('fecPROGESPEIngreso').readOnly = false;
                                            Ext.getCmp('strPROGESPEViaCaptacion').readOnly = false;
                                            Ext.getCmp('fsProgramaEspecialesExamAnteriores').setVisible(false);
                                            Ext.getCmp('fsProgramaEspecialesExamSeguimiento').setVisible(false);
                                            Ext.getCmp('strPROGESPETraeParcialorina').allowBlank=false;
                                            Ext.getCmp('fecPROGESPEParcialorina').allowBlank=false;
                                            Ext.getCmp('strPROGESPEParcialorinaRes').allowBlank=false;
                                            Ext.getCmp('strPROGESPETraeColesterolTotal').allowBlank=false;
                                            Ext.getCmp('fecPROGESPEColesterolTotal').allowBlank=false;
                                            Ext.getCmp('strPROGESPEColesterolTotalRes').allowBlank=false;
                                            Ext.getCmp('strPROGESPETraeColesterolHDL').allowBlank=false;
                                            Ext.getCmp('fecPROGESPEColesterolHDL').allowBlank=false;
                                            Ext.getCmp('strPROGESPEColesterolHDLRes').allowBlank=false;
                                            Ext.getCmp('strPROGESPETraeColesterolLDL').allowBlank=false;
                                            Ext.getCmp('fecPROGESPEColesterolLDL').allowBlank=false;
                                            Ext.getCmp('strPROGESPEColesterolLDLRes').allowBlank=false;
                                            Ext.getCmp('strPROGESPETraeTrigliceridos').allowBlank=false;
                                            Ext.getCmp('fecPROGESPETrigliceridos').allowBlank=false;
                                            Ext.getCmp('strPROGESPETrigliceridosRes').allowBlank=false;
                                            Ext.getCmp('strPROGESPETraeHemoglobinaGlicosilada').allowBlank=false;
                                            Ext.getCmp('fecPROGESPEHemoglobinaGlicosilada').allowBlank=false;
                                            Ext.getCmp('strPROGESPEHemoglobinaGlicosiladaRes').allowBlank=false;
                                            Ext.getCmp('strPROGESPETraeGlicemia').allowBlank=false;
                                            Ext.getCmp('fecPROGESPEGlicemia').allowBlank=false;
                                            Ext.getCmp('strPROGESPEGlicemiaRes').allowBlank=false;
                                            Ext.getCmp('strPROGESPETraeMicroAlbuminuria').allowBlank=false;
                                            Ext.getCmp('fecPROGESPEMicroAlbuminuria').allowBlank=false;
                                            Ext.getCmp('strPROGESPEMicroAlbuminuriaRes').allowBlank=false;
                                            Ext.getCmp('strPROGESPETraeUrea').allowBlank=false;
                                            Ext.getCmp('fecPROGESPEUrea').allowBlank=false;
                                            Ext.getCmp('strPROGESPEUreaRes').allowBlank=false;
                                            Ext.getCmp('strPROGESPETraeCreatinina').allowBlank=false;
                                            Ext.getCmp('fecPROGESPECreatinina').allowBlank=false;
                                            Ext.getCmp('strPROGESPECreatininaRes').allowBlank=false;
                                            Ext.getCmp('intPROGESPETFGIngreso').allowBlank=false;
                                            Ext.getCmp('strPROGESPETraeParcialorina').readOnly=false;
                                            Ext.getCmp('fecPROGESPEParcialorina').readOnly=false;
                                            Ext.getCmp('strPROGESPEParcialorinaRes').readOnly=false;
                                            Ext.getCmp('strPROGESPETraeColesterolTotal').readOnly=false;
                                            Ext.getCmp('fecPROGESPEColesterolTotal').readOnly=false;
                                            Ext.getCmp('strPROGESPEColesterolTotalRes').readOnly=false;
                                            Ext.getCmp('strPROGESPETraeColesterolHDL').readOnly=false;
                                            Ext.getCmp('fecPROGESPEColesterolHDL').readOnly=false;
                                            Ext.getCmp('strPROGESPEColesterolHDLRes').readOnly=false;
                                            Ext.getCmp('strPROGESPETraeColesterolLDL').readOnly=false;
                                            Ext.getCmp('fecPROGESPEColesterolLDL').readOnly=false;
                                            Ext.getCmp('strPROGESPEColesterolLDLRes').readOnly=false;
                                            Ext.getCmp('strPROGESPETraeTrigliceridos').readOnly=false;
                                            Ext.getCmp('fecPROGESPETrigliceridos').readOnly=false;
                                            Ext.getCmp('strPROGESPETrigliceridosRes').readOnly=false;
                                            Ext.getCmp('strPROGESPETraeHemoglobinaGlicosilada').readOnly=false;
                                            Ext.getCmp('fecPROGESPEHemoglobinaGlicosilada').readOnly=false;
                                            Ext.getCmp('strPROGESPEHemoglobinaGlicosiladaRes').readOnly=false;
                                            Ext.getCmp('strPROGESPETraeGlicemia').readOnly=false;
                                            Ext.getCmp('fecPROGESPEGlicemia').readOnly=false;
                                            Ext.getCmp('strPROGESPEGlicemiaRes').readOnly=false;
                                            Ext.getCmp('strPROGESPETraeMicroAlbuminuria').readOnly=false;
                                            Ext.getCmp('fecPROGESPEMicroAlbuminuria').readOnly=false;
                                            Ext.getCmp('strPROGESPEMicroAlbuminuriaRes').readOnly=false;
                                            Ext.getCmp('strPROGESPETraeUrea').readOnly=false;
                                            Ext.getCmp('fecPROGESPEUrea').readOnly=false;
                                            Ext.getCmp('strPROGESPEUreaRes').readOnly=false;
                                            Ext.getCmp('strPROGESPETraeCreatinina').readOnly=false;
                                            Ext.getCmp('fecPROGESPECreatinina').readOnly=false;
                                            Ext.getCmp('strPROGESPECreatininaRes').readOnly=false;
                                            Ext.getCmp('intPROGESPETFGIngreso').readOnly=false;
                                            Ext.getCmp('strPROGESPEAnteriorTraeParcialorina').readOnly=true;
                                            Ext.getCmp('fecPROGESPEAnteriorParcialorina').readOnly=true;
                                            Ext.getCmp('strPROGESPEAnteriorParcialorinaRes').readOnly=true;
                                            Ext.getCmp('strPROGESPEAnteriorTraeColesterolTotal').readOnly=true;
                                            Ext.getCmp('fecPROGESPEAnteriorColesterolTotal').readOnly=true;
                                            Ext.getCmp('strPROGESPEAnteriorColesterolTotalRes').readOnly=true;
                                            Ext.getCmp('strPROGESPEAnteriorTraeColesterolHDL').readOnly=true;
                                            Ext.getCmp('fecPROGESPEAnteriorColesterolHDL').readOnly=true;
                                            Ext.getCmp('strPROGESPEAnteriorColesterolHDLRes').readOnly=true;
                                            Ext.getCmp('strPROGESPEAnteriorTraeColesterolLDL').readOnly=true;
                                            Ext.getCmp('fecPROGESPEAnteriorColesterolLDL').readOnly=true;
                                            Ext.getCmp('strPROGESPEAnteriorColesterolLDLRes').readOnly=true;
                                            Ext.getCmp('strPROGESPEAnteriorTraeTrigliceridos').readOnly=true;
                                            Ext.getCmp('fecPROGESPEAnteriorTrigliceridos').readOnly=true;
                                            Ext.getCmp('strPROGESPEAnteriorTrigliceridosRes').readOnly=true;
                                            Ext.getCmp('strPROGESPEAnteriorTraeHemoglobinaGlicosilada').readOnly=true;
                                            Ext.getCmp('fecPROGESPEAnteriorHemoglobinaGlicosilada').readOnly=true;
                                            Ext.getCmp('strPROGESPEAnteriorHemoglobinaGlicosiladaRes').readOnly=true;
                                            Ext.getCmp('strPROGESPEAnteriorTraeGlicemia').readOnly=true;
                                            Ext.getCmp('fecPROGESPEAnteriorGlicemia').readOnly=true;
                                            Ext.getCmp('strPROGESPEAnteriorGlicemiaRes').readOnly=true;
                                            Ext.getCmp('strPROGESPEAnteriorTraeMicroAlbuminuria').readOnly=true;
                                            Ext.getCmp('fecPROGESPEAnteriorMicroAlbuminuria').readOnly=true;
                                            Ext.getCmp('strPROGESPEAnteriorMicroAlbuminuriaRes').readOnly=true;
                                            Ext.getCmp('strPROGESPEAnteriorTraeUrea').readOnly=true;
                                            Ext.getCmp('fecPROGESPEAnteriorUrea').readOnly=true;
                                            Ext.getCmp('strPROGESPEAnteriorUreaRes').readOnly=true;
                                            Ext.getCmp('strPROGESPEAnteriorTraeCreatinina').readOnly=true;
                                            Ext.getCmp('fecPROGESPEAnteriorCreatinina').readOnly=true;
                                            Ext.getCmp('strPROGESPEAnteriorCreatininaRes').readOnly=true;
                                            Ext.getCmp('strPROGESPEAnteriorTFG').readOnly=true;
                                            Ext.getCmp('strPROGESPESeguimientoTraeParcialorina').readOnly=true;
                                            Ext.getCmp('fecPROGESPESeguimientoParcialorina').readOnly=true;
                                            Ext.getCmp('strPROGESPESeguimientoParcialorinaRes').readOnly=true;
                                            Ext.getCmp('strPROGESPESeguimientoTraeColesterolTotal').readOnly=true;
                                            Ext.getCmp('fecPROGESPESeguimientoColesterolTotal').readOnly=true;
                                            Ext.getCmp('strPROGESPESeguimientoColesterolTotalRes').readOnly=true;
                                            Ext.getCmp('strPROGESPESeguimientoTraeColesterolHDL').readOnly=true;
                                            Ext.getCmp('fecPROGESPESeguimientoColesterolHDL').readOnly=true;
                                            Ext.getCmp('strPROGESPESeguimientoColesterolHDLRes').readOnly=true;
                                            Ext.getCmp('strPROGESPESeguimientoTraeColesterolLDL').readOnly=true;
                                            Ext.getCmp('fecPROGESPESeguimientoColesterolLDL').readOnly=true;
                                            Ext.getCmp('strPROGESPESeguimientoColesterolLDLRes').readOnly=true;
                                            Ext.getCmp('strPROGESPESeguimientoTraeTrigliceridos').readOnly=true;
                                            Ext.getCmp('fecPROGESPESeguimientoTrigliceridos').readOnly=true;
                                            Ext.getCmp('strPROGESPESeguimientoTrigliceridosRes').readOnly=true;
                                            Ext.getCmp('strPROGESPESeguimientoTraeHemoglobinaGlicosilada').readOnly=true;
                                            Ext.getCmp('fecPROGESPESeguimientoHemoglobinaGlicosilada').readOnly=true;
                                            Ext.getCmp('strPROGESPESeguimientoHemoglobinaGlicosiladaRes').readOnly=true;
                                            Ext.getCmp('strPROGESPESeguimientoTraeGlicemia').readOnly=true;
                                            Ext.getCmp('fecPROGESPESeguimientoGlicemia').readOnly=true;
                                            Ext.getCmp('strPROGESPESeguimientoGlicemiaRes').readOnly=true;
                                            Ext.getCmp('strPROGESPESeguimientoTraeMicroAlbuminuria').readOnly=true;
                                            Ext.getCmp('fecPROGESPESeguimientoMicroAlbuminuria').readOnly=true;
                                            Ext.getCmp('strPROGESPESeguimientoMicroAlbuminuriaRes').readOnly=true;
                                            Ext.getCmp('strPROGESPESeguimientoTraeUrea').readOnly=true;
                                            Ext.getCmp('fecPROGESPESeguimientoUrea').readOnly=true;
                                            Ext.getCmp('strPROGESPESeguimientoUreaRes').readOnly=true;
                                            Ext.getCmp('strPROGESPESeguimientoTraeCreatinina').readOnly=true;
                                            Ext.getCmp('fecPROGESPESeguimientoCreatinina').readOnly=true;
                                            Ext.getCmp('strPROGESPESeguimientoCreatininaRes').readOnly=true;
                                            Ext.getCmp('strPROGESPETFGSeguimiento').readOnly=true;
                                            Ext.getCmp('strPROGESPEAnteriorTraeParcialorina').allowBlank=true;
                                            Ext.getCmp('fecPROGESPEAnteriorParcialorina').allowBlank=true;
                                            Ext.getCmp('strPROGESPEAnteriorParcialorinaRes').allowBlank=true;
                                            Ext.getCmp('strPROGESPEAnteriorTraeColesterolTotal').allowBlank=true;
                                            Ext.getCmp('fecPROGESPEAnteriorColesterolTotal').allowBlank=true;
                                            Ext.getCmp('strPROGESPEAnteriorColesterolTotalRes').allowBlank=true;
                                            Ext.getCmp('strPROGESPEAnteriorTraeColesterolHDL').allowBlank=true;
                                            Ext.getCmp('fecPROGESPEAnteriorColesterolHDL').allowBlank=true;
                                            Ext.getCmp('strPROGESPEAnteriorColesterolHDLRes').allowBlank=true;
                                            Ext.getCmp('strPROGESPEAnteriorTraeColesterolLDL').allowBlank=true;
                                            Ext.getCmp('fecPROGESPEAnteriorColesterolLDL').allowBlank=true;
                                            Ext.getCmp('strPROGESPEAnteriorColesterolLDLRes').allowBlank=true;
                                            Ext.getCmp('strPROGESPEAnteriorTraeTrigliceridos').allowBlank=true;
                                            Ext.getCmp('fecPROGESPEAnteriorTrigliceridos').allowBlank=true;
                                            Ext.getCmp('strPROGESPEAnteriorTrigliceridosRes').allowBlank=true;
                                            Ext.getCmp('strPROGESPEAnteriorTraeHemoglobinaGlicosilada').allowBlank=true;
                                            Ext.getCmp('fecPROGESPEAnteriorHemoglobinaGlicosilada').allowBlank=true;
                                            Ext.getCmp('strPROGESPEAnteriorHemoglobinaGlicosiladaRes').allowBlank=true;
                                            Ext.getCmp('strPROGESPEAnteriorTraeGlicemia').allowBlank=true;
                                            Ext.getCmp('fecPROGESPEAnteriorGlicemia').allowBlank=true;
                                            Ext.getCmp('strPROGESPEAnteriorGlicemiaRes').allowBlank=true;
                                            Ext.getCmp('strPROGESPEAnteriorTraeMicroAlbuminuria').allowBlank=true;
                                            Ext.getCmp('fecPROGESPEAnteriorMicroAlbuminuria').allowBlank=true;
                                            Ext.getCmp('strPROGESPEAnteriorMicroAlbuminuriaRes').allowBlank=true;
                                            Ext.getCmp('strPROGESPEAnteriorTraeUrea').allowBlank=true;
                                            Ext.getCmp('fecPROGESPEAnteriorUrea').allowBlank=true;
                                            Ext.getCmp('strPROGESPEAnteriorUreaRes').allowBlank=true;
                                            Ext.getCmp('strPROGESPEAnteriorTraeCreatinina').allowBlank=true;
                                            Ext.getCmp('fecPROGESPEAnteriorCreatinina').allowBlank=true;
                                            Ext.getCmp('strPROGESPEAnteriorCreatininaRes').allowBlank=true;
                                            Ext.getCmp('strPROGESPEAnteriorTFG').allowBlank=true;
                                            Ext.getCmp('strPROGESPETraeParcialorina').allowBlank=false;
                                            Ext.getCmp('strPROGESPETraeColesterolTotal').allowBlank=false;
                                            Ext.getCmp('strPROGESPETraeColesterolHDL').allowBlank=false;
                                            Ext.getCmp('strPROGESPETraeColesterolLDL').allowBlank=false;
                                            Ext.getCmp('strPROGESPETraeTrigliceridos').allowBlank=false;
                                            Ext.getCmp('strPROGESPETraeHemoglobinaGlicosilada').allowBlank=false;
                                            Ext.getCmp('strPROGESPETraeGlicemia').allowBlank=false;
                                            Ext.getCmp('strPROGESPETraeMicroAlbuminuria').allowBlank=false;
                                            Ext.getCmp('strPROGESPETraeUrea').allowBlank=false;
                                            Ext.getCmp('strPROGESPETraeCreatinina').allowBlank=false;
                                            Ext.getCmp('strPROGESPESeguimientoTraeParcialorina').allowBlank=true;
                                            Ext.getCmp('fecPROGESPESeguimientoParcialorina').allowBlank=true;
                                            Ext.getCmp('strPROGESPESeguimientoParcialorinaRes').allowBlank=true;
                                            Ext.getCmp('strPROGESPESeguimientoTraeColesterolTotal').allowBlank=true;
                                            Ext.getCmp('fecPROGESPESeguimientoColesterolTotal').allowBlank=true;
                                            Ext.getCmp('strPROGESPESeguimientoColesterolTotalRes').allowBlank=true;
                                            Ext.getCmp('strPROGESPESeguimientoTraeColesterolHDL').allowBlank=true;
                                            Ext.getCmp('fecPROGESPESeguimientoColesterolHDL').allowBlank=true;
                                            Ext.getCmp('strPROGESPESeguimientoColesterolHDLRes').allowBlank=true;
                                            Ext.getCmp('strPROGESPESeguimientoTraeColesterolLDL').allowBlank=true;
                                            Ext.getCmp('fecPROGESPESeguimientoColesterolLDL').allowBlank=true;
                                            Ext.getCmp('strPROGESPESeguimientoColesterolLDLRes').allowBlank=true;
                                            Ext.getCmp('strPROGESPESeguimientoTraeTrigliceridos').allowBlank=true;
                                            Ext.getCmp('fecPROGESPESeguimientoTrigliceridos').allowBlank=true;
                                            Ext.getCmp('strPROGESPESeguimientoTrigliceridosRes').allowBlank=true;
                                            Ext.getCmp('strPROGESPESeguimientoTraeHemoglobinaGlicosilada').allowBlank=true;
                                            Ext.getCmp('fecPROGESPESeguimientoHemoglobinaGlicosilada').allowBlank=true;
                                            Ext.getCmp('strPROGESPESeguimientoHemoglobinaGlicosiladaRes').allowBlank=true;
                                            Ext.getCmp('strPROGESPESeguimientoTraeGlicemia').allowBlank=true;
                                            Ext.getCmp('fecPROGESPESeguimientoGlicemia').allowBlank=true;
                                            Ext.getCmp('strPROGESPESeguimientoGlicemiaRes').allowBlank=true;
                                            Ext.getCmp('strPROGESPESeguimientoTraeMicroAlbuminuria').allowBlank=true;
                                            Ext.getCmp('fecPROGESPESeguimientoMicroAlbuminuria').allowBlank=true;
                                            Ext.getCmp('strPROGESPESeguimientoMicroAlbuminuriaRes').allowBlank=true;
                                            Ext.getCmp('strPROGESPESeguimientoTraeUrea').allowBlank=true;
                                            Ext.getCmp('fecPROGESPESeguimientoUrea').allowBlank=true;
                                            Ext.getCmp('strPROGESPESeguimientoUreaRes').allowBlank=true;
                                            Ext.getCmp('strPROGESPESeguimientoTraeCreatinina').allowBlank=true;
                                            Ext.getCmp('fecPROGESPESeguimientoCreatinina').allowBlank=true;
                                            Ext.getCmp('strPROGESPESeguimientoCreatininaRes').allowBlank=true;
                                            Ext.getCmp('strPROGESPETFGSeguimiento').allowBlank=true;
                                        }
                                    }
                                }
                            }
                        ]
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'datefield',
                                width: 120,
                                fieldLabel: 'Fecha Ingreso',
                                name: 'Fecha Ingreso',
                                allowBlank: true,
                                emptyText: '(dia/mes/año) ',
                                style: 'text-align:center;',
                                id: 'fecPROGESPEIngreso'
                            },
                            {
                                html: '   Via de Captacion:'
                            },
                            {
                                xtype: 'combo',
                                name: 'Via de Captacion',
                                width: 250,
                                allowBlank: true,
                                store: stViaCaptacion,
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strPROGESPEViaCaptacion'
                            }
                        ]
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'combo',
                                fieldLabel: 'Dx HTA',
                                name: 'Dx HTA',
                                width: 60,
                                allowBlank: true,
                                store: 'StoreSiNo',
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strPROGESPEDxHTA',
                                listeners:{
                                    change : function( t, newValue, oldValue){
                                        if(newValue == "NO"){
                                            Ext.getCmp('strPROGESPETipoDxHTA').allowBlank = true;
                                            Ext.getCmp('intPROGESPEDxHTAMes').allowBlank = true;
                                            Ext.getCmp('intPROGESPEDxHTAAno').allowBlank = true;
                                            Ext.getCmp('strPROGESPENivelRiesgoHTA').allowBlank = true;
                                            Ext.getCmp('strPROGESPETipoDxHTA').setValue(null);
                                            Ext.getCmp('intPROGESPEDxHTAMes').setValue(null);
                                            Ext.getCmp('intPROGESPEDxHTAAno').setValue(null);
                                            Ext.getCmp('strPROGESPENivelRiesgoHTA').setValue(null);
                                            Ext.getCmp('strPROGESPETipoDxHTA').disable();
                                            Ext.getCmp('intPROGESPEDxHTAMes').disable();
                                            Ext.getCmp('intPROGESPEDxHTAAno').disable();
                                            Ext.getCmp('strPROGESPENivelRiesgoHTA').disable();
                                            Ext.getCmp('strPROGESPETipoDxHTA').clearInvalid();
                                            Ext.getCmp('intPROGESPEDxHTAMes').clearInvalid();
                                            Ext.getCmp('intPROGESPEDxHTAAno').clearInvalid();
                                            Ext.getCmp('strPROGESPENivelRiesgoHTA').clearInvalid();
                                        }else{
                                            Ext.getCmp('strPROGESPETipoDxHTA').enable();
                                            Ext.getCmp('intPROGESPEDxHTAMes').enable();
                                            Ext.getCmp('intPROGESPEDxHTAAno').enable();
                                            Ext.getCmp('strPROGESPENivelRiesgoHTA').enable();
                                            Ext.getCmp('strPROGESPETipoDxHTA').allowBlank = false;
                                            Ext.getCmp('intPROGESPEDxHTAMes').allowBlank = false;
                                            Ext.getCmp('intPROGESPEDxHTAAno').allowBlank = false;
                                            Ext.getCmp('strPROGESPENivelRiesgoHTA').allowBlank = false;
                                        }
                                    }
                                }
                            },
                            {
                                html:'Tipo de Dx:'
                            },
                            {
                                xtype: 'combo',
                                name: 'Tipo de Dx',
                                width: 90,
                                allowBlank: true,
                                disabled: true,
                                store: stDatProgTipoDx,
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strPROGESPETipoDxHTA'
                            },
                            {
                                html:'Nivel de Riesgo:'
                            },
                            {
                                xtype: 'combo',
                                name: 'Nivel de Riesgo',
                                width: 90,
                                allowBlank: true,
                                disabled: true,
                                store: stDatProgNivelRiesgo,
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strPROGESPENivelRiesgoHTA'
                            },
                            {
                                html:'Fecha Dx:'
                            },
                            {
                                xtype: 'numberfield',
                                name: 'Mes',
                                emptyText: 'Mes',
                                disabled: true,
                                width: 50,
                                minValue: 1,
                                maxValue: 12,
                                decimalPrecision: 0,
                                allowBlank: true,
                                id: 'intPROGESPEDxHTAMes'
                            },
                            {
                                html:'/'
                            },
                            {
                                xtype: 'numberfield',
                                name: 'Año',
                                emptyText: 'Año',
                                disabled: true,
                                width: 70,
                                minValue: 1900,
                                maxValue: 2199,
                                decimalPrecision: 0,
                                allowBlank: true,
                                id: 'intPROGESPEDxHTAAno'
                            },
                        ]
                    },
                    {
                        html: '<br>'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'combo',
                                fieldLabel: 'Dx DM',
                                name: 'Dx DM',
                                width: 60,
                                allowBlank: true,
                                store: 'StoreSiNo',
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strPROGESPEDxDM',
                                listeners:{
                                    change : function( t, newValue, oldValue){
                                        if(newValue == "NO"){
                                            Ext.getCmp('strPROGESPETipoDxDM').allowBlank = true;
                                            Ext.getCmp('intPROGESPEDxDMMes').allowBlank = true;
                                            Ext.getCmp('intPROGESPEDxDMAno').allowBlank = true;
                                            Ext.getCmp('strPROGESPENivelRiesgoDM').allowBlank = true;
                                            Ext.getCmp('strPROGESPETipoDM').allowBlank = true;
                                            Ext.getCmp('strPROGESPETipoDxDM').setValue(null);
                                            Ext.getCmp('intPROGESPEDxDMMes').setValue(null);
                                            Ext.getCmp('intPROGESPEDxDMAno').setValue(null);
                                            Ext.getCmp('strPROGESPENivelRiesgoDM').setValue(null);
                                            Ext.getCmp('strPROGESPETipoDM').setValue(null);
                                            Ext.getCmp('strPROGESPETipoDxDM').disable();
                                            Ext.getCmp('intPROGESPEDxDMMes').disable();
                                            Ext.getCmp('intPROGESPEDxDMAno').disable();
                                            Ext.getCmp('strPROGESPENivelRiesgoDM').disable();
                                            Ext.getCmp('strPROGESPETipoDM').disable();
                                            Ext.getCmp('strPROGESPETipoDxDM').clearInvalid();
                                            Ext.getCmp('intPROGESPEDxDMMes').clearInvalid();
                                            Ext.getCmp('intPROGESPEDxDMAno').clearInvalid();
                                            Ext.getCmp('strPROGESPENivelRiesgoDM').clearInvalid();
                                            Ext.getCmp('strPROGESPETipoDM').clearInvalid();
                                        }else{
                                            Ext.getCmp('strPROGESPETipoDxDM').enable();
                                            Ext.getCmp('intPROGESPEDxDMMes').enable();
                                            Ext.getCmp('intPROGESPEDxDMAno').enable();
                                            Ext.getCmp('strPROGESPENivelRiesgoDM').enable();
                                            Ext.getCmp('strPROGESPETipoDM').enable();
                                            Ext.getCmp('strPROGESPETipoDxDM').allowBlank = false;
                                            Ext.getCmp('intPROGESPEDxDMMes').allowBlank = false;
                                            Ext.getCmp('intPROGESPEDxDMAno').allowBlank = false;
                                            Ext.getCmp('strPROGESPENivelRiesgoDM').allowBlank = false;
                                            Ext.getCmp('strPROGESPETipoDM').allowBlank = false;
                                        }
                                    }
                                }
                            },
                            {
                                html:'Tipo de Dx:'
                            },
                            {
                                xtype: 'combo',
                                name: 'Tipo de Dx',
                                width: 90,
                                allowBlank: true,
                                disabled: true,
                                store: stDatProgTipoDx,
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strPROGESPETipoDxDM'
                            },
                            {
                                html:'Nivel de Riesgo:'
                            },
                            {
                                xtype: 'combo',
                                name: 'Nivel de Riesgo',
                                width: 90,
                                allowBlank: true,
                                disabled: true,
                                store: stDatProgNivelRiesgo,
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strPROGESPENivelRiesgoDM'
                            },
                            {
                                html:'Fecha Dx:'
                            },
                            {
                                xtype: 'numberfield',
                                name: 'Mes',
                                emptyText: 'Mes',
                                disabled: true,
                                width: 50,
                                minValue: 1,
                                maxValue: 12,
                                decimalPrecision: 0,
                                allowBlank: true,
                                id: 'intPROGESPEDxDMMes'
                            },
                            {
                                html:'/'
                            },
                            {
                                xtype: 'numberfield',
                                name: 'Año',
                                emptyText: 'Año',
                                disabled: true,
                                width: 70,
                                minValue: 1900,
                                maxValue: 2199,
                                decimalPrecision: 0,
                                allowBlank: true,
                                id: 'intPROGESPEDxDMAno'
                            },
                            {
                                html:'Tipo DM:'
                            },
                            {
                                xtype: 'combo',
                                name: 'Tipo de DM',
                                width: 90,
                                allowBlank: true,
                                disabled: true,
                                store: stDatProgTipoDM,
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strPROGESPETipoDM'
                            },
                        ]
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'combo',
                                fieldLabel: 'Dx Nefroprot',
                                name: 'Dx Nefroproteccion',
                                width: 60,
                                allowBlank: true,
                                store: 'StoreSiNo',
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strPROGESPEDxNefroProteccion',
                                listeners:{
                                    change : function( t, newValue, oldValue){
                                        if(newValue == "NO"){
                                            Ext.getCmp('strPROGESPETipoDxNefroProteccion').allowBlank = true;
                                            Ext.getCmp('intPROGESPEDxNefroProteccionMes').allowBlank = true;
                                            Ext.getCmp('intPROGESPEDxNefroProteccionAno').allowBlank = true;
                                            Ext.getCmp('strPROGESPENivelRiesgoNefroProteccion').allowBlank = true;
                                            Ext.getCmp('strPROGESPEEstadioNefroProteccion').allowBlank = true;
                                            Ext.getCmp('strPROGESPETipoDxNefroProteccion').setValue(null);
                                            Ext.getCmp('intPROGESPEDxNefroProteccionMes').setValue(null);
                                            Ext.getCmp('intPROGESPEDxNefroProteccionAno').setValue(null);
                                            Ext.getCmp('strPROGESPENivelRiesgoNefroProteccion').setValue(null);
                                            Ext.getCmp('strPROGESPEEstadioNefroProteccion').setValue(null);
                                            Ext.getCmp('strPROGESPETipoDxNefroProteccion').disable();
                                            Ext.getCmp('intPROGESPEDxNefroProteccionMes').disable();
                                            Ext.getCmp('intPROGESPEDxNefroProteccionAno').disable();
                                            Ext.getCmp('strPROGESPENivelRiesgoNefroProteccion').disable();
                                            Ext.getCmp('strPROGESPEEstadioNefroProteccion').disable();
                                            Ext.getCmp('strPROGESPETipoDxNefroProteccion').clearInvalid();
                                            Ext.getCmp('intPROGESPEDxNefroProteccionMes').clearInvalid();
                                            Ext.getCmp('intPROGESPEDxNefroProteccionAno').clearInvalid();
                                            Ext.getCmp('strPROGESPENivelRiesgoNefroProteccion').clearInvalid();
                                            Ext.getCmp('strPROGESPEEstadioNefroProteccion').clearInvalid();
                                        }else{
                                            Ext.getCmp('strPROGESPETipoDxNefroProteccion').enable();
                                            Ext.getCmp('intPROGESPEDxNefroProteccionMes').enable();
                                            Ext.getCmp('intPROGESPEDxNefroProteccionAno').enable();
                                            Ext.getCmp('strPROGESPENivelRiesgoNefroProteccion').enable();
                                            Ext.getCmp('strPROGESPEEstadioNefroProteccion').enable();
                                            Ext.getCmp('strPROGESPETipoDxNefroProteccion').allowBlank = false;
                                            Ext.getCmp('intPROGESPEDxNefroProteccionMes').allowBlank = false;
                                            Ext.getCmp('intPROGESPEDxNefroProteccionAno').allowBlank = false;
                                            Ext.getCmp('strPROGESPENivelRiesgoNefroProteccion').allowBlank = false;
                                            Ext.getCmp('strPROGESPEEstadioNefroProteccion').allowBlank = false;
                                        }
                                    }
                                }
                            },
                            {
                                html:'Tipo de Dx:'
                            },
                            {
                                xtype: 'combo',
                                name: 'Tipo de Dx',
                                width: 90,
                                allowBlank: true,
                                disabled: true,
                                store: stDatProgTipoDx,
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strPROGESPETipoDxNefroProteccion'
                            },
                             {
                                html:'Nivel de Riesgo:'
                            },
                            {
                                xtype: 'combo',
                                name: 'Nivel de Riesgo',
                                width: 90,
                                allowBlank: true,
                                disabled: true,
                                store: stDatProgNivelRiesgo,
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strPROGESPENivelRiesgoNefroProteccion'
                            },
                            {
                                html:'Fecha Dx:'
                            },
                            {
                                xtype: 'numberfield',
                                name: 'Mes',
                                emptyText: 'Mes',
                                disabled: true,
                                width: 50,
                                minValue: 1,
                                maxValue: 12,
                                decimalPrecision: 0,
                                allowBlank: true,
                                id: 'intPROGESPEDxNefroProteccionMes'
                            },
                            {
                                html:'/'
                            },
                            {
                                xtype: 'numberfield',
                                name: 'Año',
                                emptyText: 'Año',
                                disabled: true,
                                width: 70,
                                minValue: 1900,
                                maxValue: 2199,
                                decimalPrecision: 0,
                                allowBlank: true,
                                id: 'intPROGESPEDxNefroProteccionAno'
                            },
                            {
                                html:'Estadio:'
                            },
                            {
                                xtype: 'combo',
                                name: 'Estadio',
                                width: 90,
                                allowBlank: true,
                                disabled: true,
                                store: stDatProgEstadioNefroProteccion,
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strPROGESPEEstadioNefroProteccion'
                            },
                        ]
                    },
                    {
                        xtype: 'fieldset',
                        title: 'Examenes Ingreso',
                        layout: 'form',
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        anchor: '100%',
                        autoHeight: true,
                        padding: 5,
                        items: [
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {   
                                        xtype: 'combo',
                                        fieldLabel: 'Parcial de Orina',
                                        name: 'Parcial de Orina',
                                        width: 60,
                                        allowBlank: false,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPROGESPETraeParcialorina',
                                        listeners:{
                                            change : function( t, newValue, oldValue){
                                                if(newValue == "NO"){
                                                    Ext.getCmp('fecPROGESPEParcialorina').allowBlank = true;
                                                    Ext.getCmp('strPROGESPEParcialorinaRes').allowBlank = true;
                                                    Ext.getCmp('fecPROGESPEParcialorina').setValue(null);
                                                    Ext.getCmp('strPROGESPEParcialorinaRes').setValue(null);
                                                    Ext.getCmp('fecPROGESPEParcialorina').disable();
                                                    Ext.getCmp('strPROGESPEParcialorinaRes').disable();
                                                    Ext.getCmp('fecPROGESPEParcialorina').clearInvalid();
                                                    Ext.getCmp('strPROGESPEParcialorinaRes').clearInvalid();
                                                }else{
                                                    Ext.getCmp('fecPROGESPEParcialorina').enable();
                                                    Ext.getCmp('strPROGESPEParcialorinaRes').enable();
                                                    Ext.getCmp('fecPROGESPEParcialorina').allowBlank = false;
                                                    Ext.getCmp('strPROGESPEParcialorinaRes').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html:'Fecha:'
                                    },
                                    {
                                        xtype: 'datefield',
                                        width: 120,
                                        name: 'Fecha',
                                        allowBlank: true,
                                        disabled: true,
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        id: 'fecPROGESPEParcialorina'
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 400,
                                        name: 'Resultado Pacial Orina',
                                        emptyText: 'Resultado',
                                        disabled: true,
                                        allowBlank: false,
                                        id: 'strPROGESPEParcialorinaRes'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {   
                                        xtype: 'combo',
                                        fieldLabel: 'Colesterol Total',
                                        name: 'Colesterol Total',
                                        width: 60,
                                        allowBlank: false,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPROGESPETraeColesterolTotal',
                                        listeners:{
                                            change : function( t, newValue, oldValue){
                                                if(newValue == "NO"){
                                                    Ext.getCmp('fecPROGESPEColesterolTotal').allowBlank = true;
                                                    Ext.getCmp('strPROGESPEColesterolTotalRes').allowBlank = true;
                                                    Ext.getCmp('fecPROGESPEColesterolTotal').setValue(null);
                                                    Ext.getCmp('strPROGESPEColesterolTotalRes').setValue(null);
                                                    Ext.getCmp('fecPROGESPEColesterolTotal').disable();
                                                    Ext.getCmp('strPROGESPEColesterolTotalRes').disable();
                                                    Ext.getCmp('fecPROGESPEColesterolTotal').clearInvalid();
                                                    Ext.getCmp('strPROGESPEColesterolTotalRes').clearInvalid();
                                                }else{
                                                    Ext.getCmp('fecPROGESPEColesterolTotal').enable();
                                                    Ext.getCmp('strPROGESPEColesterolTotalRes').enable();
                                                    Ext.getCmp('fecPROGESPEColesterolTotal').allowBlank = false;
                                                    Ext.getCmp('strPROGESPEColesterolTotalRes').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html:'Fecha:'
                                    },
                                    {
                                        xtype: 'datefield',
                                        width: 120,
                                        name: 'Fecha',
                                        allowBlank: true,
                                        disabled: true,
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        id: 'fecPROGESPEColesterolTotal'
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Resultado Colesterol Total',
                                        emptyText: 'Rango 20 - 700',
                                        width: 110,
                                        decimalPrecision: 0,
                                        allowBlank: true,
                                        disabled: true,
                                        id: 'strPROGESPEColesterolTotalRes'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {   
                                        xtype: 'combo',
                                        fieldLabel: 'Colesterol HDL',
                                        name: 'Colesterol HDL',
                                        width: 60,
                                        allowBlank: false,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPROGESPETraeColesterolHDL',
                                        listeners:{
                                            change : function( t, newValue, oldValue){
                                                if(newValue == "NO"){
                                                    Ext.getCmp('fecPROGESPEColesterolHDL').allowBlank = true;
                                                    Ext.getCmp('strPROGESPEColesterolHDLRes').allowBlank = true;
                                                    Ext.getCmp('fecPROGESPEColesterolHDL').setValue(null);
                                                    Ext.getCmp('strPROGESPEColesterolHDLRes').setValue(null);
                                                    Ext.getCmp('fecPROGESPEColesterolHDL').disable();
                                                    Ext.getCmp('strPROGESPEColesterolHDLRes').disable();
                                                    Ext.getCmp('fecPROGESPEColesterolHDL').clearInvalid();
                                                    Ext.getCmp('strPROGESPEColesterolHDLRes').clearInvalid();
                                                }else{
                                                    Ext.getCmp('fecPROGESPEColesterolHDL').enable();
                                                    Ext.getCmp('strPROGESPEColesterolHDLRes').enable();
                                                    Ext.getCmp('fecPROGESPEColesterolHDL').allowBlank = false;
                                                    Ext.getCmp('strPROGESPEColesterolHDLRes').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html:'Fecha:'
                                    },
                                    {
                                        xtype: 'datefield',
                                        width: 120,
                                        name: 'Fecha',
                                        allowBlank: true,
                                        disabled: true,
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        id: 'fecPROGESPEColesterolHDL'
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Resultado Colesterol HDL',
                                        emptyText: 'Rango 10 - 500',
                                        width: 110,
                                        decimalPrecision: 0,
                                        allowBlank: true,
                                        disabled: true,
                                        id: 'strPROGESPEColesterolHDLRes'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {   
                                        xtype: 'combo',
                                        fieldLabel: 'Colesterol LDL',
                                        name: 'Colesterol LDL',
                                        width: 60,
                                        allowBlank: false,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPROGESPETraeColesterolLDL',
                                        listeners:{
                                            change : function( t, newValue, oldValue){
                                                if(newValue == "NO"){
                                                    Ext.getCmp('fecPROGESPEColesterolLDL').allowBlank = true;
                                                    Ext.getCmp('strPROGESPEColesterolLDLRes').allowBlank = true;
                                                    Ext.getCmp('fecPROGESPEColesterolLDL').setValue(null);
                                                    Ext.getCmp('strPROGESPEColesterolLDLRes').setValue(null);
                                                    Ext.getCmp('fecPROGESPEColesterolLDL').disable();
                                                    Ext.getCmp('strPROGESPEColesterolLDLRes').disable();
                                                    Ext.getCmp('fecPROGESPEColesterolLDL').clearInvalid();
                                                    Ext.getCmp('strPROGESPEColesterolLDLRes').clearInvalid();
                                                }else{
                                                    Ext.getCmp('fecPROGESPEColesterolLDL').enable();
                                                    Ext.getCmp('strPROGESPEColesterolLDLRes').enable();
                                                    Ext.getCmp('fecPROGESPEColesterolLDL').allowBlank = false;
                                                    Ext.getCmp('strPROGESPEColesterolLDLRes').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html:'Fecha:'
                                    },
                                    {
                                        xtype: 'datefield',
                                        width: 120,
                                        name: 'Fecha',
                                        allowBlank: true,
                                        disabled: true,
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        id: 'fecPROGESPEColesterolLDL'
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Resultado Colesterol LDL',
                                        emptyText: 'Rango 10 - 500',
                                        width: 110,
                                        decimalPrecision: 0,
                                        allowBlank: true,
                                        disabled: true,
                                        id: 'strPROGESPEColesterolLDLRes'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {   
                                        xtype: 'combo',
                                        fieldLabel: 'Trigliceridos',
                                        name: 'Trigliceridos',
                                        width: 60,
                                        allowBlank: false,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPROGESPETraeTrigliceridos',
                                        listeners:{
                                            change : function( t, newValue, oldValue){
                                                if(newValue == "NO"){
                                                    Ext.getCmp('fecPROGESPETrigliceridos').allowBlank = true;
                                                    Ext.getCmp('strPROGESPETrigliceridosRes').allowBlank = true;
                                                    Ext.getCmp('fecPROGESPETrigliceridos').setValue(null);
                                                    Ext.getCmp('strPROGESPETrigliceridosRes').setValue(null);
                                                    Ext.getCmp('fecPROGESPETrigliceridos').disable();
                                                    Ext.getCmp('strPROGESPETrigliceridosRes').disable();
                                                    Ext.getCmp('fecPROGESPETrigliceridos').clearInvalid();
                                                    Ext.getCmp('strPROGESPETrigliceridosRes').clearInvalid();
                                                }else{
                                                    Ext.getCmp('fecPROGESPETrigliceridos').enable();
                                                    Ext.getCmp('strPROGESPETrigliceridosRes').enable();
                                                    Ext.getCmp('fecPROGESPETrigliceridos').allowBlank = false;
                                                    Ext.getCmp('strPROGESPETrigliceridosRes').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html:'Fecha:'
                                    },
                                    {
                                        xtype: 'datefield',
                                        width: 120,
                                        name: 'Fecha',
                                        allowBlank: true,
                                        disabled: true,
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        id: 'fecPROGESPETrigliceridos'
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Resultado Trigliceridos',
                                        emptyText: 'Rango 20 - 1000',
                                        width: 110,
                                        decimalPrecision: 0,
                                        allowBlank: true,
                                        disabled: true,
                                        id: 'strPROGESPETrigliceridosRes'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {   
                                        xtype: 'combo',
                                        fieldLabel: 'Hb Glicosilada',
                                        name: 'Hb Glicosilada',
                                        width: 60,
                                        allowBlank: false,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPROGESPETraeHemoglobinaGlicosilada',
                                        listeners:{
                                            change : function( t, newValue, oldValue){
                                                if(newValue == "NO"){
                                                    Ext.getCmp('fecPROGESPEHemoglobinaGlicosilada').allowBlank = true;
                                                    Ext.getCmp('strPROGESPEHemoglobinaGlicosiladaRes').allowBlank = true;
                                                    Ext.getCmp('fecPROGESPEHemoglobinaGlicosilada').setValue(null);
                                                    Ext.getCmp('strPROGESPEHemoglobinaGlicosiladaRes').setValue(null);
                                                    Ext.getCmp('fecPROGESPEHemoglobinaGlicosilada').disable();
                                                    Ext.getCmp('strPROGESPEHemoglobinaGlicosiladaRes').disable();
                                                    Ext.getCmp('fecPROGESPEHemoglobinaGlicosilada').clearInvalid();
                                                    Ext.getCmp('strPROGESPEHemoglobinaGlicosiladaRes').clearInvalid();
                                                }else{
                                                    Ext.getCmp('fecPROGESPEHemoglobinaGlicosilada').enable();
                                                    Ext.getCmp('strPROGESPEHemoglobinaGlicosiladaRes').enable();
                                                    Ext.getCmp('fecPROGESPEHemoglobinaGlicosilada').allowBlank = false;
                                                    Ext.getCmp('strPROGESPEHemoglobinaGlicosiladaRes').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html:'Fecha:'
                                    },
                                    {
                                        xtype: 'datefield',
                                        width: 120,
                                        name: 'Fecha',
                                        allowBlank: true,
                                        disabled: true,
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        id: 'fecPROGESPEHemoglobinaGlicosilada'
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Resultado Hb Glicosilada',
                                        emptyText: 'Rango 5 - 20',
                                        width: 110,
                                        decimalPrecision: 0,
                                        allowBlank: true,
                                        disabled: true,
                                        id: 'strPROGESPEHemoglobinaGlicosiladaRes'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {   
                                        xtype: 'combo',
                                        fieldLabel: 'Glicemia',
                                        name: 'Glicemia',
                                        width: 60,
                                        allowBlank: false,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPROGESPETraeGlicemia',
                                        listeners:{
                                            change : function( t, newValue, oldValue){
                                                if(newValue == "NO"){
                                                    Ext.getCmp('fecPROGESPEGlicemia').allowBlank = true;
                                                    Ext.getCmp('strPROGESPEGlicemiaRes').allowBlank = true;
                                                    Ext.getCmp('fecPROGESPEGlicemia').setValue(null);
                                                    Ext.getCmp('strPROGESPEGlicemiaRes').setValue(null);
                                                    Ext.getCmp('fecPROGESPEGlicemia').disable();
                                                    Ext.getCmp('strPROGESPEGlicemiaRes').disable();
                                                    Ext.getCmp('fecPROGESPEGlicemia').clearInvalid();
                                                    Ext.getCmp('strPROGESPEGlicemiaRes').clearInvalid();
                                                }else{
                                                    Ext.getCmp('fecPROGESPEGlicemia').enable();
                                                    Ext.getCmp('strPROGESPEGlicemiaRes').enable();
                                                    Ext.getCmp('fecPROGESPEGlicemia').allowBlank = false;
                                                    Ext.getCmp('strPROGESPEGlicemiaRes').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html:'Fecha:'
                                    },
                                    {
                                        xtype: 'datefield',
                                        width: 120,
                                        name: 'Fecha',
                                        allowBlank: true,
                                        disabled: true,
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        id: 'fecPROGESPEGlicemia'
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Resultado Glicemia',
                                        emptyText: 'Rango 20 - 1000',
                                        width: 110,
                                        decimalPrecision: 0,
                                        allowBlank: true,
                                        disabled: true,
                                        id: 'strPROGESPEGlicemiaRes'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {   
                                        xtype: 'combo',
                                        fieldLabel: 'Micro Albuminuria',
                                        name: 'Micro Albuminuria',
                                        width: 60,
                                        allowBlank: false,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPROGESPETraeMicroAlbuminuria',
                                        listeners:{
                                            change : function( t, newValue, oldValue){
                                                if(newValue == "NO"){
                                                    Ext.getCmp('fecPROGESPEMicroAlbuminuria').allowBlank = true;
                                                    Ext.getCmp('strPROGESPEMicroAlbuminuriaRes').allowBlank = true;
                                                    Ext.getCmp('fecPROGESPEMicroAlbuminuria').setValue(null);
                                                    Ext.getCmp('strPROGESPEMicroAlbuminuriaRes').setValue(null);
                                                    Ext.getCmp('fecPROGESPEMicroAlbuminuria').disable();
                                                    Ext.getCmp('strPROGESPEMicroAlbuminuriaRes').disable();
                                                    Ext.getCmp('fecPROGESPEMicroAlbuminuria').clearInvalid();
                                                    Ext.getCmp('strPROGESPEMicroAlbuminuriaRes').clearInvalid();
                                                }else{
                                                    Ext.getCmp('fecPROGESPEMicroAlbuminuria').enable();
                                                    Ext.getCmp('strPROGESPEMicroAlbuminuriaRes').enable();
                                                    Ext.getCmp('fecPROGESPEMicroAlbuminuria').allowBlank = false;
                                                    Ext.getCmp('strPROGESPEMicroAlbuminuriaRes').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html:'Fecha:'
                                    },
                                    {
                                        xtype: 'datefield',
                                        width: 120,
                                        name: 'Fecha',
                                        allowBlank: true,
                                        disabled: true,
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        id: 'fecPROGESPEMicroAlbuminuria'
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Resultado Micro Albuminuria',
                                        emptyText: 'Rango 0 - 700',
                                        width: 110,
                                        decimalPrecision: 0,
                                        allowBlank: true,
                                        disabled: true,
                                        id: 'strPROGESPEMicroAlbuminuriaRes'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {   
                                        xtype: 'combo',
                                        fieldLabel: 'Urea',
                                        name: 'Urea',
                                        width: 60,
                                        allowBlank: false,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPROGESPETraeUrea',
                                        listeners:{
                                            change : function( t, newValue, oldValue){
                                                if(newValue == "NO"){
                                                    Ext.getCmp('fecPROGESPEUrea').allowBlank = true;
                                                    Ext.getCmp('strPROGESPEUreaRes').allowBlank = true;
                                                    Ext.getCmp('fecPROGESPEUrea').setValue(null);
                                                    Ext.getCmp('strPROGESPEUreaRes').setValue(null);
                                                    Ext.getCmp('fecPROGESPEUrea').disable();
                                                    Ext.getCmp('strPROGESPEUreaRes').disable();
                                                    Ext.getCmp('fecPROGESPEUrea').clearInvalid();
                                                    Ext.getCmp('strPROGESPEUreaRes').clearInvalid();
                                                }else{
                                                    Ext.getCmp('fecPROGESPEUrea').enable();
                                                    Ext.getCmp('strPROGESPEUreaRes').enable();
                                                    Ext.getCmp('fecPROGESPEUrea').allowBlank = false;
                                                    Ext.getCmp('strPROGESPEUreaRes').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html:'Fecha:'
                                    },
                                    {
                                        xtype: 'datefield',
                                        width: 120,
                                        name: 'Fecha',
                                        allowBlank: true,
                                        disabled: true,
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        id: 'fecPROGESPEUrea'
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Resultado Urea',
                                        emptyText: 'Resultado',
                                        width: 110,
                                        decimalPrecision: 0,
                                        allowBlank: true,
                                        disabled: true,
                                        id: 'strPROGESPEUreaRes'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {   
                                        xtype: 'combo',
                                        fieldLabel: 'Creatinina',
                                        name: 'Creatinina',
                                        width: 60,
                                        allowBlank: false,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPROGESPETraeCreatinina',
                                        listeners:{
                                            change : function( t, newValue, oldValue){
                                                if(newValue == "NO"){
                                                    Ext.getCmp('fecPROGESPECreatinina').allowBlank = true;
                                                    Ext.getCmp('strPROGESPECreatininaRes').allowBlank = true;
                                                    Ext.getCmp('fecPROGESPECreatinina').setValue(null);
                                                    Ext.getCmp('strPROGESPECreatininaRes').setValue(null);
                                                    Ext.getCmp('fecPROGESPECreatinina').disable();
                                                    Ext.getCmp('strPROGESPECreatininaRes').disable();
                                                    Ext.getCmp('fecPROGESPECreatinina').clearInvalid();
                                                    Ext.getCmp('strPROGESPECreatininaRes').clearInvalid();
                                                }else{
                                                    Ext.getCmp('fecPROGESPECreatinina').enable();
                                                    Ext.getCmp('strPROGESPECreatininaRes').enable();
                                                    Ext.getCmp('fecPROGESPECreatinina').allowBlank = false;
                                                    Ext.getCmp('strPROGESPECreatininaRes').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html:'Fecha:'
                                    },
                                    {
                                        xtype: 'datefield',
                                        width: 120,
                                        name: 'Fecha',
                                        allowBlank: true,
                                        disabled: true,
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        id: 'fecPROGESPECreatinina'
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Resultado Creatinina',
                                        emptyText: 'Rango 0,2 - 25',
                                        width: 110,
                                        decimalPrecision: 2,
                                        allowBlank: true,
                                        disabled: true,
                                        id: 'strPROGESPECreatininaRes',
                                        listeners:{
                                            change : function(f,pNew, pOld){
                                                if(pNew === null || pNew === 0){
                                                    Ext.getCmp('intPROGESPETFGIngreso').setValue(null);
                                                    Ext.getCmp('strPROGESPETFGIngresoCalsifica').setValue(null);
                                                }else{
                                                    // CALCULO TFG
                                                    if((Ext.getCmp('sysFechaHC').getValue() !== "" && Ext.getCmp('sysFechaNac').getValue() !== "" && Ext.getCmp('sysFechaHC').getValue() !== null && Ext.getCmp('sysFechaNac').getValue() !== null)){
                                                        var pFec1 = Ext.getCmp('sysFechaHC').getValue();
                                                        var pFec2Anio = Ext.getCmp('sysFechaNac').getValue().substr(6,4);
                                                        var pFec2Mes = Ext.getCmp('sysFechaNac').getValue().substr(3,2);
                                                        if(pFec2Mes.length===1){
                                                            pFec2Mes = "0" + pFec2Mes;
                                                        }
                                                        var pFec2Dia = Ext.getCmp('sysFechaNac').getValue().substr(0,2);
                                                        if(pFec2Dia.length===1){
                                                            pFec2Dia = "0" + pFec1Dia;
                                                        }
                                                        var pFec2 =  pFec2Anio + "/" + pFec2Mes + "/" + pFec2Dia;
                                                        var AniosCumplidos = MostrarEdadAnios(pFec1, pFec2);
                                                        var ResTFG = ((140 - AniosCumplidos) * Ext.getCmp('intEXAFISPeso').getValue()) / (72 * Ext.getCmp('strPROGESPECreatininaRes').getValue());
                                                        if(Ext.getCmp('sysGeneroHC').getValue().substr(0,1) === "F"){
                                                            ResTFG = ResTFG * 0.85;
                                                        }
                                                        Ext.getCmp('intPROGESPETFGIngreso').setValue(ResTFG);
                                                        if(ResTFG < 15){
                                                            Ext.getCmp('strPROGESPETFGIngresoCalsifica').setValue("Estadio V");
                                                        }else{
                                                            if(ResTFG < 30){
                                                                Ext.getCmp('strPROGESPETFGIngresoCalsifica').setValue("Estadio IV");
                                                            }else{
                                                                if(ResTFG < 60){
                                                                    Ext.getCmp('strPROGESPETFGIngresoCalsifica').setValue("Estadio III");
                                                                }else{
                                                                    if(ResTFG < 90){
                                                                        Ext.getCmp('strPROGESPETFGIngresoCalsifica').setValue("Estadio II");
                                                                    }else{
                                                                        Ext.getCmp('strPROGESPETFGIngresoCalsifica').setValue("Estadio I");
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                ]
                            },
                            {
                                xtype: 'numberfield',
                                name: 'T.F.G Ingreso',
                                fieldLabel: 'T.F.G Ingreso',
                                emptyText: 'Resultado',
                                width: 110,
                                decimalPrecision: 2,
                                allowBlank: true,
                                id: 'intPROGESPETFGIngreso'
                            },
                            {
                                xtype: 'textfield',
                                width: 100,
                                allowBlank: true,
                                readOnly: true,
                                name: 'TFG CLASIFICACION',
                                id: 'strPROGESPETFGIngresoCalsifica'
                            }
                        ]
                    },                                                 
                    {
                        xtype: 'fieldset',
                        title: 'Examenes Anteriores',
                        layout: 'form',
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        anchor: '100%',
                        autoHeight: true,
                        padding: 5,
                        id: 'fsProgramaEspecialesExamAnteriores',
                        items: [
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {   
                                        xtype: 'combo',
                                        fieldLabel: 'Parcial de Orina',
                                        name: 'Parcial de Orina',
                                        width: 60,
                                        allowBlank: false,
                                        readOnly: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPROGESPEAnteriorTraeParcialorina',
                                        listeners:{
                                            change : function( t, newValue, oldValue){
                                                if(newValue == "NO"){
                                                    Ext.getCmp('fecPROGESPEAnteriorParcialorina').allowBlank = true;
                                                    Ext.getCmp('strPROGESPEAnteriorParcialorinaRes').allowBlank = true;
                                                    Ext.getCmp('fecPROGESPEAnteriorParcialorina').setValue(null);
                                                    Ext.getCmp('strPROGESPEAnteriorParcialorinaRes').setValue(null);
                                                    Ext.getCmp('fecPROGESPEAnteriorParcialorina').disable();
                                                    Ext.getCmp('strPROGESPEAnteriorParcialorinaRes').disable();
                                                    Ext.getCmp('fecPROGESPEAnteriorParcialorina').clearInvalid();
                                                    Ext.getCmp('strPROGESPEAnteriorParcialorinaRes').clearInvalid();
                                                }else{
                                                    Ext.getCmp('fecPROGESPEAnteriorParcialorina').enable();
                                                    Ext.getCmp('strPROGESPEAnteriorParcialorinaRes').enable();
                                                    Ext.getCmp('fecPROGESPEAnteriorParcialorina').allowBlank = false;
                                                    Ext.getCmp('strPROGESPEAnteriorParcialorinaRes').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html:'Fecha:'
                                    },
                                    {
                                        xtype: 'datefield',
                                        width: 120,
                                        name: 'Fecha',
                                        allowBlank: true,
                                        disabled: true,
                                        readOnly: true,
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        id: 'fecPROGESPEAnteriorParcialorina'
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 400,
                                        name: 'Resultado Pacial Orina',
                                        emptyText: 'Resultado',
                                        disabled: true,
                                        readOnly: true,
                                        allowBlank: false,
                                        id: 'strPROGESPEAnteriorParcialorinaRes'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {   
                                        xtype: 'combo',
                                        fieldLabel: 'Colesterol Total',
                                        name: 'Colesterol Total',
                                        width: 60,
                                        allowBlank: false,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        readOnly: true,
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPROGESPEAnteriorTraeColesterolTotal',
                                        listeners:{
                                            change : function( t, newValue, oldValue){
                                                if(newValue == "NO"){
                                                    Ext.getCmp('fecPROGESPEAnteriorColesterolTotal').allowBlank = true;
                                                    Ext.getCmp('strPROGESPEAnteriorColesterolTotalRes').allowBlank = true;
                                                    Ext.getCmp('fecPROGESPEAnteriorColesterolTotal').setValue(null);
                                                    Ext.getCmp('strPROGESPEAnteriorColesterolTotalRes').setValue(null);
                                                    Ext.getCmp('fecPROGESPEAnteriorColesterolTotal').disable();
                                                    Ext.getCmp('strPROGESPEAnteriorColesterolTotalRes').disable();
                                                    Ext.getCmp('fecPROGESPEAnteriorColesterolTotal').clearInvalid();
                                                    Ext.getCmp('strPROGESPEAnteriorColesterolTotalRes').clearInvalid();
                                                }else{
                                                    Ext.getCmp('fecPROGESPEAnteriorColesterolTotal').enable();
                                                    Ext.getCmp('strPROGESPEAnteriorColesterolTotalRes').enable();
                                                    Ext.getCmp('fecPROGESPEAnteriorColesterolTotal').allowBlank = false;
                                                    Ext.getCmp('strPROGESPEAnteriorColesterolTotalRes').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html:'Fecha:'
                                    },
                                    {
                                        xtype: 'datefield',
                                        width: 120,
                                        name: 'Fecha',
                                        allowBlank: true,
                                        readOnly: true,
                                        disabled: true,
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        id: 'fecPROGESPEAnteriorColesterolTotal'
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Resultado Colesterol Total',
                                        emptyText: 'Rango 20 - 700',
                                        width: 110,
                                        decimalPrecision: 0,
                                        allowBlank: true,
                                        disabled: true,
                                        id: 'strPROGESPEAnteriorColesterolTotalRes'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {   
                                        xtype: 'combo',
                                        fieldLabel: 'Colesterol HDL',
                                        name: 'Colesterol HDL',
                                        width: 60,
                                        allowBlank: false,
                                        readOnly: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPROGESPEAnteriorTraeColesterolHDL',
                                        listeners:{
                                            change : function( t, newValue, oldValue){
                                                if(newValue == "NO"){
                                                    Ext.getCmp('fecPROGESPEAnteriorColesterolHDL').allowBlank = true;
                                                    Ext.getCmp('strPROGESPEAnteriorColesterolHDLRes').allowBlank = true;
                                                    Ext.getCmp('fecPROGESPEAnteriorColesterolHDL').setValue(null);
                                                    Ext.getCmp('strPROGESPEAnteriorColesterolHDLRes').setValue(null);
                                                    Ext.getCmp('fecPROGESPEAnteriorColesterolHDL').disable();
                                                    Ext.getCmp('strPROGESPEAnteriorColesterolHDLRes').disable();
                                                    Ext.getCmp('fecPROGESPEAnteriorColesterolHDL').clearInvalid();
                                                    Ext.getCmp('strPROGESPEAnteriorColesterolHDLRes').clearInvalid();
                                                }else{
                                                    Ext.getCmp('fecPROGESPEAnteriorColesterolHDL').enable();
                                                    Ext.getCmp('strPROGESPEAnteriorColesterolHDLRes').enable();
                                                    Ext.getCmp('fecPROGESPEAnteriorColesterolHDL').allowBlank = false;
                                                    Ext.getCmp('strPROGESPEAnteriorColesterolHDLRes').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html:'Fecha:'
                                    },
                                    {
                                        xtype: 'datefield',
                                        width: 120,
                                        name: 'Fecha',
                                        allowBlank: true,
                                        readOnly: true,
                                        disabled: true,
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        id: 'fecPROGESPEAnteriorColesterolHDL'
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Resultado Colesterol HDL',
                                        emptyText: 'Rango 10 - 500',
                                        width: 110,
                                        decimalPrecision: 0,
                                        allowBlank: true,
                                        disabled: true,
                                        id: 'strPROGESPEAnteriorColesterolHDLRes'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {   
                                        xtype: 'combo',
                                        fieldLabel: 'Colesterol LDL',
                                        name: 'Colesterol LDL',
                                        width: 60,
                                        allowBlank: false,
                                        readOnly: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPROGESPEAnteriorTraeColesterolLDL',
                                        listeners:{
                                            change : function( t, newValue, oldValue){
                                                if(newValue == "NO"){
                                                    Ext.getCmp('fecPROGESPEAnteriorColesterolLDL').allowBlank = true;
                                                    Ext.getCmp('strPROGESPEAnteriorColesterolLDLRes').allowBlank = true;
                                                    Ext.getCmp('fecPROGESPEAnteriorColesterolLDL').setValue(null);
                                                    Ext.getCmp('strPROGESPEAnteriorColesterolLDLRes').setValue(null);
                                                    Ext.getCmp('fecPROGESPEAnteriorColesterolLDL').disable();
                                                    Ext.getCmp('strPROGESPEAnteriorColesterolLDLRes').disable();
                                                    Ext.getCmp('fecPROGESPEAnteriorColesterolLDL').clearInvalid();
                                                    Ext.getCmp('strPROGESPEAnteriorColesterolLDLRes').clearInvalid();
                                                }else{
                                                    Ext.getCmp('fecPROGESPEAnteriorColesterolLDL').enable();
                                                    Ext.getCmp('strPROGESPEAnteriorColesterolLDLRes').enable();
                                                    Ext.getCmp('fecPROGESPEAnteriorColesterolLDL').allowBlank = false;
                                                    Ext.getCmp('strPROGESPEAnteriorColesterolLDLRes').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html:'Fecha:'
                                    },
                                    {
                                        xtype: 'datefield',
                                        width: 120,
                                        name: 'Fecha',
                                        allowBlank: true,
                                        readOnly: true,
                                        disabled: true,
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        id: 'fecPROGESPEAnteriorColesterolLDL'
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Resultado Colesterol LDL',
                                        emptyText: 'Rango 10 - 500',
                                        width: 110,
                                        decimalPrecision: 0,
                                        allowBlank: true,
                                        readOnly: true,
                                        disabled: true,
                                        id: 'strPROGESPEAnteriorColesterolLDLRes'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {   
                                        xtype: 'combo',
                                        fieldLabel: 'Trigliceridos',
                                        name: 'Trigliceridos',
                                        width: 60,
                                        allowBlank: false,
                                        readOnly: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPROGESPEAnteriorTraeTrigliceridos',
                                        listeners:{
                                            change : function( t, newValue, oldValue){
                                                if(newValue == "NO"){
                                                    Ext.getCmp('fecPROGESPEAnteriorTrigliceridos').allowBlank = true;
                                                    Ext.getCmp('strPROGESPEAnteriorTrigliceridosRes').allowBlank = true;
                                                    Ext.getCmp('fecPROGESPEAnteriorTrigliceridos').setValue(null);
                                                    Ext.getCmp('strPROGESPEAnteriorTrigliceridosRes').setValue(null);
                                                    Ext.getCmp('fecPROGESPEAnteriorTrigliceridos').disable();
                                                    Ext.getCmp('strPROGESPEAnteriorTrigliceridosRes').disable();
                                                    Ext.getCmp('fecPROGESPEAnteriorTrigliceridos').clearInvalid();
                                                    Ext.getCmp('strPROGESPEAnteriorTrigliceridosRes').clearInvalid();
                                                }else{
                                                    Ext.getCmp('fecPROGESPEAnteriorTrigliceridos').enable();
                                                    Ext.getCmp('strPROGESPEAnteriorTrigliceridosRes').enable();
                                                    Ext.getCmp('fecPROGESPEAnteriorTrigliceridos').allowBlank = false;
                                                    Ext.getCmp('strPROGESPEAnteriorTrigliceridosRes').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html:'Fecha:'
                                    },
                                    {
                                        xtype: 'datefield',
                                        width: 120,
                                        name: 'Fecha',
                                        allowBlank: true,
                                        readOnly: true,
                                        disabled: true,
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        id: 'fecPROGESPEAnteriorTrigliceridos'
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Resultado Trigliceridos',
                                        emptyText: 'Rango 20 - 1000',
                                        width: 110,
                                        decimalPrecision: 0,
                                        allowBlank: true,
                                        disabled: true,
                                        id: 'strPROGESPEAnteriorTrigliceridosRes'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {   
                                        xtype: 'combo',
                                        fieldLabel: 'Hb Glicosilada',
                                        name: 'Hb Glicosilada',
                                        width: 60,
                                        allowBlank: false,
                                        readOnly: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPROGESPEAnteriorTraeHemoglobinaGlicosilada',
                                        listeners:{
                                            change : function( t, newValue, oldValue){
                                                if(newValue == "NO"){
                                                    Ext.getCmp('fecPROGESPEAnteriorHemoglobinaGlicosilada').allowBlank = true;
                                                    Ext.getCmp('strPROGESPEAnteriorHemoglobinaGlicosiladaRes').allowBlank = true;
                                                    Ext.getCmp('fecPROGESPEAnteriorHemoglobinaGlicosilada').setValue(null);
                                                    Ext.getCmp('strPROGESPEAnteriorHemoglobinaGlicosiladaRes').setValue(null);
                                                    Ext.getCmp('fecPROGESPEAnteriorHemoglobinaGlicosilada').disable();
                                                    Ext.getCmp('strPROGESPEAnteriorHemoglobinaGlicosiladaRes').disable();
                                                    Ext.getCmp('fecPROGESPEAnteriorHemoglobinaGlicosilada').clearInvalid();
                                                    Ext.getCmp('strPROGESPEAnteriorHemoglobinaGlicosiladaRes').clearInvalid();
                                                }else{
                                                    Ext.getCmp('fecPROGESPEAnteriorHemoglobinaGlicosilada').enable();
                                                    Ext.getCmp('strPROGESPEAnteriorHemoglobinaGlicosiladaRes').enable();
                                                    Ext.getCmp('fecPROGESPEAnteriorHemoglobinaGlicosilada').allowBlank = false;
                                                    Ext.getCmp('strPROGESPEAnteriorHemoglobinaGlicosiladaRes').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html:'Fecha:'
                                    },
                                    {
                                        xtype: 'datefield',
                                        width: 120,
                                        name: 'Fecha',
                                        allowBlank: true,
                                        readOnly: true,
                                        disabled: true,
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        id: 'fecPROGESPEAnteriorHemoglobinaGlicosilada'
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Resultado Hb Glicosilada',
                                        emptyText: 'Rango 5 - 20',
                                        width: 110,
                                        decimalPrecision: 0,
                                        allowBlank: true,
                                        readOnly: true,
                                        disabled: true,
                                        id: 'strPROGESPEAnteriorHemoglobinaGlicosiladaRes'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {   
                                        xtype: 'combo',
                                        fieldLabel: 'Glicemia',
                                        name: 'Glicemia',
                                        width: 60,
                                        allowBlank: false,
                                        readOnly: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPROGESPEAnteriorTraeGlicemia',
                                        listeners:{
                                            change : function( t, newValue, oldValue){
                                                if(newValue == "NO"){
                                                    Ext.getCmp('fecPROGESPEAnteriorGlicemia').allowBlank = true;
                                                    Ext.getCmp('strPROGESPEAnteriorGlicemiaRes').allowBlank = true;
                                                    Ext.getCmp('fecPROGESPEAnteriorGlicemia').setValue(null);
                                                    Ext.getCmp('strPROGESPEAnteriorGlicemiaRes').setValue(null);
                                                    Ext.getCmp('fecPROGESPEAnteriorGlicemia').disable();
                                                    Ext.getCmp('strPROGESPEAnteriorGlicemiaRes').disable();
                                                    Ext.getCmp('fecPROGESPEAnteriorGlicemia').clearInvalid();
                                                    Ext.getCmp('strPROGESPEAnteriorGlicemiaRes').clearInvalid();
                                                }else{
                                                    Ext.getCmp('fecPROGESPEAnteriorGlicemia').enable();
                                                    Ext.getCmp('strPROGESPEAnteriorGlicemiaRes').enable();
                                                    Ext.getCmp('fecPROGESPEAnteriorGlicemia').allowBlank = false;
                                                    Ext.getCmp('strPROGESPEAnteriorGlicemiaRes').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html:'Fecha:'
                                    },
                                    {
                                        xtype: 'datefield',
                                        width: 120,
                                        name: 'Fecha',
                                        allowBlank: true,
                                        readOnly: true,
                                        disabled: true,
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        id: 'fecPROGESPEAnteriorGlicemia'
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Resultado Glicemia',
                                        emptyText: 'Rango 20 - 1000',
                                        width: 110,
                                        decimalPrecision: 0,
                                        allowBlank: true,
                                        readOnly: true,
                                        disabled: true,
                                        id: 'strPROGESPEAnteriorGlicemiaRes'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {   
                                        xtype: 'combo',
                                        fieldLabel: 'Micro Albuminuria',
                                        name: 'Micro Albuminuria',
                                        width: 60,
                                        allowBlank: false,
                                        readOnly: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPROGESPEAnteriorTraeMicroAlbuminuria',
                                        listeners:{
                                            change : function( t, newValue, oldValue){
                                                if(newValue == "NO"){
                                                    Ext.getCmp('fecPROGESPEAnteriorMicroAlbuminuria').allowBlank = true;
                                                    Ext.getCmp('strPROGESPEAnteriorMicroAlbuminuriaRes').allowBlank = true;
                                                    Ext.getCmp('fecPROGESPEAnteriorMicroAlbuminuria').setValue(null);
                                                    Ext.getCmp('strPROGESPEAnteriorMicroAlbuminuriaRes').setValue(null);
                                                    Ext.getCmp('fecPROGESPEAnteriorMicroAlbuminuria').disable();
                                                    Ext.getCmp('strPROGESPEAnteriorMicroAlbuminuriaRes').disable();
                                                    Ext.getCmp('fecPROGESPEAnteriorMicroAlbuminuria').clearInvalid();
                                                    Ext.getCmp('strPROGESPEAnteriorMicroAlbuminuriaRes').clearInvalid();
                                                }else{
                                                    Ext.getCmp('fecPROGESPEAnteriorMicroAlbuminuria').enable();
                                                    Ext.getCmp('strPROGESPEAnteriorMicroAlbuminuriaRes').enable();
                                                    Ext.getCmp('fecPROGESPEAnteriorMicroAlbuminuria').allowBlank = false;
                                                    Ext.getCmp('strPROGESPEAnteriorMicroAlbuminuriaRes').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html:'Fecha:'
                                    },
                                    {
                                        xtype: 'datefield',
                                        width: 120,
                                        name: 'Fecha',
                                        allowBlank: true,
                                        readOnly: true,
                                        disabled: true,
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        id: 'fecPROGESPEAnteriorMicroAlbuminuria'
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Resultado Micro Albuminuria',
                                        emptyText: 'Rango 0 - 700',
                                        width: 110,
                                        decimalPrecision: 0,
                                        allowBlank: true,
                                        readOnly: true,
                                        disabled: true,
                                        id: 'strPROGESPEAnteriorMicroAlbuminuriaRes'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {   
                                        xtype: 'combo',
                                        fieldLabel: 'Urea',
                                        name: 'Urea',
                                        width: 60,
                                        allowBlank: false,
                                        readOnly: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPROGESPEAnteriorTraeUrea',
                                        listeners:{
                                            change : function( t, newValue, oldValue){
                                                if(newValue == "NO"){
                                                    Ext.getCmp('fecPROGESPEAnteriorUrea').allowBlank = true;
                                                    Ext.getCmp('strPROGESPEAnteriorUreaRes').allowBlank = true;
                                                    Ext.getCmp('fecPROGESPEAnteriorUrea').setValue(null);
                                                    Ext.getCmp('strPROGESPEAnteriorUreaRes').setValue(null);
                                                    Ext.getCmp('fecPROGESPEAnteriorUrea').disable();
                                                    Ext.getCmp('strPROGESPEAnteriorUreaRes').disable();
                                                    Ext.getCmp('fecPROGESPEAnteriorUrea').clearInvalid();
                                                    Ext.getCmp('strPROGESPEAnteriorUreaRes').clearInvalid();
                                                }else{
                                                    Ext.getCmp('fecPROGESPEAnteriorUrea').enable();
                                                    Ext.getCmp('strPROGESPEAnteriorUreaRes').enable();
                                                    Ext.getCmp('fecPROGESPEAnteriorUrea').allowBlank = false;
                                                    Ext.getCmp('strPROGESPEAnteriorUreaRes').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html:'Fecha:'
                                    },
                                    {
                                        xtype: 'datefield',
                                        width: 120,
                                        name: 'Fecha',
                                        allowBlank: true,
                                        readOnly: true,
                                        disabled: true,
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        id: 'fecPROGESPEAnteriorUrea'
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Resultado Urea',
                                        emptyText: 'Resultado',
                                        width: 110,
                                        decimalPrecision: 0,
                                        allowBlank: true,
                                        readOnly: true,
                                        disabled: true,
                                        id: 'strPROGESPEAnteriorUreaRes'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {   
                                        xtype: 'combo',
                                        fieldLabel: 'Creatinina',
                                        name: 'Creatinina',
                                        width: 60,
                                        allowBlank: false,
                                        readOnly: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPROGESPEAnteriorTraeCreatinina',
                                        listeners:{
                                            change : function( t, newValue, oldValue){
                                                if(newValue == "NO"){
                                                    Ext.getCmp('fecPROGESPEAnteriorCreatinina').allowBlank = true;
                                                    Ext.getCmp('strPROGESPEAnteriorCreatininaRes').allowBlank = true;
                                                    Ext.getCmp('fecPROGESPEAnteriorCreatinina').setValue(null);
                                                    Ext.getCmp('strPROGESPEAnteriorCreatininaRes').setValue(null);
                                                    Ext.getCmp('fecPROGESPEAnteriorCreatinina').disable();
                                                    Ext.getCmp('strPROGESPEAnteriorCreatininaRes').disable();
                                                    Ext.getCmp('fecPROGESPEAnteriorCreatinina').clearInvalid();
                                                    Ext.getCmp('strPROGESPEAnteriorCreatininaRes').clearInvalid();
                                                }else{
                                                    Ext.getCmp('fecPROGESPEAnteriorCreatinina').enable();
                                                    Ext.getCmp('strPROGESPEAnteriorCreatininaRes').enable();
                                                    Ext.getCmp('fecPROGESPEAnteriorCreatinina').allowBlank = false;
                                                    Ext.getCmp('strPROGESPEAnteriorCreatininaRes').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html:'Fecha:'
                                    },
                                    {
                                        xtype: 'datefield',
                                        width: 120,
                                        name: 'Fecha',
                                        allowBlank: true,
                                        readOnly: true,
                                        disabled: true,
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        id: 'fecPROGESPEAnteriorCreatinina'
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Resultado Creatinina',
                                        emptyText: 'Rango 0,2 - 25',
                                        width: 110,
                                        decimalPrecision: 2,
                                        allowBlank: true,
                                        disabled: true,
                                        id: 'strPROGESPEAnteriorCreatininaRes'
                                    }
                                ]
                            },
                            {
                                xtype: 'numberfield',
                                name: 'T.F.G Anterior',
                                fieldLabel: 'T.F.G Anterior',
                                readOnly: true,
                                emptyText: 'Resultado',
                                width: 110,
                                decimalPrecision: 2,
                                allowBlank: true,
                                id: 'strPROGESPEAnteriorTFG'
                            }
                        ]
                    },
                    {
                        xtype: 'fieldset',
                        title: 'Examenes Seguimiento',
                        layout: 'form',
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        anchor: '100%',
                        autoHeight: true,
                        padding: 5,
                        id: 'fsProgramaEspecialesExamSeguimiento',
                        items: [
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {   
                                        xtype: 'combo',
                                        fieldLabel: 'Parcial de Orina',
                                        name: 'Parcial de Orina',
                                        width: 60,
                                        allowBlank: false,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPROGESPESeguimientoTraeParcialorina',
                                        listeners:{
                                            change : function( t, newValue, oldValue){
                                                if(newValue == "NO"){
                                                    Ext.getCmp('fecPROGESPESeguimientoParcialorina').allowBlank = true;
                                                    Ext.getCmp('strPROGESPESeguimientoParcialorinaRes').allowBlank = true;
                                                    Ext.getCmp('fecPROGESPESeguimientoParcialorina').setValue(null);
                                                    Ext.getCmp('strPROGESPESeguimientoParcialorinaRes').setValue(null);
                                                    Ext.getCmp('fecPROGESPESeguimientoParcialorina').disable();
                                                    Ext.getCmp('strPROGESPESeguimientoParcialorinaRes').disable();
                                                    Ext.getCmp('fecPROGESPESeguimientoParcialorina').clearInvalid();
                                                    Ext.getCmp('strPROGESPESeguimientoParcialorinaRes').clearInvalid();
                                                }else{
                                                    Ext.getCmp('fecPROGESPESeguimientoParcialorina').enable();
                                                    Ext.getCmp('strPROGESPESeguimientoParcialorinaRes').enable();
                                                    Ext.getCmp('fecPROGESPESeguimientoParcialorina').allowBlank = false;
                                                    Ext.getCmp('strPROGESPESeguimientoParcialorinaRes').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html:'Fecha:'
                                    },
                                    {
                                        xtype: 'datefield',
                                        width: 120,
                                        name: 'Fecha',
                                        allowBlank: true,
                                        disabled: true,
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        id: 'fecPROGESPESeguimientoParcialorina'
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 400,
                                        name: 'Resultado Pacial Orina',
                                        emptyText: 'Resultado',
                                        disabled: true,
                                        allowBlank: false,
                                        id: 'strPROGESPESeguimientoParcialorinaRes'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {   
                                        xtype: 'combo',
                                        fieldLabel: 'Colesterol Total',
                                        name: 'Colesterol Total',
                                        width: 60,
                                        allowBlank: false,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPROGESPESeguimientoTraeColesterolTotal',
                                        listeners:{
                                            change : function( t, newValue, oldValue){
                                                if(newValue == "NO"){
                                                    Ext.getCmp('fecPROGESPESeguimientoColesterolTotal').allowBlank = true;
                                                    Ext.getCmp('strPROGESPESeguimientoColesterolTotalRes').allowBlank = true;
                                                    Ext.getCmp('fecPROGESPESeguimientoColesterolTotal').setValue(null);
                                                    Ext.getCmp('strPROGESPESeguimientoColesterolTotalRes').setValue(null);
                                                    Ext.getCmp('fecPROGESPESeguimientoColesterolTotal').disable();
                                                    Ext.getCmp('strPROGESPESeguimientoColesterolTotalRes').disable();
                                                    Ext.getCmp('fecPROGESPESeguimientoColesterolTotal').clearInvalid();
                                                    Ext.getCmp('strPROGESPESeguimientoColesterolTotalRes').clearInvalid();
                                                }else{
                                                    Ext.getCmp('fecPROGESPESeguimientoColesterolTotal').enable();
                                                    Ext.getCmp('strPROGESPESeguimientoColesterolTotalRes').enable();
                                                    Ext.getCmp('fecPROGESPESeguimientoColesterolTotal').allowBlank = false;
                                                    Ext.getCmp('strPROGESPESeguimientoColesterolTotalRes').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html:'Fecha:'
                                    },
                                    {
                                        xtype: 'datefield',
                                        width: 120,
                                        name: 'Fecha',
                                        allowBlank: true,
                                        disabled: true,
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        id: 'fecPROGESPESeguimientoColesterolTotal'
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Resultado Colesterol Total',
                                        emptyText: 'Rango 20 - 700',
                                        width: 110,
                                        decimalPrecision: 0,
                                        allowBlank: true,
                                        disabled: true,
                                        id: 'strPROGESPESeguimientoColesterolTotalRes'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {   
                                        xtype: 'combo',
                                        fieldLabel: 'Colesterol HDL',
                                        name: 'Colesterol HDL',
                                        width: 60,
                                        allowBlank: false,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPROGESPESeguimientoTraeColesterolHDL',
                                        listeners:{
                                            change : function( t, newValue, oldValue){
                                                if(newValue == "NO"){
                                                    Ext.getCmp('fecPROGESPESeguimientoColesterolHDL').allowBlank = true;
                                                    Ext.getCmp('strPROGESPESeguimientoColesterolHDLRes').allowBlank = true;
                                                    Ext.getCmp('fecPROGESPESeguimientoColesterolHDL').setValue(null);
                                                    Ext.getCmp('strPROGESPESeguimientoColesterolHDLRes').setValue(null);
                                                    Ext.getCmp('fecPROGESPESeguimientoColesterolHDL').disable();
                                                    Ext.getCmp('strPROGESPESeguimientoColesterolHDLRes').disable();
                                                    Ext.getCmp('fecPROGESPESeguimientoColesterolHDL').clearInvalid();
                                                    Ext.getCmp('strPROGESPESeguimientoColesterolHDLRes').clearInvalid();
                                                }else{
                                                    Ext.getCmp('fecPROGESPESeguimientoColesterolHDL').enable();
                                                    Ext.getCmp('strPROGESPESeguimientoColesterolHDLRes').enable();
                                                    Ext.getCmp('fecPROGESPESeguimientoColesterolHDL').allowBlank = false;
                                                    Ext.getCmp('strPROGESPESeguimientoColesterolHDLRes').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html:'Fecha:'
                                    },
                                    {
                                        xtype: 'datefield',
                                        width: 120,
                                        name: 'Fecha',
                                        allowBlank: true,
                                        disabled: true,
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        id: 'fecPROGESPESeguimientoColesterolHDL'
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Resultado Colesterol HDL',
                                        emptyText: 'Rango 10 - 500',
                                        width: 110,
                                        decimalPrecision: 0,
                                        allowBlank: true,
                                        disabled: true,
                                        id: 'strPROGESPESeguimientoColesterolHDLRes'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {   
                                        xtype: 'combo',
                                        fieldLabel: 'Colesterol LDL',
                                        name: 'Colesterol LDL',
                                        width: 60,
                                        allowBlank: false,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPROGESPESeguimientoTraeColesterolLDL',
                                        listeners:{
                                            change : function( t, newValue, oldValue){
                                                if(newValue == "NO"){
                                                    Ext.getCmp('fecPROGESPESeguimientoColesterolLDL').allowBlank = true;
                                                    Ext.getCmp('strPROGESPESeguimientoColesterolLDLRes').allowBlank = true;
                                                    Ext.getCmp('fecPROGESPESeguimientoColesterolLDL').setValue(null);
                                                    Ext.getCmp('strPROGESPESeguimientoColesterolLDLRes').setValue(null);
                                                    Ext.getCmp('fecPROGESPESeguimientoColesterolLDL').disable();
                                                    Ext.getCmp('strPROGESPESeguimientoColesterolLDLRes').disable();
                                                    Ext.getCmp('fecPROGESPESeguimientoColesterolLDL').clearInvalid();
                                                    Ext.getCmp('strPROGESPESeguimientoColesterolLDLRes').clearInvalid();
                                                }else{
                                                    Ext.getCmp('fecPROGESPESeguimientoColesterolLDL').enable();
                                                    Ext.getCmp('strPROGESPESeguimientoColesterolLDLRes').enable();
                                                    Ext.getCmp('fecPROGESPESeguimientoColesterolLDL').allowBlank = false;
                                                    Ext.getCmp('strPROGESPESeguimientoColesterolLDLRes').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html:'Fecha:'
                                    },
                                    {
                                        xtype: 'datefield',
                                        width: 120,
                                        name: 'Fecha',
                                        allowBlank: true,
                                        disabled: true,
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        id: 'fecPROGESPESeguimientoColesterolLDL'
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Resultado Colesterol LDL',
                                        emptyText: 'Rango 10 - 500',
                                        width: 110,
                                        decimalPrecision: 0,
                                        allowBlank: true,
                                        disabled: true,
                                        id: 'strPROGESPESeguimientoColesterolLDLRes'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {   
                                        xtype: 'combo',
                                        fieldLabel: 'Trigliceridos',
                                        name: 'Trigliceridos',
                                        width: 60,
                                        allowBlank: false,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPROGESPESeguimientoTraeTrigliceridos',
                                        listeners:{
                                            change : function( t, newValue, oldValue){
                                                if(newValue == "NO"){
                                                    Ext.getCmp('fecPROGESPESeguimientoTrigliceridos').allowBlank = true;
                                                    Ext.getCmp('strPROGESPESeguimientoTrigliceridosRes').allowBlank = true;
                                                    Ext.getCmp('fecPROGESPESeguimientoTrigliceridos').setValue(null);
                                                    Ext.getCmp('strPROGESPESeguimientoTrigliceridosRes').setValue(null);
                                                    Ext.getCmp('fecPROGESPESeguimientoTrigliceridos').disable();
                                                    Ext.getCmp('strPROGESPESeguimientoTrigliceridosRes').disable();
                                                    Ext.getCmp('fecPROGESPESeguimientoTrigliceridos').clearInvalid();
                                                    Ext.getCmp('strPROGESPESeguimientoTrigliceridosRes').clearInvalid();
                                                }else{
                                                    Ext.getCmp('fecPROGESPESeguimientoTrigliceridos').enable();
                                                    Ext.getCmp('strPROGESPESeguimientoTrigliceridosRes').enable();
                                                    Ext.getCmp('fecPROGESPESeguimientoTrigliceridos').allowBlank = false;
                                                    Ext.getCmp('strPROGESPESeguimientoTrigliceridosRes').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html:'Fecha:'
                                    },
                                    {
                                        xtype: 'datefield',
                                        width: 120,
                                        name: 'Fecha',
                                        allowBlank: true,
                                        disabled: true,
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        id: 'fecPROGESPESeguimientoTrigliceridos'
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Resultado Trigliceridos',
                                        emptyText: 'Rango 20 - 1000',
                                        width: 110,
                                        decimalPrecision: 0,
                                        allowBlank: true,
                                        disabled: true,
                                        id: 'strPROGESPESeguimientoTrigliceridosRes'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {   
                                        xtype: 'combo',
                                        fieldLabel: 'Hb Glicosilada',
                                        name: 'Hb Glicosilada',
                                        width: 60,
                                        allowBlank: false,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPROGESPESeguimientoTraeHemoglobinaGlicosilada',
                                        listeners:{
                                            change : function( t, newValue, oldValue){
                                                if(newValue == "NO"){
                                                    Ext.getCmp('fecPROGESPESeguimientoHemoglobinaGlicosilada').allowBlank = true;
                                                    Ext.getCmp('strPROGESPESeguimientoHemoglobinaGlicosiladaRes').allowBlank = true;
                                                    Ext.getCmp('fecPROGESPESeguimientoHemoglobinaGlicosilada').setValue(null);
                                                    Ext.getCmp('strPROGESPESeguimientoHemoglobinaGlicosiladaRes').setValue(null);
                                                    Ext.getCmp('fecPROGESPESeguimientoHemoglobinaGlicosilada').disable();
                                                    Ext.getCmp('strPROGESPESeguimientoHemoglobinaGlicosiladaRes').disable();
                                                    Ext.getCmp('fecPROGESPESeguimientoHemoglobinaGlicosilada').clearInvalid();
                                                    Ext.getCmp('strPROGESPESeguimientoHemoglobinaGlicosiladaRes').clearInvalid();
                                                }else{
                                                    Ext.getCmp('fecPROGESPESeguimientoHemoglobinaGlicosilada').enable();
                                                    Ext.getCmp('strPROGESPESeguimientoHemoglobinaGlicosiladaRes').enable();
                                                    Ext.getCmp('fecPROGESPESeguimientoHemoglobinaGlicosilada').allowBlank = false;
                                                    Ext.getCmp('strPROGESPESeguimientoHemoglobinaGlicosiladaRes').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html:'Fecha:'
                                    },
                                    {
                                        xtype: 'datefield',
                                        width: 120,
                                        name: 'Fecha',
                                        allowBlank: true,
                                        disabled: true,
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        id: 'fecPROGESPESeguimientoHemoglobinaGlicosilada'
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Resultado Hb Glicosilada',
                                        emptyText: 'Rango 5 - 20',
                                        width: 110,
                                        decimalPrecision: 0,
                                        allowBlank: true,
                                        disabled: true,
                                        id: 'strPROGESPESeguimientoHemoglobinaGlicosiladaRes'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {   
                                        xtype: 'combo',
                                        fieldLabel: 'Glicemia',
                                        name: 'Glicemia',
                                        width: 60,
                                        allowBlank: false,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPROGESPESeguimientoTraeGlicemia',
                                        listeners:{
                                            change : function( t, newValue, oldValue){
                                                if(newValue == "NO"){
                                                    Ext.getCmp('fecPROGESPESeguimientoGlicemia').allowBlank = true;
                                                    Ext.getCmp('strPROGESPESeguimientoGlicemiaRes').allowBlank = true;
                                                    Ext.getCmp('fecPROGESPESeguimientoGlicemia').setValue(null);
                                                    Ext.getCmp('strPROGESPESeguimientoGlicemiaRes').setValue(null);
                                                    Ext.getCmp('fecPROGESPESeguimientoGlicemia').disable();
                                                    Ext.getCmp('strPROGESPESeguimientoGlicemiaRes').disable();
                                                    Ext.getCmp('fecPROGESPESeguimientoGlicemia').clearInvalid();
                                                    Ext.getCmp('strPROGESPESeguimientoGlicemiaRes').clearInvalid();
                                                }else{
                                                    Ext.getCmp('fecPROGESPESeguimientoGlicemia').enable();
                                                    Ext.getCmp('strPROGESPESeguimientoGlicemiaRes').enable();
                                                    Ext.getCmp('fecPROGESPESeguimientoGlicemia').allowBlank = false;
                                                    Ext.getCmp('strPROGESPESeguimientoGlicemiaRes').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html:'Fecha:'
                                    },
                                    {
                                        xtype: 'datefield',
                                        width: 120,
                                        name: 'Fecha',
                                        allowBlank: true,
                                        disabled: true,
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        id: 'fecPROGESPESeguimientoGlicemia'
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Resultado Glicemia',
                                        emptyText: 'Rango 20 - 1000',
                                        width: 110,
                                        decimalPrecision: 0,
                                        allowBlank: true,
                                        disabled: true,
                                        id: 'strPROGESPESeguimientoGlicemiaRes'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {   
                                        xtype: 'combo',
                                        fieldLabel: 'Micro Albuminuria',
                                        name: 'Micro Albuminuria',
                                        width: 60,
                                        allowBlank: false,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPROGESPESeguimientoTraeMicroAlbuminuria',
                                        listeners:{
                                            change : function( t, newValue, oldValue){
                                                if(newValue == "NO"){
                                                    Ext.getCmp('fecPROGESPESeguimientoMicroAlbuminuria').allowBlank = true;
                                                    Ext.getCmp('strPROGESPESeguimientoMicroAlbuminuriaRes').allowBlank = true;
                                                    Ext.getCmp('fecPROGESPESeguimientoMicroAlbuminuria').setValue(null);
                                                    Ext.getCmp('strPROGESPESeguimientoMicroAlbuminuriaRes').setValue(null);
                                                    Ext.getCmp('fecPROGESPESeguimientoMicroAlbuminuria').disable();
                                                    Ext.getCmp('strPROGESPESeguimientoMicroAlbuminuriaRes').disable();
                                                    Ext.getCmp('fecPROGESPESeguimientoMicroAlbuminuria').clearInvalid();
                                                    Ext.getCmp('strPROGESPESeguimientoMicroAlbuminuriaRes').clearInvalid();
                                                }else{
                                                    Ext.getCmp('fecPROGESPESeguimientoMicroAlbuminuria').enable();
                                                    Ext.getCmp('strPROGESPESeguimientoMicroAlbuminuriaRes').enable();
                                                    Ext.getCmp('fecPROGESPESeguimientoMicroAlbuminuria').allowBlank = false;
                                                    Ext.getCmp('strPROGESPESeguimientoMicroAlbuminuriaRes').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html:'Fecha:'
                                    },
                                    {
                                        xtype: 'datefield',
                                        width: 120,
                                        name: 'Fecha',
                                        allowBlank: true,
                                        disabled: true,
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        id: 'fecPROGESPESeguimientoMicroAlbuminuria'
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Resultado Micro Albuminuria',
                                        emptyText: 'Rango 0 - 700',
                                        width: 110,
                                        decimalPrecision: 0,
                                        allowBlank: true,
                                        disabled: true,
                                        id: 'strPROGESPESeguimientoMicroAlbuminuriaRes'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {   
                                        xtype: 'combo',
                                        fieldLabel: 'Urea',
                                        name: 'Urea',
                                        width: 60,
                                        allowBlank: false,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPROGESPESeguimientoTraeUrea',
                                        listeners:{
                                            change : function( t, newValue, oldValue){
                                                if(newValue == "NO"){
                                                    Ext.getCmp('fecPROGESPESeguimientoUrea').allowBlank = true;
                                                    Ext.getCmp('strPROGESPESeguimientoUreaRes').allowBlank = true;
                                                    Ext.getCmp('fecPROGESPESeguimientoUrea').setValue(null);
                                                    Ext.getCmp('strPROGESPESeguimientoUreaRes').setValue(null);
                                                    Ext.getCmp('fecPROGESPESeguimientoUrea').disable();
                                                    Ext.getCmp('strPROGESPESeguimientoUreaRes').disable();
                                                    Ext.getCmp('fecPROGESPESeguimientoUrea').clearInvalid();
                                                    Ext.getCmp('strPROGESPESeguimientoUreaRes').clearInvalid();
                                                }else{
                                                    Ext.getCmp('fecPROGESPESeguimientoUrea').enable();
                                                    Ext.getCmp('strPROGESPESeguimientoUreaRes').enable();
                                                    Ext.getCmp('fecPROGESPESeguimientoUrea').allowBlank = false;
                                                    Ext.getCmp('strPROGESPESeguimientoUreaRes').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html:'Fecha:'
                                    },
                                    {
                                        xtype: 'datefield',
                                        width: 120,
                                        name: 'Fecha',
                                        allowBlank: true,
                                        disabled: true,
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        id: 'fecPROGESPESeguimientoUrea'
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Resultado Urea',
                                        emptyText: 'Resultado',
                                        width: 110,
                                        decimalPrecision: 0,
                                        allowBlank: true,
                                        disabled: true,
                                        id: 'strPROGESPESeguimientoUreaRes'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {   
                                        xtype: 'combo',
                                        fieldLabel: 'Creatinina',
                                        name: 'Creatinina',
                                        width: 60,
                                        allowBlank: false,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPROGESPESeguimientoTraeCreatinina',
                                        listeners:{
                                            change : function( t, newValue, oldValue){
                                                if(newValue == "NO"){
                                                    Ext.getCmp('fecPROGESPESeguimientoCreatinina').allowBlank = true;
                                                    Ext.getCmp('strPROGESPESeguimientoCreatininaRes').allowBlank = true;
                                                    Ext.getCmp('fecPROGESPESeguimientoCreatinina').setValue(null);
                                                    Ext.getCmp('strPROGESPESeguimientoCreatininaRes').setValue(null);
                                                    Ext.getCmp('fecPROGESPESeguimientoCreatinina').disable();
                                                    Ext.getCmp('strPROGESPESeguimientoCreatininaRes').disable();
                                                    Ext.getCmp('fecPROGESPESeguimientoCreatinina').clearInvalid();
                                                    Ext.getCmp('strPROGESPESeguimientoCreatininaRes').clearInvalid();
                                                }else{
                                                    Ext.getCmp('fecPROGESPESeguimientoCreatinina').enable();
                                                    Ext.getCmp('strPROGESPESeguimientoCreatininaRes').enable();
                                                    Ext.getCmp('fecPROGESPESeguimientoCreatinina').allowBlank = false;
                                                    Ext.getCmp('strPROGESPESeguimientoCreatininaRes').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html:'Fecha:'
                                    },
                                    {
                                        xtype: 'datefield',
                                        width: 120,
                                        name: 'Fecha',
                                        allowBlank: true,
                                        disabled: true,
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        id: 'fecPROGESPESeguimientoCreatinina'
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Resultado Creatinina',
                                        emptyText: 'Rango 0,2 - 25',
                                        width: 110,
                                        decimalPrecision: 2,
                                        allowBlank: true,
                                        disabled: true,
                                        id: 'strPROGESPESeguimientoCreatininaRes'
                                    }
                                ]
                            },
                            {
                                xtype: 'numberfield',
                                name: 'T.F.G Seguimiento',
                                fieldLabel: 'T.F.G Seguimiento',
                                emptyText: 'Resultado',
                                width: 110,
                                decimalPrecision: 2,
                                allowBlank: true,
                                id: 'strPROGESPETFGSeguimiento'
                            }
                        ]
                    },
                    {
                        xtype: 'textarea',
                        anchor: '100%',
                        width: 880,
                        fieldLabel: 'Metas Terapeuticas Planteadas',
                        name: 'Metas Terapeuticas',
                        height: 100,
                        allowBlank: true,
                        id: 'memPROGESPEMetasTerapeuticas'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'combo',
                                fieldLabel: 'Metas Cumplidas',
                                name: 'Metas Cumplidas',
                                width: 90,
                                allowBlank: true,
                                store: 'StoreSiNo',
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strPROGESPECumplimientoMetas'
                            },
                            {
                              html: 'Numero Metas Cumplidas:'
                            },
                            {
                                xtype: 'numberfield',
                                width: 50,
                                name: 'Numero Metas Cumplidas',
                                minValue: 0,
                                allowBlank: true,
                                style: 'text-align:center;',
                                id: 'intPROGESPENumCumplimientoMetas'
                            }
                        ]
                    },
                    {
                        xtype: 'datefield',
                        width: 120,
                        fieldLabel: 'Fecha Probable Proxima Cita',
                        name: 'Fecha Probable Proxima Cita',
                        allowBlank: true,
                        emptyText: '(dia/mes/año) ',
                        style: 'text-align:center;',
                        id: 'fecPROGESPECita'
                    },
                    {
                        html: 'Profesional que Atiende'
                    },
                    {
                        xtype: 'combo',
                        name: 'Profesional que Atiende',
                        width: 250,
                        allowBlank: true,
                        store: stProfesionalAtiende,
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        mode: 'local',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 10,
                        triggerAction: 'all',
                        id: 'strPROGESPEProfesionalAtiende'
                    }
                ]
            }
        ];
        this.on({
            afterlayout:{
                scope:this, 
                single:true, 
                fn:function() {
                    Ext.Msg.hide();
                    Ext.getCmp('fsProgramaEspecialesExamAnteriores').setVisible(false);
                    Ext.getCmp('fsProgramaEspecialesExamSeguimiento').setVisible(false);
                }
            }
        });
        pnProgramasEspecialesUi.superclass.initComponent.call(this);
    }
});
