/*
* @category    Panel Alteraciones Agudeza Visual
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


pnAlteracionesAgudezaVisualUi = Ext.extend(Ext.Panel, {
    anchor: '100%',
    autoHeight: true,
    layout: 'form',
    collapseFirst: false,
    collapsible: false,
    animCollapse: false,
    titleCollapse: false,
    border: false,
    padding: 0,
    id: 'pnAlteracionesAgudezaVisual',
    initComponent: function() {
        this.items = [
            {
                xtype: 'panel',
                anchor: '100%',
                autoHeight: true,
                layout: 'form',
                labelWidth: 260,
                padding: 5,
                items: [
                    {
                        xtype: 'combo',
                        labelStyle: 'background-color:#FF0; color:#F00; text-decoration:blink;',
                        fieldLabel: 'Registrar HC Medicion de Agudeza Visual?',
                        name: 'Registrar HC Medicion de Agudeza Visual?',
                        width: 60,
                        allowBlank: false,
                        store: 'StoreSiNo',
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        mode: 'local',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 10,
                        triggerAction: 'all',
                        id: 'strAgudezaVisual',
                        listeners:{
                            change : function( t, newValue, oldValue){
                                if(newValue == "NO"){
                                    Ext.getCmp('fsAgudezaVisual').setVisible(false);
                                    Ext.getCmp('strAGUVISMedicion').allowBlank=true;
                                    Ext.getCmp('memGUVISPlan').allowBlank=true;
                                    Ext.getCmp('strAGUVISRemisionOft').allowBlank=true;
                                    Ext.getCmp('sysAGUVISDiag').allowBlank=true;
                                    Ext.getCmp('sysAGUVISDiag').setValue(null);
                                    Ext.getCmp('strAGUVISMedicion').setValue(null);
                                    Ext.getCmp('memGUVISPlan').setValue(null);
                                    Ext.getCmp('strAGUVISRemisionOft').setValue(null);
                                    Ext.getCmp('strAGUVISMedicion').disable();
                                    Ext.getCmp('memGUVISPlan').disable();
                                    Ext.getCmp('strAGUVISRemisionOft').disable();
                                    Ext.getCmp('sysAGUVISDiag').disable();
                                    Ext.getCmp('sysAGUVISDiag').clearInvalid();
                                    Ext.getCmp('strAGUVISMedicion').clearInvalid();
                                    Ext.getCmp('memGUVISPlan').clearInvalid();
                                    Ext.getCmp('strAGUVISRemisionOft').clearInvalid();

                                }else{
                                    Ext.getCmp('fsAgudezaVisual').setVisible(true);
                                    Ext.getCmp('strAGUVISMedicion').allowBlank=false;
                                    Ext.getCmp('memGUVISPlan').allowBlank=false;
                                    Ext.getCmp('strAGUVISRemisionOft').allowBlank=false;
                                    Ext.getCmp('sysAGUVISDiag').allowBlank=false;
                                    Ext.getCmp('sysAGUVISDiag').enable();
                                    Ext.getCmp('strAGUVISMedicion').enable();
                                    Ext.getCmp('memGUVISPlan').enable();
                                    Ext.getCmp('strAGUVISRemisionOft').enable();
                                }
                            }
                        }
                    }
                ]
            },
            {
                xtype: 'fieldset',
                title: 'MEDICION AGUDEZA VISUAL',
                layout: 'form',
                collapseFirst: false,
                collapsible: true,
                animCollapse: true,
                titleCollapse: true,
                anchor: '100%',
                autoHeight: true,
                padding: 5,
                id:'fsAgudezaVisual',
                items: [
                    {
                        xtype: 'textfield',
                        width: 250,
                        allowBlank: true,
                        fieldLabel: 'Medicion',
                        id: 'strAGUVISMedicion'
                    },
                    {
                        xtype: 'textarea',
                        anchor: '100%',
                        fieldLabel: 'PLAN',
                        name: 'PLAN',
                        height: 100,
                        allowBlank: true,
                        id: 'memGUVISPlan'
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: 'Remision Valoracion Oftalmologica',
                        name: 'Remision Valoracion Oftalmologica',
                        width: 60,
                        allowBlank: true,
                        store: 'StoreSiNo',
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        mode: 'local',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 10,
                        triggerAction: 'all',
                        id: 'strAGUVISRemisionOft'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                                {
                                xtype: 'textfield',
                                width: 96,
                                allowBlank: false,
                                fieldLabel: 'Diagnostico',
                                id: 'sysAGUVISDiag',
                                listeners:{
                                    specialkey: function(f,e){
                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                        {
                                            if (f.getValue() != "" && f.getValue() != null){
                                                Ext.Ajax.request({
                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                    params:{
                                                        task: 'BUSCAR',
                                                        pCodigo: f.getValue().toUpperCase()
                                                    },
                                                    success: function(response,options)
                                                    {
                                                        var el = Ext.get('response'); // get the LOG
                                                        var Respuesta = response.responseText;
                                                        var Contenido = Respuesta.split('^');
                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                            Ext.getCmp('sysAGUVISDiag').setValue(null);
                                                            Ext.getCmp('sysAGUVISDiagNom').setValue(null);
                                                        } else {
                                                            Ext.getCmp('sysAGUVISDiag').setValue(Contenido[0]);
                                                            Ext.getCmp('sysAGUVISDiagNom').setValue(Contenido[1]);
                                                        }
                                                    },
                                                    failure: function(response,options){
                                                        var el = Ext.get('response');
                                                        Ext.getCmp('sysAGUVISDiag').setValue(null);
                                                        Ext.getCmp('sysAGUVISDiagNom').setValue(null);
                                                    },
                                                    scope:this //bind the callbacks
                                                });
                                            }else{
                                                Ext.getCmp('sysAGUVISDiag').setValue(null);
                                                Ext.getCmp('sysAGUVISDiagNom').setValue(null);
                                            }
                                        }
                                    }
                                }
                            },
                            {
                                xtype: 'textarea',
                                readOnly: true,
                                width: 625,
                                height: 22,
                                id: 'sysAGUVISDiagNom'
                            },
                            {
                                xtype: 'button',
                                iconCls: 'btnBuscar',
                                tooltip: 'Buscar Diagnostico Principal',
                                listeners:{
                                    click : function(){
                                        buscarcie10('sysAGUVISDiag','sysAGUVISDiagNom');
                                    }
                                }
                            }
                        ]
                    }
                ]
            }
        ];
        pnAlteracionesAgudezaVisualUi.superclass.initComponent.call(this);
    }
});
