/*
* @category    Formulario Examen Fisico Crecimiento y Desarrollo
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


winHCCrecimientoyDesarrollo001Ui = Ext.extend(Ext.Window, {
    title: 'eOfiClinic ©  .:: Plantilla HC - Examen Fisico Crecimiento y Desarrollo ::.',
    width: 990,
    height: 636,
    closable: false,
    resizable: false,
    draggable: false,
    modal: true,
    id: 'winHC',
    initComponent: function() {
        
        tmpmx = objMX;
        tmpmxadd = objMXADD;
        tmpexa = objEXA;
        tmprem = objREM;
        myPaciente = 0;
        myCAS = 0;
        
        try {
            var campo = Ext.getCmp('sysPacientePlantillaHC');
            if ( campo != null ) {
                myPaciente = Ext.getCmp('sysPacientePlantillaHC').getValue();
            }
        }catch(ex){
        }
        if(myPaciente == 0){
            try {
                var campo1 = Ext.getCmp('sysIdPacienteHC');
                if ( campo1 != null ) {
                    myPaciente = Ext.getCmp('sysIdPacienteHC').getValue();
                }
            }catch(ex){
            }
        }
        if(myPaciente == 0){
            try {
                var campo5 = Ext.getCmp('sysPacienteRefHC');
                if ( campo5 != null ) {
                    myPaciente = Ext.getCmp('sysPacienteRefHC').getValue();
                }
            }catch(ex){
            }
        }
        try {
            var campo2 = Ext.getCmp('sysCASPlantillaHC');
            if ( campo2 != null ) {
                myCAS = Ext.getCmp('sysCASPlantillaHC').getValue();
            }
        }catch(ex){
        }
        if(myCAS == 0){
            try {
                var campo3 = Ext.getCmp('sysCASHC');
                if ( campo3 != null ) {
                    myCAS = Ext.getCmp('sysCASHC').getValue();
                }
            }catch(ex){
            }
        }
        if(myCAS == 0){
            try {
                var campo4 = Ext.getCmp('sysCASRefHC');
                if ( campo4 != null ) {
                    myCAS = Ext.getCmp('sysCASRefHC').getValue();
                }
            }catch(ex){
            }
        }
        if (objMX != "NA"){
            var xSolMX = eval(objMX);
            Ext.getCmp('gridMedicamentosHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: myPaciente,
                    pCAS: myCAS
                }
            });
        }
        else{
            var xSolMX = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        if (objEXA != "NA"){
            var xSolEXA = eval(objEXA);
            Ext.getCmp('gridExamenesHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: myPaciente,
                    pCAS: myCAS
                }
            });
        }else{
            var xSolEXA = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }    
        if (objREM != "NA"){
            var xSolREM = eval(objREM);
            Ext.getCmp('gridRemisionesHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: myPaciente,
                    pCAS: myCAS
                }
            });
        }else{
            var xSolREM = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        
        
        var dataProfesionalAtiende = [
            ['Medico General'],
            ['Medico Especialista'],
            ['Enfermera'],
            ['Optometria'],
            ['Audiometria'],
            ['Otro Profesional']
        ];
        var stProfesionalAtiende = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stProfesionalAtiende.loadData(dataProfesionalAtiende);
        
        
        var dataEstadoNutricional = [
            ['NORMAL'],
            ['DESNUTRICION']
        ];
        var stEstadoNutricional = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stEstadoNutricional.loadData(dataEstadoNutricional);
        
        
        var dataDesnutricion = [
            ['RECIENTE'],
            ['CRONICA']
        ];
        var stDesnutricion = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stDesnutricion.loadData(dataDesnutricion);
        
        
        
        this.items = [
            {
                xtype: 'panel',
                frame: true,
                anchor: '100%',
                id: 'panelHC',
                padding: 10,
                border: false,
                height: 610,
                autoScroll: true,
                layout: 'form',
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysIdCodPlantillaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        value: 1,
                        id: 'sysUsaGridSalida'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                        value: 0,
                        id: 'sysYaGuardoHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysPlantillaHC',
                        name: 'PLANTILLA'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptMx'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptExa'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptRem'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Actividad',
                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                        id: 'sysActividadHC',
                        name: 'PLANTILLA'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Empresa',
                        id: 'sysEmpresaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'IPS',
                        id: 'sysIPSHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Usuario',
                        id: 'sysUsuarioHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Profesional',
                        id: 'sysProfesionalHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Paciente',
                        id: 'sysIdPacienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Apertura',
                        id: 'sysAperturaHC'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Cliente',
                        id: 'sysClienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdClienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdPlanHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdSubPlanHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdContratoHC'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Profesional',
                        id: 'sysProfesionalAgendaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'ConsecutivoDetalle',
                        id: 'sysConsecutivoDetalleHC'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'CAS',
                                id: 'sysCASHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysFechaHC',
                                value: 'Fecha: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                width: 100,
                                id: 'sysFechaHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysHoraHC',
                                value: 'Hora: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                width: 90,
                                id: 'sysHoraHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysLegalizacionHC',
                                value: 'Legalización: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                width: 100,
                                id: 'sysLegalizaHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysAutorizacionHC',
                                value: 'Nro Autorización: '
                            },
                            {
                                xtype: 'textfield',
                                width: 210,
                                allowBlank: true,
                                style: 'color:brown;',
                                readOnly: true,
                                id: 'sysNroAutorizacionHC'
                            }
                        ]
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Paciente',
                        value: 'CC 792558261  - JORGE GALEANO RUIZ - (Masculino) FechaNac: 1973-01-30, Edad 38 Años',
                        id: 'sysPacienteHC'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'textfield',
                                width: 120,
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'Genero',
                                id: 'sysGeneroPacHC'
                            },
                            {
                                html: 'Fecha Nacimiento'
                            },
                            {
                                xtype: 'datefield',
                                width: 120,
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysFecNacPacHC'
                            },
                            {
                                html: 'Edad'
                            },
                            {
                                xtype: 'textfield',
                                width: 250,
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysEdadPacHC'
                            }
                        ]
                    },
                    {
                        html: '<hr>',
                        style: 'background:transparent;',
                        border: false
                    },
                    {
                        xtype: 'tabpanel',
                        width: 930,
                        autoHeight: true,
                        border: false,
                        ref: 'fTabPanel',
                        id: 'fTabPanel',
                        activeTab: 0,
                        items: [
                            {
                                xtype: 'panel',
                                title: 'Evolución',
                                autoHeight: true,
                                autoScroll: true,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaEvolucion',
                                layout: 'form',
                                items: [
                                    {
                                        xtype: 'form',
                                        frame: true,
                                        anchor: '100%',
                                        id: 'frmHC',
                                        padding: 10,
                                        border: false,
                                        autoScroll: true,
                                        style: 'background:transparent;',
                                        items: [
                                            // AQUI EMPIEZAN CAMBIOS
                                            {
                                                xtype: 'fieldset',
                                                title: 'CRECIMIENTO Y DESARROLLO',
                                                layout: 'form',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                id: 'fsCrecimientoyDesarrollo',
                                                items: [
                                                    {
                                                        xtype: 'fieldset',
                                                        title: 'MOTIVO DE CONSULTA',
                                                        layout: 'table',
                                                        collapsible: true,
                                                        titleCollapse: true,
                                                        anchor: '100%',
                                                        autoHeight: true,
                                                        padding: 7,
                                                        items: [
                                                            {
                                                                xtype: 'textarea',
                                                                width: 850,
                                                                fieldLabel: 'MOTIVO DE CONSULTA',
                                                                name: 'MOTIVO DE CONSULTA',
                                                                height: 30,
                                                                grow: true,
                                                                minGrow: 30,
                                                                allowBlank: false,
                                                                id: 'memMotivoConsulta'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        title: '<center>EXAMEN FISICO</center>',
                                                        layout: 'form',
                                                        anchor: '100%',
                                                        autoHeight: true,
                                                        id: 'paAteInfControles',
                                                        items: [
                                                            {
                                                                html: '<br>'
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        width: 60,
                                                                        minValue: 0,
                                                                        maxValue: 250,
                                                                        decimalPrecision: 2,
                                                                        allowBlank: false,
                                                                        fieldLabel: 'TALLA (cm)',
                                                                        name:"TALLA (cm)",
                                                                        emptyText: '(cm)',
                                                                        id: 'intEXAFISTalla',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null || pNew == 0){
                                                                                    Ext.getCmp('intEXAFISTalla').setValue(null);
                                                                                    Ext.getCmp('intEXAFISIMC').setValue(0);
                                                                                }else{
                                                                                    if(Ext.getCmp('intEXAFISPeso').getValue() > 0){
                                                                                        var pTalla = Ext.getCmp('intEXAFISTalla').getValue() / 100;
                                                                                        Ext.getCmp('intEXAFISIMC').setValue(Ext.getCmp('intEXAFISPeso').getValue()/(pTalla*pTalla));
                                                                                    }else{
                                                                                        Ext.getCmp('intEXAFISIMC').setValue(0);
                                                                                    }
                                                                                }
                                                                                if(Ext.getCmp('intEXAFISIMC').getValue()<1){
                                                                                   Ext.getCmp('strEXAFISIMCClasificacon').setValue(null);
                                                                                }else{
                                                                                    if(Ext.getCmp('intEXAFISIMC').getValue()<24.9){
                                                                                       Ext.getCmp('strEXAFISIMCClasificacon').setValue("ACEPTABLE");
                                                                                    }else{
                                                                                        if(Ext.getCmp('intEXAFISIMC').getValue()<29.9){
                                                                                           Ext.getCmp('strEXAFISIMCClasificacon').setValue("SOBREPESO");
                                                                                        }else{
                                                                                            Ext.getCmp('strEXAFISIMCClasificacon').setValue("OBESIDAD");
                                                                                        }

                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sysEXAFISPeso',
                                                                        value: 'PESO (Kg): '
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        width: 60,
                                                                        minValue: 0,
                                                                        maxValue: 250,
                                                                        decimalPrecision: 2,
                                                                        allowBlank: false,
                                                                        emptyText: '(Kg)',
                                                                        name:"PESO (Kg)",
                                                                        id: 'intEXAFISPeso',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null || pNew == 0){
                                                                                    Ext.getCmp('intEXAFISPeso').setValue(null);
                                                                                    Ext.getCmp('intEXAFISIMC').setValue(0);
                                                                                }else{
                                                                                    //peso [kg]/ estatura [m2]
                                                                                    if(Ext.getCmp('intEXAFISTalla').getValue() > 0){
                                                                                        var pTalla = Ext.getCmp('intEXAFISTalla').getValue() / 100;
                                                                                        Ext.getCmp('intEXAFISIMC').setValue(Ext.getCmp('intEXAFISPeso').getValue()/(pTalla*pTalla));
                                                                                    }else{
                                                                                        Ext.getCmp('intEXAFISIMC').setValue(0);
                                                                                    }
                                                                                }
                                                                                if(Ext.getCmp('intEXAFISIMC').getValue()<1){
                                                                                   Ext.getCmp('strEXAFISIMCClasificacon').setValue(null);
                                                                                }else{
                                                                                    if(Ext.getCmp('intEXAFISIMC').getValue()<24.9){
                                                                                       Ext.getCmp('strEXAFISIMCClasificacon').setValue("ACEPTABLE");
                                                                                    }else{
                                                                                        if(Ext.getCmp('intEXAFISIMC').getValue()<29.9){
                                                                                           Ext.getCmp('strEXAFISIMCClasificacon').setValue("SOBREPESO");
                                                                                        }else{
                                                                                            Ext.getCmp('strEXAFISIMCClasificacon').setValue("OBESIDAD");
                                                                                        }

                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sysEXAFISIMC',
                                                                        value: 'IMC: '
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        width: 60,
                                                                        minValue: 0,
                                                                        decimalPrecision: 2,
                                                                        allowBlank: false,
                                                                        readOnly: true,
                                                                        name: "IMC",
                                                                        id: 'intEXAFISIMC'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        anchor: '100%',
                                                                        allowBlank: false,
                                                                        readOnly: true,
                                                                        name: "IMC - CLASIFICACION",
                                                                        id: 'strEXAFISIMCClasificacon'
                                                                    },
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        width: 60,
                                                                        minValue: 0,
                                                                        maxValue: 250,
                                                                        decimalPrecision: 2,
                                                                        allowBlank: false,
                                                                        fieldLabel: 'Temperatura',
                                                                        name:"Temperatura",
                                                                        id: 'intEXAFISTemperatura'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sysEXAFISPC',
                                                                        value: 'P. Cefalico: '
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        width: 60,
                                                                        minValue: 0,
                                                                        decimalPrecision: 2,
                                                                        name: 'Perimetro Cefalico',
                                                                        allowBlank: false,
                                                                        id: 'strEXAFISPC'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sysEXAFISPT',
                                                                        value: 'P. Toracico: '
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        width: 60,
                                                                        minValue: 0,
                                                                        decimalPrecision: 2,
                                                                        name: 'Perimetro Toracico',
                                                                        allowBlank: false,
                                                                        id: 'strEXAFISPT'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                html: '<br>'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        title: '<center>EXPLORACIÓN - ESTADO</center>',
                                                        layout: 'form',
                                                        anchor: '100%',
                                                        autoHeight: true,
                                                        id: 'paAteInfExpFisica',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                name:'Cabeza',
                                                                fieldLabel:'Cabeza',
                                                                width: 360,
                                                                height: 22,
                                                                id: 'strExpFisCabeza',
                                                                listeners: {
                                                                    render: function( p ) {
                                                                        p.getEl().on('dblclick', function (){
                                                                            Ext.getCmp('strExpFisCabeza').setValue("No Evaluado");
                                                                        });
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name:'Ojos',
                                                                fieldLabel:'Ojos',
                                                                width: 360,
                                                                id: 'strExpFisOjos',
                                                                listeners: {
                                                                    render: function( p ) {
                                                                        p.getEl().on('dblclick', function (){
                                                                            Ext.getCmp('strExpFisOjos').setValue("No Evaluado");
                                                                        });
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name:'Nariz',
                                                                fieldLabel:'Nariz',
                                                                width: 360,
                                                                id: 'strExpFisNariz',
                                                                listeners: {
                                                                    render: function( p ) {
                                                                        p.getEl().on('dblclick', function (){
                                                                            Ext.getCmp('strExpFisNariz').setValue("No Evaluado");
                                                                        });
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name:'Oidos',
                                                                fieldLabel:'Oidos',
                                                                width: 360,
                                                                id: 'strExpFisOidos',
                                                                listeners: {
                                                                    render: function( p ) {
                                                                        p.getEl().on('dblclick', function (){
                                                                            Ext.getCmp('strExpFisOidos').setValue("No Evaluado");
                                                                        });
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name:'Boca',
                                                                fieldLabel:'Boca',
                                                                width: 360,
                                                                id: 'strExpFisBoca',
                                                                listeners: {
                                                                    render: function( p ) {
                                                                        p.getEl().on('dblclick', function (){
                                                                            Ext.getCmp('strExpFisBoca').setValue("No Evaluado");
                                                                        });
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name:'Cuello',
                                                                fieldLabel:'Cuello',
                                                                width: 360,
                                                                id: 'strExpFisCuello',
                                                                listeners: {
                                                                    render: function( p ) {
                                                                        p.getEl().on('dblclick', function (){
                                                                            Ext.getCmp('strExpFisCuello').setValue("No Evaluado");
                                                                        });
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name:'Torax',
                                                                fieldLabel:'Torax',
                                                                width: 360,
                                                                id: 'strExpFisTorax',
                                                                listeners: {
                                                                    render: function( p ) {
                                                                        p.getEl().on('dblclick', function (){
                                                                            Ext.getCmp('strExpFisTorax').setValue("No Evaluado");
                                                                        });
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name:'Cardio-Respiratorio',
                                                                fieldLabel:'Cardio-Respiratorio',
                                                                width: 360,
                                                                id: 'strExpFisCarRespiratorio',
                                                                listeners: {
                                                                    render: function( p ) {
                                                                        p.getEl().on('dblclick', function (){
                                                                            Ext.getCmp('strExpFisCarRespiratorio').setValue("No Evaluado");
                                                                        });
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name:'Abdomen',
                                                                fieldLabel:'Abdomen',
                                                                width: 360,
                                                                id: 'strExpFisAbdomen',
                                                                listeners: {
                                                                    render: function( p ) {
                                                                        p.getEl().on('dblclick', function (){
                                                                            Ext.getCmp('strExpFisAbdomen').setValue("No Evaluado");
                                                                        });
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name:'Genito-Urinario',
                                                                fieldLabel:'Genito-Urinario',
                                                                width: 360,
                                                                id: 'strExpFisGenUrinario',
                                                                listeners: {
                                                                    render: function( p ) {
                                                                        p.getEl().on('dblclick', function (){
                                                                            Ext.getCmp('strExpFisGenUrinario').setValue("No Evaluado");
                                                                        });
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name:'Ano',
                                                                fieldLabel:'Ano',
                                                                width: 360,
                                                                id: 'strExpFisAno',
                                                                listeners: {
                                                                    render: function( p ) {
                                                                        p.getEl().on('dblclick', function (){
                                                                            Ext.getCmp('strExpFisAno').setValue("No Evaluado");
                                                                        });
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name:'Extremidades',
                                                                fieldLabel:'Extremidades',
                                                                width: 360,
                                                                id: 'strExpFisExtremidades',
                                                                listeners: {
                                                                    render: function( p ) {
                                                                        p.getEl().on('dblclick', function (){
                                                                            Ext.getCmp('strExpFisExtremidades').setValue("No Evaluado");
                                                                        });
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name:'Piel',
                                                                fieldLabel:'Piel',
                                                                width: 360,
                                                                id: 'strExpFisPiel',
                                                                listeners: {
                                                                    render: function( p ) {
                                                                        p.getEl().on('dblclick', function (){
                                                                            Ext.getCmp('strExpFisPiel').setValue("No Evaluado");
                                                                        });
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name:'Sistema Nervioso',
                                                                fieldLabel:'Sistema Nervioso',
                                                                width: 360,
                                                                id: 'strExpFisSisNervioso',
                                                                listeners: {
                                                                    render: function( p ) {
                                                                        p.getEl().on('dblclick', function (){
                                                                            Ext.getCmp('strExpFisSisNervioso').setValue("No Evaluado");
                                                                        });
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        title: '<center>VALORACION DEL DESARROLLO POR CONDUCTAS</center>',
                                                        layout: 'form',
                                                        anchor: '100%',
                                                        autoHeight: true,
                                                        id: 'pnExpFisValDesConductas',
                                                        items: [
                                                            {
                                                                xtype: 'panel',
                                                                title: '<center>ESCALA ABREVIADA DEL DESARROLLO</center>',
                                                                layout: 'form',
                                                                anchor: '100%',
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'panel',
                                                                        layout: 'table',
                                                                        anchor: '100%',
                                                                        padding: 0,
                                                                        layoutConfig: {
                                                                            columns: 5
                                                                        },
                                                                        autoHeight: true,
                                                                        items: [
                                                                            {
                                                                                xtype: 'panel',
                                                                                layout: 'form',
                                                                                width: 25,
                                                                                height: 1600,
                                                                                labelWidth: 0,
                                                                                labelSeparator: '',
                                                                                labelStyle: 'color:blue;',
                                                                                title: '<center>M</center>',
                                                                                items: [
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        fieldLabel: '<br>&nbsp;< 1<br>&nbsp;',
                                                                                        width: 1,
                                                                                        allowBlank: true,
                                                                                        readOnly: true,
                                                                                        border: 0,
                                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                                        id: 'sysExaA'
                                                                                    },
                                                                                    {
                                                                                        html: '<hr>' 
                                                                                    },
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        fieldLabel: '<br>',
                                                                                        width: 1,
                                                                                        height: 7,
                                                                                        allowBlank: true,
                                                                                        readOnly: true,
                                                                                        border: 0,
                                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                                        id: 'sysExaB'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        fieldLabel: '&nbsp;1<br>&nbsp;a<br>&nbsp;3',
                                                                                        width: 1,
                                                                                        height: 7,
                                                                                        allowBlank: true,
                                                                                        readOnly: true,
                                                                                        border: 0,
                                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                                        id: 'sysExaC'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        fieldLabel: '<br>&nbsp;',
                                                                                        width: 1,
                                                                                        height: 7,
                                                                                        allowBlank: true,
                                                                                        readOnly: true,
                                                                                        border: 0,
                                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                                        id: 'sysExaD'
                                                                                    },
                                                                                    {
                                                                                        html: '<hr>' 
                                                                                    },
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        fieldLabel: '<br>',
                                                                                        width: 1,
                                                                                        height: 7,
                                                                                        allowBlank: true,
                                                                                        readOnly: true,
                                                                                        border: 0,
                                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                                        id: 'sysExaE'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        fieldLabel: '&nbsp;4<br>&nbsp;a<br>&nbsp;6',
                                                                                        width: 1,
                                                                                        height: 7,
                                                                                        allowBlank: true,
                                                                                        readOnly: true,
                                                                                        border: 0,
                                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                                        id: 'sysExaF'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        fieldLabel: '<br>&nbsp;',
                                                                                        width: 1,
                                                                                        height: 7,
                                                                                        allowBlank: true,
                                                                                        readOnly: true,
                                                                                        border: 0,
                                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                                        id: 'sysExaG'
                                                                                    },
                                                                                    {
                                                                                        html: '<hr>' 
                                                                                    },
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        fieldLabel: '<br>',
                                                                                        width: 1,
                                                                                        height: 7,
                                                                                        allowBlank: true,
                                                                                        readOnly: true,
                                                                                        border: 0,
                                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                                        id: 'sysExaH'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        fieldLabel: '&nbsp;7<br>&nbsp;a<br>&nbsp;9',
                                                                                        width: 1,
                                                                                        height: 7,
                                                                                        allowBlank: true,
                                                                                        readOnly: true,
                                                                                        border: 0,
                                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                                        id: 'sysExaI'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        fieldLabel: '<br>&nbsp;',
                                                                                        width: 1,
                                                                                        height: 7,
                                                                                        allowBlank: true,
                                                                                        readOnly: true,
                                                                                        border: 0,
                                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                                        id: 'sysExaJ'
                                                                                    },
                                                                                    {
                                                                                        html: '<hr>' 
                                                                                    },
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        fieldLabel: '<br>',
                                                                                        width: 1,
                                                                                        height: 7,
                                                                                        allowBlank: true,
                                                                                        readOnly: true,
                                                                                        border: 0,
                                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                                        id: 'sysExaK'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        fieldLabel: '10&nbsp;<br>&nbsp;a<br>12&nbsp;',
                                                                                        width: 1,
                                                                                        height: 7,
                                                                                        allowBlank: true,
                                                                                        readOnly: true,
                                                                                        border: 0,
                                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                                        id: 'sysExaL'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        fieldLabel: '<br>&nbsp;',
                                                                                        width: 1,
                                                                                        height: 7,
                                                                                        allowBlank: true,
                                                                                        readOnly: true,
                                                                                        border: 0,
                                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                                        id: 'sysExaM'
                                                                                    },
                                                                                    {
                                                                                        html: '<hr>' 
                                                                                    },
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        fieldLabel: '<br>',
                                                                                        width: 1,
                                                                                        height: 7,
                                                                                        allowBlank: true,
                                                                                        readOnly: true,
                                                                                        border: 0,
                                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                                        id: 'sysExaN'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        fieldLabel: '13&nbsp;<br>&nbsp;a<br>18&nbsp;',
                                                                                        width: 1,
                                                                                        height: 7,
                                                                                        allowBlank: true,
                                                                                        readOnly: true,
                                                                                        border: 0,
                                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                                        id: 'sysExaO'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        fieldLabel: '<br>&nbsp;',
                                                                                        width: 1,
                                                                                        height: 7,
                                                                                        allowBlank: true,
                                                                                        readOnly: true,
                                                                                        border: 0,
                                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                                        id: 'sysExaP'
                                                                                    },
                                                                                    {
                                                                                        html: '<hr>' 
                                                                                    },
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        fieldLabel: '<br>',
                                                                                        width: 1,
                                                                                        height: 7,
                                                                                        allowBlank: true,
                                                                                        readOnly: true,
                                                                                        border: 0,
                                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                                        id: 'sysExaQ'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        fieldLabel: '19&nbsp;<br>&nbsp;a<br>24&nbsp;',
                                                                                        width: 1,
                                                                                        height: 7,
                                                                                        allowBlank: true,
                                                                                        readOnly: true,
                                                                                        border: 0,
                                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                                        id: 'sysExaR'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        fieldLabel: '<br>&nbsp;',
                                                                                        width: 1,
                                                                                        height: 7,
                                                                                        allowBlank: true,
                                                                                        readOnly: true,
                                                                                        border: 0,
                                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                                        id: 'sysExaS'
                                                                                    },
                                                                                    {
                                                                                        html: '<hr>' 
                                                                                    },
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        fieldLabel: '<br>',
                                                                                        width: 1,
                                                                                        height: 7,
                                                                                        allowBlank: true,
                                                                                        readOnly: true,
                                                                                        border: 0,
                                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                                        id: 'sysExaT'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        fieldLabel: '25&nbsp;<br>&nbsp;a<br>36&nbsp;',
                                                                                        width: 1,
                                                                                        height: 7,
                                                                                        allowBlank: true,
                                                                                        readOnly: true,
                                                                                        border: 0,
                                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                                        id: 'sysExaU'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        fieldLabel: '<br>&nbsp;',
                                                                                        width: 1,
                                                                                        height: 7,
                                                                                        allowBlank: true,
                                                                                        readOnly: true,
                                                                                        border: 0,
                                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                                        id: 'sysExaV'
                                                                                    },
                                                                                    {
                                                                                        html: '<hr>' 
                                                                                    },
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        fieldLabel: '<br>',
                                                                                        width: 1,
                                                                                        height: 7,
                                                                                        allowBlank: true,
                                                                                        readOnly: true,
                                                                                        border: 0,
                                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                                        id: 'sysExaW'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        fieldLabel: '37&nbsp;<br>&nbsp;a<br>48&nbsp;',
                                                                                        width: 1,
                                                                                        height: 7,
                                                                                        allowBlank: true,
                                                                                        readOnly: true,
                                                                                        border: 0,
                                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                                        id: 'sysExaX'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        fieldLabel: '<br>&nbsp;',
                                                                                        width: 1,
                                                                                        height: 7,
                                                                                        allowBlank: true,
                                                                                        readOnly: true,
                                                                                        border: 0,
                                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                                        id: 'sysExaY'
                                                                                    },
                                                                                    {
                                                                                        html: '<hr>' 
                                                                                    },
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        fieldLabel: '<br>',
                                                                                        width: 1,
                                                                                        height: 7,
                                                                                        allowBlank: true,
                                                                                        readOnly: true,
                                                                                        border: 0,
                                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                                        id: 'sysExaZ'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        fieldLabel: '49&nbsp;<br>&nbsp;a<br>60&nbsp;',
                                                                                        width: 1,
                                                                                        height: 7,
                                                                                        allowBlank: true,
                                                                                        readOnly: true,
                                                                                        border: 0,
                                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                                        id: 'sysExaAA'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        fieldLabel: '<br>&nbsp;',
                                                                                        width: 1,
                                                                                        height: 7,
                                                                                        allowBlank: true,
                                                                                        readOnly: true,
                                                                                        border: 0,
                                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                                        id: 'sysExaAB'
                                                                                    },
                                                                                    {
                                                                                        html: '<hr>' 
                                                                                    },
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        fieldLabel: '<br>',
                                                                                        width: 1,
                                                                                        height: 7,
                                                                                        allowBlank: true,
                                                                                        readOnly: true,
                                                                                        border: 0,
                                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                                        id: 'sysExaAC'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        fieldLabel: '61&nbsp;<br>&nbsp;a<br>72&nbsp;',
                                                                                        width: 1,
                                                                                        height: 7,
                                                                                        allowBlank: true,
                                                                                        readOnly: true,
                                                                                        border: 0,
                                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                                        id: 'sysExaAD'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        fieldLabel: '<br>&nbsp;',
                                                                                        width: 1,
                                                                                        height: 7,
                                                                                        allowBlank: true,
                                                                                        readOnly: true,
                                                                                        border: 0,
                                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                                        id: 'sysExaAE'
                                                                                    },
                                                                                    {
                                                                                        html: '<hr>' 
                                                                                    },
                                                                                    {
                                                                                        html: '<hr>' 
                                                                                    }
                                                                                ]
                                                                            },
                                                                            {
                                                                                xtype: 'panel',
                                                                                layout: 'form',
                                                                                width: 210,
                                                                                height: 1600,
                                                                                labelWidth: 150,
                                                                                labelSeparator: '',
                                                                                labelStyle: 'color:blue;',
                                                                                title: '<center>MOTRIZ - GRUEZA</center>',
                                                                                items: [
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '0. Patea vigorosamente?<br>&nbsp;<br>&nbsp;',
                                                                                        name: '0. Patea vigorosamente?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_A0',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_AClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_A0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        html: '<hr>'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '1. Levanta la cabeza en prona?',
                                                                                        name: '1. Levanta la cabeza en prona?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_A1',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_AClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_A0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '2. Levanta cabeza pecho en prona?',
                                                                                        name: '2. Levanta cabeza pecho en prona?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_A2',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_AClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_A0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '3. Sostiene cabeza al levantarlo de los brazos?',
                                                                                        name: '3. Sostiene cabeza al levantarlo de los brazos?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_A3',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_AClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_A0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        html: '<hr>'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '4. Control de cabeza sentado?',
                                                                                        name: '4. Control de cabeza sentado?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_A4',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_AClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_A0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '5. Se voltea de un lado a otro?',
                                                                                        name: '5. Se voltea de un lado a otro?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_A5',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_AClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_A0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '6. Intenta sentarse solo?<br>&nbsp;',
                                                                                        name: '6. Intenta sentarse solo?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_A6',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_AClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_A0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        html: '<hr>'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '7.Se sostiene sentado con ayuda?',
                                                                                        name: '7. Se sostiene sentado con ayuda?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_A7',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_AClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_A0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '8. Se arrastra en posicion prona?',
                                                                                        name: '8. Se arrastra en posicion prona?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_A8',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_AClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_A0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '9. Se sienta por si solo?<br>&nbsp;',
                                                                                        name: '9. Se sienta por si solo?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_A9',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_AClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_A0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        html: '<hr>'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '10.Gatea bien?<br>&nbsp;',
                                                                                        name: '10.Gatea bien?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_A10',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_AClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_A0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '11.Se agarra y sostiene de pie?',
                                                                                        name: '11.Se agarra y sostiene de pie?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_A11',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_AClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_A0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '12.Se para solo?<br>&nbsp;',
                                                                                        name: '12.Se para solo?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_A12',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_AClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_A0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        html: '<hr>'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '13.Da pasitos solo?<br>&nbsp;',
                                                                                        name: '13.Da pasitos solo?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_A13',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_AClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_A0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '14.Camina solo bien?<br>&nbsp;',
                                                                                        name: '14.Camina solo bien?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_A14',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_AClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_A0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '15.Corre?<br>&nbsp;',
                                                                                        name: '15.Corre?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_A15',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_AClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_A0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        html: '<hr>'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '16.Patea la pelota?<br>&nbsp;',
                                                                                        name: '16.Patea la pelota?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_A16',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_AClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_A0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '17.Lanza la pelota con las manos?',
                                                                                        name: '17.Lanza la pelota con las manos?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_A17',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_AClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_A0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '18.Salta en los dos pies?<br>&nbsp;',
                                                                                        name: '18.Salta en los dos pies?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_A18',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_AClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_A0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        html: '<hr>'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '19.Se empina en ambos pies?',
                                                                                        name: '19.Se empina en ambos pies?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_A19',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_AClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_A0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '20.Se levanta sin usar las manos?',
                                                                                        name: '20.Se levanta sin usar las manos?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_A20',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_AClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_A0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '21.Camina hacia atras?<br>&nbsp;',
                                                                                        name: '21.Camina hacia atras?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_A21',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_AClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_A0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        html: '<hr>'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '22.Camina en punta de pies?',
                                                                                        name: '22.Camina en punta de pies?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_A22',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_AClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_A0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '23.Se para en un solo pie?<br>&nbsp;',
                                                                                        name: '23.Se para en un solo pie?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_A23',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_AClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_A0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '24.Lanza y agarra la pelota?',
                                                                                        name: '24.Lanza y agarra la pelota?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_A24',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_AClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_A0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        html: '<hr>'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '25.Camina en linea recta?<br>&nbsp;',
                                                                                        name: '25.Camina en linea recta?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_A25',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_AClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_A0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '26.Tres o mas pasos en un pie?',
                                                                                        name: '26.Tres o mas pasos en un pie?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_A26',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_AClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_A0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '27.Hace rebotar y agarra la pelota?',
                                                                                        name: '27.Hace rebotar y agarra la pelota?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_A27',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_AClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_A0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        html: '<hr>'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '28.Salta a pies juntillas cuerda a 25 cms?',
                                                                                        name: '28.Salta a pies juntillas cuerda a 25 cms?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_A28',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_AClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_A0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '29.Hace "caballitos" alternando los pies?',
                                                                                        name: '29.Hace "caballitos" alternando los pies?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_A29',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_AClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_A0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '30.Salta desde 60 cms de altura?',
                                                                                        name: '30.Salta desde 60 cms de altura?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_A30',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_AClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_ACalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_A0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_A30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        html: '<hr>'
                                                                                    },
                                                                                    {
                                                                                        html: '<hr>'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'numberfield',
                                                                                        name: 'Calificacion Motricidad Gruesa',
                                                                                        fieldLabel: 'Calificacion Motricidad Gruesa',
                                                                                        width: 50,
                                                                                        minValue: 0,
                                                                                        decimalPrecision: 0,
                                                                                        allowBlank: true,
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_ACalificacion'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        name: 'Clasificacion Motricidad Gruesa',
                                                                                        fieldLabel: 'Clasificacion Motricidad Gruesa',
                                                                                        width: 50,
                                                                                        allowBlank: true,
                                                                                        id: 'strEVALDESACyD_AClasificacion'
                                                                                    }
                                                                                ]
                                                                            },
                                                                            {
                                                                                xtype: 'panel',
                                                                                layout: 'form',
                                                                                labelWidth: 150,
                                                                                labelSeparator: '',
                                                                                labelStyle: 'color:red;',
                                                                                width: 210,
                                                                                height: 1600,
                                                                                title: '<center>MOTRIZ - FINO ADAPTATIVA</center>',
                                                                                items: [
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '0. Sigue movimiento horizontal y vertical del objeto?',
                                                                                        name: '0. Sigue movimiento horizontal y vertical del objeto?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_B0',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_BClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_B0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        html: '<hr>'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '1. Abre y mira sus manos?<br>&nbsp;',
                                                                                        name: '1. Abre y mira sus manos?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_B1',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_BClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_B0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '2. Sostiene objeto en la mano?',
                                                                                        name: '2. Sostiene objeto en la mano?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_B2',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_BClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_B0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '3. Se lleva objeto a la boca?',
                                                                                        name: '3. Se lleva objeto a la boca?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_B3',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_BClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_B0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        html: '<hr>'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '4. Agarra objetos voluntariamente?',
                                                                                        name: '4. Agarra objetos voluntariamente?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_B4',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_BClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_B0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '5. Sostiene un objetos en cada mano?',
                                                                                        name: '5. Sostiene un objetos en cada mano?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_B5',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_BClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_B0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '6. Pasa objetos de una mano a otra?',
                                                                                        name: '6. Pasa objetos de una mano a otra?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_B6',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_BClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_B0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        html: '<hr>'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '7. Manipula varios objetos a la vez?',
                                                                                        name: '7. Manipula varios objetos a la vez?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_B7',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_BClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_B0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '8. Agarra objetos pequeños con los dedos?',
                                                                                        name: '8. Agarra objetos pequeños con los dedos?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_B8',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_BClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_B0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '9. Agarra cubo con pulgar e indice?',
                                                                                        name: '9. Agarra cubo con pulgar e indice?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_B9',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_BClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_B0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        html: '<hr>'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '10.Mete y saca objetos en caja?',
                                                                                        name: '10.Mete y saca objetos en caja?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_B10',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_BClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_B0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '11.Agarra tercer objeto sin soltar otros?',
                                                                                        name: '11.Agarra tercer objeto sin soltar otros?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_B11',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_BClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_B0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '12.Busca objetos escondidos?',
                                                                                        name: '12.Busca objetos escondidos?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_B12',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_BClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_B0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        html: '<hr>'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '13.Hace torre de tres cubos?',
                                                                                        name: '13.Hace torre de tres cubos?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_B13',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_BClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_B0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '14.Pasa hojas de un libro?<br>&nbsp;',
                                                                                        name: '14.Pasa hojas de un libro?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_B14',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_BClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_B0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '15.Anticipa salida del objeto?',
                                                                                        name: '15.Anticipa salida del objeto?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_B15',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_BClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_B0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        html: '<hr>'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '16.Tapa bien la caja?<br>&nbsp;',
                                                                                        name: '16.Tapa bien la caja?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_B16',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_BClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_B0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '17.Hace garabatos circulares?',
                                                                                        name: '17.Hace garabatos circulares?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_B17',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_BClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_B0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '18.Hace torre de cinco o mas cubo?',
                                                                                        name: '18.Hace torre de cinco o mas cubos?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_B18',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_BClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_B0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        html: '<hr>'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '19.Ensarta seis o mas cuentas?',
                                                                                        name: '19.Ensarta seis o mas cuentas?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_B19',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_BClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_B0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '20.Copia linea horizontal y vertical?',
                                                                                        name: '20.Copia linea horizontal y vertical?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_B20',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_BClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_B0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '21.Separa objetos grandes y pequeños?',
                                                                                        name: '21.Separa objetos grandes y pequeños?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_B21',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_BClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_B0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        html: '<hr>'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '22.Figura humana rudimentaria 1?',
                                                                                        name: '22.Figura humana rudimentaria 1?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_B22',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_BClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_B0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '23.Corta papel con tijeras?<br>&nbsp;',
                                                                                        name: '23.Corta papel con tijeras?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_B23',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_BClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_B0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '24.Copia cuadrado y circulo?',
                                                                                        name: '24.Copia cuadrado y circulo?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_B24',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_BClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_B0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        html: '<hr>'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '25.Figura humana rudimentaria 2?',
                                                                                        name: '25.Figura humana rudimentaria 2?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_B25',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_BClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_B0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '26.Agrupa por color y forma?',
                                                                                        name: '26.Agrupa por color y forma?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_B26',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_BClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_B0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '27.Dibuja escalera (imita)?<br>&nbsp;',
                                                                                        name: '27.Dibuja escalera (imita)?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_B27',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_BClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_B0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        html: '<hr>'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '28.Agrupa por color, forma y tamaño?',
                                                                                        name: '28.Agrupa por color, forma y tamaño?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_B28',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_BClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_B0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '29.Reconstruye escalera 10 cubos?',
                                                                                        name: '29.Reconstruye escalera 10 cubos?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_B29',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_BClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_B0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '30.Dibuja casa?<br>&nbsp;',
                                                                                        name: '30.Dibuja casa?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_B30',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_BClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_BCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_B0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_B30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        html: '<hr>'
                                                                                    },
                                                                                    {
                                                                                        html: '<hr>'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'numberfield',
                                                                                        name: 'Calificacion Motricidad Fina Adaptativa',
                                                                                        fieldLabel: 'Calificacion Motricidad Fina Adaptativa',
                                                                                        width: 50,
                                                                                        minValue: 0,
                                                                                        value: 0,
                                                                                        decimalPrecision: 0,
                                                                                        allowBlank: true,
                                                                                        id: 'intEVALDESACyD_BCalificacion'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        name: 'Clasificacion Motricidad Fina Adaptativa',
                                                                                        fieldLabel: 'Clasificacion Motricidad Fina Adaptativa',
                                                                                        width: 50,
                                                                                        allowBlank: true,
                                                                                        id: 'strEVALDESACyD_BClasificacion'
                                                                                    }
                                                                                ]
                                                                            },
                                                                            {
                                                                                xtype: 'panel',
                                                                                layout: 'form',
                                                                                labelWidth: 150,
                                                                                labelSeparator: '',
                                                                                width: 210,
                                                                                height: 1600,
                                                                                title: '<center>AUDICION Y LENGUUAJE</center>',
                                                                                items: [
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '0. Se sobresalta con ruido?<br>&nbsp;<br>&nbsp;',
                                                                                        name: '0. Se sobresalta con ruido?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_C0',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_CClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_C0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        html: '<hr>'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '1. Busca Sonido con la Mirada?',
                                                                                        name: '1. Busca Sonido con la Mirada?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_C1',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_CClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_C0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '2. Dos Sonidos Guturales Diferentes?',
                                                                                        name: '2. Dos Sonidos Guturales Diferentes?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_C2',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_CClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_C0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '3. Balbucea con las Personas?',
                                                                                        name: '3. Balbucea con las Personas?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_C3',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_CClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_C0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        html: '<hr>'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '4. Cuatro o mas sonidos diferentes?',
                                                                                        name: '4. Cuatro o mas sonidos diferentes?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_C4',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_CClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_C0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '5. Rie a "carcajadas"?<br>&nbsp;',
                                                                                        name: '5. Rie a "carcajadas"',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_C5',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_CClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_C0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '6. Reacciona cuando se llama?',
                                                                                        name: '6. Reacciona cuando se llama?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_C6',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_CClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_C0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        html: '<hr>'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '7. Pronuncia tres o mas silabas?',
                                                                                        name: '7. Pronuncia tres o mas silabas?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_C7',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_CClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_C0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '8. Hace sonar la campanilla?&nbsp;',
                                                                                        name: '8. Hace sonar la campanilla?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_C8',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_CClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_C0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '9. Una palabra clara?<br>&nbsp;',
                                                                                        name: '9. Una palabra clara?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_C9',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_CClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_C0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        html: '<hr>'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '10.Niega con la Cabeza?<br>&nbsp;',
                                                                                        name: '10.Niega con la Cabeza?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_C10',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_CClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_C0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '11.Llama a la madre o acompañante?',
                                                                                        name: '11.Llama a la madre o acompañante?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_C11',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_CClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_C0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '12.Entiende orden sencilla?<br>&nbsp;',
                                                                                        name: '12.Entiende orden sencilla?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_C12',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_CClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_C0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        html: '<hr>'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '13.Reconoce tres objetos?<br>&nbsp;',
                                                                                        name: '13.Reconoce tres objetos?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_C13',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_CClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_C0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '14.Combina dos palabras?<br>&nbsp;',
                                                                                        name: '14.Combina dos palabras?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_C14',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_CClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_C0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '15.Reconoce seis objetos?<br>&nbsp;',
                                                                                        name: '15.Reconoce seis objetos?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_C15',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_CClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_C0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        html: '<hr>'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '16.Nombra cinco objetos?<br>&nbsp;',
                                                                                        name: '16.Nombra cinco objetos?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_C16',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_CClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_C0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '17.Usa fraces de tres palabras?',
                                                                                        name: '17.Usa fraces de tres palabras?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_C17',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_CClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_C0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '18.Mas de veinte palabras claras?',
                                                                                        name: '18.Mas de veinte palabras claras?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_C18',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_CClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_C0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        html: '<hr>'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '19.Dice su nombre completo?',
                                                                                        name: '19.Dice su nombre completo?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_C19',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_CClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_C0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '20.Conoce: Alto, bajo, grande, pequeño?',
                                                                                        name: '20.Conoce: Alto, bajo, grande, pequeño?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_C20',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_CClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_C0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '21.Usa oraciones completas?',
                                                                                        name: '21.Usa oraciones completas?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_C21',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_CClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_C0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        html: '<hr>'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '22.Define por uso cinco objetos?',
                                                                                        name: '22.Define por uso cinco objetos?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_C22',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_CClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_C0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '23.Repite tres digitos?<br>&nbsp;',
                                                                                        name: '23.Repite tres digitos?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_C23',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_CClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_C0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '24.Describe bien el dibujo?<br>&nbsp;',
                                                                                        name: '24.Describe bien el dibujo?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_C24',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_CClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_C0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        html: '<hr>'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '25.Cuenta los dedos de la mano?',
                                                                                        name: '25.Cuenta los dedos de la mano?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_C25',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_CClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_C0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '26.Distingue: Adelante, atras, arriba, abajo?',
                                                                                        name: '26.Distingue: Adelante, atras, arriba, abajo?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_C26',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_CClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_C0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '27.Nombra cuatro, cinco colores?',
                                                                                        name: '27.Nombra cuatro, cinco colores?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_C27',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_CClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_C0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        html: '<hr>'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '28.Expresa opiniones?<br>&nbsp;',
                                                                                        name: '28.Expresa opiniones?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_C28',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_CClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_C0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '29.Conoce izquierda, derecha?',
                                                                                        name: '29.Conoce izquierda, derecha?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_C29',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_CClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_C0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '30.Conoce dias de la semana?',
                                                                                        name: '30.Conoce dias de la semana?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_C30',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_CClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_CCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_C0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_C30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        html: '<hr>'
                                                                                    },
                                                                                    {
                                                                                        html: '<hr>'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'numberfield',
                                                                                        name: 'Calificacion Audicion y Lenguaje',
                                                                                        fieldLabel: 'Calificacion Audicion y Lenguaje',
                                                                                        width: 50,
                                                                                        minValue: 0,
                                                                                        value: 0,
                                                                                        decimalPrecision: 0,
                                                                                        allowBlank: true,
                                                                                        id: 'intEVALDESACyD_CCalificacion'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        name: 'Clasificacion Audicion y Lenguaje',
                                                                                        fieldLabel: 'Clasificacion Audicion y Lenguaje',
                                                                                        width: 50,
                                                                                        allowBlank: true,
                                                                                        id: 'strEVALDESACyD_CClasificacion'
                                                                                    }
                                                                                ]
                                                                            },
                                                                            {
                                                                                xtype: 'panel',
                                                                                layout: 'form',
                                                                                labelWidth: 150,
                                                                                labelSeparator: '',
                                                                                width: 210,
                                                                                height: 1600,
                                                                                title: '<center>PERSONA SOCIAL</center>',
                                                                                items: [
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '0. Sigue movimiento del rostro?<br>&nbsp;',
                                                                                        name: '0. Sigue movimiento del rostro?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_D0',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_DClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_D0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        html: '<hr>'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '1. Reconoce a la madre?<br>&nbsp;',
                                                                                        name: '1. Reconoce a la madre?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_D1',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_DClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_D0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '2. Sonrie al acariciarlo?<br>&nbsp;',
                                                                                        name: '2. Sonrie al acariciarlo?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_D2',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_DClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_D0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '3. Se voltea cuando se le habla?',
                                                                                        name: '3. Se voltea cuando se le habla?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_D3',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_DClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_D0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        html: '<hr>'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '4. Coge mano del examinador?',
                                                                                        name: '4. Coge mano del examinador?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_D4',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_DClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_D0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '5. Acepta y coge juguete?<br>&nbsp;',
                                                                                        name: '5. Acepta y coge juguete?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_D5',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_DClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_D0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '6. Pone atencion a la conversacion?',
                                                                                        name: '6. Pone atencion a la conversacion?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_D6',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_DClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_D0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        html: '<hr>'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '7. Ayuda a sostener tasa para beber?',
                                                                                        name: '7. Ayuda a sostener tasa para beber?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_D7',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_DClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_D0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '8. Reacciona a imagen en el espejo?',
                                                                                        name: '8. Reacciona a imagen en el espejo?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_D8',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_DClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_D0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '9. Imita aplausos?<br>&nbsp;',
                                                                                        name: '9. Imita aplausos?<br>',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_D9',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_DClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_D0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        html: '<hr>'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '10.Entrega juguetes al examinador?',
                                                                                        name: '10.Entrega juguetes al examinador?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_D10',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_DClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_D0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '11.Pide un objeto o juguete?',
                                                                                        name: '11.Pide un objeto o juguete?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_D11',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_DClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_D0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '12.Bebe en tasa solo?<br>&nbsp;',
                                                                                        name: '12.Bebe en tasa solo',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_D12',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_DClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_D0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        html: '<hr>'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '13.Señala una prenda de vestir?',
                                                                                        name: '13.Señala una prenda de vestir?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_D13',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_DClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_D0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '14.Señala dos partes del cuerpo?',
                                                                                        name: '14.Señala dos partes del cuerpo?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_D14',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_DClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_D0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '15. Avisa higiene personal?<br>&nbsp;',
                                                                                        name: '15. Avisa higiene personal?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_D15',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_DClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_D0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        html: '<hr>'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '16.Señala cinco partes del cuerpo?',
                                                                                        name: '16.Señala cinco partes del cuerpo?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_D16',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_DClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_D0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '17.Trata de contar experiencias?',
                                                                                        name: '17.Trata de contar experiencias?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_D17',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_DClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_D0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '18.Control diurno de orina?<br>&nbsp;',
                                                                                        name: '18.Control diurno de orina?',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_D18',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_DClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_D0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        html: '<hr>'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '19.Diferencia niño-niña?<br>&nbsp;',
                                                                                        name: '19.Diferencia niño-niña',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_D19',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_DClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_D0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '20.Dice nombre Papa-Mama?',
                                                                                        name: '20.Dice nombre Papa-Mama',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_D20',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_DClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_D0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '21.Se lava solo Manos y Cara',
                                                                                        name: '21.Se lava solo Manos y Cara',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_D21',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_DClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_D0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        html: '<hr>'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '22. Puede Desvestirse Solo<br>&nbsp;',
                                                                                        name: '22. Puede Desvestirse Solo',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_D22',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_DClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_D0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '23. Comparte Juego con otros Niños',
                                                                                        name: '23. Comparte Juego con otros Niños',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_D23',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_DClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_D0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '24. Tiene Amigo Especial<br>&nbsp;',
                                                                                        name: '24. Tiene Amigo Especial',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_D24',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_DClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_D0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        html: '<hr>'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '25. Puede Vestirse y Desvestirse Solo',
                                                                                        name: '25. Puede Vestirse y Desvestirse Solo',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_D25',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_DClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_D0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '26. Sabe Cuantos Años Tiene',
                                                                                        name: '26. Sabe Cuantos Años Tiene',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_D26',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_DClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_D0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '27. Organiza Juegos<br>&nbsp;',
                                                                                        name: '27. Organiza Juegos',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_D27',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_DClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_D0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        html: '<hr>'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '28. Hace Mandados<br>&nbsp;',
                                                                                        name: '28. Hace Mandados',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_D28',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_DClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_D0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '29. Conoce Nombre Barrio o Pueblo de Recidencia',
                                                                                        name: '29. Conoce Nombre Barrio o Pueblo de Recidencia',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_D29',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_DClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_D0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        xtype: 'combo',
                                                                                        width: 50,
                                                                                        fieldLabel: '30. Comenta Vida Familiar<br>&nbsp;',
                                                                                        name: '30. Comenta Vida Familiar',
                                                                                        allowBlank: true,
                                                                                        store: 'StoreEscalaValoracion',
                                                                                        valueField: 'Valor',
                                                                                        displayField: 'Descripcion',
                                                                                        mode: 'local',
                                                                                        forceSelection: true,
                                                                                        typeAhead: true,
                                                                                        typeAheadDelay: 10,
                                                                                        triggerAction: 'all',
                                                                                        value: 0,
                                                                                        id: 'intEVALDESACyD_D30',
                                                                                        listeners:{
                                                                                            change : function(f,pNew, pOld){
                                                                                                if(pNew == null){
                                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(0);
                                                                                                    Ext.getCmp('strEVALDESACyD_DClasificacion').setValue(null);
                                                                                                }else{
                                                                                                    Ext.getCmp('intEVALDESACyD_DCalificacion').setValue(parseInt(Ext.getCmp('intEVALDESACyD_D0').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D1').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D2').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D3').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D4').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D5').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D6').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D7').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D8').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D9').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D10').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D12').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D13').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D14').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D15').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D16').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D17').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D18').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D19').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D20').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D21').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D22').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D23').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D24').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D25').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D26').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D27').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D28').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D29').getValue()) + parseInt(Ext.getCmp('intEVALDESACyD_D30').getValue())); 
                                                                                                    Ext.getCmp('intEVALDESACyD_TotalCalificacion').setValue(Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() + Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() + Ext.getCmp('intEVALDESACyD_DCalificacion').getValue());
                                                                                                    clasificacionEscala()
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    },
                                                                                    {
                                                                                        html: '<hr>'
                                                                                    },
                                                                                    {
                                                                                        html: '<hr>'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'numberfield',
                                                                                        name: 'Calificacion  Persona Social',
                                                                                        fieldLabel: 'Calificacion  Persona Social<br>&nbsp;',
                                                                                        width: 50,
                                                                                        minValue: 0,
                                                                                        value: 0,
                                                                                        decimalPrecision: 0,
                                                                                        allowBlank: true,
                                                                                        id: 'intEVALDESACyD_DCalificacion'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        name: 'Clasificacion  Persona Social',
                                                                                        fieldLabel: 'Clasificacion  Persona Social',
                                                                                        width: 50,
                                                                                        allowBlank: true,
                                                                                        id: 'strEVALDESACyD_DClasificacion'
                                                                                    }
                                                                                ]
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        name: 'Calificacion Total',
                                                                        fieldLabel: 'Calificacion Total',
                                                                        width: 100,
                                                                        minValue: 0,
                                                                        value: 0,
                                                                        decimalPrecision: 0,
                                                                        allowBlank: true,
                                                                        id: 'intEVALDESACyD_TotalCalificacion'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Clasificacion Total',
                                                                        fieldLabel: 'Clasificacion Total',
                                                                        width: 100,
                                                                        allowBlank: true,
                                                                        id: 'strEVALDESACyD_TotalClasificacion'
                                                                    },
                                                                    {
                                                                        html: '<br>'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                layout: 'table',
                                                                anchor: '100%',
                                                                padding: 0,
                                                                layoutConfig: {
                                                                    columns: 3
                                                                },
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'panel',
                                                                        layout: 'form',
                                                                        width: 450,
                                                                        autoHeight: true,
                                                                        items: [
                                                                            {
                                                                                xtype: 'textfield',
                                                                                name:'Motora',
                                                                                fieldLabel:'Motora',
                                                                                width: 300,
                                                                                id: 'strValDesConMotora'
                                                                            },
                                                                            {
                                                                                xtype: 'textfield',
                                                                                name:'Adaptativa',
                                                                                fieldLabel:'Adaptativa',
                                                                                width: 300,
                                                                                id: 'strValDesConAdaptativa'
                                                                            },
                                                                            {
                                                                                xtype: 'textfield',
                                                                                name:'Lenguaje',
                                                                                fieldLabel:'Lenguaje',
                                                                                width: 300,
                                                                                id: 'strValDesConLenguaje'
                                                                            },
                                                                            {
                                                                                xtype: 'textfield',
                                                                                name:'Personal Social',
                                                                                fieldLabel:'Personal Social',
                                                                                width: 300,
                                                                                id: 'strValDesConPerSocial'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'panel',
                                                                        title: '<center>CURVA PESO</center>',
                                                                        layout: 'form',
                                                                        width: 200,
                                                                        autoHeight: true,
                                                                        id: 'paFisExpCurPeso',
                                                                        items: [
                                                                            {
                                                                                xtype: 'combo',
                                                                                width: 60,
                                                                                forceSelection: true,
                                                                                emptyText: 'SI/NO',
                                                                                mode: 'local',
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 50,
                                                                                listEmptyText: '',
                                                                                triggerAction: 'all',
                                                                                store:'StoreSiNo',
                                                                                fieldLabel:'Satisfactoria',
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                name:'Satisfactoria',
                                                                                id: 'strCurPesoSatisfactorio'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'panel',
                                                                        title: '<center>CURVA TALLA</center>',
                                                                        layout: 'form',
                                                                        width: 200,
                                                                        autoHeight: true,
                                                                        id: 'paFisExpCurTalla',
                                                                        items: [
                                                                            {
                                                                                xtype: 'combo',
                                                                                width: 60,
                                                                                forceSelection: true,
                                                                                emptyText: 'SI/NO',
                                                                                mode: 'local',
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 50,
                                                                                listEmptyText: '',
                                                                                triggerAction: 'all',
                                                                                store:'StoreSiNo',
                                                                                fieldLabel:'Satisfactoria',
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                name:'Satisfactoria',
                                                                                id: 'strCurTalSatisfactorio'
                                                                            }
                                                                        ]
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'fieldset',
                                                        title: 'ESTADO NUTRICIONAL',
                                                        layout: 'form',
                                                        collapsible: true,
                                                        titleCollapse: true,
                                                        anchor: '100%',
                                                        autoHeight: true,
                                                        padding: 7,
                                                        items: [
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Estado',
                                                                        fieldLabel: 'Estado',
                                                                        width: 250,
                                                                        allowBlank: true,
                                                                        store: stEstadoNutricional,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strEstadoNutricional',
                                                                        listeners:{
                                                                            change : function( t, newValue, oldValue){
                                                                                if(newValue == "DESNUTRICION"){
                                                                                    Ext.getCmp('strDesnutricion').allowBlank = false;
                                                                                    Ext.getCmp('strDesnutricion').enable();
                                                                                }else{
                                                                                    Ext.getCmp('strDesnutricion').allowBlank = true;
                                                                                    Ext.getCmp('strDesnutricion').disable();
                                                                                    Ext.getCmp('strDesnutricion').clearInvalid();
                                                                                    Ext.getCmp('strDesnutricion').setValue(null);
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        html: ' - '
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Estado',
                                                                        fieldLabel: 'Estado',
                                                                        width: 250,
                                                                        allowBlank: true,
                                                                        disabled: true,
                                                                        store: stDesnutricion,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strDesnutricion'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        width: 60,
                                                        forceSelection: true,
                                                        emptyText: 'SI/NO',
                                                        mode: 'local',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        listEmptyText: '',
                                                        triggerAction: 'all',
                                                        store:'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        name:'Remision',
                                                        fieldLabel:'Remision',
                                                        id: 'strExpFisRemision'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'datefield',
                                                                width: 120,
                                                                fieldLabel: 'Fecha Probable Proxima Cita',
                                                                name: 'Fecha Probable Proxima Cita',
                                                                allowBlank: true,
                                                                emptyText: '(dia/mes/año) ',
                                                                style: 'text-align:center;',
                                                                id: 'fecProximaCita'
                                                            },
                                                            {
                                                                html: 'Profesional que Atiende'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Profesional que Atiende',
                                                                width: 250,
                                                                allowBlank: true,
                                                                store: stProfesionalAtiende,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strProximaCitaProfesionalAtiende'
                                                            }
                                                        ]
                                                    }
                                                ]                                                
                                            },
                                            // AQUI FINALIZAN CAMBIOS 
                                            {
                                                xtype: 'fieldset',
                                                title: 'RIPS',
                                                layout: 'form',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                id: 'fsRips',
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: false,
                                                                fieldLabel: 'Diagnostico Principal',
                                                                id: 'sysDiagPpalHC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request({
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagPpalHC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                        Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagPpalHCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Principal',
                                                                id: 'btnSearchDiagPpalHC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagPpalHC','sysDiagPpalHCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.1',
                                                                id: 'sysDiagRel1HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel1HC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagRel1HCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel1HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado1',
                                                                id: 'btnSearchDiagRel1HC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel1HC','sysDiagRel1HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.2',
                                                                id: 'sysDiagRel2HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel2HC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagRel2HCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel2HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado2',
                                                                id: 'btnSearchDiagRel2HC1',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel2HC','sysDiagRel2HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.3',
                                                                id: 'sysDiagRel3HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel3HC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagRel3HCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel3HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado3',
                                                                id: 'btnSearchDiagRel3HC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel3HC','sysDiagRel3HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Tipo de Diagnostico',
                                                        width:750,
                                                        name: 'Tipo de Diagnostico',
                                                        allowBlank: false,
                                                        store: 'StoreTipoDiagnostico',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        id: 'sysTipoDiagosticoHC'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Finalidad Consulta',
                                                        width:750,
                                                        name: 'Finalidad Consulta',
                                                        allowBlank: false,
                                                        store: 'StoreFinalidadConsulta',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        value: 04,
                                                        id: 'sysFinalidadConsultaHC'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Causa Externa',
                                                        width:750,
                                                        name: 'Causa Externa',
                                                        allowBlank: false,
                                                        store: 'StoreCausaExterna',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        value: 13,
                                                        id: 'sysCausaExternaHC'
                                                    }                            
                                                ]
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Medicamentos',
                                height: 352,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaMedicamentos',
                                items: [
                                    xSolMX
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Servicios',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaServicios',
                                items: [
                                    xSolEXA
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Remisiones',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaRemisiones',
                                items: [
                                    xSolREM
                                ]
                            }
                            /*,
                            {
                                xtype: 'panel',
                                title: 'Solicitud CTC',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaCTC',
                                items: [
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Consentimientos Informados',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaConsentimientos',
                                items: [
                                ]
                            },*/
                        ]
                    }
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Salir',
                            iconCls: 'btnSalir',
                            id: 'btnSalirEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 1) 
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    if (Ext.getCmp('sysUsaGridSalida').getValue() == 1){
                                                        Ext.getCmp('gridFormulario').store.reload();
                                                    }
                                                    Ext.getCmp('winHC').close();
                                                }
                                            }
                                        });
                                    else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Usted No ha Guardado la Evolución del Paciente y Se Perdera la Información, Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.getCmp('winHC').close();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                },
                tbar:{
                    items: [
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Ver Historia Clínica',
                            iconCls: 'btnVerHC',
                            id: 'btnVerHC',
                            listeners:{
                                click : function(){
                                    var cmpResumenHC = new winFrmVerHistorialHC({
                                        renderTo: Ext.getBody()
                                    });
                                    Ext.getCmp('winViewEvolucionHC').title = "PACIENTE: " + Ext.getCmp('sysPacienteHC').getValue();
                                    Ext.getCmp('gridHistorialEvoluciones').store.load({
                                        params: {
                                            pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                                            pPaciente: Ext.getCmp('sysIdPacienteHC').getValue()
                                        }
                                    });
                                    cmpResumenHC.show();
                                }
                            }
                        },
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar Evolución',
                            iconCls: 'btnGuardar',
                            id: 'btnGuardarEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 0) 
                                    {
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Guardar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnGuardarRegistros();
                                                }
                                            }
                                        });
                                    }else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Modificar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnModificarRegistros();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                }
            }
        ];      
        winHCCrecimientoyDesarrollo001Ui.superclass.initComponent.call(this);
    }
});

function fnGuardarRegistros(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc.php',
            params:{
                task: 'guardar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pidPlantillaHC : Ext.getCmp('sysIdCodPlantillaHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1); 
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function fnModificarRegistros(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc.php',
            params:{
                task: 'modificar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1);
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function clasificacionEscala(){
    var valFecha1 = 0;
    var pFec2Anio = 0;
    var pFec2Mes = 0;
    var pFec2Dia = 0;
    var valFecha2 = 0;

    valFecha1 = Ext.getCmp('sysFechaHC').getValue();
    pFec2Anio = Ext.getCmp('sysFecNacPacHC').getValue().substr(6,4);
    pFec2Mes = Ext.getCmp('sysFecNacPacHC').getValue().substr(3,2);
    pFec2Dia = Ext.getCmp('sysFecNacPacHC').getValue().substr(0,2);
    
    valFecha2 =  pFec2Anio + "/" + pFec2Mes + "/" + pFec2Dia;

    MesesCumplidos = MostrarEdadMeses(valFecha1, valFecha2);
    
    //CRECIMIENTO Y DESARROLLO MOTRICIDAD GRUESA
    if(MesesCumplidos <= 3 && Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() <= 1){
        Ext.getCmp('strEVALDESACyD_AClasificacion').setValue("Alerta");
    }else{
        if(MesesCumplidos <= 3 && Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() >= 2 && Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() <= 3){
            Ext.getCmp('strEVALDESACyD_AClasificacion').setValue("Medio");
        }else{
            if(MesesCumplidos <= 3 && Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() >= 4 && Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() <= 5){
                Ext.getCmp('strEVALDESACyD_AClasificacion').setValue("Medio Alto");
            }else{
                if(MesesCumplidos >= 4 && MesesCumplidos <= 6 && Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() <= 4){
                    Ext.getCmp('strEVALDESACyD_AClasificacion').setValue("Alerta");
                }else{
                    if(MesesCumplidos >= 4 && MesesCumplidos <= 6 && Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() <= 5 && Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() <= 6){
                        Ext.getCmp('strEVALDESACyD_AClasificacion').setValue("Medio");
                    }else{
                        if(MesesCumplidos >= 4 && MesesCumplidos <= 6 && Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() <= 7 && Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() <= 9){
                            Ext.getCmp('strEVALDESACyD_AClasificacion').setValue("Medio Alto");
                        }else{
                            if(MesesCumplidos >= 7 && MesesCumplidos <= 9 && Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() <= 7){
                                Ext.getCmp('strEVALDESACyD_AClasificacion').setValue("Alerta");
                            }else{
                                if(MesesCumplidos >= 7 && MesesCumplidos <= 9 && Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() <= 8 && Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() <= 10){
                                    Ext.getCmp('strEVALDESACyD_AClasificacion').setValue("Medio");
                                }else{
                                    if(MesesCumplidos >= 7 && MesesCumplidos <= 9 && Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() <= 11 && Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() <= 13){
                                        Ext.getCmp('strEVALDESACyD_AClasificacion').setValue("Medio Alto");
                                    }else{
                                        if(MesesCumplidos >= 10 && MesesCumplidos <= 12 && Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() <= 11){
                                            Ext.getCmp('strEVALDESACyD_AClasificacion').setValue("Alerta");
                                        }else{
                                            if(MesesCumplidos >= 10 && MesesCumplidos <= 12 && Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() <= 12 && Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() <= 13){
                                                Ext.getCmp('strEVALDESACyD_AClasificacion').setValue("Medio");
                                            }else{
                                                if(MesesCumplidos >= 10 && MesesCumplidos <= 12 && Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() <= 14 && Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() <= 16){
                                                    Ext.getCmp('strEVALDESACyD_AClasificacion').setValue("Medio Alto");
                                                }else{
                                                    if(MesesCumplidos >= 13 && MesesCumplidos <= 18 && Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() <= 13){
                                                        Ext.getCmp('strEVALDESACyD_AClasificacion').setValue("Alerta");
                                                    }else{
                                                        if(MesesCumplidos >= 13 && MesesCumplidos <= 18 && Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() <= 14 && Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() <= 16){
                                                            Ext.getCmp('strEVALDESACyD_AClasificacion').setValue("Medio");
                                                        }else{
                                                            if(MesesCumplidos >= 13 && MesesCumplidos <= 18 && Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() <= 17 && Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() <= 19){
                                                                Ext.getCmp('strEVALDESACyD_AClasificacion').setValue("Medio Alto");
                                                            }else{
                                                                if(MesesCumplidos >= 19 && MesesCumplidos <= 24 && Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() <= 16){
                                                                    Ext.getCmp('strEVALDESACyD_AClasificacion').setValue("Alerta");
                                                                }else{
                                                                    if(MesesCumplidos >= 19 && MesesCumplidos <= 24 && Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() <= 17 && Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() <= 19){
                                                                        Ext.getCmp('strEVALDESACyD_AClasificacion').setValue("Medio");
                                                                    }else{
                                                                        if(MesesCumplidos >= 19 && MesesCumplidos <= 24 && Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() <= 20 && Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() <= 23){
                                                                            Ext.getCmp('strEVALDESACyD_AClasificacion').setValue("Medio Alto");
                                                                        }else{
                                                                            if(MesesCumplidos >= 25 && MesesCumplidos <= 36 && Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() <= 19){
                                                                                Ext.getCmp('strEVALDESACyD_AClasificacion').setValue("Alerta");
                                                                            }else{
                                                                                if(MesesCumplidos >= 25 && MesesCumplidos <= 36 && Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() <= 20 && Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() <= 23){
                                                                                    Ext.getCmp('strEVALDESACyD_AClasificacion').setValue("Medio");
                                                                                }else{
                                                                                    if(MesesCumplidos >= 25 && MesesCumplidos <= 36 && Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() <= 24 && Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() <= 27){
                                                                                        Ext.getCmp('strEVALDESACyD_AClasificacion').setValue("Medio Alto");
                                                                                    }else{
                                                                                        if(MesesCumplidos >= 37 && MesesCumplidos <= 48 && Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() <= 22){
                                                                                            Ext.getCmp('strEVALDESACyD_AClasificacion').setValue("Alerta");
                                                                                        }else{
                                                                                            if(MesesCumplidos >= 37 && MesesCumplidos <= 48 && Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() <= 23 && Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() <= 26){
                                                                                                Ext.getCmp('strEVALDESACyD_AClasificacion').setValue("Medio");
                                                                                            }else{
                                                                                                if(MesesCumplidos >= 37 && MesesCumplidos <= 48 && Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() <= 27 && Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() <= 29){
                                                                                                    Ext.getCmp('strEVALDESACyD_AClasificacion').setValue("Medio Alto");
                                                                                                }else{
                                                                                                    if(MesesCumplidos >= 49 && MesesCumplidos <= 60 && Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() <= 26){
                                                                                                        Ext.getCmp('strEVALDESACyD_AClasificacion').setValue("Alerta");
                                                                                                    }else{
                                                                                                        if(MesesCumplidos >= 49 && MesesCumplidos <= 60 && Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() <= 27 && Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() <= 29){
                                                                                                            Ext.getCmp('strEVALDESACyD_AClasificacion').setValue("Medio");
                                                                                                        }else{
                                                                                                            if(MesesCumplidos >= 49 && MesesCumplidos <= 60 && Ext.getCmp('intEVALDESACyD_ACalificacion').getValue() == 30){
                                                                                                                Ext.getCmp('strEVALDESACyD_AClasificacion').setValue("Medio Alto");
                                                                                                            }else{
                                                                                                                Ext.getCmp('strEVALDESACyD_AClasificacion').setValue("Alto");
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }
        
    //CRECIMIENTO Y DESARROLLO MOTRICIDAD FINA
    if(MesesCumplidos <= 3 && Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() <= 1){
        Ext.getCmp('strEVALDESACyD_BClasificacion').setValue("Alerta");
    }else{
        if(MesesCumplidos <= 3 && Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() >= 2 && Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() <= 3){
            Ext.getCmp('strEVALDESACyD_BClasificacion').setValue("Medio");
        }else{
            if(MesesCumplidos <= 3 && Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() >= 4 && Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() <= 5){
                Ext.getCmp('strEVALDESACyD_BClasificacion').setValue("Medio Alto");
            }else{
                if(MesesCumplidos >= 4 && MesesCumplidos <= 6 && Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() <= 4){
                    Ext.getCmp('strEVALDESACyD_BClasificacion').setValue("Alerta");
                }else{
                    if(MesesCumplidos >= 4 && MesesCumplidos <= 6 && Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() <= 5 && Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() <= 6){
                        Ext.getCmp('strEVALDESACyD_BClasificacion').setValue("Medio");
                    }else{
                        if(MesesCumplidos >= 4 && MesesCumplidos <= 6 && Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() <= 7 && Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() <= 9){
                            Ext.getCmp('strEVALDESACyD_BClasificacion').setValue("Medio Alto");
                        }else{
                            if(MesesCumplidos >= 7 && MesesCumplidos <= 9 && Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() <= 7){
                                Ext.getCmp('strEVALDESACyD_BClasificacion').setValue("Alerta");
                            }else{
                                if(MesesCumplidos >= 7 && MesesCumplidos <= 9 && Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() <= 8 && Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() <= 10){
                                    Ext.getCmp('strEVALDESACyD_BClasificacion').setValue("Medio");
                                }else{
                                    if(MesesCumplidos >= 7 && MesesCumplidos <= 9 && Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() <= 11 && Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() <= 13){
                                        Ext.getCmp('strEVALDESACyD_BClasificacion').setValue("Medio Alto");
                                    }else{
                                        if(MesesCumplidos >= 10 && MesesCumplidos <= 12 && Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() <= 9){
                                            Ext.getCmp('strEVALDESACyD_BClasificacion').setValue("Alerta");
                                        }else{
                                            if(MesesCumplidos >= 10 && MesesCumplidos <= 12 && Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() <= 10 && Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() <= 12){
                                                Ext.getCmp('strEVALDESACyD_BClasificacion').setValue("Medio");
                                            }else{
                                                if(MesesCumplidos >= 10 && MesesCumplidos <= 12 && Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() <= 13 && Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() <= 14){
                                                    Ext.getCmp('strEVALDESACyD_BClasificacion').setValue("Medio Alto");
                                                }else{
                                                    if(MesesCumplidos >= 13 && MesesCumplidos <= 18 && Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() <= 12){
                                                        Ext.getCmp('strEVALDESACyD_BClasificacion').setValue("Alerta");
                                                    }else{
                                                        if(MesesCumplidos >= 13 && MesesCumplidos <= 18 && Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() <= 13 && Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() <= 15){
                                                            Ext.getCmp('strEVALDESACyD_BClasificacion').setValue("Medio");
                                                        }else{
                                                            if(MesesCumplidos >= 13 && MesesCumplidos <= 18 && Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() <= 16 && Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() <= 18){
                                                                Ext.getCmp('strEVALDESACyD_BClasificacion').setValue("Medio Alto");
                                                            }else{
                                                                if(MesesCumplidos >= 19 && MesesCumplidos <= 24 && Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() <= 14){
                                                                    Ext.getCmp('strEVALDESACyD_BClasificacion').setValue("Alerta");
                                                                }else{
                                                                    if(MesesCumplidos >= 19 && MesesCumplidos <= 24 && Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() <= 15 && Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() <= 18){
                                                                        Ext.getCmp('strEVALDESACyD_BClasificacion').setValue("Medio");
                                                                    }else{
                                                                        if(MesesCumplidos >= 19 && MesesCumplidos <= 24 && Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() <= 19 && Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() <= 20){
                                                                            Ext.getCmp('strEVALDESACyD_BClasificacion').setValue("Medio Alto");
                                                                        }else{
                                                                            if(MesesCumplidos >= 25 && MesesCumplidos <= 36 && Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() <= 18){
                                                                                Ext.getCmp('strEVALDESACyD_BClasificacion').setValue("Alerta");
                                                                            }else{
                                                                                if(MesesCumplidos >= 25 && MesesCumplidos <= 36 && Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() <= 19 && Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() <= 21){
                                                                                    Ext.getCmp('strEVALDESACyD_BClasificacion').setValue("Medio");
                                                                                }else{
                                                                                    if(MesesCumplidos >= 25 && MesesCumplidos <= 36 && Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() <= 22 && Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() <= 24){
                                                                                        Ext.getCmp('strEVALDESACyD_BClasificacion').setValue("Medio Alto");
                                                                                    }else{
                                                                                        if(MesesCumplidos >= 37 && MesesCumplidos <= 48 && Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() <= 21){
                                                                                            Ext.getCmp('strEVALDESACyD_BClasificacion').setValue("Alerta");
                                                                                        }else{
                                                                                            if(MesesCumplidos >= 37 && MesesCumplidos <= 48 && Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() <= 22 && Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() <= 24){
                                                                                                Ext.getCmp('strEVALDESACyD_BClasificacion').setValue("Medio");
                                                                                            }else{
                                                                                                if(MesesCumplidos >= 37 && MesesCumplidos <= 48 && Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() <= 25 && Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() <= 28){
                                                                                                    Ext.getCmp('strEVALDESACyD_BClasificacion').setValue("Medio Alto");
                                                                                                }else{
                                                                                                    if(MesesCumplidos >= 49 && MesesCumplidos <= 60 && Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() <= 23){
                                                                                                        Ext.getCmp('strEVALDESACyD_BClasificacion').setValue("Alerta");
                                                                                                    }else{
                                                                                                        if(MesesCumplidos >= 49 && MesesCumplidos <= 60 && Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() <= 24 && Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() <= 28){
                                                                                                            Ext.getCmp('strEVALDESACyD_BClasificacion').setValue("Medio");
                                                                                                        }else{
                                                                                                            if(MesesCumplidos >= 49 && MesesCumplidos <= 60 && Ext.getCmp('intEVALDESACyD_BCalificacion').getValue() == 29){
                                                                                                                Ext.getCmp('strEVALDESACyD_BClasificacion').setValue("Medio Alto");
                                                                                                            }else{
                                                                                                                Ext.getCmp('strEVALDESACyD_BClasificacion').setValue("Alto");
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }
    
    //CRECIMIENTO Y DESARROLLO AUDICION LENGUAJE
    if(MesesCumplidos <= 3 && Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() <= 1){
        Ext.getCmp('strEVALDESACyD_CClasificacion').setValue("Alerta");
    }else{
        if(MesesCumplidos <= 3 && Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() >= 2 && Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() <= 3){
            Ext.getCmp('strEVALDESACyD_CClasificacion').setValue("Medio");
        }else{
            if(MesesCumplidos <= 3 && Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() >= 4 && Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() <= 5){
                Ext.getCmp('strEVALDESACyD_CClasificacion').setValue("Medio Alto");
            }else{
                if(MesesCumplidos >= 4 && MesesCumplidos <= 6 && Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() <= 4){
                    Ext.getCmp('strEVALDESACyD_CClasificacion').setValue("Alerta");
                }else{
                    if(MesesCumplidos >= 4 && MesesCumplidos <= 6 && Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() <= 5 && Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() <= 6){
                        Ext.getCmp('strEVALDESACyD_CClasificacion').setValue("Medio");
                    }else{
                        if(MesesCumplidos >= 4 && MesesCumplidos <= 6 && Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() <= 7 && Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() <= 9){
                            Ext.getCmp('strEVALDESACyD_CClasificacion').setValue("Medio Alto");
                        }else{
                            if(MesesCumplidos >= 7 && MesesCumplidos <= 9 && Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() <= 7){
                                Ext.getCmp('strEVALDESACyD_CClasificacion').setValue("Alerta");
                            }else{
                                if(MesesCumplidos >= 7 && MesesCumplidos <= 9 && Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() <= 8 && Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() <= 10){
                                    Ext.getCmp('strEVALDESACyD_CClasificacion').setValue("Medio");
                                }else{
                                    if(MesesCumplidos >= 7 && MesesCumplidos <= 9 && Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() <= 11 && Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() <= 13){
                                        Ext.getCmp('strEVALDESACyD_CClasificacion').setValue("Medio Alto");
                                    }else{
                                        if(MesesCumplidos >= 10 && MesesCumplidos <= 12 && Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() <= 9){
                                            Ext.getCmp('strEVALDESACyD_CClasificacion').setValue("Alerta");
                                        }else{
                                            if(MesesCumplidos >= 10 && MesesCumplidos <= 12 && Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() <= 10 && Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() <= 12){
                                                Ext.getCmp('strEVALDESACyD_CClasificacion').setValue("Medio");
                                            }else{
                                                if(MesesCumplidos >= 10 && MesesCumplidos <= 12 && Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() <= 13 && Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() <= 14){
                                                    Ext.getCmp('strEVALDESACyD_CClasificacion').setValue("Medio Alto");
                                                }else{
                                                    if(MesesCumplidos >= 13 && MesesCumplidos <= 18 && Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() <= 12){
                                                        Ext.getCmp('strEVALDESACyD_CClasificacion').setValue("Alerta");
                                                    }else{
                                                        if(MesesCumplidos >= 13 && MesesCumplidos <= 18 && Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() <= 13 && Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() <= 14){
                                                            Ext.getCmp('strEVALDESACyD_CClasificacion').setValue("Medio");
                                                        }else{
                                                            if(MesesCumplidos >= 13 && MesesCumplidos <= 18 && Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() <= 15 && Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() <= 17){
                                                                Ext.getCmp('strEVALDESACyD_CClasificacion').setValue("Medio Alto");
                                                            }else{
                                                                if(MesesCumplidos >= 19 && MesesCumplidos <= 24 && Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() <= 13){
                                                                    Ext.getCmp('strEVALDESACyD_CClasificacion').setValue("Alerta");
                                                                }else{
                                                                    if(MesesCumplidos >= 19 && MesesCumplidos <= 24 && Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() <= 14 && Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() <= 17){
                                                                        Ext.getCmp('strEVALDESACyD_CClasificacion').setValue("Medio");
                                                                    }else{
                                                                        if(MesesCumplidos >= 19 && MesesCumplidos <= 24 && Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() <= 18 && Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() <= 20){
                                                                            Ext.getCmp('strEVALDESACyD_CClasificacion').setValue("Medio Alto");
                                                                        }else{
                                                                            if(MesesCumplidos >= 25 && MesesCumplidos <= 36 && Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() <= 17){
                                                                                Ext.getCmp('strEVALDESACyD_CClasificacion').setValue("Alerta");
                                                                            }else{
                                                                                if(MesesCumplidos >= 25 && MesesCumplidos <= 36 && Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() <= 18 && Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() <= 21){
                                                                                    Ext.getCmp('strEVALDESACyD_CClasificacion').setValue("Medio");
                                                                                }else{
                                                                                    if(MesesCumplidos >= 25 && MesesCumplidos <= 36 && Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() <= 22 && Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() <= 24){
                                                                                        Ext.getCmp('strEVALDESACyD_CClasificacion').setValue("Medio Alto");
                                                                                    }else{
                                                                                        if(MesesCumplidos >= 37 && MesesCumplidos <= 48 && Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() <= 21){
                                                                                            Ext.getCmp('strEVALDESACyD_CClasificacion').setValue("Alerta");
                                                                                        }else{
                                                                                            if(MesesCumplidos >= 37 && MesesCumplidos <= 48 && Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() <= 22 && Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() <= 25){
                                                                                                Ext.getCmp('strEVALDESACyD_CClasificacion').setValue("Medio");
                                                                                            }else{
                                                                                                if(MesesCumplidos >= 37 && MesesCumplidos <= 48 && Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() <= 26 && Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() <= 29){
                                                                                                    Ext.getCmp('strEVALDESACyD_CClasificacion').setValue("Medio Alto");
                                                                                                }else{
                                                                                                    if(MesesCumplidos >= 49 && MesesCumplidos <= 60 && Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() <= 24){
                                                                                                        Ext.getCmp('strEVALDESACyD_CClasificacion').setValue("Alerta");
                                                                                                    }else{
                                                                                                        if(MesesCumplidos >= 49 && MesesCumplidos <= 60 && Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() <= 25 && Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() <= 28){
                                                                                                            Ext.getCmp('strEVALDESACyD_CClasificacion').setValue("Medio");
                                                                                                        }else{
                                                                                                            if(MesesCumplidos >= 49 && MesesCumplidos <= 60 && Ext.getCmp('intEVALDESACyD_CCalificacion').getValue() == 29){
                                                                                                                Ext.getCmp('strEVALDESACyD_CClasificacion').setValue("Medio Alto");
                                                                                                            }else{
                                                                                                                Ext.getCmp('strEVALDESACyD_CClasificacion').setValue("Alto");
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }
    
    //CRECIMIENTO Y DESARROLLO PERSONAL SOCIAL
    if(MesesCumplidos <= 3 && Ext.getCmp('intEVALDESACyD_DCalificacion').getValue() <= 1){
        Ext.getCmp('strEVALDESACyD_DClasificacion').setValue("Alerta");
    }else{
        if(MesesCumplidos <= 3 && Ext.getCmp('intEVALDESACyD_DCalificacion').getValue() >= 2 && Ext.getCmp('intEVALDESACyD_DCalificacion').getValue() <= 3){
            Ext.getCmp('strEVALDESACyD_DClasificacion').setValue("Medio");
        }else{
            if(MesesCumplidos <= 3 && Ext.getCmp('intEVALDESACyD_DCalificacion').getValue() >= 4 && Ext.getCmp('intEVALDESACyD_DCalificacion').getValue() <= 5){
                Ext.getCmp('strEVALDESACyD_DClasificacion').setValue("Medio Alto");
            }else{
                if(MesesCumplidos >= 4 && MesesCumplidos <= 6 && Ext.getCmp('intEVALDESACyD_DCalificacion').getValue() <= 4){
                    Ext.getCmp('strEVALDESACyD_DClasificacion').setValue("Alerta");
                }else{
                    if(MesesCumplidos >= 4 && MesesCumplidos <= 6 && Ext.getCmp('intEVALDESACyD_DCalificacion').getValue() <= 5 && Ext.getCmp('intEVALDESACyD_DCalificacion').getValue() <= 6){
                        Ext.getCmp('strEVALDESACyD_DClasificacion').setValue("Medio");
                    }else{
                        if(MesesCumplidos >= 4 && MesesCumplidos <= 6 && Ext.getCmp('intEVALDESACyD_DCalificacion').getValue() <= 7 && Ext.getCmp('intEVALDESACyD_DCalificacion').getValue() <= 9){
                            Ext.getCmp('strEVALDESACyD_DClasificacion').setValue("Medio Alto");
                        }else{
                            if(MesesCumplidos >= 7 && MesesCumplidos <= 9 && Ext.getCmp('intEVALDESACyD_DCalificacion').getValue() <= 7){
                                Ext.getCmp('strEVALDESACyD_DClasificacion').setValue("Alerta");
                            }else{
                                if(MesesCumplidos >= 7 && MesesCumplidos <= 9 && Ext.getCmp('intEVALDESACyD_DCalificacion').getValue() <= 8 && Ext.getCmp('intEVALDESACyD_DCalificacion').getValue() <= 10){
                                    Ext.getCmp('strEVALDESACyD_DClasificacion').setValue("Medio");
                                }else{
                                    if(MesesCumplidos >= 7 && MesesCumplidos <= 9 && Ext.getCmp('intEVALDESACyD_DCalificacion').getValue() <= 11 && Ext.getCmp('intEVALDESACyD_DCalificacion').getValue() <= 13){
                                        Ext.getCmp('strEVALDESACyD_DClasificacion').setValue("Medio Alto");
                                    }else{
                                        if(MesesCumplidos >= 10 && MesesCumplidos <= 12 && Ext.getCmp('intEVALDESACyD_DCalificacion').getValue() <= 9){
                                            Ext.getCmp('strEVALDESACyD_DClasificacion').setValue("Alerta");
                                        }else{
                                            if(MesesCumplidos >= 10 && MesesCumplidos <= 12 && Ext.getCmp('intEVALDESACyD_DCalificacion').getValue() <= 10 && Ext.getCmp('intEVALDESACyD_DCalificacion').getValue() <= 12){
                                                Ext.getCmp('strEVALDESACyD_DClasificacion').setValue("Medio");
                                            }else{
                                                if(MesesCumplidos >= 10 && MesesCumplidos <= 12 && Ext.getCmp('intEVALDESACyD_DCalificacion').getValue() <= 13 && Ext.getCmp('intEVALDESACyD_DCalificacion').getValue() <= 14){
                                                    Ext.getCmp('strEVALDESACyD_DClasificacion').setValue("Medio Alto");
                                                }else{
                                                    if(MesesCumplidos >= 13 && MesesCumplidos <= 18 && Ext.getCmp('intEVALDESACyD_DCalificacion').getValue() <= 12){
                                                        Ext.getCmp('strEVALDESACyD_DClasificacion').setValue("Alerta");
                                                    }else{
                                                        if(MesesCumplidos >= 13 && MesesCumplidos <= 18 && Ext.getCmp('intEVALDESACyD_DCalificacion').getValue() <= 13 && Ext.getCmp('intEVALDESACyD_DCalificacion').getValue() <= 14){
                                                            Ext.getCmp('strEVALDESACyD_DClasificacion').setValue("Medio");
                                                        }else{
                                                            if(MesesCumplidos >= 13 && MesesCumplidos <= 18 && Ext.getCmp('intEVALDESACyD_DCalificacion').getValue() <= 15 && Ext.getCmp('intEVALDESACyD_DCalificacion').getValue() <= 17){
                                                                Ext.getCmp('strEVALDESACyD_DClasificacion').setValue("Medio Alto");
                                                            }else{
                                                                if(MesesCumplidos >= 19 && MesesCumplidos <= 24 && Ext.getCmp('intEVALDESACyD_DCalificacion').getValue() <= 14){
                                                                    Ext.getCmp('strEVALDESACyD_DClasificacion').setValue("Alerta");
                                                                }else{
                                                                    if(MesesCumplidos >= 19 && MesesCumplidos <= 24 && Ext.getCmp('intEVALDESACyD_DCalificacion').getValue() <= 15 && Ext.getCmp('intEVALDESACyD_DCalificacion').getValue() <= 17){
                                                                        Ext.getCmp('strEVALDESACyD_DClasificacion').setValue("Medio");
                                                                    }else{
                                                                        if(MesesCumplidos >= 19 && MesesCumplidos <= 24 && Ext.getCmp('intEVALDESACyD_DCalificacion').getValue() <= 18 && Ext.getCmp('intEVALDESACyD_DCalificacion').getValue() <= 22){
                                                                            Ext.getCmp('strEVALDESACyD_DClasificacion').setValue("Medio Alto");
                                                                        }else{
                                                                            if(MesesCumplidos >= 25 && MesesCumplidos <= 36 && Ext.getCmp('intEVALDESACyD_DCalificacion').getValue() <= 18){
                                                                                Ext.getCmp('strEVALDESACyD_DClasificacion').setValue("Alerta");
                                                                            }else{
                                                                                if(MesesCumplidos >= 25 && MesesCumplidos <= 36 && Ext.getCmp('intEVALDESACyD_DCalificacion').getValue() <= 19 && Ext.getCmp('intEVALDESACyD_DCalificacion').getValue() <= 22){
                                                                                    Ext.getCmp('strEVALDESACyD_DClasificacion').setValue("Medio");
                                                                                }else{
                                                                                    if(MesesCumplidos >= 25 && MesesCumplidos <= 36 && Ext.getCmp('intEVALDESACyD_DCalificacion').getValue() <= 23 && Ext.getCmp('intEVALDESACyD_DCalificacion').getValue() <= 27){
                                                                                        Ext.getCmp('strEVALDESACyD_DClasificacion').setValue("Medio Alto");
                                                                                    }else{
                                                                                        if(MesesCumplidos >= 37 && MesesCumplidos <= 48 && Ext.getCmp('intEVALDESACyD_DCalificacion').getValue() <= 22){
                                                                                            Ext.getCmp('strEVALDESACyD_DClasificacion').setValue("Alerta");
                                                                                        }else{
                                                                                            if(MesesCumplidos >= 37 && MesesCumplidos <= 48 && Ext.getCmp('intEVALDESACyD_DCalificacion').getValue() <= 23 && Ext.getCmp('intEVALDESACyD_DCalificacion').getValue() <= 26){
                                                                                                Ext.getCmp('strEVALDESACyD_DClasificacion').setValue("Medio");
                                                                                            }else{
                                                                                                if(MesesCumplidos >= 37 && MesesCumplidos <= 48 && Ext.getCmp('intEVALDESACyD_DCalificacion').getValue() <= 27 && Ext.getCmp('intEVALDESACyD_DCalificacion').getValue() <= 29){
                                                                                                    Ext.getCmp('strEVALDESACyD_DClasificacion').setValue("Medio Alto");
                                                                                                }else{
                                                                                                    if(MesesCumplidos >= 49 && MesesCumplidos <= 60 && Ext.getCmp('intEVALDESACyD_DCalificacion').getValue() <= 25){
                                                                                                        Ext.getCmp('strEVALDESACyD_DClasificacion').setValue("Alerta");
                                                                                                    }else{
                                                                                                        if(MesesCumplidos >= 49 && MesesCumplidos <= 60 && Ext.getCmp('intEVALDESACyD_DCalificacion').getValue() <= 26 && Ext.getCmp('intEVALDESACyD_DCalificacion').getValue() <= 28){
                                                                                                            Ext.getCmp('strEVALDESACyD_DClasificacion').setValue("Medio");
                                                                                                        }else{
                                                                                                            if(MesesCumplidos >= 49 && MesesCumplidos <= 60 && Ext.getCmp('intEVALDESACyD_DCalificacion').getValue() == 29){
                                                                                                                Ext.getCmp('strEVALDESACyD_DClasificacion').setValue("Medio Alto");
                                                                                                            }else{
                                                                                                                Ext.getCmp('strEVALDESACyD_DClasificacion').setValue("Alto");
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }
    
    //CRECIMIENTO Y DESARROLLO TOTAL
    if(MesesCumplidos <= 3 && Ext.getCmp('intEVALDESACyD_TotalCalificacion').getValue() <= 6){
        Ext.getCmp('strEVALDESACyD_TotalClasificacion').setValue("Alerta");
    }else{
        if(MesesCumplidos <= 3 && Ext.getCmp('intEVALDESACyD_TotalCalificacion').getValue() >= 7 && Ext.getCmp('intEVALDESACyD_TotalCalificacion').getValue() <= 13){
            Ext.getCmp('strEVALDESACyD_TotalClasificacion').setValue("Medio");
        }else{
            if(MesesCumplidos <= 3 && Ext.getCmp('intEVALDESACyD_TotalCalificacion').getValue() >= 14 && Ext.getCmp('intEVALDESACyD_TotalCalificacion').getValue() <= 22){
                Ext.getCmp('strEVALDESACyD_TotalClasificacion').setValue("Medio Alto");
            }else{
                if(MesesCumplidos >= 4 && MesesCumplidos <= 6 && Ext.getCmp('intEVALDESACyD_TotalCalificacion').getValue() <= 19){
                    Ext.getCmp('strEVALDESACyD_TotalClasificacion').setValue("Alerta");
                }else{
                    if(MesesCumplidos >= 4 && MesesCumplidos <= 6 && Ext.getCmp('intEVALDESACyD_TotalCalificacion').getValue() <= 20 && Ext.getCmp('intEVALDESACyD_TotalCalificacion').getValue() <= 27){
                        Ext.getCmp('strEVALDESACyD_TotalClasificacion').setValue("Medio");
                    }else{
                        if(MesesCumplidos >= 4 && MesesCumplidos <= 6 && Ext.getCmp('intEVALDESACyD_TotalCalificacion').getValue() <= 28 && Ext.getCmp('intEVALDESACyD_TotalCalificacion').getValue() <= 34){
                            Ext.getCmp('strEVALDESACyD_TotalClasificacion').setValue("Medio Alto");
                        }else{
                            if(MesesCumplidos >= 7 && MesesCumplidos <= 9 && Ext.getCmp('intEVALDESACyD_TotalCalificacion').getValue() <= 31){
                                Ext.getCmp('strEVALDESACyD_TotalClasificacion').setValue("Alerta");
                            }else{
                                if(MesesCumplidos >= 7 && MesesCumplidos <= 9 && Ext.getCmp('intEVALDESACyD_TotalCalificacion').getValue() <= 32 && Ext.getCmp('intEVALDESACyD_TotalCalificacion').getValue() <= 39){
                                    Ext.getCmp('strEVALDESACyD_TotalClasificacion').setValue("Medio");
                                }else{
                                    if(MesesCumplidos >= 7 && MesesCumplidos <= 9 && Ext.getCmp('intEVALDESACyD_TotalCalificacion').getValue() <= 40 && Ext.getCmp('intEVALDESACyD_TotalCalificacion').getValue() <= 48){
                                        Ext.getCmp('strEVALDESACyD_TotalClasificacion').setValue("Medio Alto");
                                    }else{
                                        if(MesesCumplidos >= 10 && MesesCumplidos <= 12 && Ext.getCmp('intEVALDESACyD_TotalCalificacion').getValue() <= 42){
                                            Ext.getCmp('strEVALDESACyD_TotalClasificacion').setValue("Alerta");
                                        }else{
                                            if(MesesCumplidos >= 10 && MesesCumplidos <= 12 && Ext.getCmp('intEVALDESACyD_TotalCalificacion').getValue() <= 43 && Ext.getCmp('intEVALDESACyD_TotalCalificacion').getValue() <= 49){
                                                Ext.getCmp('strEVALDESACyD_TotalClasificacion').setValue("Medio");
                                            }else{
                                                if(MesesCumplidos >= 10 && MesesCumplidos <= 12 && Ext.getCmp('intEVALDESACyD_TotalCalificacion').getValue() <= 50 && Ext.getCmp('intEVALDESACyD_TotalCalificacion').getValue() <= 56){
                                                    Ext.getCmp('strEVALDESACyD_TotalClasificacion').setValue("Medio Alto");
                                                }else{
                                                    if(MesesCumplidos >= 13 && MesesCumplidos <= 18 && Ext.getCmp('intEVALDESACyD_TotalCalificacion').getValue() <= 51){
                                                        Ext.getCmp('strEVALDESACyD_TotalClasificacion').setValue("Alerta");
                                                    }else{
                                                        if(MesesCumplidos >= 13 && MesesCumplidos <= 18 && Ext.getCmp('intEVALDESACyD_TotalCalificacion').getValue() <= 52 && Ext.getCmp('intEVALDESACyD_TotalCalificacion').getValue() <= 60){
                                                            Ext.getCmp('strEVALDESACyD_TotalClasificacion').setValue("Medio");
                                                        }else{
                                                            if(MesesCumplidos >= 13 && MesesCumplidos <= 18 && Ext.getCmp('intEVALDESACyD_TotalCalificacion').getValue() <= 61 && Ext.getCmp('intEVALDESACyD_TotalCalificacion').getValue() <= 69){
                                                                Ext.getCmp('strEVALDESACyD_TotalClasificacion').setValue("Medio Alto");
                                                            }else{
                                                                if(MesesCumplidos >= 19 && MesesCumplidos <= 24 && Ext.getCmp('intEVALDESACyD_TotalCalificacion').getValue() <= 61){
                                                                    Ext.getCmp('strEVALDESACyD_TotalClasificacion').setValue("Alerta");
                                                                }else{
                                                                    if(MesesCumplidos >= 19 && MesesCumplidos <= 24 && Ext.getCmp('intEVALDESACyD_TotalCalificacion').getValue() <= 62 && Ext.getCmp('intEVALDESACyD_TotalCalificacion').getValue() <= 71){
                                                                        Ext.getCmp('strEVALDESACyD_TotalClasificacion').setValue("Medio");
                                                                    }else{
                                                                        if(MesesCumplidos >= 19 && MesesCumplidos <= 24 && Ext.getCmp('intEVALDESACyD_TotalCalificacion').getValue() <= 72 && Ext.getCmp('intEVALDESACyD_TotalCalificacion').getValue() <= 83){
                                                                            Ext.getCmp('strEVALDESACyD_TotalClasificacion').setValue("Medio Alto");
                                                                        }else{
                                                                            if(MesesCumplidos >= 25 && MesesCumplidos <= 36 && Ext.getCmp('intEVALDESACyD_TotalCalificacion').getValue() <= 74){
                                                                                Ext.getCmp('strEVALDESACyD_TotalClasificacion').setValue("Alerta");
                                                                            }else{
                                                                                if(MesesCumplidos >= 25 && MesesCumplidos <= 36 && Ext.getCmp('intEVALDESACyD_TotalCalificacion').getValue() <= 75 && Ext.getCmp('intEVALDESACyD_TotalCalificacion').getValue() <= 86){
                                                                                    Ext.getCmp('strEVALDESACyD_TotalClasificacion').setValue("Medio");
                                                                                }else{
                                                                                    if(MesesCumplidos >= 25 && MesesCumplidos <= 36 && Ext.getCmp('intEVALDESACyD_TotalCalificacion').getValue() <= 87 && Ext.getCmp('intEVALDESACyD_TotalCalificacion').getValue() <= 100){
                                                                                        Ext.getCmp('strEVALDESACyD_TotalClasificacion').setValue("Medio Alto");
                                                                                    }else{
                                                                                        if(MesesCumplidos >= 37 && MesesCumplidos <= 48 && Ext.getCmp('intEVALDESACyD_TotalCalificacion').getValue() <= 89){
                                                                                            Ext.getCmp('strEVALDESACyD_TotalClasificacion').setValue("Alerta");
                                                                                        }else{
                                                                                            if(MesesCumplidos >= 37 && MesesCumplidos <= 48 && Ext.getCmp('intEVALDESACyD_TotalCalificacion').getValue() <= 90 && Ext.getCmp('intEVALDESACyD_TotalCalificacion').getValue() <= 100){
                                                                                                Ext.getCmp('strEVALDESACyD_TotalClasificacion').setValue("Medio");
                                                                                            }else{
                                                                                                if(MesesCumplidos >= 37 && MesesCumplidos <= 48 && Ext.getCmp('intEVALDESACyD_TotalCalificacion').getValue() <= 101 && Ext.getCmp('intEVALDESACyD_TotalCalificacion').getValue() <= 114){
                                                                                                    Ext.getCmp('strEVALDESACyD_TotalClasificacion').setValue("Medio Alto");
                                                                                                }else{
                                                                                                    if(MesesCumplidos >= 49 && MesesCumplidos <= 60 && Ext.getCmp('intEVALDESACyD_TotalCalificacion').getValue() <= 101){
                                                                                                        Ext.getCmp('strEVALDESACyD_TotalClasificacion').setValue("Alerta");
                                                                                                    }else{
                                                                                                        if(MesesCumplidos >= 49 && MesesCumplidos <= 60 && Ext.getCmp('intEVALDESACyD_TotalCalificacion').getValue() <= 102 && Ext.getCmp('intEVALDESACyD_TotalCalificacion').getValue() <= 113){
                                                                                                            Ext.getCmp('strEVALDESACyD_TotalClasificacion').setValue("Medio");
                                                                                                        }else{
                                                                                                            if(MesesCumplidos >= 49 && MesesCumplidos <= 60 && Ext.getCmp('intEVALDESACyD_TotalCalificacion').getValue() == 114){
                                                                                                                Ext.getCmp('strEVALDESACyD_TotalClasificacion').setValue("Medio Alto");
                                                                                                            }else{
                                                                                                                Ext.getCmp('strEVALDESACyD_TotalClasificacion').setValue("Alto");
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}
