/*
* @category    Formulario Control de Signos Vitales
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winAddEvolucion001Ui = Ext.extend(Ext.Window, {
    title: 'eOfiClinic .:: Evolucion Actividad Adicional ::.',
    width: 1000,
    height: 636,
    closable: true,
    resizable: false,
    draggable: false,
    modal: true,
    autoScroll: true,
    id: 'winAddEvolucion001',
    initComponent: function() {
        
        var stComboUbicacion = new StoreConsultoriosxIPS();
        stComboUbicacion.load({
            params: {
                pIPS: ID_IPS
            }
        });
        this.tbar = [
            {
                xtype: 'toolbar',
                anchor: '99%',
                items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Crear Evolucion',
                            iconCls: 'btnAsignarCita',
                            id: 'btnCrearEvolucion002',
                            listeners:{
                                click : function(){
                                    guardarActividadesAdicionales();
                            }
                        }
                    }
                ]
            }
        ],
        this.items = [
            {
                xtype: 'panel',
                frame: true,
                anchor: '85%',
                id: 'panelHC',
                border: false,
                autoHeight: true,
                autoScroll: true,
                layout: 'form',
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'form',
                        frame: true,
                        anchor: '98%',
                        id: 'frmAddHCEvolucion002',
                        padding: 10,
                        border: false,
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: false,
                                readOnly: true,
                                value: 'NA',
                                fieldLabel: 'Pantalla',
                                id: 'sysPantalla'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: false,
                                readOnly: true,
                                fieldLabel: 'Usuario',
                                id: 'sysUsuarioActividadesAdicionales'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: false,
                                readOnly: true,
                                fieldLabel: 'ConsecutivoRegistro',
                                id: 'sysConsecutivoRegistro'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: false,
                                readOnly: true,
                                fieldLabel: 'IdPaciente',
                                id: 'sysPacienteActividadesAdicionales'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: false,
                                readOnly: true,
                                fieldLabel: 'FechaRegistro',
                                value: new Date().format('Y-m-d'),
                                id: 'sysFechaRegistro'
                            },
                            {
                                xtype: 'hidden',
                                width: 150,
                                fieldLabel: 'CAS',
                                id: 'sysCASRef'
                            },
                            {
                                xtype: 'hidden',
                                readOnly: true,
                                width: 96,
                                allowBlank: true,
                                style: 'color: #0000cc; font-weight: bold;',
                                id: 'sysCodConceptoActividadesAdicionales'
                            },
                            {
                                xtype: 'hidden',
                                readOnly: true,
                                width: 455,
                                height: 50,
                                fieldLabel: 'Descripción',
                                style: 'font-family: Arial,Helvetica,sans-serif;font-size: 10px; color: #0000cc; font-weight: bold;',
                                id: 'sysDesConceptoActividadesAdicionales'
                            },
                            {
                                xtype: 'hidden',
                                readOnly: true,
                                width: 96,
                                allowBlank: true,
                                style: 'color: #0000cc; font-weight: bold;',
                                id: 'sysVlrConceptoActividadesAdicionales'
                            },
                            {
                                xtype: 'hidden',
                                readOnly: true,
                                width: 96,
                                allowBlank: true,
                                style: 'color: #0000cc; font-weight: bold;',
                                id: 'sysIdCliente_Adicionales'
                            },
                            {
                                xtype: 'hidden',
                                readOnly: true,
                                width: 96,
                                allowBlank: true,
                                style: 'color: #0000cc; font-weight: bold;',
                                id: 'sysProfesionalActividadesAdicionales'
                            },
                            {
                                xtype: 'hidden',
                                name: 'Hora',
                                width: 90,
                                allowBlank: false,
                                id: 'sysHora'
                            },
                            {
                                xtype: 'panel',
                                title: '<center>Evolucion</center>',
                                layout: 'form',
                                anchor: '100%',
                                labelSeparator: '',
                                labelWidth: 100,
                                autoHeight: true,
                                id: 'pnEvolucion',
                                items: [
                                    {
                                        xtype: 'combo',
                                        fieldLabel: 'Concepto',
                                        anchor: '100%',
                                        allowBlank: false,
                                        store: 'StoreConceptosClienteActividadesAdicionales',
                                        typeAhead: true,
                                        typeAheadDelay: 50,
                                        valueField: 'Codigo',
                                        displayField: 'Descripcion',
                                        tpl: '<tpl for="."><div class="cbRango"><h3>{Descripcion}</h3><span style="font-size: 12; color: #AA0033">Codigo: {CUPSCodigo}</span><br/><span style="font-size: 12; color: #0000EE ">Tarifa: $ {Tarifa}</span><hr /></div></tpl>',
                                        emptyText: 'Seleccione Concepto....',
                                        itemSelector: 'div.cbRango',
                                        mode: 'local',
                                        triggerAction: 'all',
                                        forceSelection: true,
                                        id: 'sysIdProcedimientoActividadesAdicionales',
                                        listeners:{
                                            select: function(cmb, rec, idx) {
                                                if(cmb.getValue() !== null && cmb.getValue() !== ""){
                                                    Ext.getCmp('sysDesConceptoActividadesAdicionales').setValue(rec.data.Descripcion);
                                                    Ext.getCmp('sysCodConceptoActividadesAdicionales').setValue(rec.data.CodProced);
                                                    Ext.getCmp('sysVlrConceptoActividadesAdicionales').setValue(rec.data.VlrTarifa);
                                                }else{
                                                    Ext.getCmp('sysDesConceptoActividadesAdicionales').setValue(null);
                                                    Ext.getCmp('sysCodConceptoActividadesAdicionales').setValue(null);
                                                    Ext.getCmp('sysVlrConceptoActividadesAdicionales').setValue(null);
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'datefield',
                                        width: 120,
                                        fieldLabel: 'Fecha',
                                        name: 'Fecha',
                                        allowBlank: false,
                                        readOnly: true,
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        value: new Date().format('d/m/Y'),
                                        id: 'sysFecha'
                                    },
                                    {
                                        xtype: 'fieldset',
                                        title: 'EVOLUCION',
                                        layout: 'table',
                                        collapseFirst: false,
                                        collapsible: true,
                                        animCollapse: true,
                                        titleCollapse: true,
                                        anchor: '100%',
                                        autoHeight: true,
                                        padding: 7,
                                        items: [
                                            {
                                                xtype: 'textarea',
                                                anchor: '100%',
                                                width: 880,
                                                fieldLabel: 'EVOLUCION',
                                                name: 'EVOLUCION',
                                                height: 100,
                                                allowBlank: false,
                                                id: 'memEvolucion'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'fieldset',
                                        title: 'RIPS',
                                        layout: 'form',
                                        collapsible: true,
                                        titleCollapse: true,
                                        anchor: '100%',
                                        autoHeight: true,
                                        id: 'fsRips',
                                        items: [
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        width: 96,
                                                        allowBlank: false,
                                                        fieldLabel: 'Diagnostico Principal',
                                                        id: 'sysDiagPpalActividadAdicional',
                                                        listeners:{
                                                            specialkey: function(f,e){
                                                                if (e.getKey() === e.ENTER || e.getKey() === e.TAB)
                                                                {
                                                                    if (f.getValue() !== "" && f.getValue() !== null && f.getValue().toUpperCase() !== Ext.getCmp('sysDiagRel1ActividadAdicional').getValue() && f.getValue().toUpperCase() !== Ext.getCmp('sysDiagRel2ActividadAdicional').getValue() && f.getValue().toUpperCase() !== Ext.getCmp('sysDiagRel3ActividadAdicional').getValue()){
                                                                        Ext.Ajax.request({
                                                                            url: '../../controlador/cie10/controlador_cie10.php',
                                                                            params:{
                                                                                task: 'BUSCAR',
                                                                                pCodigo: f.getValue().toUpperCase()
                                                                            },
                                                                            success: function(response,options)
                                                                            {
                                                                                var el = Ext.get('response'); // get the LOG
                                                                                var Respuesta = response.responseText;
                                                                                var Contenido = Respuesta.split('^');
                                                                                if(Contenido[0]==="" || Contenido[0]=== "{success:false}" || Contenido[0]=== null){
                                                                                    Ext.getCmp('sysDiagPpalActividadAdicional').setValue(null);
                                                                                    Ext.getCmp('sysDiagPpalActividadAdicionalNom').setValue(null);
                                                                                } else {
                                                                                    Ext.getCmp('sysDiagPpalActividadAdicional').setValue(Contenido[0]);
                                                                                    Ext.getCmp('sysDiagPpalActividadAdicionalNom').setValue(Contenido[1]);
                                                                                }
                                                                            },
                                                                            failure: function(response,options){
                                                                                var el = Ext.get('response');
                                                                                Ext.getCmp('sysDiagPpalActividadAdicional').setValue(null);
                                                                                Ext.getCmp('sysDiagPpalActividadAdicionalNom').setValue(null);
                                                                            },
                                                                            scope:this //bind the callbacks
                                                                        });
                                                                    }else{
                                                                        Ext.getCmp('sysDiagPpalActividadAdicional').setValue(null);
                                                                        Ext.getCmp('sysDiagPpalActividadAdicionalNom').setValue(null);
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        readOnly: true,
                                                        width: 625,
                                                        height: 22,
                                                        id: 'sysDiagPpalActividadAdicionalNom'
                                                    },
                                                    {
                                                        xtype: 'button',
                                                        iconCls: 'btnBuscar',
                                                        tooltip: 'Buscar Diagnostico Principal',
                                                        id: 'btnSearchDiagPpalActividadesAdicional',
                                                        listeners:{
                                                            click : function(){
                                                                buscarcie10('sysDiagPpalActividadAdicional','sysDiagPpalActividadAdicionalNom');
                                                            }
                                                        }
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        width: 96,
                                                        allowBlank: true,
                                                        fieldLabel: 'Diagnostico Relacionado Nro.1',
                                                        id: 'sysDiagRel1ActividadAdicional',
                                                        listeners:{
                                                            specialkey: function(f,e){
                                                                if (e.getKey() === e.ENTER || e.getKey() === e.TAB)
                                                                {
                                                                    if (f.getValue() !== "" && f.getValue() !== null && f.getValue().toUpperCase() !== Ext.getCmp('sysDiagPpalActividadAdicional').getValue() && f.getValue().toUpperCase() !== Ext.getCmp('sysDiagRel2ActividadAdicional').getValue() && f.getValue().toUpperCase() !== Ext.getCmp('sysDiagRel3ActividadAdicional').getValue()){
                                                                        Ext.Ajax.request(
                                                                        {
                                                                            url: '../../controlador/cie10/controlador_cie10.php',
                                                                            params:{
                                                                                task: 'BUSCAR',
                                                                                pCodigo: f.getValue().toUpperCase()
                                                                            },
                                                                            success: function(response,options)
                                                                            {
                                                                                var el = Ext.get('response'); // get the LOG
                                                                                var Respuesta = response.responseText;
                                                                                var Contenido = Respuesta.split('^');
                                                                                if(Contenido[0]==="" || Contenido[0]=== "{success:false}" || Contenido[0]=== null){
                                                                                    Ext.getCmp('sysDiagRel1ActividadAdicional').setValue(null);
                                                                                    Ext.getCmp('sysDiagRel1ActividadAdicionalNom').setValue(null);
                                                                                } else {
                                                                                    Ext.getCmp('sysDiagRel1ActividadAdicional').setValue(Contenido[0]);
                                                                                    Ext.getCmp('sysDiagRel1ActividadAdicionalNom').setValue(Contenido[1]);
                                                                                }
                                                                            },
                                                                            failure: function(response,options){
                                                                                var el = Ext.get('response');
                                                                                Ext.getCmp('sysDiagRel1ActividadAdicional').setValue(null);
                                                                                Ext.getCmp('sysDiagRel1ActividadAdicionalNom').setValue(null);
                                                                            },
                                                                            scope:this //bind the callbacks
                                                                        });
                                                                    }else{
                                                                        Ext.getCmp('sysDiagRel1ActividadAdicional').setValue(null);
                                                                        Ext.getCmp('sysDiagRel1ActividadAdicionalNom').setValue(null);
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        readOnly: true,
                                                        width: 625,
                                                        height: 22,
                                                        id: 'sysDiagRel1ActividadAdicionalNom'
                                                    },
                                                    {
                                                        xtype: 'button',
                                                        iconCls: 'btnBuscar',
                                                        tooltip: 'Buscar Diagnostico Relacionado1',
                                                        id: 'btnSearchDiagRel1ActividadAdicional',
                                                        listeners:{
                                                            click : function(){
                                                                buscarcie10('sysDiagRel1ActividadAdicional','sysDiagRel1ActividadAdicionalNom');
                                                            }
                                                        }
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        width: 96,
                                                        allowBlank: true,
                                                        fieldLabel: 'Diagnostico Relacionado Nro.2',
                                                        id: 'sysDiagRel2ActividadAdicional',
                                                        listeners:{
                                                            specialkey: function(f,e){
                                                                if (e.getKey() === e.ENTER || e.getKey() === e.TAB)
                                                                {
                                                                    if (f.getValue() !== "" && f.getValue() !== null && f.getValue().toUpperCase() !== Ext.getCmp('sysDiagPpalActividadAdicional').getValue() && f.getValue().toUpperCase() !== Ext.getCmp('sysDiagRel1ActividadAdicional').getValue() && f.getValue().toUpperCase() !== Ext.getCmp('sysDiagRel3ActividadAdicional').getValue()){
                                                                        Ext.Ajax.request(
                                                                        {
                                                                            url: '../../controlador/cie10/controlador_cie10.php',
                                                                            params:{
                                                                                task: 'BUSCAR',
                                                                                pCodigo: f.getValue().toUpperCase()
                                                                            },
                                                                            success: function(response,options)
                                                                            {
                                                                                var el = Ext.get('response'); // get the LOG
                                                                                var Respuesta = response.responseText;
                                                                                var Contenido = Respuesta.split('^');
                                                                                if(Contenido[0]==="" || Contenido[0]=== "{success:false}" || Contenido[0]=== null){
                                                                                    Ext.getCmp('sysDiagRel2ActividadAdicional').setValue(null);
                                                                                    Ext.getCmp('sysDiagRel2ActividadAdicionalNom').setValue(null);
                                                                                } else {
                                                                                    Ext.getCmp('sysDiagRel2ActividadAdicional').setValue(Contenido[0]);
                                                                                    Ext.getCmp('sysDiagRel2ActividadAdicionalNom').setValue(Contenido[1]);
                                                                                }
                                                                            },
                                                                            failure: function(response,options){
                                                                                var el = Ext.get('response');
                                                                                Ext.getCmp('sysDiagRel2ActividadAdicional').setValue(null);
                                                                                Ext.getCmp('sysDiagRel2ActividadAdicionalNom').setValue(null);
                                                                            },
                                                                            scope:this //bind the callbacks
                                                                        });
                                                                    }else{
                                                                        Ext.getCmp('sysDiagRel2ActividadAdicional').setValue(null);
                                                                        Ext.getCmp('sysDiagRel2ActividadAdicionalNom').setValue(null);
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        readOnly: true,
                                                        width: 625,
                                                        height: 22,
                                                        id: 'sysDiagRel2ActividadAdicionalNom'
                                                    },
                                                    {
                                                        xtype: 'button',
                                                        iconCls: 'btnBuscar',
                                                        tooltip: 'Buscar Diagnostico Relacionado2',
                                                        id: 'btnSearchDiagRel2ActividadAdicional1',
                                                        listeners:{
                                                            click : function(){
                                                                buscarcie10('sysDiagRel2ActividadAdicional','sysDiagRel2ActividadAdicionalNom');
                                                            }
                                                        }
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        width: 96,
                                                        allowBlank: true,
                                                        fieldLabel: 'Diagnostico Relacionado Nro.3',
                                                        id: 'sysDiagRel3ActividadAdicional',
                                                        listeners:{
                                                            specialkey: function(f,e){
                                                                if (e.getKey() === e.ENTER || e.getKey() === e.TAB)
                                                                {
                                                                    if (f.getValue() !== "" && f.getValue() !== null && f.getValue().toUpperCase() !== Ext.getCmp('sysDiagPpalActividadAdicional').getValue() && f.getValue().toUpperCase() !== Ext.getCmp('sysDiagRel1ActividadAdicional').getValue() && f.getValue().toUpperCase() !== Ext.getCmp('sysDiagRel2ActividadAdicional').getValue()){
                                                                        Ext.Ajax.request(
                                                                        {
                                                                            url: '../../controlador/cie10/controlador_cie10.php',
                                                                            params:{
                                                                                task: 'BUSCAR',
                                                                                pCodigo: f.getValue().toUpperCase()
                                                                            },
                                                                            success: function(response,options)
                                                                            {
                                                                                var el = Ext.get('response'); // get the LOG
                                                                                var Respuesta = response.responseText;
                                                                                var Contenido = Respuesta.split('^');
                                                                                if(Contenido[0]==="" || Contenido[0]=== "{success:false}" || Contenido[0]=== null){
                                                                                    Ext.getCmp('sysDiagRel3ActividadAdicional').setValue(null);
                                                                                    Ext.getCmp('sysDiagRel3ActividadAdicionalNom').setValue(null);
                                                                                } else {
                                                                                    Ext.getCmp('sysDiagRel3ActividadAdicional').setValue(Contenido[0]);
                                                                                    Ext.getCmp('sysDiagRel3ActividadAdicionalNom').setValue(Contenido[1]);
                                                                                }
                                                                            },
                                                                            failure: function(response,options){
                                                                                var el = Ext.get('response');
                                                                                Ext.getCmp('sysDiagRel3ActividadAdicional').setValue(null);
                                                                                Ext.getCmp('sysDiagRel3ActividadAdicionalNom').setValue(null);
                                                                            },
                                                                            scope:this //bind the callbacks
                                                                        });
                                                                    }else{
                                                                        Ext.getCmp('sysDiagRel3ActividadAdicional').setValue(null);
                                                                        Ext.getCmp('sysDiagRel3ActividadAdicionalNom').setValue(null);
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        readOnly: true,
                                                        width: 625,
                                                        height: 22,
                                                        id: 'sysDiagRel3ActividadAdicionalNom'
                                                    },
                                                    {
                                                        xtype: 'button',
                                                        iconCls: 'btnBuscar',
                                                        tooltip: 'Buscar Diagnostico Relacionado3',
                                                        id: 'btnSearchDiagRel3ActividadAdicional',
                                                        listeners:{
                                                            click : function(){
                                                                buscarcie10('sysDiagRel3ActividadAdicional','sysDiagRel3ActividadAdicionalNom');
                                                            }
                                                        }
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'combo',
                                                fieldLabel: 'Tipo de Diagnostico',
                                                width:750,
                                                name: 'Tipo de Diagnostico',
                                                allowBlank: false,
                                                store: 'StoreTipoDiagnostico',
                                                forceSelection: true,
                                                triggerAction: 'all',
                                                typeAhead: true,
                                                typeAheadDelay: 50,
                                                mode: 'local',
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                emptyText: 'Seleccione....',
                                                submitValue: true,
                                                id: 'sysTipoDiagosticoActividadAdicional'
                                            },
                                            {
                                                xtype: 'combo',
                                                fieldLabel: 'Finalidad Consulta',
                                                width:750,
                                                name: 'Finalidad Consulta',
                                                allowBlank: false,
                                                store: 'StoreFinalidadConsulta',
                                                forceSelection: true,
                                                triggerAction: 'all',
                                                typeAhead: true,
                                                typeAheadDelay: 50,
                                                mode: 'local',
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                emptyText: 'Seleccione....',
                                                submitValue: true,
                                                value: 10,
                                                id: 'sysFinalidadConsultaActividadAdicional'
                                            },
                                            {
                                                xtype: 'combo',
                                                fieldLabel: 'Causa Externa',
                                                width:750,
                                                name: 'Causa Externa',
                                                allowBlank: false,
                                                store: 'StoreCausaExterna',
                                                forceSelection: true,
                                                triggerAction: 'all',
                                                typeAhead: true,
                                                typeAheadDelay: 50,
                                                mode: 'local',
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                emptyText: 'Seleccione....',
                                                submitValue: true,
                                                value: 13,
                                                id: 'sysCausaExternaActividadAdicional'
                                            }                            
                                        ]
                                    }
                                ]
                            }
                        ]
                    }
                ]
                
        }];
        winAddEvolucion001Ui.superclass.initComponent.call(this);
    }
});

function guardarActividadesAdicionales(){
        Ext.Msg.show({
        title: 'Guardar Evolucion....!',
        msg: 'Esta seguro que desea Guardar la Informacion?',
        buttons: Ext.Msg.YESNO,
        icon: Ext.Msg.QUESTION,
        fn: function(btn)
        {
            if(btn==="yes")
            {
                var frm = Ext.getCmp('frmAddHCEvolucion002').getForm();
                var listacampos = ExtraerCamposFrmHC(frm);
                if (frm.isValid())
                {
                    frm.submit({
                        url: '../../controlador/asistencial/evolucionhc2014.php',
                        params: {
                            task: 'GUARDA_ACTIVIDADES_ADICIONALES',
                            CAMPOS: listacampos,
                            pEmpresa: ID_EMPRESA,
                            pIPS: ID_IPS,
                            pPaciente: Ext.getCmp('sysPacienteActividadesAdicionales').getValue(),
                            pProfesional: Ext.getCmp('sysProfesionalActividadesAdicionales').getValue(),
                            pFechaAtencion: Ext.getCmp('sysFecha').getValue(),
                            pFecha: Ext.getCmp('sysFecha').getValue(),
                            pHoraAtencion: Ext.getCmp('sysHora').getValue(),
                            pCAS: Ext.getCmp('sysCASRef').getValue(),
                            pDiagppal: Ext.getCmp('sysDiagPpalActividadAdicional').getValue(),
                            pDiagrel1: Ext.getCmp('sysDiagRel1ActividadAdicional').getValue(),
                            pDiagrel2: Ext.getCmp('sysDiagRel2ActividadAdicional').getValue(),
                            pDiagrel3: Ext.getCmp('sysDiagRel3ActividadAdicional').getValue(),
                            pTipodiag: Ext.getCmp('sysTipoDiagosticoActividadAdicional').getValue(),
                            pFinalidad: Ext.getCmp('sysFinalidadConsultaActividadAdicional').getValue(),
                            pCausa: Ext.getCmp('sysCausaExternaActividadAdicional').getValue(),
                            pUsuario: ID_USUARIO,
                            pIdProcedimiento: Ext.getCmp('sysIdProcedimientoActividadesAdicionales').getValue(),
                            pCodProcedimiento: Ext.getCmp('sysCodConceptoActividadesAdicionales').getValue(),
                            pDesProcedimiento: Ext.getCmp('sysDesConceptoActividadesAdicionales').getValue(),
                            pVlrProcedimiento: Ext.getCmp('sysVlrConceptoActividadesAdicionales').getValue()
                        },
                        success: function(res,req)
                        {
                            switch(req.result.requestedId){
                                case "1":
                                    Ext.MessageBox.show({
                                        title: 'Guardar Evolucion',
                                        msg: 'Se Guardo Informacion con Exito.',
                                        buttons: Ext.MessageBox.OK,
                                        icon: Ext.MessageBox.INFO
                                    });
                                    Ext.getCmp('gridActividadesAdicionales').store.baseParams = {
                                        task: 'ACTIVIDADES_ADICIONALES_LISTAR',
                                        pPaciente: Ext.getCmp('sysPacienteActividadesAdicionales').getValue()
                                    };
                                    Ext.getCmp('gridActividadesAdicionales').store.load();
                                    Ext.getCmp('winAddEvolucion001').close();
                                    break;

                                default:
                                    Ext.MessageBox.show({
                                        title: 'Guardar Evolucion',
                                        msg: 'Ocurrio un error al Guardar la Informacion o no se pudo establecer conexión con el servidor.',
                                        buttons: Ext.MessageBox.OK,
                                        icon: Ext.MessageBox.ERROR
                                    });
                                    break;
                            }
                        },
                        failure: function(response,options)
                        {
                            Ext.MessageBox.show({
                                title: 'Error Base Datos',
                                msg: 'No podemos Guardar la Informacion en estos momentos',
                                buttons: Ext.MessageBox.OK,
                                icon: Ext.MessageBox.ERROR
                            });
                        }
                    });
                }else{
                    Ext.MessageBox.show({
                        title: 'Error',
                        msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.ERROR
                    });
                }
            }
        }
    });
}
