/*
* @category    Fieldset Infancia
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


fsRES202Infancia2022Ui = Ext.extend(Ext.form.FieldSet, {
    anchor: '100%',
    autoHeight: true,
    layout: 'form',
    title: '** INFANCIA **',
    collapseFirst: false,
    collapsible: true,
    animCollapse: true,
    labelWidth: 150,
    titleCollapse: true,
    padding: 0,
    id: 'fsRES202Infancia',
    initComponent: function() {
        
        this.items = [
            {
                html: '<br>'
            },
            {
                xtype: 'numberfield',
                width: 60,
                minValue: 0,
                decimalPrecision: 2,
                fieldLabel: 'Perimetro Cefalico',
                name: 'INFANCIA - PERIMETRO CEFALICO',
                allowBlank: true,
                id: 'strInfanciaPC'
            },
            {
                xtype: 'numberfield',
                width: 60,
                minValue: 0,
                decimalPrecision: 2,
                fieldLabel: 'Perimetro Toracico',
                name: 'INFANCIA - PERIMETRO TORACICO',
                allowBlank: true,
                id: 'strInfanciaPT'
            },
            {
                xtype: 'fieldset',
                title: 'VALE',
                layout: 'form',
                collapseFirst: false,
                collapsible: true,
                animCollapse: true,
                titleCollapse: true,
                anchor: '100%',
                autoHeight: true,
                id: 'fsInfanciaVale',
                tbar: [
                    {
                        xtype: 'button',
                        text: 'VALE',
                        iconCls: 'btnEvolucionar1',
                        listeners:{
                            click : function(){
                                //alert("Error al tratar de abrir la ruta '../../../rias/anexos/vale.js'");
                                //window.open ('http://localhost:3000/vale?cas=' + wCAS,"VALE");
                            }
                        }
                    },
                    {
                        xtype: 'tbseparator'
                    }
                ],
                items: [
                    {
                        xtype: 'combo',
                        fieldLabel: 'No se Realiza',
                        name: 'INFANCIA - VALE - NO SE REALIZA',
                        anchor: '100%',
                        allowBlank: true,
                        store: stRES202NoRealiza,
                        forceSelection: true,
                        triggerAction: 'all',
                        typeAhead: true,
                        typeAheadDelay: 50,
                        mode: 'local',
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        id: 'strInfanciaValeNoSeRealiza',
                        listeners: {
                            change: function( t, newValue, oldValue ){
                                if(newValue === "" || newValue === null){
                                    Ext.getCmp('fecInfanciaVale63').setValue(null);
                                    Ext.getCmp('strInfanciaVale40').setValue(null);
                                }else{
                                    if(newValue === "No se tiene el dato"){
                                        Ext.getCmp('fecInfanciaVale63').setValue("01/01/1800");
                                        Ext.getCmp('strInfanciaVale40').setValue("21 - Riesgo no evaluado");
                                    }else if(newValue === "No se realiza por una tradición"){
                                        Ext.getCmp('fecInfanciaVale63').setValue("01/01/1805");
                                        Ext.getCmp('strInfanciaVale40').setValue("21 - Riesgo no evaluado");
                                    }else if(newValue === "No se realiza por una condición de salud registrar"){
                                        Ext.getCmp('fecInfanciaVale63').setValue("01/01/1810");
                                        Ext.getCmp('strInfanciaVale40').setValue("21 - Riesgo no evaluado");
                                    }else if(newValue === "No se realiza por una negación del usuario"){
                                        Ext.getCmp('fecInfanciaVale63').setValue("01/01/1825");
                                        Ext.getCmp('strInfanciaVale40').setValue("21 - Riesgo no evaluado");
                                    }else if(newValue === "No se realiza por otras razones"){
                                        Ext.getCmp('fecInfanciaVale63').setValue("01/01/1835");
                                        Ext.getCmp('strInfanciaVale40').setValue("21 - Riesgo no evaluado");
                                    }
                                }
                            }
                        }
                    },
                    {
                        xtype: 'datefield',
                        fieldLabel: 'Fecha Valoracion',
                        name: 'INFANCIA - VALE - FECHA VALORACION',
                        width: 110,
                        allowBlank: true,
                        //value: new Date().format('d/m/Y'),
                        disabledDates: '',
                        emptyText: '(dia/mes/año) ',
                        style: 'text-align:center;',
                        id: 'fecInfanciaVale63',
                        listeners: {
                            render: function( p ) {
                                p.getEl().on('dblclick', function (){
                                    Ext.getCmp('strInfanciaValeNoSeRealiza').setValue(null);
                                    Ext.getCmp('fecInfanciaVale63').setValue(localStorage.getItem('fecVALE'));
                                    Ext.getCmp('strInfanciaVale40').setValue(localStorage.getItem('resVALE'));
                                });
                            }
                        }
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: 'Resultado',
                        name: 'INFANCIA - VALE - RESULTADO',
                        anchor: '100%',
                        allowBlank: true,
                        store: stRES202VALE,
                        forceSelection: true,
                        triggerAction: 'all',
                        typeAhead: true,
                        typeAheadDelay: 50,
                        mode: 'local',
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        id: 'strInfanciaVale40',
                        listeners: {
                            render: function( p ) {
                                p.getEl().on('dblclick', function (){
                                    Ext.getCmp('strInfanciaValeNoSeRealiza').setValue(null);
                                    Ext.getCmp('fecInfanciaVale63').setValue(localStorage.getItem('fecVALE'));
                                    Ext.getCmp('strInfanciaVale40').setValue(localStorage.getItem('resVALE'));
                                });
                            }
                        }
                    },
                    {
                        xtype: 'textarea',
                        fieldLabel: 'Observaciones',
                        name: 'INFANCIA - VALE - OBSERVACIONES',
                        anchor: '100%',
                        allowBlank: true,
                        id: 'memInfanciaVale'
                    }
                ]
            },
            {
                xtype: 'fieldset',
                title: 'TANNER FEMENINO',
                layout: 'form',
                collapseFirst: false,
                collapsible: true,
                animCollapse: true,
                titleCollapse: true,
                anchor: '100%',
                autoHeight: true,
                id: 'fsInfanciaTannerMujer',
                items: [
                    {
                        xtype: 'combo',
                        fieldLabel: 'Desarrollo Mamario',
                        name: 'INFANCIA - TANNER - DESARROLLO MAMARIO',
                        anchor: '100%',
                        allowBlank: true,
                        store: stTannerMamaMujer,
                        forceSelection: true,
                        triggerAction: 'all',
                        typeAhead: true,
                        typeAheadDelay: 50,
                        mode: 'local',
                        valueField: 'Codigo',
                        displayField: 'Codigo',
                        itemSelector: 'div.mujer-mama',
                        tpl: new Ext.XTemplate('<tpl for="."><div class="mujer-mama"><table><tr><td><img src="{urlImagen}"></td><td>{Codigo}<br>{Descripcion}</td></tr></table></div></tpl>'),
                        id: 'strInfanciaTannerMujerMama'
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: 'Desarrollo Vello Pubiano',
                        name: 'INFANCIA - TANNER - DESARROLLO DEL VELLO PUBIANO ',
                        anchor: '100%',
                        allowBlank: true,
                        store: stTannerVelloMujer,
                        forceSelection: true,
                        triggerAction: 'all',
                        typeAhead: true,
                        typeAheadDelay: 50,
                        mode: 'local',
                        valueField: 'Codigo',
                        displayField: 'Codigo',
                        itemSelector: 'div.mujer-vello',
                        tpl: new Ext.XTemplate('<tpl for="."><div class="mujer-vello"><table><tr><td><img src="{urlImagen}"></td><td>{Codigo}<br>{Descripcion}</td></tr></table></div></tpl>'),
                        id: 'strInfanciaTannerMujerVello'
                    }
                ]
            },
            {
                xtype: 'fieldset',
                title: 'TANNER MASCULINO',
                layout: 'form',
                collapseFirst: false,
                collapsible: true,
                animCollapse: true,
                titleCollapse: true,
                anchor: '100%',
                autoHeight: true,
                id: 'fsInfanciaTannerHombre',
                items: [
                    {
                        xtype: 'combo',
                        fieldLabel: 'Desarrollo Genital',
                        name: 'INFANCIA - TANNER - DESARROLLO GENITAL',
                        anchor: '100%',
                        allowBlank: true,
                        store: stTannerGenitalHombre,
                        forceSelection: true,
                        triggerAction: 'all',
                        typeAhead: true,
                        typeAheadDelay: 50,
                        mode: 'local',
                        valueField: 'Codigo',
                        displayField: 'Codigo',
                        itemSelector: 'div.hombre-genital',
                        tpl: new Ext.XTemplate('<tpl for="."><div class="hombre-genital"><table><tr><td><img src="{urlImagen}"></td><td>{Codigo}<br>{Descripcion}</td></tr></table></div></tpl>'),
                        id: 'strInfanciaTannerHombrGenital'
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: 'Desarrollo Vello Pubiano',
                        name: 'INFANCIA - TANNER - DESARROLLO DEL VELLO PUBIANO ',
                        anchor: '100%',
                        allowBlank: true,
                        store: stTannerVelloHombre,
                        forceSelection: true,
                        triggerAction: 'all',
                        typeAhead: true,
                        typeAheadDelay: 50,
                        mode: 'local',
                        valueField: 'Codigo',
                        displayField: 'Codigo',
                        itemSelector: 'div.hombre-vello',
                        tpl: new Ext.XTemplate('<tpl for="."><div class="hombre-vello"><table><tr><td><img src="{urlImagen}"></td><td>{Codigo}<br>{Descripcion}</td></tr></table></div></tpl>'),
                        id: 'strInfanciaTannerHombreVello'
                    }
                ]
            },
            {
                xtype: 'fieldset',
                title: 'RQC',
                layout: 'form',
                collapseFirst: false,
                collapsible: true,
                animCollapse: true,
                titleCollapse: true,
                anchor: '100%',
                autoHeight: true,
                labelWidth: 650,
                id: 'fsInfanciaRQC',
                items: [
                    {
                        xtype: 'combo',
                        fieldLabel: '¿El lenguaje del niño es anormal en alguna forma?',
                        name: 'INFANCIA - RQC - ¿EL LENGUAJE DEL NIÑO ES ANORMAL EN ALGUNA FORMA?',
                        anchor: '100%',
                        allowBlank: true,
                        store: 'StoreSiNo',
                        forceSelection: true,
                        triggerAction: 'all',
                        typeAhead: true,
                        typeAheadDelay: 50,
                        mode: 'local',
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        id: 'strInfanciaRQC1'
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: '¿El niño duerme mal?',
                        name: 'INFANCIA - RQC - ¿EL NIÑO DUERME MAL?',
                        anchor: '100%',
                        allowBlank: true,
                        store: 'StoreSiNo',
                        forceSelection: true,
                        triggerAction: 'all',
                        typeAhead: true,
                        typeAheadDelay: 50,
                        mode: 'local',
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        id: 'strInfanciaRQC2'
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: '¿Ha tenido el niño en algunas ocasiones convulsiones o caídas al suelo sin razón?',
                        name: 'INFANCIA - RQC - ¿HA TENIDO EL NIÑO EN ALGUNAS OCASIONES CONVULSIONES O CAÍDAS AL SUELO SIN RAZÓN?',
                        anchor: '100%',
                        allowBlank: true,
                        store: 'StoreSiNo',
                        forceSelection: true,
                        triggerAction: 'all',
                        typeAhead: true,
                        typeAheadDelay: 50,
                        mode: 'local',
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        id: 'strInfanciaRQC3'
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: '¿Sufre el niño de dolores frecuentes de cabeza?',
                        name: 'INFANCIA - RQC - ¿SUFRE EL NIÑO DE DOLORES FRECUENTES DE CABEZA?',
                        anchor: '100%',
                        allowBlank: true,
                        store: 'StoreSiNo',
                        forceSelection: true,
                        triggerAction: 'all',
                        typeAhead: true,
                        typeAheadDelay: 50,
                        mode: 'local',
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        id: 'strInfanciaRQC4'
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: '¿El niño ha huido de casa frecuentemente?',
                        name: 'INFANCIA - RQC - ¿EL NIÑO HA HUIDO DE CASA FRECUENTEMENTE?',
                        anchor: '100%',
                        allowBlank: true,
                        store: 'StoreSiNo',
                        forceSelection: true,
                        triggerAction: 'all',
                        typeAhead: true,
                        typeAheadDelay: 50,
                        mode: 'local',
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        id: 'strInfanciaRQC5'
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: '¿Ha robado algo de la casa?',
                        name: 'INFANCIA - RQC - ¿HA ROBADO ALGO DE LA CASA?',
                        anchor: '100%',
                        allowBlank: true,
                        store: 'StoreSiNo',
                        forceSelection: true,
                        triggerAction: 'all',
                        typeAhead: true,
                        typeAheadDelay: 50,
                        mode: 'local',
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        id: 'strInfanciaRQC6'
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: '¿Se asusta o se pone nervioso sin razón?',
                        name: 'INFANCIA - RQC - ¿SE ASUSTA O SE PONE NERVIOSO SIN RAZÓN?',
                        anchor: '100%',
                        allowBlank: true,
                        store: 'StoreSiNo',
                        forceSelection: true,
                        triggerAction: 'all',
                        typeAhead: true,
                        typeAheadDelay: 50,
                        mode: 'local',
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        id: 'strInfanciaRQC7'
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: '¿Parece como retardado o lento para aprender?',
                        name: 'INFANCIA - RQC - ¿PARECE COMO RETARDADO O LENTO PARA APRENDER?',
                        anchor: '100%',
                        allowBlank: true,
                        store: 'StoreSiNo',
                        forceSelection: true,
                        triggerAction: 'all',
                        typeAhead: true,
                        typeAheadDelay: 50,
                        mode: 'local',
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        id: 'strInfanciaRQC8'
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: '¿El niño casi nunca juega con otros niños?',
                        name: 'INFANCIA - RQC - ¿EL NIÑO CASI NUNCA JUEGA CON OTROS NIÑOS?',
                        anchor: '100%',
                        allowBlank: true,
                        store: 'StoreSiNo',
                        forceSelection: true,
                        triggerAction: 'all',
                        typeAhead: true,
                        typeAheadDelay: 50,
                        mode: 'local',
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        id: 'strInfanciaRQC9'
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: '¿El niño se orina o defeca en la ropa?',
                        name: 'INFANCIA - RQC - ¿EL NIÑO SE ORINA O DEFECA EN LA ROPA?',
                        anchor: '100%',
                        allowBlank: true,
                        store: 'StoreSiNo',
                        forceSelection: true,
                        triggerAction: 'all',
                        typeAhead: true,
                        typeAheadDelay: 50,
                        mode: 'local',
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        id: 'strInfanciaRQC10'
                    }
                ]
            },
            {
                xtype: 'fieldset',
                title: 'FAMILIOGRAMA',
                layout: 'table',
                collapseFirst: false,
                collapsible: true,
                animCollapse: true,
                titleCollapse: true,
                anchor: '100%',
                autoHeight: true,
                padding: 7,
                items: [
                    {
                        xtype: 'textarea',
                        fieldLabel: 'Familiograma',
                        name: 'PRIMERA INFANCIA - FAMILIOGRAMA',
                        width: 830,
                        allowBlank: true,
                        id: 'memInfanciaFamiliograma'
                    }
                ]
            },
            {
                xtype: 'fieldset',
                title: 'ECOMAPA',
                layout: 'table',
                collapseFirst: false,
                collapsible: true,
                animCollapse: true,
                titleCollapse: true,
                anchor: '100%',
                autoHeight: true,
                padding: 7,
                items: [
                    {
                        xtype: 'textarea',
                        fieldLabel: 'Ecomapa',
                        name: 'PRIMERA INFANCIA - ECOMAPA',
                        width: 830,
                        allowBlank: true,
                        id: 'memInfanciaEcomapa'
                    }
                ]
            },
            {
                xtype: 'fieldset',
                title: 'TEST FIGURA HUMANA',
                layout: 'table',
                collapseFirst: false,
                collapsible: true,
                animCollapse: true,
                titleCollapse: true,
                anchor: '100%',
                autoHeight: true,
                padding: 7,
                items: [
                    {
                        xtype: 'textarea',
                        fieldLabel: 'Test Figura Humana',
                        name: 'PRIMERA INFANCIA - FIGURA HUMANA',
                        width: 830,
                        allowBlank: true,
                        id: 'memInfanciaTestFiguraHumana'
                    }
                ]
            },
            {
                xtype: 'textarea',
                fieldLabel: 'Observaciones',
                name: 'INFANCIA - OBSERVACIONES',
                anchor: '100%',
                allowBlank: false,
                id: 'memInfanciaObservaciones'
            }
        ];
        this.on({
            afterlayout:{
                scope:this, 
                single:true, 
                fn:function() {
                    /*var MyDate = new Date();
                    MyDate.setDate(MyDate.getDate() - 360);
                    Ext.getCmp('fecInfanciaValoracion').setMinValue(MyDate.format("d/m/Y"));
                    Ext.getCmp('fecInfanciaValoracion').setMaxValue(new Date().format("d/m/Y"));*/
                }
            }
        });
        fsRES202Infancia2022Ui.superclass.initComponent.call(this);
    }
});
