/*
* @category    Fieldset Vejez
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


fsFindRisk2022Ui = Ext.extend(Ext.form.FieldSet, {
    anchor: '100%',
    autoHeight: true,
    layout: 'form',
    title: 'FINDRISC',
    collapseFirst: false,
    collapsible: true,
    animCollapse: true,
    titleCollapse: true,
    padding: 0,
    labelWidth: 650,
    id: 'fsFindRisk',
    initComponent: function() {
        this.items = [
            {
                xtype: 'combo',
                fieldLabel: 'Rango de Edad',
                name: 'FINDRISK - RANGO DE EDAD',
                anchor: '100%',
                allowBlank: true,
                store: stFINDRISCEdad,
                forceSelection: true,
                triggerAction: 'all',
                typeAhead: true,
                typeAheadDelay: 50,
                mode: 'local',
                valueField: 'Descripcion',
                displayField: 'Descripcion',
                id: 'strFINDRISCRangoEdad',
                listeners: {
                    change: function( t, newValue, oldValue ){
                        if(newValue === "" || newValue === null){
                            Ext.getCmp('strFINDRISCRangoEdad').setValue(oldValue);
                        }
                        calificarFindRisk();
                    }
                }
            },
            {
                xtype: 'combo',
                fieldLabel: 'IMC',
                name: 'FINDRISC - IMC',
                anchor: '100%',
                allowBlank: true,
                store: stFINDRISCIMC,
                forceSelection: true,
                triggerAction: 'all',
                typeAhead: true,
                typeAheadDelay: 50,
                mode: 'local',
                valueField: 'Descripcion',
                displayField: 'Descripcion',
                id: 'strFINDRISCIMC',
                listeners: {
                    change: function( t, newValue, oldValue ){
                        if(newValue === "" || newValue === null){
                            Ext.getCmp('strFINDRISCIMC').setValue(oldValue);
                        }
                        calificarFindRisk();
                    }
                }
            },
            {
                xtype: 'combo',
                fieldLabel: 'Perimetro Cintura',
                name: 'FINDRISC - PERIMETRO CINTURA',
                anchor: '100%',
                allowBlank: true,
                store: stFINDRISCPC,
                forceSelection: true,
                triggerAction: 'all',
                typeAhead: true,
                typeAheadDelay: 50,
                mode: 'local',
                valueField: 'Descripcion',
                displayField: 'Descripcion',
                listWidth: 450,
                id: 'strFINDRISCPC',
                listeners: {
                    change: function( t, newValue, oldValue ){
                        if(newValue === "" || newValue === null){
                            Ext.getCmp('strFINDRISCPC').setValue(oldValue);
                        }
                        calificarFindRisk();
                    }
                }
            },
            {
                xtype: 'combo',
                fieldLabel: 'Realiza habitualmente (a diario) al menos 30 minutos de actividad física, en el trabajo y/o en el tiempo libre',
                name: 'FINDRISC - REALIZA EJERCICIO 30 MINUTOS DIARIOS',
                anchor: '100%',
                allowBlank: true,
                store: 'StoreSiNo',
                forceSelection: true,
                triggerAction: 'all',
                typeAhead: true,
                typeAheadDelay: 50,
                mode: 'local',
                valueField: 'Descripcion',
                displayField: 'Descripcion',
                id: 'strFINDRISCEjercicio',
                listeners: {
                    change: function( t, newValue, oldValue ){
                        if(newValue === "" || newValue === null){
                            Ext.getCmp('strFINDRISCEjercicio').setValue(oldValue);
                        }
                        calificarFindRisk();
                    }
                }
            },
            {
                xtype: 'combo',
                fieldLabel: 'Con qué frecuencia come verduras o frutas',
                name: 'FINDRISC - FRECUENCIA CONSUMO VERDURAS O VEGETALES',
                anchor: '100%',
                allowBlank: true,
                store: stFINDRISCConsumoVegetal,
                forceSelection: true,
                triggerAction: 'all',
                typeAhead: true,
                typeAheadDelay: 50,
                mode: 'local',
                valueField: 'Descripcion',
                displayField: 'Descripcion',
                id: 'strFINDRISCConsumoVejetales',
                listeners: {
                    change: function( t, newValue, oldValue ){
                        if(newValue === "" || newValue === null){
                            Ext.getCmp('strFINDRISCConsumoVejetales').setValue(oldValue);
                        }
                        calificarFindRisk();
                    }
                }
            },
            {
                xtype: 'combo',
                fieldLabel: 'Toma medicación para la hipertensión regularmente',
                name: 'FINDRISC - TOMA MEDICAMENTOS PARA HTA',
                anchor: '100%',
                allowBlank: true,
                store: 'StoreSiNo',
                forceSelection: true,
                triggerAction: 'all',
                typeAhead: true,
                typeAheadDelay: 50,
                mode: 'local',
                valueField: 'Descripcion',
                displayField: 'Descripcion',
                id: 'strFINDRISCMedicamentosHTA',
                listeners: {
                    change: function( t, newValue, oldValue ){
                        if(newValue === "" || newValue === null){
                            Ext.getCmp('strFINDRISCMedicamentosHTA').setValue(oldValue);
                        }
                        calificarFindRisk();
                    }
                }
            },
            {
                xtype: 'combo',
                fieldLabel: 'Le han encontrado alguna vez valores de glucosa altos',
                name: 'FINDRISC - LE HAN ENCONTRADO ALGYNA VEZ VALORES ALTOS DE GLUCOSA',
                anchor: '100%',
                allowBlank: true,
                store: 'StoreSiNo',
                forceSelection: true,
                triggerAction: 'all',
                typeAhead: true,
                typeAheadDelay: 50,
                mode: 'local',
                valueField: 'Descripcion',
                displayField: 'Descripcion',
                id: 'strFINDRISCGlucosaAlterada',
                listeners: {
                    change: function( t, newValue, oldValue ){
                        if(newValue === "" || newValue === null){
                            Ext.getCmp('strFINDRISCMedicamentosHTA').setValue(oldValue);
                        }
                        calificarFindRisk();
                    }
                }
            },
            {
                xtype: 'combo',
                fieldLabel: 'Se le ha diagnosticado diabetes (tipo 1 o tipo 2) a alguno de sus familiares',
                name: 'FINDRISC - SE LE HA DIAGNOSTICADO DIABETES (TIPO 1 O TIPO 2) A ALGUNO DE SUS FAMILIARES',
                anchor: '100%',
                allowBlank: true,
                store: stFINDRISCAntecedentesDM,
                forceSelection: true,
                triggerAction: 'all',
                typeAhead: true,
                typeAheadDelay: 50,
                mode: 'local',
                valueField: 'Descripcion',
                displayField: 'Descripcion',
                listWidth: 450,
                id: 'strFINDRISCAntecedentesDM',
                listeners: {
                    change: function( t, newValue, oldValue ){
                        if(newValue === "" || newValue === null){
                            Ext.getCmp('strFINDRISCAntecedentesDM').setValue(oldValue);
                        }
                        calificarFindRisk();
                    }
                }
            },
            {
                xtype: 'textfield',
                fieldLabel: 'Puntaje Total',
                name: 'FINDRISC - Puntaje Total',
                width: 100,
                allowBlank: true,
                readOnly: true,
                id: 'strFINDRISCPuntajeTotal'
            },
            {
                html: 'Interpretación del puntaje: Igual o mayor a 12 = Alta probabilidad de tener Diabetes u otra anormalidad de la regulación de la glucosa'
            }
        ];
        this.on({
            afterlayout:{
                scope:this, 
                single:true, 
                fn:function() {
                    /*var MyDate = new Date();
                    MyDate.setDate(MyDate.getDate() - 360);
                    Ext.getCmp('fecVejezValoracion').setMinValue(MyDate.format("d/m/Y"));
                    Ext.getCmp('fecVejezValoracion').setMaxValue(new Date().format("d/m/Y"));*/
                }
            }
        });
        fsFindRisk2022Ui.superclass.initComponent.call(this);
    }
});

function calificarFindRisk(){
    //alert("calificando");
}