/*
* @category    Formulario Modelo Evolucion Historia Clinica
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winHCMedicinaBasica001Ui = Ext.extend(Ext.Window, {
    title: 'eOfiClinic ©  .:: Plantilla Historia Clinica ::.',
    width: 990,
    height: 636,
    closable: false,
    resizable: false,
    draggable: false,
    modal: true,
    id: 'winHCMedGen',
    initComponent: function() {
        MesesCumplidos = 0;
        AniosCumplidos = 0;
        
        var fsDiagnosticosConsulta = new fsDiagnosticosConsultaUi();
        var fsRevisionxSistemas = new fsRevisionxSistemasUi();
        var fsAntecedentesPersonales = new fsAntecedentesPersonalesUi();
        var fsAntecedentesFamiliares = new fsAntecedentesFamiliaresUi();
        var fsExamenFisico = new fsExamenFisicoUi();
        
        //NUEVO 2014
        //Consentimientos Informados
        var xConsentimientosInformados = new GridConsentimientosInformadosUi();
        //Consentimientos Informados
        var xEventosAdversos = new GridEventosAdversosUi();
        //KardexProgramas
        var xKardexProgramas = new GridKardexxPacUi();
        //Guias Atencion
        var xGuiasAtencion = new GridGuiasAtencionUi();
        //Fichas de Notificacion
        var xFichasNotificacion = new GridFichasNotificacionUi();
        //Docuentos Anexos
        var xDocumentosAnexos = new GridDocumentosAnexosUi();
        //Reporte Paraclinicos
        var stReporteParaclinicos = new StoreGridReporteParaclinicos();
        stReporteParaclinicos.load({
            params: {
                pPaciente: wPaciente
            }
        });
        //Alertas Medicas
        var xAlertasxPaciente = new AlertasxPaciente001Ui();
        Ext.getCmp('gridAlertasPacientes').store.baseParams = {
            task: 'LISTAR_ALERTAS',
            pPaciente: wPaciente,
            pIPS: ID_IPS
        };
        Ext.getCmp('gridAlertasPacientes').store.load({
            params: {
                pPaciente: wPaciente
            }
        });
        function renderClasificacionReporte(val, x, store){
            switch(val){
                case "A":
                    return '<span style="color:#F00">Anormal</span>';
                    break;
                case "N":
                    return '<span style="color:#090">Normal</span>';
                    break;
                default:
                    break;
            }
        }
        function renderValorReporte(value, metaData, record, rowIndex, colIndex, store){  
            metaData.attr = 'style="white-space:normal"';  
            if(record.get('ReporteVal') !== "" && record.get('ReporteVal') !== null){
                return value + "<br><hr>Valor: " + record.get('ReporteVal');  
            }else{
                return value;  
            }
        }
        function renderObservaReporte(value, metaData, record, rowIndex, colIndex, store){  
            metaData.attr = 'style="white-space:normal"';  
            return value;  
        }
        
        var xGridVacunacion = new GridVacunacionUi();
        var xGridActividadesAdicionales = new GridActividadesAdicionalesUi();
        
        //
        tmpmx = objMX;
        tmpmxadd = objMXADD;
        tmpexa = objEXA;
        tmprem = objREM;
        myPaciente = 0;
        myCAS = 0;

        try {
            var campo = Ext.getCmp('sysPacientePlantillaHC');
            if ( campo !== null ) {
                myPaciente = Ext.getCmp('sysPacientePlantillaHC').getValue();
            }
        }catch(ex){
        }
        if(myPaciente === 0){
            try {
                var campo1 = Ext.getCmp('sysIdPacienteHC');
                if ( campo1 !== null ) {
                    myPaciente = Ext.getCmp('sysIdPacienteHC').getValue();
                }
            }catch(ex){
            }
        }
        if(myPaciente === 0){
            try {
                var campo5 = Ext.getCmp('sysPacienteRefHC');
                if ( campo5 !== null ) {
                    myPaciente = Ext.getCmp('sysPacienteRefHC').getValue();
                }
            }catch(ex){
            }
        }
        try {
            var campo2 = Ext.getCmp('sysCASPlantillaHC');
            if ( campo2 !== null ) {
                myCAS = Ext.getCmp('sysCASPlantillaHC').getValue();
            }
        }catch(ex){
        }
        if(myCAS === 0){
            try {
                var campo3 = Ext.getCmp('sysCASHC');
                if ( campo3 !== null ) {
                    myCAS = Ext.getCmp('sysCASHC').getValue();
                }
            }catch(ex){
            }
        }
        if(myCAS === 0){
            try {
                var campo4 = Ext.getCmp('sysCASRefHC');
                if ( campo4 !== null ) {
                    myCAS = Ext.getCmp('sysCASRefHC').getValue();
                }
            }catch(ex){
            }
        }
        if (objMX !== "NA"){
            var xSolMX = eval(objMX);
            Ext.getCmp('gridMedicamentosHC').store.load({
                params: {
                    task: 'MX_IPS_BASICA',
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: wPaciente,
                    pCAS: wCAS
                }
            });
        }
        else{
            var xSolMX = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        if (objEXA !== "NA"){
            var xSolEXA = eval(objEXA);
            Ext.getCmp('gridExamenesHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: wPaciente,
                    pCAS: wCAS
                }
            });
        }else{
            var xSolEXA = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        if (objREM !== "NA"){
            var xSolREM = eval(objREM);
            Ext.getCmp('gridRemisionesHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: wPaciente,
                    pCAS: wCAS
                }
            });
        }else{
            var xSolREM = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        var xSolNOPOS = new SolNOPOS001Ui();
        Ext.getCmp('gridSolicitudesNOPOSxPaciente').store.load({
            params: {
                task: 'LISTAR_NOPOS',
                pPaciente: myPaciente
            }
        });
        //
        var xVerResumenDxxPaciente = new pnResumenDxxPaciente01();
        
        this.items = [
            {
                xtype: 'panel',
                frame: true,
                anchor: '100%',
                id: 'panelHC',
                border: false,
                height: 570,
                autoScroll: true,
                layout: 'form',
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        value: 0,
                        id: 'sysSolicitaCitologia'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        value: 0,
                        id: 'sysSolicitaMamografia'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        value: 0,
                        id: 'sysSolicitaBaciloscopia'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysIdCodPlantillaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        value: 1,
                        id: 'sysUsaGridSalida'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                        value: 0,
                        id: 'sysYaGuardoHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysPlantillaHC',
                        name: 'PLANTILLA'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptMx'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptExa'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptRem'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Actividad',
                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                        id: 'sysActividadHC',
                        name: 'PLANTILLA'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Empresa',
                        id: 'sysEmpresaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'IPS',
                        id: 'sysIPSHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Usuario',
                        id: 'sysUsuarioHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Profesional',
                        id: 'sysProfesionalHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Paciente',
                        id: 'sysIdPacienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Apertura',
                        id: 'sysAperturaHC'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Cliente',
                        id: 'sysClienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdClienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdPlanHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdSubPlanHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdContratoHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Genero',
                        id: 'sysGeneroPacHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Edad',
                        id: 'sysEdadPacHC'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Profesional',
                        id: 'sysProfesionalAgendaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'ConsecutivoDetalle',
                        id: 'sysConsecutivoDetalleHC'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'CAS',
                                id: 'sysCASHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysFechaHC',
                                value: 'Fecha: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysFechaHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysHoraHC',
                                value: 'Hora: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysHoraHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysLegalizacionHC',
                                value: 'Legalización: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysLegalizaHC'
                            }
                        ]
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Paciente',
                        value: 'CC 792558261  - JORGE GALEANO RUIZ - (Masculino) FechaNac: 1973-01-30, Edad 38 Años',
                        id: 'sysPacienteHC'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'textfield',
                                width: 100,
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'Genero',
                                id: 'sysGeneroHC'
                            },
                            {
                                html: 'Fecha Nac:'
                            },
                            {
                                xtype: 'textfield',
                                width: 100,
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysFechaNac'
                            },
                            {
                                html: 'Edad:'
                            },
                            {
                                xtype: 'textfield',
                                width: 350,
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysEdadHC'
                            }
                        ]
                    },
                    /*//quitar
                    {
                        xtype: 'button',
                        iconCls: 'btnImprimir',
                        text: 'Cargar Antecedentes',
                        tooltip: 'Cargar Antecedentes',
                        listeners:{
                            click : function(){
                                var frm = Ext.getCmp('frmHCMedGen').getForm();
                                frm.doAction('load', {
                                    url: '../../controlador/asistencial/evolucionhc2014.php',
                                    waitMsg: 'Cargando Información...',
                                    params:{
                                        pCAS: myCAS,
                                        pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                                        task: 'ImportarAntecedentesPersonalesOfiClinic002'
                                    },
                                    success:function(form, action) {
                                        //CargarDataHCUltimaAtencion(action.result.data.sysEvolucion);
                                    }
                                });
                            }
                        }
                    },
                    {
                        xtype: 'button',
                        iconCls: 'btnImprimir',
                        text: 'Cargar 4505',
                        tooltip: 'Cargar 4505',
                        listeners:{
                            click : function(){
                                var frm = Ext.getCmp('frmHCMedGen').getForm();
                                frm.doAction('load', {
                                    url: '../../controlador/asistencial/evolucionhc2014.php',
                                    waitMsg: 'Cargando Información...',
                                    params:{
                                        pCAS: myCAS,
                                        pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                                        task: 'ImportarFactoresRiesgo4505'
                                    },
                                    success:function(form, action) {
                                        //CargarDataHCUltimaAtencion(action.result.data.sysEvolucion);
                                    }
                                });
                            }
                        }
                    },*/
                    {
                        html: '<hr>',
                        style: 'background:transparent;',
                        border: false
                    },
                    {
                        //xtype: 'tabpanel',
                        xtype: 'multirowtabpanel',
                        multipleRows: true,
                        anchor: '99%',
                        autoHeight: true,
                        border: false,
                        enableTabScroll: true,
                        ref: 'fTabPanel',
                        id: 'fTabPanel',
                        activeTab: 0,
                        items: [
                            {
                                xtype: 'panel',
                                title: 'Evolución',
                                autoHeight: true,
                                autoScroll: true,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaEvolucion',
                                layout: 'form',
                                items: [
                                    {
                                        xtype: 'form',
                                        frame: true,
                                        anchor: '100%',
                                        id: 'frmHCMedGen',
                                        padding: 10,
                                        border: false,
                                        autoScroll: true,
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'fieldset',
                                                title: 'Acompañante - Responsable',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 5,
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                fieldLabel: 'Acompañante',
                                                                name: 'Acompañante',
                                                                width: 350,
                                                                allowBlank: false,
                                                                id: 'strAcompanante'
                                                            },
                                                            {
                                                                html: '   Parentesco:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Parentezco',
                                                                width: 322,
                                                                allowBlank: true,
                                                                store: stParentesco,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strParentescoAcompanante'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        fieldLabel: 'Responsable',
                                                        name: 'Responsable',
                                                        anchor: '100%',
                                                        allowBlank: true,
                                                        id: 'strResponsable'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                fieldLabel: 'Direccion',
                                                                name: 'Direccion',
                                                                width: 350,
                                                                allowBlank: true,
                                                                id: 'strDireccionResponsable'
                                                            },
                                                            {
                                                                html: 'Telefono'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Telefono',
                                                                width: 340,
                                                                allowBlank: true,
                                                                id: 'strTelefonoResponsable'
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'MOTIVO DE CONSULTA',
                                                layout: 'table',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'MOTIVO DE CONSULTA',
                                                        name: 'MOTIVO DE CONSULTA',
                                                        height: 100,
                                                        allowBlank: false,
                                                        id: 'memMotivoConsulta'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'ENFERMEDAD ACTUAL',
                                                layout: 'table',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'ENFERMEDAD ACTUAL',
                                                        name: 'ENFERMEDAD ACTUAL',
                                                        height: 100,
                                                        allowBlank: false,
                                                        id: 'memEnfermedadActual'
                                                    }
                                                ]
                                            },
                                            fsRevisionxSistemas,
                                            fsAntecedentesPersonales,
                                            fsAntecedentesFamiliares,
                                            fsExamenFisico,
                                            {
                                                xtype: 'fieldset',
                                                title: 'FORMULACION POST-FECHA',
                                                layout: 'form',
                                                labelWidth: 135,
                                                //labelAlign: 'top',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Realizar Formulacion para',
                                                        name: 'Realizar Formulacion para',
                                                        width: 250,
                                                        allowBlank: true,
                                                        store: stMesesFormulacion,
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: 1,
                                                        id: 'sysFormulacion'
                                                    }
                                                ]
                                            },
                                            //------------ INICIO HC PROGRAMAS
                                            {
                                                xtype: 'fieldset',
                                                title: 'HISTORIA ATENCION PROGRAMA AGUDEZA VISUAL',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 5,
                                                id:'fsAgudezaVisual',
                                                items: [
                                                    {
                                                        xtype: 'hidden',
                                                        id: 'sysReqPrgAgudezaVisual',
                                                        value: 0
                                                    },
                                                    {
                                                        xtype: 'hidden',
                                                        fieldLabel: 'HISTORIA ATENCION PROGRAMA AGUDEZA VISUAL',
                                                        name: 'HISTORIA ATENCION PROGRAMA AGUDEZA VISUAL',
                                                        id: 'strInfPrgAgudezaVisual'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                html: 'Ojo Izquierdo:'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 100,
                                                                allowBlank: true,
                                                                fieldLabel: 'Medicion',
                                                                name: 'Medicion Ojo Izquierdo',
                                                                id: 'strAGUVISMedicionOI'
                                                            },
                                                            {
                                                                html: 'Medicion Ojo Derecho'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 100,
                                                                allowBlank: true,
                                                                name: 'Medicion Ojo Derecho',
                                                                id: 'strAGUVISMedicionOD'
                                                            },
                                                            {
                                                                html: 'Remision a Oftalmologia:',
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Remision Oftalmologica',
                                                                width: 60,
                                                                allowBlank: true,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strAGUVISRemisionOft'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        fieldLabel: 'Plan',
                                                        name: 'Plan',
                                                        allowBlank: true,
                                                        id: 'memGUVISPlan'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'HISTORIA ATENCION PROGRAMA DEL JOVEN',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 5,
                                                id: 'fsProgramaJoven',
                                                items: [
                                                    {
                                                        xtype: 'hidden',
                                                        id: 'sysReqPrgJoven',
                                                        value: 0
                                                    },
                                                    {
                                                        xtype: 'hidden',
                                                        fieldLabel: 'HISTORIA ATENCION PROGRAMA DEL JOVEN',
                                                        name: 'HISTORIA ATENCION PROGRAMA DEL JOVEN',
                                                        id: 'strInfPrgJoven'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        fieldLabel: 'Ocupacion de los Padres',
                                                        name: 'Ocupacion de los Padres',
                                                        anchor: '100%',
                                                        allowBlank: true,
                                                        id: 'strJovenOcupacionPadres'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name: 'Dependencia Economica',
                                                        fieldLabel: 'Dependencia Economica',
                                                        anchor: '100%',
                                                        allowBlank: true,
                                                        store: stDependenciaEconomica,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strALTJOVDependencia'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Relaciones Intrafamiliares',
                                                        name: 'Relaciones Intrafamiliares',
                                                        anchor: '100%',
                                                        allowBlank: true,
                                                        store: stRelaciones,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strALTJOVRelIntrafamiliares'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Relaciones Interpersonales',
                                                        name: 'Relaciones Interpersonales',
                                                        anchor: '100%',
                                                        allowBlank: true,
                                                        store: stRelaciones,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strALTJOVRelInterpersonales'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Comunicacion Intrafamiliar',
                                                        name: 'Comunicacion Intrafamiliar',
                                                        anchor: '100%',
                                                        allowBlank: true,
                                                        store: stRelaciones,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strALTJOVComIntrafamiliar'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        fieldLabel: 'Vida Sexual',
                                                        name: 'Vida Sexual',
                                                        anchor: '100%',
                                                        id: 'strALTJOVVidaSexual',
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('strALTJOVVidaSexual').setValue("Negativo");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        html: '<br>'
                                                    },        
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        fieldLabel: 'Proyecto de Vida',
                                                        name: 'Proyecto de Vida',
                                                        height: 100,
                                                        allowBlank: true,
                                                        id: 'memALTJOVproyectoVida',
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('memALTJOVproyectoVida').setValue("No Refiere");
                                                                });
                                                            }
                                                        }
                                                    },  
                                                    {
                                                        xtype: 'fieldset',
                                                        title: 'Factores de Riesgo',
                                                        layout: 'form',
                                                        collapseFirst: false,
                                                        collapsible: true,
                                                        animCollapse: true,
                                                        titleCollapse: true,
                                                        labelWidth: 350,
                                                        anchor: '100%',
                                                        autoHeight: true,
                                                        padding: 5,
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Paciente Fuma o tiene exposicion a humo de leña o carbon',
                                                                name: 'Paciente Fuma o tiene exposicion a humo de leña o carbon',
                                                                width: 60,
                                                                allowBlank: true,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'bolALTJOVFumador'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Paciente Consume Alcohol',
                                                                name: 'Paciente Consume Alcohol',
                                                                width: 60,
                                                                allowBlank: true,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'bolALTJOVAlcohol'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Paciente Consume Sustancias Psicoactivas',
                                                                name: 'Paciente Consume Sustancias Psicoactivas',
                                                                width: 60,
                                                                allowBlank: true,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'bolALTJOVSustPsicoa'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Paciente Mantiene una Dieta Saludable',
                                                                name: 'Paciente Mantiene una Dieta Saludable',
                                                                width: 60,
                                                                allowBlank: true,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'bolALTJOVDietaSaludable'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Paciente Realiza Actividad Fisica',
                                                                name: 'Paciente Realiza Actividad Fisica',
                                                                width: 60,
                                                                allowBlank: true,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'bolALTJOVActFisica'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Paciente Sabe Manejar Stress o Situaciones de Alta Tension',
                                                                name: 'Paciente Sabe Manejar Stress o Situaciones de Alta Tension',
                                                                width: 60,
                                                                allowBlank: true,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'bolALTJOVManejoStress'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Paciente a Presentado Convulsiones',
                                                                name: 'Paciente a Presentado Convulsiones',
                                                                width: 60,
                                                                allowBlank: true,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strJovenConvulsiones'
                                                            }
                                                        ]
                                                    },
                                                    {   
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Hemoglobina',
                                                                fieldLabel: 'Hemoglobina',
                                                                width: 60,
                                                                allowBlank: true,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strALTJOVHemoglo',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue === "NO"){
                                                                            Ext.getCmp('strALTJOVHemogloDescripcion').allowBlank = true;
                                                                            Ext.getCmp('fecALTJOVHemogloFecha').allowBlank = true;
                                                                            Ext.getCmp('strALTJOVHemogloDescripcion').disable();
                                                                            Ext.getCmp('fecALTJOVHemogloFecha').disable();
                                                                            Ext.getCmp('strALTJOVHemogloDescripcion').clearInvalid();
                                                                            Ext.getCmp('fecALTJOVHemogloFecha').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strALTJOVHemogloDescripcion').enable();
                                                                            Ext.getCmp('fecALTJOVHemogloFecha').enable();
                                                                            Ext.getCmp('strALTJOVHemogloDescripcion').allowBlank = false;
                                                                            Ext.getCmp('fecALTJOVHemogloFecha').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html: ' - '
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 250,
                                                                allowBlank: true,
                                                                name: 'Hemoglobina Descripcion',
                                                                id: 'strALTJOVHemogloDescripcion'
                                                            },
                                                            {
                                                                html: ' - '
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                name: 'Hemoglobina Fecha',
                                                                emptyText: '(dia/mes/año)',
                                                                width: 120,
                                                                allowBlank: true,
                                                                id: 'fecALTJOVHemogloFecha'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'hidden',
                                                        id: 'strJovenColesterolTotal'
                                                    },
                                                    {
                                                        xtype: 'hidden',
                                                        id: 'strJovenColesterolTotalDescripcion'
                                                    },
                                                    {
                                                        xtype: 'hidden',
                                                        id: 'fecJovenColesterolTotalFecha'
                                                    },
                                                    {
                                                        xtype: 'hidden',
                                                        id: 'strJovenColesterolHDL'
                                                    },
                                                    {
                                                        xtype: 'hidden',
                                                        id: 'strJovenColesterolHDLDescripcion'
                                                    },
                                                    {
                                                        xtype: 'hidden',
                                                        id: 'fecJovenColesterolHDLFecha'
                                                    },
                                                    {
                                                        xtype: 'hidden',
                                                        id: 'strJovenVDRL'
                                                    },
                                                    {
                                                        xtype: 'hidden',
                                                        id: 'strJovenVDRLDescripcion'
                                                    },
                                                    {
                                                        xtype: 'hidden',
                                                        id: 'fecJovenVDRLFecha'
                                                    },
                                                    {
                                                        xtype: 'hidden',
                                                        id: 'strJovenVIH'
                                                    },
                                                    {
                                                        xtype: 'hidden',
                                                        id: 'strJovenVIHDescripcion'
                                                    },
                                                    {
                                                        xtype: 'hidden',
                                                        id: 'fecJovenVIHFecha'
                                                    },
                                                    {
                                                        xtype: 'hidden',
                                                        id: 'strJovenTanner'
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        fieldLabel: 'Educacion Programa del Joven',
                                                        name: 'Educacion Programa del Joven',
                                                        allowBlank: true,
                                                        id: 'memJovenEducacion'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'HISTORIA ATENCION PROGRAMA PLANIFICACION FAMILIAR',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                id: 'fsProgramaPlanificacionFam',
                                                items: [
                                                    {
                                                        xtype: 'hidden',
                                                        id: 'sysReqPrgPlanificaFam',
                                                        value: 0
                                                    },
                                                    {
                                                        xtype: 'hidden',
                                                        fieldLabel: 'HISTORIA ATENCION PROGRAMA PLANIFICACION FAMILIAR',
                                                        name: 'HISTORIA ATENCION PROGRAMA PLANIFICACION FAMILIAR',
                                                        id: 'strInfPrgPlanificaFam'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Metodo Planificacion',
                                                                name: 'Metodo Planificacion',
                                                                width: 190,
                                                                allowBlank: false,
                                                                store: stSuministroMetodoPlanificacion,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strPLANIFAMIMetodoPlanifica'
                                                            },
                                                            {
                                                                html: 'Tolera Metodo'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Tolera Metodo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strPLANIFAMIToleraMetodo'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Esta Lactando Actualmente',
                                                                name: 'Esta Lactando Actualmente',
                                                                width: 60,
                                                                allowBlank: true,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strPlanificacionLactanciaHoy'
                                                            },
                                                            {
                                                                html:'Ha Lactando en el Pasado:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Ha Lactando en el Pasado',
                                                                width: 60,
                                                                allowBlank: true,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strPlanificacionLactanciaPasado',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue === "NO"){
                                                                            Ext.getCmp('strPlanificacionTiempoLactancia').setValue(null);
                                                                            Ext.getCmp('strPlanificacionTiempoLactancia').disable();
                                                                            Ext.getCmp('strPlanificacionTiempoLactancia').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strPlanificacionTiempoLactancia').enable();
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html:'Tiempo de Lactancia:'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Tiempo Lactancia',
                                                                width: 50,
                                                                allowBlank: true,
                                                                id: 'strPlanificacionTiempoLactancia'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Cambio de Metodo',
                                                                fieldLabel: 'Cambio de Metodo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strPLANIFAMICambioMetodo',
                                                                listeners:{
                                                                    change : function( t, newValue, oldValue){
                                                                        if(newValue === "NO"){
                                                                            Ext.getCmp('strPLANIFAMINuevoMetodo').allowBlank = true;
                                                                            Ext.getCmp('fecPLANIFAMIFecCambioMetodo').allowBlank = true;
                                                                            Ext.getCmp('strPLANIFAMINuevoMetodo').setValue(null);
                                                                            Ext.getCmp('fecPLANIFAMIFecCambioMetodo').setValue(null);
                                                                            Ext.getCmp('strPLANIFAMINuevoMetodo').disable();
                                                                            Ext.getCmp('fecPLANIFAMIFecCambioMetodo').disable();
                                                                            Ext.getCmp('strPLANIFAMINuevoMetodo').clearInvalid();
                                                                            Ext.getCmp('fecPLANIFAMIFecCambioMetodo').clearInvalid();
                                                                            }else{
                                                                            Ext.getCmp('strPLANIFAMINuevoMetodo').enable();
                                                                            Ext.getCmp('fecPLANIFAMIFecCambioMetodo').enable();
                                                                            Ext.getCmp('strPLANIFAMINuevoMetodo').allowBlank = false;
                                                                            Ext.getCmp('fecPLANIFAMIFecCambioMetodo').allowBlank = false;
                                                                            }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html: 'Nuevo Metodo:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Nuevo Metodo',
                                                                width: 190,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                store: stSuministroMetodoPlanificacion,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strPLANIFAMINuevoMetodo'
                                                            },
                                                            {
                                                                html: 'Fecha Cambio:'
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 120,
                                                                name: 'Fecha Cambio Metodo',
                                                                allowBlank: true,
                                                                disabled: true,
                                                                emptyText: '(dia/mes/año) ',
                                                                style: 'text-align:center;',
                                                                id: 'fecPLANIFAMIFecCambioMetodo'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        fieldLabel: 'Educacion Programa Planificacion Familiar',
                                                        name: 'Educacion Programa Planificacion Familiar',
                                                        allowBlank: true,
                                                        id: 'memPLANIFAMIEducacion'
                                                    }
                                                ]
                                            }, 
                                            {
                                                xtype: 'fieldset',
                                                title: 'HISTORIA ATENCION PROGRAMA DEL ADULTO',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 5,
                                                id: 'fsAlteracionesAdulto',
                                                items: [
                                                    {
                                                        xtype: 'hidden',
                                                        id: 'sysReqPrgAdulto',
                                                        value: 0
                                                    },
                                                    {
                                                        xtype: 'hidden',
                                                        fieldLabel: 'HISTORIA ATENCION PROGRAMA DEL ADULTO',
                                                        name: 'HISTORIA ATENCION PROGRAMA DEL ADULTO',
                                                        id: 'strInfPrgAdulto'
                                                    },
                                                    {
                                                        xtype: 'fieldset',
                                                        title: 'Factores de Riesgo',
                                                        layout: 'form',
                                                        collapseFirst: false,
                                                        collapsible: true,
                                                        animCollapse: true,
                                                        titleCollapse: true,
                                                        labelWidth: 350,
                                                        anchor: '100%',
                                                        autoHeight: true,
                                                        padding: 5,
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Paciente Fuma o tiene exposicion a humo de leña o carbon',
                                                                name: 'Paciente Fuma o tiene exposicion a humo de leña o carbon',
                                                                width: 60,
                                                                allowBlank: true,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'bolALTADULFumador'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Paciente Consume Alcohol',
                                                                name: 'Paciente Consume Alcohol',
                                                                width: 60,
                                                                allowBlank: true,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'bolALTADULAlcohol'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Paciente Consume Sustancias Psicoactivas',
                                                                name: 'Paciente Consume Sustancias Psicoactivas',
                                                                width: 60,
                                                                allowBlank: true,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'bolALTADULSustPsicoa'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Paciente Mantiene una Dieta Saludable',
                                                                name: 'Paciente Mantiene una Dieta Saludable',
                                                                width: 60,
                                                                allowBlank: true,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'bolALTADULDietaSaludable'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Paciente Realiza Actividad Fisica',
                                                                name: 'Paciente Realiza Actividad Fisica',
                                                                width: 60,
                                                                allowBlank: true,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'bolALTADULActFisica'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Paciente Sabe Manejar Stress o Situaciones de Alta Tension',
                                                                name: 'Paciente Sabe Manejar Stress o Situaciones de Alta Tension',
                                                                width: 60,
                                                                allowBlank: true,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'bolALTADULManejoStress'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'fieldset',
                                                        title: 'Laboratorios',
                                                        layout: 'form',
                                                        collapseFirst: false,
                                                        collapsible: true,
                                                        animCollapse: true,
                                                        titleCollapse: true,
                                                        anchor: '100%',
                                                        autoHeight: true,
                                                        padding: 5,
                                                        items: [
                                                            {   
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Uroanalisis',
                                                                        fieldLabel: 'Uroanalisis',
                                                                        width: 60,
                                                                        allowBlank: true,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strALTADULUroanalisis',
                                                                        listeners:{
                                                                            change : function( t, newValue, oldValue){
                                                                                if(newValue === "NO"){
                                                                                    Ext.getCmp('strALTADULUroanalisisDescripcion').allowBlank = true;
                                                                                    Ext.getCmp('fecALTADULUroanalisisFecha').allowBlank = true;
                                                                                    Ext.getCmp('strALTADULUroanalisisDescripcion').disable();
                                                                                    Ext.getCmp('fecALTADULUroanalisisFecha').disable();
                                                                                    Ext.getCmp('strALTADULUroanalisisDescripcion').clearInvalid();
                                                                                    Ext.getCmp('fecALTADULUroanalisisFecha').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('strALTADULUroanalisisDescripcion').enable();
                                                                                    Ext.getCmp('fecALTADULUroanalisisFecha').enable();
                                                                                    Ext.getCmp('strALTADULUroanalisisDescripcion').allowBlank = false;
                                                                                    Ext.getCmp('fecALTADULUroanalisisFecha').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        html: ' - '
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 250,
                                                                        allowBlank: true,
                                                                        name: 'Uroanalisis Descripcion',
                                                                        id: 'strALTADULUroanalisisDescripcion'
                                                                    },
                                                                    {
                                                                        html: ' - '
                                                                    },
                                                                    {
                                                                        xtype: 'datefield',
                                                                        name: 'Uroanalisis Fecha',
                                                                        emptyText: '(dia/mes/año)',
                                                                        width: 120,
                                                                        allowBlank: true,
                                                                        id: 'fecALTADULUroanalisisFecha'
                                                                    }
                                                                ]
                                                            },
                                                            {   
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Creatinina',
                                                                        fieldLabel: 'Creatinina',
                                                                        width: 60,
                                                                        allowBlank: true,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strALTADULCreatinina',
                                                                        listeners:{
                                                                            change : function( t, newValue, oldValue){
                                                                                if(newValue === "NO"){
                                                                                    Ext.getCmp('strALTADULCreatininaDescripcion').allowBlank = true;
                                                                                    Ext.getCmp('fecALTADULCreatininaFecha').allowBlank = true;
                                                                                    Ext.getCmp('strALTADULCreatininaDescripcion').disable();
                                                                                    Ext.getCmp('fecALTADULCreatininaFecha').disable();
                                                                                    Ext.getCmp('strALTADULCreatininaDescripcion').clearInvalid();
                                                                                    Ext.getCmp('fecALTADULCreatininaFecha').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('strALTADULCreatininaDescripcion').enable();
                                                                                    Ext.getCmp('fecALTADULCreatininaFecha').enable();
                                                                                    Ext.getCmp('strALTADULCreatininaDescripcion').allowBlank = false;
                                                                                    Ext.getCmp('fecALTADULCreatininaFecha').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        html: ' - '
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 250,
                                                                        allowBlank: true,
                                                                        name: 'Creatinina Descripcion',
                                                                        id: 'strALTADULCreatininaDescripcion'
                                                                    },
                                                                    {
                                                                        html: ' - '
                                                                    },
                                                                    {
                                                                        xtype: 'datefield',
                                                                        name: 'Creatinina Fecha',
                                                                        emptyText: '(dia/mes/año)',
                                                                        width: 120,
                                                                        allowBlank: true,
                                                                        id: 'fecALTADULCreatininaFecha'
                                                                    }
                                                                ]
                                                            },
                                                            {   
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Glicemia',
                                                                        fieldLabel: 'Glicemia',
                                                                        width: 60,
                                                                        allowBlank: true,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strALTADULGlicemia',
                                                                        listeners:{
                                                                            change : function( t, newValue, oldValue){
                                                                                if(newValue === "NO"){
                                                                                    Ext.getCmp('strALTADULGlicemiaDescripcion').allowBlank = true;
                                                                                    Ext.getCmp('fecALTADULGlicemiaFecha').allowBlank = true;
                                                                                    Ext.getCmp('strALTADULGlicemiaDescripcion').disable();
                                                                                    Ext.getCmp('fecALTADULGlicemiaFecha').disable();
                                                                                    Ext.getCmp('strALTADULGlicemiaDescripcion').clearInvalid();
                                                                                    Ext.getCmp('fecALTADULGlicemiaFecha').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('strALTADULGlicemiaDescripcion').enable();
                                                                                    Ext.getCmp('fecALTADULGlicemiaFecha').enable();
                                                                                    Ext.getCmp('strALTADULGlicemiaDescripcion').allowBlank = false;
                                                                                    Ext.getCmp('fecALTADULGlicemiaFecha').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        html: ' - '
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 250,
                                                                        allowBlank: true,
                                                                        name: 'Glicemia Descripcion',
                                                                        id: 'strALTADULGlicemiaDescripcion'
                                                                    },
                                                                    {
                                                                        html: ' - '
                                                                    },
                                                                    {
                                                                        xtype: 'datefield',
                                                                        name: 'Glicemia Fecha',
                                                                        emptyText: '(dia/mes/año)',
                                                                        width: 120,
                                                                        allowBlank: true,
                                                                        id: 'fecALTADULGlicemiaFecha'
                                                                    }
                                                                ]
                                                            },
                                                            {   
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Colesterol Total',
                                                                        fieldLabel: 'Colesterol Total',
                                                                        width: 60,
                                                                        allowBlank: true,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strALTADULColesterolTotal',
                                                                        listeners:{
                                                                            change : function( t, newValue, oldValue){
                                                                                if(newValue === "NO"){
                                                                                    Ext.getCmp('strALTADULColesterolTotalDescripcion').allowBlank = true;
                                                                                    Ext.getCmp('fecALTADULColesterolTotalFecha').allowBlank = true;
                                                                                    Ext.getCmp('strALTADULColesterolTotalDescripcion').disable();
                                                                                    Ext.getCmp('fecALTADULColesterolTotalFecha').disable();
                                                                                    Ext.getCmp('strALTADULColesterolTotalDescripcion').clearInvalid();
                                                                                    Ext.getCmp('fecALTADULColesterolTotalFecha').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('strALTADULColesterolTotalDescripcion').enable();
                                                                                    Ext.getCmp('fecALTADULColesterolTotalFecha').enable();
                                                                                    Ext.getCmp('strALTADULColesterolTotalDescripcion').allowBlank = false;
                                                                                    Ext.getCmp('fecALTADULColesterolTotalFecha').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        html: ' - '
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 250,
                                                                        allowBlank: true,
                                                                        name: 'Colesterol Total Descripcion',
                                                                        id: 'strALTADULColesterolTotalDescripcion'
                                                                    },
                                                                    {
                                                                        html: ' - '
                                                                    },
                                                                    {
                                                                        xtype: 'datefield',
                                                                        name: 'Colesterol Total Fecha',
                                                                        emptyText: '(dia/mes/año)',
                                                                        width: 120,
                                                                        allowBlank: true,
                                                                        id: 'fecALTADULColesterolTotalFecha'
                                                                    }
                                                                ]
                                                            },
                                                            {   
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Colesterol HDL',
                                                                        fieldLabel: 'Colesterol HDL',
                                                                        width: 60,
                                                                        allowBlank: true,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strALTADULColesterolHDL',
                                                                        listeners:{
                                                                            change : function( t, newValue, oldValue){
                                                                                if(newValue === "NO"){
                                                                                    Ext.getCmp('strALTADULColesterolHDLDescripcion').allowBlank = true;
                                                                                    Ext.getCmp('fecALTADULColesterolHDLFecha').allowBlank = true;
                                                                                    Ext.getCmp('strALTADULColesterolHDLDescripcion').disable();
                                                                                    Ext.getCmp('fecALTADULColesterolHDLFecha').disable();
                                                                                    Ext.getCmp('strALTADULColesterolHDLDescripcion').clearInvalid();
                                                                                    Ext.getCmp('fecALTADULColesterolHDLFecha').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('strALTADULColesterolHDLDescripcion').enable();
                                                                                    Ext.getCmp('fecALTADULColesterolHDLFecha').enable();
                                                                                    Ext.getCmp('strALTADULColesterolHDLDescripcion').allowBlank = false;
                                                                                    Ext.getCmp('fecALTADULColesterolHDLFecha').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        html: ' - '
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 250,
                                                                        allowBlank: true,
                                                                        name: 'Colesterol HDL Descripcion',
                                                                        id: 'strALTADULColesterolHDLDescripcion'
                                                                    },
                                                                    {
                                                                        html: ' - '
                                                                    },
                                                                    {
                                                                        xtype: 'datefield',
                                                                        name: 'Colesterol HDL Fecha',
                                                                        emptyText: '(dia/mes/año)',
                                                                        width: 120,
                                                                        allowBlank: true,
                                                                        id: 'fecALTADULColesterolHDLFecha'
                                                                    }
                                                                ]
                                                            },
                                                            {   
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Trigliceridos',
                                                                        fieldLabel: 'Trigliceridos',
                                                                        width: 60,
                                                                        allowBlank: true,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strALTADULTrigliceridos',
                                                                        listeners:{
                                                                            change : function( t, newValue, oldValue){
                                                                                if(newValue === "NO"){
                                                                                    Ext.getCmp('strALTADULTrigliceridosDescripcion').allowBlank = true;
                                                                                    Ext.getCmp('fecALTADULTrigliceridosFecha').allowBlank = true;
                                                                                    Ext.getCmp('strALTADULTrigliceridosDescripcion').disable();
                                                                                    Ext.getCmp('fecALTADULTrigliceridosFecha').disable();
                                                                                    Ext.getCmp('strALTADULTrigliceridosDescripcion').clearInvalid();
                                                                                    Ext.getCmp('fecALTADULTrigliceridosFecha').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('strALTADULTrigliceridosDescripcion').enable();
                                                                                    Ext.getCmp('fecALTADULTrigliceridosFecha').enable();
                                                                                    Ext.getCmp('strALTADULTrigliceridosDescripcion').allowBlank = false;
                                                                                    Ext.getCmp('fecALTADULTrigliceridosFecha').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        html: ' - '
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 250,
                                                                        allowBlank: true,
                                                                        name: 'Trigliceridos Descripcion',
                                                                        id: 'strALTADULTrigliceridosDescripcion'
                                                                    },
                                                                    {
                                                                        html: ' - '
                                                                    },
                                                                    {
                                                                        xtype: 'datefield',
                                                                        name: 'Trigliceridos Fecha',
                                                                        emptyText: '(dia/mes/año)',
                                                                        width: 120,
                                                                        allowBlank: true,
                                                                        id: 'fecALTADULTrigliceridosFecha'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        fieldLabel: 'Educacion Programa del Adulto',
                                                        name: 'Educacion Programa del Adulto',
                                                        allowBlank: true,
                                                        id: 'memAdultoEducacion'
                                                    }
                                                ]
                                            },
                                            //------------ FIN HC PROGRAMAS
                                            {
                                                xtype: 'fieldset',
                                                title: 'INFORMACION PROXIMA CITA',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 5,
                                                items: [
                                                        {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'datefield',
                                                                width: 120,
                                                                fieldLabel: 'Fecha Probable Proxima Cita',
                                                                name: 'Fecha Probable Proxima Cita',
                                                                allowBlank: true,
                                                                emptyText: '(dia/mes/año) ',
                                                                style: 'text-align:center;',
                                                                id: 'fecPROXCITACita'
                                                            },
                                                            {
                                                                html: 'Profesional que Atiende'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Profesional que Atiende',
                                                                width: 250,
                                                                allowBlank: true,
                                                                store: stProfesionalAtiende,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strPROXCITAProfesionalAtiende'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'Observacion',
                                                        name: 'Observacion',
                                                        height: 100,
                                                        allowBlank: true,
                                                        id: 'memPROXCITAObservacion'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'CONDUCTA',
                                                layout: 'table',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'CONDUCTA',
                                                        name: 'CONDUCTA',
                                                        height: 100,
                                                        allowBlank: false,
                                                        id: 'memConducta'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'INCAPACIDAD',
                                                layout: 'form',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        fieldLabel: 'Dias',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 50,
                                                                name: 'INCAPACIDAD DIAS',
                                                                minValue: 0,
                                                                allowBlank: true,
                                                                style: 'text-align:center;',
                                                                id: 'intDiasIncapacidad',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        //new Date(año,mes,dia) 01/05/2010
                                                                        if(Ext.getCmp('fecDesdeIncapacidad').getValue() === null || Ext.getCmp('fecDesdeIncapacidad').getValue() === ""){
                                                                            Ext.getCmp('fecDesdeIncapacidad').setValue(new Date().format('d/m/Y'));
                                                                        }
                                                                        var xFecha = Ext.getCmp('fecDesdeIncapacidad').getValue().format('d/m/Y');
                                                                        var xMes = xFecha.substr(3,2);
                                                                        var NewFecha = new Date(xFecha.substr(6,10),(xMes-1),xFecha.substr(0,2));
                                                                        if(pNew > 0)
                                                                            DiasIncapacidad = pNew - 1;
                                                                        else
                                                                            DiasIncapacidad = pNew;
                                                                        NewFecha.setDate(NewFecha.getDate()+DiasIncapacidad);
                                                                        Ext.getCmp('fecHastaIncapacidad').setValue(NewFecha.format('d/m/Y'));
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysIncDsd',
                                                                value: 'Desde:'
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 120,
                                                                name: 'INCAPACIDAD DESDE',
                                                                allowBlank: true,
                                                                disabledDates: '',
                                                                emptyText: '(dia/mes/año) ',
                                                                style: 'text-align:center;',
                                                                id: 'fecDesdeIncapacidad',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        Ext.getCmp('fecHastaIncapacidad').setValue(null);
                                                                        Ext.getCmp('fecHastaIncapacidad').setMinValue(pNew.format("d/m/Y"));
                                                                        Ext.getCmp('fecHastaIncapacidad').clearInvalid();
                                                                        var xFecha = pNew.format('d/m/Y');
                                                                        var xMes = xFecha.substr(3,2);
                                                                        var NewFecha = new Date(xFecha.substr(6,10),(xMes-1),xFecha.substr(0,2));
                                                                        if(Ext.getCmp('intDiasIncapacidad').getValue() > 0){
                                                                            DiasIncapacidad = Ext.getCmp('intDiasIncapacidad').getValue() - 1;
                                                                        }else{
                                                                            DiasIncapacidad = Ext.getCmp('intDiasIncapacidad').getValue();
                                                                        }
                                                                        NewFecha.setDate(NewFecha.getDate()+DiasIncapacidad);
                                                                        Ext.getCmp('fecHastaIncapacidad').setValue(NewFecha.format('d/m/Y'));
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysIncHst',
                                                                value: 'Hasta:'
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 120,
                                                                name: 'INCAPACIDAD HASTA',
                                                                allowBlank: true,
                                                                disabledDates: '',
                                                                emptyText: '(dia/mes/año) ',
                                                                style: 'text-align:center;',
                                                                id: 'fecHastaIncapacidad'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        fieldLabel: 'Observaciones',
                                                        items: [
                                                            {
                                                                xtype: 'textarea',
                                                                anchor: '100%',
                                                                width: 615,
                                                                name: 'INCAPACIDAD OBSERVACIONES',
                                                                height: 50,
                                                                allowBlank: true,
                                                                id: 'memIncapacidadObserva'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnImprimir',
                                                                text: 'Imprimir Incapacidad',
                                                                tooltip: 'Imprimir Incapacidad',
                                                                id: 'btnPrintIncapacidadHC',
                                                                listeners:{
                                                                    click : function(){
                                                                        if (parseInt(Ext.getCmp('sysYaGuardoHC').getValue()) === 1)
                                                                            window.open ("../../controlador/asistencial/printincapacidad0.php?pEmpresa=" + ID_EMPRESA + "&pIPS=" + ID_IPS + "&pPaciente=" + Ext.getCmp('sysIdPacienteHC').getValue() + "&pCAS=" + Ext.getCmp('sysCASHC').getValue() + "&pConsecutivo=" + Ext.getCmp('sysConsecutivoDetalleHC').getValue(),"Incapacidad");
                                                                        else{
                                                                            Ext.Msg.show({
                                                                                title: 'eOfiClinic',
                                                                                msg: 'Usted No ha Guardado la Evolución',
                                                                                buttons: Ext.Msg.OK,
                                                                                icon: Ext.Msg.ERROR
                                                                            });
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                html: '<hr>'
                                            },
                                            xVerResumenDxxPaciente,
                                            {
                                                html: '<hr>'
                                            },
                                            fsDiagnosticosConsulta,
                                            {
                                                xtype: 'fieldset',
                                                title: 'SOLICITUD DE MEDICAMENTOS',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: false,
                                                titleCollapse: false,
                                                anchor: '100%',
                                                autoHeight: true,
                                                items: [
                                                    xSolMX
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'SOLICITUD DE SERVICIOS Y/O EXAMENES',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: false,
                                                titleCollapse: false,
                                                anchor: '100%',
                                                autoHeight: true,
                                                items: [
                                                    xSolEXA
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'SOLICITUD DE REMISIONES REF/CONTRA REF.',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: false,
                                                titleCollapse: false,
                                                anchor: '100%',
                                                autoHeight: true,
                                                items: [
                                                    xSolREM
                                                ]
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Alertas',
                                height: 380,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaAlertas',
                                items: [
                                    xAlertasxPaciente
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Ver Documentos Anexos',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaDocumentosAnexos',
                                layout: 'form',
                                items: [
                                    xDocumentosAnexos
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Reporte de Resultados',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaParaclinicos',
                                layout: 'form',
                                items: [
                                     {
                                        xtype: 'grid',
                                        title: ' ',
                                        id: 'gridReporteParaclinicos',
                                        store: stReporteParaclinicos,
                                        anchor: "100%",
                                        height: 320,
                                        border: false,
                                        frame: true,
                                        loadMask: true,
                                        colModel: new Ext.ux.grid.LockingColumnModel([
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Id',
                                                sortable: false,
                                                width: 1,
                                                hidden: true,
                                                hideable: false,
                                                dataIndex: 'IdConsecutivoReporte'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Descripcion',
                                                sortable: false,
                                                width: 300,
                                                dataIndex: 'DescProced'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Fecha Solicitud',
                                                sortable: false,
                                                width: 90,
                                                dataIndex: 'FechaSolicitud'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Fecha Realiza',
                                                sortable: false,
                                                width: 120,
                                                dataIndex: 'FechaRealizacion'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Reporte',
                                                sortable: false,
                                                width: 150,
                                                renderer: renderValorReporte,
                                                dataIndex: 'ReporteTxt'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Observaciones',
                                                sortable: false,
                                                width: 150,
                                                renderer: renderObservaReporte,
                                                dataIndex: 'Observaciones'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Clasificacion',
                                                sortable: false,
                                                width: 80,
                                                renderer: renderClasificacionReporte,
                                                dataIndex: 'Clasificacion'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Solicitante',
                                                sortable: false,
                                                width: 150,
                                                dataIndex: 'Solicitante'
                                            }
                                        ]),
                                        selModel: new Ext.grid.RowSelectionModel({singleSelect:false}),
                                        viewConfig: {
                                            getRowClass: function(record, index) {
                                                if (record.get('Estado') === 'S')
                                                    return 'Negado';
                                                else
                                                    return;
                                            }
                                        },
                                        iconCls:'icon-grid',
                                        tbar:
                                            {
                                                xtype: 'toolbar',
                                                items: [
                                                    {
                                                        xtype: 'button',
                                                        text: 'Adicionar',
                                                        iconCls: 'btnAddRow',
                                                        listeners: {
                                                            click : function() {
                                                                var winReporteParaclinicos = new winReporteParaclinicos001Ui();
                                                                Ext.getCmp('intPacienteReporteParaclin').setValue(wPaciente);
                                                                Ext.getCmp('intCASReporteParaclin').setValue(wCAS);
                                                                Ext.getCmp('intUsuarioReporteParaclin').setValue(ID_USUARIO);
                                                                Ext.getCmp('intIdConsecutivoReporteParaclin').setValue(0);
                                                                winReporteParaclinicos.show();
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'tbseparator'
                                                    },
                                                    {
                                                        xtype: 'button',
                                                        text: 'Reportar',
                                                        iconCls: 'btnEditRow',
                                                        listeners: {
                                                            click : function() {
                                                                if(Ext.getCmp('gridReporteParaclinicos').selModel.getCount() === 1){
                                                                    var selections = Ext.getCmp('gridReporteParaclinicos').selModel.getSelections();
                                                                    if(parseInt(selections[0].json.CASReporte) === parseInt(wCAS)){
                                                                        var winReporteParaclinicos = new winReporteParaclinicos001Ui();
                                                                        Ext.getCmp('intPacienteReporteParaclin').setValue(wPaciente);
                                                                        Ext.getCmp('intCASReporteParaclin').setValue(wCAS);
                                                                        Ext.getCmp('intUsuarioReporteParaclin').setValue(ID_USUARIO);
                                                                        Ext.getCmp('intIdConsecutivoReporteParaclin').setValue(selections[0].json.IdConsecutivoReporte);
                                                                        Ext.getCmp('intConceptoOfiMedicalReporteParaclin').setValue(selections[0].json.IdProced);
                                                                        Ext.getCmp('strNomConceptoOfiMedicalReporteParaclin').setValue(selections[0].json.DescProced);
                                                                        Ext.getCmp('strNomQuienSolicitaReporteParaclin').setValue(selections[0].json.Solicitante);
                                                                        Ext.getCmp('fecFecSolicitudReporteParaclin').setValue(selections[0].json.FechaSolicitud);
                                                                        Ext.getCmp('fecFecRealizacionReporteParaclin').setValue(selections[0].json.FechaRealizacion);
                                                                        Ext.getCmp('strResultadoReporteParaclin').setValue(selections[0].json.ReporteTxt);
                                                                        Ext.getCmp('intValorReporteParaclin').setValue(selections[0].json.ReporteVal);
                                                                        Ext.getCmp('strClasificacionReporteParaclin').setValue(selections[0].json.Clasificacion);
                                                                        Ext.getCmp('strObservacionesReporteParaclin').setValue(selections[0].json.Observaciones);
                                                                        Ext.getCmp('sysSearchReporteParaclin').setVisible(false);
                                                                        winReporteParaclinicos.show();
                                                                    }else{
                                                                        if(selections[0].json.Estado === "S"){
                                                                            var winReporteParaclinicos = new winReporteParaclinicos001Ui();
                                                                            Ext.getCmp('intPacienteReporteParaclin').setValue(wPaciente);
                                                                            Ext.getCmp('intCASReporteParaclin').setValue(wCAS);
                                                                            Ext.getCmp('intUsuarioReporteParaclin').setValue(ID_USUARIO);
                                                                            Ext.getCmp('intIdConsecutivoReporteParaclin').setValue(selections[0].json.IdConsecutivoReporte);
                                                                            Ext.getCmp('intConceptoOfiMedicalReporteParaclin').setValue(selections[0].json.IdProced);
                                                                            Ext.getCmp('strNomConceptoOfiMedicalReporteParaclin').setValue(selections[0].json.DescProced);
                                                                            Ext.getCmp('strNomQuienSolicitaReporteParaclin').setValue(selections[0].json.Solicitante);
                                                                            //Ext.getCmp('strNomQuienSolicitaReporteParaclin').setReadOnly(true);
                                                                            Ext.getCmp('fecFecSolicitudReporteParaclin').setValue(selections[0].json.FechaSolicitud);
                                                                            Ext.getCmp('fecFecRealizacionReporteParaclin').setValue(selections[0].json.FechaRealizacion);
                                                                            Ext.getCmp('sysSearchReporteParaclin').setVisible(false);
                                                                            winReporteParaclinicos.show();
                                                                        }else{
                                                                            Ext.MessageBox.show({
                                                                                title: 'Error',
                                                                                msg: 'El registro no esta disponible para ser reportado',
                                                                                buttons: Ext.MessageBox.OK,
                                                                                icon: Ext.MessageBox.ERROR
                                                                            });
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'tbseparator'
                                                    },
                                                    {
                                                        xtype: 'button',
                                                        text: 'Eliminar',
                                                        iconCls: 'btnDelRow',
                                                        listeners: {
                                                            click : function() {
                                                                if(Ext.getCmp('gridReporteParaclinicos').selModel.getCount() === 1){
                                                                    var selections = Ext.getCmp('gridReporteParaclinicos').selModel.getSelections();
                                                                    if((selections[0].json.CAS === null || selections[0].json.CAS === "") && selections[0].json.Estado === "S" && parseInt(selections[0].json.Usuario) === parseInt(Ext.getCmp('sysUsuarioHC').getValue())){
                                                                        Ext.Msg.show({
                                                                            title: 'Reporte Paraclinicos',
                                                                            msg: 'Esta Seguro que Desea Eliminar el Registro ' + selections[0].json.DescProced + '?',
                                                                            buttons: Ext.Msg.YESNO,
                                                                            icon: Ext.Msg.QUESTION,
                                                                            fn: function(btn){
                                                                                if(btn ==="yes"){
                                                                                    fnEliminarRegistrosReporteParaclinicos001("../../controlador/asistencial/evolucionhc2013.php",{task: "ELIMINAR_REPORTEEXA", pIdReporte: selections[0].json.IdConsecutivoReporte}, 'gridReporteParaclinicos');
                                                                                }
                                                                            }
                                                                        });
                                                                    }else{
                                                                        Ext.MessageBox.show({
                                                                            title: 'Error',
                                                                            msg: 'No podemos eliminar los registro en estos momentos',
                                                                            buttons: Ext.MessageBox.OK,
                                                                            icon: Ext.MessageBox.ERROR
                                                                        });
                                                                    }
                                                                }else{
                                                                    Ext.MessageBox.show({
                                                                        title: 'Error',
                                                                        msg: 'No podemos eliminar los registros en estos momentos, verifique que solo haya seleccionado un registro',
                                                                        buttons: Ext.MessageBox.OK,
                                                                        icon: Ext.MessageBox.ERROR
                                                                    });
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'tbseparator'
                                                    },
                                                    '->',
                                                    new Ext.app.SearchField({
                                                        id: 'qryReporteParaclin',
                                                        store: stReporteParaclinicos,
                                                        ValparamP1: wPaciente,
                                                        emptyText: 'Escriba el criterio que desea buscar',
                                                        width: 120,
                                                        pLoadGrid: false,
                                                        pGrid: 'gridReporteParaclinicos',
                                                        parrParam: {params:{pPaciente: wPaciente}}
                                                    })
                                                ]
                                            }
                                    }
                                ]
                            },
                            /*{
                                xtype: 'panel',
                                title: 'Solicitud Medicamentos',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaMedicamentos',
                                items: [
                                    xSolMX
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Servicios',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaServicios',
                                items: [
                                    xSolEXA
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Remisiones',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaRemisiones',
                                items: [
                                    xSolREM
                                ]
                            },
                            */
                            {
                                xtype: 'panel',
                                title: 'Solicitud NO POS',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaNOPOS',
                                items: [
                                    xSolNOPOS
                                ]
                            },
                            /*{
                                xtype: 'panel',
                                title: 'Actividades Adicionales',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaActividadesAdicionales',
                                layout: 'form',
                                items: [
                                    xGridActividadesAdicionales
                                ]
                            },*/
                            {
                                xtype: 'panel',
                                title: 'Vacunacion',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaVacunacion',
                                layout: 'form',
                                items: [
                                    xGridVacunacion
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Guias de Manejo',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaGuiasManejo',
                                layout: 'form',
                                items: [
                                    xGuiasAtencion
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Fichas de Notificacion',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaFichasNotificacion',
                                layout: 'form',
                                items: [
                                    xFichasNotificacion
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Consentimientos Informados',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaConsentimientos',
                                layout: 'form',
                                items: [
                                    xConsentimientosInformados
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Notificacion Eventos Adversos',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaEventosAdversos',
                                layout: 'form',
                                items: [
                                    xEventosAdversos
                                ]
                            }
                            /*
                            {
                                xtype: 'panel',
                                title: 'Kardex PyP - Programas Especiales',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaKardex',
                                layout: 'form',
                                items: [
                                    xKardexProgramas
                                ]
                            }*/
                        ]
                    }
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Salir',
                            iconCls: 'btnSalir',
                            id: 'btnSalirEvolucion',
                            listeners:{
                                click : function(){
                                    if (parseInt(Ext.getCmp('sysYaGuardoHC').getValue()) === 1)
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn === "yes")
                                                {
                                                    Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.getCmp('winHCMedGen').close();
                                                }
                                            }
                                        });
                                    else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Usted No ha Guardado la Evolución del Paciente y Se Perdera la Información, Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn === "yes")
                                                {
                                                    Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.getCmp('winHCMedGen').close();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                },
                tbar:{
                    items: [
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Ver Historia Clínica',
                            iconCls: 'btnVerHC',
                            id: 'btnVerHC',
                            listeners:{
                                click : function(){
                                    var cmpResumenHC = new winFrmVerHistorialHC({
                                        renderTo: Ext.getBody()
                                    });
                                    Ext.getCmp('winViewEvolucionHC').title = "PACIENTE: " + Ext.getCmp('sysPacienteHC').getValue();
                                    Ext.getCmp('gridHistorialEvoluciones').store.load({
                                        params: {
                                            pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                                            pPaciente: Ext.getCmp('sysIdPacienteHC').getValue()
                                        }
                                    });
                                    cmpResumenHC.show();
                                }
                            }
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Ver Informacion Adicional',
                            iconCls: 'btnVerHC',
                            listeners:{
                                click : function(){ 
                                    verInfoActividadesxPaciente(Ext.getCmp('sysIdPacienteHC').getValue(),Ext.getCmp('sysPacienteHC').getValue() + " - Genero: " + Ext.getCmp('sysGeneroHC').getValue() + " - Edad: " + Ext.getCmp('sysEdadHC').getValue());
                                }
                            }
                        },
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar Evolución',
                            iconCls: 'btnGuardar',
                            id: 'btnGuardarEvolucion',
                            listeners:{
                                click : function(){
                                    if (parseInt(Ext.getCmp('sysYaGuardoHC').getValue()) == 0)
                                    {
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Guardar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn === "yes")
                                                {
                                                    fnGuardarRegistrosMedicinaGeneral();
                                                }
                                            }
                                        });
                                    }else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Modificar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn === "yes")
                                                {
                                                    fnModificarRegistrosMedicinaGeneral();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                }
            }
        ];
        this.on({
            afterlayout:{
                scope:this, 
                single:true, 
                fn:function() {
                    Ext.Msg.hide();
                    if(paramOpcion === "Nuevo"){ 
                        var frm = Ext.getCmp('frmHCMedGen').getForm();
                        frm.doAction('load', {
                            url: '../../controlador/asistencial/evolucionhc2014.php',
                            waitMsg: 'Cargando Información...',
                            params:{
                                pCAS: myCAS,
                                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                                task: 'ImportarAntecedentesPersonalesOfiClinic002'
                            },
                            failure: function(response,options){
                                importarfactoresriesgo4505('frmHCMedGen', myCAS, Ext.getCmp('sysIdPacienteHC').getValue(),"MORBILIDAD");
                            },
                            success:function(form, action) {
                                importarfactoresriesgo4505('frmHCMedGen', myCAS, Ext.getCmp('sysIdPacienteHC').getValue(),"MORBILIDAD");
                            }
                        });
                    }
                    //Cargar Guias de Atencion
                    Ext.getCmp('gridGuiasAtencion').store.load({
                        params: {
                            pPlantilla: Ext.getCmp('sysIdCodPlantillaHC').getValue()
                        }
                    });
                    //Cargar Documentos Anexos
                    Ext.getCmp('gridDocumentosAnexos').store.baseParams = {
                        task: 'verDocumentosAnexosHC',
                        pPaciente: Ext.getCmp('sysIdPacienteHC').getValue()
                    };
                    Ext.getCmp('gridDocumentosAnexos').store.load();
                    
                    calculoEdadPacienteMeses();
                    //DEFINICION DE LA HSTORIA CLINICA DE AGUDEZA VISUAL
                    if(parseInt(AniosCumplidos) === 4 || parseInt(AniosCumplidos) === 11 || parseInt(AniosCumplidos) === 16 || parseInt(AniosCumplidos) === 45){
                        Ext.Ajax.request({
                            url: '../../controlador/asistencial/controladorhc2016.php',
                            params:{
                                task: 'CHECK_CONSULTA_AGUDEZA',
                                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue()
                            },
                            success: function(response,options){
                                var el = Ext.get('response'); // get the LOG
                                var Respuesta = response.responseText;
                                var Contenido = Respuesta.split('^');
                                if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null || Contenido[0] === "SI"  || Contenido[0] === "{failure:true}"){
                                    Ext.getCmp('fsAgudezaVisual').setVisible(false);
                                    Ext.getCmp('sysReqPrgAgudezaVisual').setValue(0);
                                    Ext.getCmp('strInfPrgAgudezaVisual').setValue(null);
                                    Ext.getCmp('strAGUVISMedicionOI').allowBlank = true;
                                    Ext.getCmp('strAGUVISMedicionOI').clearInvalid();
                                    Ext.getCmp('strAGUVISMedicionOI').setValue(null);
                                    Ext.getCmp('strAGUVISMedicionOD').allowBlank = true;
                                    Ext.getCmp('strAGUVISMedicionOD').clearInvalid();
                                    Ext.getCmp('strAGUVISMedicionOD').setValue(null);
                                    Ext.getCmp('memGUVISPlan').allowBlank = true;
                                    Ext.getCmp('memGUVISPlan').clearInvalid();
                                    Ext.getCmp('memGUVISPlan').setValue(null);
                                    Ext.getCmp('strAGUVISRemisionOft').allowBlank = true;
                                    Ext.getCmp('strAGUVISRemisionOft').clearInvalid();
                                    Ext.getCmp('strAGUVISRemisionOft').setValue(null);
                                }else{
                                    Ext.getCmp('sysReqPrgAgudezaVisual').setValue(1);
                                    Ext.getCmp('strInfPrgAgudezaVisual').setValue("HISTORIA ATENCION PROGRAMA AGUDEZA VISUAL");
                                    Ext.getCmp('strAGUVISMedicionOI').allowBlank = false;
                                    Ext.getCmp('strAGUVISMedicionOD').allowBlank = false;
                                    Ext.getCmp('memGUVISPlan').allowBlank = false;
                                    Ext.getCmp('strAGUVISRemisionOft').allowBlank = false;
                                }
                            },
                            failure: function(response,options){
                                Ext.getCmp('fsAgudezaVisual').setVisible(false);
                                Ext.getCmp('sysReqPrgAgudezaVisual').setValue(0);
                                Ext.getCmp('strInfPrgAgudezaVisual').setValue(null);
                                Ext.getCmp('strAGUVISMedicionOI').allowBlank = true;
                                Ext.getCmp('strAGUVISMedicionOI').clearInvalid();
                                Ext.getCmp('strAGUVISMedicionOI').setValue(null);
                                Ext.getCmp('strAGUVISMedicionOD').allowBlank = true;
                                Ext.getCmp('strAGUVISMedicionOD').clearInvalid();
                                Ext.getCmp('strAGUVISMedicionOD').setValue(null);
                                Ext.getCmp('memGUVISPlan').allowBlank = true;
                                Ext.getCmp('memGUVISPlan').clearInvalid();
                                Ext.getCmp('memGUVISPlan').setValue(null);
                                Ext.getCmp('strAGUVISRemisionOft').allowBlank = true;
                                Ext.getCmp('strAGUVISRemisionOft').clearInvalid();
                                Ext.getCmp('strAGUVISRemisionOft').setValue(null);
                            },
                            scope:this //bind the callbacks
                        });
                    }else{
                        Ext.getCmp('fsAgudezaVisual').setVisible(false);
                        Ext.getCmp('sysReqPrgAgudezaVisual').setValue(0);
                        Ext.getCmp('strInfPrgAgudezaVisual').setValue(null);
                        Ext.getCmp('strAGUVISMedicionOI').allowBlank = true;
                        Ext.getCmp('strAGUVISMedicionOI').clearInvalid();
                        Ext.getCmp('strAGUVISMedicionOI').setValue(null);
                        Ext.getCmp('strAGUVISMedicionOD').allowBlank = true;
                        Ext.getCmp('strAGUVISMedicionOD').clearInvalid();
                        Ext.getCmp('strAGUVISMedicionOD').setValue(null);
                        Ext.getCmp('memGUVISPlan').allowBlank = true;
                        Ext.getCmp('memGUVISPlan').clearInvalid();
                        Ext.getCmp('memGUVISPlan').setValue(null);
                        Ext.getCmp('strAGUVISRemisionOft').allowBlank = true;
                        Ext.getCmp('strAGUVISRemisionOft').clearInvalid();
                        Ext.getCmp('strAGUVISRemisionOft').setValue(null);
                    }
                    //DEFINICION DE LA HSTORIA CLINICA DEL JOVEN
                    if(parseInt(AniosCumplidos) >= 10 && parseInt(AniosCumplidos) < 30){
                        Ext.Ajax.request({
                            url: '../../controlador/asistencial/controladorhc2016.php',
                            params:{
                                task: 'CHECK_CONSULTA_JOVEN',
                                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue()
                            },
                            success: function(response,options){
                                var el = Ext.get('response'); // get the LOG
                                var Respuesta = response.responseText;
                                var Contenido = Respuesta.split('^');
                                if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null || Contenido[0] === "SI"){
                                    Ext.getCmp('fsProgramaJoven').setVisible(false);
                                    Ext.getCmp('sysReqPrgJoven').setValue(0);
                                    Ext.getCmp('strInfPrgJoven').setValue(null);
                                    Ext.getCmp('strJovenOcupacionPadres').allowBlank = true;
                                    Ext.getCmp('strJovenOcupacionPadres').clearInvalid();
                                    Ext.getCmp('strJovenOcupacionPadres').setValue(null);
                                    Ext.getCmp('strALTJOVDependencia').allowBlank = true;
                                    Ext.getCmp('strALTJOVDependencia').clearInvalid();
                                    Ext.getCmp('strALTJOVDependencia').setValue(null);
                                    Ext.getCmp('strALTJOVRelIntrafamiliares').allowBlank = true;
                                    Ext.getCmp('strALTJOVRelIntrafamiliares').clearInvalid();
                                    Ext.getCmp('strALTJOVRelIntrafamiliares').setValue(null);
                                    Ext.getCmp('strALTJOVRelInterpersonales').allowBlank = true;
                                    Ext.getCmp('strALTJOVRelInterpersonales').clearInvalid();
                                    Ext.getCmp('strALTJOVRelInterpersonales').setValue(null);
                                    Ext.getCmp('strALTJOVComIntrafamiliar').allowBlank = true;
                                    Ext.getCmp('strALTJOVComIntrafamiliar').clearInvalid();
                                    Ext.getCmp('strALTJOVComIntrafamiliar').setValue(null);
                                    Ext.getCmp('strALTJOVVidaSexual').allowBlank = true;
                                    Ext.getCmp('strALTJOVVidaSexual').clearInvalid();
                                    Ext.getCmp('strALTJOVVidaSexual').setValue(null);
                                    Ext.getCmp('memALTJOVproyectoVida').allowBlank = true;
                                    Ext.getCmp('memALTJOVproyectoVida').clearInvalid();
                                    Ext.getCmp('memALTJOVproyectoVida').setValue(null);
                                    Ext.getCmp('bolALTJOVFumador').allowBlank = true;
                                    Ext.getCmp('bolALTJOVFumador').clearInvalid();
                                    Ext.getCmp('bolALTJOVFumador').setValue(null);
                                    Ext.getCmp('bolALTJOVAlcohol').allowBlank = true;
                                    Ext.getCmp('bolALTJOVAlcohol').clearInvalid();
                                    Ext.getCmp('bolALTJOVAlcohol').setValue(null);
                                    Ext.getCmp('bolALTJOVSustPsicoa').allowBlank = true;
                                    Ext.getCmp('bolALTJOVSustPsicoa').clearInvalid();
                                    Ext.getCmp('bolALTJOVSustPsicoa').setValue(null);
                                    Ext.getCmp('bolALTJOVDietaSaludable').allowBlank = true;
                                    Ext.getCmp('bolALTJOVDietaSaludable').clearInvalid();
                                    Ext.getCmp('bolALTJOVDietaSaludable').setValue(null);
                                    Ext.getCmp('bolALTJOVActFisica').allowBlank = true;
                                    Ext.getCmp('bolALTJOVActFisica').clearInvalid();
                                    Ext.getCmp('bolALTJOVActFisica').setValue(null);
                                    Ext.getCmp('bolALTJOVManejoStress').allowBlank = true;
                                    Ext.getCmp('bolALTJOVManejoStress').clearInvalid();
                                    Ext.getCmp('bolALTJOVManejoStress').setValue(null);
                                    Ext.getCmp('strJovenConvulsiones').allowBlank = true;
                                    Ext.getCmp('strJovenConvulsiones').clearInvalid();
                                    Ext.getCmp('strJovenConvulsiones').setValue(null);
                                    Ext.getCmp('strALTJOVHemoglo').allowBlank = true;
                                    Ext.getCmp('strALTJOVHemoglo').clearInvalid();
                                    Ext.getCmp('strALTJOVHemoglo').setValue(null);
                                    Ext.getCmp('strALTJOVHemogloDescripcion').allowBlank = true;
                                    Ext.getCmp('strALTJOVHemogloDescripcion').clearInvalid();
                                    Ext.getCmp('strALTJOVHemogloDescripcion').setValue(null);
                                    Ext.getCmp('fecALTJOVHemogloFecha').allowBlank = true;
                                    Ext.getCmp('fecALTJOVHemogloFecha').clearInvalid();
                                    Ext.getCmp('fecALTJOVHemogloFecha').setValue(null);
                                    Ext.getCmp('strJovenColesterolTotal').allowBlank = true;
                                    Ext.getCmp('strJovenColesterolTotal').clearInvalid();
                                    Ext.getCmp('strJovenColesterolTotal').setValue(null);
                                    Ext.getCmp('strJovenColesterolTotalDescripcion').allowBlank = true;
                                    Ext.getCmp('strJovenColesterolTotalDescripcion').clearInvalid();
                                    Ext.getCmp('strJovenColesterolTotalDescripcion').setValue(null);
                                    Ext.getCmp('fecJovenColesterolTotalFecha').allowBlank = true;
                                    Ext.getCmp('fecJovenColesterolTotalFecha').clearInvalid();
                                    Ext.getCmp('fecJovenColesterolTotalFecha').setValue(null);
                                    Ext.getCmp('strJovenColesterolHDL').allowBlank = true;
                                    Ext.getCmp('strJovenColesterolHDL').clearInvalid();
                                    Ext.getCmp('strJovenColesterolHDL').setValue(null);
                                    Ext.getCmp('strJovenColesterolHDLDescripcion').allowBlank = true;
                                    Ext.getCmp('strJovenColesterolHDLDescripcion').clearInvalid();
                                    Ext.getCmp('strJovenColesterolHDLDescripcion').setValue(null);
                                    Ext.getCmp('fecJovenColesterolHDLFecha').allowBlank = true;
                                    Ext.getCmp('fecJovenColesterolHDLFecha').clearInvalid();
                                    Ext.getCmp('fecJovenColesterolHDLFecha').setValue(null);
                                    Ext.getCmp('strJovenVDRL').allowBlank = true;
                                    Ext.getCmp('strJovenVDRL').clearInvalid();
                                    Ext.getCmp('strJovenVDRL').setValue(null);
                                    Ext.getCmp('strJovenVDRLDescripcion').allowBlank = true;
                                    Ext.getCmp('strJovenVDRLDescripcion').clearInvalid();
                                    Ext.getCmp('strJovenVDRLDescripcion').setValue(null);
                                    Ext.getCmp('fecJovenVDRLFecha').allowBlank = true;
                                    Ext.getCmp('fecJovenVDRLFecha').clearInvalid();
                                    Ext.getCmp('fecJovenVDRLFecha').setValue(null);
                                    Ext.getCmp('strJovenVIH').allowBlank = true;
                                    Ext.getCmp('strJovenVIH').clearInvalid();
                                    Ext.getCmp('strJovenVIH').setValue(null);
                                    Ext.getCmp('strJovenVIHDescripcion').allowBlank = true;
                                    Ext.getCmp('strJovenVIHDescripcion').clearInvalid();
                                    Ext.getCmp('strJovenVIHDescripcion').setValue(null);
                                    Ext.getCmp('fecJovenVIHFecha').allowBlank = true;
                                    Ext.getCmp('fecJovenVIHFecha').clearInvalid();
                                    Ext.getCmp('fecJovenVIHFecha').setValue(null);
                                    Ext.getCmp('strJovenTanner').allowBlank = true;
                                    Ext.getCmp('strJovenTanner').clearInvalid();
                                    Ext.getCmp('strJovenTanner').setValue(null);
                                    Ext.getCmp('memJovenEducacion').allowBlank = true;
                                    Ext.getCmp('memJovenEducacion').clearInvalid();
                                    Ext.getCmp('memJovenEducacion').setValue(null);
                                } else {
                                    Ext.getCmp('sysReqPrgJoven').setValue(1);
                                    Ext.getCmp('strInfPrgJoven').setValue("HISTORIA ATENCION PROGRAMA DEL JOVEN");
                                    Ext.getCmp('strJovenOcupacionPadres').allowBlank = false;
                                    Ext.getCmp('strALTJOVDependencia').allowBlank = false;
                                    Ext.getCmp('strALTJOVRelIntrafamiliares').allowBlank = false;
                                    Ext.getCmp('strALTJOVRelInterpersonales').allowBlank = false;
                                    Ext.getCmp('strALTJOVComIntrafamiliar').allowBlank = false;
                                    Ext.getCmp('strALTJOVVidaSexual').allowBlank = false;
                                    Ext.getCmp('memALTJOVproyectoVida').allowBlank = false;
                                    Ext.getCmp('bolALTJOVFumador').allowBlank = false;
                                    Ext.getCmp('bolALTJOVAlcohol').allowBlank = false;
                                    Ext.getCmp('bolALTJOVSustPsicoa').allowBlank = false;
                                    Ext.getCmp('bolALTJOVDietaSaludable').allowBlank = false;
                                    Ext.getCmp('bolALTJOVActFisica').allowBlank = false;
                                    Ext.getCmp('bolALTJOVManejoStress').allowBlank = false;
                                    Ext.getCmp('strJovenConvulsiones').allowBlank = false;
                                    Ext.getCmp('memJovenEducacion').allowBlank = false;
                                }
                            },
                            failure: function(response,options){
                                Ext.getCmp('fsProgramaJoven').setVisible(false);
                                Ext.getCmp('sysReqPrgJoven').setValue(0);
                                Ext.getCmp('strInfPrgJoven').setValue(null);
                                Ext.getCmp('strJovenOcupacionPadres').allowBlank = true;
                                Ext.getCmp('strJovenOcupacionPadres').clearInvalid();
                                Ext.getCmp('strJovenOcupacionPadres').setValue(null);
                                Ext.getCmp('strALTJOVDependencia').allowBlank = true;
                                Ext.getCmp('strALTJOVDependencia').clearInvalid();
                                Ext.getCmp('strALTJOVDependencia').setValue(null);
                                Ext.getCmp('strALTJOVRelIntrafamiliares').allowBlank = true;
                                Ext.getCmp('strALTJOVRelIntrafamiliares').clearInvalid();
                                Ext.getCmp('strALTJOVRelIntrafamiliares').setValue(null);
                                Ext.getCmp('strALTJOVRelInterpersonales').allowBlank = true;
                                Ext.getCmp('strALTJOVRelInterpersonales').clearInvalid();
                                Ext.getCmp('strALTJOVRelInterpersonales').setValue(null);
                                Ext.getCmp('strALTJOVComIntrafamiliar').allowBlank = true;
                                Ext.getCmp('strALTJOVComIntrafamiliar').clearInvalid();
                                Ext.getCmp('strALTJOVComIntrafamiliar').setValue(null);
                                Ext.getCmp('strALTJOVVidaSexual').allowBlank = true;
                                Ext.getCmp('strALTJOVVidaSexual').clearInvalid();
                                Ext.getCmp('strALTJOVVidaSexual').setValue(null);
                                Ext.getCmp('memALTJOVproyectoVida').allowBlank = true;
                                Ext.getCmp('memALTJOVproyectoVida').clearInvalid();
                                Ext.getCmp('memALTJOVproyectoVida').setValue(null);
                                Ext.getCmp('bolALTJOVFumador').allowBlank = true;
                                Ext.getCmp('bolALTJOVFumador').clearInvalid();
                                Ext.getCmp('bolALTJOVFumador').setValue(null);
                                Ext.getCmp('bolALTJOVAlcohol').allowBlank = true;
                                Ext.getCmp('bolALTJOVAlcohol').clearInvalid();
                                Ext.getCmp('bolALTJOVAlcohol').setValue(null);
                                Ext.getCmp('bolALTJOVSustPsicoa').allowBlank = true;
                                Ext.getCmp('bolALTJOVSustPsicoa').clearInvalid();
                                Ext.getCmp('bolALTJOVSustPsicoa').setValue(null);
                                Ext.getCmp('bolALTJOVDietaSaludable').allowBlank = true;
                                Ext.getCmp('bolALTJOVDietaSaludable').clearInvalid();
                                Ext.getCmp('bolALTJOVDietaSaludable').setValue(null);
                                Ext.getCmp('bolALTJOVActFisica').allowBlank = true;
                                Ext.getCmp('bolALTJOVActFisica').clearInvalid();
                                Ext.getCmp('bolALTJOVActFisica').setValue(null);
                                Ext.getCmp('bolALTJOVManejoStress').allowBlank = true;
                                Ext.getCmp('bolALTJOVManejoStress').clearInvalid();
                                Ext.getCmp('bolALTJOVManejoStress').setValue(null);
                                Ext.getCmp('strJovenConvulsiones').allowBlank = true;
                                Ext.getCmp('strJovenConvulsiones').clearInvalid();
                                Ext.getCmp('strJovenConvulsiones').setValue(null);
                                Ext.getCmp('strALTJOVHemoglo').allowBlank = true;
                                Ext.getCmp('strALTJOVHemoglo').clearInvalid();
                                Ext.getCmp('strALTJOVHemoglo').setValue(null);
                                Ext.getCmp('strALTJOVHemogloDescripcion').allowBlank = true;
                                Ext.getCmp('strALTJOVHemogloDescripcion').clearInvalid();
                                Ext.getCmp('strALTJOVHemogloDescripcion').setValue(null);
                                Ext.getCmp('fecALTJOVHemogloFecha').allowBlank = true;
                                Ext.getCmp('fecALTJOVHemogloFecha').clearInvalid();
                                Ext.getCmp('fecALTJOVHemogloFecha').setValue(null);
                                Ext.getCmp('strJovenColesterolTotal').allowBlank = true;
                                Ext.getCmp('strJovenColesterolTotal').clearInvalid();
                                Ext.getCmp('strJovenColesterolTotal').setValue(null);
                                Ext.getCmp('strJovenColesterolTotalDescripcion').allowBlank = true;
                                Ext.getCmp('strJovenColesterolTotalDescripcion').clearInvalid();
                                Ext.getCmp('strJovenColesterolTotalDescripcion').setValue(null);
                                Ext.getCmp('fecJovenColesterolTotalFecha').allowBlank = true;
                                Ext.getCmp('fecJovenColesterolTotalFecha').clearInvalid();
                                Ext.getCmp('fecJovenColesterolTotalFecha').setValue(null);
                                Ext.getCmp('strJovenColesterolHDL').allowBlank = true;
                                Ext.getCmp('strJovenColesterolHDL').clearInvalid();
                                Ext.getCmp('strJovenColesterolHDL').setValue(null);
                                Ext.getCmp('strJovenColesterolHDLDescripcion').allowBlank = true;
                                Ext.getCmp('strJovenColesterolHDLDescripcion').clearInvalid();
                                Ext.getCmp('strJovenColesterolHDLDescripcion').setValue(null);
                                Ext.getCmp('fecJovenColesterolHDLFecha').allowBlank = true;
                                Ext.getCmp('fecJovenColesterolHDLFecha').clearInvalid();
                                Ext.getCmp('fecJovenColesterolHDLFecha').setValue(null);
                                Ext.getCmp('strJovenVDRL').allowBlank = true;
                                Ext.getCmp('strJovenVDRL').clearInvalid();
                                Ext.getCmp('strJovenVDRL').setValue(null);
                                Ext.getCmp('strJovenVDRLDescripcion').allowBlank = true;
                                Ext.getCmp('strJovenVDRLDescripcion').clearInvalid();
                                Ext.getCmp('strJovenVDRLDescripcion').setValue(null);
                                Ext.getCmp('fecJovenVDRLFecha').allowBlank = true;
                                Ext.getCmp('fecJovenVDRLFecha').clearInvalid();
                                Ext.getCmp('fecJovenVDRLFecha').setValue(null);
                                Ext.getCmp('strJovenVIH').allowBlank = true;
                                Ext.getCmp('strJovenVIH').clearInvalid();
                                Ext.getCmp('strJovenVIH').setValue(null);
                                Ext.getCmp('strJovenVIHDescripcion').allowBlank = true;
                                Ext.getCmp('strJovenVIHDescripcion').clearInvalid();
                                Ext.getCmp('strJovenVIHDescripcion').setValue(null);
                                Ext.getCmp('fecJovenVIHFecha').allowBlank = true;
                                Ext.getCmp('fecJovenVIHFecha').clearInvalid();
                                Ext.getCmp('fecJovenVIHFecha').setValue(null);
                                Ext.getCmp('strJovenTanner').allowBlank = true;
                                Ext.getCmp('strJovenTanner').clearInvalid();
                                Ext.getCmp('strJovenTanner').setValue(null);
                                Ext.getCmp('memJovenEducacion').allowBlank = true;
                                Ext.getCmp('memJovenEducacion').clearInvalid();
                                Ext.getCmp('memJovenEducacion').setValue(null);
                            },
                            scope:this //bind the callbacks
                        });
                    }else{
                        Ext.getCmp('fsProgramaJoven').setVisible(false);
                        Ext.getCmp('sysReqPrgJoven').setValue(0);
                        Ext.getCmp('strInfPrgJoven').setValue(null);
                        Ext.getCmp('strJovenOcupacionPadres').allowBlank = true;
                        Ext.getCmp('strJovenOcupacionPadres').clearInvalid();
                        Ext.getCmp('strJovenOcupacionPadres').setValue(null);
                        Ext.getCmp('strALTJOVDependencia').allowBlank = true;
                        Ext.getCmp('strALTJOVDependencia').clearInvalid();
                        Ext.getCmp('strALTJOVDependencia').setValue(null);
                        Ext.getCmp('strALTJOVRelIntrafamiliares').allowBlank = true;
                        Ext.getCmp('strALTJOVRelIntrafamiliares').clearInvalid();
                        Ext.getCmp('strALTJOVRelIntrafamiliares').setValue(null);
                        Ext.getCmp('strALTJOVRelInterpersonales').allowBlank = true;
                        Ext.getCmp('strALTJOVRelInterpersonales').clearInvalid();
                        Ext.getCmp('strALTJOVRelInterpersonales').setValue(null);
                        Ext.getCmp('strALTJOVComIntrafamiliar').allowBlank = true;
                        Ext.getCmp('strALTJOVComIntrafamiliar').clearInvalid();
                        Ext.getCmp('strALTJOVComIntrafamiliar').setValue(null);
                        Ext.getCmp('strALTJOVVidaSexual').allowBlank = true;
                        Ext.getCmp('strALTJOVVidaSexual').clearInvalid();
                        Ext.getCmp('strALTJOVVidaSexual').setValue(null);
                        Ext.getCmp('memALTJOVproyectoVida').allowBlank = true;
                        Ext.getCmp('memALTJOVproyectoVida').clearInvalid();
                        Ext.getCmp('memALTJOVproyectoVida').setValue(null);
                        Ext.getCmp('bolALTJOVFumador').allowBlank = true;
                        Ext.getCmp('bolALTJOVFumador').clearInvalid();
                        Ext.getCmp('bolALTJOVFumador').setValue(null);
                        Ext.getCmp('bolALTJOVAlcohol').allowBlank = true;
                        Ext.getCmp('bolALTJOVAlcohol').clearInvalid();
                        Ext.getCmp('bolALTJOVAlcohol').setValue(null);
                        Ext.getCmp('bolALTJOVSustPsicoa').allowBlank = true;
                        Ext.getCmp('bolALTJOVSustPsicoa').clearInvalid();
                        Ext.getCmp('bolALTJOVSustPsicoa').setValue(null);
                        Ext.getCmp('bolALTJOVDietaSaludable').allowBlank = true;
                        Ext.getCmp('bolALTJOVDietaSaludable').clearInvalid();
                        Ext.getCmp('bolALTJOVDietaSaludable').setValue(null);
                        Ext.getCmp('bolALTJOVActFisica').allowBlank = true;
                        Ext.getCmp('bolALTJOVActFisica').clearInvalid();
                        Ext.getCmp('bolALTJOVActFisica').setValue(null);
                        Ext.getCmp('bolALTJOVManejoStress').allowBlank = true;
                        Ext.getCmp('bolALTJOVManejoStress').clearInvalid();
                        Ext.getCmp('bolALTJOVManejoStress').setValue(null);
                        Ext.getCmp('strJovenConvulsiones').allowBlank = true;
                        Ext.getCmp('strJovenConvulsiones').clearInvalid();
                        Ext.getCmp('strJovenConvulsiones').setValue(null);
                        Ext.getCmp('strALTJOVHemoglo').allowBlank = true;
                        Ext.getCmp('strALTJOVHemoglo').clearInvalid();
                        Ext.getCmp('strALTJOVHemoglo').setValue(null);
                        Ext.getCmp('strALTJOVHemogloDescripcion').allowBlank = true;
                        Ext.getCmp('strALTJOVHemogloDescripcion').clearInvalid();
                        Ext.getCmp('strALTJOVHemogloDescripcion').setValue(null);
                        Ext.getCmp('fecALTJOVHemogloFecha').allowBlank = true;
                        Ext.getCmp('fecALTJOVHemogloFecha').clearInvalid();
                        Ext.getCmp('fecALTJOVHemogloFecha').setValue(null);
                        Ext.getCmp('strJovenColesterolTotal').allowBlank = true;
                        Ext.getCmp('strJovenColesterolTotal').clearInvalid();
                        Ext.getCmp('strJovenColesterolTotal').setValue(null);
                        Ext.getCmp('strJovenColesterolTotalDescripcion').allowBlank = true;
                        Ext.getCmp('strJovenColesterolTotalDescripcion').clearInvalid();
                        Ext.getCmp('strJovenColesterolTotalDescripcion').setValue(null);
                        Ext.getCmp('fecJovenColesterolTotalFecha').allowBlank = true;
                        Ext.getCmp('fecJovenColesterolTotalFecha').clearInvalid();
                        Ext.getCmp('fecJovenColesterolTotalFecha').setValue(null);
                        Ext.getCmp('strJovenColesterolHDL').allowBlank = true;
                        Ext.getCmp('strJovenColesterolHDL').clearInvalid();
                        Ext.getCmp('strJovenColesterolHDL').setValue(null);
                        Ext.getCmp('strJovenColesterolHDLDescripcion').allowBlank = true;
                        Ext.getCmp('strJovenColesterolHDLDescripcion').clearInvalid();
                        Ext.getCmp('strJovenColesterolHDLDescripcion').setValue(null);
                        Ext.getCmp('fecJovenColesterolHDLFecha').allowBlank = true;
                        Ext.getCmp('fecJovenColesterolHDLFecha').clearInvalid();
                        Ext.getCmp('fecJovenColesterolHDLFecha').setValue(null);
                        Ext.getCmp('strJovenVDRL').allowBlank = true;
                        Ext.getCmp('strJovenVDRL').clearInvalid();
                        Ext.getCmp('strJovenVDRL').setValue(null);
                        Ext.getCmp('strJovenVDRLDescripcion').allowBlank = true;
                        Ext.getCmp('strJovenVDRLDescripcion').clearInvalid();
                        Ext.getCmp('strJovenVDRLDescripcion').setValue(null);
                        Ext.getCmp('fecJovenVDRLFecha').allowBlank = true;
                        Ext.getCmp('fecJovenVDRLFecha').clearInvalid();
                        Ext.getCmp('fecJovenVDRLFecha').setValue(null);
                        Ext.getCmp('strJovenVIH').allowBlank = true;
                        Ext.getCmp('strJovenVIH').clearInvalid();
                        Ext.getCmp('strJovenVIH').setValue(null);
                        Ext.getCmp('strJovenVIHDescripcion').allowBlank = true;
                        Ext.getCmp('strJovenVIHDescripcion').clearInvalid();
                        Ext.getCmp('strJovenVIHDescripcion').setValue(null);
                        Ext.getCmp('fecJovenVIHFecha').allowBlank = true;
                        Ext.getCmp('fecJovenVIHFecha').clearInvalid();
                        Ext.getCmp('fecJovenVIHFecha').setValue(null);
                        Ext.getCmp('strJovenTanner').allowBlank = true;
                        Ext.getCmp('strJovenTanner').clearInvalid();
                        Ext.getCmp('strJovenTanner').setValue(null);
                        Ext.getCmp('memJovenEducacion').allowBlank = true;
                        Ext.getCmp('memJovenEducacion').clearInvalid();
                        Ext.getCmp('memJovenEducacion').setValue(null);
                    }
                    //DEFINICION DE LA HISTORIA CLINICA PLANIFICACION FAMILIAR
                    if(parseInt(AniosCumplidos) >= 10 && parseInt(AniosCumplidos) <= 59 && Ext.getCmp('sysGeneroHC').getValue() === "FEMENINO"){
                        Ext.Ajax.request({
                            url: '../../controlador/asistencial/controladorhc2016.php',
                            params:{
                                task: 'CHECK_CONSULTA_PLANIFICACION',
                                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue()
                            },
                            success: function(response,options){
                                var el = Ext.get('response'); // get the LOG
                                var Respuesta = response.responseText;
                                var Contenido = Respuesta.split('^');
                                if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null || Contenido[0] === "SI"  || Contenido[0] === "{failure:true}"){
                                    Ext.getCmp('fsProgramaPlanificacionFam').setVisible(false);
                                    Ext.getCmp('sysReqPrgPlanificaFam').setValue(0);
                                    Ext.getCmp('strInfPrgPlanificaFam').setValue(null);
                                    Ext.getCmp('strPLANIFAMIMetodoPlanifica').allowBlank = true;
                                    Ext.getCmp('strPLANIFAMIMetodoPlanifica').clearInvalid();
                                    Ext.getCmp('strPLANIFAMIMetodoPlanifica').setValue(null);
                                    Ext.getCmp('strPLANIFAMIToleraMetodo').allowBlank = true;
                                    Ext.getCmp('strPLANIFAMIToleraMetodo').clearInvalid();
                                    Ext.getCmp('strPLANIFAMIToleraMetodo').setValue(null);
                                    Ext.getCmp('strPlanificacionLactanciaHoy').allowBlank = true;
                                    Ext.getCmp('strPlanificacionLactanciaHoy').clearInvalid();
                                    Ext.getCmp('strPlanificacionLactanciaHoy').setValue(null);
                                    Ext.getCmp('strPlanificacionLactanciaPasado').allowBlank = true;
                                    Ext.getCmp('strPlanificacionLactanciaPasado').clearInvalid();
                                    Ext.getCmp('strPlanificacionLactanciaPasado').setValue(null);
                                    Ext.getCmp('strPlanificacionTiempoLactancia').allowBlank = true;
                                    Ext.getCmp('strPlanificacionTiempoLactancia').clearInvalid();
                                    Ext.getCmp('strPlanificacionTiempoLactancia').setValue(null);
                                    Ext.getCmp('strPLANIFAMICambioMetodo').allowBlank = true;
                                    Ext.getCmp('strPLANIFAMICambioMetodo').clearInvalid();
                                    Ext.getCmp('strPLANIFAMICambioMetodo').setValue(null);
                                    Ext.getCmp('strPLANIFAMINuevoMetodo').allowBlank = true;
                                    Ext.getCmp('strPLANIFAMINuevoMetodo').clearInvalid();
                                    Ext.getCmp('strPLANIFAMINuevoMetodo').setValue(null);
                                    Ext.getCmp('fecPLANIFAMIFecCambioMetodo').allowBlank = true;
                                    Ext.getCmp('fecPLANIFAMIFecCambioMetodo').clearInvalid();
                                    Ext.getCmp('fecPLANIFAMIFecCambioMetodo').setValue(null);
                                    Ext.getCmp('memPLANIFAMIEducacion').allowBlank = true;
                                    Ext.getCmp('memPLANIFAMIEducacion').clearInvalid();
                                    Ext.getCmp('memPLANIFAMIEducacion').setValue(null);
                                }else{
                                    Ext.getCmp('sysReqPrgPlanificaFam').setValue(1);
                                    Ext.getCmp('strInfPrgPlanificaFam').setValue("HISTORIA ATENCION PROGRAMA PLANIFICACION FAMILIAR");
                                    Ext.getCmp('strPLANIFAMIMetodoPlanifica').allowBlank = false;
                                    Ext.getCmp('strPLANIFAMIToleraMetodo').allowBlank = false;
                                    Ext.getCmp('strPlanificacionLactanciaHoy').allowBlank = false;
                                    Ext.getCmp('strPlanificacionLactanciaPasado').allowBlank = false;
                                    Ext.getCmp('strPLANIFAMICambioMetodo').allowBlank = false;
                                    Ext.getCmp('memPLANIFAMIEducacion').allowBlank = false;
                                }
                            },
                            failure: function(response,options){
                                Ext.getCmp('fsProgramaPlanificacionFam').setVisible(false);
                                Ext.getCmp('sysReqPrgPlanificaFam').setValue(0);
                                Ext.getCmp('strInfPrgPlanificaFam').setValue(null);
                                Ext.getCmp('strPLANIFAMIMetodoPlanifica').allowBlank = true;
                                Ext.getCmp('strPLANIFAMIMetodoPlanifica').clearInvalid();
                                Ext.getCmp('strPLANIFAMIMetodoPlanifica').setValue(null);
                                Ext.getCmp('strPLANIFAMIToleraMetodo').allowBlank = true;
                                Ext.getCmp('strPLANIFAMIToleraMetodo').clearInvalid();
                                Ext.getCmp('strPLANIFAMIToleraMetodo').setValue(null);
                                Ext.getCmp('strPlanificacionLactanciaHoy').allowBlank = true;
                                Ext.getCmp('strPlanificacionLactanciaHoy').clearInvalid();
                                Ext.getCmp('strPlanificacionLactanciaHoy').setValue(null);
                                Ext.getCmp('strPlanificacionLactanciaPasado').allowBlank = true;
                                Ext.getCmp('strPlanificacionLactanciaPasado').clearInvalid();
                                Ext.getCmp('strPlanificacionLactanciaPasado').setValue(null);
                                Ext.getCmp('strPlanificacionTiempoLactancia').allowBlank = true;
                                Ext.getCmp('strPlanificacionTiempoLactancia').clearInvalid();
                                Ext.getCmp('strPlanificacionTiempoLactancia').setValue(null);
                                Ext.getCmp('strPLANIFAMICambioMetodo').allowBlank = true;
                                Ext.getCmp('strPLANIFAMICambioMetodo').clearInvalid();
                                Ext.getCmp('strPLANIFAMICambioMetodo').setValue(null);
                                Ext.getCmp('strPLANIFAMINuevoMetodo').allowBlank = true;
                                Ext.getCmp('strPLANIFAMINuevoMetodo').clearInvalid();
                                Ext.getCmp('strPLANIFAMINuevoMetodo').setValue(null);
                                Ext.getCmp('fecPLANIFAMIFecCambioMetodo').allowBlank = true;
                                Ext.getCmp('fecPLANIFAMIFecCambioMetodo').clearInvalid();
                                Ext.getCmp('fecPLANIFAMIFecCambioMetodo').setValue(null);
                                Ext.getCmp('memPLANIFAMIEducacion').allowBlank = true;
                                Ext.getCmp('memPLANIFAMIEducacion').clearInvalid();
                                Ext.getCmp('memPLANIFAMIEducacion').setValue(null);
                            },
                            scope:this //bind the callbacks
                        });
                    }else{
                        Ext.getCmp('fsProgramaPlanificacionFam').setVisible(false);
                        Ext.getCmp('sysReqPrgPlanificaFam').setValue(0);
                        Ext.getCmp('strInfPrgPlanificaFam').setValue(null);
                        Ext.getCmp('strPLANIFAMIMetodoPlanifica').allowBlank = true;
                        Ext.getCmp('strPLANIFAMIMetodoPlanifica').clearInvalid();
                        Ext.getCmp('strPLANIFAMIMetodoPlanifica').setValue(null);
                        Ext.getCmp('strPLANIFAMIToleraMetodo').allowBlank = true;
                        Ext.getCmp('strPLANIFAMIToleraMetodo').clearInvalid();
                        Ext.getCmp('strPLANIFAMIToleraMetodo').setValue(null);
                        Ext.getCmp('strPlanificacionLactanciaHoy').allowBlank = true;
                        Ext.getCmp('strPlanificacionLactanciaHoy').clearInvalid();
                        Ext.getCmp('strPlanificacionLactanciaHoy').setValue(null);
                        Ext.getCmp('strPlanificacionLactanciaPasado').allowBlank = true;
                        Ext.getCmp('strPlanificacionLactanciaPasado').clearInvalid();
                        Ext.getCmp('strPlanificacionLactanciaPasado').setValue(null);
                        Ext.getCmp('strPlanificacionTiempoLactancia').allowBlank = true;
                        Ext.getCmp('strPlanificacionTiempoLactancia').clearInvalid();
                        Ext.getCmp('strPlanificacionTiempoLactancia').setValue(null);
                        Ext.getCmp('strPLANIFAMICambioMetodo').allowBlank = true;
                        Ext.getCmp('strPLANIFAMICambioMetodo').clearInvalid();
                        Ext.getCmp('strPLANIFAMICambioMetodo').setValue(null);
                        Ext.getCmp('strPLANIFAMINuevoMetodo').allowBlank = true;
                        Ext.getCmp('strPLANIFAMINuevoMetodo').clearInvalid();
                        Ext.getCmp('strPLANIFAMINuevoMetodo').setValue(null);
                        Ext.getCmp('fecPLANIFAMIFecCambioMetodo').allowBlank = true;
                        Ext.getCmp('fecPLANIFAMIFecCambioMetodo').clearInvalid();
                        Ext.getCmp('fecPLANIFAMIFecCambioMetodo').setValue(null);
                        Ext.getCmp('memPLANIFAMIEducacion').allowBlank = true;
                        Ext.getCmp('memPLANIFAMIEducacion').clearInvalid();
                        Ext.getCmp('memPLANIFAMIEducacion').setValue(null);
                    }
                    //DEFINICION DE LA HISTORIA CLINICA ADULTO
                    if(parseInt(AniosCumplidos) === 45 || parseInt(AniosCumplidos) === 50 || parseInt(AniosCumplidos) === 55 || parseInt(AniosCumplidos) === 60 || parseInt(AniosCumplidos) === 65 || parseInt(AniosCumplidos) === 70 || parseInt(AniosCumplidos) === 75 || parseInt(AniosCumplidos) === 80 || parseInt(AniosCumplidos) === 85 || parseInt(AniosCumplidos) === 90 || parseInt(AniosCumplidos) === 95 || parseInt(AniosCumplidos) >= 100){
                        Ext.Ajax.request({
                            url: '../../controlador/asistencial/controladorhc2016.php',
                            params:{
                                task: 'CHECK_CONSULTA_ADULTO',
                                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue()
                            },
                            success: function(response,options){
                                var el = Ext.get('response'); // get the LOG
                                var Respuesta = response.responseText;
                                var Contenido = Respuesta.split('^');
                                if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null || Contenido[0] === "SI"  || Contenido[0] === "{failure:true}"){
                                    Ext.getCmp('fsAlteracionesAdulto').setVisible(false);
                                    Ext.getCmp('sysReqPrgAdulto').setValue(0);
                                    Ext.getCmp('strInfPrgAdulto').setValue(null);
                                    Ext.getCmp('bolALTADULFumador').allowBlank = true;
                                    Ext.getCmp('bolALTADULFumador').clearInvalid();
                                    Ext.getCmp('bolALTADULFumador').setValue(null);
                                    Ext.getCmp('bolALTADULAlcohol').allowBlank = true;
                                    Ext.getCmp('bolALTADULAlcohol').clearInvalid();
                                    Ext.getCmp('bolALTADULAlcohol').setValue(null);
                                    Ext.getCmp('bolALTADULSustPsicoa').allowBlank = true;
                                    Ext.getCmp('bolALTADULSustPsicoa').clearInvalid();
                                    Ext.getCmp('bolALTADULSustPsicoa').setValue(null);
                                    Ext.getCmp('bolALTADULDietaSaludable').allowBlank = true;
                                    Ext.getCmp('bolALTADULDietaSaludable').clearInvalid();
                                    Ext.getCmp('bolALTADULDietaSaludable').setValue(null);
                                    Ext.getCmp('bolALTADULActFisica').allowBlank = true;
                                    Ext.getCmp('bolALTADULActFisica').clearInvalid();
                                    Ext.getCmp('bolALTADULActFisica').setValue(null);
                                    Ext.getCmp('bolALTADULManejoStress').allowBlank = true;
                                    Ext.getCmp('bolALTADULManejoStress').clearInvalid();
                                    Ext.getCmp('bolALTADULManejoStress').setValue(null);
                                    Ext.getCmp('strALTADULUroanalisis').allowBlank = true;
                                    Ext.getCmp('strALTADULUroanalisis').clearInvalid();
                                    Ext.getCmp('strALTADULUroanalisis').setValue(null);
                                    Ext.getCmp('strALTADULUroanalisisDescripcion').allowBlank = true;
                                    Ext.getCmp('strALTADULUroanalisisDescripcion').clearInvalid();
                                    Ext.getCmp('strALTADULUroanalisisDescripcion').setValue(null);
                                    Ext.getCmp('fecALTADULUroanalisisFecha').allowBlank = true;
                                    Ext.getCmp('fecALTADULUroanalisisFecha').clearInvalid();
                                    Ext.getCmp('fecALTADULUroanalisisFecha').setValue(null);
                                    Ext.getCmp('strALTADULCreatinina').allowBlank = true;
                                    Ext.getCmp('strALTADULCreatinina').clearInvalid();
                                    Ext.getCmp('strALTADULCreatinina').setValue(null);
                                    Ext.getCmp('strALTADULCreatininaDescripcion').allowBlank = true;
                                    Ext.getCmp('strALTADULCreatininaDescripcion').clearInvalid();
                                    Ext.getCmp('strALTADULCreatininaDescripcion').setValue(null);
                                    Ext.getCmp('fecALTADULCreatininaFecha').allowBlank = true;
                                    Ext.getCmp('fecALTADULCreatininaFecha').clearInvalid();
                                    Ext.getCmp('fecALTADULCreatininaFecha').setValue(null);
                                    Ext.getCmp('strALTADULGlicemia').allowBlank = true;
                                    Ext.getCmp('strALTADULGlicemia').clearInvalid();
                                    Ext.getCmp('strALTADULGlicemia').setValue(null);
                                    Ext.getCmp('strALTADULGlicemiaDescripcion').allowBlank = true;
                                    Ext.getCmp('strALTADULGlicemiaDescripcion').clearInvalid();
                                    Ext.getCmp('strALTADULGlicemiaDescripcion').setValue(null);
                                    Ext.getCmp('fecALTADULGlicemiaFecha').allowBlank = true;
                                    Ext.getCmp('fecALTADULGlicemiaFecha').clearInvalid();
                                    Ext.getCmp('fecALTADULGlicemiaFecha').setValue(null);
                                    Ext.getCmp('strALTADULColesterolTotal').allowBlank = true;
                                    Ext.getCmp('strALTADULColesterolTotal').clearInvalid();
                                    Ext.getCmp('strALTADULColesterolTotal').setValue(null);
                                    Ext.getCmp('strALTADULColesterolTotalDescripcion').allowBlank = true;
                                    Ext.getCmp('strALTADULColesterolTotalDescripcion').clearInvalid();
                                    Ext.getCmp('strALTADULColesterolTotalDescripcion').setValue(null);
                                    Ext.getCmp('fecALTADULColesterolTotalFecha').allowBlank = true;
                                    Ext.getCmp('fecALTADULColesterolTotalFecha').clearInvalid();
                                    Ext.getCmp('fecALTADULColesterolTotalFecha').setValue(null);
                                    Ext.getCmp('strALTADULColesterolHDL').allowBlank = true;
                                    Ext.getCmp('strALTADULColesterolHDL').clearInvalid();
                                    Ext.getCmp('strALTADULColesterolHDL').setValue(null);
                                    Ext.getCmp('strALTADULColesterolHDLDescripcion').allowBlank = true;
                                    Ext.getCmp('strALTADULColesterolHDLDescripcion').clearInvalid();
                                    Ext.getCmp('strALTADULColesterolHDLDescripcion').setValue(null);
                                    Ext.getCmp('fecALTADULColesterolHDLFecha').allowBlank = true;
                                    Ext.getCmp('fecALTADULColesterolHDLFecha').clearInvalid();
                                    Ext.getCmp('fecALTADULColesterolHDLFecha').setValue(null);
                                    Ext.getCmp('strALTADULTrigliceridos').allowBlank = true;
                                    Ext.getCmp('strALTADULTrigliceridos').clearInvalid();
                                    Ext.getCmp('strALTADULTrigliceridos').setValue(null);
                                    Ext.getCmp('strALTADULTrigliceridosDescripcion').allowBlank = true;
                                    Ext.getCmp('strALTADULTrigliceridosDescripcion').clearInvalid();
                                    Ext.getCmp('strALTADULTrigliceridosDescripcion').setValue(null);
                                    Ext.getCmp('fecALTADULTrigliceridosFecha').allowBlank = true;
                                    Ext.getCmp('fecALTADULTrigliceridosFecha').clearInvalid();
                                    Ext.getCmp('fecALTADULTrigliceridosFecha').setValue(null);
                                    Ext.getCmp('memAdultoEducacion').allowBlank = true;
                                    Ext.getCmp('memAdultoEducacion').clearInvalid();
                                    Ext.getCmp('memAdultoEducacion').setValue(null);
                                }else{
                                    Ext.getCmp('sysReqPrgAdulto').setValue(1);
                                    Ext.getCmp('strInfPrgAdulto').setValue("HISTORIA ATENCION PROGRAMA DEL ADULTO");
                                    Ext.getCmp('bolALTADULFumador').allowBlank = false;
                                    Ext.getCmp('bolALTADULAlcohol').allowBlank = false;
                                    Ext.getCmp('bolALTADULSustPsicoa').allowBlank = false;
                                    Ext.getCmp('bolALTADULDietaSaludable').allowBlank = false;
                                    Ext.getCmp('bolALTADULActFisica').allowBlank = false;
                                    Ext.getCmp('bolALTADULManejoStress').allowBlank = false;
                                    Ext.getCmp('memAdultoEducacion').allowBlank = false;
                                }
                            },
                            failure: function(response,options){
                                Ext.getCmp('fsAlteracionesAdulto').setVisible(false);
                                Ext.getCmp('sysReqPrgAdulto').setValue(0);
                                Ext.getCmp('strInfPrgAdulto').setValue(null);
                                Ext.getCmp('bolALTADULFumador').allowBlank = true;
                                Ext.getCmp('bolALTADULFumador').clearInvalid();
                                Ext.getCmp('bolALTADULFumador').setValue(null);
                                Ext.getCmp('bolALTADULAlcohol').allowBlank = true;
                                Ext.getCmp('bolALTADULAlcohol').clearInvalid();
                                Ext.getCmp('bolALTADULAlcohol').setValue(null);
                                Ext.getCmp('bolALTADULSustPsicoa').allowBlank = true;
                                Ext.getCmp('bolALTADULSustPsicoa').clearInvalid();
                                Ext.getCmp('bolALTADULSustPsicoa').setValue(null);
                                Ext.getCmp('bolALTADULDietaSaludable').allowBlank = true;
                                Ext.getCmp('bolALTADULDietaSaludable').clearInvalid();
                                Ext.getCmp('bolALTADULDietaSaludable').setValue(null);
                                Ext.getCmp('bolALTADULActFisica').allowBlank = true;
                                Ext.getCmp('bolALTADULActFisica').clearInvalid();
                                Ext.getCmp('bolALTADULActFisica').setValue(null);
                                Ext.getCmp('bolALTADULManejoStress').allowBlank = true;
                                Ext.getCmp('bolALTADULManejoStress').clearInvalid();
                                Ext.getCmp('bolALTADULManejoStress').setValue(null);
                                Ext.getCmp('strALTADULUroanalisis').allowBlank = true;
                                Ext.getCmp('strALTADULUroanalisis').clearInvalid();
                                Ext.getCmp('strALTADULUroanalisis').setValue(null);
                                Ext.getCmp('strALTADULUroanalisisDescripcion').allowBlank = true;
                                Ext.getCmp('strALTADULUroanalisisDescripcion').clearInvalid();
                                Ext.getCmp('strALTADULUroanalisisDescripcion').setValue(null);
                                Ext.getCmp('fecALTADULUroanalisisFecha').allowBlank = true;
                                Ext.getCmp('fecALTADULUroanalisisFecha').clearInvalid();
                                Ext.getCmp('fecALTADULUroanalisisFecha').setValue(null);
                                Ext.getCmp('strALTADULCreatinina').allowBlank = true;
                                Ext.getCmp('strALTADULCreatinina').clearInvalid();
                                Ext.getCmp('strALTADULCreatinina').setValue(null);
                                Ext.getCmp('strALTADULCreatininaDescripcion').allowBlank = true;
                                Ext.getCmp('strALTADULCreatininaDescripcion').clearInvalid();
                                Ext.getCmp('strALTADULCreatininaDescripcion').setValue(null);
                                Ext.getCmp('fecALTADULCreatininaFecha').allowBlank = true;
                                Ext.getCmp('fecALTADULCreatininaFecha').clearInvalid();
                                Ext.getCmp('fecALTADULCreatininaFecha').setValue(null);
                                Ext.getCmp('strALTADULGlicemia').allowBlank = true;
                                Ext.getCmp('strALTADULGlicemia').clearInvalid();
                                Ext.getCmp('strALTADULGlicemia').setValue(null);
                                Ext.getCmp('strALTADULGlicemiaDescripcion').allowBlank = true;
                                Ext.getCmp('strALTADULGlicemiaDescripcion').clearInvalid();
                                Ext.getCmp('strALTADULGlicemiaDescripcion').setValue(null);
                                Ext.getCmp('fecALTADULGlicemiaFecha').allowBlank = true;
                                Ext.getCmp('fecALTADULGlicemiaFecha').clearInvalid();
                                Ext.getCmp('fecALTADULGlicemiaFecha').setValue(null);
                                Ext.getCmp('strALTADULColesterolTotal').allowBlank = true;
                                Ext.getCmp('strALTADULColesterolTotal').clearInvalid();
                                Ext.getCmp('strALTADULColesterolTotal').setValue(null);
                                Ext.getCmp('strALTADULColesterolTotalDescripcion').allowBlank = true;
                                Ext.getCmp('strALTADULColesterolTotalDescripcion').clearInvalid();
                                Ext.getCmp('strALTADULColesterolTotalDescripcion').setValue(null);
                                Ext.getCmp('fecALTADULColesterolTotalFecha').allowBlank = true;
                                Ext.getCmp('fecALTADULColesterolTotalFecha').clearInvalid();
                                Ext.getCmp('fecALTADULColesterolTotalFecha').setValue(null);
                                Ext.getCmp('strALTADULColesterolHDL').allowBlank = true;
                                Ext.getCmp('strALTADULColesterolHDL').clearInvalid();
                                Ext.getCmp('strALTADULColesterolHDL').setValue(null);
                                Ext.getCmp('strALTADULColesterolHDLDescripcion').allowBlank = true;
                                Ext.getCmp('strALTADULColesterolHDLDescripcion').clearInvalid();
                                Ext.getCmp('strALTADULColesterolHDLDescripcion').setValue(null);
                                Ext.getCmp('fecALTADULColesterolHDLFecha').allowBlank = true;
                                Ext.getCmp('fecALTADULColesterolHDLFecha').clearInvalid();
                                Ext.getCmp('fecALTADULColesterolHDLFecha').setValue(null);
                                Ext.getCmp('strALTADULTrigliceridos').allowBlank = true;
                                Ext.getCmp('strALTADULTrigliceridos').clearInvalid();
                                Ext.getCmp('strALTADULTrigliceridos').setValue(null);
                                Ext.getCmp('strALTADULTrigliceridosDescripcion').allowBlank = true;
                                Ext.getCmp('strALTADULTrigliceridosDescripcion').clearInvalid();
                                Ext.getCmp('strALTADULTrigliceridosDescripcion').setValue(null);
                                Ext.getCmp('fecALTADULTrigliceridosFecha').allowBlank = true;
                                Ext.getCmp('fecALTADULTrigliceridosFecha').clearInvalid();
                                Ext.getCmp('fecALTADULTrigliceridosFecha').setValue(null);
                                Ext.getCmp('memAdultoEducacion').allowBlank = true;
                                Ext.getCmp('memAdultoEducacion').clearInvalid();
                                Ext.getCmp('memAdultoEducacion').setValue(null);
                            },
                            scope:this //bind the callbacks
                        });
                    }else{
                        Ext.getCmp('fsAlteracionesAdulto').setVisible(false);
                        Ext.getCmp('sysReqPrgAdulto').setValue(0);
                        Ext.getCmp('strInfPrgAdulto').setValue(null);
                        Ext.getCmp('bolALTADULFumador').allowBlank = true;
                        Ext.getCmp('bolALTADULFumador').clearInvalid();
                        Ext.getCmp('bolALTADULFumador').setValue(null);
                        Ext.getCmp('bolALTADULAlcohol').allowBlank = true;
                        Ext.getCmp('bolALTADULAlcohol').clearInvalid();
                        Ext.getCmp('bolALTADULAlcohol').setValue(null);
                        Ext.getCmp('bolALTADULSustPsicoa').allowBlank = true;
                        Ext.getCmp('bolALTADULSustPsicoa').clearInvalid();
                        Ext.getCmp('bolALTADULSustPsicoa').setValue(null);
                        Ext.getCmp('bolALTADULDietaSaludable').allowBlank = true;
                        Ext.getCmp('bolALTADULDietaSaludable').clearInvalid();
                        Ext.getCmp('bolALTADULDietaSaludable').setValue(null);
                        Ext.getCmp('bolALTADULActFisica').allowBlank = true;
                        Ext.getCmp('bolALTADULActFisica').clearInvalid();
                        Ext.getCmp('bolALTADULActFisica').setValue(null);
                        Ext.getCmp('bolALTADULManejoStress').allowBlank = true;
                        Ext.getCmp('bolALTADULManejoStress').clearInvalid();
                        Ext.getCmp('bolALTADULManejoStress').setValue(null);
                        Ext.getCmp('strALTADULUroanalisis').allowBlank = true;
                        Ext.getCmp('strALTADULUroanalisis').clearInvalid();
                        Ext.getCmp('strALTADULUroanalisis').setValue(null);
                        Ext.getCmp('strALTADULUroanalisisDescripcion').allowBlank = true;
                        Ext.getCmp('strALTADULUroanalisisDescripcion').clearInvalid();
                        Ext.getCmp('strALTADULUroanalisisDescripcion').setValue(null);
                        Ext.getCmp('fecALTADULUroanalisisFecha').allowBlank = true;
                        Ext.getCmp('fecALTADULUroanalisisFecha').clearInvalid();
                        Ext.getCmp('fecALTADULUroanalisisFecha').setValue(null);
                        Ext.getCmp('strALTADULCreatinina').allowBlank = true;
                        Ext.getCmp('strALTADULCreatinina').clearInvalid();
                        Ext.getCmp('strALTADULCreatinina').setValue(null);
                        Ext.getCmp('strALTADULCreatininaDescripcion').allowBlank = true;
                        Ext.getCmp('strALTADULCreatininaDescripcion').clearInvalid();
                        Ext.getCmp('strALTADULCreatininaDescripcion').setValue(null);
                        Ext.getCmp('fecALTADULCreatininaFecha').allowBlank = true;
                        Ext.getCmp('fecALTADULCreatininaFecha').clearInvalid();
                        Ext.getCmp('fecALTADULCreatininaFecha').setValue(null);
                        Ext.getCmp('strALTADULGlicemia').allowBlank = true;
                        Ext.getCmp('strALTADULGlicemia').clearInvalid();
                        Ext.getCmp('strALTADULGlicemia').setValue(null);
                        Ext.getCmp('strALTADULGlicemiaDescripcion').allowBlank = true;
                        Ext.getCmp('strALTADULGlicemiaDescripcion').clearInvalid();
                        Ext.getCmp('strALTADULGlicemiaDescripcion').setValue(null);
                        Ext.getCmp('fecALTADULGlicemiaFecha').allowBlank = true;
                        Ext.getCmp('fecALTADULGlicemiaFecha').clearInvalid();
                        Ext.getCmp('fecALTADULGlicemiaFecha').setValue(null);
                        Ext.getCmp('strALTADULColesterolTotal').allowBlank = true;
                        Ext.getCmp('strALTADULColesterolTotal').clearInvalid();
                        Ext.getCmp('strALTADULColesterolTotal').setValue(null);
                        Ext.getCmp('strALTADULColesterolTotalDescripcion').allowBlank = true;
                        Ext.getCmp('strALTADULColesterolTotalDescripcion').clearInvalid();
                        Ext.getCmp('strALTADULColesterolTotalDescripcion').setValue(null);
                        Ext.getCmp('fecALTADULColesterolTotalFecha').allowBlank = true;
                        Ext.getCmp('fecALTADULColesterolTotalFecha').clearInvalid();
                        Ext.getCmp('fecALTADULColesterolTotalFecha').setValue(null);
                        Ext.getCmp('strALTADULColesterolHDL').allowBlank = true;
                        Ext.getCmp('strALTADULColesterolHDL').clearInvalid();
                        Ext.getCmp('strALTADULColesterolHDL').setValue(null);
                        Ext.getCmp('strALTADULColesterolHDLDescripcion').allowBlank = true;
                        Ext.getCmp('strALTADULColesterolHDLDescripcion').clearInvalid();
                        Ext.getCmp('strALTADULColesterolHDLDescripcion').setValue(null);
                        Ext.getCmp('fecALTADULColesterolHDLFecha').allowBlank = true;
                        Ext.getCmp('fecALTADULColesterolHDLFecha').clearInvalid();
                        Ext.getCmp('fecALTADULColesterolHDLFecha').setValue(null);
                        Ext.getCmp('strALTADULTrigliceridos').allowBlank = true;
                        Ext.getCmp('strALTADULTrigliceridos').clearInvalid();
                        Ext.getCmp('strALTADULTrigliceridos').setValue(null);
                        Ext.getCmp('strALTADULTrigliceridosDescripcion').allowBlank = true;
                        Ext.getCmp('strALTADULTrigliceridosDescripcion').clearInvalid();
                        Ext.getCmp('strALTADULTrigliceridosDescripcion').setValue(null);
                        Ext.getCmp('fecALTADULTrigliceridosFecha').allowBlank = true;
                        Ext.getCmp('fecALTADULTrigliceridosFecha').clearInvalid();
                        Ext.getCmp('fecALTADULTrigliceridosFecha').setValue(null);
                        Ext.getCmp('memAdultoEducacion').allowBlank = true;
                        Ext.getCmp('memAdultoEducacion').clearInvalid();
                        Ext.getCmp('memAdultoEducacion').setValue(null);
                    }
                }
            }
        });
        winHCMedicinaBasica001Ui.superclass.initComponent.call(this);
    }
});

function fnGuardarRegistrosMedicinaGeneral(){
    var frm = Ext.getCmp('frmHCMedGen').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc201501.php',
            params:{
                task: 'guardar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pidPlantillaHC : Ext.getCmp('sysIdCodPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue(),
                pFormulacion: Ext.getCmp('sysFormulacion').getValue(),
                
                //4505 IDENTIFICACION RIESGO
                pOcupacion4505: Ext.getCmp('strOcupacionHC').getValue(),
                pEtnia4505: Ext.getCmp('intEtniaHC').getValue(),
                pEscolaridad4505: Ext.getCmp('intEscolaridadHC').getValue(),
                pGestacion4505: Ext.getCmp('intIdentificacionRiesgoGestacion').getValue(),
                pSifilisGestacional4505: Ext.getCmp('intIdentificacionRiesgoSifilisGestacional').getValue(),
                pHipertencionGestacional4505: Ext.getCmp('intIdentificacionRiesgoHipertencionGestacional').getValue(),
                pHipotiroidismoCongenito4505: Ext.getCmp('intIdentificacionRiesgoHipotiroidismoCongenito').getValue(),
                pTuberculosisMultidrogoresistente4505: Ext.getCmp('intIdentificacionRiesgoTuberculosisMultidrogoresistente').getValue(),
                pLepra4505: Ext.getCmp('intIdentificacionRiesgoLepra').getValue(),
                pVictimaMaltrato4505: Ext.getCmp('intIdentificacionRiesgoVictimaMaltrato').getValue(),
                pViolenciaSexual4505: Ext.getCmp('intIdentificacionRiesgoViolenciaSexual').getValue(),
                pFluorosisDental4505: Ext.getCmp('intIdentificacionRiesgoFluorosisDental').getValue(),
                pEnfermedadMental4505: Ext.getCmp('intIdentificacionRiesgoEnfermedadMental').getValue(),
                pTransmisionSexual4505: Ext.getCmp('intIdentificacionRiesgoInfeccionesTransmisionSexual').getValue(),
                pSintomaticoRespiratorio4505: Ext.getCmp('intIdentificacionRiesgoSintomaticoRespiratorio').getValue(),
                
                pAsesoriaPreTestVIH4505: Ext.getCmp('strAsesoriaPreTestVIH').getValue(),
                pAsesoriaPostTestVIH4505: Ext.getCmp('strAsesoriaPostTestVIH').getValue(),

                //SIGNOS VITALES
                pGuardarSignos: "SI",
                pTASIS: Ext.getCmp('intEXAFISTASentadoSistolica').getValue(),
                pTADIAS: Ext.getCmp('intEXAFISTASentadoDiastolica').getValue(),
                pTensionArterialSistolicaPie: Ext.getCmp('intEXAFISTAdePieSistolica').getValue(),
                pTensionArterialDiastolicaPie: Ext.getCmp('intEXAFISTAdePieDiastolica').getValue(),
                pTalla: Ext.getCmp('intEXAFISTalla').getValue(),
                pPeso: Ext.getCmp('intEXAFISPeso').getValue(),
                pIMC: Ext.getCmp('intEXAFISIMC').getValue(),
                pIMCClasifica: Ext.getCmp('strEXAFISIMCClasificacon').getValue(),
                pTE: Ext.getCmp('intEXAFISTemp').getValue(),
                pFC: Ext.getCmp('intEXAFISFC').getValue(),
                pFR: Ext.getCmp('intEXAFISFR').getValue(),
                pPerimetroAbdominal: Ext.getCmp('strEXAFISPA').getValue(),
                
                //ANTECEDENTES 201508
                pAcompanante: Ext.getCmp('strAcompanante').getValue(),
                pParentescoAcompanante: Ext.getCmp('strParentescoAcompanante').getValue(),
                pResponsable: Ext.getCmp('strResponsable').getValue(),
                pResponsableDireccion: Ext.getCmp('strDireccionResponsable').getValue(),
                pResponsableTelefono: Ext.getCmp('strTelefonoResponsable').getValue(),
                pPatologicos: Ext.getCmp('memANTPERSOPatologicos').getValue(),
                pFarmacologicos: Ext.getCmp('memANTPERSOFarmacologicos').getValue(),
                pQuirurgicos: Ext.getCmp('memANTPERSOQuirurgicos').getValue(),
                pTraumatologicos: Ext.getCmp('memANTPERSOTraumatologicos').getValue(),
                pToxicologicos: Ext.getCmp('memANTPERSOToxicologicos').getValue(),
                pAlergicos: Ext.getCmp('memANTPERSOAlergicos').getValue(),
                pBiopsicosociales: Ext.getCmp('memANTPERSOBiopsicosociales').getValue(),
                pVIH: Ext.getCmp('bolANTPERSOVIH').getValue(),
                pCancer: Ext.getCmp('bolANTPERSOCancer').getValue(),
                pMamografia: Ext.getCmp('strANTGINECOMamografia').getValue(),
                pFecMamografia: Ext.getCmp('fecANTGINECOMamografia').getValue(),
                pResMamografia: Ext.getCmp('strANTGINECOMamografiaRes').getValue(),
                pGest: Ext.getCmp('intANTGINECOG').getValue(),
                pPartos: Ext.getCmp('intANTGINECOP').getValue(),
                pPVaginales: Ext.getCmp('intANTGINECOPV').getValue(),
                pCesarea: Ext.getCmp('intANTGINECOPC').getValue(),
                pAbortos: Ext.getCmp('intANTGINECOA').getValue(),
                pVivos: Ext.getCmp('intANTGINECOVivos').getValue(),
                pMuertos: Ext.getCmp('intANTGINECOMuertos').getValue(),
                pMola: Ext.getCmp('bolANTGINECOMola').getValue(),
                pEmbEctopico: Ext.getCmp('bolANTGINECOEmbEctopico').getValue(),
                pPreclampsia: Ext.getCmp('bolANTPERSOPreclampsia').getValue(),
                pEclampsia: Ext.getCmp('bolANTPERSOEclampsia').getValue(),
                pFup: Ext.getCmp('fecANTGINECOFup').getValue(),
                pMenarquia: Ext.getCmp('strANTGINECOMenarquiaPreg').getValue(),
                pMenarquiaDes: Ext.getCmp('strANTGINECOMenarquia').getValue(),
                pFum: Ext.getCmp('fecANTGINECOFum').getValue(),
                pFucPregunta: Ext.getCmp('strANTGINECOFuc').getValue(),
                pfecfuc: Ext.getCmp('fecANTGINECOFuc').getValue(),
                pFucRes: Ext.getCmp('strANTGINECOFucRes').getValue(),
                pMetodoPlanifica: Ext.getCmp('strANTGINECOMetodoPlanifica').getValue(),
                pActividadSexual: Ext.getCmp('strANTGINECOActividadSexual').getValue(),
                pInicioActividad: Ext.getCmp('strANTGINECOInicioActividadSexual').getValue(),
                pCompanerosActividad: Ext.getCmp('strANTGINECONroCompanerosSexual').getValue(),
                pETS: Ext.getCmp('strANTGINECOETS').getValue(),
                pPatologiaEmbarazo: Ext.getCmp('strANTGINECOPatologiaEmbarazo').getValue(),
                pMenopausia: Ext.getCmp('strANTGINECOMenopausia').getValue(),
                pAntFamiliares: Ext.getCmp('memAntecedentesFamiliares').getValue(),
                pFamiliaresDiabetes: Ext.getCmp('strAntecedentesFamiliaresDiabetes').getValue(),
                pFamiliaresHTA: Ext.getCmp('strAntecedentesFamiliaresHTA').getValue(),
                pFamiliaresDislipidemia: Ext.getCmp('strAntecedentesFamiliaresDislipidemia').getValue(),
                pFamiliaresECCV: Ext.getCmp('strAntecedentesFamiliaresEnfermedadesCardioCerebroVasculares').getValue(),
                pFamiliaresCACervix: Ext.getCmp('strAntecedentesFamiliaresCACervix').getValue(),
                pFamiliaresCAProstata: Ext.getCmp('strAntecedentesFamiliaresCAProstata').getValue(),
                pFamiliaresCASeno: Ext.getCmp('strAntecedentesFamiliaresCASeno').getValue(),
                pFamiliaresCAEstomago: Ext.getCmp('strAntecedentesFamiliaresCAEstomago').getValue(),
                pFamiliaresCAColorrectal: Ext.getCmp('strAntecedentesFamiliaresCAColorrectal').getValue(),
                pGuardarAntecedentes: "SI",
                //FIN ANTECEDENTES 201508
                
                pSolicitarCitologia: Ext.getCmp('sysSolicitaCitologia').getValue(),
                pSolicitarMamografia: Ext.getCmp('sysSolicitaMamografia').getValue(),
                pSolicitarBaciloscopia: Ext.getCmp('sysSolicitaBaciloscopia').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1);
                        
                        Ext.getCmp('gridExamenesHC').store.load({
                            params: {
                                task: 'VerExaSolicitadosxHC',
                                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                                pCAS: Ext.getCmp('sysCASHC').getValue()
                            }
                        });
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function fnModificarRegistrosMedicinaGeneral(){
    var frm = Ext.getCmp('frmHCMedGen').getForm();
    if (frm.isValid()){
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc201501.php',
            params:{
                task: 'modificar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pidPlantillaHC : Ext.getCmp('sysIdCodPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue(),
                pFormulacion: Ext.getCmp('sysFormulacion').getValue(),
                
                //4505 IDENTIFICACION RIESGO
                pOcupacion4505: Ext.getCmp('strOcupacionHC').getValue(),
                pEtnia4505: Ext.getCmp('intEtniaHC').getValue(),
                pEscolaridad4505: Ext.getCmp('intEscolaridadHC').getValue(),
                pGestacion4505: Ext.getCmp('intIdentificacionRiesgoGestacion').getValue(),
                pSifilisGestacional4505: Ext.getCmp('intIdentificacionRiesgoSifilisGestacional').getValue(),
                pHipertencionGestacional4505: Ext.getCmp('intIdentificacionRiesgoHipertencionGestacional').getValue(),
                pHipotiroidismoCongenito4505: Ext.getCmp('intIdentificacionRiesgoHipotiroidismoCongenito').getValue(),
                pTuberculosisMultidrogoresistente4505: Ext.getCmp('intIdentificacionRiesgoTuberculosisMultidrogoresistente').getValue(),
                pLepra4505: Ext.getCmp('intIdentificacionRiesgoLepra').getValue(),
                pVictimaMaltrato4505: Ext.getCmp('intIdentificacionRiesgoVictimaMaltrato').getValue(),
                pViolenciaSexual4505: Ext.getCmp('intIdentificacionRiesgoViolenciaSexual').getValue(),
                pFluorosisDental4505: Ext.getCmp('intIdentificacionRiesgoFluorosisDental').getValue(),
                pEnfermedadMental4505: Ext.getCmp('intIdentificacionRiesgoEnfermedadMental').getValue(),
                pTransmisionSexual4505: Ext.getCmp('intIdentificacionRiesgoInfeccionesTransmisionSexual').getValue(),
                pSintomaticoRespiratorio4505: Ext.getCmp('intIdentificacionRiesgoSintomaticoRespiratorio').getValue(),
                
                //SIGNOS VITALES
                pGuardarSignos: "SI",
                pTASIS: Ext.getCmp('intEXAFISTASentadoSistolica').getValue(),
                pTADIAS: Ext.getCmp('intEXAFISTASentadoDiastolica').getValue(),
                pTensionArterialSistolicaPie: Ext.getCmp('intEXAFISTAdePieSistolica').getValue(),
                pTensionArterialDiastolicaPie: Ext.getCmp('intEXAFISTAdePieDiastolica').getValue(),
                pTalla: Ext.getCmp('intEXAFISTalla').getValue(),
                pPeso: Ext.getCmp('intEXAFISPeso').getValue(),
                pIMC: Ext.getCmp('intEXAFISIMC').getValue(),
                pIMCClasifica: Ext.getCmp('strEXAFISIMCClasificacon').getValue(),
                pTE: Ext.getCmp('intEXAFISTemp').getValue(),
                pFC: Ext.getCmp('intEXAFISFC').getValue(),
                pFR: Ext.getCmp('intEXAFISFR').getValue(),
                pPerimetroAbdominal: Ext.getCmp('strEXAFISPA').getValue(),
                
                //ANTECEDENTES 201508
                pAcompanante: Ext.getCmp('strAcompanante').getValue(),
                pParentescoAcompanante: Ext.getCmp('strParentescoAcompanante').getValue(),
                pResponsable: Ext.getCmp('strResponsable').getValue(),
                pResponsableDireccion: Ext.getCmp('strDireccionResponsable').getValue(),
                pResponsableTelefono: Ext.getCmp('strTelefonoResponsable').getValue(),
                pPatologicos: Ext.getCmp('memANTPERSOPatologicos').getValue(),
                pFarmacologicos: Ext.getCmp('memANTPERSOFarmacologicos').getValue(),
                pQuirurgicos: Ext.getCmp('memANTPERSOQuirurgicos').getValue(),
                pTraumatologicos: Ext.getCmp('memANTPERSOTraumatologicos').getValue(),
                pToxicologicos: Ext.getCmp('memANTPERSOToxicologicos').getValue(),
                pAlergicos: Ext.getCmp('memANTPERSOAlergicos').getValue(),
                pBiopsicosociales: Ext.getCmp('memANTPERSOBiopsicosociales').getValue(),
                pVIH: Ext.getCmp('bolANTPERSOVIH').getValue(),
                pCancer: Ext.getCmp('bolANTPERSOCancer').getValue(),
                pMamografia: Ext.getCmp('strANTGINECOMamografia').getValue(),
                pFecMamografia: Ext.getCmp('fecANTGINECOMamografia').getValue(),
                pResMamografia: Ext.getCmp('strANTGINECOMamografiaRes').getValue(),
                pGest: Ext.getCmp('intANTGINECOG').getValue(),
                pPartos: Ext.getCmp('intANTGINECOP').getValue(),
                pPVaginales: Ext.getCmp('intANTGINECOPV').getValue(),
                pCesarea: Ext.getCmp('intANTGINECOPC').getValue(),
                pAbortos: Ext.getCmp('intANTGINECOA').getValue(),
                pVivos: Ext.getCmp('intANTGINECOVivos').getValue(),
                pMuertos: Ext.getCmp('intANTGINECOMuertos').getValue(),
                pMola: Ext.getCmp('bolANTGINECOMola').getValue(),
                pEmbEctopico: Ext.getCmp('bolANTGINECOEmbEctopico').getValue(),
                pPreclampsia: Ext.getCmp('bolANTPERSOPreclampsia').getValue(),
                pEclampsia: Ext.getCmp('bolANTPERSOEclampsia').getValue(),
                pFup: Ext.getCmp('fecANTGINECOFup').getValue(),
                pMenarquia: Ext.getCmp('strANTGINECOMenarquiaPreg').getValue(),
                pMenarquiaDes: Ext.getCmp('strANTGINECOMenarquia').getValue(),
                pFum: Ext.getCmp('fecANTGINECOFum').getValue(),
                pFucPregunta: Ext.getCmp('strANTGINECOFuc').getValue(),
                pfecfuc: Ext.getCmp('fecANTGINECOFuc').getValue(),
                pFucRes: Ext.getCmp('strANTGINECOFucRes').getValue(),
                pMetodoPlanifica: Ext.getCmp('strANTGINECOMetodoPlanifica').getValue(),
                pActividadSexual: Ext.getCmp('strANTGINECOActividadSexual').getValue(),
                pInicioActividad: Ext.getCmp('strANTGINECOInicioActividadSexual').getValue(),
                pCompanerosActividad: Ext.getCmp('strANTGINECONroCompanerosSexual').getValue(),
                pETS: Ext.getCmp('strANTGINECOETS').getValue(),
                pPatologiaEmbarazo: Ext.getCmp('strANTGINECOPatologiaEmbarazo').getValue(),
                pMenopausia: Ext.getCmp('strANTGINECOMenopausia').getValue(),
                pAntFamiliares: Ext.getCmp('memAntecedentesFamiliares').getValue(),
                pFamiliaresDiabetes: Ext.getCmp('strAntecedentesFamiliaresDiabetes').getValue(),
                pFamiliaresHTA: Ext.getCmp('strAntecedentesFamiliaresHTA').getValue(),
                pFamiliaresDislipidemia: Ext.getCmp('strAntecedentesFamiliaresDislipidemia').getValue(),
                pFamiliaresECCV: Ext.getCmp('strAntecedentesFamiliaresEnfermedadesCardioCerebroVasculares').getValue(),
                pFamiliaresCACervix: Ext.getCmp('strAntecedentesFamiliaresCACervix').getValue(),
                pFamiliaresCAProstata: Ext.getCmp('strAntecedentesFamiliaresCAProstata').getValue(),
                pFamiliaresCASeno: Ext.getCmp('strAntecedentesFamiliaresCASeno').getValue(),
                pFamiliaresCAEstomago: Ext.getCmp('strAntecedentesFamiliaresCAEstomago').getValue(),
                pFamiliaresCAColorrectal: Ext.getCmp('strAntecedentesFamiliaresCAColorrectal').getValue(),
                pGuardarAntecedentes: "SI",
                //FIN ANTECEDENTES 201508
                
                pSolicitarCitologia: Ext.getCmp('sysSolicitaCitologia').getValue(),
                pSolicitarMamografia: Ext.getCmp('sysSolicitaMamografia').getValue(),
                pSolicitarBaciloscopia: Ext.getCmp('sysSolicitaBaciloscopia').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1);
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function calculoEdadPacienteMeses(){
    var valFecha1 = 0;
    var pFec2Anio = 0;
    var pFec2Mes = 0;
    var pFec2Dia = 0;
    var valFecha2 = 0;
    MesesCumplidos = 0;
    AniosCumplidos = 0;


    valFecha1 = Ext.getCmp('sysFechaHC').getValue();
    pFec2Anio = Ext.getCmp('sysFechaNac').getValue().substr(6,4);
    pFec2Mes = Ext.getCmp('sysFechaNac').getValue().substr(3,2);
    pFec2Dia = Ext.getCmp('sysFechaNac').getValue().substr(0,2);
    
    valFecha2 =  pFec2Anio + "/" + pFec2Mes + "/" + pFec2Dia;

    MesesCumplidos = MostrarEdadMeses(valFecha1, valFecha2);
    
    AniosCumplidos = MostrarEdadAnios(valFecha1, valFecha2);
}