/*
* @category    Fieldset Antecedentes Personales
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


fsAntecedentesPersonalesUi = Ext.extend(Ext.form.FieldSet, {
    anchor: '100%',
    autoHeight: true,
    layout: 'form',
    title: 'ANTECEDENTES PERSONALES',
    collapseFirst: false,
    collapsible: true,
    animCollapse: true,
    titleCollapse: true,
    padding: 0,
    id: 'fsAntecedentesPersonales',
    initComponent: function() {
        this.items = [
            {
                xtype: 'textarea',
                anchor: '100%',
                fieldLabel: 'Patologicos',
                name: 'Patologicos',
                allowBlank: false,
                id: 'memANTPERSOPatologicos',
                listeners: {
                    render: function( p ) {
                        p.getEl().on('dblclick', function (){
                            Ext.getCmp('memANTPERSOPatologicos').setValue("No Refiere");
                        });
                    }
                }
            },
            {
                xtype: 'textarea',
                anchor: '100%',
                fieldLabel: 'Farmacologicos',
                name: 'Farmacologicos',
                allowBlank: false,
                id: 'memANTPERSOFarmacologicos',
                listeners: {
                    render: function( p ) {
                        p.getEl().on('dblclick', function (){
                            Ext.getCmp('memANTPERSOFarmacologicos').setValue("No Refiere");
                        });
                    }
                }
            },
            {
                xtype: 'textarea',
                anchor: '100%',
                fieldLabel: 'Quirurgicos',
                name: 'Quirurgicos',
                allowBlank: false,
                id: 'memANTPERSOQuirurgicos',
                listeners: {
                    render: function( p ) {
                        p.getEl().on('dblclick', function (){
                            Ext.getCmp('memANTPERSOQuirurgicos').setValue("No Refiere");
                        });
                    }
                }
            },
            {
                xtype: 'textarea',
                anchor: '100%',
                fieldLabel: 'Traumatologicos',
                name: 'Traumatologicos',
                allowBlank: false,
                id: 'memANTPERSOTraumatologicos',
                listeners: {
                    render: function( p ) {
                        p.getEl().on('dblclick', function (){
                            Ext.getCmp('memANTPERSOTraumatologicos').setValue("No Refiere");
                        });
                    }
                }
            },
            {
                xtype: 'textarea',
                anchor: '100%',
                fieldLabel: 'Toxicologicos',
                name: 'Toxicologicos',
                allowBlank: false,
                id: 'memANTPERSOToxicologicos',
                listeners: {
                    render: function( p ) {
                        p.getEl().on('dblclick', function (){
                            Ext.getCmp('memANTPERSOToxicologicos').setValue("No Refiere");
                        });
                    }
                }
            },
            {
                xtype: 'textarea',
                anchor: '100%',
                fieldLabel: 'Alergicos',
                name: 'Alergicos',
                allowBlank: false,
                id: 'memANTPERSOAlergicos',
                listeners: {
                    render: function( p ) {
                        p.getEl().on('dblclick', function (){
                            Ext.getCmp('memANTPERSOAlergicos').setValue("No Refiere");
                        });
                    }
                }
            },
            {
                xtype: 'textarea',
                anchor: '100%',
                fieldLabel: 'Biopsicosociales',
                name: 'Biopsicosociales',
                allowBlank: false,
                id: 'memANTPERSOBiopsicosociales',
                listeners: {
                    render: function( p ) {
                        p.getEl().on('dblclick', function (){
                            Ext.getCmp('memANTPERSOBiopsicosociales').setValue("No Refiere");
                        });
                    }
                }
            },
            {
                xtype: 'checkbox',
                fieldLabel: 'VIH',
                name: 'VIH',
                anchor: '100%',
                value: 'false',
                id: 'bolANTPERSOVIH'
            },
            {
                xtype: 'checkbox',
                fieldLabel: 'Cancer',
                name: 'Cancer',
                anchor: '100%',
                value: 'false',
                id: 'bolANTPERSOCancer'
            },
            {
                html: '<br>'
            },
            {
                xtype: 'fieldset',
                layout: 'form',
                collapseFirst: false,
                collapsible: true,
                animCollapse: true,
                anchor: '100%',
                autoHeight: true,
                labelSeparator: '',
                id: 'fsMamografia',
                items: [
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'combo',
                                fieldLabel: 'Se a realizado la Mamografia en los dos ultimos años',
                                name: 'Se a realizado la Mamografia en los dos ultimos años',
                                width: 60,
                                allowBlank: false,
                                store: 'StoreSiNo',
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strANTGINECOMamografia',
                                listeners:{
                                    change : function( t, newValue, oldValue){
                                        if(newValue === "NO"){
                                            Ext.getCmp('fecANTGINECOMamografia').disable();
                                            Ext.getCmp('fecANTGINECOMamografia').clearInvalid();
                                            Ext.getCmp('fecANTGINECOMamografia').setValue(null);
                                            Ext.getCmp('fecANTGINECOMamografia').allowBlank = true;
                                            Ext.getCmp('strANTGINECOMamografiaRes').disable();
                                            Ext.getCmp('strANTGINECOMamografiaRes').clearInvalid();
                                            Ext.getCmp('strANTGINECOMamografiaRes').setValue(null);
                                            Ext.getCmp('strANTGINECOMamografiaRes').allowBlank = true;

                                            //Adicionar Solicitud de la mamografia
                                            if(parseInt(Ext.getCmp('sysSolicitaMamografia').getValue()) === 0){
                                                Ext.getCmp('sysSolicitaMamografia').setValue(1);
                                            }
                                        }else{  
                                            Ext.getCmp('fecANTGINECOMamografia').enable();
                                            Ext.getCmp('strANTGINECOMamografiaRes').enable();
                                            Ext.getCmp('fecANTGINECOMamografia').allowBlank = false;
                                            Ext.getCmp('strANTGINECOMamografiaRes').allowBlank = false;

                                            // Borrar Solicitud de la mamografia
                                            Ext.Ajax.request({
                                                url: '../../controlador/asistencial/evolucionhc2015.php',
                                                params:{
                                                    task: 'BORRAR_SERVICIOS_ANTECEDENTES',
                                                    pCodProced: "876802",
                                                    pCAS: Ext.getCmp('sysCASHC').getValue()
                                                },
                                                success: function(response,options)
                                                {
                                                    var el = Ext.get('response'); // get the LOG
                                                    var Respuesta = response.responseText;
                                                    var Contenido = Respuesta.split('^');
                                                    if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                        //
                                                    } else {
                                                        Ext.getCmp('gridExamenesHC').store.reload();
                                                        Ext.getCmp('sysSolicitaMamografia').setValue(0);
                                                    }
                                                },
                                                failure: function(response,options){
                                                    //
                                                },
                                                scope:this
                                            });
                                        }
                                    }
                                }
                            },
                            {
                                html: 'Fecha Ultima Mamografia:'
                            },
                            {
                                xtype: 'datefield',
                                width: 120,
                                name: 'Ultima Mamografia',
                                allowBlank: true,
                                disabledDates: '',
                                emptyText: '(dia/mes/año) ',
                                style: 'text-align:center;',
                                id: 'fecANTGINECOMamografia'
                            },
                            {
                                html: 'Resultado:'
                            },
                            {
                                xtype: 'combo',
                                name: 'Resultado Mamografia',
                                width: 300,
                                allowBlank: true,
                                store: stResultadoMamografia,
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strANTGINECOMamografiaRes'
                            }
                        ]
                    }
                ]
            },
            {
                xtype: 'fieldset',
                title: 'ANTECEDENTES GINECO-OBSTETRICOS',
                layout: 'form',
                collapseFirst: false,
                collapsible: true,
                animCollapse: true,
                titleCollapse: true,
                anchor: '100%',
                labelSeparator: '',
                autoHeight: true,
                id: 'fsANTGINECO',
                items: [
                    {
                        html: '<br>'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                html: 'G'
                            },
                            {
                                xtype: 'numberfield',
                                name: 'G',
                                fieldLabel: 'Embarazos',
                                emptyText: 'Gestaciones',
                                width: 68,
                                minValue: 0,
                                maxValue: 20,
                                decimalPrecision: 0,
                                allowBlank: false,
                                id: 'intANTGINECOG',
                                listeners:{
                                    change : function( t, newValue, oldValue){
                                        if(newValue <= 1 && Ext.getCmp('intANTGINECOP').getValue() === 0 && Ext.getCmp('intANTGINECOA').getValue() === 0){
                                            Ext.getCmp('fecANTGINECOFup').setValue(null);
                                            Ext.getCmp('fecANTGINECOFup').disable();
                                            Ext.getCmp('fecANTGINECOFup').clearInvalid();
                                        }else{
                                            Ext.getCmp('fecANTGINECOFup').enable();
                                        }
                                        if(newValue === 0){
                                            Ext.getCmp('intANTGINECOP').disable();
                                            Ext.getCmp('intANTGINECOPV').disable();
                                            Ext.getCmp('intANTGINECOPC').disable();
                                            Ext.getCmp('intANTGINECOA').disable();
                                            Ext.getCmp('intANTGINECOVivos').disable();
                                            Ext.getCmp('intANTGINECOMuertos').disable();
                                            Ext.getCmp('intANTGINECOP').allowBlank = true;
                                            Ext.getCmp('intANTGINECOPV').allowBlank = true;
                                            Ext.getCmp('intANTGINECOPC').allowBlank = true;
                                            Ext.getCmp('intANTGINECOA').allowBlank = true;
                                            Ext.getCmp('intANTGINECOVivos').allowBlank = true;
                                            Ext.getCmp('intANTGINECOMuertos').allowBlank = true;
                                            Ext.getCmp('intANTGINECOP').clearInvalid();
                                            Ext.getCmp('intANTGINECOPV').clearInvalid();
                                            Ext.getCmp('intANTGINECOPC').clearInvalid();
                                            Ext.getCmp('intANTGINECOA').clearInvalid();
                                            Ext.getCmp('intANTGINECOVivos').clearInvalid();
                                            Ext.getCmp('intANTGINECOMuertos').clearInvalid();
                                        }else{
                                            Ext.getCmp('intANTGINECOP').enable();
                                            Ext.getCmp('intANTGINECOPV').enable();
                                            Ext.getCmp('intANTGINECOPC').enable();
                                            Ext.getCmp('intANTGINECOA').enable();
                                            Ext.getCmp('intANTGINECOVivos').enable();
                                            Ext.getCmp('intANTGINECOMuertos').enable();
                                            Ext.getCmp('intANTGINECOP').allowBlank = false;
                                            Ext.getCmp('intANTGINECOPV').allowBlank = false;
                                            Ext.getCmp('intANTGINECOPC').allowBlank = false;
                                            Ext.getCmp('intANTGINECOA').allowBlank = false;
                                            Ext.getCmp('intANTGINECOVivos').allowBlank = false;
                                            Ext.getCmp('intANTGINECOMuertos').allowBlank = false;
                                        }
                                    }
                                }
                            },
                            {
                                html: 'P'
                            },
                            {
                                xtype: 'numberfield',
                                name: 'P',
                                emptyText: 'Partos',
                                width: 68,
                                minValue: 0,
                                maxValue: 20,
                                decimalPrecision: 0,
                                allowBlank: false,
                                id: 'intANTGINECOP',
                                listeners:{
                                    change : function( t, newValue, oldValue){
                                        if(newValue === 0 && Ext.getCmp('intANTGINECOG').getValue() <= 1 && Ext.getCmp('intANTGINECOA').getValue() === 0){
                                            Ext.getCmp('fecANTGINECOFup').setValue(null);
                                            Ext.getCmp('fecANTGINECOFup').disable();
                                            Ext.getCmp('fecANTGINECOFup').clearInvalid();
                                        }else{
                                            Ext.getCmp('fecANTGINECOFup').enable();
                                        }
                                    }
                                }
                            },
                            {
                                html: 'P.V'
                            },
                            {
                                xtype: 'numberfield',
                                name: 'PV',
                                emptyText: 'Vaginales',
                                width: 68,
                                minValue: 0,
                                maxValue: 20,
                                decimalPrecision: 0,
                                allowBlank: false,
                                id: 'intANTGINECOPV'
                            },
                            {
                                html: 'P.C'
                            },
                            {
                                xtype: 'numberfield',
                                name: 'PC',
                                emptyText: 'Cesarea',
                                width: 68,
                                minValue: 0,
                                maxValue: 20,
                                decimalPrecision: 0,
                                allowBlank: false,
                                id: 'intANTGINECOPC'
                            },
                            {
                                html: 'A'
                            },
                            {
                                xtype: 'numberfield',
                                name: 'A',
                                emptyText: 'Abortos',
                                width: 68,
                                minValue: 0,
                                maxValue: 20,
                                decimalPrecision: 0,
                                allowBlank: false,
                                id: 'intANTGINECOA',
                                listeners:{
                                    change : function( t, newValue, oldValue){
                                        if(newValue === 0 && Ext.getCmp('intANTGINECOG').getValue() <= 1 && Ext.getCmp('intANTGINECOP').getValue() === 0){
                                            Ext.getCmp('fecANTGINECOFup').setValue(null);
                                            Ext.getCmp('fecANTGINECOFup').disable();
                                            Ext.getCmp('fecANTGINECOFup').clearInvalid();
                                        }else{
                                            Ext.getCmp('fecANTGINECOFup').enable();
                                        }
                                    }
                                }
                            },
                            {
                                html: 'Vivos'
                            },
                            {
                                xtype: 'numberfield',
                                name: 'V',
                                width: 68,
                                minValue: 0,
                                maxValue: 20,
                                decimalPrecision: 0,
                                allowBlank: false,
                                id: 'intANTGINECOVivos'
                            },
                            {
                                html: 'Muertos'
                            },
                            {
                                xtype: 'numberfield',
                                name: 'M',
                                width: 68,
                                minValue: 0,
                                maxValue: 20,
                                decimalPrecision: 0,
                                allowBlank: false,
                                id: 'intANTGINECOMuertos'
                            }
                        ]
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                html: 'Mola'
                            },
                            {
                                xtype: 'checkbox',
                                name: 'Mola',
                                anchor: '100%',
                                value: 'false',
                                id: 'bolANTGINECOMola'
                            },
                            {
                                html: 'Embarazo Ectopico'
                            },
                            {
                                xtype: 'checkbox',
                                name: 'Embarazo Ectopico',
                                anchor: '100%',
                                value: 'false',
                                id: 'bolANTGINECOEmbEctopico'
                            },
                            {
                                html: 'Preclampsia'
                            },
                            {
                                xtype: 'checkbox',
                                name: 'Preclampsia',
                                anchor: '100%',
                                value: 'false',
                                id: 'bolANTPERSOPreclampsia'
                            },
                            {
                                html: 'Eclampsia'
                            },
                            {
                                xtype: 'checkbox',
                                name: 'Eclampsia',
                                anchor: '100%',
                                value: 'false',
                                id: 'bolANTPERSOEclampsia'
                            }
                        ]
                    },
                    {
                        html: '<br>'
                    },
                    {
                        xtype: 'datefield',
                        width: 120,
                        name: 'FUP',
                        fieldLabel: 'FUP',
                        allowBlank: true,
                        disabledDates: '',
                        emptyText: '(dia/mes/año) ',
                        style: 'text-align:center;',
                        id: 'fecANTGINECOFup'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'combo',
                                fieldLabel: 'Menarquia',
                                name: 'Menarquia',
                                width: 60,
                                allowBlank: true,
                                store: 'StoreSiNo',
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strANTGINECOMenarquiaPreg',
                                listeners:{
                                    change : function( t, newValue, oldValue){
                                        if(newValue === "NO"){
                                            Ext.getCmp('fecANTGINECOFum').disable();
                                            Ext.getCmp('fecANTGINECOFum').clearInvalid();
                                            Ext.getCmp('fecANTGINECOFum').setValue(null);
                                            Ext.getCmp('strANTGINECOMenarquia').disable();
                                            Ext.getCmp('strANTGINECOMenarquia').clearInvalid();
                                            Ext.getCmp('strANTGINECOMenarquia').setValue(null);
                                        }else{  
                                            Ext.getCmp('fecANTGINECOFum').enable();
                                            Ext.getCmp('strANTGINECOMenarquia').enable();
                                        }
                                    }
                                }
                            },
                            {
                                html: '-'
                            },
                            {
                                xtype: 'textfield',
                                name: 'Menarquia Descripcion',
                                width: 370,
                                allowBlank: true,
                                id: 'strANTGINECOMenarquia'
                            },
                            {
                                html: 'FUM'
                            },
                            {
                                xtype: 'datefield',
                                width: 120,
                                name: 'FUM',
                                allowBlank: true,
                                disabledDates: '',
                                emptyText: '(dia/mes/año) ',
                                style: 'text-align:center;',
                                id: 'fecANTGINECOFum'
                            }
                        ]
                    },
                    {
                        html: '<br><hr><br>'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'combo',
                                fieldLabel: 'Se a realizado la Citologia en el ultimo año',
                                name: 'Se a realizado la Citologia en el ultimo año',
                                width: 60,
                                allowBlank: false,
                                store: 'StoreSiNo',
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strANTGINECOFuc',
                                listeners:{
                                    change : function( t, newValue, oldValue){
                                        if(newValue === "NO"){
                                            Ext.getCmp('fecANTGINECOFuc').disable();
                                            Ext.getCmp('fecANTGINECOFuc').clearInvalid();
                                            Ext.getCmp('fecANTGINECOFuc').setValue(null);
                                            Ext.getCmp('fecANTGINECOFuc').allowBlank = true;
                                            Ext.getCmp('strANTGINECOFucRes').disable();
                                            Ext.getCmp('strANTGINECOFucRes').clearInvalid();
                                            Ext.getCmp('strANTGINECOFucRes').setValue(null);
                                            Ext.getCmp('strANTGINECOFucRes').allowBlank = true;
                                            
                                            if(parseInt(Ext.getCmp('sysSolicitaCitologia').getValue()) === 0){
                                                Ext.getCmp('sysSolicitaCitologia').setValue(1);
                                            }
                                        }else{  
                                            Ext.getCmp('fecANTGINECOFuc').enable();
                                            Ext.getCmp('strANTGINECOFucRes').enable();
                                            Ext.getCmp('fecANTGINECOFuc').allowBlank = false;
                                            Ext.getCmp('strANTGINECOFucRes').allowBlank = false;
                                            // Borrar Solicitud de la Citologia
                                            Ext.Ajax.request({
                                                url: '../../controlador/asistencial/evolucionhc2015.php',
                                                params:{
                                                    task: 'BORRAR_SERVICIOS_ANTECEDENTES',
                                                    pCodProced: "892901",
                                                    pCAS: Ext.getCmp('sysCASHC').getValue()
                                                },
                                                success: function(response,options)
                                                {
                                                    var el = Ext.get('response'); // get the LOG
                                                    var Respuesta = response.responseText;
                                                    var Contenido = Respuesta.split('^');
                                                    if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                        //
                                                    } else {
                                                        Ext.getCmp('gridExamenesHC').store.reload();
                                                        Ext.getCmp('sysSolicitaCitologia').setValue(0);
                                                    }
                                                },
                                                failure: function(response,options){
                                                    //
                                                },
                                                scope:this
                                            });
                                        }
                                    }
                                }
                            },
                            {
                                html: 'Fecha Ultima Citologia:'
                            },
                            {
                                xtype: 'datefield',
                                width: 120,
                                name: 'Ultima Citologia',
                                allowBlank: true,
                                disabledDates: '',
                                emptyText: '(dia/mes/año) ',
                                style: 'text-align:center;',
                                id: 'fecANTGINECOFuc'
                            },
                            {
                                html: 'Resultado:'
                            },
                            {
                                xtype: 'combo',
                                name: 'Resultado',
                                width: 150,
                                allowBlank: true,
                                store: stResultadoCitologia,
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strANTGINECOFucRes'
                            }
                        ]
                    },
                    {
                        html: '<br><hr><br>'
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: 'Metodo Planificacion',
                        name: 'Metodo Planificacion',
                        anchor: '100%',
                        allowBlank: true,
                        store: stSuministroMetodoPlanificacion,
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        mode: 'local',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 10,
                        triggerAction: 'all',
                        value: "REGISTRO NO EVALUADO",
                        id: 'strANTGINECOMetodoPlanifica'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'combo',
                                fieldLabel: 'Actividad Sexual',
                                name: 'Actividad Sexual',
                                width: 60,
                                allowBlank: true,
                                store: 'StoreSiNo',
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strANTGINECOActividadSexual'
                            },
                            {
                                html: 'Edad - Inicio: '
                            },
                            {
                                xtype: 'textfield',
                                width: 40,
                                name: 'Edad Inicio Actividad Sexual',
                                allowBlank: true,
                                id: 'strANTGINECOInicioActividadSexual'
                            },
                            {
                                html: 'Compañeros: '
                            },
                            {
                                xtype: 'textfield',
                                width: 40,
                                name: 'Numero Compañeros Sexuales',
                                allowBlank: true,
                                id: 'strANTGINECONroCompanerosSexual'
                            },
                            {
                                html: 'ETS: '
                            },
                            {
                                xtype: 'textfield',
                                width: 400,
                                name: 'ETS',
                                allowBlank: true,
                                id: 'strANTGINECOETS'
                            }
                        ]
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        fieldLabel: 'Patologias Relacionadas Emb.',
                        name: 'Patologias Relacionadas Emb.',
                        allowBlank: true,
                        id: 'strANTGINECOPatologiaEmbarazo',
                        listeners: {
                            render: function( p ) {
                                p.getEl().on('dblclick', function (){
                                    Ext.getCmp('strANTGINECOPatologiaEmbarazo').setValue("Negativo");
                                });
                            }
                        }
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        fieldLabel: 'Menopausia',
                        name: 'Menopausia',
                        allowBlank: true,
                        id: 'strANTGINECOMenopausia',
                        listeners: {
                            render: function( p ) {
                                p.getEl().on('dblclick', function (){
                                    Ext.getCmp('strANTGINECOMenopausia').setValue("Negativo");
                                });
                            }
                        }
                    }
                ]
            },
            {
                xtype: 'fieldset',
                title: 'IDENTIFICACION DEL RIESGO',
                layout: 'form',
                collapseFirst: false,
                collapsible: true,
                animCollapse: true,
                titleCollapse: true,
                anchor: '100%',
                labelSeparator: '',
                autoHeight: true,
                //hidden: true,
                id: 'fsIdentificacionRiesgo',
                items: [
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'textfield',
                                width: 86,
                                allowBlank: false,
                                fieldLabel: 'Ocupacion',
                                name: 'Ocupacion',
                                id: 'strOcupacionHC',
                                listeners:{
                                    specialkey: function(f,e){
                                        if (e.getKey() === e.ENTER || e.getKey() === e.TAB)
                                        {
                                            if (f.getValue() !== "" && f.getValue() !== null){
                                                Ext.Ajax.request({
                                                    url: '../../controlador/ciuo/controlador_ciuo.php',
                                                    params:{
                                                        task: 'BUSCAR',
                                                        pCodigo: f.getValue().toUpperCase()
                                                    },
                                                    success: function(response,options)
                                                    {
                                                        var el = Ext.get('response'); // get the LOG
                                                        var Respuesta = response.responseText;
                                                        var Contenido = Respuesta.split('^');
                                                        if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                            Ext.getCmp('strOcupacionHC').setValue(null);
                                                            Ext.getCmp('sysOcupacionHCNom').setValue(null);
                                                        } else {
                                                            Ext.getCmp('strOcupacionHC').setValue(Contenido[0].toUpperCase());
                                                            Ext.getCmp('sysOcupacionHCNom').setValue(Contenido[1].toUpperCase());
                                                        }
                                                    },
                                                    failure: function(response,options){
                                                        var el = Ext.get('response');
                                                        Ext.getCmp('strOcupacionHC').setValue(null);
                                                        Ext.getCmp('sysOcupacionHCNom').setValue(null);
                                                    },
                                                    scope:this //bind the callbacks
                                                });
                                            }else{
                                                Ext.getCmp('strOcupacionHC').setValue(null);
                                                Ext.getCmp('sysOcupacionHCNom').setValue(null);
                                            }
                                        }
                                    },
                                    blur: function(t){
                                        if(Ext.getCmp('sysOcupacionHCNom').getValue() === null || Ext.getCmp('sysOcupacionHCNom').getValue() === "")
                                        {
                                            if (Ext.getCmp('strOcupacionHC').getValue() !== "" && Ext.getCmp('strOcupacionHC').getValue() !== null){
                                                Ext.Ajax.request({
                                                    url: '../../controlador/ciuo/controlador_ciuo.php',
                                                    params:{
                                                        task: 'BUSCAR',
                                                        pCodigo: Ext.getCmp('strOcupacionHC').getValue().toUpperCase()
                                                    },
                                                    success: function(response,options)
                                                    {
                                                        var el = Ext.get('response'); // get the LOG
                                                        var Respuesta = response.responseText;
                                                        var Contenido = Respuesta.split('^');
                                                        if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                            Ext.getCmp('strOcupacionHC').setValue(null);
                                                            Ext.getCmp('sysOcupacionHCNom').setValue(null);
                                                        } else {
                                                            Ext.getCmp('strOcupacionHC').setValue(Contenido[0].toUpperCase());
                                                            Ext.getCmp('sysOcupacionHCNom').setValue(Contenido[1].toUpperCase());
                                                        }
                                                    },
                                                    failure: function(response,options){
                                                        var el = Ext.get('response');
                                                        Ext.getCmp('strOcupacionHC').setValue(null);
                                                        Ext.getCmp('sysOcupacionHCNom').setValue(null);
                                                    },
                                                    scope:this //bind the callbacks
                                                });
                                            }else{
                                                Ext.getCmp('strOcupacionHC').setValue(null);
                                                Ext.getCmp('sysOcupacionHCNom').setValue(null);
                                            }
                                        }
                                    }
                                }
                            },
                            {
                                xtype: 'textarea',
                                readOnly: true,
                                width: 615,
                                height: 22,
                                id: 'sysOcupacionHCNom'
                            },
                            {
                                xtype: 'button',
                                iconCls: 'btnBuscar',
                                tooltip: 'Buscar Ocupacion',
                                id: 'btnSearchOcupacionHC',
                                listeners:{
                                    click : function(){
                                        buscarciuo('strOcupacionHC','sysOcupacionHCNom');
                                    }
                                }
                            }
                        ]
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'combo',
                                fieldLabel: 'Etnia',
                                name: 'Etnia',
                                width: 330,
                                allowBlank: false,
                                store: stEtnia4505,
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'intEtniaHC'
                            },
                            {
                                html: 'Escolaridad:'
                            },
                            {
                                xtype: 'combo',
                                name: 'Escolaridad',
                                width: 330,
                                allowBlank: false,
                                store: stEscolaridad4505,
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'intEscolaridadHC'
                            }
                        ]
                    },
                    {
                        html: '<br>'
                    },
                    {
                        xtype: 'panel',
                        layout: 'table',
                        anchor: '100%',
                        padding: 0,
                        layoutConfig: {
                            columns: 2
                        },
                        autoHeight: true,
                        items: [
                            {
                                xtype: 'panel',
                                layout: 'form',
                                width: 400,
                                height: 310,
                                labelSeparator: '',
                                labelStyle: 'color:blue;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        name: 'Paciente en Gestacion?',
                                        fieldLabel: 'Paciente en Gestacion?',
                                        width: 250,
                                        allowBlank: false,
                                        store: stGestacion,
                                        valueField: 'Codigo',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        //value: 21,
                                        id: 'intIdentificacionRiesgoGestacion',
                                        listeners:{
                                            change : function( t, newValue, oldValue){
                                                if(newValue == 1){
                                                    Ext.getCmp('intIdentificacionRiesgoSifilisGestacional').setValue(3);
                                                    Ext.getCmp('intIdentificacionRiesgoSifilisGestacional').enable();
                                                    Ext.getCmp('intIdentificacionRiesgoHipertencionGestacional').setValue(2);
                                                    Ext.getCmp('intIdentificacionRiesgoHipertencionGestacional').enable();
                                                }else{
                                                    Ext.getCmp('intIdentificacionRiesgoSifilisGestacional').setValue(0);
                                                    Ext.getCmp('intIdentificacionRiesgoHipertencionGestacional').setValue(0);
                                                    Ext.getCmp('intIdentificacionRiesgoHipertencionGestacional').disable();
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'combo',
                                        name: 'Paciente con Sifilis Gestacional o Congenita?',
                                        fieldLabel: 'Paciente con Sifilis Gestacional o Congenita?',
                                        width: 250,
                                        allowBlank: false,
                                        store: stSifilisGestacional,
                                        valueField: 'Codigo',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        //value: 21,
                                        id: 'intIdentificacionRiesgoSifilisGestacional'
                                    },
                                    {
                                        xtype: 'combo',
                                        name: 'Paciente con Hipertension Gestacional?',
                                        fieldLabel: 'Paciente con Hipertension Gestacional?',
                                        width: 250,
                                        allowBlank: false,
                                        store: stHipertencionGestacional,
                                        valueField: 'Codigo',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        //value: 21,
                                        id: 'intIdentificacionRiesgoHipertencionGestacional'
                                    },
                                    {
                                        xtype: 'combo',
                                        name: 'Paciente con Hipotiroidismo Congenito?',
                                        fieldLabel: 'Paciente con Hipotiroidismo Congenito?',
                                        width: 250,
                                        allowBlank: false,
                                        store: stHipotiroidismoCongenito,
                                        valueField: 'Codigo',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        //value: 21,
                                        id: 'intIdentificacionRiesgoHipotiroidismoCongenito'
                                    },
                                    {
                                        xtype: 'combo',
                                        name: 'Sintomático Respiratorio?',
                                        fieldLabel: 'Sintomático Respiratorio?',
                                        width: 250,
                                        allowBlank: false,
                                        store: stSintomaticoRespiratorio,
                                        valueField: 'Codigo',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        //value: 21,
                                        id: 'intIdentificacionRiesgoSintomaticoRespiratorio'
                                    },
                                    {
                                        xtype: 'combo',
                                        name: 'Paciente Tuberculosis Multidrogoresistente?',
                                        fieldLabel: 'Paciente Tuberculosis Multidrogoresistente?',
                                        width: 250,
                                        allowBlank: false,
                                        store: stTuberculosisMultidrogoresistente,
                                        valueField: 'Codigo',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        //value: 21,
                                        id: 'intIdentificacionRiesgoTuberculosisMultidrogoresistente'
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                layout: 'form',
                                width: 400,
                                height: 310,
                                labelSeparator: '',
                                labelStyle: 'color:blue;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        name: 'Paciente con Lepra?',
                                        fieldLabel: 'Paciente con Lepra',
                                        width: 250,
                                        allowBlank: false,
                                        store: stLepra,
                                        valueField: 'Codigo',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        //value: 21,
                                        id: 'intIdentificacionRiesgoLepra'
                                    },
                                    {
                                        xtype: 'combo',
                                        name: 'Paciente Victima Maltrato',
                                        fieldLabel: 'Paciente Victima Maltrato',
                                        width: 250,
                                        allowBlank: false,
                                        store: stVictimaMaltrato,
                                        valueField: 'Codigo',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        //value: 21,
                                        id: 'intIdentificacionRiesgoVictimaMaltrato'
                                    },
                                    {
                                        xtype: 'combo',
                                        name: 'Paciente Victima Violencia Sexual',
                                        fieldLabel: 'Paciente Victima Violencia Sexual',
                                        width: 250,
                                        allowBlank: false,
                                        store: stViolenciaSexual,
                                        valueField: 'Codigo',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        //value: 21,
                                        id: 'intIdentificacionRiesgoViolenciaSexual'
                                    },
                                    {
                                        xtype: 'combo',
                                        name: 'Infecciones de Trasmisión Sexual',
                                        fieldLabel: 'Infecciones de Trasmisión Sexual',
                                        width: 250,
                                        allowBlank: false,
                                        store: stInfeccionTransmiteSexual,
                                        valueField: 'Codigo',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        //value: 21,
                                        id: 'intIdentificacionRiesgoInfeccionesTransmisionSexual'
                                    },
                                    {
                                        xtype: 'combo',
                                        name: 'Enfermedad Mental',
                                        fieldLabel: 'Enfermedad Mental',
                                        width: 250,
                                        allowBlank: false,
                                        store: stEnfermedadMental,
                                        valueField: 'Codigo',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        //value: 21,
                                        id: 'intIdentificacionRiesgoEnfermedadMental'
                                    },
                                    {
                                        xtype: 'combo',
                                        name: 'Paciente con Fluorosis Dental',
                                        fieldLabel: 'Paciente con Fluorosis Dental',
                                        width: 250,
                                        allowBlank: false,
                                        store: stFluorosisDental,
                                        valueField: 'Codigo',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        //value: 21,
                                        id: 'intIdentificacionRiesgoFluorosisDental'
                                    }
                                ]
                            }
                        ]
                    }
                ]
            }
        ];
        fsAntecedentesPersonalesUi.superclass.initComponent.call(this);
    }
});
