/*
* @category    Formulario Modelo Historia Clinica Odontologia Primera Vez
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


winHCOdontologia001Ui = Ext.extend(Ext.Window, {
    title: 'eOfiClinic ©  .:: Historia Clinica Odontologia Primera Vez ::.',
    width: 1010,
    height: 636,
    closable: false,
    resizable: false,
    draggable: false,
    modal: true,
    id: 'winHCOdontologia001',
    initComponent: function() {
        
        tmpmx = objMX;
        tmpmxadd = objMXADD;
        tmpexa = objEXA;
        tmprem = objREM;
        myPaciente = 0;
        myCAS = 0;
        
        try {
            var campo = Ext.getCmp('sysPacientePlantillaHC');
            if ( campo != null ) {
                myPaciente = Ext.getCmp('sysPacientePlantillaHC').getValue();
            }
        }catch(ex){
        }
        if(myPaciente == 0){
            try {
                var campo1 = Ext.getCmp('sysIdPacienteHC');
                if ( campo1 != null ) {
                    myPaciente = Ext.getCmp('sysIdPacienteHC').getValue();
                }
            }catch(ex){
            }
        }
        if(myPaciente == 0){
            try {
                var campo5 = Ext.getCmp('sysPacienteRefHC');
                if ( campo5 != null ) {
                    myPaciente = Ext.getCmp('sysPacienteRefHC').getValue();
                }
            }catch(ex){
            }
        }
        try {
            var campo2 = Ext.getCmp('sysCASPlantillaHC');
            if ( campo2 != null ) {
                myCAS = Ext.getCmp('sysCASPlantillaHC').getValue();
            }
        }catch(ex){
        }
        if(myCAS == 0){
            try {
                var campo3 = Ext.getCmp('sysCASHC');
                if ( campo3 != null ) {
                    myCAS = Ext.getCmp('sysCASHC').getValue();
                }
            }catch(ex){
            }
        }
        if(myCAS == 0){
            try {
                var campo4 = Ext.getCmp('sysCASRefHC');
                if ( campo4 != null ) {
                    myCAS = Ext.getCmp('sysCASRefHC').getValue();
                }
            }catch(ex){
            }
        }
        if (objMX != "NA"){
            var xSolMX = eval(objMX);
            Ext.getCmp('gridMedicamentosHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: wPaciente,
                    pCAS: wCAS
                }
            });
        }
        else{
            var xSolMX = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        if (objEXA != "NA"){
            var xSolEXA = eval(objEXA);
            Ext.getCmp('gridExamenesHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: wPaciente,
                    pCAS: wCAS
                }
            });
        }else{
            var xSolEXA = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }    
        if (objREM != "NA"){
            var xSolREM = eval(objREM);
            Ext.getCmp('gridRemisionesHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: wPaciente,
                    pCAS: wCAS
                }
            });
        }else{
            var xSolREM = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        
        function DescripcionGrid(val, x, store){
            mostrarHC = '<table><tr><td style="padding: 1px;">';
            mostrarHC += val;
            mostrarHC += '</td></tr></table>';
            return mostrarHC;
        }
        
        //Store
        
        var stGridDienteActividadesRealizadas = new StoreGridDienteActividadesRealizadas();
        stGridDienteActividadesRealizadas.load({
            params: {
                pPaciente: wPaciente
            }
        });
        
        var stGridDienteActividadesProxCita = new StoreGridDienteActividadesProxCita();
        stGridDienteActividadesProxCita.load({
            params: {
                pPaciente: wPaciente
            }
        });
        
        var stGridOdontogramasxPaciente = new StoreGridOdontogramasxPaciente();
        stGridOdontogramasxPaciente.load({
            params: {
                pPaciente: wPaciente
            }
        });
        
        function VerInfoOdontograma(value, metaData, record, rowIndex, colIndex, store){  
            metaData.attr = 'style="white-space:normal"';  
            return value + '</br>' + record.get('Profesional') + '</br>Tipo Odontograma:' + record.get('TipoOdontograma') + '</br>Tipo Denticion:' + record.get('TipoDenticion');
        }
        
        var OdontogramaInical = new Ext.Panel({ 
            autoLoad:{
                url:'../../../app/frm/odontograma/odontograma001.php?pPaciente=' + wPaciente + '&pCAS=' + wCAS,
                scripts:true,
                scope:this
            },
            id:'OdontogramaInical',
            height: 480,
            autoScroll:true,
            closable:false
        });
        
        //Store Locales
        var dataTipoDenticion = [
            ['TEMPORAL'],
            ['PERMANENTE'],
            ['MIXTA']
        ];
        var stTipoDenticion = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stTipoDenticion.loadData(dataTipoDenticion);
        
        var dataHigiene = [
            ['BUENO'],
            ['REGULAR'],
            ['MALO']
        ];
        var stHigiene = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stHigiene.loadData(dataHigiene);
        
        var dataRiesgo = [
            ['ALTO'],
            ['MEDIO'],
            ['BAJO']
        ];
        var stRiesgo = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stRiesgo.loadData(dataRiesgo);        

        //
        this.items = [
            {
                xtype: 'panel',
                frame: true,
                anchor: '100%',
                id: 'panelHC',
                border: false,
                height: 570,
                autoScroll: true,
                layout: 'form',
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'tabpanel',
                        anchor: '100%',
                        autoHeight: true,
                        border: false,
                        enableTabScroll: true,
                        ref: 'fTabPanel',
                        id: 'fTabPanel',
                        activeTab: 0,
                        items: [
                            {
                                xtype: 'panel',
                                title: 'Datos Basicos',
                                autoHeight: true,
                                autoScroll: true,
                                width: 1005,
                                frame: true,
                                border: false,
                                id: 'fichaIdentifica',
                                layout: 'form',
                                items:[
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysIdCodPlantillaHC'
                                    },
                                     {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        value: 1,
                                        id: 'sysUsaGridSalida'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                                        value: 0,
                                        id: 'sysYaGuardoHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Plantilla',
                                        id: 'sysPlantillaHC',
                                        name: 'PLANTILLA'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysRutaRptHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysRutaRptMx'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysRutaRptExa'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysRutaRptRem'
                                    },
                                    {
                                        xtype: 'textfield',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Actividad',
                                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                                        id: 'sysActividadHC',
                                        name: 'PLANTILLA'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Empresa',
                                        id: 'sysEmpresaHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'IPS',
                                        id: 'sysIPSHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Usuario',
                                        id: 'sysUsuarioHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Profesional',
                                        id: 'sysProfesionalHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Paciente',
                                        id: 'sysIdPacienteHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Apertura',
                                        id: 'sysAperturaHC'
                                    },
                                    {
                                        xtype: 'textfield',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Cliente',
                                        id: 'sysClienteHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Plantilla',
                                        id: 'sysIdClienteHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Plantilla',
                                        id: 'sysIdPlanHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Plantilla',
                                        id: 'sysIdSubPlanHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Plantilla',
                                        id: 'sysIdContratoHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Genero',
                                        id: 'sysGeneroPacHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Edad',
                                        id: 'sysEdadPacHC'
                                    },
                                    {
                                        xtype: 'textfield',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Profesional',
                                        id: 'sysProfesionalAgendaHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'ConsecutivoDetalle',
                                        id: 'sysConsecutivoDetalleHC'
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'CAS',
                                                id: 'sysCASHC'
                                            },
                                            {
                                                xtype: 'displayfield',
                                                id: 'sysFechaHC',
                                                value: 'Fecha: '
                                            },
                                            {
                                                xtype: 'textfield',
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysFechaHC'
                                            },
                                            {
                                                xtype: 'displayfield',
                                                id: 'sysHoraHC',
                                                value: 'Hora: '
                                            },
                                            {
                                                xtype: 'textfield',
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysHoraHC'
                                            },
                                            {
                                                xtype: 'displayfield',
                                                id: 'sysLegalizacionHC',
                                                value: 'Legalización: '
                                            },
                                            {
                                                xtype: 'textfield',
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysLegalizaHC'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'textfield',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Paciente',
                                        value: 'CC 792558261  - JORGE GALEANO RUIZ - (Masculino) FechaNac: 1973-01-30, Edad 38 Años',
                                        id: 'sysPacienteHC'
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 100,
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Genero',
                                                id: 'sysGeneroHC'
                                            },
                                            {
                                                html: 'Fecha Nac:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 100,
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysFechaNac'
                                            },
                                            {
                                                html: 'Edad:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 350,
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysEdadHC'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 370,
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Ocupación',
                                                id: 'sysOcupacionHC'
                                            },
                                            {
                                                html: 'Discapacidad:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 370,
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysDiscapacidadHC'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 370,
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Estado Civil',
                                                id: 'sysEstadoCivilHC'
                                            },
                                            {
                                                html: 'Escolaridad:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 380,
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysEscolaridadHC'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 370,
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Dirección',
                                                id: 'sysDireccionHC'
                                            },
                                            {
                                                html: 'Telefono:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 390,
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysTelefonoHC'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 380,
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Etnia',
                                                id: 'sysEtniaHC'
                                            },
                                            {
                                                html: 'Estrato:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 390,
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysEstratoHC'
                                            }
                                        ]
                                    },
                                    {
                                        html: '<hr>',
                                        style: 'background:transparent;',
                                        border: false
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Evolucion',
                                autoHeight: true,
                                autoScroll: true,
                                width: 1005,
                                frame: true,
                                border: false,
                                id: 'fichaEvolucion',
                                layout: 'form',
                                items: [
                                    {
                                        xtype: 'form',
                                        frame: true,
                                        anchor: '100%',
                                        id: 'frmHC',
                                        padding: 10,
                                        border: false,
                                        autoScroll: true,
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'fieldset',
                                                title: 'MOTIVO CONSULTA',
                                                layout: 'table',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'MOTIVO CONSULTA',
                                                        name: 'MOTIVO CONSULTA',
                                                        height: 100,            
                                                        allowBlank: true,
                                                        id: 'memMotivoConsulta'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                autoHeight: true,
                                                anchor: '100%',
                                                layout: {
                                                    columns: 2,
                                                    type: 'table'
                                                },
                                                items: [
                                                    {
                                                        xtype: 'panel',
                                                        autoHeight: true,
                                                        width: 180,
                                                        layout: {
                                                            type: 'form'
                                                        },
                                                        items: [
                                                            {
                                                                xtype: 'checkbox',
                                                                fieldLabel: 'Cirugias Incluso Orales',
                                                                name: 'Cirugias Incluso Orales',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolCxOral'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                fieldLabel: 'Exodoncias',
                                                                name: 'Exodoncias',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolExodoncias'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                fieldLabel: 'Enfermedades Orales',
                                                                name: 'Enfermedades Orales',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolEnfermedadesOrales'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                fieldLabel: 'Protesis',
                                                                name: 'Protesis',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolProtesis'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        autoHeight: true,
                                                        width: 500,
                                                        layout: {
                                                            type: 'form'
                                                        },
                                                        items: [
                                                           {
                                                                xtype: 'textarea',
                                                                anchor: '100%',
                                                                width: 480,
                                                                fieldLabel: 'Otras Patologias o Antecedentes Odontologicos',
                                                                name: 'Otras Patologias o Antecedentes Odontologicos',
                                                                height: 50,            
                                                                allowBlank: true,
                                                                id: 'memAnteOdontologicos'
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                anchor: '100%',
                                                                width: 480,
                                                                fieldLabel: 'Observaciones',
                                                                name: 'Observaciones',
                                                                height: 50,            
                                                                allowBlank: true,
                                                                id: 'memObservaciones'
                                                            } 
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'textarea',
                                                anchor: '100%',
                                                width: 880,
                                                fieldLabel: 'Habitos Asociados a Cavidad Oral',
                                                name: 'Habitos Asociados a Cavidad Oral',
                                                height: 100,            
                                                allowBlank: true,
                                                id: 'memHabitosAsociados'
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'Examen Estomatologico',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'panel',
                                                        autoHeight: true,
                                                        anchor: '100%',
                                                        layout: {
                                                            columns: 6,
                                                            type: 'table'
                                                        },
                                                        items: [
                                                            {
                                                                xtype: 'panel',
                                                                title: 'Estructura',
                                                                width: 180,
                                                                height: 150, 
                                                                labelSeparator: ' ',
                                                                labelWidth: 160,
                                                                labelStyle: 'text-align:right;',
                                                                layout: {
                                                                    type: 'form'
                                                                },
                                                                items: [
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 1,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        fieldLabel: 'Labio Inferior',
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaEstoma001'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 1,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        fieldLabel: 'Labio Superior',
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaEstoma002'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 1,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        fieldLabel: 'Comisuras',
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaEstoma003'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 1,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        fieldLabel: 'Mucosa Oral',
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaEstoma004'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                title: 'Sano',
                                                                labelWidth: 1,
                                                                width: 80,
                                                                height: 150,
                                                                layout: {
                                                                    type: 'form'
                                                                },
                                                                items: [
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        name: 'Labio Inferior',
                                                                        value: 'true',
                                                                        width: 30,
                                                                        id: 'bolExaEstomatologico_1'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        name: 'Labio Superior',
                                                                        value: 'true',
                                                                        width: 30,
                                                                        id: 'bolExaEstomatologico_2'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        name: 'Comisuras',
                                                                        value: 'true',
                                                                        width: 30,
                                                                        id: 'bolExaEstomatologico_3'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        name: 'Mucosa Oral',
                                                                        value: 'true',
                                                                        width: 30,
                                                                        id: 'bolExaEstomatologico_4'
                                                                    },
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                title: 'Estructura',
                                                                width: 180,
                                                                height: 150,
                                                                labelSeparator: ' ',
                                                                labelStyle: 'text-align:right;',
                                                                labelWidth: 160,
                                                                layout: {
                                                                    type: 'form'
                                                                },
                                                                items: [
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 1,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        fieldLabel: 'Surcos Yugales',
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaEstoma005'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 1,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        fieldLabel: 'Frenillos',
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaEstoma006'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 1,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        fieldLabel: 'Orofaringe',
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaEstoma007'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 1,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        fieldLabel: 'Paladar',
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaEstoma008'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                title: 'Sano',
                                                                labelWidth: 1,
                                                                height: 150,
                                                                width: 80,
                                                                layout: {
                                                                    type: 'form'
                                                                },
                                                                items: [
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        name: 'Surcos Yugales',
                                                                        width: 30,
                                                                        value: 'true',
                                                                        id: 'bolExaEstomatologico_5'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        name: 'Frenillos',
                                                                        width: 30,
                                                                        value: 'true',
                                                                        id: 'bolExaEstomatologico_6'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        name: 'Orofaringe',
                                                                        width: 30,
                                                                        value: 'true',
                                                                        id: 'bolExaEstomatologico_7'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        name: 'Paladar',
                                                                        width: 30,
                                                                        value: 'true',
                                                                        id: 'bolExaEstomatologico_8'
                                                                    },
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                title: 'Estructura',
                                                                width: 180,
                                                                height: 150,
                                                                labelSeparator: ' ',
                                                                labelStyle: 'text-align:right;',
                                                                labelWidth: 160,
                                                                layout: {
                                                                    type: 'form'
                                                                },
                                                                items: [
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 1,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        fieldLabel: 'Glandulas Salivales',
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaEstoma009'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 1,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        fieldLabel: 'Piso de Boca',
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaEstoma010'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 1,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        fieldLabel: 'Dorso de Lengua',
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaEstoma011'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 1,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        fieldLabel: 'Vientre de Lengua',
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaEstoma012'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                title: 'Sano',
                                                                labelWidth: 1,
                                                                width: 80,
                                                                height: 150,
                                                                layout: {
                                                                    type: 'form'
                                                                },
                                                                items: [
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        name: 'Glandulas Salivales',
                                                                        width: 30,
                                                                        value: 'true',
                                                                        id: 'bolExaEstomatologico_9'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        name: 'Piso de Boca',
                                                                        width: 30,
                                                                        value: 'true',
                                                                        id: 'bolExaEstomatologico_10'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        name: 'Dorso de Lengua',
                                                                        width: 30,
                                                                        value: 'true',
                                                                        id: 'bolExaEstomatologico_11'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        name: 'Vientre de Lengua',
                                                                        width: 30,
                                                                        value: 'true',
                                                                        id: 'bolExaEstomatologico_12'
                                                                    },
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'Observaciones',
                                                        name: 'Observaciones',
                                                        height: 100,            
                                                        allowBlank: true,
                                                        id: 'memExaEstomatologicoObservaciones'
                                                    },
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'Articulacion Temporo-Mandibular',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'panel',
                                                        autoHeight: true,
                                                        anchor: '100%',
                                                        layout: {
                                                            columns: 4,
                                                            type: 'table'
                                                        },
                                                        items: [
                                                            {
                                                                xtype: 'panel',
                                                                title: 'Estructura',
                                                                width: 180,
                                                                height: 150,
                                                                labelSeparator: ' ',
                                                                labelStyle: 'text-align:right;',
                                                                labelWidth: 160,
                                                                layout: {
                                                                    type: 'form'
                                                                },
                                                                items: [
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 1,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        fieldLabel: 'Ruidos',
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaEstoma013'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 1,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        fieldLabel: 'Desviacion',
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaEstoma014'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 1,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        fieldLabel: 'Cambio de Volumen',
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaEstoma015'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 1,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        fieldLabel: 'Bloqueo Mandibular',
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaEstoma016'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                title: 'Sano',
                                                                labelWidth: 1,
                                                                width: 80,
                                                                height: 150,
                                                                layout: {
                                                                    type: 'form'
                                                                },
                                                                items: [
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        name: 'Ruidos',
                                                                        width: 30,
                                                                        value: 'true',
                                                                        id: 'bolArtMandibular_1'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        name: 'Desviacion',
                                                                        width: 30,
                                                                        value: 'true',
                                                                        id: 'bolArtMandibular_2'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        name: 'Cambio de Volumen',
                                                                        width: 30,
                                                                        value: 'true',
                                                                        id: 'bolArtMandibular_3'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        name: 'Bloqueo Mandibular',
                                                                        width: 30,
                                                                        value: 'true',
                                                                        id: 'bolArtMandibular_4'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                title: 'Estructura',
                                                                width: 180,
                                                                height: 150,
                                                                labelSeparator: ' ',
                                                                labelStyle: 'text-align:right;',
                                                                labelWidth: 160,
                                                                layout: {
                                                                    type: 'form'
                                                                },
                                                                items: [
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 1,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        fieldLabel: 'Limitacion Apertura',
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaEstoma017'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 1,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        fieldLabel: 'Dolor Articular',
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaEstoma018'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 1,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        fieldLabel: 'Dolor Muscular',
                                                                        border: 0,
                                                                        style: 'background:transparent;text-align:right;border:none;',
                                                                        id: 'sysExaEstoma019'
                                                                    },
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                title: 'Sano',
                                                                labelWidth: 1,
                                                                width: 80,
                                                                height: 150,
                                                                layout: {
                                                                    type: 'form'
                                                                },
                                                                items: [
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        name: 'Limitacion Apertura',
                                                                        width: 30,
                                                                        value: 'true',
                                                                        id: 'bolArtMandibular_5'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        name: 'Dolor Articular',
                                                                        width: 30,
                                                                        value: 'true',
                                                                        id: 'bolArtMandibular_6'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        name: 'Dolor Muscular',
                                                                        width: 30,
                                                                        value: 'true',
                                                                        id: 'bolArtMandibular_7'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'Indice COPS',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                name: 'Dientes Cariados',
                                                                fieldLabel: 'Dientes Cariados',
                                                                width: 70,
                                                                minValue: 0,
                                                                maxValue: 100,
                                                                decimalPrecision: 0,
                                                                allowBlank: false,
                                                                value: 0,
                                                                id: 'intIndice_1'
                                                            },
                                                            {
                                                                html: 'Dientes Obturados'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                name: 'Dientes Obturados',
                                                                width: 70,
                                                                minValue: 0,
                                                                maxValue: 100,
                                                                decimalPrecision: 0,
                                                                allowBlank: false,
                                                                value: 0,
                                                                id: 'intIndice_2'
                                                            },
                                                            {
                                                                html: 'Dientes Exfoliados'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                name: 'Dientes Exfoliados',
                                                                width: 70,
                                                                minValue: 0,
                                                                maxValue: 100,
                                                                decimalPrecision: 0,
                                                                allowBlank: false,
                                                                value: 0,
                                                                id: 'intIndice_3'
                                                            },
                                                            {
                                                                html: 'Dientes Sanos'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                name: 'Dientes Sanos',
                                                                width: 70,
                                                                minValue: 0,
                                                                maxValue: 100,
                                                                decimalPrecision: 0,
                                                                allowBlank: false,
                                                                value: 0,
                                                                id: 'intIndice_4'
                                                            },
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'Protesis',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Presenta Protesis',
                                                                fieldLabel: 'Presenta Protesis',
                                                                width: 60,
                                                                allowBlank: true,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strProtesis_1',
                                                                listeners:{
                                                                    select : function(cmb, rec, idx){
                                                                        if(cmb.getValue() == "NO"){
                                                                            Ext.getCmp('strProtesis_2').allowBlank = true;
                                                                            Ext.getCmp('strProtesis_2').setValue(null);
                                                                            Ext.getCmp('strProtesis_2').disable();
                                                                            Ext.getCmp('strProtesis_2').clearInvalid();
                                                                            Ext.getCmp('strProtesis_3').allowBlank = true;
                                                                            Ext.getCmp('strProtesis_3').setValue(null);
                                                                            Ext.getCmp('strProtesis_3').disable();
                                                                            Ext.getCmp('strProtesis_3').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strProtesis_2').enable();
                                                                            Ext.getCmp('strProtesis_2').allowBlank = false;
                                                                            Ext.getCmp('strProtesis_3').enable();
                                                                            Ext.getCmp('strProtesis_3').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html: 'Tipo Protesis'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Tipo Protesis',
                                                                width: 150,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                id: 'strProtesis_2'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        name: 'Descripcion',
                                                        fieldLabel: 'Descripcion',
                                                        width: 350,
                                                        allowBlank: true,
                                                        disabled: true,
                                                        id: 'strProtesis_3'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'Higiene Oral',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'panel',
                                                        autoHeight: true,
                                                        anchor: '100%',
                                                        layout: {
                                                            columns: 2,
                                                            type: 'table'
                                                        },
                                                        items: [
                                                            {
                                                                xtype: 'panel',
                                                                autoHeight: true,
                                                                width: 280,
                                                                layout: {
                                                                    type: 'form'
                                                                },
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Higiene Oral',
                                                                        fieldLabel: 'Higiene Oral',
                                                                        width: 150,
                                                                        allowBlank: true,
                                                                        store: stHigiene,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strHigieneOral_1'
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        name: 'Frecuencia Cepillado',
                                                                        fieldLabel: 'Frecuencia Cepillado',
                                                                        emptyText: 'Veces al Dia', 
                                                                        width: 100,
                                                                        minValue: 0,
                                                                        maxValue: 100,
                                                                        decimalPrecision: 0,
                                                                        allowBlank: false,
                                                                        value: 0,
                                                                        id: 'intHigieneOral_2'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Grado de Riesgo',
                                                                        fieldLabel: 'Grado de Riesgo',
                                                                        width: 150,
                                                                        allowBlank: true,
                                                                        store: stRiesgo,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strHigieneOral_3'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        name: 'Usa Ceda Dental',
                                                                        fieldLabel: 'Usa Ceda Dental',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolHigieneOral_4'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        name: 'Pigmentacion',
                                                                        fieldLabel: 'Pigmentacion',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolHigieneOral_5'
                                                                    },
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                autoHeight: true,
                                                                width: 600,
                                                                layout: {
                                                                    type: 'form'
                                                                },
                                                                items: [
                                                                    {
                                                                        xtype: 'compositefield',
                                                                        style: 'background:transparent;',
                                                                        items: [
                                                                            {
                                                                                xtype: 'numberfield',
                                                                                name: 'Superficies con Placa',
                                                                                fieldLabel: 'Superficies con Placa',
                                                                                width: 100,
                                                                                minValue: 0,
                                                                                decimalPrecision: 0,
                                                                                allowBlank: false,
                                                                                value: 0,
                                                                                id: 'intHigieneOral_6'
                                                                            },
                                                                            {
                                                                                html: 'Porcentaje Placa'
                                                                            },
                                                                            {
                                                                                xtype: 'numberfield',
                                                                                name: 'Porcentaje Placa',
                                                                                width: 100,
                                                                                minValue: 0,
                                                                                decimalPrecision: 0,
                                                                                allowBlank: false,
                                                                                value: 0,
                                                                                id: 'intHigieneOral_7'
                                                                            },
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'textarea',
                                                                        width: 300,
                                                                        fieldLabel: 'Observaciones',
                                                                        name: 'Observaciones',
                                                                        height: 80,            
                                                                        allowBlank: true,
                                                                        id: 'memHigieneOral_8'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'Examen Pulpar',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'checkbox',
                                                                name: 'Cuellos Sensibles',
                                                                fieldLabel: 'Cuellos Sensibles',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolExamenPulpar_1'
                                                            },
                                                            {
                                                                html: 'Abscesos'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                name: 'Abscesos',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolExamenPulpar_2'
                                                            },
                                                            {
                                                                html: 'Exposicion Pulpar'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                name: 'Exposicion Pulpar',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolExamenPulpar_3'
                                                            },
                                                            {
                                                                html: 'Cambio de Color'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                name: 'Cambio de Color',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolExamenPulpar_4'
                                                            },
                                                            {
                                                                html: 'Fistula'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                name: 'Fistula',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolExamenPulpar_6'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 480,
                                                        fieldLabel: 'Observaciones',
                                                        name: 'Observaciones',
                                                        height: 100,            
                                                        allowBlank: true,
                                                        id: 'memExamenPulpar_5'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'Tejidos Dentarios y Oclusion',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'checkbox',
                                                                name: 'Supernumerarios',
                                                                fieldLabel: 'Supernumerarios',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolTejidosDentarios_1'
                                                            },
                                                            {
                                                                html: 'Decoloracion'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                name: 'Decoloracion',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolTejidosDentarios_2'
                                                            },
                                                            {
                                                                html: 'Descalsificacion'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                name: 'Descalcificacion',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolTejidosDentarios_3'
                                                            },
                                                            {
                                                                html: 'Facetas de Desgaste'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                name: 'Facetas de Desgaste',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolTejidosDentarios_4'
                                                            },
                                                            {
                                                                html: 'Abracion y/o Erosion'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                name: 'Abrasion y/o Erosion',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolTejidosDentarios_5'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'Observaciones',
                                                        name: 'Observaciones',
                                                        height: 100,            
                                                        allowBlank: true,
                                                        id: 'memTejidosDentarios_6'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'Alteraciones Periodontales',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'checkbox',
                                                                name: 'Sangrado',
                                                                fieldLabel: 'Sangrado',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolAlteracionesPeriodontales_1'
                                                            },
                                                            {
                                                                html: 'Exudado'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                name: 'Exudado',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolAlteracionesPeriodontales_2'
                                                            },
                                                            {
                                                                html: 'Supuracion'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                name: 'Supuracion',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolAlteracionesPeriodontales_3'
                                                            },
                                                            {
                                                                html: 'Calculos'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                name: 'Calculos',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolAlteracionesPeriodontales_4'
                                                            },
                                                            {
                                                                html: 'Inflamacion'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                name: 'Inflamacion',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolAlteracionesPeriodontales_5'
                                                            },
                                                            {
                                                                html: 'Retracciones'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                name: 'Retracciones',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolAlteracionesPeriodontales_6'
                                                            },
                                                            {
                                                                html: 'Presencia Bolsas'
                                                            },
                                                            {
                                                                xtype: 'checkbox',
                                                                name: 'Presencia Bolsas',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolAlteracionesPeriodontales_7'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'Observaciones',
                                                        name: 'Observaciones',
                                                        height: 100,            
                                                        allowBlank: true,
                                                        id: 'memAlteracionesPeriodontales_8'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'textarea',
                                                anchor: '100%',
                                                width: 880,
                                                fieldLabel: 'Tipo Oclusion',
                                                name: 'Tipo Oclusion',
                                                height: 60,            
                                                allowBlank: true,
                                                id: 'memTipoOclusion'
                                            },
                                            {
                                                xtype: 'textarea',
                                                anchor: '100%',
                                                width: 880,
                                                fieldLabel: 'Lectura Radiografica',
                                                name: 'Lectura Radiografica',
                                                height: 60,            
                                                allowBlank: true,
                                                id: 'memLecturaRx'
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'Diagnosticos',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'Diagnostico - Articular',
                                                        name: 'Diagnostico - Articular',
                                                        height: 100,            
                                                        allowBlank: true,
                                                        id: 'memDiagnosticoArticular'
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'Diagnostico - Pulpar',
                                                        name: 'Diagnostico - Pulpar',
                                                        height: 100,            
                                                        allowBlank: true,
                                                        id: 'memDiagnosticoPulpar'
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'Diagnostico - Periodontal',
                                                        name: 'Diagnostico - Periodontal',
                                                        height: 100,            
                                                        allowBlank: true,
                                                        id: 'memDiagnosticoPeriodontal'
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'Diagnostico - Dental',
                                                        name: 'Diagnostico - Dental',
                                                        height: 100,            
                                                        allowBlank: true,
                                                        id: 'memDiagnosticoDental'
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'Diagnostico - CyD',
                                                        name: 'Diagnostico - CyD',
                                                        height: 100,            
                                                        allowBlank: true,
                                                        id: 'memDiagnosticoCyD'
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'Diagnostico - Tejidos Blandos',
                                                        name: 'Diagnostico - Tejidos Blandos',
                                                        height: 100,            
                                                        allowBlank: true,
                                                        id: 'memDiagnosticoTejidosBlandos'
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'Diagnostico - Otros',
                                                        name: 'Diagnostico - Otros',
                                                        height: 100,            
                                                        allowBlank: true,
                                                        id: 'memDiagnosticoOtros'
                                                    },
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'CONDUCTA',
                                                layout: 'table',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'CONDUCTA',
                                                        name: 'CONDUCTA',
                                                        height: 100,            
                                                        allowBlank: true,
                                                        id: 'memConducta'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'RIPS',
                                                layout: 'form',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                id: 'fsRips',
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: false,
                                                                fieldLabel: 'Diagnostico Principal',
                                                                id: 'sysDiagPpalHC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request({
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagPpalHC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                        Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagPpalHCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Principal',
                                                                id: 'btnSearchDiagPpalHC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagPpalHC','sysDiagPpalHCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.1',
                                                                id: 'sysDiagRel1HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel1HC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagRel1HCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel1HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado1',
                                                                id: 'btnSearchDiagRel1HC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel1HC','sysDiagRel1HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.2',
                                                                id: 'sysDiagRel2HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel2HC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagRel2HCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel2HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado2',
                                                                id: 'btnSearchDiagRel2HC1',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel2HC','sysDiagRel2HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.3',
                                                                id: 'sysDiagRel3HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel3HC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagRel3HCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel3HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado3',
                                                                id: 'btnSearchDiagRel3HC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel3HC','sysDiagRel3HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Tipo de Diagnostico',
                                                        width:750,
                                                        name: 'Tipo de Diagnostico',
                                                        allowBlank: false,
                                                        store: 'StoreTipoDiagnostico',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        id: 'sysTipoDiagosticoHC'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Finalidad Consulta',
                                                        width:750,
                                                        name: 'Finalidad Consulta',
                                                        allowBlank: false,
                                                        store: 'StoreFinalidadConsulta',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        value: 10,
                                                        id: 'sysFinalidadConsultaHC'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Causa Externa',
                                                        width:750,
                                                        name: 'Causa Externa',
                                                        allowBlank: false,
                                                        store: 'StoreCausaExterna',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        value: 13,
                                                        id: 'sysCausaExternaHC'
                                                    }                            
                                                ]
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Carta Dental Inicial (LEY 38/93)',
                                autoHeight: true,
                                autoScroll: true,
                                frame: true,
                                border: false,
                                width: 1005,
                                id: 'fichaCartaDentalInicial',
                                tbar:{
                                    items: [
                                        {
                                            html: 'Tipo Denticion:'
                                        },
                                        {
                                            xtype: 'combo',
                                            width: 110,
                                            allowBlank: true,
                                            store: stTipoDenticion,
                                            valueField: 'Descripcion',
                                            displayField: 'Descripcion',
                                            mode: 'local',
                                            forceSelection: true,
                                            typeAhead: true,
                                            typeAheadDelay: 10,
                                            triggerAction: 'all',
                                            id: 'sysBtnTipoDenticion'
                                        },
                                        {
                                            xtype: 'tbseparator'
                                        },
                                        {
                                            xtype: 'button',
                                            text: 'Crear Odontograma',
                                            iconCls: 'btnDiente',
                                            id: 'btnCrearOdontograma',
                                            listeners:{
                                                click : function(){
                                                    if (Ext.getCmp('sysYaGuardoHC').getValue() === 0){
                                                        Ext.Msg.show({
                                                            title: 'eOfiClinic',
                                                            msg: 'Debe guardar la evolucion antes de gererar el odontograma',
                                                            buttons: Ext.Msg.OK,
                                                            icon: Ext.Msg.ERROR
                                                        });
                                                    }else{
                                                        if(Ext.getCmp('sysBtnTipoDenticion').getValue() === "" || Ext.getCmp('sysBtnTipoDenticion').getValue() === null){
                                                            Ext.Msg.show({
                                                                title: 'eOfiClinic',
                                                                msg: 'Debe seleccionar el tipo de denticion',
                                                                buttons: Ext.Msg.OK,
                                                                icon: Ext.Msg.ERROR
                                                            });
                                                        }else{
                                                            Ext.Ajax.request({
                                                                url: '../../controlador/odontograma/controlador_odontograma.php',
                                                                params:{
                                                                    task: 'OBTENER_ULTIMO_ODONTOGRAMA',
                                                                    pPaciente: wPaciente
                                                                },
                                                                success: function(response,options)
                                                                {
                                                                    var Respuesta = response.responseText;
                                                                    var Contenido = Respuesta.split('^');
                                                                    if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                                        Ext.MessageBox.show({
                                                                            title: 'eOfiClinic',
                                                                            msg: 'Ocurrio un error al validar el odontograma del paciente.',
                                                                            buttons: Ext.MessageBox.OK,
                                                                            icon: Ext.MessageBox.ERROR
                                                                        });
                                                                    } else {
                                                                        var idOdontograma = parseInt(Contenido[0]);
                                                                        var tipoOdontograma = "Inicial";
                                                                        if(idOdontograma !== 0){
                                                                            tipoOdontograma = "Control";
                                                                        }
                                                                        Ext.Ajax.request({
                                                                            url: '../../controlador/odontograma/controlador_odontograma.php',
                                                                            params:{
                                                                                task: 'CREAR_ODONTOGRAMA',
                                                                                pPaciente: wPaciente,
                                                                                pIdOdontograma: idOdontograma,
                                                                                pTipoOdontograma: tipoOdontograma,
                                                                                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                                                                                pProfesional:  Ext.getCmp('sysProfesionalHC').getValue(),
                                                                                pCAS: wCAS,
                                                                                pCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                                                                                pTipoDenticion: Ext.getCmp('sysBtnTipoDenticion').getValue(),
                                                                                pUsuario: ID_USUARIO
                                                                            },
                                                                            success: function(response,options)
                                                                            {
                                                                                var Respuesta = response.responseText;
                                                                                var Contenido = Respuesta.split('^');
                                                                                if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                                                    Ext.MessageBox.show({
                                                                                        title: 'eOfiClinic',
                                                                                        msg: 'Ocurrio un error al crear el odontograma del paciente.',
                                                                                        buttons: Ext.MessageBox.OK,
                                                                                        icon: Ext.MessageBox.ERROR
                                                                                    });
                                                                                } else {
                                                                                    Ext.getCmp('gridOdontogramasxPaciente').store.reload();
                                                                                    var updater = Ext.getCmp('OdontogramaInical').getUpdater();
                                                                                    updater.setDefaultUrl('../../../app/frm/odontograma/odontograma001.php?pPaciente=' + wPaciente + '&pCAS=' + wCAS);
                                                                                    updater.refresh();
                                                                                }
                                                                            },
                                                                            failure: function(response,options){
                                                                                Ext.MessageBox.show({
                                                                                    title: 'eOfiClinic',
                                                                                    msg: 'No podemos crear el odontograma y/o No se pudo establecer conexión con el servidor',
                                                                                    buttons: Ext.MessageBox.OK,
                                                                                    icon: Ext.MessageBox.ERROR
                                                                                });
                                                                            },
                                                                            scope:this 
                                                                        });
                                                                    }
                                                                },
                                                                failure: function(response,options){
                                                                    Ext.MessageBox.show({
                                                                        title: 'Error Conexión',
                                                                        msg: 'No podemos crear el odontograma y/o No se pudo establecer conexión con el servidor',
                                                                        buttons: Ext.MessageBox.OK,
                                                                        icon: Ext.MessageBox.ERROR
                                                                    });
                                                                },
                                                                scope:this 
                                                            });
                                                        }
                                                    }
                                                }
                                            }
                                        },
                                        {
                                            xtype: 'tbseparator'
                                        },
                                        {
                                            html: '&nbsp;&nbsp;&nbsp;'
                                        },
                                        {
                                            xtype: 'tbseparator'
                                        },
                                        {
                                            xtype: 'button',
                                            text: 'Actualizar Odontograma',
                                            iconCls: 'btnActualizarGrid',
                                            id: 'btnUpdate',
                                            listeners:{
                                                click : function(){
                                                    var updater = Ext.getCmp('OdontogramaInical').getUpdater();
                                                    updater.setDefaultUrl('../../../app/frm/odontograma/odontograma001.php?pPaciente=' + wPaciente + '&pCAS=' + wCAS);
                                                    updater.refresh();
                                                }
                                            }
                                        },
                                        {
                                            xtype: 'tbseparator'
                                        }
                                    ]
                                },
                                items: [
                                    {
                                        xtype: 'panel',
                                        border: false, 
                                        autoHeight: true,
                                        layout: {
                                            columns: 2,
                                            type: 'table'
                                        },
                                        items:[
                                            {
                                                xtype: 'panel',
                                                //title: 'Odontogramas',
                                                //autoHeight: true,
                                                autoScroll: true,
                                                width: 250,
                                                height: 470,
                                                frame: true,
                                                border: false,
                                                items: [
                                                    {
                                                        xtype: 'grid',
                                                        layout: 'fit',
                                                        id: 'gridOdontogramasxPaciente',
                                                        store: stGridOdontogramasxPaciente,
                                                        anchor: "100%",
                                                        height: 390,
                                                        border: false,
                                                        frame: true,
                                                        loadMask: true,
                                                        colModel: new Ext.ux.grid.LockingColumnModel([
                                                            {
                                                                xtype: 'gridcolumn',
                                                                header: 'Id',
                                                                sortable: false,
                                                                width: 100,
                                                                hidden: true,
                                                                hideable: false,
                                                                dataIndex: 'CAS',
                                                                id: 'CAS'
                                                            },
                                                            {
                                                                xtype: 'gridcolumn',
                                                                header: 'Fecha',
                                                                sortable: true,
                                                                width: 205,
                                                                dataIndex: 'FecReporte',
                                                                renderer: VerInfoOdontograma,
                                                                id: 'FecReporte'
                                                            }
                                                        ]),
                                                        selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                                                        listeners:{
                                                            rowclick : function(grid, fila, e){
                                                                var selections = grid.selModel.getSelections();
                                                                var updater = Ext.getCmp('OdontogramaInical').getUpdater();
                                                                updater.setDefaultUrl('../../../app/frm/odontograma/odontograma001.php?pPaciente=' + wPaciente + '&pCAS=' + selections[0].json.CAS);
                                                                updater.refresh();
                                                            }
                                                        }
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                layout: 'form',
                                                width: 700,
                                                height: 470,
                                                items: [
                                                    OdontogramaInical
                                                ]
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'panel',
                                        layout: 'form',
                                        items: [
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        fieldLabel: 'Tipo Denticíon',
                                                        name: 'Tipo Denticíon',
                                                        width: 200,
                                                        allowBlank: true,
                                                        readOnly: true,
                                                        id: 'strTipoDenticionOdontograma'
                                                    },
                                                    {
                                                        xtype: 'displayfield',
                                                        id: 'sysCOP',
                                                        value: 'COP: '
                                                    },
                                                    {
                                                        xtype: 'numberfield',
                                                        width: 100,
                                                        decimalPrecision: 0,
                                                        readOnly: true,
                                                        allowBlank: true,
                                                        name: 'COP',
                                                        id: 'intCOPOdontograma'
                                                    },
                                                    {
                                                        xtype: 'displayfield',
                                                        id: 'sysceo',
                                                        value: 'ceo: '
                                                    },
                                                    {
                                                        xtype: 'numberfield',
                                                        width: 100,
                                                        decimalPrecision: 0,
                                                        readOnly: true,
                                                        allowBlank: true,
                                                        name: 'ceo',
                                                        id: 'intCEOOdontograma'
                                                    },
                                                    {
                                                        xtype: 'displayfield',
                                                        id: 'syscopceo',
                                                        value: 'COP/ceo: '
                                                    },
                                                    {
                                                        xtype: 'numberfield',
                                                        width: 100,
                                                        decimalPrecision: 2,
                                                        readOnly: true,
                                                        allowBlank: true,
                                                        name: 'COP/ceo',
                                                        id: 'intCOPCEOOdontograma'
                                                    }
                                                ]
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Actividades Realizadas',
                                autoHeight: true,
                                autoScroll: true,
                                width: 1005,
                                frame: true,
                                border: false,
                                id: 'fichaActividades',
                                items: [
                                    {
                                        xtype: 'grid',
                                        layout: 'fit',
                                        id: 'gridDientesActividadesRealizadas',
                                        store: stGridDienteActividadesRealizadas,
                                        anchor: "100%",
                                        height: 470,
                                        border: false,
                                        frame: true,
                                        loadMask: true,
                                        colModel: new Ext.ux.grid.LockingColumnModel([
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Id',
                                                sortable: false,
                                                width: 1,
                                                hidden: true,
                                                hideable: false,
                                                dataIndex: 'IdConsecutivoDientesActividad',
                                                id: 'IdConsecutivoDientesActividad'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Fecha',
                                                sortable: true,
                                                width: 110,
                                                dataIndex: 'FechaAtencion',
                                                id: 'FechaAtencion'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Profesional',
                                                sortable: true,
                                                width: 170,
                                                dataIndex: 'Profesional',
                                                id: 'Profesional'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Diente',
                                                sortable: true,
                                                width: 60,
                                                dataIndex: 'Diente',
                                                id: 'Diente'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Superficie',
                                                sortable: true,
                                                width: 60,
                                                dataIndex: 'Superficie',
                                                id: 'Superficie'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Procedimiento/Actividad',
                                                sortable: true,
                                                width: 170,
                                                dataIndex: 'DesProced',
                                                renderer: DescripcionGrid,
                                                id: 'DesProced'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Notas Evolución',
                                                sortable: false,
                                                width: 270,
                                                dataIndex: 'NotasEvolucion',
                                                renderer: DescripcionGrid,
                                                id: 'NotasEvolucion'
                                            }
                                        ]),
                                        selModel: new Ext.grid.RowSelectionModel({singleSelect:false}),
                                        iconCls:'icon-grid',
                                        //view: new Ext.grid.GroupingView(),
                                        tbar:
                                        {
                                            xtype: 'toolbar',
                                            items: [
                                                {
                                                    xtype: 'button',
                                                    text: 'Adicionar Registro',
                                                    iconCls: 'btnAddRow',
                                                    id: 'btnAddActividadDiente',
                                                    listeners: {
                                                        click : function() {
                                                            if (Ext.getCmp('sysYaGuardoHC').getValue() == 1){
                                                                var winAddDienteActividadRealizada = new winAddDienteActividadRealizadaUi();
                                                                Ext.getCmp('intPacienteDienteActividad').setValue(Ext.getCmp('sysIdPacienteHC').getValue());
                                                                Ext.getCmp('intCASDienteActividad').setValue(Ext.getCmp('sysCASHC').getValue());
                                                                //Ext.getCmp('intProfesionalDienteActividad').setValue(Ext.getCmp('sysProfesionalHC').getValue());
                                                                Ext.getCmp('intIdProcedDienteActividad').store.load({
                                                                    params: {
                                                                        pServicio: "%ODONTOLO%"
                                                                    }
                                                                });
                                                                winAddDienteActividadRealizada.show();
                                                            }else{
                                                                Ext.Msg.show({
                                                                    title: 'eOfiClinic',
                                                                    msg: 'Usted No ha Guardado la Historia',
                                                                    buttons: Ext.Msg.OK,
                                                                    icon: Ext.Msg.ERROR
                                                                });
                                                            }
                                                        }
                                                    }
                                                },
                                                {
                                                    xtype: 'tbseparator'
                                                },
                                                {
                                                    xtype: 'button',
                                                    text: 'Eliminar Registro',
                                                    iconCls: 'btnDelRow',
                                                    id: 'btnDelActividadDiente',
                                                    listeners: {
                                                        click : function() {
                                                            if(Ext.getCmp('gridDientesActividadesRealizadas').selModel.getCount() == 1)
                                                            {
                                                                var selections = Ext.getCmp('gridDientesActividadesRealizadas').selModel.getSelections();
                                                                if(selections[0].json.CAS == Ext.getCmp('sysCASHC').getValue()){
                                                                    Ext.Msg.show({
                                                                        title: 'Actividades Realizadas en el Diente: ' + selections[0].json.Diente,
                                                                        msg: 'Esta Seguro que Desea Eliminar el Registro ' + selections[0].json.DesProced + '?',
                                                                        buttons: Ext.Msg.YESNO,
                                                                        icon: Ext.Msg.QUESTION,
                                                                        fn: function(btn)
                                                                        {
                                                                            if(btn=="yes")
                                                                            {
                                                                                fnEliminarRegistros("../../controlador/asistencial/controlador_odontologia.php",{task: "ELIMINAR_DIENTE_ACTIVIDAD", pIdRegistroActividadDiente: selections[0].json.IdConsecutivoDientesActividad}, 'gridDientesActividadesRealizadas');
                                                                            }
                                                                        }
                                                                    });
                                                                }else{
                                                                    Ext.MessageBox.show({
                                                                        title: 'Error',
                                                                        msg: 'Este Registro No Fue Creado por Usted y No Se Puede Eliminar',
                                                                        buttons: Ext.MessageBox.OK,
                                                                        icon: Ext.MessageBox.ERROR
                                                                    });
                                                                }
                                                            }else{
                                                                Ext.MessageBox.show({
                                                                    title: 'Error',
                                                                    msg: 'No podemos eliminar los registros en estos momentos, verifique que solo haya seleccionado un registro',
                                                                    buttons: Ext.MessageBox.OK,
                                                                    icon: Ext.MessageBox.ERROR
                                                                });
                                                            }
                                                        }
                                                    }
                                                },
                                                {
                                                    xtype: 'tbseparator'
                                                }
                                            ]
                                        }
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Actividades Proxima Cita',
                                autoHeight: true,
                                autoScroll: true,
                                width: 1005,
                                frame: true,
                                border: false,
                                id: 'fichaActividadesProximaCita',
                                items: [
                                    {
                                        xtype: 'panel',
                                        border: false, 
                                        autoHeight: true,
                                        layout: {
                                            columns: 2,
                                            type: 'table'
                                        },
                                        items:[
                                            {
                                                xtype: 'panel',
                                                title: 'Atenciones',
                                                //autoHeight: true,
                                                autoScroll: true,
                                                width: 250,
                                                height: 460,
                                                frame: true,
                                                border: false,
                                                items: [
                                                    {
                                                        xtype: 'grid',
                                                        layout: 'fit',
                                                        id: 'gridAtencionesProximaCitaxPaciente',
                                                        store: stGridOdontogramasxPaciente,
                                                        anchor: "100%",
                                                        height: 405,
                                                        border: false,
                                                        frame: true,
                                                        loadMask: true,
                                                        colModel: new Ext.ux.grid.LockingColumnModel([
                                                            {
                                                                xtype: 'gridcolumn',
                                                                header: 'Id',
                                                                sortable: false,
                                                                width: 100,
                                                                hidden: true,
                                                                hideable: false,
                                                                dataIndex: 'CAS',
                                                                id: 'CASProxCita'
                                                            },
                                                            {
                                                                xtype: 'gridcolumn',
                                                                header: 'Fecha',
                                                                sortable: true,
                                                                width: 205,
                                                                dataIndex: 'FecReporte',
                                                                renderer: VerInfoOdontograma,
                                                                id: 'FecReporteProxCita'
                                                            }
                                                        ]),
                                                        selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                                                        listeners:{
                                                            rowclick : function(grid, fila, e){
                                                                alert("Ver Items Proxima Cita");
                                                            }
                                                        }
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                layout: 'form',
                                                width: 700,
                                                height: 460,
                                                items: [
                                                    {
                                                        xtype: 'grid',
                                                        layout: 'fit',
                                                        id: 'gridDientesActividadesProximaCita',
                                                        store: stGridDienteActividadesProxCita,
                                                        anchor: "100%",
                                                        height: 460,
                                                        border: false,
                                                        frame: true,
                                                        loadMask: true,
                                                        colModel: new Ext.ux.grid.LockingColumnModel([
                                                            {
                                                                xtype: 'gridcolumn',
                                                                header: 'Id',
                                                                sortable: false,
                                                                width: 1,
                                                                hidden: true,
                                                                hideable: false,
                                                                dataIndex: 'IdConsecutivoDientesProxCita',
                                                                id: 'IdConsecutivoDientesProxCita'
                                                            },
                                                            {
                                                                xtype: 'gridcolumn',
                                                                header: 'Diente',
                                                                sortable: true,
                                                                width: 60,
                                                                dataIndex: 'Diente',
                                                                id: 'DienteProxCita'
                                                            },
                                                            {
                                                                xtype: 'gridcolumn',
                                                                header: 'Superficie',
                                                                sortable: true,
                                                                width: 60,
                                                                dataIndex: 'Superficie',
                                                                id: 'SuperficieProxCita'
                                                            },
                                                            {
                                                                xtype: 'gridcolumn',
                                                                header: 'Procedimiento/Actividad',
                                                                sortable: true,
                                                                width: 270,
                                                                dataIndex: 'DesProced',
                                                                renderer: DescripcionGrid,
                                                                id: 'DesProcedProxCita'
                                                            },
                                                            {
                                                                xtype: 'gridcolumn',
                                                                header: 'Copago',
                                                                sortable: false,
                                                                width: 120,
                                                                dataIndex: 'VlrCopago',
                                                                id: 'VlrCopagoProxCita'
                                                            }
                                                        ]),
                                                        selModel: new Ext.grid.RowSelectionModel({singleSelect:false}),
                                                        iconCls:'icon-grid',
                                                        //view: new Ext.grid.GroupingView(),
                                                        tbar:
                                                        {
                                                            xtype: 'toolbar',
                                                            items: [
                                                                {
                                                                    xtype: 'button',
                                                                    text: 'Adicionar Registro',
                                                                    iconCls: 'btnAddRow',
                                                                    id: 'btnAddProxCitaDiente',
                                                                    listeners: {
                                                                        click : function() {
                                                                            if (Ext.getCmp('sysYaGuardoHC').getValue() == 1){
                                                                                var winAddDienteActividadRealizada = new winAddDienteActividadRealizadaUi();
                                                                                Ext.getCmp('intPacienteDienteActividad').setValue(Ext.getCmp('sysIdPacienteHC').getValue());
                                                                                Ext.getCmp('intCASDienteActividad').setValue(Ext.getCmp('sysCASHC').getValue());
                                                                                //Ext.getCmp('intProfesionalDienteActividad').setValue(Ext.getCmp('sysProfesionalHC').getValue());
                                                                                Ext.getCmp('intIdProcedDienteActividad').store.load({
                                                                                    params: {
                                                                                        pServicio: "%ODONTOLO%"
                                                                                    }
                                                                                });
                                                                                winAddDienteActividadRealizada.show();
                                                                            }else{
                                                                                Ext.Msg.show({
                                                                                    title: 'eOfiClinic',
                                                                                    msg: 'Usted No ha Guardado la Historia',
                                                                                    buttons: Ext.Msg.OK,
                                                                                    icon: Ext.Msg.ERROR
                                                                                });
                                                                            }
                                                                        }
                                                                    }
                                                                },
                                                                {
                                                                    xtype: 'tbseparator'
                                                                },
                                                                {
                                                                    xtype: 'button',
                                                                    text: 'Eliminar Registro',
                                                                    iconCls: 'btnDelRow',
                                                                    id: 'btnDelProxCitaDiente',
                                                                    listeners: {
                                                                        click : function() {
                                                                            if(Ext.getCmp('gridDientesActividadesRealizadas').selModel.getCount() == 1)
                                                                            {
                                                                                var selections = Ext.getCmp('gridDientesActividadesRealizadas').selModel.getSelections();
                                                                                if(selections[0].json.CAS == Ext.getCmp('sysCASHC').getValue()){
                                                                                    Ext.Msg.show({
                                                                                        title: 'Actividades Realizadas en el Diente: ' + selections[0].json.Diente,
                                                                                        msg: 'Esta Seguro que Desea Eliminar el Registro ' + selections[0].json.DesProced + '?',
                                                                                        buttons: Ext.Msg.YESNO,
                                                                                        icon: Ext.Msg.QUESTION,
                                                                                        fn: function(btn)
                                                                                        {
                                                                                            if(btn=="yes")
                                                                                            {
                                                                                                fnEliminarRegistros("../../controlador/asistencial/controlador_odontologia.php",{task: "ELIMINAR_DIENTE_ACTIVIDAD", pIdRegistroActividadDiente: selections[0].json.IdConsecutivoDientesActividad}, 'gridDientesActividadesRealizadas');
                                                                                            }
                                                                                        }
                                                                                    });
                                                                                }else{
                                                                                    Ext.MessageBox.show({
                                                                                        title: 'Error',
                                                                                        msg: 'Este Registro No Fue Creado por Usted y No Se Puede Eliminar',
                                                                                        buttons: Ext.MessageBox.OK,
                                                                                        icon: Ext.MessageBox.ERROR
                                                                                    });
                                                                                }
                                                                            }else{
                                                                                Ext.MessageBox.show({
                                                                                    title: 'Error',
                                                                                    msg: 'No podemos eliminar los registros en estos momentos, verifique que solo haya seleccionado un registro',
                                                                                    buttons: Ext.MessageBox.OK,
                                                                                    icon: Ext.MessageBox.ERROR
                                                                                });
                                                                            }
                                                                        }
                                                                    }
                                                                },
                                                                {
                                                                    xtype: 'tbseparator'
                                                                }
                                                            ]
                                                        }
                                                    }
                                                ]
                                            }
                                        ]
                                    }
                                ]
                            }
                        ]
                    }
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Salir',
                            iconCls: 'btnSalir',
                            id: 'btnSalirEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 1) 
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.getCmp('winHCOdontologia001').close();
                                                }
                                            }
                                        });
                                    else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Usted No ha Guardado la Evolución del Paciente y Se Perdera la Información, Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.getCmp('winHCOdontologia001').close();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                },
                tbar:{
                    items: [
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Ver Historia Clínica',
                            iconCls: 'btnVerHC',
                            id: 'btnVerHC',
                            listeners:{
                                click : function(){
                                    var cmpResumenHC = new winFrmVerHistorialHC({
                                        renderTo: Ext.getBody()
                                    });
                                    Ext.getCmp('winViewEvolucionHC').title = "PACIENTE: " + Ext.getCmp('sysPacienteHC').getValue();
                                    Ext.getCmp('gridHistorialEvoluciones').store.load({
                                        params: {
                                            pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                                            pPaciente: Ext.getCmp('sysIdPacienteHC').getValue()
                                        }
                                    });
                                    cmpResumenHC.show();
                                }
                            }
                        },
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar Evolución',
                            iconCls: 'btnGuardar',
                            id: 'btnGuardarEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 0) 
                                    {
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Guardar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnGuardarRegistrosMedicinaGeneral();
                                                }
                                            }
                                        });
                                    }else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Modificar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnModificarRegistrosMedicinaGeneral();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                }
            }
        ];
        winHCOdontologia001Ui.superclass.initComponent.call(this);
    }
});

function fnGuardarRegistrosMedicinaGeneral(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc.php',
            params:{
                task: 'guardar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pidPlantillaHC : Ext.getCmp('sysIdCodPlantillaHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1); 
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function fnModificarRegistrosMedicinaGeneral(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc.php',
            params:{
                task: 'modificar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1);
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}
