/**
 * autoNumeric.js
 * @author: Bob Knothe
 * @author: Sokolov Yura
 * @version: 1.9.43 - 2015-12-19 GMT 4:00 PM / 16:00
 *
 * Created by Robert J. Knothe on 2010-10-25. Please report any bugs to https://github.com/BobKnothe/autoNumeric
 * Contributor by Sokolov Yura on 2010-11-07
 *
 * Copyright (c) 2011 Robert J. Knothe http://www.decorplanit.com/plugin/
 *
 * The MIT License (http://www.opensource.org/licenses/mit-license.php)
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following
 * conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 */
!function(e){"function"==typeof define&&define.amd?define(["jquery"],e):"object"==typeof module&&module.exports?module.exports=e(require("jquery")):e(window.jQuery)}(function(e){"use strict";function t(e){var t={};if(void 0===e.selectionStart){e.focus();var a=document.selection.createRange();t.length=a.text.length,a.moveStart("character",-e.value.length),t.end=a.text.length,t.start=t.end-t.length}else t.start=e.selectionStart,t.end=e.selectionEnd,t.length=t.end-t.start;return t}function a(e,t,a){if(void 0===e.selectionStart){e.focus();var i=e.createTextRange();i.collapse(!0),i.moveEnd("character",a),i.moveStart("character",t),i.select()}else e.selectionStart=t,e.selectionEnd=a}function i(e,t){if(t){var a=new Error(e);throw a}}function n(t,a){e.each(a,function(e,i){"function"==typeof i?a[e]=i(t,a,e):"function"==typeof t.autoNumeric[i]&&(a[e]=t.autoNumeric[i](t,a,e))})}function r(e,t){n(e,t);var a=t.vMax.toString().split("."),i=t.vMin||0===t.vMin?t.vMin.toString().split("."):[];if(t.aNeg=t.vMin<0?"-":"",a[0]=a[0].replace("-",""),i[0]=i[0].replace("-",""),t.mIntPos=Math.max(a[0].length,1),t.mIntNeg=Math.max(i[0].length,1),null===t.mDec){var r=0,s=0;a[1]&&(r=a[1].length),i[1]&&(s=i[1].length),t.mDec=Math.max(r,s),t.oDec=t.mDec}else t.mDec=Number(t.mDec);null===t.altDec&&t.mDec>0&&("."===t.aDec&&","!==t.aSep?t.altDec=",":","===t.aDec&&"."!==t.aSep&&(t.altDec="."));var o=t.aNeg?"([-\\"+t.aNeg+"]?)":"(-?)";t.aNegRegAutoStrip=o,t.skipFirstAutoStrip=new RegExp(o+"[^-"+(t.aNeg?"\\"+t.aNeg:"")+"\\"+t.aDec+"\\d].*?(\\d|\\"+t.aDec+"\\d)"),t.skipLastAutoStrip=new RegExp("(\\d\\"+t.aDec+"?)[^\\"+t.aDec+"\\d]\\D*$");var u="-"+t.aNum+"\\"+t.aDec;return t.allowedAutoStrip=new RegExp("[^"+u+"]","gi"),t.numRegAutoStrip=new RegExp(o+"(?:\\"+t.aDec+"?(\\d+\\"+t.aDec+"\\d+)|(\\d*(?:\\"+t.aDec+"\\d*)?))"),t}function s(e,t){if(""!==t.aSign&&(e=e.replace(t.aSign,"")),t.aSuffix)for(;e.indexOf(t.aSuffix)>-1;)e=e.replace(t.aSuffix,"");e=e.replace(t.skipFirstAutoStrip,"$1$2"),("s"===t.pNeg||"s"===t.pSign&&"p"!==t.pNeg)&&e.indexOf("-")>-1&&""!==e&&(t.trailingNegative=!0),e=e.replace(t.skipLastAutoStrip,"$1"),e=e.replace(t.allowedAutoStrip,""),t.altDec&&(e=e.replace(t.altDec,t.aDec));var a=e.match(t.numRegAutoStrip);if(e=a?[a[1],a[2],a[3]].join(""):"","allow"===t.lZero||"keep"===t.lZero){var i=[],n="";i=e.split(t.aDec),-1!==i[0].indexOf(t.aNeg)&&(n=t.aNeg,i[0]=i[0].replace(t.aNeg,"")),""===n&&i[0].length>t.mIntPos&&"0"===i[0].charAt(0)&&(i[0]=i[0].slice(1)),""!==n&&i[0].length>t.mIntNeg&&"0"===i[0].charAt(0)&&(i[0]=i[0].slice(1)),e=n+i.join(t.aDec)}if(t.onOff&&"deny"===t.lZero||"allow"===t.lZero&&t.onOff===!1){var r="^"+t.aNegRegAutoStrip+"0*(\\d|$)";r=new RegExp(r),e=e.replace(r,"$1$2")}return e}function o(e,t){if("p"===t.pSign&&"l"===t.pNeg||"s"===t.pSign&&"p"===t.pNeg){var a=t.nBracket.split(",");t.onOff?t.onOff&&e.charAt(0)===a[0]&&(e=e.replace(a[0],t.aNeg),e=e.replace(a[1],"")):(e=e.replace(t.aNeg,""),e=a[0]+e+a[1])}return e}function u(e){return e=e.replace(",","."),-1!==e.lastIndexOf("-")&&e.lastIndexOf("-")===e.length-1&&(e=e.replace("-",""),e="-"+e),e}function l(e,t,a){return t&&"."!==t&&(e=e.replace(t,".")),a&&"-"!==a&&(e=e.replace(a,"-")),e.match(/\d/)||(e+="0"),e}function c(e,t,a){return a&&"-"!==a&&(e=e.replace("-",a)),t&&"."!==t&&(e=e.replace(".",t)),e}function g(e,t,a){return""===e||e===t.aNeg?"always"===t.wEmpty||a?"l"===t.pNeg?e+t.aSign+t.aSuffix:t.aSign+e+t.aSuffix:e:null}function h(e,t){e=s(e,t),t.trailingNegative&&-1===e.indexOf("-")&&(e="-"+e);var a=g(e,t,!0),i=e.replace(",",".")<0;if(e.indexOf("-")>-1&&0===Number(e)&&(i=!0),i&&(e=e.replace("-","")),null!==a)return a;var n="";t.dGroup=t.dGroup.toString(),n="2"===t.dGroup?/(\d)((\d)(\d{2}?)+)$/:"2s"===t.dGroup?/(\d)((?:\d{2}){0,2}\d{3}(?:(?:\d{2}){2}\d{3})*?)$/:"4"===t.dGroup?/(\d)((\d{4}?)+)$/:/(\d)((\d{3}?)+)$/;var r=e.split(t.aDec);t.altDec&&1===r.length&&(r=e.split(t.altDec));var u=r[0];if(""!==t.aSep)for(;n.test(u);)u=u.replace(n,"$1"+t.aSep+"$2");return 0!==t.mDec&&r.length>1?(r[1].length>t.mDec&&(r[1]=r[1].substring(0,t.mDec)),e=u+t.aDec+r[1]):e=u,"p"===t.pSign&&(i&&"l"===t.pNeg&&(e=t.aNeg+t.aSign+e),i&&"r"===t.pNeg&&(e=t.aSign+t.aNeg+e),i&&"s"===t.pNeg&&(e=t.aSign+e+t.aNeg),i||t.trailingNegative||(e=t.aSign+e)),"s"===t.pSign&&(i&&"r"===t.pNeg&&(e=e+t.aSign+t.aNeg),i&&"l"===t.pNeg&&(e=e+t.aNeg+t.aSign),i&&"p"===t.pNeg&&(e=t.aNeg+e+t.aSign),i||(e+=t.aSign)),t.rawValue<0&&null!==t.nBracket&&(e=o(e,t)),t.trailingNegative=!1,e+t.aSuffix}function p(e,t){if(e=""===e?"0":e.toString(),"N05"===t.mRound||"U05"===t.mRound||"D05"===t.mRound)return e="N05"===t.mRound?(Math.round(20*e)/20).toString():"U05"===t.mRound?(Math.ceil(20*e)/20).toString():(Math.floor(20*e)/20).toString(),-1===e.indexOf(".")?e+".00":e.length-e.indexOf(".")<3?e+"0":e;var a="",i=0,n="",r="boolean"==typeof t.aPad||null===t.aPad?t.aPad?t.mDec:0:Number(t.aPad),s=function(e){var t=0===r?/(\.(?:\d*[1-9])?)0*$/:1===r?/(\.\d(?:\d*[1-9])?)0*$/:new RegExp("(\\.\\d{"+r+"}(?:\\d*[1-9])?)0*");return e=e.replace(t,"$1"),0===r&&(e=e.replace(/\.$/,"")),e};"-"===e.charAt(0)&&(n="-",e=e.replace("-","")),e.match(/^\d/)||(e="0"+e),"-"===n&&0===Number(e)&&(n=""),(Number(e)>0&&"keep"!==t.lZero||e.length>0&&"allow"===t.lZero)&&(e=e.replace(/^0*(\d)/,"$1"));var o=e.lastIndexOf("."),u=-1===o?e.length-1:o,l=e.length-1-u;if(l<=t.mDec){if(a=e,r>l){-1===o&&(a+=t.aDec);for(var c="000000";r>l;)c=c.substring(0,r-l),a+=c,l+=c.length}else l>r?a=s(a):0===l&&0===r&&(a=a.replace(/\.$/,""));return 0===Number(a)?a:n+a}var g=o+t.mDec,h=Number(e.charAt(g+1)),p=e.substring(0,g+1).split(""),f="."===e.charAt(g)?e.charAt(g-1)%2:e.charAt(g)%2;if(h>4&&"S"===t.mRound||h>4&&"A"===t.mRound&&""===n||h>5&&"A"===t.mRound&&"-"===n||h>5&&"s"===t.mRound||h>5&&"a"===t.mRound&&""===n||h>4&&"a"===t.mRound&&"-"===n||h>5&&"B"===t.mRound||5===h&&"B"===t.mRound&&1===f||h>0&&"C"===t.mRound&&""===n||h>0&&"F"===t.mRound&&"-"===n||h>0&&"U"===t.mRound)for(i=p.length-1;i>=0;i-=1)if("."!==p[i]){if(p[i]=+p[i]+1,p[i]<10)break;i>0&&(p[i]="0")}return p=p.slice(0,g+1),a=s(p.join("")),0===Number(a)?a:n+a}function f(e,t,a){var i=t.aDec,n=t.mDec;if(e="paste"===a?p(e,t):e,i&&n){var r=e.split(i);r[1]&&r[1].length>n&&(n>0?(r[1]=r[1].substring(0,n),e=r.join(i)):e=r[0])}return e}function d(e){var t,a,i,n,r={};if(0===e&&0>1/e&&(e="-0"),"-"===e.charAt(0)?(e=e.slice(1),r.s=-1):r.s=1,t=e.indexOf("."),t>-1&&(e=e.replace(".","")),0>t&&(t=e.length),a=-1===e.search(/[1-9]/i)?e.length:e.search(/[1-9]/i),i=e.length,a===i)r.e=0,r.c=[0];else{for(n=i-1;"0"===e.charAt(n);n-=1)i-=1;for(i-=1,r.e=t-a-1,r.c=[],t=0;i>=a;a+=1)r.c[t]=+e.charAt(a),t+=1}return r}function m(e,t){var a,i=t.c,n=e.c,r=t.s,s=e.s,o=t.e,u=e.e;if(!i[0]||!n[0])return i[0]?r:n[0]?-s:0;if(r!==s)return r;if(a=0>r,o!==u)return o>u^a?1:-1;for(r=-1,o=i.length,u=n.length,s=u>o?o:u,r+=1;s>r;r+=1)if(i[r]!==n[r])return i[r]>n[r]^a?1:-1;return o===u?0:o>u^a?1:-1}function v(e,t){e=e.replace(",",".");var a=d(t.vMin),i=d(t.vMax),n=d(e);return m(a,n)>-1&&m(i,n)<1}function N(t,a){this.settings=a,this.that=t,this.$that=e(t),this.formatted=!1,this.settingsClone=r(this.$that,this.settings),this.value=t.value}function S(t){return"string"==typeof t&&(t=t.replace(/\[/g,"\\[").replace(/\]/g,"\\]"),t="#"+t.replace(/(:|\.)/g,"\\$1")),e(t)}function y(e,t,a){var i=e.data("autoNumeric");i||(i={},e.data("autoNumeric",i));var n=i.holder;return(void 0===n&&t||a)&&(n=new N(e.get(0),t),i.holder=n),n}function x(e){return e.oDec=e.mDec,e.oPad=e.aPad,e.oBracket=e.nBracket,e.oSep=e.aSep,e.oSign=e.aSign,e}function w(e){var t=e+"=",a=document.cookie.split(";"),i=0,n="";for(i;i<a.length;i+=1){for(n=a[i];" "===n.charAt(0);)n=n.substring(1,n.length);if(0===n.indexOf(t))return n.substring(t.length,n.length)}return null}function D(){var e="modernizr";try{return sessionStorage.setItem(e,e),sessionStorage.removeItem(e),!0}catch(t){return!1}}function b(e,t,a){if(t.aStor){var i=""!==e[0].name&&void 0!==e[0].name?"AUTO_"+decodeURIComponent(e[0].name):"AUTO_"+e[0].id;if(D()===!1){if("get"===a)return w(i);if("set"===a&&(document.cookie=i+"="+t.rawValue+"; expires= ; path=/"),"wipe"===a){var n=new Date;n.setTime(n.getTime()+-864e5);var r="; expires="+n.toGMTString();document.cookie=i+'="" ;'+r+"; path=/"}}else{if("get"===a)return sessionStorage.getItem(i);"set"===a&&sessionStorage.setItem(i,t.rawValue),"wipe"===a&&sessionStorage.removeItem(i)}}}N.prototype={init:function(e){this.value=this.that.value,this.settingsClone=r(this.$that,this.settings),this.ctrlKey=e.ctrlKey,this.cmdKey=e.metaKey,this.shiftKey=e.shiftKey,this.selection=t(this.that),("keydown"===e.type||"keyup"===e.type)&&(this.kdCode=e.keyCode),this.which=e.which,this.processed=!1,this.formatted=!1},setSelection:function(e,t,i){e=Math.max(e,0),t=Math.min(t,this.that.value.length),this.selection={start:e,end:t,length:t-e},(void 0===i||i)&&a(this.that,e,t)},setPosition:function(e,t){this.setSelection(e,e,t)},getBeforeAfter:function(){var e=this.value,t=e.substring(0,this.selection.start),a=e.substring(this.selection.end,e.length);return[t,a]},getBeforeAfterStriped:function(){var e=this.settingsClone,t=this.getBeforeAfter();return t[0]=s(t[0],this.settingsClone),t[1]=s(t[1],this.settingsClone),e.trailingNegative&&-1===t[0].indexOf("-")&&(t[0]="-"+t[0],t[1]="-"===t[1]?"":t[1]),e.trailingNegative=!1,t},normalizeParts:function(e,t){var a=this.settingsClone;e=s(e,a),t=s(t,a),a.trailingNegative&&-1===e.indexOf("-")&&(e="-"+e,a.trailingNegative=!1),""!==e&&e!==a.aNeg||"deny"!==a.lZero||t>""&&(t=t.replace(/^0*(\d)/,"$1"));var i=e+t;if(a.aDec){var n=i.match(new RegExp("^"+a.aNegRegAutoStrip+"\\"+a.aDec));n&&(e=e.replace(n[1],n[1]+"0"),i=e+t)}return[e,t]},setValueParts:function(e,t,a){var i=this.settingsClone,n=this.normalizeParts(e,t),r=n.join(""),s=n[0].length;if(v(r,i)){r=f(r,i,a);var o=-1!==r.indexOf(",")?r.replace(",","."):r,u=o;return""===o||o===i.aNeg?i.rawValue="":i.rawValue=u,s>r.length&&(s=r.length),this.value=r,this.setPosition(s,!1),!0}return!1},signPosition:function(){var e=this.settingsClone,t=e.aSign,a=this.that;if(t){var i=t.length;if("p"===e.pSign){var n=e.aNeg&&a.value&&a.value.charAt(0)===e.aNeg;return n?[1,i+1]:[0,i]}var r=a.value.length;return[r-i,r]}return[1e3,-1]},expandSelectionOnSign:function(e){var t=this.signPosition(),a=this.selection;a.start<t[1]&&a.end>t[0]&&((a.start<t[0]||a.end>t[1])&&this.value.substring(Math.max(a.start,t[0]),Math.min(a.end,t[1])).match(/^\s*$/)?a.start<t[0]?this.setSelection(a.start,t[0],e):this.setSelection(t[1],a.end,e):this.setSelection(Math.min(a.start,t[0]),Math.max(a.end,t[1]),e))},checkPaste:function(){if(void 0!==this.valuePartsBeforePaste){var e=this.getBeforeAfter(),t=this.valuePartsBeforePaste;delete this.valuePartsBeforePaste,e[0]=e[0].substr(0,t[0].length)+s(e[0].substr(t[0].length),this.settingsClone),this.setValueParts(e[0],e[1],"paste")||(this.value=t.join(""),this.setPosition(t[0].length,!1))}},skipAllways:function(e){var t=this.kdCode,i=this.which,n=this.ctrlKey,r=this.cmdKey,s=this.shiftKey;if((n||r)&&"keyup"===e.type&&void 0!==this.valuePartsBeforePaste||s&&45===t)return this.checkPaste(),!1;if(t>=112&&123>=t||t>=91&&93>=t||t>=9&&31>=t||8>t&&(0===i||i===t)||144===t||145===t||45===t||224===t)return!0;if((n||r)&&65===t){if(this.settings.sNumber){e.preventDefault();var o=this.that.value.length,u=this.settings.aSign.length,l=-1===this.that.value.indexOf("-")?0:1,c=this.settings.aSuffix.length,g=this.settings.pSign,h=this.settings.pNeg,p="s"===g?0:"l"===h&&1===l&&u>0?u+1:u,f="p"===g?o-c:"l"===h?o-(c+u):"r"===h&&u>0?o-(u+l+c):o-(u+c);a(this.that,p,f)}return!0}if((n||r)&&(67===t||86===t||88===t))return"keydown"===e.type&&this.expandSelectionOnSign(),(86===t||45===t)&&("keydown"===e.type||"keypress"===e.type?void 0===this.valuePartsBeforePaste&&(this.valuePartsBeforePaste=this.getBeforeAfter()):this.checkPaste()),"keydown"===e.type||"keypress"===e.type||67===t;if(n||r)return!0;if(37===t||39===t){var d=this.settingsClone.aSep,m=this.settingsClone.aDec,v=this.selection.start,N=this.that.value;return"keydown"!==e.type||this.shiftKey||(37!==t||N.charAt(v-2)!==d&&N.charAt(v-2)!==m?39!==t||N.charAt(v+1)!==d&&N.charAt(v+1)!==m||this.setPosition(v+1):this.setPosition(v-1)),!0}return t>=34&&40>=t?!0:!1},processTrailing:function(e){var t=this.settingsClone;return"p"===t.pSign&&"s"===t.pNeg&&(8===this.kdCode?(t.caretFix=this.selection.start>=this.value.indexOf(t.aSuffix)&&""!==t.aSuffix?!0:!1,"-"===this.value.charAt(this.selection.start-1)?e[0]=e[0].substring(1):this.selection.start<=this.value.length-t.aSuffix.length&&(e[0]=e[0].substring(0,e[0].length-1))):(t.caretFix=this.selection.start>=this.value.indexOf(t.aSuffix)&&""!==t.aSuffix?!0:!1,this.selection.start>=this.value.indexOf(t.aSign)+t.aSign.length&&(e[1]=e[1].substring(1,e[1].length)),e[0].indexOf("-")>-1&&"-"===this.value.charAt(this.selection.start)&&(e[0]=e[0].substring(1)))),"s"===t.pSign&&"l"===t.pNeg&&(t.caretFix=this.selection.start>=this.value.indexOf(t.aNeg)+t.aNeg.length?!0:!1,8===this.kdCode?this.selection.start===this.value.indexOf(t.aNeg)+t.aNeg.length&&-1!==this.value.indexOf(t.aNeg)?e[0]=e[0].substring(1):"-"!==e[0]&&(this.selection.start<=this.value.indexOf(t.aNeg)||-1===this.value.indexOf(t.aNeg))&&(e[0]=e[0].substring(0,e[0].length-1)):("-"===e[0][0]&&(e[1]=e[1].substring(1)),this.selection.start===this.value.indexOf(t.aNeg)&&-1!==this.value.indexOf(t.aNeg)&&(e[0]=e[0].substring(1)))),"s"===t.pSign&&"r"===t.pNeg&&(t.caretFix=this.selection.start>=this.value.indexOf(t.aNeg)+t.aNeg.length?!0:!1,8===this.kdCode?this.selection.start===this.value.indexOf(t.aNeg)+t.aNeg.length?e[0]=e[0].substring(1):"-"!==e[0]&&this.selection.start<=this.value.indexOf(t.aNeg)-t.aSign.length?e[0]=e[0].substring(0,e[0].length-1):""!==e[0]&&-1===this.value.indexOf(t.aNeg)&&(e[0]=e[0].substring(0,e[0].length-1)):(t.caretFix=this.selection.start>=this.value.indexOf(t.aSign)&&""!==t.aSign?!0:!1,this.selection.start===this.value.indexOf(t.aNeg)&&(e[0]=e[0].substring(1)),e[1]=e[1].substring(1))),e},processAllways:function(){var e=this.settingsClone,t=[];return 8===this.kdCode||46===this.kdCode?(this.selection.length?(this.expandSelectionOnSign(!1),t=this.getBeforeAfterStriped(),this.setValueParts(t[0],t[1])):(t=this.getBeforeAfterStriped(),""===t[0]&&""===t[1]&&(e.throwInput=!1),"p"===e.pSign&&"s"===e.pNeg||"s"===e.pSign&&"p"!==e.pNeg?t=this.processTrailing(t):8===this.kdCode?t[0]=t[0].substring(0,t[0].length-1):t[1]=t[1].substring(1,t[1].length),this.setValueParts(t[0],t[1])),!0):!1},processKeypress:function(){var e=this.settingsClone,t=String.fromCharCode(this.which),a=this.getBeforeAfterStriped(),i=a[0],n=a[1];return e.throwInput=!0,t===e.aDec||e.altDec&&t===e.altDec||("."===t||","===t)&&110===this.kdCode?e.mDec&&e.aDec?e.aNeg&&n.indexOf(e.aNeg)>-1?!0:i.indexOf(e.aDec)>-1?!0:n.indexOf(e.aDec)>0?!0:(0===n.indexOf(e.aDec)&&(n=n.substr(1)),this.setValueParts(i+e.aDec,n,null),!0):!0:"-"===t||"+"===t?e?("p"===e.pSign&&"s"===e.pNeg||"s"===e.pSign&&"p"!==e.pNeg?(""===i&&n.indexOf(e.aNeg)>-1&&(i=e.aNeg,n=n.substring(1,n.length)),i="-"===i.charAt(0)||-1!==i.indexOf(e.aNeg)?i.substring(1,i.length):"-"===t?e.aNeg+i:i):(""===i&&n.indexOf(e.aNeg)>-1&&(i=e.aNeg,n=n.substring(1,n.length)),i=i.charAt(0)===e.aNeg?i.substring(1,i.length):"-"===t?e.aNeg+i:i),this.setValueParts(i,n,null),!0):!0:t>="0"&&"9">=t?(e.aNeg&&""===i&&n.indexOf(e.aNeg)>-1&&(i=e.aNeg,n=n.substring(1,n.length)),e.vMax<=0&&e.vMin<e.vMax&&-1===this.value.indexOf(e.aNeg)&&"0"!==t&&(i=e.aNeg+i),this.setValueParts(i+t,n,null),!0):(e.throwInput=!1,!0)},formatQuick:function(t){var a=this.settingsClone,i=this.getBeforeAfterStriped(),n=this.value,r=t.keyCode;if((""===a.aSep||""!==a.aSep&&-1===n.indexOf(a.aSep))&&(""===a.aSign||""!==a.aSign&&-1===n.indexOf(a.aSign))){var s=[],o="";s=n.split(a.aDec),s[0].indexOf("-")>-1&&(o="-",s[0]=s[0].replace("-",""),i[0]=i[0].replace("-","")),""===o&&s[0].length>a.mIntPos&&"0"===i[0].charAt(0)&&(i[0]=i[0].slice(1)),"-"===o&&s[0].length>a.mIntNeg&&"0"===i[0].charAt(0)&&(i[0]=i[0].slice(1)),i[0]=o+i[0]}var u=h(this.value,this.settingsClone),l=u.length;if(u){var c=i[0].split(""),g=0;if(("s"===a.pNeg||"s"===a.pSign&&"p"!==a.pNeg)&&"-"===c[0]&&""!==a.aNeg&&(c.shift(),"s"!==a.pSign||"l"!==a.pNeg||8!==r&&8!==this.kdCode&&46!==r&&46!==this.kdCode||!a.caretFix||(c.push("-"),a.caretFix="keydown"===t.type?!0:!1),"p"!==a.pSign||"s"!==a.pNeg||8!==r&&8!==this.kdCode&&46!==r&&46!==this.kdCode||!a.caretFix||(c.push("-"),a.caretFix="keydown"===t.type?!0:!1),"s"===a.pSign&&"r"===a.pNeg&&(8===r||8===this.kdCode||46===r||46===this.kdCode)&&a.caretFix)){var p=a.aSign.split(""),f=["\\","^","$",".","|","?","*","+","(",")","["],d=[],m="";e.each(p,function(t,a){a=p[t],-1!==e.inArray(a,f)?d.push("\\"+a):d.push(a)}),(8===r||8===this.kdCode)&&d.push("-"),m=d.join(""),c.push(m),a.caretFix="keydown"===t.type?!0:!1}for(g;g<c.length;g+=1)c[g].match("\\d")||(c[g]="\\"+c[g]);var v=new RegExp("^.*?"+c.join(".*?")),N=u.match(v);N?(l=N[0].length,(0===l&&u.charAt(0)!==a.aNeg||1===l&&u.charAt(0)===a.aNeg)&&a.aSign&&"p"===a.pSign&&(l=this.settingsClone.aSign.length+("-"===u.charAt(0)?1:0))):(a.aSign&&"s"===a.pSign&&(l-=a.aSign.length),a.aSuffix&&(l-=a.aSuffix.length))}this.that.value=u,this.setPosition(l),this.formatted=!0}};var k={init:function(t){return this.each(function(){var n=e(this),r=n.data("autoNumeric"),u=n.data(),f=n.is("input[type=text], input[type=hidden], input[type=tel], input:not([type])");if(e.each(u,function(e,t){"number"==typeof t&&(u[e]=t.toString())}),"object"==typeof r)return this;r=e.extend({},e.fn.autoNumeric.defaults,u,t,{aNum:"0123456789",onOff:!1,runOnce:!1,rawValue:"",trailingNegative:!1,caretFix:!1,throwInput:!0,tagList:["b","caption","cite","code","dd","del","div","dfn","dt","em","h1","h2","h3","h4","h5","h6","ins","kdb","label","li","option","output","p","q","s","sample","span","strong","td","th","u","var"]}),r.aDec===r.aSep&&i('autoNumeric will not function properly when the decimal character aDec: "'+r.aDec+'" and thousand separator aSep: "'+r.aSep+'" are the same character',r.debug),e.each(r,function(e,t){("true"===t||"false"===t)&&(r[e]="true"===t?!0:!1)}),n.data("autoNumeric",r),r=x(r);var d=y(n,r);if(f||"input"!==n.prop("tagName").toLowerCase()||i('The input type "'+n.prop("type")+'" is not supported by autoNumeric()',r.debug),-1===e.inArray(n.prop("tagName").toLowerCase(),r.tagList)&&"input"!==n.prop("tagName").toLowerCase()&&i('The "<'+n.prop("tagName").toLowerCase()+'>" is not supported by autoNumeric()',r.debug),r.aDec===r.aSep&&i('autoNumeric will not function properly when the decimal character aDec: "'+r.aDec+'" and thousand separator aSep: "'+r.aSep+'" are the same character',r.debug),r.eDec<r.mDec&&null!==r.eDec&&i('autoNumeric will not function properly when the extended decimal places "eDec: '+r.eDec+'" is greater than mDec: "'+r.mDec+'" value',r.debug),r.runOnce===!1&&r.aForm){var m=!0;if(f){if(null!==r.anDefault&&r.anDefault.toString()!==n.val()||null===r.anDefault&&""!==n.val()&&n.val()!==n.attr("value")||""!==n.val()&&"hidden"===n.attr("type")&&!e.isNumeric(n.val().replace(",","."))){if(null!==r.eDec&&r.aStor&&(r.rawValue=b(n,r,"get")),!r.aStor){var N="";null!==r.nBracket&&""!==r.aNeg?(r.onOff=!0,N=o(n.val(),r)):N=n.val(),r.rawValue=("s"===r.pNeg||"s"===r.pSign&&"p"!==r.pNeg)&&""!==r.aNeg&&n.val().indexOf("-")>-1?"-"+s(N,r):s(N,r)}m=!1}""===n.val()&&"focus"===r.wEmpty&&(m=!1),""===n.val()&&"always"===r.wEmpty&&(n.val(r.aSign),m=!1),m&&""!==n.val()&&n.val()===n.attr("value")&&n.autoNumeric("set",n.val())}-1!==e.inArray(n.prop("tagName").toLowerCase(),r.tagList)&&""!==n.text()&&(null!==r.anDefault?r.anDefault===n.text()&&n.autoNumeric("set",n.text()):n.autoNumeric("set",n.text()))}r.runOnce=!0,f&&(n.on("focusin.autoNumeric",function(){d=y(n);var e=d.settingsClone;e.onOff=!0,null!==e.nBracket&&""!==e.aNeg&&n.val(o(n.val(),e)),e.nSep===!0&&(e.aSep="",e.aSign=""),null!==e.eDec?(e.mDec=e.eDec,n.autoNumeric("set",e.rawValue)):n.autoNumeric("set",e.rawValue),d.inVal=n.val(),d.lastVal=n.val();var t=g(d.inVal,e,!0);null!==t&&""!==t&&"focus"===e.wEmpty&&n.val(t)}),n.on("keydown.autoNumeric",function(e){return d=y(n),d.that.readOnly?(d.processed=!0,!0):(d.init(e),d.skipAllways(e)?(d.processed=!0,!0):d.processAllways()?(d.processed=!0,d.formatQuick(e),n.val()!==d.lastVal&&d.settingsClone.throwInput&&n.trigger("input"),d.lastVal=n.val(),d.settingsClone.throwInput=!0,e.preventDefault(),!1):(d.formatted=!1,!0))}),n.on("keypress.autoNumeric",function(e){if(!e.shiftKey||45!==e.keyCode){d=y(n);var t=d.processed;return d.init(e),d.skipAllways(e)?!0:t?(e.preventDefault(),!1):d.processAllways()||d.processKeypress()?(d.formatQuick(e),n.val()!==d.lastVal&&d.settingsClone.throwInput&&n.trigger("input"),d.lastVal=n.val(),d.settingsClone.throwInput=!0,void e.preventDefault()):void(d.formatted=!1)}}),n.on("keyup.autoNumeric",function(e){d=y(n),d.init(e);var t=d.skipAllways(e);return d.kdCode=0,delete d.valuePartsBeforePaste,n[0].value===d.settingsClone.aSign&&("s"===d.settingsClone.pSign?a(this,0,0):a(this,d.settingsClone.aSign.length,d.settingsClone.aSign.length)),n[0].value===d.settingsClone.aSuffix&&a(this,0,0),""===d.settingsClone.rawValue&&""!==d.settingsClone.aSign&&""!==d.settingsClone.aSuffix&&a(this,0,0),null!==d.settingsClone.eDec&&d.settingsClone.aStor&&b(n,r,"set"),t?!0:""===this.value?!0:void(d.formatted||d.formatQuick(e))}),n.on("focusout.autoNumeric",function(){d=y(n);var e=n.val(),t=e,a=d.settingsClone;a.onOff=!1,a.aStor&&b(n,a,"set"),a.nSep===!0&&(a.aSep=a.oSep,a.aSign=a.oSign),null!==a.eDec&&(a.mDec=a.oDec,a.aPad=a.oPad,a.nBracket=a.oBracket),""!==e?(e=s(e,a),a.trailingNegative&&(e="-"+e,a.trailingNegative=!1),null===g(e,a)&&v(e,a,n[0])?(e=l(e,a.aDec,a.aNeg),a.rawValue=e,e=p(e,a),e=c(e,a.aDec,a.aNeg)):(e="",a.rawValue="")):a.rawValue="";var i=g(e,a,!1);null===i&&(i=h(e,a)),i!==t&&n.val(i),i!==d.inVal&&(n.change(),delete d.inVal)}),n.on("paste.autoNumeric",function(e){d=y(n);var t=e.clipboardData||e.originalEvent.clipboardData||window.clipboardData,a=t.getData("text");a!==d.lastVal&&(n.trigger("input"),d.lastVal=window.setTimeout(function(){n.val()},100))}),n.closest("form").on("submit.autoNumeric",function(){d=y(n);var e=d.settingsClone;e.unSetOnSubmit&&n.val(e.rawValue)}))})},destroy:function(){return e(this).each(function(){var t=S(e(this)),a=t.data("autoNumeric");"object"==typeof a&&(t.val(""),b(t,a,"wipe"),t.off(".autoNumeric"),t.removeData("autoNumeric"))})},wipe:function(){return e(this).each(function(){var t=S(e(this)),a=t.data("autoNumeric");"object"==typeof a&&(t.val(""),a.rawValue="",b(t,a,"wipe"))})},update:function(t){return e(this).each(function(){var a=S(e(this)),n=a.data("autoNumeric");"object"!=typeof n&&i('Initializing autoNumeric is required prior to calling the "update" method',!0);var r=a.autoNumeric("get");return n=e.extend(n,t),n=x(n),y(a,n,!0),n.aDec===n.aSep&&i('autoNumeric will not function properly when the decimal character aDec: "'+n.aDec+'" and thousand separator aSep: "'+n.aSep+'" are the same character',n.debug),a.data("autoNumeric",n),""!==a.val()||""!==a.text()?a.autoNumeric("set",r):void 0})},set:function(t){return e(this).each(function(){if(null!==t){var a=S(e(this)),n=a.data("autoNumeric"),r=t.toString(),s=a.is("input[type=text], input[type=hidden], input[type=tel], input:not([type])");return"object"!=typeof n&&i('Initializing autoNumeric is required prior to calling the "set" method',!0),r=u(r),e.isNumeric(Number(r))||i('The value "'+r+'" being "set" is not numeric and has caused a error to be thrown',n.debug),""===r?"":v(r,n)?(s&&null!==n.eDec&&(n.rawValue=r),(s||-1!==e.inArray(a.prop("tagName").toLowerCase(),n.tagList))&&(r=p(r,n),null===n.eDec&&(n.rawValue=r),r=c(r,n.aDec,n.aNeg),r=h(r,n)),n.aStor&&null!==n.eDec&&b(a,n,"set"),s?a.val(r):-1!==e.inArray(a.prop("tagName").toLowerCase(),n.tagList)?a.text(r):!1):(n.rawValue="",b(a,n,"wipe"),r="",i('The value being set falls outside the min: "'+n.vMin+' max: "'+n.vMax+'" ) settings for this element',n.debug),"")}})},unSet:function(t){return e(this).each(function(){var a=S(e(this)),i=a.data("autoNumeric");"object"==typeof i&&(i.onOff=!0,a.val(a.autoNumeric("get",t)))})},reSet:function(){return e(this).each(function(){var t=S(e(this)),a=t.data("autoNumeric");"object"==typeof a&&t.autoNumeric("set",t.val())})},get:function(t){var a=S(e(this)),n=a.data("autoNumeric"),r=a.is("input[type=text], input[type=hidden], input[type=tel], input:not([type])");"object"!=typeof n&&i('Initializing autoNumeric is required prior to calling the "get" method',!0);var s="";return r?s=a.eq(0).val():-1!==e.inArray(a.prop("tagName").toLowerCase(),n.tagList)?s=a.eq(0).text():i('The "<'+a.prop("tagName").toLowerCase()+'>" is not supported by autoNumeric()',n.debug),""!==n.rawValue&&(s=n.rawValue),!(!1).test(s)&&0!==Number(s)||"focus"!==n.wEmpty?(""!==s&&null!==n.nBracket&&(n.onOff=!0,s=o(s,n)),s=l(s,n.aDec,n.aNeg),0===Number(s)&&"keep"!==n.lZero&&(s="0"),","===t&&(s=s.replace(".",",")),".-"===t&&s.indexOf("-")>-1&&(s=s.replace("-","")+"-"),",-"===t&&s.indexOf("-")>-1&&(s=s.replace(".",",").replace("-","")+"-"),s):""},getString:function(t){var a=S(e(this)),i=a.serialize(),n=i.split("&"),r=e("form").index(a),s=e("form:eq("+r+")"),o=[],u=[],l=/^(?:submit|button|image|reset|file)$/i,c=/^(?:input|select|textarea|keygen)/i,g=/^(?:checkbox|radio)$/i,h=/^(?:button|checkbox|color|date|datetime|datetime-local|email|file|image|month|number|password|radio|range|reset|search|submit|time|url|week)/i,p=0;return e.each(s[0],function(e,t){""===t.name||!c.test(t.localName)||l.test(t.type)||t.disabled||!t.checked&&g.test(t.type)?u.push(-1):(u.push(p),p+=1)}),p=0,e.each(s[0],function(e,t){"input"!==t.localName||""!==t.type&&"text"!==t.type&&"hidden"!==t.type&&"tel"!==t.type?(o.push(-1),"input"===t.localName&&h.test(t.type)&&(p+=1)):(o.push(p),p+=1)}),e.each(n,function(a,i){i=n[a].split("=");var s=e.inArray(a,u);if(s>-1&&o[s]>-1){var l=e("form:eq("+r+") input:eq("+o[s]+")"),c=l.data("autoNumeric");"object"==typeof c&&null!==i[1]&&(i[1]=e("form:eq("+r+") input:eq("+o[s]+")").autoNumeric("get",t).toString(),n[a]=i.join("="))}}),n.join("&")},getArray:function(t){var a=S(e(this)),i=a.serializeArray(),n=e("form").index(a),r=e("form:eq("+n+")"),s=[],o=[],u=/^(?:submit|button|image|reset|file)$/i,l=/^(?:input|select|textarea|keygen)/i,c=/^(?:checkbox|radio)$/i,g=/^(?:button|checkbox|color|date|datetime|datetime-local|email|file|image|month|number|password|radio|range|reset|search|submit|time|url|week)/i,h=0;return e.each(r[0],function(e,t){""===t.name||!l.test(t.localName)||u.test(t.type)||t.disabled||!t.checked&&c.test(t.type)?o.push(-1):(o.push(h),h+=1)}),h=0,e.each(r[0],function(e,t){"input"!==t.localName||""!==t.type&&"text"!==t.type&&"hidden"!==t.type&&"tel"!==t.type?(s.push(-1),"input"===t.localName&&g.test(t.type)&&(h+=1)):(s.push(h),h+=1)}),e.each(i,function(a,i){var r=e.inArray(a,o);if(r>-1&&s[r]>-1){var u=e("form:eq("+n+") input:eq("+s[r]+")"),l=u.data("autoNumeric");"object"==typeof l&&(i.value=e("form:eq("+n+") input:eq("+s[r]+")").autoNumeric("get",t).toString())}}),i},getSettings:function(){var t=S(e(this));return t.eq(0).data("autoNumeric")}};e.fn.autoNumeric=function(e){return k[e]?k[e].apply(this,Array.prototype.slice.call(arguments,1)):"object"!=typeof e&&e?void i('Method "'+e+'" is not supported by autoNumeric()',!0):k.init.apply(this,arguments)},e.fn.autoNumeric.defaults={aSep:",",nSep:!1,dGroup:"3",aDec:".",altDec:null,aSign:"",pSign:"p",pNeg:"l",aSuffix:"",vMax:"9999999999999.99",vMin:"-9999999999999.99",mDec:null,eDec:null,aStor:!1,mRound:"S",aPad:!0,nBracket:null,wEmpty:"focus",lZero:"allow",aForm:!0,sNumber:!1,anDefault:null,unSetOnSubmit:!1,debug:!0}});